/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.ui;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import multivalent.Behavior;
import multivalent.Document;
import multivalent.ESISNode;
import multivalent.INode;
import multivalent.Layer;
import multivalent.Multivalent;
import multivalent.Node;
import multivalent.SemanticEvent;
import multivalent.gui.VMenuButton;
import multivalent.gui.VRadiobox;
import multivalent.gui.VRadiogroup;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Zoom
extends Behavior {
    public static final String MSG_GET = "zoom:get";
    public static final String MSG_SET = "zoom:set";
    public static final String ARG_BIGGER = "Bigger";
    public static final String ARG_SMALLER = "Smaller";
    public static final String ARG_FIT_WIDTH = "Fit_Width";
    public static final String ARG_FIT_PAGE = "Fit_Page";
    public static final String MSG_CREATE_ZOOM = "createWidget/Zoom";
    public static final String ATTR_ZOOMS = "zooms";
    private Matcher FACTOR = Pattern.compile("([0-9.]+)").matcher("");
    private Matcher PERCENTAGE = Pattern.compile("([0-9.]+)\\s*%").matcher("");
    private String[] zooms_ = null;
    private VRadiogroup rg_ = new VRadiogroup();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$multivalent$std$ui$Zoom;

    private float getCurZoom() {
        return this.getBrowser().getCurDocument().getMediaAdaptor().getZoom();
    }

    private float parseZoom(String string, boolean bl) {
        float f = this.getCurZoom();
        float f2 = 0.0f;
        if (string != null) {
            if (this.FACTOR.reset(string).find()) {
                try {
                    f2 = Float.parseFloat(this.FACTOR.group(0)) / 100.0f;
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (this.PERCENTAGE.reset(string).find()) {
                try {
                    f2 = Float.parseFloat(this.PERCENTAGE.group(0));
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (!bl) {
                if (ARG_FIT_WIDTH.equals(string)) {
                    Document document = this.getBrowser().getCurDocument();
                    f2 = f * (float)document.bbox.width / (float)document.childAt((int)0).bbox.width - 0.01f;
                } else if (ARG_FIT_PAGE.equals(string)) {
                    Document document = this.getBrowser().getCurDocument();
                    float f3 = f * (float)document.bbox.width / (float)document.childAt((int)0).bbox.width - 0.01f;
                    float f4 = f * (float)document.bbox.height / (float)document.childAt((int)0).bbox.height - 0.01f;
                    f2 = Math.min(f3, f4);
                } else if (ARG_BIGGER.equals(string) || ARG_SMALLER.equals(string)) {
                    String string2;
                    int n = -1;
                    float f5 = 2.1474836E9f;
                    int n2 = this.zooms_.length;
                    for (int i = 0; i < n2; ++i) {
                        try {
                            float f6 = this.parseZoom(this.zooms_[i], true) - f;
                            if (!(Math.abs(f6) < Math.abs(f5))) continue;
                            n = i;
                            f5 = f6;
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (ARG_BIGGER.equals(string)) {
                        string2 = f5 >= 0.0f && n + 1 < this.zooms_.length ? this.zooms_[n + 1] : (f5 < 0.0f ? this.zooms_[n] : null);
                    } else {
                        if (!$assertionsDisabled && !ARG_SMALLER.equals(string)) {
                            throw new AssertionError();
                        }
                        string2 = f5 <= 0.0f && n > 0 ? this.zooms_[n - 1] : (f5 > 0.0f ? this.zooms_[n] : null);
                    }
                    f2 = this.parseZoom(string2, true);
                }
            }
        }
        return f2;
    }

    @Override
    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        if ("createWidget/View" == string) {
            VMenuButton vMenuButton = (VMenuButton)this.createUI("menubutton", "Zoom", "event createWidget/Zoom", (INode)semanticEvent.getOut(), "View", false);
            vMenuButton.setDynamic("Zoom");
        } else if (MSG_CREATE_ZOOM == string) {
            this.rg_.clear();
            float f = this.getCurZoom();
            INode iNode = (INode)semanticEvent.getOut();
            for (String string2 : this.zooms_) {
                float f2 = this.parseZoom(string2, true);
                Node node = this.createUI(f2 != 0.0f ? "radiobox" : "button", string2, new StringBuffer().append("event zoom:set ").append(string2).toString(), iNode, "Zoom", false);
                if (f2 == 0.0f) continue;
                VRadiobox vRadiobox = (VRadiobox)node;
                vRadiobox.setRadiogroup(this.rg_);
                if (this.rg_.getActive() != null || !(Math.abs(f2 - f) < 0.02f)) continue;
                this.rg_.setActive(vRadiobox);
            }
        }
        return false;
    }

    @Override
    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        if (MSG_GET == string) {
            semanticEvent.setArg(Float.valueOf(this.getCurZoom()));
        } else if (MSG_SET == string) {
            float f;
            float f2 = f = this.getCurZoom();
            Document document = this.getBrowser().getCurDocument();
            Object object = semanticEvent.getArg();
            if (object instanceof String) {
                f2 = this.parseZoom((String)object, false);
            } else if (object instanceof Number) {
                f2 = ((Number)object).floatValue();
            }
            if (f2 != f) {
                document.getMediaAdaptor().setZoom(f2);
                if (this.getCurZoom() != f) {
                    String string2 = document.getAttr("genre");
                    if (string2 != null) {
                        Multivalent.getInstance().putPreference(new StringBuffer().append(string2).append("-zoom").toString(), Float.toString(f2));
                    }
                    this.getBrowser().eventq(document.getAttr("page") == null ? "reloadDocument" : "reloadDocumentPage", null);
                }
            }
        }
        return super.semanticEventAfter(semanticEvent, string);
    }

    @Override
    public void restore(ESISNode eSISNode, Map<String, Object> map, Layer layer) {
        super.restore(eSISNode, map, layer);
        this.zooms_ = this.getAttr(ATTR_ZOOMS, "Bigger,Smaller,50%,75%,90%,100%,110%,125%,150%,175%,200%,400%,Fit_Width,Fit_Page").split("\\s*,\\s*");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$multivalent$std$ui$Zoom == null ? (class$multivalent$std$ui$Zoom = Zoom.class$("multivalent.std.ui.Zoom")) : class$multivalent$std$ui$Zoom).desiredAssertionStatus();
    }
}

