/*
 * Decompiled with CFR 0.152.
 */
package phelps.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import phelps.io.InputStreams;
import phelps.lang.Strings;

public class Files {
    private static final String[] Z = new String[]{".gz", ".Z", ".bzip2", ".bz2"};
    private static final Matcher ZBKUP = Pattern.compile("(?i)(~|\\.bak|\\.bkup|\\.backup)(\\.(gz|Z|z|bzip2|bz2))?$").matcher("");
    private static final Matcher GLOB_REGEX = Pattern.compile("[?*\\[\\]{}]").matcher("");
    public static final Comparator<File> DICTIONARY_CASE_INSENSITIVE_ORDER = new Comparator<File>(){

        @Override
        public int compare(File file, File file2) {
            return Strings.compareDictionary(file.getName(), file2.getName(), true);
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.compare((File)object, (File)object2);
        }
    };
    public static final int BUFSIZ = 8192;

    private Files() {
    }

    public static File getFile(String string) {
        if (string.equals("~") || string.startsWith("~/") || string.startsWith("~\\")) {
            string = System.getProperty("user.home") + string.substring(1);
        }
        return new File(string);
    }

    public static File getCanonicalFile(String string) throws IOException {
        return Files.getFile(string).getCanonicalFile();
    }

    public static File getFuzzyFile(File file, String string) throws IOException {
        File file2;
        block8: {
            File file3;
            block9: {
                file2 = new File(string);
                if (file2.exists()) {
                    return file2.getCanonicalFile();
                }
                if (string.equals("~") || string.startsWith("~/") || string.startsWith("~\\")) {
                    string = System.getProperty("user.home") + string.substring(1);
                    file2 = new File(string);
                }
                if (file != null && !file2.isAbsolute()) {
                    file2 = new File(file, string);
                }
                if (file2.exists() && file2.isDirectory()) {
                    file3 = new File(string + "index.html");
                    if (file3.exists()) {
                        file2 = file3;
                    } else {
                        file3 = new File(string + "index.htm");
                        if (file3.exists()) {
                            file2 = file3;
                        }
                    }
                }
                if (file2.exists()) break block8;
                if (!Files.isCompressed(string)) break block9;
                file3 = new File(string = string.substring(0, string.lastIndexOf(46)));
                if (!file3.exists()) break block8;
                file2 = file3;
                break block8;
            }
            int n = Z.length;
            for (int i = 0; i < n; ++i) {
                file3 = new File(string + Z);
                if (!file3.exists()) continue;
                file2 = file3;
                break;
            }
        }
        return file2.getCanonicalFile();
    }

    public static String relative(File file, File file2) {
        char c = File.separatorChar;
        try {
            file2 = Files.getCanonicalFile(file2.toString());
        }
        catch (IOException iOException) {
            return file2.toString();
        }
        if (file != null) {
            try {
                file = Files.getCanonicalFile(file.toString());
            }
            catch (IOException iOException) {
                file = null;
            }
        }
        String string = file2.toString();
        if (file2.isDirectory()) {
            string = string + c;
        }
        String string2 = string;
        if (file != null) {
            int n;
            String string3 = file.toString();
            if (file.isDirectory()) {
                string3 = string3 + c;
            }
            int n2 = string3.length();
            int n3 = string.length();
            int n4 = Math.min(n2, n3);
            for (n = 0; n < n4 && string3.charAt(n) == string.charAt(n); ++n) {
            }
            --n;
            while (n > 0 && string.charAt(n) != c) {
                --n;
            }
            StringBuffer stringBuffer = new StringBuffer(n3);
            for (int i = ++n; i < n2; ++i) {
                if (string3.charAt(i) != c) continue;
                stringBuffer.append("..").append(c);
            }
            stringBuffer.append(string.substring(n));
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    public static String shortpath(File file, File file2) {
        String string;
        String string2 = Files.relative(file, file2);
        String string3 = System.getProperty("user.home");
        String string4 = file2.toString();
        if (string4.startsWith(string3) && (string = "~" + string4.substring(string3.length())).length() < string2.length()) {
            string2 = string;
        }
        try {
            string = Files.getCanonicalFile(string4).toString();
            if (string.length() < string2.length()) {
                string2 = string;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string2;
    }

    public static String getRoot(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        return n > 0 ? string.substring(0, n) : string;
    }

    public static String getTail(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(47);
        return n != -1 ? string.substring(n + 1) : string;
    }

    public static String getSuffix(File file) {
        if (file == null) {
            return null;
        }
        return Files.getSuffix(file.getName());
    }

    public static String getSuffix(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        int n2 = string.lastIndexOf(47);
        return n > 0 && n > n2 ? string.substring(n + 1) : "";
    }

    public static boolean renameTo(File file, File file2) {
        boolean bl = file.renameTo(file2);
        if (!bl) {
            try {
                Files.copy(file, file2);
                bl = file.delete();
            }
            catch (IOException iOException) {
                file2.delete();
            }
            if (!bl) {
                file2.delete();
            }
        }
        return bl;
    }

    public static boolean isCompressed(String string) {
        return !"identity".equals(Files.getEncoding(string));
    }

    public static String getEncoding(String string) {
        String string2 = "identity";
        if (string != null) {
            String string3 = Files.getSuffix(string);
            if ("Z".equals(string3)) {
                string2 = "compress";
            } else if ("lzw".equals(string3 = string3.toLowerCase())) {
                string2 = "compress";
            } else if ("gz".equals(string3)) {
                string2 = "gzip";
            } else if ("flate".equals(string3)) {
                string2 = "flate";
            } else if ("bz2".equals(string3)) {
                string2 = "bzip2";
            }
        }
        return string2;
    }

    public static boolean isBackup(String string) {
        ZBKUP.reset(string);
        return ZBKUP.find();
    }

    public static File[] glob(String string) throws IOException {
        Object object;
        File[] fileArray = new File[]{};
        if (string == null) {
            return fileArray;
        }
        int n = string.indexOf(47);
        File file = new File(".").getCanonicalFile();
        if (n != -1) {
            object = string.substring(0, n);
            if ("/".equals(object)) {
                file = new File((String)object);
            } else if ("~".equals(object)) {
                file = new File(System.getProperty("user.home"));
            } else {
                n = -1;
            }
        }
        object = new LinkedList();
        object.add(file);
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(string.substring(n + 1));
        ArrayList<Object> arrayList = new ArrayList<Object>(100);
        while (object.size() > 0) {
            Object object2;
            String string2;
            File file2 = (File)object.remove(0);
            String string3 = string2 = (String)linkedList.remove(0);
            String string4 = "";
            n = string3.indexOf(47);
            if (n != -1) {
                string4 = string3.substring(n + 1);
                string3 = string3.substring(0, n);
            }
            boolean bl = "".equals(string4);
            if (string3.length() == 0) {
                arrayList.add(file2);
                continue;
            }
            if (".".equals(string3)) {
                object.add(file2);
                linkedList.add(string4);
                continue;
            }
            if ("..".equals(string3)) {
                object.add(file2.getParentFile());
                linkedList.add(string4);
                continue;
            }
            if ("**".equals(string3)) {
                object.add(file2);
                linkedList.add(string4);
                object2 = file2.listFiles();
                int n2 = ((File[])object2).length;
                for (int i = 0; i < n2; ++i) {
                    File file3 = object2[i];
                    if (!file3.isDirectory()) continue;
                    object.add(file3);
                    linkedList.add(string2);
                }
                continue;
            }
            if ("*".equals(string3)) {
                object2 = file2.listFiles();
                int n3 = ((File[])object2).length;
                for (int i = 0; i < n3; ++i) {
                    Object object3 = object2[i];
                    if (bl) {
                        arrayList.add(object3);
                        continue;
                    }
                    object.add(object3);
                    linkedList.add(string4);
                }
                continue;
            }
            if (GLOB_REGEX.reset(string3).find()) {
                Object object4;
                int n4;
                int n5;
                object2 = new StringBuffer(string3.length() * 2);
                int n6 = string3.length();
                for (int i = 0; i < n6; ++i) {
                    n5 = string3.charAt(i);
                    if (92 == n5) {
                        ((StringBuffer)object2).append("\\\\");
                        continue;
                    }
                    if (63 == n5) {
                        ((StringBuffer)object2).append('.');
                        continue;
                    }
                    if (42 == n5) {
                        ((StringBuffer)object2).append(".*");
                        continue;
                    }
                    if (91 == n5 || 93 == n5) {
                        ((StringBuffer)object2).append((char)n5);
                        continue;
                    }
                    if (123 == n5) {
                        n4 = string3.indexOf(125, i);
                        n = string3.indexOf(44, i);
                        if (n4 == -1 || n == -1) {
                            ((StringBuffer)object2).append('{');
                            continue;
                        }
                        object4 = i > 0 ? string3.substring(0, i) : "";
                        String string5 = n4 + 1 < n6 ? string3.substring(n4 + 1) : "";
                        object.add(file2);
                        linkedList.add((String)object4 + string3.substring(n + 1, n4) + string5);
                        string3 = string3.substring(i + 1, n) + string5;
                        i = -1;
                        n6 = string3.length();
                        continue;
                    }
                    ((StringBuffer)object2).append((char)n5);
                }
                Matcher matcher = Pattern.compile(((StringBuffer)object2).toString()).matcher("");
                File[] fileArray2 = file2.listFiles();
                n5 = fileArray2.length;
                for (n4 = 0; n4 < n5; ++n4) {
                    object4 = fileArray2[n4];
                    if (!matcher.reset(((File)object4).getName()).matches()) continue;
                    if (bl) {
                        arrayList.add(object4);
                        continue;
                    }
                    object.add(object4);
                    linkedList.add(string4);
                }
                continue;
            }
            object2 = new File(file2, string3);
            if (!((File)object2).exists()) continue;
            if (bl) {
                arrayList.add(object2);
                continue;
            }
            object.add(object2);
            linkedList.add(string4);
        }
        return arrayList.toArray(fileArray);
    }

    public static byte[] toByteArray(File file) throws IOException {
        return InputStreams.toByteArray(new FileInputStream(file), file.length());
    }

    public static void copy(File file, File file2) throws IOException {
        file = file.getAbsoluteFile();
        file2 = file2.getAbsoluteFile();
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath());
        }
        if (!file.canRead()) {
            throw new IOException(file.getPath() + " not readable");
        }
        if (file.equals(file2)) {
            return;
        }
        File file3 = file2.getParentFile();
        if (!file3.exists()) {
            file2.mkdirs();
        }
        InputStreams.copy(new FileInputStream(file), new FileOutputStream(file2), true);
    }

    public static boolean delete(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                File file2 = fileArray[i];
                if (file2.isDirectory()) {
                    Files.delete(file2);
                    continue;
                }
                file2.delete();
            }
        }
        return file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean secureDelete(File file) throws IOException {
        if (!file.canWrite()) {
            return false;
        }
        Random random = new Random();
        byte[] byArray = new byte[8192];
        long l = file.length();
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        try {
            for (int i = 0; i < 10; ++i) {
                for (long j = l; j > 0L; j -= (long)byArray.length) {
                    random.nextBytes(byArray);
                    randomAccessFile.write(byArray, 0, (int)Math.min(j, (long)byArray.length));
                }
            }
        }
        finally {
            randomAccessFile.close();
        }
        return file.delete();
    }
}

