/*
 * Decompiled with CFR 0.152.
 */
package phelps.io;

import com.pt.io.InputStreamLZW;
import com.pt.io.RandomAccess;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Random;
import java.util.zip.CRC32;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.apache.tools.bzip2.CBZip2InputStream;

public class InputStreams {
    public static final InputStream DEVNULL = new InputStream(){

        public int read() {
            return -1;
        }

        public long skip(long l) {
            return 0L;
        }

        public void reset() {
        }

        public boolean markSupported() {
            return true;
        }
    };
    public static final InputStream DEVZERO = new InputStream(){

        public int read() {
            return 0;
        }

        public int read(byte[] byArray, int n, int n2) {
            n2 = Math.min(n2, byArray.length - n);
            Arrays.fill(byArray, n, n2, (byte)0);
            return n2;
        }

        public long skip(long l) {
            return l;
        }

        public int available() {
            return Integer.MAX_VALUE;
        }

        public void reset() {
        }

        public boolean markSupported() {
            return true;
        }
    };
    public static final InputStream DEVRANDOM = new InputStream(){
        Random rand_ = new Random(System.currentTimeMillis());

        public int read() {
            return this.rand_.nextInt() & 0xFF;
        }

        public int available() {
            return Integer.MAX_VALUE;
        }

        public boolean markSupported() {
            return false;
        }
    };

    private InputStreams() {
    }

    public static long crc32(InputStream inputStream) throws IOException {
        int n;
        CRC32 cRC32 = new CRC32();
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) >= 0) {
            cRC32.update(byArray, 0, n);
        }
        return cRC32.getValue();
    }

    public static void readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n2 > 0) {
            n3 = inputStream.read(byArray, n, n2);
            if (n3 == -1) {
                throw new EOFException();
            }
            n += n3;
            n2 -= n3;
        }
    }

    public static void readFully(InputStream inputStream, byte[] byArray) throws IOException {
        InputStreams.readFully(inputStream, byArray, 0, byArray.length);
    }

    public static void skipFully(InputStream inputStream, long l) throws IOException {
        long l2;
        while (l > 0L && (l2 = inputStream.skip(l)) != -1L) {
            l -= l2;
        }
    }

    public static InputStream uncompress(InputStream inputStream, String string) throws IOException {
        if (!"identity".equals(string) && string != null) {
            if ("compress".equals(string)) {
                inputStream = new InputStreamLZW(inputStream);
            } else if ("gzip".equals(string)) {
                inputStream = new GZIPInputStream(inputStream);
            } else if ("deflate".equals(string)) {
                inputStream = new InflaterInputStream(inputStream);
            } else if ("bzip2".equals(string)) {
                inputStream = new CBZip2InputStream(inputStream);
            }
        }
        return inputStream;
    }

    public static long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        return InputStreams.copy(inputStream, outputStream, false);
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, boolean bl) throws IOException {
        return InputStreams.copy(inputStream, outputStream, bl, Integer.MAX_VALUE);
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, boolean bl, int n) throws IOException {
        byte[] byArray = new byte[Math.min(n, 8192)];
        long l = 0L;
        try {
            int n2;
            for (int i = n; i > 0 && (n2 = inputStream.read(byArray, 0, Math.min(i, byArray.length))) >= 0; i -= n2) {
                outputStream.write(byArray, 0, n2);
                l += (long)n2;
            }
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage() + " @ " + l);
        }
        finally {
            if (bl) {
                outputStream.close();
                inputStream.close();
            }
        }
        return l;
    }

    public static void copy(InputStream inputStream, RandomAccess randomAccess) throws IOException {
        int n;
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) != -1) {
            randomAccess.write(byArray, 0, n);
        }
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        return InputStreams.toByteArray(inputStream, 10240L);
    }

    public static byte[] toByteArray(InputStream inputStream, long l) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(l >= 1L ? (int)l : 10240);
        InputStreams.copy(inputStream, byteArrayOutputStream, true);
        return byteArrayOutputStream.toByteArray();
    }
}

