/*
 * Decompiled with CFR 0.152.
 */
package tool.pdf;

import com.pt.io.FileList;
import com.pt.io.InputUni;
import com.pt.io.InputUniByteArray;
import com.pt.io.InputUniFile;
import com.pt.io.OutputUni;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import multivalent.ParseException;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.PDFReader;
import multivalent.std.adaptor.pdf.PDFWriter;
import multivalent.std.adaptor.pdf.SecurityHandler;
import multivalent.std.adaptor.pdf.SecurityHandlerStandard;

public class Decrypt
implements Observer {
    static final boolean DEBUG = false;
    public static final String VERSION = "1.3 of $Date: 2005/07/26 21:15:46 $";
    public static final String COPYRIGHT = "Copyright (c) 2002 - 2005  Thomas A. Phelps.  All rights reserved.";
    private static final String USAGE = "java tool.pdf.Decrypt [-password <OWNER-password>] [-inplace] <PDF-file...>";
    private boolean fverbose_ = false;
    private boolean fquiet_ = false;
    private boolean fmonitor_ = false;
    private String password_ = null;
    private boolean finplace_ = false;
    private PDFReader pdfr_;
    private PDFWriter pdfw_;

    public Decrypt(File file) throws IOException, ParseException {
        this(new InputUniFile(file));
    }

    public Decrypt(byte[] byArray) throws IOException, ParseException {
        this(new InputUniByteArray(byArray));
    }

    public Decrypt(InputUni inputUni) throws IOException, ParseException {
        this(new PDFReader(inputUni));
    }

    public Decrypt(PDFReader pDFReader) {
    }

    public boolean isEncrypted() {
        return this.pdfr_.getTrailer().get("Encrypt") != null;
    }

    public boolean setPassword(String string) {
        return this.pdfr_.getEncrypt().getSecurityHandler().authOwner(string);
    }

    public void writeFile(File file) throws IOException, ParseException {
        this.writeUni(OutputUni.getInstance(file, null));
    }

    public byte[] writeBytes() throws IOException, ParseException {
        OutputUni outputUni = OutputUni.getInstance(new byte[this.pdfr_.getObjCnt() * 100], null);
        this.writeUni(outputUni);
        return outputUni.toByteArray();
    }

    public void writeUni(OutputUni outputUni) throws IOException, ParseException {
        this.decrypt(new PDFWriter(outputUni, this.pdfr_));
    }

    public PDFReader writePipe() throws IOException, ParseException {
        return null;
    }

    private Object decrypt(PDFWriter pDFWriter) throws IOException, ParseException {
        Object object;
        if (!this.pdfr_.isAuthorized()) {
            throw new ParseException("invalid password");
        }
        SecurityHandler securityHandler = this.pdfr_.getEncrypt().getSecurityHandler();
        if (securityHandler instanceof SecurityHandlerStandard && (((SecurityHandlerStandard)securityHandler).getPerm() & 1) == 0) {
            throw new ParseException("need OWNER password");
        }
        if (this.fmonitor_) {
            object = this.pdfr_.getInfo();
            System.out.println(object);
        }
        this.decrypt2(pDFWriter);
        this.pdfw_ = pDFWriter;
        object = pDFWriter.writePDF(this);
        this.pdfw_ = null;
        this.pdfr_.close();
        this.pdfr_ = null;
        pDFWriter.close();
        return object;
    }

    private void decrypt2(PDFWriter pDFWriter) throws IOException, ParseException {
        this.pdfr_.fault();
        pDFWriter.setExact(true);
        pDFWriter.getTrailer().remove("Encrypt");
    }

    public void update(Observable observable, Object object) {
        Object[] objectArray = (Object[])object;
        Object object2 = objectArray[0];
    }

    private int commandLine(String[] stringArray) {
        String string;
        int n;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if ((string = string.toLowerCase()).startsWith("--")) {
                string = string.substring(1);
            }
            if (string.equals("-password") || string.startsWith("-owner")) {
                this.password_ = stringArray[++n];
                continue;
            }
            if (string.equals("-inplace")) {
                this.finplace_ = true;
                continue;
            }
            if (string.startsWith("-verb")) {
                this.fverbose_ = true;
                this.fquiet_ = false;
                continue;
            }
            if (string.startsWith("-mon")) {
                this.fverbose_ = true;
                this.fmonitor_ = true;
                this.fquiet_ = false;
                continue;
            }
            if (string.startsWith("-q")) {
                this.fquiet_ = true;
                this.fmonitor_ = false;
                this.fverbose_ = false;
                continue;
            }
            if (string.startsWith("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (string.startsWith("-h")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println("Unknown option: " + string);
            System.err.println(USAGE);
            System.exit(1);
        }
        if (n == n2) {
            System.err.println(USAGE);
            System.exit(0);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Decrypt decrypt = new Decrypt((PDFReader)null);
        int n = decrypt.commandLine(stringArray);
        Iterator<File> iterator = new FileList(stringArray, n, COS.FILTER).iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            if (System.getSecurityManager() != null) continue;
            try {
                decrypt.pdfr_ = new PDFReader(file);
                boolean bl = decrypt.setPassword(decrypt.password_);
                if (!bl) {
                    System.err.println(file + ": invalid OWNER password");
                    continue;
                }
                String string = file.getPath();
                if (file.getName().toLowerCase().endsWith(".pdf")) {
                    string = string.substring(0, string.length() - 4);
                }
                decrypt.writeFile(decrypt.finplace_ ? file : new File(string + "-d.pdf"));
            }
            catch (Exception exception) {
                System.err.println(file + ": " + exception);
            }
            finally {
                if (decrypt.pdfr_ == null) continue;
                try {
                    decrypt.pdfr_.close();
                }
                catch (IOException iOException) {}
            }
        }
        System.exit(0);
    }
}

