/*
 * Decompiled with CFR 0.152.
 */
package tool.pdf;

import com.pt.io.RandomAccess;
import java.io.File;
import java.io.IOException;
import multivalent.ParseException;
import multivalent.std.adaptor.pdf.PDFReader;
import multivalent.std.adaptor.pdf.PDFWriter;

public class Repair {
    static final boolean DEBUG = true;
    public static final String VERSION = "1.0 of $Date: 2003/06/21 00:02:18 $";
    public static final String COPYRIGHT = "Copyright (c) 2003 - 2005  Thomas A. Phelps.  All rights reserved.";
    private static final String USAGE = "java tool.pdf.Repair [-uncompress] [-password <word>] <PDF-file>";
    private String password_;
    boolean funcompress;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Repair() {
        this.defaults();
    }

    public void defaults() {
        this.password_ = null;
        this.funcompress = false;
    }

    private void repair(File file) throws IOException, ParseException {
        String string = file.getPath();
        String string2 = (string.toLowerCase().endsWith(".pdf") ? string.substring(0, string.length() - ".pdf".length()) : string) + "-repair.pdf";
        this.repair(file, new File(string2));
    }

    private void repair(File file, File file2) throws IOException, ParseException {
        String string;
        if (!$assertionsDisabled && file.equals(file2)) {
            throw new AssertionError();
        }
        PDFReader pDFReader = new PDFReader(file);
        pDFReader.setPassword(this.password_);
        pDFReader.setExact(true);
        PDFWriter pDFWriter = new PDFWriter(file2, pDFReader, false);
        pDFWriter.writePDF();
        pDFWriter.close();
        if (!pDFReader.isModified()) {
            string = "no errors to repair";
        } else if (pDFReader.isRepaired()) {
            string = "REPAIRED ERRORS";
        } else {
            int n;
            RandomAccess randomAccess = pDFReader.getRA();
            int n2 = 0;
            while ((n = randomAccess.read()) != -1) {
                if (n < 128) continue;
                ++n2;
            }
            string = n2 < 20 ? "transferred over ASCII (not binary) channel -- unrepairable" : "cannot repair";
        }
        System.out.println(string);
        pDFReader.close();
    }

    private int commandLine(String[] stringArray) {
        String string;
        int n;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if ((string = string.toLowerCase()).startsWith("--")) {
                string = string.substring(1);
            }
            if (string.equals("-password")) {
                this.password_ = stringArray[++n];
                continue;
            }
            if (string.equals("-uncompress")) {
                this.funcompress = true;
                continue;
            }
            if (string.startsWith("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (string.startsWith("-h")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println("Unknown option: " + string);
            System.err.println(USAGE);
            System.exit(1);
        }
        if (n == n2) {
            System.err.println(USAGE);
            System.exit(0);
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        Repair repair = new Repair();
        int n = repair.commandLine(stringArray);
        File file = new File(stringArray[n]);
        if (System.getSecurityManager() == null) {
            try {
                repair.repair(file);
            }
            catch (Exception exception) {
                System.err.println(file + ": " + exception);
                exception.printStackTrace();
            }
        }
        System.exit(0);
    }

    static {
        $assertionsDisabled = !Repair.class.desiredAssertionStatus();
    }
}

