/*
 * Decompiled with CFR 0.152.
 */
package tool.pdf;

import com.pt.io.FileList;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import multivalent.ParseException;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.PDFReader;
import multivalent.std.adaptor.pdf.PDFWriter;
import multivalent.std.adaptor.pdf.SecurityHandler;
import multivalent.std.adaptor.pdf.SecurityHandlerStandard;
import phelps.io.PrintStreams;
import phelps.util.Units;

public class Stamp {
    static final boolean DEBUG = false;
    public static final String VERSION = "1.0 of $Date: 2003/10/01 14:01:23 $";
    public static final String COPYRIGHT = "Copyright (c) 2005  Thomas A. Phelps.  All rights reserved.";
    private static final String USAGE = "java tool.pdf.Stamp [<options>] <PDF-file>\t[-page <range>]\n\t[-password <password>] [-verbose] [-quiet]";
    private String range_;
    private String password_;
    private boolean fverbose_;
    private boolean fquiet_;
    private boolean fmonitor_;
    private PrintStream out_;

    public Stamp() {
        this.defaults();
    }

    public void defaults() {
        this.range_ = null;
        this.password_ = null;
        this.out_ = PrintStreams.DEVNULL;
        this.fmonitor_ = false;
        this.fquiet_ = false;
        this.fverbose_ = false;
    }

    public void setOut(PrintStream printStream) {
        this.out_ = printStream != null ? printStream : PrintStreams.DEVNULL;
    }

    public void setRange(String string) {
        this.range_ = string;
    }

    public void setPassword(String string) {
        this.password_ = string;
    }

    public void stamp(File file) throws IOException, ParseException {
        String string = file.getPath();
        String string2 = (string.toLowerCase().endsWith(".pdf") ? string.substring(0, string.length() - 4) : string) + "-s.pdf";
        this.stamp(file, new File(string2));
    }

    public void stamp(File file, File file2) throws IOException, ParseException {
        if (!this.fquiet_) {
            this.out_.println(file);
        }
        PDFReader pDFReader = new PDFReader(file);
        PDFWriter pDFWriter = new PDFWriter(file2, pDFReader, false);
        this.stamp(pDFReader, pDFWriter);
        pDFWriter.writePDF();
        pDFWriter.close();
        pDFReader.close();
    }

    public void stamp(PDFReader pDFReader, PDFWriter pDFWriter) throws IOException, ParseException {
        int n;
        Object object;
        pDFReader.setPassword(this.password_);
        if (!pDFReader.isAuthorized()) {
            throw new ParseException("invalid password");
        }
        SecurityHandler securityHandler = pDFReader.getEncrypt().getSecurityHandler();
        if (securityHandler instanceof SecurityHandlerStandard) {
            object = (SecurityHandlerStandard)securityHandler;
            n = ((SecurityHandlerStandard)object).getR();
            int n2 = ((SecurityHandlerStandard)object).getPerm();
            if ((n2 & 8) == 0) {
                throw new ParseException("don't have permission to 'modify' -- try owner password");
            }
        }
        pDFWriter.setPassword(this.password_);
        object = Units.parseRange(this.range_, 1, pDFReader.getPageCnt());
        n = pDFReader.getPageCnt();
        pDFWriter.refcntRemove();
        pDFWriter.liftPageTree();
    }

    private int commandLine(String[] stringArray) {
        String string;
        int n;
        this.out_ = System.out;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if ((string = string.toLowerCase()).startsWith("--")) {
                string = string.substring(1);
            }
            if (string.startsWith("-page") || string.startsWith("-range")) {
                this.setRange(stringArray[++n]);
                continue;
            }
            if (string.startsWith("-pass")) {
                this.setPassword(stringArray[++n]);
                continue;
            }
            if (string.startsWith("-verb")) {
                this.fverbose_ = true;
                this.fquiet_ = false;
                continue;
            }
            if (string.startsWith("-mon")) {
                this.fverbose_ = true;
                this.fmonitor_ = true;
                this.fquiet_ = false;
                continue;
            }
            if (string.startsWith("-q")) {
                this.fquiet_ = true;
                this.fverbose_ = false;
                this.fmonitor_ = false;
                continue;
            }
            if (string.startsWith("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (string.startsWith("-h")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println("Unknown option: " + string);
            System.err.println(USAGE);
            System.exit(1);
        }
        if (n == n2) {
            System.err.println(USAGE);
            System.exit(0);
        }
        return n;
    }

    public static void main(String[] stringArray) {
        Stamp stamp = new Stamp();
        int n = stamp.commandLine(stringArray);
        Iterator<File> iterator = new FileList(stringArray, n, COS.FILTER).iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            if (System.getSecurityManager() != null) continue;
            try {
                stamp.stamp(file);
            }
            catch (Exception exception) {
                System.err.println(file + ": " + exception);
                System.exit(1);
            }
        }
        System.exit(0);
    }
}

