/*
 * Decompiled with CFR 0.152.
 */
package io.github.eb4j.stardict;

import java.util.Map;

public class StarDictInfo {
    private final String bookName;
    private final String version;
    private final int wordCount;
    private final boolean hasSynonym;
    private final int synWordCount;
    private final boolean oftindexbits64;
    private final String author;
    private final String website;
    private final String description;
    private final String date;
    private final String sametypesequence;

    public StarDictInfo(Map<String, String> header) throws Exception {
        String bitsString;
        this.bookName = header.get("bookname");
        this.version = header.get("version");
        String swc = header.getOrDefault("synwordcount", null);
        this.hasSynonym = swc != null;
        this.synWordCount = this.hasSynonym ? Integer.parseUnsignedInt(swc) : 0;
        String wc = header.getOrDefault("wordcount", "0");
        this.wordCount = Integer.parseUnsignedInt(wc);
        int idxoffsetbits = 32;
        if ("3.0.0".equals(this.version) && (bitsString = header.get("idxoffsetbits")) != null) {
            idxoffsetbits = Integer.parseInt(bitsString);
        }
        if (idxoffsetbits != 32 && idxoffsetbits != 64) {
            throw new Exception("StarDict dictionaries other than idxoffsetbits=64 or 32 are not supported.");
        }
        this.oftindexbits64 = idxoffsetbits == 64;
        this.sametypesequence = header.getOrDefault("sametypesequence", null);
        this.author = header.getOrDefault("author", "");
        this.website = header.getOrDefault("website", "");
        this.description = header.getOrDefault("description", "");
        this.date = header.getOrDefault("date", null);
    }

    public String getBookName() {
        return this.bookName;
    }

    public String getVersion() {
        return this.version;
    }

    public int getWordCount() {
        return this.wordCount;
    }

    public boolean isHasSynonym() {
        return this.hasSynonym;
    }

    public int getSynWordCount() {
        return this.synWordCount;
    }

    public boolean isOftindexbits64() {
        return this.oftindexbits64;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getWebsite() {
        return this.website;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDate() {
        return this.date;
    }

    public String getSametypesequence() {
        return this.sametypesequence;
    }
}

