/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.html2;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.omegat.filters2.html2.HTMLOptions;
import org.omegat.util.PatternConsts;

public class HTMLWriter
extends Writer {
    private StringWriter writer;
    private BufferedWriter realWriter;
    private String htmlMeta;
    private String xmlHeader;
    private String encoding;
    private HTMLOptions options;
    private static final int MIN_HEADERED_BUFFER_SIZE = 4096;
    private static final int MAX_BUFFER_SIZE = 65536;
    private boolean signalClosing = false;
    private boolean signalAlreadyFlushed = false;

    public HTMLWriter(String fileName, String encoding, HTMLOptions options) throws FileNotFoundException, UnsupportedEncodingException {
        this.encoding = encoding;
        this.options = options;
        this.writer = new StringWriter();
        FileOutputStream fos = new FileOutputStream(fileName);
        OutputStreamWriter osw = encoding != null ? new OutputStreamWriter((OutputStream)fos, encoding) : new OutputStreamWriter((OutputStream)fos, Charset.defaultCharset());
        this.realWriter = new BufferedWriter(osw);
    }

    @Override
    public void close() throws IOException {
        this.signalClosing = true;
        this.flush();
        this.realWriter.close();
    }

    @Override
    public void flush() throws IOException {
        StringBuffer buffer = this.writer.getBuffer();
        if (this.signalAlreadyFlushed || this.encoding == null) {
            this.realWriter.write(buffer.toString());
            buffer.setLength(0);
        } else if (this.signalClosing || buffer.length() >= 4096) {
            this.signalAlreadyFlushed = true;
            Object contents = buffer.toString();
            if (this.options.getRewriteEncoding() != HTMLOptions.REWRITE_MODE.NEVER) {
                String EOL = "";
                Matcher matcherLineending = PatternConsts.LINE_ENDING.matcher((CharSequence)contents);
                if (matcherLineending.find()) {
                    EOL = matcherLineending.group();
                }
                Matcher matcherHeader = PatternConsts.XML_HEADER.matcher((CharSequence)contents);
                boolean xhtml = false;
                if (matcherHeader.find()) {
                    this.xmlHeader = "<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>";
                    contents = matcherHeader.replaceFirst(this.xmlHeader);
                    xhtml = true;
                }
                this.htmlMeta = "<meta http-equiv=\"content-type\" content=\"text/html; charset=" + this.encoding + "\"";
                this.htmlMeta = xhtml ? this.htmlMeta + " />" : this.htmlMeta + ">";
                Matcher matcherEnc = PatternConsts.HTML_ENCODING.matcher((CharSequence)contents);
                Matcher matcherEncHtml5 = PatternConsts.HTML5_ENCODING.matcher((CharSequence)contents);
                if (matcherEnc.find()) {
                    contents = matcherEnc.replaceFirst(this.htmlMeta);
                } else if (matcherEncHtml5.find()) {
                    contents = matcherEncHtml5.replaceFirst("<meta charset=\"" + this.encoding + "\">");
                } else if (this.options.getRewriteEncoding() != HTMLOptions.REWRITE_MODE.IFMETA) {
                    Matcher matcherHead = PatternConsts.HTML_HEAD.matcher((CharSequence)contents);
                    if (matcherHead.find()) {
                        contents = matcherHead.replaceFirst("$0" + EOL + "    " + this.htmlMeta);
                    } else if (this.options.getRewriteEncoding() != HTMLOptions.REWRITE_MODE.IFHEADER) {
                        Matcher matcherHtml = PatternConsts.HTML_HTML.matcher((CharSequence)contents);
                        contents = matcherHtml.find() ? matcherHtml.replaceFirst("$0" + EOL + "<head>" + EOL + "    " + this.htmlMeta + EOL + "</head>") : "<html>" + EOL + "<head>" + EOL + "    " + this.htmlMeta + EOL + "</head>" + EOL + (String)contents;
                    }
                }
            }
            this.realWriter.write((String)contents);
            buffer.setLength(0);
        }
    }

    @Override
    public void write(@NotNull char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
        if (this.writer.getBuffer().length() >= 65536) {
            this.flush();
        }
    }
}

