/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.preferences.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.table.AbstractTableModel;
import org.omegat.gui.preferences.BasePreferencesController;
import org.omegat.gui.preferences.view.CustomColorSelectionPanel;
import org.omegat.util.OStrings;
import org.omegat.util.gui.Styles;

public class CustomColorSelectionController
extends BasePreferencesController {
    private static final int MAX_ROW_COUNT = 10;
    private final Map<Styles.EditorColor, Color> temporaryPreferences = new EnumMap<Styles.EditorColor, Color>(Styles.EditorColor.class);
    private ColorIcon icon;
    private CustomColorSelectionPanel panel;
    private boolean listenerEnabled = true;

    @Override
    public JComponent getGui() {
        if (this.panel == null) {
            this.initGui();
            this.initFromPrefs();
        }
        return this.panel;
    }

    @Override
    public String toString() {
        return OStrings.getString("PREFS_TITLE_COLORS");
    }

    private void initGui() {
        this.panel = new CustomColorSelectionPanel();
        try {
            CustomColorSelectionController.removeTransparencySlider(this.panel.colorChooser);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.panel.colorChooser.getSelectionModel().addChangeListener(e -> {
            if (this.listenerEnabled) {
                this.recordTemporaryPreference();
            }
        });
        this.panel.colorStylesTable.getSelectionModel().addListSelectionListener(e -> this.onSelectionChanged());
        Dimension tableSize = this.panel.colorStylesTable.getPreferredSize();
        this.panel.colorStylesTable.setPreferredScrollableViewportSize(new Dimension(tableSize.width, this.panel.colorStylesTable.getRowHeight() * 10));
        this.panel.colorStylesTable.setModel(new ColorTableModel());
        this.icon = new ColorIcon(this.panel.colorStylesTable.getRowHeight());
        this.panel.resetCurrentColorButton.addActionListener(e -> this.resetCurrentColor());
    }

    private Optional<Styles.EditorColor> getSelection() {
        int row = this.panel.colorStylesTable.getSelectedRow();
        if (row < 0) {
            return Optional.empty();
        }
        ColorTableModel model = (ColorTableModel)this.panel.colorStylesTable.getModel();
        return Optional.of(model.getEditorColorAtRow(row));
    }

    private void recordTemporaryPreference() {
        this.getSelection().ifPresent(style -> {
            this.temporaryPreferences.put((Styles.EditorColor)((Object)style), this.panel.colorChooser.getColor());
            this.setRestartRequired(this.hasChanges());
            this.updateSelectionIcon();
        });
    }

    private void updateSelectionIcon() {
        int row = this.panel.colorStylesTable.getSelectedRow();
        if (row >= 0) {
            ((ColorTableModel)this.panel.colorStylesTable.getModel()).fireTableRowsUpdated(row, row);
        }
    }

    private static void removeTransparencySlider(JColorChooser jc) throws Exception {
        AbstractColorChooserPanel[] colorPanels = jc.getChooserPanels();
        for (int i = 1; i < colorPanels.length; ++i) {
            AbstractColorChooserPanel cp = colorPanels[i];
            Field f = cp.getClass().getDeclaredField("panel");
            f.setAccessible(true);
            Object colorPanel = f.get(cp);
            Field f2 = colorPanel.getClass().getDeclaredField("spinners");
            f2.setAccessible(true);
            Object spinners = f2.get(colorPanel);
            Object transpSlispinner = Array.get(spinners, 3);
            if (i == colorPanels.length - 1) {
                transpSlispinner = Array.get(spinners, 4);
            }
            Field f3 = transpSlispinner.getClass().getDeclaredField("slider");
            f3.setAccessible(true);
            JSlider slider = (JSlider)f3.get(transpSlispinner);
            slider.setEnabled(false);
            slider.setVisible(false);
            Field f4 = transpSlispinner.getClass().getDeclaredField("spinner");
            f4.setAccessible(true);
            JSpinner spinner = (JSpinner)f4.get(transpSlispinner);
            spinner.setEnabled(false);
            spinner.setVisible(false);
            Field f5 = transpSlispinner.getClass().getDeclaredField("label");
            f5.setAccessible(true);
            JLabel label = (JLabel)f5.get(transpSlispinner);
            label.setVisible(false);
        }
    }

    private void setColorChooserWithoutNotifying(Color color) {
        this.listenerEnabled = false;
        this.panel.colorChooser.setColor(color == null ? Color.BLACK : color);
        this.listenerEnabled = true;
    }

    private void onSelectionChanged() {
        Optional<Styles.EditorColor> selection = this.getSelection();
        boolean enabled = selection.isPresent();
        this.panel.colorChooser.setEnabled(enabled);
        this.panel.resetCurrentColorButton.setEnabled(enabled);
        selection.ifPresent(style -> {
            Color color = this.temporaryPreferences.getOrDefault(style, style.getColor());
            this.setColorChooserWithoutNotifying(color);
        });
    }

    private void resetCurrentColor() {
        this.getSelection().ifPresent(style -> {
            Color defaultColor = style.getDefault();
            if (defaultColor == null) {
                this.setColorChooserWithoutNotifying(Color.BLACK);
                this.temporaryPreferences.put((Styles.EditorColor)((Object)style), (Color)null);
            } else {
                this.panel.colorChooser.setColor(defaultColor);
            }
            this.setRestartRequired(this.hasChanges());
            this.updateSelectionIcon();
        });
    }

    private boolean hasChanges() {
        return !this.temporaryPreferences.entrySet().stream().allMatch(e -> Objects.equals(((Styles.EditorColor)((Object)((Object)e.getKey()))).getColor(), e.getValue()));
    }

    @Override
    public void restoreDefaults() {
        for (Styles.EditorColor style : Styles.EditorColor.values()) {
            this.temporaryPreferences.put(style, style.getDefault());
        }
        this.panel.colorStylesTable.repaint();
        this.panel.colorStylesTable.clearSelection();
        this.onSelectionChanged();
        this.setRestartRequired(this.hasChanges());
    }

    @Override
    protected void initFromPrefs() {
        this.temporaryPreferences.clear();
        this.panel.colorStylesTable.repaint();
        this.panel.colorStylesTable.clearSelection();
        this.onSelectionChanged();
    }

    @Override
    public void persist() {
        this.temporaryPreferences.entrySet().forEach(e -> ((Styles.EditorColor)((Object)((Object)e.getKey()))).setColor((Color)e.getValue()));
    }

    class ColorTableModel
    extends AbstractTableModel {
        ColorTableModel() {
        }

        @Override
        public int getRowCount() {
            return Styles.EditorColor.values().length;
        }

        @Override
        public int getColumnCount() {
            return ColorColumns.values().length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Styles.EditorColor style = this.getEditorColorAtRow(rowIndex);
            switch (ColorColumns.get(columnIndex)) {
                case NAME: {
                    return style.getDisplayName();
                }
                case ICON: {
                    Color color = CustomColorSelectionController.this.temporaryPreferences.getOrDefault((Object)style, style.getColor());
                    return CustomColorSelectionController.this.icon.setColor(color);
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return ColorColumns.get((int)columnIndex).clss;
        }

        public Styles.EditorColor getEditorColorAtRow(int row) {
            return Styles.EditorColor.values()[row];
        }
    }

    static class ColorIcon
    implements Icon {
        private final int size;
        private Color color;

        ColorIcon(int size) {
            this.size = size;
        }

        public ColorIcon setColor(Color color) {
            this.color = color;
            return this;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.color != null) {
                g.setColor(this.color);
                g.fillRect(x, y, this.size, this.size);
            } else {
                g.setColor(Color.RED);
                g.drawLine(x, y, x + this.size, y + this.size);
            }
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }
    }

    static enum ColorColumns {
        NAME(String.class),
        ICON(Icon.class);

        private final Class<?> clss;

        private ColorColumns(Class<?> clss) {
            this.clss = clss;
        }

        static ColorColumns get(int index) {
            return ColorColumns.values()[index];
        }
    }
}

