/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.channels.ServerSocketChannel;
import java.util.Set;
import org.newsclub.net.unix.AFUNIXSelectorProvider;
import org.newsclub.net.unix.AFUNIXServerSocket;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketChannel;
import org.newsclub.net.unix.AFUNIXSocketCore;
import org.newsclub.net.unix.FileDescriptorAccess;
import org.newsclub.net.unix.SocketOptionsMapper;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class AFUNIXServerSocketChannel
extends ServerSocketChannel
implements FileDescriptorAccess {
    private final AFUNIXServerSocket afSocket;

    AFUNIXServerSocketChannel(AFUNIXServerSocket socket) {
        super(AFUNIXSelectorProvider.getInstance());
        this.afSocket = socket;
    }

    public static AFUNIXServerSocketChannel open() throws IOException {
        return AFUNIXSelectorProvider.provider().openServerSocketChannel();
    }

    @Override
    public <T> T getOption(SocketOption<T> name) throws IOException {
        Integer optionId = SocketOptionsMapper.resolve(name);
        if (optionId == null) {
            throw new UnsupportedOperationException("unsupported option");
        }
        return (T)this.afSocket.getAFImpl().getOption(optionId);
    }

    @Override
    public <T> AFUNIXServerSocketChannel setOption(SocketOption<T> name, T value) throws IOException {
        Integer optionId = SocketOptionsMapper.resolve(name);
        if (optionId == null) {
            throw new UnsupportedOperationException("unsupported option");
        }
        this.afSocket.getAFImpl().setOption(optionId, value);
        return this;
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        return SocketOptionsMapper.SUPPORTED_SOCKET_OPTIONS;
    }

    @Override
    public AFUNIXServerSocketChannel bind(SocketAddress local, int backlog) throws IOException {
        this.afSocket.bind(local, backlog);
        return this;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public AFUNIXServerSocket socket() {
        return this.afSocket;
    }

    @Override
    public AFUNIXSocketChannel accept() throws IOException {
        AFUNIXSocket socket = this.afSocket.accept();
        return socket == null ? null : socket.getChannel();
    }

    @Override
    public AFUNIXSocketAddress getLocalAddress() throws IOException {
        return this.afSocket.getLocalSocketAddress();
    }

    @Override
    protected void implCloseSelectableChannel() throws IOException {
        this.afSocket.close();
    }

    @Override
    protected void implConfigureBlocking(boolean block) throws IOException {
        this.getAFCore().implConfigureBlocking(block);
    }

    AFUNIXSocketCore getAFCore() {
        return this.afSocket.getAFImpl().getCore();
    }

    @Override
    public FileDescriptor getFileDescriptor() throws IOException {
        return this.afSocket.getFileDescriptor();
    }
}

