# Announce: Rakudo Perl 6 compiler, Development Release #83 ("Cologne")

On behalf of the Rakudo development team, I'm happy to announce the
December 2014 release of Rakudo Perl 6 #83 "Cologne". Rakudo is an
implementation of Perl 6 on the Moar Virtual Machine[^1], the Java Virtual
Machine and the Parrot Virtual Machine[^2]. The tarball for this release
is available from <http://rakudo.org/downloads/rakudo/>.

Please note: This announcement is not for the Rakudo Star
distribution[^3] --- it's announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<http://rakudo.org/downloads/star/>.

The Rakudo Perl compiler follows a monthly release cycle, with each
release named after a Perl Mongers group. This release is named after
Cologne, in honour of the organizers of the Niederrhein.PM meeting this week.

Some of the changes in this release are outlined below:

These are only some of the changes in this release. For a more
detailed list, see "docs/ChangeLog".

INCOMPATIBLE CHANGES:
+ $str ~~ s/// now returns a Match or list of Matches

Other notable changes:
+ Flakiness on OS X has been fixed (for the most part)
+ Method FALLBACK implemented
+ Updated List smart-matching to latest design
+ $*DISTRO and $*KERNEL updated ($*DISTRO now actually report the Linux dist)
+ Added Metamodel::Primitives, to open up more meta-programming possibilities
  (publishing method caches, completely custom meta-objects, etc.)
+ Support for closure parameter signatures
+ Implemented chained sequences
+ Many optimizations, bug-fixes and other additions

The development team thanks all of our contributors and sponsors for
making Rakudo Perl possible, as well as those people who worked on
Parrot, the Perl 6 test suite, MoarVM and the specification.

The following people contributed to this release:

Elizabeth Mattijsen, Larry Wall, Jonathan Worthington, Rob Hoelz, Moritz Lenz,
Tobias Leich, Timo Paulssen, Christian Bartolomäus, Carl Mäsak, Solomon Foster,
Geoffrey Broadwell, Will "Coke" Coleda, raydiak, Alexander Moquin

If you would like to contribute, see <http://rakudo.org/how-to-help>,
ask on the <perl6-compiler@perl.org> mailing list, or ask on IRC
\#perl6 on freenode.

The next release of Rakudo (#84), is scheduled for 22 January 2015.
A list of the other planned release dates and code names for future
releases is available in the "docs/release_guide.pod" file. A Rakudo
development release typically occurs a few days (often two) after the
third Tuesday of each month.

The development team appreciates feedback! If you're using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback -- get in touch with
us through (the above-mentioned) mailing list of IRC channel. Enjoy!

[^1]: See <http://moarvm.org/>

[^2]: See <http://parrot.org/>

[^3]: What's the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Nothing else.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, the most recent
incarnation of the "Using Perl 6" book, and other software that can
be used with the Rakudo compiler to enhance its utility.  Rakudo Star
is meant for early adopters who wish to explore what's possible with
Rakudo Perl 6 and provide feedback on what works, what doesn't, and
what else they would like to see included in the distribution.

# Troubleshooting
It appears that on OS X, the build will sometimes fail with a message like:

  .../install/include/libuv/uv-darwin.h:26:11: fatal error: 
        'mach/mach.h' file not found

The only solution found to fix this so far, has been:

  $ cd install/include/libuv
  $ ln -s /Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX10.9.sdk/usr/include/mach
  $ cd ../../..
  $ # run make again

Note that the 10.9 in the above, represents the major version of OS X being
used.  On Mavericks use 10.9 (like above), on Yosemite use 10.10.
