# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
import sys
from datetime import datetime
from importlib.metadata import version as metadata_version

base_path = os.path.abspath("../..")
sys.path.insert(0, os.path.join(base_path, "src"))


# -- Project information -----------------------------------------------------
project = "qbittorrent-api"
author = "Russell Martin"
copyright = f"{datetime.today().year}, {author}"

# The full version, including alpha/beta/rc tags
release = version = metadata_version("qbittorrent-api")

# -- General configuration ---------------------------------------------------
# Add any Sphinx extension module names here, as strings. They can be extensions coming
# with Sphinx (named 'sphinx.ext.*') or your custom ones.
extensions = [
    "sphinx.ext.todo",
    "sphinx.ext.githubpages",
    "sphinx.ext.autodoc",
    "sphinx_autodoc_typehints",
    "sphinx.ext.intersphinx",
    "sphinx_copybutton",
]

pygments_style = "sphinx"

# warn about everything
nitpicky = True
nitpick_ignore = [
    ("py:class", "JsonValueT"),
    ("py:class", "ListInputT"),
    ("py:class", "Response"),
    ("py:class", "Request"),
    ("py:class", "qbittorrentapi.request.ResponseT"),
    ("py:class", "qbittorrentapi.request.T"),
    ("py:class", "qbittorrentapi.torrents.TorrentFilesT"),
    ("py:obj", "qbittorrentapi._attrdict.K"),
    ("py:obj", "qbittorrentapi._attrdict.V"),
    ("py:obj", "qbittorrentapi.definitions.K"),
    ("py:obj", "qbittorrentapi.definitions.V"),
]

autodoc_type_aliases = {"JsonValueT": "qbittorrentapi.definitions.JsonValueT"}
always_use_bars_union = True
add_module_names = False
autodoc_typehints_format = "short"
python_use_unqualified_type_names = True
python_use_unqualified_names = True
typehints_fully_qualified = False
typehints_use_signature = False
typehints_use_signature_return = True
typehints_document_rtype = True

source_suffix = ".rst"

# The master toctree document.
master_doc = "index"

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = []

linkcheck_ignore = [
    # ignore reference to just the HTTP schemas
    r"^http://$",
    r"^https://$",
    r"^http://localhost",
    r"^http://example.com",
    # RTD CI seems to be banned...
    r"^https://distrowatch.com/news/torrents.xml",
]

# ignore GitHub code line number anchors that are generated by javascript
linkcheck_anchors_ignore = ["L79", "L42"]

# -- Options for HTML output -------------------------------------------------
# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
# html_static_path = ["_static"]

html_theme = "furo"

# Add mappings
intersphinx_mapping = {
    "python": ("https://docs.python.org/3", None),
    "requests": ("https://requests.readthedocs.io/en/latest/", None),
}

suppress_warnings = [
    # Suppress builds warnings while building epub
    "epub.unknown_project_files",
]

# -- Options for spelling -------------------------------------------

# Spelling check needs an additional module that is not installed by default.
# Add it only if spelling check is requested so docs can be generated without it.
if "spelling" in sys.argv:
    extensions.append("sphinxcontrib.spelling")

# Spelling language.
spelling_lang = "en_US"

# Location of word list.
spelling_word_list_filename = "spelling_wordlist"

spelling_ignore_pypi_package_names = False
