#include <errno.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <getopt.h>

/* Normal Character Set */

static uint8_t teletext_characters[96*60]={
  // 0x20 ' '
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x21 '!'
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x22 '"'
  0,0,0,0,0,0,
  0,0,1,0,1,0,
  0,0,1,0,1,0,
  0,0,1,0,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x23 ' British Pound'
  0,0,0,0,0,0,
  0,0,0,1,1,0,
  0,0,1,0,0,1,
  0,0,1,0,0,0,
  0,1,1,1,0,0,
  0,0,1,0,0,0,
  0,0,1,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x24 '$'
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,1,0,1,
  0,1,0,1,0,0,
  0,0,1,1,1,0,
  0,0,0,1,0,1,
  0,1,0,1,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x25 '%'
  0,0,0,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,1,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,1,0,0,0,
  0,1,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x26 '&'
  0,0,0,0,0,0,
  0,0,1,0,0,0,
  0,1,0,1,0,0,
  0,1,0,1,0,0,
  0,0,1,0,0,0,
  0,1,0,1,0,1,
  0,1,0,0,1,0,
  0,0,1,1,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x27 '''
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x28 '('
  0,0,0,0,0,0,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,1,0,0,0,
  0,0,1,0,0,0,
  0,0,1,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x29 ')'
  0,0,0,0,0,0,
  0,0,1,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,1,0,
  0,0,0,0,1,0,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x2a '*'
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,1,0,1,0,1,
  0,0,1,1,1,0,
  0,0,0,1,0,0,
  0,0,1,1,1,0,
  0,1,0,1,0,1,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x2b '+'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,1,1,1,1,1,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x2c ','
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x2d '-'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x2e '.'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x2f '/'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,1,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,1,0,0,0,
  0,1,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x30 '0'
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,1,0,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,0,1,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x31 '1'
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,1,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x32 '2'
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,0,0,0,0,1,
  0,0,0,1,1,0,
  0,0,1,0,0,0,
  0,1,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x33 '3'
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,1,
  0,0,0,0,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x34 '4'
  0,0,0,0,0,0,
  0,0,0,0,1,0,
  0,0,0,1,1,0,
  0,0,1,0,1,0,
  0,1,0,0,1,0,
  0,1,1,1,1,1,
  0,0,0,0,1,0,
  0,0,0,0,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x35 '5'
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,1,0,0,0,0,
  0,1,1,1,1,0,
  0,0,0,0,0,1,
  0,0,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x36 '6'
  0,0,0,0,0,0,
  0,0,0,1,1,0,
  0,0,1,0,0,0,
  0,1,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x37 '7'
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,1,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,1,0,0,0,
  0,0,1,0,0,0,
  0,0,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x38 '8'
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x39 '9'
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,1,
  0,0,0,0,0,1,
  0,0,0,0,1,0,
  0,0,1,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x3a ':'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x3b ';'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x3c '<'
  0,0,0,0,0,0,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,1,0,0,0,
  0,1,0,0,0,0,
  0,0,1,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x3d '='
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x3e '>'
  0,0,0,0,0,0,
  0,0,1,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,1,0,
  0,0,0,0,0,1,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x3f '?'
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x40 '@'
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,1,1,1,
  0,1,0,1,0,1,
  0,1,0,1,1,1,
  0,1,0,0,0,0,
  0,0,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x41 'A'
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,1,0,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x42 'B'
  0,0,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x43 'C'
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x44 'D'
  0,0,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x45 'E'
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x46 'F'
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x47 'G'
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,1,1,
  0,1,0,0,0,1,
  0,0,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x48 'H'
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x49 'I'
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x4a 'J'
  0,0,0,0,0,0,
  0,0,0,0,0,1,
  0,0,0,0,0,1,
  0,0,0,0,0,1,
  0,0,0,0,0,1,
  0,0,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x4b 'K'
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,1,0,
  0,1,0,1,0,0,
  0,1,1,0,0,0,
  0,1,0,1,0,0,
  0,1,0,0,1,0,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x4c 'L'
  0,0,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x4d 'M'
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,1,0,1,1,
  0,1,0,1,0,1,
  0,1,0,1,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x4e 'N'
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,0,0,1,
  0,1,0,1,0,1,
  0,1,0,0,1,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x4f 'O'
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x50 'P'
  0,0,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x51 'Q'
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,1,0,1,
  0,1,0,0,1,0,
  0,0,1,1,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x52 'R'
  0,0,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,0,
  0,1,0,1,0,0,
  0,1,0,0,1,0,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x53 'S'
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,0,
  0,0,1,1,1,0,
  0,0,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x54 'T'
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x55 'U'
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x56 'V'
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,0,1,0,
  0,0,1,0,1,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x57 'W'
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,1,0,1,
  0,1,0,1,0,1,
  0,1,0,1,0,1,
  0,0,1,0,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x58 'X'
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,0,1,0,
  0,0,0,1,0,0,
  0,0,1,0,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x59 'Y'
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,0,1,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x5a 'Z'
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,1,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,1,0,0,0,
  0,1,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x5b Left Arrow
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,1,0,0,0,
  0,1,1,1,1,1,
  0,0,1,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x5c ' 1/2 symbol'
  0,0,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,1,1,0,
  0,0,0,0,0,1,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,0,1,1,1
, // 0x5d Right Arrow
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,1,0,
  0,1,1,1,1,1,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x5e Up Arrow
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,1,1,1,0,
  0,1,0,1,0,1,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x5f '#'
  0,0,0,0,0,0,
  0,0,1,0,1,0,
  0,0,1,0,1,0,
  0,1,1,1,1,1,
  0,0,1,0,1,0,
  0,1,1,1,1,1,
  0,0,1,0,1,0,
  0,0,1,0,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x60 '_'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x61 'a'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,0,0,0,0,1,
  0,0,1,1,1,1,
  0,1,0,0,0,1,
  0,0,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x62 'b'
  0,0,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x63 'c'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,1,1,1,1,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,0,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x64 'd'
  0,0,0,0,0,0,
  0,0,0,0,0,1,
  0,0,0,0,0,1,
  0,0,1,1,1,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x65 'e'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,1,1,1,1,
  0,1,0,0,0,0,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x66 'f'
  0,0,0,0,0,0,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,1,1,1,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x67 'g'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,1,1,1,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,1,
  0,0,0,0,0,1,
  0,0,1,1,1,0
, // 0x68 'h'
  0,0,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x69 'i'
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,1,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x6a 'j'
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,1,0,0,0,
  0,0,0,0,0,0
, // 0x6b 'k'
  0,0,0,0,0,0,
  0,0,1,0,0,0,
  0,0,1,0,0,0,
  0,0,1,0,0,1,
  0,0,1,0,1,0,
  0,0,1,1,0,0,
  0,0,1,0,1,0,
  0,0,1,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x6c 'l'
  0,0,0,0,0,0,
  0,0,1,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x6d 'm'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,1,1,0,1,0,
  0,1,0,1,0,1,
  0,1,0,1,0,1,
  0,1,0,1,0,1,
  0,1,0,1,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x6e 'n'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x6f 'o'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x70 'p'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0
, // 0x71 'q'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,1,1,1,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,1,
  0,0,0,0,0,1,
  0,0,0,0,0,1
, // 0x72 'r'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,1,0,1,1,
  0,0,1,1,0,0,
  0,0,1,0,0,0,
  0,0,1,0,0,0,
  0,0,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x73 's'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,1,1,1,1,
  0,1,0,0,0,0,
  0,0,1,1,1,0,
  0,0,0,0,0,1,
  0,1,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x74 't'
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,1,1,1,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,0,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x75 'u'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x76 'v'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,0,1,0,
  0,0,1,0,1,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x77 'w'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,1,0,1,
  0,1,0,1,0,1,
  0,0,1,0,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x78 'x'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,0,1,0,1,0,
  0,0,0,1,0,0,
  0,0,1,0,1,0,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x79 'y'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,1,
  0,0,0,0,0,1,
  0,0,1,1,1,0
, // 0x7a 'z'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,1,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x7b 'one fourth symbol'
  0,0,0,0,0,0,
  0,0,1,0,0,0,
  0,0,1,0,0,0,
  0,0,1,0,0,0,
  0,0,1,0,0,1,
  0,0,0,0,1,1,
  0,0,0,1,0,1,
  0,0,0,1,1,1,
  0,0,0,0,0,1,
  0,0,0,0,0,0
, // 0x7c '|'
  0,0,0,0,0,0,
  0,0,1,0,1,0,
  0,0,1,0,1,0,
  0,0,1,0,1,0,
  0,0,1,0,1,0,
  0,0,1,0,1,0,
  0,0,1,0,1,0,
  0,0,1,0,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x7d ' three fourths symbol'
  0,0,0,0,0,0,
  0,1,1,0,0,0,
  0,0,0,1,0,0,
  0,1,1,0,0,0,
  0,0,0,1,0,0,
  0,1,1,0,0,1,
  0,0,0,0,1,1,
  0,0,0,1,0,1,
  0,0,0,1,1,1,
  0,0,0,0,0,1
, // 0x7e Divide
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x7f Block
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,1,1,1,1,1,
  0,1,1,1,1,1,
  0,1,1,1,1,1,
  0,1,1,1,1,1,
  0,1,1,1,1,1,
  0,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
};

/* Graphics Character Set */

static uint8_t teletext_graphics[96*60]={
  // 0x20
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x21
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x22
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x23
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x24
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x25
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x26
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x27
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x28
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x29
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x2a
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x2b
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x2c
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x2d
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x2e
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x2f
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x30
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0
, // 0x31
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0
, // 0x32
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0
, // 0x33
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0
, // 0x34
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0
, // 0x35
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0
, // 0x36
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0
, // 0x37
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0
, // 0x38
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0
, // 0x39
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0
, // 0x3a
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0
, // 0x3b
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0
, // 0x3c
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0
, // 0x3d
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0
, // 0x3e
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0
, // 0x3f
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0
, // 0x40 '@'
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,1,1,1,
  0,1,0,1,0,1,
  0,1,0,1,1,1,
  0,1,0,0,0,0,
  0,0,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x41 'A'
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,1,0,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x42 'B'
  0,0,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x43 'C'
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x44 'D'
  0,0,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x45 'E'
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x46 'F'
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x47 'G'
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,1,1,
  0,1,0,0,0,1,
  0,0,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x48 'H'
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x49 'I'
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x4a 'J'
  0,0,0,0,0,0,
  0,0,0,0,0,1,
  0,0,0,0,0,1,
  0,0,0,0,0,1,
  0,0,0,0,0,1,
  0,0,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x4b 'K'
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,1,0,
  0,1,0,1,0,0,
  0,1,1,0,0,0,
  0,1,0,1,0,0,
  0,1,0,0,1,0,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x4c 'L'
  0,0,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x4d 'M'
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,1,0,1,1,
  0,1,0,1,0,1,
  0,1,0,1,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x4e 'N'
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,0,0,1,
  0,1,0,1,0,1,
  0,1,0,0,1,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x4f 'O'
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x50 'P'
  0,0,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x51 'Q'
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,1,0,1,
  0,1,0,0,1,0,
  0,0,1,1,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x52 'R'
  0,0,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,0,
  0,1,0,1,0,0,
  0,1,0,0,1,0,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x53 'S'
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,0,
  0,0,1,1,1,0,
  0,0,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x54 'T'
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x55 'U'
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x56 'V'
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,0,1,0,
  0,0,1,0,1,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x57 'W'
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,1,0,1,
  0,1,0,1,0,1,
  0,1,0,1,0,1,
  0,0,1,0,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x58 'X'
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,0,1,0,
  0,0,0,1,0,0,
  0,0,1,0,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x59 'Y'
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,0,1,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x5a 'Z'
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,1,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,1,0,0,0,
  0,1,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x5b Left Arrow
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,1,0,0,0,
  0,1,1,1,1,1,
  0,0,1,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x5c '½'
  0,0,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,1,1,0,
  0,0,0,0,0,1,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,0,1,1,1
, // 0x5d Right Arrow
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,1,0,
  0,1,1,1,1,1,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x5e Up Arrow
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,1,1,1,0,
  0,1,0,1,0,1,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x5f '#'
  0,0,0,0,0,0,
  0,0,1,0,1,0,
  0,0,1,0,1,0,
  0,1,1,1,1,1,
  0,0,1,0,1,0,
  0,1,1,1,1,1,
  0,0,1,0,1,0,
  0,0,1,0,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x60
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1
, // 0x61
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1
, // 0x62
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1
, // 0x63
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1
, // 0x64
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1
, // 0x65
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1
, // 0x66
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1
, // 0x67
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1
, // 0x68
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1
, // 0x69
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1
, // 0x6a
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1
, // 0x6b
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1
, // 0x6c
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1
, // 0x6d
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1
, // 0x6e
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1
, // 0x6f
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1
, // 0x70
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1
, // 0x71
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1
, // 0x72
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1
, // 0x73
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1
, // 0x74
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1
, // 0x75
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1
, // 0x76
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1
, // 0x77
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1
, // 0x78
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1
, // 0x79
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1
, // 0x7a
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1
, // 0x7b
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1
, // 0x7c
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1
, // 0x7d
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1
, // 0x7e
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1
, // 0x7f
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1
};

/* Separated Graphics Character Set */

static uint8_t teletext_separated_graphics[96*60]={
  // Character ' ' (32)
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '!' (33)
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '"' (34)
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '#' (35)
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '$' (36)
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '%' (37)
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '&' (38)
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character ''' (39)
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '(' (40)
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character ')' (41)
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '*' (42)
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '+' (43)
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character ',' (44)
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '-' (45)
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '.' (46)
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '/' (47)
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '0' (48)
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0
,
  // Character '1' (49)
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0
,
  // Character '2' (50)
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0
,
  // Character '3' (51)
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0
,
  // Character '4' (52)
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0
,
  // Character '5' (53)
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0
,
  // Character '6' (54)
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0
,
  // Character '7' (55)
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0
,
  // Character '8' (56)
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0
,
  // Character '9' (57)
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0
,
  // Character ':' (58)
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0
,
  // Character ';' (59)
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0
,
  // Character '<' (60)
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0
,
  // Character '=' (61)
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0
,
  // Character '>' (62)
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0
,
  // Character '?' (63)
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0
,
  // Character '@' (64)
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,1,1,1,
  0,1,0,1,0,1,
  0,1,0,1,1,1,
  0,1,0,0,0,0,
  0,0,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'A' (65)
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,1,0,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'B' (66)
  0,0,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'C' (67)
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'D' (68)
  0,0,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'E' (69)
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'F' (70)
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'G' (71)
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,1,1,
  0,1,0,0,0,1,
  0,0,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'H' (72)
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'I' (73)
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'J' (74)
  0,0,0,0,0,0,
  0,0,0,0,0,1,
  0,0,0,0,0,1,
  0,0,0,0,0,1,
  0,0,0,0,0,1,
  0,0,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'K' (75)
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,1,0,
  0,1,0,1,0,0,
  0,1,1,0,0,0,
  0,1,0,1,0,0,
  0,1,0,0,1,0,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'L' (76)
  0,0,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'M' (77)
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,1,0,1,1,
  0,1,0,1,0,1,
  0,1,0,1,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'N' (78)
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,0,0,1,
  0,1,0,1,0,1,
  0,1,0,0,1,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'O' (79)
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'P' (80)
  0,0,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'Q' (81)
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,1,0,1,
  0,1,0,0,1,0,
  0,0,1,1,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'R' (82)
  0,0,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,0,
  0,1,0,1,0,0,
  0,1,0,0,1,0,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'S' (83)
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,0,
  0,0,1,1,1,0,
  0,0,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'T' (84)
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'U' (85)
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'V' (86)
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,0,1,0,
  0,0,1,0,1,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'W' (87)
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,1,0,1,
  0,1,0,1,0,1,
  0,1,0,1,0,1,
  0,0,1,0,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'X' (88)
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,0,1,0,
  0,0,0,1,0,0,
  0,0,1,0,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'Y' (89)
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,0,1,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'Z' (90)
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,1,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,1,0,0,0,
  0,1,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '[' (91)
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,1,0,0,0,
  0,1,1,1,1,1,
  0,0,1,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '\' (92)
  0,0,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,1,1,0,
  0,0,0,0,0,1,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,0,1,1,1
,
  // Character ']' (93)
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,1,0,
  0,1,1,1,1,1,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '^' (94)
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,1,1,1,0,
  0,1,0,1,0,1,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '_' (95)
  0,0,0,0,0,0,
  0,0,1,0,1,0,
  0,0,1,0,1,0,
  0,1,1,1,1,1,
  0,0,1,0,1,0,
  0,1,1,1,1,1,
  0,0,1,0,1,0,
  0,0,1,0,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '`' (96)
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0
,
  // Character 'a' (97)
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0
,
  // Character 'b' (98)
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0
,
  // Character 'c' (99)
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0
,
  // Character 'd' (100)
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0
,
  // Character 'e' (101)
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0
,
  // Character 'f' (102)
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0
,
  // Character 'g' (103)
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0
,
  // Character 'h' (104)
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0
,
  // Character 'i' (105)
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0
,
  // Character 'j' (106)
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0
,
  // Character 'k' (107)
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0
,
  // Character 'l' (108)
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0
,
  // Character 'm' (109)
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0
,
  // Character 'n' (110)
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0
,
  // Character 'o' (111)
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0
,
  // Character 'p' (112)
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0
,
  // Character 'q' (113)
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0
,
  // Character 'r' (114)
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0
,
  // Character 's' (115)
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0
,
  // Character 't' (116)
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0
,
  // Character 'u' (117)
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0
,
  // Character 'v' (118)
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0
,
  // Character 'w' (119)
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0
,
  // Character 'x' (120)
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0
,
  // Character 'y' (121)
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,1,1,1,1,1,
  0,0,0,0,0,0
,
  // Character 'z' (122)
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0
,
  // Character '{' (123)
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0
,
  // Character '|' (124)
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0
,
  // Character '}' (125)
  0,1,1,0,0,0,
  0,1,1,0,0,0,
  0,0,0,0,0,0,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0
,
  // Character '~' (126)
  0,0,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0
,
  // Character 'DEL' (127)
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0,
  0,1,1,0,1,1,
  0,1,1,0,1,1,
  0,0,0,0,0,0
};

static const uint16_t brandyfont[96][20] = {
/* 20   */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 21 ! */ { 0x0000u, 0x0180u, 0x0180u, 0x0180u, 0x0180u,
             0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u,
             0x0180u, 0x0000u, 0x0000u, 0x0180u, 0x0180u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 22 " */ { 0x0000u, 0x0c60u, 0x0c60u, 0x0c60u, 0x0c60u,
             0x0c60u, 0x0c60u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 23 # */ { 0x0000u, 0x03f0u, 0x07f8u, 0x0e1cu, 0x0c0cu,
             0x0c00u, 0x0c00u, 0x3f80u, 0x3f80u, 0x0c00u,
             0x0c00u, 0x0c00u, 0x0c00u, 0x3ffcu, 0x3ffcu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 24 $ */ { 0x0000u, 0x0ff0u, 0x1ff8u, 0x399cu, 0x318cu,
             0x3180u, 0x3980u, 0x1ff0u, 0x0ff8u, 0x019cu,
             0x018cu, 0x318cu, 0x399cu, 0x1ff8u, 0x0ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 25 % */ { 0x0000u, 0x3c00u, 0x3c0cu, 0x3c1cu, 0x3c38u,
             0x0070u, 0x00e0u, 0x01c0u, 0x0380u, 0x0700u,
             0x0e00u, 0x1c3cu, 0x383cu, 0x303cu, 0x003cu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 26 & */ { 0x0000u, 0x0e00u, 0x1f00u, 0x3b80u, 0x3180u,
             0x3380u, 0x3f00u, 0x1e00u, 0x1f00u, 0x3f8cu,
             0x31dcu, 0x30f8u, 0x3878u, 0x1ffcu, 0x0ffcu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 27 ' */ { 0x0000u, 0x0180u, 0x0180u, 0x0180u, 0x0180u,
             0x0180u, 0x0180u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 28 ( */ { 0x0000u, 0x0060u, 0x00e0u, 0x01c0u, 0x0380u,
             0x0700u, 0x0600u, 0x0600u, 0x0600u, 0x0600u,
             0x0700u, 0x0380u, 0x01c0u, 0x00e0u, 0x0060u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 29 ) */ { 0x0000u, 0x0600u, 0x0700u, 0x0380u, 0x01c0u,
             0x00e0u, 0x0060u, 0x0060u, 0x0060u, 0x0060u,
             0x00e0u, 0x01c0u, 0x0380u, 0x0700u, 0x0600u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 2A * */ { 0x0000u, 0x0180u, 0x0180u, 0x318cu, 0x399cu,
             0x1ff8u, 0x0ff0u, 0x0180u, 0x0180u, 0x0ff0u,
             0x1ff8u, 0x399cu, 0x318cu, 0x0180u, 0x0180u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 2B + */ { 0x0000u, 0x0000u, 0x0000u, 0x0180u, 0x0180u,
             0x0180u, 0x0180u, 0x1ff8u, 0x1ff8u, 0x0180u,
             0x0180u, 0x0180u, 0x0180u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 2C , */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0180u, 0x0180u, 0x0180u, 0x0180u,
             0x0380u, 0x0300u, 0x0000u, 0x0000u, 0x0000u },
/* 2D - */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0ff0u, 0x0ff0u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 2E . */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0180u, 0x0180u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 2F / */ { 0x0000u, 0x0000u, 0x0018u, 0x0038u, 0x0070u,
             0x00e0u, 0x01c0u, 0x0380u, 0x0700u, 0x0e00u,
             0x1c00u, 0x1800u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 30 0 */ { 0x0000u, 0x03c0u, 0x07e0u, 0x0e70u, 0x1c38u,
             0x381cu, 0x300cu, 0x300cu, 0x300cu, 0x300cu,
             0x381cu, 0x1c38u, 0x0e70u, 0x07e0u, 0x03c0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 31 1 */ { 0x0000u, 0x0180u, 0x0180u, 0x0f80u, 0x0f80u,
             0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u,
             0x0180u, 0x0180u, 0x0180u, 0x0ff0u, 0x0ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 32 2 */ { 0x0000u, 0x0ff0u, 0x1ff8u, 0x381cu, 0x300cu,
             0x000cu, 0x001cu, 0x03f8u, 0x07f0u, 0x0e00u,
             0x1c00u, 0x3800u, 0x3000u, 0x3ffcu, 0x3ffcu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 33 3 */ { 0x0000u, 0x3ffcu, 0x3ffcu, 0x001cu, 0x0038u,
             0x0070u, 0x00e0u, 0x01f8u, 0x01fcu, 0x000cu,
             0x000cu, 0x300cu, 0x381cu, 0x1ff8u, 0x0ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 34 4 */ { 0x0000u, 0x0070u, 0x00f0u, 0x01f0u, 0x03b0u,
             0x0730u, 0x0e30u, 0x1c30u, 0x3830u, 0x3ffcu,
             0x3ffcu, 0x0030u, 0x0030u, 0x0030u, 0x0030u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 35 5 */ { 0x0000u, 0x3ffcu, 0x3ffcu, 0x3000u, 0x3000u,
             0x3ff0u, 0x3ff8u, 0x001cu, 0x000cu, 0x000cu,
             0x000cu, 0x300cu, 0x381cu, 0x1ff8u, 0x0ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 36 6 */ { 0x0000u, 0x01f0u, 0x07f0u, 0x0f00u, 0x1c00u,
             0x3800u, 0x3000u, 0x3ff0u, 0x3ff8u, 0x301cu,
             0x300cu, 0x300cu, 0x381cu, 0x1ff8u, 0x0ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 37 7 */ { 0x0000u, 0x3ffcu, 0x3ffcu, 0x000cu, 0x001cu,
             0x0038u, 0x0070u, 0x00e0u, 0x01c0u, 0x0380u,
             0x0700u, 0x0600u, 0x0600u, 0x0600u, 0x0600u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 38 8 */ { 0x0000u, 0x0ff0u, 0x1ff8u, 0x381cu, 0x300cu,
             0x300cu, 0x381cu, 0x1ff8u, 0x1ff8u, 0x381cu,
             0x300cu, 0x300cu, 0x381cu, 0x1ff8u, 0x0ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 39 9 */ { 0x0000u, 0x0ff0u, 0x1ff8u, 0x381cu, 0x300cu,
             0x300cu, 0x380cu, 0x1ffcu, 0x0ffcu, 0x000cu,
             0x001cu, 0x0038u, 0x00f0u, 0x0fe0u, 0x0f80u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 3A : */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0180u, 0x0180u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0180u, 0x0180u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 3B ; */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0180u, 0x0180u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0180u, 0x0180u, 0x0180u, 0x0180u,
             0x0380u, 0x0300u, 0x0000u, 0x0000u, 0x0000u },
/* 3C < */ { 0x0000u, 0x0060u, 0x00e0u, 0x01c0u, 0x0380u,
             0x0700u, 0x0e00u, 0x1c00u, 0x1c00u, 0x0e00u,
             0x0700u, 0x0380u, 0x01c0u, 0x00e0u, 0x0060u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 3D = */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x3ffcu, 0x3ffcu, 0x0000u, 0x0000u, 0x3ffcu,
             0x3ffcu, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 3E > */ { 0x0000u, 0x0600u, 0x0700u, 0x0380u, 0x01c0u,
             0x00e0u, 0x0070u, 0x0038u, 0x0038u, 0x0070u,
             0x00e0u, 0x01c0u, 0x0380u, 0x0700u, 0x0600u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 3F ? */ { 0x0000u, 0x0fe0u, 0x1ff0u, 0x3838u, 0x3018u,
             0x0038u, 0x0070u, 0x00e0u, 0x01c0u, 0x0180u,
             0x0180u, 0x0000u, 0x0000u, 0x0180u, 0x0180u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 40 @ */ { 0x0000u, 0x0ff0u, 0x1ff8u, 0x381cu, 0x300cu,
             0x31fcu, 0x31fcu, 0x318cu, 0x318cu, 0x31fcu,
             0x31fcu, 0x3000u, 0x3800u, 0x1ff0u, 0x0ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 41 A */ { 0x0000u, 0x0180u, 0x03c0u, 0x07e0u, 0x0e70u,
             0x1c38u, 0x381cu, 0x300cu, 0x300cu, 0x3ffcu,
             0x3ffcu, 0x300cu, 0x300cu, 0x300cu, 0x300cu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 42 B */ { 0x0000u, 0x3ff0u, 0x3ff8u, 0x301cu, 0x300cu,
             0x300cu, 0x301cu, 0x3ff8u, 0x3ff8u, 0x301cu,
             0x300cu, 0x300cu, 0x301cu, 0x3ff8u, 0x3ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 43 C */ { 0x0000u, 0x0ff0u, 0x1ff8u, 0x381cu, 0x300cu,
             0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u,
             0x3000u, 0x300cu, 0x381cu, 0x1ff8u, 0x0ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 44 D */ { 0x0000u, 0x3ff0u, 0x3ff8u, 0x301cu, 0x300cu,
             0x300cu, 0x300cu, 0x300cu, 0x300cu, 0x300cu,
             0x300cu, 0x300cu, 0x301cu, 0x3ff8u, 0x3ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 45 E */ { 0x0000u, 0x3ffcu, 0x3ffcu, 0x3000u, 0x3000u,
             0x3000u, 0x3000u, 0x3ff0u, 0x3ff0u, 0x3000u,
             0x3000u, 0x3000u, 0x3000u, 0x3ffcu, 0x3ffcu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 46 F */ { 0x0000u, 0x3ffcu, 0x3ffcu, 0x3000u, 0x3000u,
             0x3000u, 0x3000u, 0x3ff0u, 0x3ff0u, 0x3000u,
             0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 47 G */ { 0x0000u, 0x0ff0u, 0x1ff8u, 0x381cu, 0x300cu,
             0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x303cu,
             0x303cu, 0x300cu, 0x380cu, 0x1ffcu, 0x0ffcu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 48 H */ { 0x0000u, 0x300cu, 0x300cu, 0x300cu, 0x300cu,
             0x300cu, 0x300cu, 0x3ffcu, 0x3ffcu, 0x300cu,
             0x300cu, 0x300cu, 0x300cu, 0x300cu, 0x300cu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 49 I */ { 0x0000u, 0x0ff0u, 0x0ff0u, 0x0180u, 0x0180u,
             0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u,
             0x0180u, 0x0180u, 0x0180u, 0x0ff0u, 0x0ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 4A J */ { 0x0000u, 0x000cu, 0x000cu, 0x000cu, 0x000cu,
             0x000cu, 0x000cu, 0x000cu, 0x000cu, 0x000cu,
             0x000cu, 0x300cu, 0x381cu, 0x1ff8u, 0x0ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 4B K */ { 0x0000u, 0x1818u, 0x1838u, 0x1870u, 0x18e0u,
             0x19c0u, 0x1b80u, 0x1f00u, 0x1f00u, 0x1b80u,
             0x19c0u, 0x18e0u, 0x1870u, 0x1838u, 0x1818u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 4C L */ { 0x0000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u,
             0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u,
             0x3000u, 0x3000u, 0x3000u, 0x3ffcu, 0x3ffcu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 4D M */ { 0x0000u, 0x300cu, 0x300cu, 0x381cu, 0x3c3cu,
             0x3e7cu, 0x37ecu, 0x33ccu, 0x318cu, 0x318cu,
             0x300cu, 0x300cu, 0x300cu, 0x300cu, 0x300cu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 4E N */ { 0x0000u, 0x300cu, 0x300cu, 0x380cu, 0x3c0cu,
             0x3e0cu, 0x370cu, 0x338cu, 0x31ccu, 0x30ecu,
             0x307cu, 0x303cu, 0x301cu, 0x300cu, 0x300cu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 4F O */ { 0x0000u, 0x0ff0u, 0x1ff8u, 0x381cu, 0x300cu,
             0x300cu, 0x300cu, 0x300cu, 0x300cu, 0x300cu,
             0x300cu, 0x300cu, 0x381cu, 0x1ff8u, 0x0ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 50 P */ { 0x0000u, 0x3ff0u, 0x3ff8u, 0x301cu, 0x300cu,
             0x300cu, 0x301cu, 0x3ff8u, 0x3ff0u, 0x3000u,
             0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 51 Q */ { 0x0000u, 0x0ff0u, 0x1ff8u, 0x381cu, 0x300cu,
             0x300cu, 0x300cu, 0x300cu, 0x300cu, 0x30ccu,
             0x30ecu, 0x3078u, 0x3838u, 0x1ffcu, 0x0fccu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 52 R */ { 0x0000u, 0x3ff0u, 0x3ff8u, 0x301cu, 0x300cu,
             0x300cu, 0x301cu, 0x3ff8u, 0x3ff0u, 0x31c0u,
             0x30e0u, 0x3070u, 0x3038u, 0x301cu, 0x300cu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 53 S */ { 0x0000u, 0x0ff0u, 0x1ff8u, 0x381cu, 0x300cu,
             0x3000u, 0x3800u, 0x1ff0u, 0x0ff8u, 0x001cu,
             0x000cu, 0x300cu, 0x381cu, 0x1ff8u, 0x0ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 54 T */ { 0x0000u, 0x3ffcu, 0x3ffcu, 0x0180u, 0x0180u,
             0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u,
             0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 55 U */ { 0x0000u, 0x300cu, 0x300cu, 0x300cu, 0x300cu,
             0x300cu, 0x300cu, 0x300cu, 0x300cu, 0x300cu,
             0x300cu, 0x300cu, 0x381cu, 0x1ff8u, 0x0ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 56 V */ { 0x0000u, 0x300cu, 0x300cu, 0x300cu, 0x300cu,
             0x381cu, 0x1818u, 0x1c38u, 0x0c30u, 0x0e70u,
             0x07e0u, 0x03c0u, 0x03c0u, 0x0180u, 0x0180u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 57 W */ { 0x0000u, 0x300cu, 0x300cu, 0x300cu, 0x300cu,
             0x300cu, 0x300cu, 0x318cu, 0x318cu, 0x318cu,
             0x318cu, 0x318cu, 0x3ffcu, 0x1ff8u, 0x0e70u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 58 X */ { 0x0000u, 0x300cu, 0x300cu, 0x381cu, 0x1c38u,
             0x0e70u, 0x07e0u, 0x03c0u, 0x03c0u, 0x07e0u,
             0x0e70u, 0x1c38u, 0x381cu, 0x300cu, 0x300cu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 59 Y */ { 0x0000u, 0x300cu, 0x300cu, 0x381cu, 0x1c38u,
             0x0e70u, 0x07e0u, 0x03c0u, 0x0180u, 0x0180u,
             0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 5A Z */ { 0x0000u, 0x3ffcu, 0x3ffcu, 0x001cu, 0x0038u,
             0x0070u, 0x00e0u, 0x01c0u, 0x0380u, 0x0700u,
             0x0e00u, 0x1c00u, 0x3800u, 0x3ffcu, 0x3ffcu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 5B [ */ { 0x0000u, 0x0000u, 0x0000u, 0x0300u, 0x0700u,
             0x0e00u, 0x1c00u, 0x3ffcu, 0x3ffcu, 0x1c00u,
             0x0e00u, 0x0700u, 0x0300u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 5C \ */ { 0x0000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u,
             0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x31f0u,
             0x31f8u, 0x000cu, 0x000cu, 0x0018u, 0x0070u,
             0x00c0u, 0x0180u, 0x01fcu, 0x01fcu, 0x0000u },
/* 5D ] */ { 0x0000u, 0x0000u, 0x0000u, 0x00c0u, 0x00e0u,
             0x0070u, 0x0038u, 0x3ffcu, 0x3ffcu, 0x0038u,
             0x0070u, 0x00e0u, 0x00c0u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 5E ^ */ { 0x0000u, 0x0000u, 0x0000u, 0x0180u, 0x03c0u,
             0x07e0u, 0x0ff0u, 0x1db8u, 0x1998u, 0x0180u,
             0x0180u, 0x0180u, 0x0180u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 5F _ */ { 0x0000u, 0x0630u, 0x0630u, 0x0630u, 0x0630u,
             0x1ffcu, 0x1ffcu, 0x0630u, 0x0630u, 0x1ffcu,
             0x1ffcu, 0x0630u, 0x0630u, 0x0630u, 0x0630u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 60 ` */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x3ffcu, 0x3ffcu, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 61 a */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x1ff0u, 0x1ff8u, 0x001cu, 0x000cu, 0x1ffcu,
             0x3ffcu, 0x300cu, 0x300cu, 0x3ffcu, 0x1ffcu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 62 b */ { 0x0000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u,
             0x3ff0u, 0x3ff8u, 0x301cu, 0x300cu, 0x300cu,
             0x300cu, 0x300cu, 0x301cu, 0x3ff8u, 0x3ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 63 c */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0ffcu, 0x1ffcu, 0x3800u, 0x3000u, 0x3000u,
             0x3000u, 0x3000u, 0x3800u, 0x1ffcu, 0x0ffcu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 64 d */ { 0x0000u, 0x000cu, 0x000cu, 0x000cu, 0x000cu,
             0x0ffcu, 0x1ffcu, 0x380cu, 0x300cu, 0x300cu,
             0x300cu, 0x300cu, 0x380cu, 0x1ffcu, 0x0ffcu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 65 e */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0ff0u, 0x1ff8u, 0x381cu, 0x300cu, 0x3ffcu,
             0x3ffcu, 0x3000u, 0x3800u, 0x1ff8u, 0x0ff8u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 66 f */ { 0x0000u, 0x0030u, 0x00f0u, 0x01c0u, 0x0180u,
             0x0180u, 0x0180u, 0x0ff0u, 0x0ff0u, 0x0180u,
             0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 67 g */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0ffcu, 0x1ffcu, 0x380cu, 0x300cu, 0x300cu,
             0x300cu, 0x300cu, 0x380cu, 0x1ffcu, 0x0ffcu,
             0x000cu, 0x001cu, 0x0ff8u, 0x0ff0u, 0x0000u },
/* 68 h */ { 0x0000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u,
             0x3ff0u, 0x3ff8u, 0x301cu, 0x300cu, 0x300cu,
             0x300cu, 0x300cu, 0x300cu, 0x300cu, 0x300cu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 69 i */ { 0x0000u, 0x0180u, 0x0180u, 0x0000u, 0x0000u,
             0x0f80u, 0x0f80u, 0x0180u, 0x0180u, 0x0180u,
             0x0180u, 0x0180u, 0x0180u, 0x0ff0u, 0x0ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 6A j */ { 0x0000u, 0x0180u, 0x0180u, 0x0000u, 0x0000u,
             0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u,
             0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u,
             0x0180u, 0x0380u, 0x0f00u, 0x0c00u, 0x0000u },
/* 6B k */ { 0x0000u, 0x1800u, 0x1800u, 0x1800u, 0x1800u,
             0x1818u, 0x1838u, 0x18f0u, 0x1bc0u, 0x1f80u,
             0x1f80u, 0x19c0u, 0x18f0u, 0x1838u, 0x1818u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 6C l */ { 0x0000u, 0x0f80u, 0x0f80u, 0x0180u, 0x0180u,
             0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u,
             0x0180u, 0x0180u, 0x0180u, 0x0ff0u, 0x0ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 6D m */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x3e30u, 0x3ff8u, 0x33fcu, 0x318cu, 0x318cu,
             0x318cu, 0x318cu, 0x318cu, 0x318cu, 0x318cu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 6E n */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x3ff0u, 0x3ff8u, 0x301cu, 0x300cu, 0x300cu,
             0x300cu, 0x300cu, 0x300cu, 0x300cu, 0x300cu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 6F o */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0ff0u, 0x1ff8u, 0x381cu, 0x300cu, 0x300cu,
             0x300cu, 0x300cu, 0x381cu, 0x1ff8u, 0x0ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 70 p */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x3ff0u, 0x3ff8u, 0x301cu, 0x300cu, 0x300cu,
             0x300cu, 0x300cu, 0x301cu, 0x3ff8u, 0x3ff0u,
             0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x0000u },
/* 71 q */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0ffcu, 0x1ffcu, 0x380cu, 0x300cu, 0x300cu,
             0x300cu, 0x300cu, 0x380cu, 0x1ffcu, 0x0ffcu,
             0x000cu, 0x000cu, 0x000cu, 0x000cu, 0x0000u },
/* 72 r */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x31fcu, 0x33fcu, 0x3e00u, 0x3c00u, 0x3000u,
             0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 73 s */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0ffcu, 0x1ffcu, 0x3000u, 0x3000u, 0x1ff0u,
             0x0ff8u, 0x000cu, 0x000cu, 0x3ff8u, 0x3ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 74 t */ { 0x0000u, 0x0180u, 0x0180u, 0x0180u, 0x0180u,
             0x0ff0u, 0x0ff0u, 0x0180u, 0x0180u, 0x0180u,
             0x0180u, 0x0180u, 0x01c0u, 0x00f0u, 0x0030u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 75 u */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x300cu, 0x300cu, 0x300cu, 0x300cu, 0x300cu,
             0x300cu, 0x300cu, 0x380cu, 0x1ffcu, 0x0ffcu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 76 v */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x300cu, 0x300cu, 0x300cu, 0x381cu, 0x1818u,
             0x1c38u, 0x0e70u, 0x07e0u, 0x03c0u, 0x0180u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 77 w */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x300cu, 0x300cu, 0x300cu, 0x300cu, 0x318cu,
             0x318cu, 0x318cu, 0x3ffcu, 0x1ff8u, 0x0e70u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 78 x */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x300cu, 0x381cu, 0x1e78u, 0x0ff0u, 0x03c0u,
             0x03c0u, 0x0ff0u, 0x1e78u, 0x381cu, 0x300cu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 79 y */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x300cu, 0x300cu, 0x300cu, 0x300cu, 0x300cu,
             0x300cu, 0x300cu, 0x380cu, 0x1ffcu, 0x0ffcu,
             0x000cu, 0x001cu, 0x0ff8u, 0x0ff0u, 0x0000u },
/* 7A z */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x3ffcu, 0x3ffcu, 0x0038u, 0x00f0u, 0x01e0u,
             0x0780u, 0x0f00u, 0x1c00u, 0x3ffcu, 0x3ffcu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 7B { */ { 0x0000u, 0x1800u, 0x1800u, 0x1800u, 0x1800u,
             0x1800u, 0x1800u, 0x1800u, 0x1800u, 0x1818u,
             0x1838u, 0x00f8u, 0x0198u, 0x0318u, 0x0318u,
             0x03f8u, 0x03f8u, 0x0018u, 0x0018u, 0x0000u },
/* 7C | */ { 0x0000u, 0x0c60u, 0x0c60u, 0x0c60u, 0x0c60u,
             0x0c60u, 0x0c60u, 0x0c60u, 0x0c60u, 0x0c60u,
             0x0c60u, 0x0c60u, 0x0c60u, 0x0c60u, 0x0c60u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 7D } */ { 0x0000u, 0x3e00u, 0x3f00u, 0x0180u, 0x0180u,
             0x3f00u, 0x3f00u, 0x0180u, 0x0180u, 0x3f0cu,
             0x3e1cu, 0x007cu, 0x00ccu, 0x018cu, 0x018cu,
             0x01fcu, 0x01fcu, 0x000cu, 0x000cu, 0x0000u },
/* 7E ~ */ { 0x0000u, 0x0000u, 0x0000u, 0x0180u, 0x0180u,
             0x0000u, 0x0000u, 0x3ffcu, 0x3ffcu, 0x0000u,
             0x0000u, 0x0180u, 0x0180u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 7F   */ { 0x0000u, 0x3ffcu, 0x3ffcu, 0x3ffcu, 0x3ffcu,
             0x3ffcu, 0x3ffcu, 0x3ffcu, 0x3ffcu, 0x3ffcu,
             0x3ffcu, 0x3ffcu, 0x3ffcu, 0x3ffcu, 0x3ffcu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u }
};

static const uint16_t sdlfont[96][20] = {
/* 20   */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 21 ! */ { 0x0000u, 0x0180u, 0x0180u, 0x0180u, 0x0180u,
             0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u,
             0x0180u, 0x0000u, 0x0000u, 0x0180u, 0x0180u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 22 " */ { 0x0000u, 0x0e70u, 0x0e70u, 0x0e70u, 0x0e70u,
             0x0e70u, 0x0e70u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 23 # */ { 0x0000u, 0x0e70u, 0x0e70u, 0x0e70u, 0x0e70u,
             0x3ffcu, 0x3ffcu, 0x0e70u, 0x0e70u, 0x3ffcu,
             0x3ffcu, 0x0e70u, 0x0e70u, 0x0e70u, 0x0e70u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 24 $ */ { 0x0000u, 0x0ff0u, 0x1ff8u, 0x399cu, 0x318cu,
             0x3180u, 0x3980u, 0x1ff0u, 0x0ff8u, 0x019cu,
             0x018cu, 0x318cu, 0x399cu, 0x1ff8u, 0x0ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 25 % */ { 0x0000u, 0x3c00u, 0x3c0cu, 0x3c1cu, 0x3c38u,
             0x0070u, 0x00e0u, 0x01c0u, 0x0380u, 0x0700u,
             0x0e00u, 0x1c3cu, 0x383cu, 0x303cu, 0x003cu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 26 & */ { 0x0000u, 0x0e00u, 0x1f00u, 0x3b80u, 0x3180u,
             0x3b80u, 0x1f00u, 0x0e00u, 0x1f00u, 0x3b8cu,
             0x31dcu, 0x30f8u, 0x38f8u, 0x1fdcu, 0x0f8cu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 27 ' */ { 0x0000u, 0x0180u, 0x0180u, 0x0180u, 0x0180u,
             0x0180u, 0x0180u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 28 ( */ { 0x0000u, 0x0060u, 0x00e0u, 0x01c0u, 0x0380u,
             0x0700u, 0x0600u, 0x0600u, 0x0600u, 0x0600u,
             0x0700u, 0x0380u, 0x01c0u, 0x00e0u, 0x0060u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 29 ) */ { 0x0000u, 0x0600u, 0x0700u, 0x0380u, 0x01c0u,
             0x00e0u, 0x0060u, 0x0060u, 0x0060u, 0x0060u,
             0x00e0u, 0x01c0u, 0x0380u, 0x0700u, 0x0600u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 2A * */ { 0x0000u, 0x0180u, 0x0180u, 0x318cu, 0x399cu,
             0x1ff8u, 0x0ff0u, 0x0180u, 0x0180u, 0x0ff0u,
             0x1ff8u, 0x399cu, 0x318cu, 0x0180u, 0x0180u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 2B + */ { 0x0000u, 0x0000u, 0x0000u, 0x0180u, 0x0180u,
             0x0180u, 0x0180u, 0x1ff8u, 0x1ff8u, 0x0180u,
             0x0180u, 0x0180u, 0x0180u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 2C , */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0180u, 0x0180u, 0x0180u, 0x0380u,
             0x0700u, 0x0600u, 0x0000u, 0x0000u, 0x0000u },
/* 2D - */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0ff0u, 0x0ff0u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 2E . */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0180u, 0x0180u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 2F / */ { 0x0000u, 0x0000u, 0x000cu, 0x001cu, 0x0038u,
             0x0070u, 0x00e0u, 0x01c0u, 0x0380u, 0x0700u,
             0x0e00u, 0x1c00u, 0x3800u, 0x3000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 30 0 */ { 0x0000u, 0x03c0u, 0x07e0u, 0x0e70u, 0x1c38u,
             0x381cu, 0x300cu, 0x300cu, 0x300cu, 0x300cu,
             0x381cu, 0x1c38u, 0x0e70u, 0x07e0u, 0x03c0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 31 1 */ { 0x0000u, 0x0180u, 0x0180u, 0x0f80u, 0x0f80u,
             0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u,
             0x0180u, 0x0180u, 0x0180u, 0x0ff0u, 0x0ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 32 2 */ { 0x0000u, 0x0ff0u, 0x1ff8u, 0x381cu, 0x300cu,
             0x000cu, 0x001cu, 0x03f8u, 0x07f0u, 0x0e00u,
             0x1c00u, 0x3800u, 0x3000u, 0x3ffcu, 0x3ffcu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 33 3 */ { 0x0000u, 0x3ffcu, 0x3ffcu, 0x001cu, 0x0038u,
             0x0070u, 0x00e0u, 0x01f8u, 0x01fcu, 0x000cu,
             0x000cu, 0x300cu, 0x381cu, 0x1ff8u, 0x0ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 34 4 */ { 0x0000u, 0x0070u, 0x00f0u, 0x01f0u, 0x03b0u,
             0x0730u, 0x0e30u, 0x1c30u, 0x3830u, 0x3ffcu,
             0x3ffcu, 0x0030u, 0x0030u, 0x0030u, 0x0030u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 35 5 */ { 0x0000u, 0x3ffcu, 0x3ffcu, 0x3000u, 0x3000u,
             0x3ff0u, 0x3ff8u, 0x001cu, 0x000cu, 0x000cu,
             0x000cu, 0x300cu, 0x381cu, 0x1ff8u, 0x0ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 36 6 */ { 0x0000u, 0x01f0u, 0x07f0u, 0x0f00u, 0x1c00u,
             0x3800u, 0x3000u, 0x3ff0u, 0x3ff8u, 0x301cu,
             0x300cu, 0x300cu, 0x381cu, 0x1ff8u, 0x0ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 37 7 */ { 0x0000u, 0x3ffcu, 0x3ffcu, 0x000cu, 0x001cu,
             0x0038u, 0x0070u, 0x00e0u, 0x01c0u, 0x0380u,
             0x0700u, 0x0600u, 0x0600u, 0x0600u, 0x0600u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 38 8 */ { 0x0000u, 0x0ff0u, 0x1ff8u, 0x381cu, 0x300cu,
             0x300cu, 0x381cu, 0x1ff8u, 0x1ff8u, 0x381cu,
             0x300cu, 0x300cu, 0x381cu, 0x1ff8u, 0x0ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 39 9 */ { 0x0000u, 0x0ff0u, 0x1ff8u, 0x381cu, 0x300cu,
             0x300cu, 0x380cu, 0x1ffcu, 0x0ffcu, 0x000cu,
             0x001cu, 0x0038u, 0x00f0u, 0x0fe0u, 0x0f80u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 3A : */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0180u, 0x0180u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0180u, 0x0180u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 3B ; */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0180u, 0x0180u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0180u, 0x0180u, 0x0180u, 0x0380u,
             0x0700u, 0x0600u, 0x0000u, 0x0000u, 0x0000u },
/* 3C < */ { 0x0000u, 0x0060u, 0x00e0u, 0x01c0u, 0x0380u,
             0x0700u, 0x0e00u, 0x1c00u, 0x1c00u, 0x0e00u,
             0x0700u, 0x0380u, 0x01c0u, 0x00e0u, 0x0060u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 3D = */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x3ffcu, 0x3ffcu, 0x0000u, 0x0000u, 0x3ffcu,
             0x3ffcu, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 3E > */ { 0x0000u, 0x0600u, 0x0700u, 0x0380u, 0x01c0u,
             0x00e0u, 0x0070u, 0x0038u, 0x0038u, 0x0070u,
             0x00e0u, 0x01c0u, 0x0380u, 0x0700u, 0x0600u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 3F ? */ { 0x0000u, 0x0fe0u, 0x1ff0u, 0x3838u, 0x3018u,
             0x0038u, 0x0070u, 0x00e0u, 0x01c0u, 0x0180u,
             0x0180u, 0x0000u, 0x0000u, 0x0180u, 0x0180u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 40 @ */ { 0x0000u, 0x0ff0u, 0x1ff8u, 0x381cu, 0x300cu,
             0x31fcu, 0x31fcu, 0x318cu, 0x318cu, 0x31fcu,
             0x31fcu, 0x3000u, 0x3800u, 0x1ff0u, 0x0ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 41 A */ { 0x0000u, 0x0180u, 0x03c0u, 0x07e0u, 0x0e70u,
             0x1c38u, 0x381cu, 0x300cu, 0x300cu, 0x3ffcu,
             0x3ffcu, 0x300cu, 0x300cu, 0x300cu, 0x300cu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 42 B */ { 0x0000u, 0x3ff0u, 0x3ff8u, 0x301cu, 0x300cu,
             0x300cu, 0x301cu, 0x3ff8u, 0x3ff8u, 0x301cu,
             0x300cu, 0x300cu, 0x301cu, 0x3ff8u, 0x3ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 43 C */ { 0x0000u, 0x0ff0u, 0x1ff8u, 0x381cu, 0x300cu,
             0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u,
             0x3000u, 0x300cu, 0x381cu, 0x1ff8u, 0x0ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 44 D */ { 0x0000u, 0x3ff0u, 0x3ff8u, 0x301cu, 0x300cu,
             0x300cu, 0x300cu, 0x300cu, 0x300cu, 0x300cu,
             0x300cu, 0x300cu, 0x301cu, 0x3ff8u, 0x3ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 45 E */ { 0x0000u, 0x3ffcu, 0x3ffcu, 0x3000u, 0x3000u,
             0x3000u, 0x3000u, 0x3ff0u, 0x3ff0u, 0x3000u,
             0x3000u, 0x3000u, 0x3000u, 0x3ffcu, 0x3ffcu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 46 F */ { 0x0000u, 0x3ffcu, 0x3ffcu, 0x3000u, 0x3000u,
             0x3000u, 0x3000u, 0x3ff0u, 0x3ff0u, 0x3000u,
             0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 47 G */ { 0x0000u, 0x0ff0u, 0x1ff8u, 0x381cu, 0x300cu,
             0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x303cu,
             0x303cu, 0x300cu, 0x380cu, 0x1ffcu, 0x0ffcu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 48 H */ { 0x0000u, 0x300cu, 0x300cu, 0x300cu, 0x300cu,
             0x300cu, 0x300cu, 0x3ffcu, 0x3ffcu, 0x300cu,
             0x300cu, 0x300cu, 0x300cu, 0x300cu, 0x300cu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 49 I */ { 0x0000u, 0x0ff0u, 0x0ff0u, 0x0180u, 0x0180u,
             0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u,
             0x0180u, 0x0180u, 0x0180u, 0x0ff0u, 0x0ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 4A J */ { 0x0000u, 0x000cu, 0x000cu, 0x000cu, 0x000cu,
             0x000cu, 0x000cu, 0x000cu, 0x000cu, 0x000cu,
             0x000cu, 0x300cu, 0x381cu, 0x1ff8u, 0x0ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 4B K */ { 0x0000u, 0x3018u, 0x3038u, 0x3070u, 0x30e0u,
             0x31c0u, 0x3380u, 0x3f00u, 0x3f00u, 0x3380u,
             0x31c0u, 0x30e0u, 0x3070u, 0x3038u, 0x3018u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 4C L */ { 0x0000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u,
             0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u,
             0x3000u, 0x3000u, 0x3000u, 0x3ffcu, 0x3ffcu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 4D M */ { 0x0000u, 0x300cu, 0x300cu, 0x381cu, 0x3c3cu,
             0x3e7cu, 0x37ecu, 0x33ccu, 0x318cu, 0x318cu,
             0x300cu, 0x300cu, 0x300cu, 0x300cu, 0x300cu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 4E N */ { 0x0000u, 0x300cu, 0x300cu, 0x380cu, 0x3c0cu,
             0x3e0cu, 0x370cu, 0x338cu, 0x31ccu, 0x30ecu,
             0x307cu, 0x303cu, 0x301cu, 0x300cu, 0x300cu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 4F O */ { 0x0000u, 0x0ff0u, 0x1ff8u, 0x381cu, 0x300cu,
             0x300cu, 0x300cu, 0x300cu, 0x300cu, 0x300cu,
             0x300cu, 0x300cu, 0x381cu, 0x1ff8u, 0x0ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 50 P */ { 0x0000u, 0x3ff0u, 0x3ff8u, 0x301cu, 0x300cu,
             0x300cu, 0x301cu, 0x3ff8u, 0x3ff0u, 0x3000u,
             0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 51 Q */ { 0x0000u, 0x0ff0u, 0x1ff8u, 0x381cu, 0x300cu,
             0x300cu, 0x300cu, 0x300cu, 0x300cu, 0x30ccu,
             0x30ecu, 0x3078u, 0x3838u, 0x1ffcu, 0x0fccu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 52 R */ { 0x0000u, 0x3ff0u, 0x3ff8u, 0x301cu, 0x300cu,
             0x300cu, 0x301cu, 0x3ff8u, 0x3ff0u, 0x31c0u,
             0x30e0u, 0x3070u, 0x3038u, 0x301cu, 0x300cu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 53 S */ { 0x0000u, 0x0ff0u, 0x1ff8u, 0x381cu, 0x300cu,
             0x3000u, 0x3800u, 0x1ff0u, 0x0ff8u, 0x001cu,
             0x000cu, 0x300cu, 0x381cu, 0x1ff8u, 0x0ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 54 T */ { 0x0000u, 0x3ffcu, 0x3ffcu, 0x0180u, 0x0180u,
             0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u,
             0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 55 U */ { 0x0000u, 0x300cu, 0x300cu, 0x300cu, 0x300cu,
             0x300cu, 0x300cu, 0x300cu, 0x300cu, 0x300cu,
             0x300cu, 0x300cu, 0x381cu, 0x1ff8u, 0x0ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 56 V */ { 0x0000u, 0x300cu, 0x300cu, 0x300cu, 0x300cu,
             0x381cu, 0x1818u, 0x1c38u, 0x0c30u, 0x0e70u,
             0x07e0u, 0x03c0u, 0x03c0u, 0x0180u, 0x0180u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 57 W */ { 0x0000u, 0x300cu, 0x300cu, 0x300cu, 0x300cu,
             0x300cu, 0x300cu, 0x318cu, 0x318cu, 0x318cu,
             0x318cu, 0x318cu, 0x3ffcu, 0x1ff8u, 0x0e70u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 58 X */ { 0x0000u, 0x300cu, 0x300cu, 0x381cu, 0x1c38u,
             0x0e70u, 0x07e0u, 0x03c0u, 0x03c0u, 0x07e0u,
             0x0e70u, 0x1c38u, 0x381cu, 0x300cu, 0x300cu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 59 Y */ { 0x0000u, 0x300cu, 0x300cu, 0x381cu, 0x1c38u,
             0x0e70u, 0x07e0u, 0x03c0u, 0x0180u, 0x0180u,
             0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 5A Z */ { 0x0000u, 0x3ffcu, 0x3ffcu, 0x001cu, 0x0038u,
             0x0070u, 0x00e0u, 0x01c0u, 0x0380u, 0x0700u,
             0x0e00u, 0x1c00u, 0x3800u, 0x3ffcu, 0x3ffcu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 5B [ */ { 0x0000u, 0x07e0u, 0x07e0u, 0x0600u, 0x0600u,
             0x0600u, 0x0600u, 0x0600u, 0x0600u, 0x0600u,
             0x0600u, 0x0600u, 0x0600u, 0x07e0u, 0x07e0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 5C \ */ { 0x0000u, 0x0000u, 0x3000u, 0x3800u, 0x1c00u,
             0x0e00u, 0x0700u, 0x0380u, 0x01c0u, 0x00e0u,
             0x0070u, 0x0038u, 0x001cu, 0x000cu, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 5D ] */ { 0x0000u, 0x07e0u, 0x07e0u, 0x0060u, 0x0060u,
             0x0060u, 0x0060u, 0x0060u, 0x0060u, 0x0060u,
             0x0060u, 0x0060u, 0x0060u, 0x07e0u, 0x07e0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 5E ^ */ { 0x0000u, 0x0180u, 0x03c0u, 0x07e0u, 0x0e70u,
             0x1c38u, 0x1818u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 5F _ */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0xffffu, 0xffffu, 0x0000u, 0x0000u },
/* 60 ` */ { 0x0000u, 0x0600u, 0x0700u, 0x0380u, 0x01c0u,
             0x00e0u, 0x0060u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 61 a */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0ff0u, 0x0ff8u, 0x001cu, 0x000cu, 0x1ffcu,
             0x3ffcu, 0x300cu, 0x300cu, 0x3ffcu, 0x1ffcu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 62 b */ { 0x0000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u,
             0x3ff0u, 0x3ff8u, 0x301cu, 0x300cu, 0x300cu,
             0x300cu, 0x300cu, 0x301cu, 0x3ff8u, 0x3ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 63 c */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0ffcu, 0x1ffcu, 0x3800u, 0x3000u, 0x3000u,
             0x3000u, 0x3000u, 0x3800u, 0x1ffcu, 0x0ffcu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 64 d */ { 0x0000u, 0x000cu, 0x000cu, 0x000cu, 0x000cu,
             0x0ffcu, 0x1ffcu, 0x380cu, 0x300cu, 0x300cu,
             0x300cu, 0x300cu, 0x380cu, 0x1ffcu, 0x0ffcu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 65 e */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0ff0u, 0x1ff8u, 0x381cu, 0x300cu, 0x3ffcu,
             0x3ffcu, 0x3000u, 0x3800u, 0x1ff0u, 0x0ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 66 f */ { 0x0000u, 0x0030u, 0x00f0u, 0x01c0u, 0x0180u,
             0x0180u, 0x0180u, 0x0ff0u, 0x0ff0u, 0x0180u,
             0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 67 g */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0ffcu, 0x1ffcu, 0x380cu, 0x300cu, 0x300cu,
             0x300cu, 0x300cu, 0x380cu, 0x1ffcu, 0x0ffcu,
             0x000cu, 0x001cu, 0x0ff8u, 0x0ff0u, 0x0000u },
/* 68 h */ { 0x0000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u,
             0x3ff0u, 0x3ff8u, 0x301cu, 0x300cu, 0x300cu,
             0x300cu, 0x300cu, 0x300cu, 0x300cu, 0x300cu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 69 i */ { 0x0000u, 0x0180u, 0x0180u, 0x0000u, 0x0000u,
             0x0f80u, 0x0f80u, 0x0180u, 0x0180u, 0x0180u,
             0x0180u, 0x0180u, 0x0180u, 0x0ff0u, 0x0ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 6A j */ { 0x0000u, 0x0180u, 0x0180u, 0x0000u, 0x0000u,
             0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u,
             0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u,
             0x0180u, 0x0380u, 0x0f00u, 0x0c00u, 0x0000u },
/* 6B k */ { 0x0000u, 0x0c00u, 0x0c00u, 0x0c00u, 0x0c18u,
             0x0c38u, 0x0c70u, 0x0ce0u, 0x0fc0u, 0x0f80u,
             0x0dc0u, 0x0ce0u, 0x0c70u, 0x0c38u, 0x0c18u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 6C l */ { 0x0000u, 0x0f80u, 0x0f80u, 0x0180u, 0x0180u,
             0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u,
             0x0180u, 0x0180u, 0x0180u, 0x0ff0u, 0x0ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 6D m */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x3e30u, 0x3ff8u, 0x33fcu, 0x318cu, 0x318cu,
             0x318cu, 0x318cu, 0x318cu, 0x318cu, 0x318cu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 6E n */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x3ff0u, 0x3ff8u, 0x301cu, 0x300cu, 0x300cu,
             0x300cu, 0x300cu, 0x300cu, 0x300cu, 0x300cu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 6F o */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0ff0u, 0x1ff8u, 0x381cu, 0x300cu, 0x300cu,
             0x300cu, 0x300cu, 0x381cu, 0x1ff8u, 0x0ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 70 p */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x3ff0u, 0x3ff8u, 0x301cu, 0x300cu, 0x300cu,
             0x300cu, 0x300cu, 0x301cu, 0x3ff8u, 0x3ff0u,
             0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x0000u },
/* 71 q */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0ffcu, 0x1ffcu, 0x380cu, 0x300cu, 0x300cu,
             0x300cu, 0x300cu, 0x380cu, 0x1ffcu, 0x0ffcu,
             0x000cu, 0x000cu, 0x000cu, 0x000cu, 0x0000u },
/* 72 r */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x19f8u, 0x1bf8u, 0x1f00u, 0x1e00u, 0x1800u,
             0x1800u, 0x1800u, 0x1800u, 0x1800u, 0x1800u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 73 s */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0ffcu, 0x1ffcu, 0x3000u, 0x3000u, 0x1ff0u,
             0x0ff8u, 0x000cu, 0x000cu, 0x3ff8u, 0x3ff0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 74 t */ { 0x0000u, 0x0180u, 0x0180u, 0x0180u, 0x0180u,
             0x0ff0u, 0x0ff0u, 0x0180u, 0x0180u, 0x0180u,
             0x0180u, 0x0180u, 0x01c0u, 0x00f0u, 0x0030u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 75 u */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x300cu, 0x300cu, 0x300cu, 0x300cu, 0x300cu,
             0x300cu, 0x300cu, 0x380cu, 0x1ffcu, 0x0ffcu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 76 v */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x300cu, 0x300cu, 0x300cu, 0x381cu, 0x1818u,
             0x1c38u, 0x0e70u, 0x07e0u, 0x03c0u, 0x0180u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 77 w */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x300cu, 0x300cu, 0x300cu, 0x300cu, 0x318cu,
             0x318cu, 0x318cu, 0x3ffcu, 0x1ff8u, 0x0e70u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 78 x */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x300cu, 0x381cu, 0x1e78u, 0x0ff0u, 0x03c0u,
             0x03c0u, 0x0ff0u, 0x1e78u, 0x381cu, 0x300cu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 79 y */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x300cu, 0x300cu, 0x300cu, 0x300cu, 0x300cu,
             0x300cu, 0x300cu, 0x380cu, 0x1ffcu, 0x0ffcu,
             0x000cu, 0x001cu, 0x0ff8u, 0x0ff0u, 0x0000u },
/* 7A z */ { 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x3ffcu, 0x3ffcu, 0x0038u, 0x0070u, 0x01e0u,
             0x0780u, 0x0e00u, 0x1c00u, 0x3ffcu, 0x3ffcu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 7B { */ { 0x0000u, 0x00f0u, 0x01f0u, 0x0180u, 0x0180u,
             0x0380u, 0x0300u, 0x0f00u, 0x0f00u, 0x0300u,
             0x0380u, 0x0180u, 0x0180u, 0x00f0u, 0x00f0u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 7C | */ { 0x0000u, 0x0180u, 0x0180u, 0x0180u, 0x0180u,
             0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u,
             0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 7D } */ { 0x0000u, 0x0f00u, 0x0f80u, 0x0180u, 0x0180u,
             0x01c0u, 0x00c0u, 0x00f0u, 0x00f0u, 0x00c0u,
             0x01c0u, 0x0180u, 0x0180u, 0x0f00u, 0x0f00u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 7E ~ */ { 0x0000u, 0x0e00u, 0x1f0cu, 0x3bdcu, 0x31f8u,
             0x0070u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u },
/* 7F   */ { 0x0000u, 0x0180u, 0x03c0u, 0x03c0u, 0x0660u,
             0x0660u, 0x0c30u, 0x0c30u, 0x1818u, 0x1818u,
             0x300cu, 0x300cu, 0x300cu, 0x3ffcu, 0x3ffcu,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u }
};

/*Mode 7 (SAA5050)*/
static uint8_t *mode7_chars, *mode7_charsi, *mode7_graph, *mode7_graphi, *mode7_sepgraph, *mode7_sepgraphi, *mode7_tempi, *mode7_tempi2;

static void decode_row(uint8_t *dest, unsigned bits)
{
    for (int c = 0; c < 16; c++) {
        *dest++ = (bits & 0x8000) ? 15 : 0;
        bits <<= 1;
    }
}

static void generate_contig(uint8_t *dest, unsigned int ch, unsigned int y)
{
    unsigned left = 0xff00u;
    unsigned right = 0x00ffu;
    unsigned bits = 0;
    if ((y >= 0) && (y <= 5)) {
        if (ch & 1) bits = left;
        if (ch & 2) bits += right;
    }
    else if ((y >= 6) && (y <= 13)) {
        if (ch & 4) bits = left;
        if (ch & 8) bits += right;
    }
    else if ((y >= 14) && (y <= 19)) {
        if (ch & 16) bits = left;
        if (ch & 64) bits += right;
    }
    decode_row(dest, bits);
}

static void generate_balanced(uint8_t *dest, unsigned int ch, unsigned int y)
{
    unsigned bits = 0;
    unsigned left = 0x7e00u;
    unsigned right = 0x007eu;
    if ((y >= 1) && (y <= 4)) {
        if (ch & 1) bits = left;
        if (ch & 2) bits += right;
    }
    else if ((y >= 7) && (y <= 12)) {
        if (ch & 4) bits = left;
        if (ch & 8) bits += right;
    }
    else if ((y >= 15) && (y <= 18)) {
        if (ch & 16) bits = left;
        if (ch & 64) bits += right;
    }
    decode_row(dest, bits);
}

static void generate_right(uint8_t *dest, unsigned int ch, unsigned int y)
{
    unsigned bits = 0;
    unsigned left = 0x3f00u;
    unsigned right = 0x003fu;
    if ((y >= 0) && (y <= 3)) {
        if (ch & 1) bits = left;
        if (ch & 2) bits += right;
    }
    else if ((y >= 6) && (y <= 11)) {
        if (ch & 4) bits = left;
        if (ch & 8) bits += right;
    }
    else if ((y >= 14) && (y <= 17)) {
        if (ch & 16) bits = left;
        if (ch & 64) bits += right;
    }
    decode_row(dest, bits);
}

static void generate_gchars(int right, int ch)
{
    int offs = (ch - 0x20) * 160;
    for (int line = 0; line < 20; line += 2) {
        generate_contig(mode7_graph + offs, ch, line);
        generate_contig(mode7_graphi + offs, ch, line+1);
        if (right) {
            generate_right(mode7_sepgraph + offs, ch, line);
            generate_right(mode7_sepgraphi + offs, ch, line+1);
        }
        else {
            generate_balanced(mode7_sepgraph + offs, ch, line);
            generate_balanced(mode7_sepgraphi + offs, ch, line+1);
        }
        offs += 16;
    }
}

static void generate_graphics(int right)
{
    for (int ch = 0x20; ch < 0x40; ch++)
        generate_gchars(right, ch);
    for (int ch = 0x60; ch < 0x80; ch++)
        generate_gchars(right, ch);
}

static void resample_graphics(int width)
{
    int wminus = width - 1;
    int offs1 = 0, offs2 = 0;
    for (int c = 0; c < 960; c++) {
        float x = 0;
        int x2 = 0;
        for (int d = 0; d < width; d++) {
            if (!d) {
                mode7_graph[offs2 + d] = mode7_graphi[offs2 + d] = teletext_graphics[offs1];
                mode7_sepgraph[offs2 + d] = mode7_sepgraphi[offs2 + d] = teletext_separated_graphics[offs1];
            } else if (d == wminus) {
                mode7_graph[offs2 + d] = mode7_graphi[offs2 + d] = teletext_graphics[offs1 + 5];
                mode7_sepgraph[offs2 + d] = mode7_sepgraphi[offs2 + d] = teletext_separated_graphics[offs1 + 5];
            } else {
                mode7_graph[offs2 + d] = mode7_graphi[offs2 + d] = teletext_graphics[offs1 + x2];
                mode7_sepgraph[offs2 + d] = mode7_sepgraphi[offs2 + d] = teletext_separated_graphics[offs1 + x2];
            }
            x += (5.0 / wminus);
            if (x >= 1.0) {
                x2++;
                x -= 1.0;
            }
        }
        offs1 += 6;
        offs2 += width;
    }
}

static void rearrange_font(const uint16_t font[96][20])
{
    int offs = 0;
    for (int ch = 0; ch < 0x60; ch++) {
        const unsigned short *rptr = font[ch];
        for (int row = 0; row < 10; row++) {
            decode_row(mode7_chars + offs, *rptr++);
            //feather_row(mode7_chars + offs);
            decode_row(mode7_charsi + offs, *rptr++);
            //feather_row(mode7_chars + offs);
            offs += 16;
        }
    }
}

static void round_text(uint8_t *p, uint8_t *p2)
{
    for (int c = 0; c < 96; c++) {
        for (int y = 0; y < 10; y++) {
            for (int d = 0; d < 6; d++) {
                int stat = 0;
                if (y < 9 && p[(y * 6) + d] && p[(y * 6) + d + 6])
                    stat |= 3;  /*Above + below - set both */
                if (y < 9 && d > 0 && p[(y * 6) + d] && p[(y * 6) + d + 5] && !p[(y * 6) + d - 1])
                    stat |= 1;  /*Above + left  - set left */
                if (y < 9 && d > 0 && p[(y * 6) + d + 6] && p[(y * 6) + d - 1] && !p[(y * 6) + d + 5])
                    stat |= 1;  /*Below + left  - set left */
                if (y < 9 && d < 5 && p[(y * 6) + d] && p[(y * 6) + d + 7] && !p[(y * 6) + d + 1])
                    stat |= 2;  /*Above + right - set right */
                if (y < 9 && d < 5 && p[(y * 6) + d + 6] && p[(y * 6) + d + 1] && !p[(y * 6) + d + 7])
                    stat |= 2;  /*Below + right - set right */

                p2[0] = (stat & 1) ? 15 : 0;
                p2[1] = (stat & 2) ? 15 : 0;
                p2 += 2;
            }
        }
        p += 60;
    }
}

static void resample_text(int width)
{
    int wminus = width - 1;
    int offs1 = 0, offs2 = 0;
    for (int c = 0; c < 960; c++) {
        float x = 0;
        int x2 = 0;
        for (int d = 0; d < width; d++) {
            mode7_chars[offs2 + d] = (int) (((float) mode7_tempi2[offs1 + x2] * (1.0 - x)) + ((float) mode7_tempi2[offs1 + x2 + 1] * x));
            mode7_charsi[offs2 + d] = (int) (((float) mode7_tempi[offs1 + x2] * (1.0 - x)) + ((float) mode7_tempi[offs1 + x2 + 1] * x));
            x += (11.0 / wminus);
            if (x >= 1.0) {
                x2++;
                x -= 1.0;
            }
        }
        offs1 += 12;
        offs2 += width;
    }
}

static int external_font(const char *ifn)
{
    int status;
    FILE *fp = fopen(ifn, "rb");
    if (fp) {
        status = 0;
        uint8_t *optr = mode7_tempi2; // odd field.
        uint8_t *eptr = mode7_tempi;  // even field.
        for (int ch = 0; ch < 96; ch++) {
            uint16_t glyph[18];
            if (fread(glyph, sizeof(glyph), 1, fp) == 1) {
                // Blank row at the top of the character.
                for (int col = 0; col < 12; col++) {
                    *optr++ = 0;
                    *eptr++ = 0;
                }
                for (int row = 0; row < 18; ) {
                    uint16_t bits = glyph[row++];
                    for (int col = 0; col < 12; col++) {
                        *optr++ = bits & 0x800 ? 15 : 0;
                        bits <<= 1;
                    }
                    bits = glyph[row++];
                    for (int col = 0; col < 12; col++) {
                        *eptr++ = bits & 0x800 ? 15 : 0;
                        bits <<= 1;
                    }
                }
            }
            else {
                fprintf(stderr, "m7makechars: error reading %s: %s\n", ifn, strerror(errno));
                status = 4;
                break;
            }
        }
        fclose(fp);
        resample_text(16);
    }
    else {
        fprintf(stderr, "m7makechars: unable to open %s for reading: %s\n", ifn, strerror(errno));
        status = 3;
    }
    return status;
}

static void text_blastthrough(int width)
{
    int bytes_per_char = width * 10;
    int offs = 0x20 * bytes_per_char;
    memcpy(mode7_graph + offs, mode7_chars + offs, offs);
    memcpy(mode7_graphi + offs, mode7_charsi + offs, offs);
    memcpy(mode7_sepgraph + offs, mode7_chars + offs, offs);
    memcpy(mode7_sepgraphi + offs, mode7_charsi + offs, offs);
}

static void save_bank(FILE *fp, int width, uint8_t *glyph, uint8_t *field1, uint8_t *field2)
{
    for (int ch = 0; ch < 96; ch++) {
        uint8_t *gptr = glyph;
        for (int row = 0; row < 10; row++)
            for (int col = 0; col < width; col++)
                *gptr++ = *field1++ | (*field2++ << 4);
        fwrite(glyph, 10 * width, 1, fp);
    }
}

int main(int argc, char **argv)
{
    const char *fn = "mode7chars.fnt", *ifn = NULL;
    const char *name = "";
    int status = 0;
    int brandy = 0;
    int gensix = 0;
    int sdl    = 0;
    int width  = 16;
    int right  = 0;
    int opt;

    while ((opt = getopt(argc, argv, "bge:f:n:rsw:")) != EOF) {
        switch(opt) {
            case 'b':
                brandy = 1;
                break;
            case 'g':
                gensix = 1;
                break;
            case 'e':
                ifn = optarg;
                break;
            case 'f':
                fn = optarg;
                break;
            case 'n':
                name = optarg;
                break;
            case 'r':
                right = 1;
                break;
            case 's':
                sdl = 1;
                break;
            case 'w':
                width = atoi(optarg);
                break;
            default:
                status = 1;
        }
    }
    if (status || optind != argc) {
        fputs("Usage: m7makechars [ -b ] [ -g ] [ -f file ] [ -w width ]\n", stderr);
        return 1;
    }
    if ((brandy || gensix) && width != 16) {
        fprintf(stderr, "m7makechars: ignoring width %d, using 16\n", width);
        width = 16;
    }
    int char_size = 10 * width;
    int bank_size = char_size * 96;
    int total_size = bank_size * 8 + char_size;
    uint8_t *mem = malloc(total_size);
    if (mem) {
        FILE *fp = fopen(fn, "wb");
        if (fp) {
            size_t namelen = strlen(name);
            memset(mem, 0xff, total_size);
            char hdr[11];
            memcpy(hdr, "BEMTTX01", 8);
            hdr[8] = width;
            hdr[9] = 10;
            hdr[10] = namelen;
            fwrite(hdr, sizeof(hdr), 1, fp);
            fwrite(name, namelen, 1, fp);

            mode7_chars = mem;
            mode7_charsi = mem + bank_size;
            mode7_graph = mem + bank_size * 2;
            mode7_graphi = mem + bank_size * 3;
            mode7_sepgraph = mem + bank_size * 4;
            mode7_sepgraphi = mem + bank_size * 5;
            mode7_tempi = mem + bank_size * 6;
            mode7_tempi2 = mem + bank_size * 7;

            if (gensix)
                generate_graphics(right);
            else {
                for (int c = 0; c < (96 * 60); c++)
                    teletext_graphics[c] *= 15;
                for (int c = 0; c < (96 * 60); c++)
                    teletext_separated_graphics[c] *= 15;
                resample_graphics(width);
            }
            if (brandy)
                rearrange_font(brandyfont);
            else if (sdl)
                rearrange_font(sdlfont);
            else if (ifn)
                status = external_font(ifn);
            else {
                for (int c = 0; c < (96 * 60); c++)
                    teletext_characters[c] *= 15;
                for (int c = 0; c < (96 * 120); c++)
                    mode7_tempi2[c] = teletext_characters[c >> 1];
                round_text(teletext_characters, mode7_tempi);
                resample_text(width);
            }
            text_blastthrough(width);
            uint8_t *glyph = mem + bank_size * 8;
            save_bank(fp, width, glyph, mode7_chars, mode7_charsi);
            save_bank(fp, width, glyph, mode7_graph, mode7_graphi);
            save_bank(fp, width, glyph, mode7_sepgraph, mode7_sepgraphi);
            fclose(fp);
            return 0;
        }
        else {
            fprintf(stderr, "m7makechars: unable to open %s for writing: %s", fn, strerror(errno));
            status = 2;
        }
    }
    else {
        fputs("m7makechars: out of memory\n", stderr);
        status = 3;
    }
    return status;
}
