#include "unalf.h"

FILE *in_file, *out_file;
char *in_filename;
opts_t opts;
const char *exclude_globs[MAX_EXCLUDES];
int exclude_count;
char * const *include_globs;
static void create_outdir(void);

/* like "mkdir -p" (no error if dir already exists),
    followed by "cd" (which will error if the existing
    "directory" turns out to be a file or broken symlink */
static void create_outdir(void) {
	int r;

	r =
#if defined(__MINGW32__) || defined(__MINGW64__)
		mkdir(opts.outdir);
#else
		mkdir(opts.outdir, 0777);
#endif
	if(r < 0 && errno != EEXIST) {
		fprintf(stderr, "%s: fatal: ", self);
		perror(opts.outdir);
		exit(1);
	}

	if(chdir(opts.outdir) < 0) {
		fprintf(stderr, "%s: fatal: ", self);
		perror(opts.outdir);
		exit(1);
	}
}

void usage(void) {
	extern char *usage_msg[];
	char **line;

	puts("unalf (ALF extractor) v" VERSION " by B. Watson. WTFPL.");
	printf("Usage: %s -[options] <file> [wildcard ...]\n", self);
	puts("Options:");
	puts("  wildcards: extract only matching files.");

	for(line = usage_msg; *line; line++)
		puts(*line);

	exit(0);
}

int main(int argc, char **argv) {
	set_self(argv[0]);

	if(argc < 2 || !strcmp(argv[1], "--help") || !strcmp(argv[1], "-h")) usage();

	if(!strcmp(argv[1], "--version")) {
		puts(VERSION);
		exit(0);
	}

	parse_opts(argc, argv);

	if(!(in_file = fopen(in_filename, "rb"))) {
		fprintf(stderr, "%s: fatal: ", self);
		perror(in_filename);
		exit(1);
	}

	if(opts.outdir) create_outdir();

	if(opts.listonly)
		list_alf();
	else
		extract_alf();

	fclose(in_file);

	exit(bad_checksum_count ? 2 : 0);
}
