#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <ctype.h>
#include <sys/stat.h>
#include <f65.h>
#include "self.h"
#include "u816.h"

#ifndef VERSION
#define VERSION "???"
#warning "VERSION not defined, defaulting to \"???\""
#endif

/* asmcode.c (converted from asm) */
void uncrunch_file(void);
void setup_io_bufs(void);
void L7A19(void);
void L79E7(void);
void L76D0(void);
void write_output(void);
void init_counters(void);
void store_outbyte(void);
void push_acc16(void);
void L7899(void);
void pop_acc16(void);
void L78C2(void);
void L7A19(void);
void L79E7(void);
void writeblock(void);
void L7A5D(void);

/* glob.c */
int globmatch(const char *pat, const char *arg);
int file_wanted(const char *filename);

/* io.c - asm rewritten in C */
int read_alf_header(void);
void readblock(void);
void writeblock(void);
void write_output(void);

/* io.c - just C */
void open_output(void);

/* listalf.c */
void list_alf(void);
unsigned int getquad(int offs);

/* extract.c */
extern int bad_checksum_count;
extern int new_file;
extern unsigned int bytes_written;
void extract_alf(void);
void dpoke(int addr, u16 value);
u16 dpeek(int addr);
void fix_filename(void);

/* opts.c */
void parse_opts(int argc, char * const *argv);

/* unalf.c */
extern char *self;
extern FILE *out_file;
extern FILE *in_file;
extern char *in_filename;

typedef struct {
	int txtconv;
	int testonly;
	int keepdot;
	int listonly;
	int lowercase;
	const char *outdir;
	int overwrite;
	int extract_to_stdout;
	int quiet;
	int verbose_list;
	int fixjunk;
	int ignore_datetime;
	int force;
	int extract_num;
	int split;
} opts_t;

#define MAX_EXCLUDES 256

extern opts_t opts;
extern const char *exclude_globs[MAX_EXCLUDES];
extern char * const *include_globs;
extern int exclude_count;
