# powerflex_gateway

Role to manage the installation and uninstallation of Powerflex Gateway.

## Requirements

```
ansible
python
```

## Ansible collections

Collections required to use the role.

```
dellemc.powerflex
```

## Role Variables

<table>
<thead>
  <tr>
    <th>Name</th>
    <th>Required</th>
    <th>Description</th>
    <th>Choices</th>
    <th>Type</th>
    <th>Default Value</th>
  </tr>
</thead>
<tbody>
  <tr>
    <td>powerflex_common_file_install_location</td>
    <td>false</td>
    <td>Location of installation, compatible installation software package based on the operating system of the node.
    <br> The files can be downloaded from the Dell Product support page for PowerFlex software.</td>
    <td></td>
    <td>path</td>
    <td>/var/tmp</td>
  </tr>
  <tr>
    <td>powerflex_gateway_is_redundant</td>
    <td>false</td>
    <td>Is the gateway redundant (will install keepalived).<br></td>
    <td></td>
    <td>bool</td>
    <td>false</td>
  </tr>
  <tr>
    <td>powerflex_gateway_admin_password</td>
    <td>true</td>
    <td>Admin password for the Powerflex gateway.<br></td>
    <td></td>
    <td>str</td>
    <td></td>
  </tr>
  <tr>
    <td>powerflex_gateway_http_port</td>
    <td>false</td>
    <td>Powerflex gateway HTTP port.<br></td>
    <td></td>
    <td>int</td>
    <td>80</td>
  </tr>
  <tr>
    <td>powerflex_gateway_https_port</td>
    <td>false</td>
    <td>Powerflex gateway HTTPS port.<br></td>
    <td></td>
    <td>int</td>
    <td>443</td>
  </tr>
  <tr>
    <td>powerflex_gateway_virtual_ip</td>
    <td>false</td>
    <td>Virtual IP address of Powerflex gateway.<br></td>
    <td></td>
    <td>str</td>
    <td></td>
  </tr>
  <tr>
    <td>powerflex_gateway_virtual_interface</td>
    <td>false</td>
    <td>Virtual interface of Powerflex gateway.<br></td>
    <td></td>
    <td>str</td>
    <td></td>
  </tr>
  <tr>
    <td>powerflex_gateway_state</td>
    <td>false</td>
    <td>Specify state of gateway.<br></td>
    <td>absent, present</td>
    <td>str</td>
    <td>present</td>
  </tr>
  <tr>
    <td>powerflex_gateway_skip_java</td>
    <td>false</td>
    <td>Specify whether to install the java or not.<br></td>
    <td></td>
    <td>bool</td>
    <td>false</td>
  </tr>
</tbody>
</table>

## Examples
----
```
  - name: Install and configure powerflex gateway
    ansible.builtin.import_role:
      name: powerflex_gateway
    vars:
      powerflex_common_file_install_location: "/opt/scaleio/rpm"
      powerflex_gateway_admin_password: password
      powerflex_gateway_state: present

  - name: Uninstall powerflex gateway
    ansible.builtin.import_role:
      name: powerflex_gateway
    vars:
      powerflex_gateway_state: absent

```

## Usage instructions
----
### To install all dependency packages, including gateway, on node:
  ```
  ansible-playbook -i inventory site.yml
  ```

### To uninstall gateway:
  ```
  ansible-playbook -i inventory uninstall_powerflex.yml
  ```

Sample playbooks and inventory can be found in the playbooks directory.

## Author Information
------------------

Dell Technologies <br>
Bhavneet Sharma (ansible.team@Dell.com)  2023
