#!/usr/bin/python -tt
# GNU General Public License v3.0+ (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)
# SPDX-License-Identifier: GPL-3.0-or-later
# SPDX-FileCopyrightText: Ansible Project, 2020

import os
import sys
from setuptools import find_namespace_packages, setup


__version__ = '8.7.0'
__author__ = 'Ansible, Inc.'


with open('README.rst', 'r') as f:
    long_desc = f.read()

setup(
    name='ansible',
    version=__version__,
    description='Radically simple IT automation',
    long_description=long_desc,
    author=__author__,
    author_email='info@ansible.com',
    url='https://ansible.com/',
    project_urls={
        'Bug Tracker': 'https://github.com/ansible/ansible/issues',
        'Code of Conduct': 'https://docs.ansible.com/ansible/latest/community/code_of_conduct.html',
        'Documentation': 'https://docs.ansible.com/ansible/',
        'Mailing lists': 'https://docs.ansible.com/ansible/latest/community/communication.html#mailing-list-information',
        'Source Code': 'https://github.com/ansible/ansible',
    },
    license='GPLv3+',
    python_requires='>=3.9',
    packages=find_namespace_packages(
        '.',
        include=[
            'ansible_collections',
            'ansible_collections.*',
        ],
        exclude=[
            'ansible_collections.amazon.aws.tests.*',
            'ansible_collections.amazon.aws.tests',
            'ansible_collections.amazon.aws.docs.*',
            'ansible_collections.amazon.aws.docs',
            'ansible_collections.ansible.netcommon.tests.*',
            'ansible_collections.ansible.netcommon.tests',
            'ansible_collections.ansible.netcommon.docs.*',
            'ansible_collections.ansible.netcommon.docs',
            'ansible_collections.ansible.posix.tests.*',
            'ansible_collections.ansible.posix.tests',
            'ansible_collections.ansible.posix.docs.*',
            'ansible_collections.ansible.posix.docs',
            'ansible_collections.ansible.utils.tests.*',
            'ansible_collections.ansible.utils.tests',
            'ansible_collections.ansible.utils.docs.*',
            'ansible_collections.ansible.utils.docs',
            'ansible_collections.ansible.windows.tests.*',
            'ansible_collections.ansible.windows.tests',
            'ansible_collections.ansible.windows.docs.*',
            'ansible_collections.ansible.windows.docs',
            'ansible_collections.arista.eos.tests.*',
            'ansible_collections.arista.eos.tests',
            'ansible_collections.arista.eos.docs.*',
            'ansible_collections.arista.eos.docs',
            'ansible_collections.awx.awx.tests.*',
            'ansible_collections.awx.awx.tests',
            'ansible_collections.awx.awx.docs.*',
            'ansible_collections.awx.awx.docs',
            'ansible_collections.azure.azcollection.tests.*',
            'ansible_collections.azure.azcollection.tests',
            'ansible_collections.azure.azcollection.docs.*',
            'ansible_collections.azure.azcollection.docs',
            'ansible_collections.check_point.mgmt.tests.*',
            'ansible_collections.check_point.mgmt.tests',
            'ansible_collections.check_point.mgmt.docs.*',
            'ansible_collections.check_point.mgmt.docs',
            'ansible_collections.chocolatey.chocolatey.tests.*',
            'ansible_collections.chocolatey.chocolatey.tests',
            'ansible_collections.chocolatey.chocolatey.docs.*',
            'ansible_collections.chocolatey.chocolatey.docs',
            'ansible_collections.cisco.aci.tests.*',
            'ansible_collections.cisco.aci.tests',
            'ansible_collections.cisco.aci.docs.*',
            'ansible_collections.cisco.aci.docs',
            'ansible_collections.cisco.asa.tests.*',
            'ansible_collections.cisco.asa.tests',
            'ansible_collections.cisco.asa.docs.*',
            'ansible_collections.cisco.asa.docs',
            'ansible_collections.cisco.dnac.tests.*',
            'ansible_collections.cisco.dnac.tests',
            'ansible_collections.cisco.dnac.docs.*',
            'ansible_collections.cisco.dnac.docs',
            'ansible_collections.cisco.intersight.tests.*',
            'ansible_collections.cisco.intersight.tests',
            'ansible_collections.cisco.intersight.docs.*',
            'ansible_collections.cisco.intersight.docs',
            'ansible_collections.cisco.ios.tests.*',
            'ansible_collections.cisco.ios.tests',
            'ansible_collections.cisco.ios.docs.*',
            'ansible_collections.cisco.ios.docs',
            'ansible_collections.cisco.iosxr.tests.*',
            'ansible_collections.cisco.iosxr.tests',
            'ansible_collections.cisco.iosxr.docs.*',
            'ansible_collections.cisco.iosxr.docs',
            'ansible_collections.cisco.ise.tests.*',
            'ansible_collections.cisco.ise.tests',
            'ansible_collections.cisco.ise.docs.*',
            'ansible_collections.cisco.ise.docs',
            'ansible_collections.cisco.meraki.tests.*',
            'ansible_collections.cisco.meraki.tests',
            'ansible_collections.cisco.meraki.docs.*',
            'ansible_collections.cisco.meraki.docs',
            'ansible_collections.cisco.mso.tests.*',
            'ansible_collections.cisco.mso.tests',
            'ansible_collections.cisco.mso.docs.*',
            'ansible_collections.cisco.mso.docs',
            'ansible_collections.cisco.nso.tests.*',
            'ansible_collections.cisco.nso.tests',
            'ansible_collections.cisco.nso.docs.*',
            'ansible_collections.cisco.nso.docs',
            'ansible_collections.cisco.nxos.tests.*',
            'ansible_collections.cisco.nxos.tests',
            'ansible_collections.cisco.nxos.docs.*',
            'ansible_collections.cisco.nxos.docs',
            'ansible_collections.cisco.ucs.tests.*',
            'ansible_collections.cisco.ucs.tests',
            'ansible_collections.cisco.ucs.docs.*',
            'ansible_collections.cisco.ucs.docs',
            'ansible_collections.cloud.common.tests.*',
            'ansible_collections.cloud.common.tests',
            'ansible_collections.cloud.common.docs.*',
            'ansible_collections.cloud.common.docs',
            'ansible_collections.cloudscale_ch.cloud.tests.*',
            'ansible_collections.cloudscale_ch.cloud.tests',
            'ansible_collections.cloudscale_ch.cloud.docs.*',
            'ansible_collections.cloudscale_ch.cloud.docs',
            'ansible_collections.community.aws.tests.*',
            'ansible_collections.community.aws.tests',
            'ansible_collections.community.aws.docs.*',
            'ansible_collections.community.aws.docs',
            'ansible_collections.community.azure.tests.*',
            'ansible_collections.community.azure.tests',
            'ansible_collections.community.azure.docs.*',
            'ansible_collections.community.azure.docs',
            'ansible_collections.community.ciscosmb.tests.*',
            'ansible_collections.community.ciscosmb.tests',
            'ansible_collections.community.ciscosmb.docs.*',
            'ansible_collections.community.ciscosmb.docs',
            'ansible_collections.community.crypto.tests.*',
            'ansible_collections.community.crypto.tests',
            'ansible_collections.community.crypto.docs.*',
            'ansible_collections.community.crypto.docs',
            'ansible_collections.community.digitalocean.tests.*',
            'ansible_collections.community.digitalocean.tests',
            'ansible_collections.community.digitalocean.docs.*',
            'ansible_collections.community.digitalocean.docs',
            'ansible_collections.community.dns.tests.*',
            'ansible_collections.community.dns.tests',
            'ansible_collections.community.dns.docs.*',
            'ansible_collections.community.dns.docs',
            'ansible_collections.community.docker.tests.*',
            'ansible_collections.community.docker.tests',
            'ansible_collections.community.docker.docs.*',
            'ansible_collections.community.docker.docs',
            'ansible_collections.community.fortios.tests.*',
            'ansible_collections.community.fortios.tests',
            'ansible_collections.community.fortios.docs.*',
            'ansible_collections.community.fortios.docs',
            'ansible_collections.community.general.tests.*',
            'ansible_collections.community.general.tests',
            'ansible_collections.community.general.docs.*',
            'ansible_collections.community.general.docs',
            'ansible_collections.community.google.tests.*',
            'ansible_collections.community.google.tests',
            'ansible_collections.community.google.docs.*',
            'ansible_collections.community.google.docs',
            'ansible_collections.community.grafana.tests.*',
            'ansible_collections.community.grafana.tests',
            'ansible_collections.community.grafana.docs.*',
            'ansible_collections.community.grafana.docs',
            'ansible_collections.community.hashi_vault.tests.*',
            'ansible_collections.community.hashi_vault.tests',
            'ansible_collections.community.hashi_vault.docs.*',
            'ansible_collections.community.hashi_vault.docs',
            'ansible_collections.community.hrobot.tests.*',
            'ansible_collections.community.hrobot.tests',
            'ansible_collections.community.hrobot.docs.*',
            'ansible_collections.community.hrobot.docs',
            'ansible_collections.community.libvirt.tests.*',
            'ansible_collections.community.libvirt.tests',
            'ansible_collections.community.libvirt.docs.*',
            'ansible_collections.community.libvirt.docs',
            'ansible_collections.community.mongodb.tests.*',
            'ansible_collections.community.mongodb.tests',
            'ansible_collections.community.mongodb.docs.*',
            'ansible_collections.community.mongodb.docs',
            'ansible_collections.community.mysql.tests.*',
            'ansible_collections.community.mysql.tests',
            'ansible_collections.community.mysql.docs.*',
            'ansible_collections.community.mysql.docs',
            'ansible_collections.community.network.tests.*',
            'ansible_collections.community.network.tests',
            'ansible_collections.community.network.docs.*',
            'ansible_collections.community.network.docs',
            'ansible_collections.community.okd.tests.*',
            'ansible_collections.community.okd.tests',
            'ansible_collections.community.okd.docs.*',
            'ansible_collections.community.okd.docs',
            'ansible_collections.community.postgresql.tests.*',
            'ansible_collections.community.postgresql.tests',
            'ansible_collections.community.postgresql.docs.*',
            'ansible_collections.community.postgresql.docs',
            'ansible_collections.community.proxysql.tests.*',
            'ansible_collections.community.proxysql.tests',
            'ansible_collections.community.proxysql.docs.*',
            'ansible_collections.community.proxysql.docs',
            'ansible_collections.community.rabbitmq.tests.*',
            'ansible_collections.community.rabbitmq.tests',
            'ansible_collections.community.rabbitmq.docs.*',
            'ansible_collections.community.rabbitmq.docs',
            'ansible_collections.community.routeros.tests.*',
            'ansible_collections.community.routeros.tests',
            'ansible_collections.community.routeros.docs.*',
            'ansible_collections.community.routeros.docs',
            'ansible_collections.community.sap.tests.*',
            'ansible_collections.community.sap.tests',
            'ansible_collections.community.sap.docs.*',
            'ansible_collections.community.sap.docs',
            'ansible_collections.community.sap_libs.tests.*',
            'ansible_collections.community.sap_libs.tests',
            'ansible_collections.community.sap_libs.docs.*',
            'ansible_collections.community.sap_libs.docs',
            'ansible_collections.community.skydive.tests.*',
            'ansible_collections.community.skydive.tests',
            'ansible_collections.community.skydive.docs.*',
            'ansible_collections.community.skydive.docs',
            'ansible_collections.community.sops.tests.*',
            'ansible_collections.community.sops.tests',
            'ansible_collections.community.sops.docs.*',
            'ansible_collections.community.sops.docs',
            'ansible_collections.community.vmware.tests.*',
            'ansible_collections.community.vmware.tests',
            'ansible_collections.community.vmware.docs.*',
            'ansible_collections.community.vmware.docs',
            'ansible_collections.community.windows.tests.*',
            'ansible_collections.community.windows.tests',
            'ansible_collections.community.windows.docs.*',
            'ansible_collections.community.windows.docs',
            'ansible_collections.community.zabbix.tests.*',
            'ansible_collections.community.zabbix.tests',
            'ansible_collections.community.zabbix.docs.*',
            'ansible_collections.community.zabbix.docs',
            'ansible_collections.containers.podman.tests.*',
            'ansible_collections.containers.podman.tests',
            'ansible_collections.containers.podman.docs.*',
            'ansible_collections.containers.podman.docs',
            'ansible_collections.cyberark.conjur.tests.*',
            'ansible_collections.cyberark.conjur.tests',
            'ansible_collections.cyberark.conjur.docs.*',
            'ansible_collections.cyberark.conjur.docs',
            'ansible_collections.cyberark.pas.tests.*',
            'ansible_collections.cyberark.pas.tests',
            'ansible_collections.cyberark.pas.docs.*',
            'ansible_collections.cyberark.pas.docs',
            'ansible_collections.dellemc.enterprise_sonic.tests.*',
            'ansible_collections.dellemc.enterprise_sonic.tests',
            'ansible_collections.dellemc.enterprise_sonic.docs.*',
            'ansible_collections.dellemc.enterprise_sonic.docs',
            'ansible_collections.dellemc.openmanage.tests.*',
            'ansible_collections.dellemc.openmanage.tests',
            'ansible_collections.dellemc.openmanage.docs.*',
            'ansible_collections.dellemc.openmanage.docs',
            'ansible_collections.dellemc.powerflex.tests.*',
            'ansible_collections.dellemc.powerflex.tests',
            'ansible_collections.dellemc.powerflex.docs.*',
            'ansible_collections.dellemc.powerflex.docs',
            'ansible_collections.dellemc.unity.tests.*',
            'ansible_collections.dellemc.unity.tests',
            'ansible_collections.dellemc.unity.docs.*',
            'ansible_collections.dellemc.unity.docs',
            'ansible_collections.f5networks.f5_modules.tests.*',
            'ansible_collections.f5networks.f5_modules.tests',
            'ansible_collections.f5networks.f5_modules.docs.*',
            'ansible_collections.f5networks.f5_modules.docs',
            'ansible_collections.fortinet.fortimanager.tests.*',
            'ansible_collections.fortinet.fortimanager.tests',
            'ansible_collections.fortinet.fortimanager.docs.*',
            'ansible_collections.fortinet.fortimanager.docs',
            'ansible_collections.fortinet.fortios.tests.*',
            'ansible_collections.fortinet.fortios.tests',
            'ansible_collections.fortinet.fortios.docs.*',
            'ansible_collections.fortinet.fortios.docs',
            'ansible_collections.frr.frr.tests.*',
            'ansible_collections.frr.frr.tests',
            'ansible_collections.frr.frr.docs.*',
            'ansible_collections.frr.frr.docs',
            'ansible_collections.gluster.gluster.tests.*',
            'ansible_collections.gluster.gluster.tests',
            'ansible_collections.gluster.gluster.docs.*',
            'ansible_collections.gluster.gluster.docs',
            'ansible_collections.google.cloud.tests.*',
            'ansible_collections.google.cloud.tests',
            'ansible_collections.google.cloud.docs.*',
            'ansible_collections.google.cloud.docs',
            'ansible_collections.grafana.grafana.tests.*',
            'ansible_collections.grafana.grafana.tests',
            'ansible_collections.grafana.grafana.docs.*',
            'ansible_collections.grafana.grafana.docs',
            'ansible_collections.hetzner.hcloud.tests.*',
            'ansible_collections.hetzner.hcloud.tests',
            'ansible_collections.hetzner.hcloud.docs.*',
            'ansible_collections.hetzner.hcloud.docs',
            'ansible_collections.hpe.nimble.tests.*',
            'ansible_collections.hpe.nimble.tests',
            'ansible_collections.hpe.nimble.docs.*',
            'ansible_collections.hpe.nimble.docs',
            'ansible_collections.ibm.qradar.tests.*',
            'ansible_collections.ibm.qradar.tests',
            'ansible_collections.ibm.qradar.docs.*',
            'ansible_collections.ibm.qradar.docs',
            'ansible_collections.ibm.spectrum_virtualize.tests.*',
            'ansible_collections.ibm.spectrum_virtualize.tests',
            'ansible_collections.ibm.spectrum_virtualize.docs.*',
            'ansible_collections.ibm.spectrum_virtualize.docs',
            'ansible_collections.ibm.storage_virtualize.tests.*',
            'ansible_collections.ibm.storage_virtualize.tests',
            'ansible_collections.ibm.storage_virtualize.docs.*',
            'ansible_collections.ibm.storage_virtualize.docs',
            'ansible_collections.infinidat.infinibox.tests.*',
            'ansible_collections.infinidat.infinibox.tests',
            'ansible_collections.infinidat.infinibox.docs.*',
            'ansible_collections.infinidat.infinibox.docs',
            'ansible_collections.infoblox.nios_modules.tests.*',
            'ansible_collections.infoblox.nios_modules.tests',
            'ansible_collections.infoblox.nios_modules.docs.*',
            'ansible_collections.infoblox.nios_modules.docs',
            'ansible_collections.inspur.ispim.tests.*',
            'ansible_collections.inspur.ispim.tests',
            'ansible_collections.inspur.ispim.docs.*',
            'ansible_collections.inspur.ispim.docs',
            'ansible_collections.inspur.sm.tests.*',
            'ansible_collections.inspur.sm.tests',
            'ansible_collections.inspur.sm.docs.*',
            'ansible_collections.inspur.sm.docs',
            'ansible_collections.junipernetworks.junos.tests.*',
            'ansible_collections.junipernetworks.junos.tests',
            'ansible_collections.junipernetworks.junos.docs.*',
            'ansible_collections.junipernetworks.junos.docs',
            'ansible_collections.kubernetes.core.tests.*',
            'ansible_collections.kubernetes.core.tests',
            'ansible_collections.kubernetes.core.docs.*',
            'ansible_collections.kubernetes.core.docs',
            'ansible_collections.lowlydba.sqlserver.tests.*',
            'ansible_collections.lowlydba.sqlserver.tests',
            'ansible_collections.lowlydba.sqlserver.docs.*',
            'ansible_collections.lowlydba.sqlserver.docs',
            'ansible_collections.microsoft.ad.tests.*',
            'ansible_collections.microsoft.ad.tests',
            'ansible_collections.microsoft.ad.docs.*',
            'ansible_collections.microsoft.ad.docs',
            'ansible_collections.netapp.aws.tests.*',
            'ansible_collections.netapp.aws.tests',
            'ansible_collections.netapp.aws.docs.*',
            'ansible_collections.netapp.aws.docs',
            'ansible_collections.netapp.azure.tests.*',
            'ansible_collections.netapp.azure.tests',
            'ansible_collections.netapp.azure.docs.*',
            'ansible_collections.netapp.azure.docs',
            'ansible_collections.netapp.cloudmanager.tests.*',
            'ansible_collections.netapp.cloudmanager.tests',
            'ansible_collections.netapp.cloudmanager.docs.*',
            'ansible_collections.netapp.cloudmanager.docs',
            'ansible_collections.netapp.elementsw.tests.*',
            'ansible_collections.netapp.elementsw.tests',
            'ansible_collections.netapp.elementsw.docs.*',
            'ansible_collections.netapp.elementsw.docs',
            'ansible_collections.netapp.ontap.tests.*',
            'ansible_collections.netapp.ontap.tests',
            'ansible_collections.netapp.ontap.docs.*',
            'ansible_collections.netapp.ontap.docs',
            'ansible_collections.netapp.storagegrid.tests.*',
            'ansible_collections.netapp.storagegrid.tests',
            'ansible_collections.netapp.storagegrid.docs.*',
            'ansible_collections.netapp.storagegrid.docs',
            'ansible_collections.netapp.um_info.tests.*',
            'ansible_collections.netapp.um_info.tests',
            'ansible_collections.netapp.um_info.docs.*',
            'ansible_collections.netapp.um_info.docs',
            'ansible_collections.netapp_eseries.santricity.tests.*',
            'ansible_collections.netapp_eseries.santricity.tests',
            'ansible_collections.netapp_eseries.santricity.docs.*',
            'ansible_collections.netapp_eseries.santricity.docs',
            'ansible_collections.netbox.netbox.tests.*',
            'ansible_collections.netbox.netbox.tests',
            'ansible_collections.netbox.netbox.docs.*',
            'ansible_collections.netbox.netbox.docs',
            'ansible_collections.ngine_io.cloudstack.tests.*',
            'ansible_collections.ngine_io.cloudstack.tests',
            'ansible_collections.ngine_io.cloudstack.docs.*',
            'ansible_collections.ngine_io.cloudstack.docs',
            'ansible_collections.ngine_io.exoscale.tests.*',
            'ansible_collections.ngine_io.exoscale.tests',
            'ansible_collections.ngine_io.exoscale.docs.*',
            'ansible_collections.ngine_io.exoscale.docs',
            'ansible_collections.ngine_io.vultr.tests.*',
            'ansible_collections.ngine_io.vultr.tests',
            'ansible_collections.ngine_io.vultr.docs.*',
            'ansible_collections.ngine_io.vultr.docs',
            'ansible_collections.openstack.cloud.tests.*',
            'ansible_collections.openstack.cloud.tests',
            'ansible_collections.openstack.cloud.docs.*',
            'ansible_collections.openstack.cloud.docs',
            'ansible_collections.openvswitch.openvswitch.tests.*',
            'ansible_collections.openvswitch.openvswitch.tests',
            'ansible_collections.openvswitch.openvswitch.docs.*',
            'ansible_collections.openvswitch.openvswitch.docs',
            'ansible_collections.ovirt.ovirt.tests.*',
            'ansible_collections.ovirt.ovirt.tests',
            'ansible_collections.ovirt.ovirt.docs.*',
            'ansible_collections.ovirt.ovirt.docs',
            'ansible_collections.purestorage.flasharray.tests.*',
            'ansible_collections.purestorage.flasharray.tests',
            'ansible_collections.purestorage.flasharray.docs.*',
            'ansible_collections.purestorage.flasharray.docs',
            'ansible_collections.purestorage.flashblade.tests.*',
            'ansible_collections.purestorage.flashblade.tests',
            'ansible_collections.purestorage.flashblade.docs.*',
            'ansible_collections.purestorage.flashblade.docs',
            'ansible_collections.purestorage.fusion.tests.*',
            'ansible_collections.purestorage.fusion.tests',
            'ansible_collections.purestorage.fusion.docs.*',
            'ansible_collections.purestorage.fusion.docs',
            'ansible_collections.sensu.sensu_go.tests.*',
            'ansible_collections.sensu.sensu_go.tests',
            'ansible_collections.sensu.sensu_go.docs.*',
            'ansible_collections.sensu.sensu_go.docs',
            'ansible_collections.servicenow.servicenow.tests.*',
            'ansible_collections.servicenow.servicenow.tests',
            'ansible_collections.servicenow.servicenow.docs.*',
            'ansible_collections.servicenow.servicenow.docs',
            'ansible_collections.splunk.es.tests.*',
            'ansible_collections.splunk.es.tests',
            'ansible_collections.splunk.es.docs.*',
            'ansible_collections.splunk.es.docs',
            'ansible_collections.t_systems_mms.icinga_director.tests.*',
            'ansible_collections.t_systems_mms.icinga_director.tests',
            'ansible_collections.t_systems_mms.icinga_director.docs.*',
            'ansible_collections.t_systems_mms.icinga_director.docs',
            'ansible_collections.telekom_mms.icinga_director.tests.*',
            'ansible_collections.telekom_mms.icinga_director.tests',
            'ansible_collections.telekom_mms.icinga_director.docs.*',
            'ansible_collections.telekom_mms.icinga_director.docs',
            'ansible_collections.theforeman.foreman.tests.*',
            'ansible_collections.theforeman.foreman.tests',
            'ansible_collections.theforeman.foreman.docs.*',
            'ansible_collections.theforeman.foreman.docs',
            'ansible_collections.vmware.vmware_rest.tests.*',
            'ansible_collections.vmware.vmware_rest.tests',
            'ansible_collections.vmware.vmware_rest.docs.*',
            'ansible_collections.vmware.vmware_rest.docs',
            'ansible_collections.vultr.cloud.tests.*',
            'ansible_collections.vultr.cloud.tests',
            'ansible_collections.vultr.cloud.docs.*',
            'ansible_collections.vultr.cloud.docs',
            'ansible_collections.vyos.vyos.tests.*',
            'ansible_collections.vyos.vyos.tests',
            'ansible_collections.vyos.vyos.docs.*',
            'ansible_collections.vyos.vyos.docs',
            'ansible_collections.wti.remote.tests.*',
            'ansible_collections.wti.remote.tests',
            'ansible_collections.wti.remote.docs.*',
            'ansible_collections.wti.remote.docs',
        ],
    ),
    package_dir={'': '.'},
    package_data={
        'ansible_collections.amazon.aws': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/action/*', 'plugins/action/.*',
            'plugins/callback/*', 'plugins/callback/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/inventory/*', 'plugins/inventory/.*',
            'plugins/lookup/*', 'plugins/lookup/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'plugins/plugin_utils/*', 'plugins/plugin_utils/.*',
        ],
        'ansible_collections.ansible.netcommon': [
            '*',
            'LICENSES/*', 'LICENSES/.*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/action/*', 'plugins/action/.*',
            'plugins/become/*', 'plugins/become/.*',
            'plugins/cache/*', 'plugins/cache/.*',
            'plugins/cliconf/*', 'plugins/cliconf/.*',
            'plugins/connection/*', 'plugins/connection/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/filter/*', 'plugins/filter/.*',
            'plugins/httpapi/*', 'plugins/httpapi/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/module_utils/cli_parser/*', 'plugins/module_utils/cli_parser/.*',
            'plugins/module_utils/network/*', 'plugins/module_utils/network/.*',
            'plugins/module_utils/network/common/*', 'plugins/module_utils/network/common/.*',
            'plugins/module_utils/network/common/cfg/*', 'plugins/module_utils/network/common/cfg/.*',
            'plugins/module_utils/network/common/facts/*', 'plugins/module_utils/network/common/facts/.*',
            'plugins/module_utils/network/common/rm_base/*', 'plugins/module_utils/network/common/rm_base/.*',
            'plugins/module_utils/network/grpc/*', 'plugins/module_utils/network/grpc/.*',
            'plugins/module_utils/network/netconf/*', 'plugins/module_utils/network/netconf/.*',
            'plugins/module_utils/network/restconf/*', 'plugins/module_utils/network/restconf/.*',
            'plugins/module_utils/utils/*', 'plugins/module_utils/utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'plugins/netconf/*', 'plugins/netconf/.*',
            'plugins/plugin_utils/*', 'plugins/plugin_utils/.*',
            'plugins/plugin_utils/compat/*', 'plugins/plugin_utils/compat/.*',
            'plugins/sub_plugins/*', 'plugins/sub_plugins/.*',
            'plugins/sub_plugins/cli_parser/*', 'plugins/sub_plugins/cli_parser/.*',
            'plugins/sub_plugins/grpc/*', 'plugins/sub_plugins/grpc/.*',
        ],
        'ansible_collections.ansible.posix': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'hacking/*', 'hacking/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/action/*', 'plugins/action/.*',
            'plugins/callback/*', 'plugins/callback/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'plugins/shell/*', 'plugins/shell/.*',
        ],
        'ansible_collections.ansible.utils': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/action/*', 'plugins/action/.*',
            'plugins/filter/*', 'plugins/filter/.*',
            'plugins/lookup/*', 'plugins/lookup/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/module_utils/common/*', 'plugins/module_utils/common/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'plugins/plugin_utils/*', 'plugins/plugin_utils/.*',
            'plugins/plugin_utils/base/*', 'plugins/plugin_utils/base/.*',
            'plugins/sub_plugins/*', 'plugins/sub_plugins/.*',
            'plugins/sub_plugins/cli_parser/*', 'plugins/sub_plugins/cli_parser/.*',
            'plugins/sub_plugins/fact_diff/*', 'plugins/sub_plugins/fact_diff/.*',
            'plugins/sub_plugins/validate/*', 'plugins/sub_plugins/validate/.*',
            'plugins/test/*', 'plugins/test/.*',
        ],
        'ansible_collections.ansible.windows': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/action/*', 'plugins/action/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/filter/*', 'plugins/filter/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'plugins/plugin_utils/*', 'plugins/plugin_utils/.*',
        ],
        'ansible_collections.arista.eos': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/action/*', 'plugins/action/.*',
            'plugins/cliconf/*', 'plugins/cliconf/.*',
            'plugins/filter/*', 'plugins/filter/.*',
            'plugins/httpapi/*', 'plugins/httpapi/.*',
            'plugins/inventory/*', 'plugins/inventory/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/module_utils/network/*', 'plugins/module_utils/network/.*',
            'plugins/module_utils/network/eos/*', 'plugins/module_utils/network/eos/.*',
            'plugins/module_utils/network/eos/argspec/*', 'plugins/module_utils/network/eos/argspec/.*',
            'plugins/module_utils/network/eos/argspec/acl_interfaces/*', 'plugins/module_utils/network/eos/argspec/acl_interfaces/.*',
            'plugins/module_utils/network/eos/argspec/acls/*', 'plugins/module_utils/network/eos/argspec/acls/.*',
            'plugins/module_utils/network/eos/argspec/bgp_address_family/*', 'plugins/module_utils/network/eos/argspec/bgp_address_family/.*',
            'plugins/module_utils/network/eos/argspec/bgp_global/*', 'plugins/module_utils/network/eos/argspec/bgp_global/.*',
            'plugins/module_utils/network/eos/argspec/facts/*', 'plugins/module_utils/network/eos/argspec/facts/.*',
            'plugins/module_utils/network/eos/argspec/hostname/*', 'plugins/module_utils/network/eos/argspec/hostname/.*',
            'plugins/module_utils/network/eos/argspec/interfaces/*', 'plugins/module_utils/network/eos/argspec/interfaces/.*',
            'plugins/module_utils/network/eos/argspec/l2_interfaces/*', 'plugins/module_utils/network/eos/argspec/l2_interfaces/.*',
            'plugins/module_utils/network/eos/argspec/l3_interfaces/*', 'plugins/module_utils/network/eos/argspec/l3_interfaces/.*',
            'plugins/module_utils/network/eos/argspec/lacp/*', 'plugins/module_utils/network/eos/argspec/lacp/.*',
            'plugins/module_utils/network/eos/argspec/lacp_interfaces/*', 'plugins/module_utils/network/eos/argspec/lacp_interfaces/.*',
            'plugins/module_utils/network/eos/argspec/lag_interfaces/*', 'plugins/module_utils/network/eos/argspec/lag_interfaces/.*',
            'plugins/module_utils/network/eos/argspec/lldp_global/*', 'plugins/module_utils/network/eos/argspec/lldp_global/.*',
            'plugins/module_utils/network/eos/argspec/lldp_interfaces/*', 'plugins/module_utils/network/eos/argspec/lldp_interfaces/.*',
            'plugins/module_utils/network/eos/argspec/logging_global/*', 'plugins/module_utils/network/eos/argspec/logging_global/.*',
            'plugins/module_utils/network/eos/argspec/ntp_global/*', 'plugins/module_utils/network/eos/argspec/ntp_global/.*',
            'plugins/module_utils/network/eos/argspec/ospf_interfaces/*', 'plugins/module_utils/network/eos/argspec/ospf_interfaces/.*',
            'plugins/module_utils/network/eos/argspec/ospfv2/*', 'plugins/module_utils/network/eos/argspec/ospfv2/.*',
            'plugins/module_utils/network/eos/argspec/ospfv3/*', 'plugins/module_utils/network/eos/argspec/ospfv3/.*',
            'plugins/module_utils/network/eos/argspec/prefix_lists/*', 'plugins/module_utils/network/eos/argspec/prefix_lists/.*',
            'plugins/module_utils/network/eos/argspec/route_maps/*', 'plugins/module_utils/network/eos/argspec/route_maps/.*',
            'plugins/module_utils/network/eos/argspec/snmp_server/*', 'plugins/module_utils/network/eos/argspec/snmp_server/.*',
            'plugins/module_utils/network/eos/argspec/static_routes/*', 'plugins/module_utils/network/eos/argspec/static_routes/.*',
            'plugins/module_utils/network/eos/argspec/vlans/*', 'plugins/module_utils/network/eos/argspec/vlans/.*',
            'plugins/module_utils/network/eos/config/*', 'plugins/module_utils/network/eos/config/.*',
            'plugins/module_utils/network/eos/config/acl_interfaces/*', 'plugins/module_utils/network/eos/config/acl_interfaces/.*',
            'plugins/module_utils/network/eos/config/acls/*', 'plugins/module_utils/network/eos/config/acls/.*',
            'plugins/module_utils/network/eos/config/bgp_address_family/*', 'plugins/module_utils/network/eos/config/bgp_address_family/.*',
            'plugins/module_utils/network/eos/config/bgp_global/*', 'plugins/module_utils/network/eos/config/bgp_global/.*',
            'plugins/module_utils/network/eos/config/hostname/*', 'plugins/module_utils/network/eos/config/hostname/.*',
            'plugins/module_utils/network/eos/config/interfaces/*', 'plugins/module_utils/network/eos/config/interfaces/.*',
            'plugins/module_utils/network/eos/config/l2_interfaces/*', 'plugins/module_utils/network/eos/config/l2_interfaces/.*',
            'plugins/module_utils/network/eos/config/l3_interfaces/*', 'plugins/module_utils/network/eos/config/l3_interfaces/.*',
            'plugins/module_utils/network/eos/config/lacp/*', 'plugins/module_utils/network/eos/config/lacp/.*',
            'plugins/module_utils/network/eos/config/lacp_interfaces/*', 'plugins/module_utils/network/eos/config/lacp_interfaces/.*',
            'plugins/module_utils/network/eos/config/lag_interfaces/*', 'plugins/module_utils/network/eos/config/lag_interfaces/.*',
            'plugins/module_utils/network/eos/config/lldp_global/*', 'plugins/module_utils/network/eos/config/lldp_global/.*',
            'plugins/module_utils/network/eos/config/lldp_interfaces/*', 'plugins/module_utils/network/eos/config/lldp_interfaces/.*',
            'plugins/module_utils/network/eos/config/logging_global/*', 'plugins/module_utils/network/eos/config/logging_global/.*',
            'plugins/module_utils/network/eos/config/ntp_global/*', 'plugins/module_utils/network/eos/config/ntp_global/.*',
            'plugins/module_utils/network/eos/config/ospf_interfaces/*', 'plugins/module_utils/network/eos/config/ospf_interfaces/.*',
            'plugins/module_utils/network/eos/config/ospfv2/*', 'plugins/module_utils/network/eos/config/ospfv2/.*',
            'plugins/module_utils/network/eos/config/ospfv3/*', 'plugins/module_utils/network/eos/config/ospfv3/.*',
            'plugins/module_utils/network/eos/config/prefix_lists/*', 'plugins/module_utils/network/eos/config/prefix_lists/.*',
            'plugins/module_utils/network/eos/config/route_maps/*', 'plugins/module_utils/network/eos/config/route_maps/.*',
            'plugins/module_utils/network/eos/config/snmp_server/*', 'plugins/module_utils/network/eos/config/snmp_server/.*',
            'plugins/module_utils/network/eos/config/static_routes/*', 'plugins/module_utils/network/eos/config/static_routes/.*',
            'plugins/module_utils/network/eos/config/vlans/*', 'plugins/module_utils/network/eos/config/vlans/.*',
            'plugins/module_utils/network/eos/facts/*', 'plugins/module_utils/network/eos/facts/.*',
            'plugins/module_utils/network/eos/facts/acl_interfaces/*', 'plugins/module_utils/network/eos/facts/acl_interfaces/.*',
            'plugins/module_utils/network/eos/facts/acls/*', 'plugins/module_utils/network/eos/facts/acls/.*',
            'plugins/module_utils/network/eos/facts/bgp_address_family/*', 'plugins/module_utils/network/eos/facts/bgp_address_family/.*',
            'plugins/module_utils/network/eos/facts/bgp_global/*', 'plugins/module_utils/network/eos/facts/bgp_global/.*',
            'plugins/module_utils/network/eos/facts/hostname/*', 'plugins/module_utils/network/eos/facts/hostname/.*',
            'plugins/module_utils/network/eos/facts/interfaces/*', 'plugins/module_utils/network/eos/facts/interfaces/.*',
            'plugins/module_utils/network/eos/facts/l2_interfaces/*', 'plugins/module_utils/network/eos/facts/l2_interfaces/.*',
            'plugins/module_utils/network/eos/facts/l3_interfaces/*', 'plugins/module_utils/network/eos/facts/l3_interfaces/.*',
            'plugins/module_utils/network/eos/facts/lacp/*', 'plugins/module_utils/network/eos/facts/lacp/.*',
            'plugins/module_utils/network/eos/facts/lacp_interfaces/*', 'plugins/module_utils/network/eos/facts/lacp_interfaces/.*',
            'plugins/module_utils/network/eos/facts/lag_interfaces/*', 'plugins/module_utils/network/eos/facts/lag_interfaces/.*',
            'plugins/module_utils/network/eos/facts/legacy/*', 'plugins/module_utils/network/eos/facts/legacy/.*',
            'plugins/module_utils/network/eos/facts/lldp_global/*', 'plugins/module_utils/network/eos/facts/lldp_global/.*',
            'plugins/module_utils/network/eos/facts/lldp_interfaces/*', 'plugins/module_utils/network/eos/facts/lldp_interfaces/.*',
            'plugins/module_utils/network/eos/facts/logging_global/*', 'plugins/module_utils/network/eos/facts/logging_global/.*',
            'plugins/module_utils/network/eos/facts/ntp_global/*', 'plugins/module_utils/network/eos/facts/ntp_global/.*',
            'plugins/module_utils/network/eos/facts/ospf_interfaces/*', 'plugins/module_utils/network/eos/facts/ospf_interfaces/.*',
            'plugins/module_utils/network/eos/facts/ospfv2/*', 'plugins/module_utils/network/eos/facts/ospfv2/.*',
            'plugins/module_utils/network/eos/facts/ospfv3/*', 'plugins/module_utils/network/eos/facts/ospfv3/.*',
            'plugins/module_utils/network/eos/facts/prefix_lists/*', 'plugins/module_utils/network/eos/facts/prefix_lists/.*',
            'plugins/module_utils/network/eos/facts/route_maps/*', 'plugins/module_utils/network/eos/facts/route_maps/.*',
            'plugins/module_utils/network/eos/facts/snmp_server/*', 'plugins/module_utils/network/eos/facts/snmp_server/.*',
            'plugins/module_utils/network/eos/facts/static_routes/*', 'plugins/module_utils/network/eos/facts/static_routes/.*',
            'plugins/module_utils/network/eos/facts/vlans/*', 'plugins/module_utils/network/eos/facts/vlans/.*',
            'plugins/module_utils/network/eos/providers/*', 'plugins/module_utils/network/eos/providers/.*',
            'plugins/module_utils/network/eos/providers/cli/*', 'plugins/module_utils/network/eos/providers/cli/.*',
            'plugins/module_utils/network/eos/providers/cli/config/*', 'plugins/module_utils/network/eos/providers/cli/config/.*',
            'plugins/module_utils/network/eos/providers/cli/config/bgp/*', 'plugins/module_utils/network/eos/providers/cli/config/bgp/.*',
            'plugins/module_utils/network/eos/rm_templates/*', 'plugins/module_utils/network/eos/rm_templates/.*',
            'plugins/module_utils/network/eos/utils/*', 'plugins/module_utils/network/eos/utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'plugins/terminal/*', 'plugins/terminal/.*',
        ],
        'ansible_collections.awx.awx': [
            '*',
            'images/*', 'images/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/inventory/*', 'plugins/inventory/.*',
            'plugins/lookup/*', 'plugins/lookup/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'test/*', 'test/.*',
            'test/awx/*', 'test/awx/.*',
        ],
        'ansible_collections.azure.azcollection': [
            '*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/inventory/*', 'plugins/inventory/.*',
            'plugins/lookup/*', 'plugins/lookup/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.check_point.mgmt': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/action/*', 'plugins/action/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/httpapi/*', 'plugins/httpapi/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'roles/*', 'roles/.*',
        ],
        'ansible_collections.chocolatey.chocolatey': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.cisco.aci': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'playbooks/*', 'playbooks/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/httpapi/*', 'plugins/httpapi/.*',
            'plugins/lookup/*', 'plugins/lookup/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'roles/*', 'roles/.*',
        ],
        'ansible_collections.cisco.asa': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/action/*', 'plugins/action/.*',
            'plugins/cliconf/*', 'plugins/cliconf/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/module_utils/network/*', 'plugins/module_utils/network/.*',
            'plugins/module_utils/network/asa/*', 'plugins/module_utils/network/asa/.*',
            'plugins/module_utils/network/asa/argspec/*', 'plugins/module_utils/network/asa/argspec/.*',
            'plugins/module_utils/network/asa/argspec/acls/*', 'plugins/module_utils/network/asa/argspec/acls/.*',
            'plugins/module_utils/network/asa/argspec/facts/*', 'plugins/module_utils/network/asa/argspec/facts/.*',
            'plugins/module_utils/network/asa/argspec/ogs/*', 'plugins/module_utils/network/asa/argspec/ogs/.*',
            'plugins/module_utils/network/asa/config/*', 'plugins/module_utils/network/asa/config/.*',
            'plugins/module_utils/network/asa/config/acls/*', 'plugins/module_utils/network/asa/config/acls/.*',
            'plugins/module_utils/network/asa/config/ogs/*', 'plugins/module_utils/network/asa/config/ogs/.*',
            'plugins/module_utils/network/asa/facts/*', 'plugins/module_utils/network/asa/facts/.*',
            'plugins/module_utils/network/asa/facts/acls/*', 'plugins/module_utils/network/asa/facts/acls/.*',
            'plugins/module_utils/network/asa/facts/legacy/*', 'plugins/module_utils/network/asa/facts/legacy/.*',
            'plugins/module_utils/network/asa/facts/ogs/*', 'plugins/module_utils/network/asa/facts/ogs/.*',
            'plugins/module_utils/network/asa/providers/*', 'plugins/module_utils/network/asa/providers/.*',
            'plugins/module_utils/network/asa/rm_templates/*', 'plugins/module_utils/network/asa/rm_templates/.*',
            'plugins/module_utils/network/asa/utils/*', 'plugins/module_utils/network/asa/utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'plugins/terminal/*', 'plugins/terminal/.*',
        ],
        'ansible_collections.cisco.dnac': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'meta/*', 'meta/.*',
            'playbooks/*', 'playbooks/.*',
            'playbooks/files/*', 'playbooks/files/.*',
            'plugins/*', 'plugins/.*',
            'plugins/action/*', 'plugins/action/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'plugins/plugin_utils/*', 'plugins/plugin_utils/.*',
        ],
        'ansible_collections.cisco.intersight': [
            '*',
            'meta/*', 'meta/.*',
            'misc/*', 'misc/.*',
            'playbooks/*', 'playbooks/.*',
            'playbooks/roles/*', 'playbooks/roles/.*',
            'playbooks/roles/policies/*', 'playbooks/roles/policies/.*',
            'playbooks/roles/policies/hyperflex_policies/*', 'playbooks/roles/policies/hyperflex_policies/.*',
            'playbooks/roles/policies/hyperflex_policies/auto_support/*', 'playbooks/roles/policies/hyperflex_policies/auto_support/.*',
            'playbooks/roles/policies/hyperflex_policies/auto_support/tasks/*', 'playbooks/roles/policies/hyperflex_policies/auto_support/tasks/.*',
            'playbooks/roles/policies/hyperflex_policies/cluster_network/*', 'playbooks/roles/policies/hyperflex_policies/cluster_network/.*',
            'playbooks/roles/policies/hyperflex_policies/cluster_network/tasks/*', 'playbooks/roles/policies/hyperflex_policies/cluster_network/tasks/.*',
            'playbooks/roles/policies/hyperflex_policies/cluster_profile/*', 'playbooks/roles/policies/hyperflex_policies/cluster_profile/.*',
            'playbooks/roles/policies/hyperflex_policies/cluster_profile/defaults/*', 'playbooks/roles/policies/hyperflex_policies/cluster_profile/defaults/.*',
            'playbooks/roles/policies/hyperflex_policies/cluster_profile/tasks/*', 'playbooks/roles/policies/hyperflex_policies/cluster_profile/tasks/.*',
            'playbooks/roles/policies/hyperflex_policies/cluster_storage/*', 'playbooks/roles/policies/hyperflex_policies/cluster_storage/.*',
            'playbooks/roles/policies/hyperflex_policies/cluster_storage/tasks/*', 'playbooks/roles/policies/hyperflex_policies/cluster_storage/tasks/.*',
            'playbooks/roles/policies/hyperflex_policies/deploy/*', 'playbooks/roles/policies/hyperflex_policies/deploy/.*',
            'playbooks/roles/policies/hyperflex_policies/deploy/tasks/*', 'playbooks/roles/policies/hyperflex_policies/deploy/tasks/.*',
            'playbooks/roles/policies/hyperflex_policies/edge_cluster_network/*', 'playbooks/roles/policies/hyperflex_policies/edge_cluster_network/.*',
            'playbooks/roles/policies/hyperflex_policies/edge_cluster_network/tasks/*', 'playbooks/roles/policies/hyperflex_policies/edge_cluster_network/tasks/.*',
            'playbooks/roles/policies/hyperflex_policies/edge_cluster_profile/*', 'playbooks/roles/policies/hyperflex_policies/edge_cluster_profile/.*',
            'playbooks/roles/policies/hyperflex_policies/edge_cluster_profile/defaults/*', 'playbooks/roles/policies/hyperflex_policies/edge_cluster_profile/defaults/.*',
            'playbooks/roles/policies/hyperflex_policies/edge_cluster_profile/tasks/*', 'playbooks/roles/policies/hyperflex_policies/edge_cluster_profile/tasks/.*',
            'playbooks/roles/policies/hyperflex_policies/edge_cluster_storage/*', 'playbooks/roles/policies/hyperflex_policies/edge_cluster_storage/.*',
            'playbooks/roles/policies/hyperflex_policies/edge_cluster_storage/tasks/*', 'playbooks/roles/policies/hyperflex_policies/edge_cluster_storage/tasks/.*',
            'playbooks/roles/policies/hyperflex_policies/edge_software_version/*', 'playbooks/roles/policies/hyperflex_policies/edge_software_version/.*',
            'playbooks/roles/policies/hyperflex_policies/edge_software_version/tasks/*', 'playbooks/roles/policies/hyperflex_policies/edge_software_version/tasks/.*',
            'playbooks/roles/policies/hyperflex_policies/fc/*', 'playbooks/roles/policies/hyperflex_policies/fc/.*',
            'playbooks/roles/policies/hyperflex_policies/fc/tasks/*', 'playbooks/roles/policies/hyperflex_policies/fc/tasks/.*',
            'playbooks/roles/policies/hyperflex_policies/intersight_org/*', 'playbooks/roles/policies/hyperflex_policies/intersight_org/.*',
            'playbooks/roles/policies/hyperflex_policies/intersight_org/tasks/*', 'playbooks/roles/policies/hyperflex_policies/intersight_org/tasks/.*',
            'playbooks/roles/policies/hyperflex_policies/iscsi/*', 'playbooks/roles/policies/hyperflex_policies/iscsi/.*',
            'playbooks/roles/policies/hyperflex_policies/iscsi/tasks/*', 'playbooks/roles/policies/hyperflex_policies/iscsi/tasks/.*',
            'playbooks/roles/policies/hyperflex_policies/local_credential/*', 'playbooks/roles/policies/hyperflex_policies/local_credential/.*',
            'playbooks/roles/policies/hyperflex_policies/local_credential/tasks/*', 'playbooks/roles/policies/hyperflex_policies/local_credential/tasks/.*',
            'playbooks/roles/policies/hyperflex_policies/node_config/*', 'playbooks/roles/policies/hyperflex_policies/node_config/.*',
            'playbooks/roles/policies/hyperflex_policies/node_config/tasks/*', 'playbooks/roles/policies/hyperflex_policies/node_config/tasks/.*',
            'playbooks/roles/policies/hyperflex_policies/node_profiles/*', 'playbooks/roles/policies/hyperflex_policies/node_profiles/.*',
            'playbooks/roles/policies/hyperflex_policies/node_profiles/tasks/*', 'playbooks/roles/policies/hyperflex_policies/node_profiles/tasks/.*',
            'playbooks/roles/policies/hyperflex_policies/proxy/*', 'playbooks/roles/policies/hyperflex_policies/proxy/.*',
            'playbooks/roles/policies/hyperflex_policies/proxy/tasks/*', 'playbooks/roles/policies/hyperflex_policies/proxy/tasks/.*',
            'playbooks/roles/policies/hyperflex_policies/software_version/*', 'playbooks/roles/policies/hyperflex_policies/software_version/.*',
            'playbooks/roles/policies/hyperflex_policies/software_version/tasks/*', 'playbooks/roles/policies/hyperflex_policies/software_version/tasks/.*',
            'playbooks/roles/policies/hyperflex_policies/sys_config/*', 'playbooks/roles/policies/hyperflex_policies/sys_config/.*',
            'playbooks/roles/policies/hyperflex_policies/sys_config/tasks/*', 'playbooks/roles/policies/hyperflex_policies/sys_config/tasks/.*',
            'playbooks/roles/policies/hyperflex_policies/vcenter/*', 'playbooks/roles/policies/hyperflex_policies/vcenter/.*',
            'playbooks/roles/policies/hyperflex_policies/vcenter/tasks/*', 'playbooks/roles/policies/hyperflex_policies/vcenter/tasks/.*',
            'playbooks/roles/policies/server_policies/*', 'playbooks/roles/policies/server_policies/.*',
            'playbooks/roles/policies/server_policies/tasks/*', 'playbooks/roles/policies/server_policies/tasks/.*',
            'playbooks/roles/servers/*', 'playbooks/roles/servers/.*',
            'playbooks/roles/servers/actions/*', 'playbooks/roles/servers/actions/.*',
            'playbooks/roles/servers/actions/tasks/*', 'playbooks/roles/servers/actions/tasks/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'roles/*', 'roles/.*',
        ],
        'ansible_collections.cisco.ios': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/action/*', 'plugins/action/.*',
            'plugins/cache/*', 'plugins/cache/.*',
            'plugins/cliconf/*', 'plugins/cliconf/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/filter/*', 'plugins/filter/.*',
            'plugins/inventory/*', 'plugins/inventory/.*',
            'plugins/lookup/*', 'plugins/lookup/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/module_utils/network/*', 'plugins/module_utils/network/.*',
            'plugins/module_utils/network/ios/*', 'plugins/module_utils/network/ios/.*',
            'plugins/module_utils/network/ios/argspec/*', 'plugins/module_utils/network/ios/argspec/.*',
            'plugins/module_utils/network/ios/argspec/acl_interfaces/*', 'plugins/module_utils/network/ios/argspec/acl_interfaces/.*',
            'plugins/module_utils/network/ios/argspec/acls/*', 'plugins/module_utils/network/ios/argspec/acls/.*',
            'plugins/module_utils/network/ios/argspec/bgp_address_family/*', 'plugins/module_utils/network/ios/argspec/bgp_address_family/.*',
            'plugins/module_utils/network/ios/argspec/bgp_global/*', 'plugins/module_utils/network/ios/argspec/bgp_global/.*',
            'plugins/module_utils/network/ios/argspec/facts/*', 'plugins/module_utils/network/ios/argspec/facts/.*',
            'plugins/module_utils/network/ios/argspec/hostname/*', 'plugins/module_utils/network/ios/argspec/hostname/.*',
            'plugins/module_utils/network/ios/argspec/interfaces/*', 'plugins/module_utils/network/ios/argspec/interfaces/.*',
            'plugins/module_utils/network/ios/argspec/l2_interfaces/*', 'plugins/module_utils/network/ios/argspec/l2_interfaces/.*',
            'plugins/module_utils/network/ios/argspec/l3_interfaces/*', 'plugins/module_utils/network/ios/argspec/l3_interfaces/.*',
            'plugins/module_utils/network/ios/argspec/lacp/*', 'plugins/module_utils/network/ios/argspec/lacp/.*',
            'plugins/module_utils/network/ios/argspec/lacp_interfaces/*', 'plugins/module_utils/network/ios/argspec/lacp_interfaces/.*',
            'plugins/module_utils/network/ios/argspec/lag_interfaces/*', 'plugins/module_utils/network/ios/argspec/lag_interfaces/.*',
            'plugins/module_utils/network/ios/argspec/lldp_global/*', 'plugins/module_utils/network/ios/argspec/lldp_global/.*',
            'plugins/module_utils/network/ios/argspec/lldp_interfaces/*', 'plugins/module_utils/network/ios/argspec/lldp_interfaces/.*',
            'plugins/module_utils/network/ios/argspec/logging_global/*', 'plugins/module_utils/network/ios/argspec/logging_global/.*',
            'plugins/module_utils/network/ios/argspec/ntp_global/*', 'plugins/module_utils/network/ios/argspec/ntp_global/.*',
            'plugins/module_utils/network/ios/argspec/ospf_interfaces/*', 'plugins/module_utils/network/ios/argspec/ospf_interfaces/.*',
            'plugins/module_utils/network/ios/argspec/ospfv2/*', 'plugins/module_utils/network/ios/argspec/ospfv2/.*',
            'plugins/module_utils/network/ios/argspec/ospfv3/*', 'plugins/module_utils/network/ios/argspec/ospfv3/.*',
            'plugins/module_utils/network/ios/argspec/ping/*', 'plugins/module_utils/network/ios/argspec/ping/.*',
            'plugins/module_utils/network/ios/argspec/prefix_lists/*', 'plugins/module_utils/network/ios/argspec/prefix_lists/.*',
            'plugins/module_utils/network/ios/argspec/route_maps/*', 'plugins/module_utils/network/ios/argspec/route_maps/.*',
            'plugins/module_utils/network/ios/argspec/service/*', 'plugins/module_utils/network/ios/argspec/service/.*',
            'plugins/module_utils/network/ios/argspec/snmp_server/*', 'plugins/module_utils/network/ios/argspec/snmp_server/.*',
            'plugins/module_utils/network/ios/argspec/static_routes/*', 'plugins/module_utils/network/ios/argspec/static_routes/.*',
            'plugins/module_utils/network/ios/argspec/vlans/*', 'plugins/module_utils/network/ios/argspec/vlans/.*',
            'plugins/module_utils/network/ios/config/*', 'plugins/module_utils/network/ios/config/.*',
            'plugins/module_utils/network/ios/config/acl_interfaces/*', 'plugins/module_utils/network/ios/config/acl_interfaces/.*',
            'plugins/module_utils/network/ios/config/acls/*', 'plugins/module_utils/network/ios/config/acls/.*',
            'plugins/module_utils/network/ios/config/bgp_address_family/*', 'plugins/module_utils/network/ios/config/bgp_address_family/.*',
            'plugins/module_utils/network/ios/config/bgp_global/*', 'plugins/module_utils/network/ios/config/bgp_global/.*',
            'plugins/module_utils/network/ios/config/hostname/*', 'plugins/module_utils/network/ios/config/hostname/.*',
            'plugins/module_utils/network/ios/config/interfaces/*', 'plugins/module_utils/network/ios/config/interfaces/.*',
            'plugins/module_utils/network/ios/config/l2_interfaces/*', 'plugins/module_utils/network/ios/config/l2_interfaces/.*',
            'plugins/module_utils/network/ios/config/l3_interfaces/*', 'plugins/module_utils/network/ios/config/l3_interfaces/.*',
            'plugins/module_utils/network/ios/config/lacp/*', 'plugins/module_utils/network/ios/config/lacp/.*',
            'plugins/module_utils/network/ios/config/lacp_interfaces/*', 'plugins/module_utils/network/ios/config/lacp_interfaces/.*',
            'plugins/module_utils/network/ios/config/lag_interfaces/*', 'plugins/module_utils/network/ios/config/lag_interfaces/.*',
            'plugins/module_utils/network/ios/config/lldp_global/*', 'plugins/module_utils/network/ios/config/lldp_global/.*',
            'plugins/module_utils/network/ios/config/lldp_interfaces/*', 'plugins/module_utils/network/ios/config/lldp_interfaces/.*',
            'plugins/module_utils/network/ios/config/logging_global/*', 'plugins/module_utils/network/ios/config/logging_global/.*',
            'plugins/module_utils/network/ios/config/ntp_global/*', 'plugins/module_utils/network/ios/config/ntp_global/.*',
            'plugins/module_utils/network/ios/config/ospf_interfaces/*', 'plugins/module_utils/network/ios/config/ospf_interfaces/.*',
            'plugins/module_utils/network/ios/config/ospfv2/*', 'plugins/module_utils/network/ios/config/ospfv2/.*',
            'plugins/module_utils/network/ios/config/ospfv3/*', 'plugins/module_utils/network/ios/config/ospfv3/.*',
            'plugins/module_utils/network/ios/config/ping/*', 'plugins/module_utils/network/ios/config/ping/.*',
            'plugins/module_utils/network/ios/config/prefix_lists/*', 'plugins/module_utils/network/ios/config/prefix_lists/.*',
            'plugins/module_utils/network/ios/config/route_maps/*', 'plugins/module_utils/network/ios/config/route_maps/.*',
            'plugins/module_utils/network/ios/config/service/*', 'plugins/module_utils/network/ios/config/service/.*',
            'plugins/module_utils/network/ios/config/snmp_server/*', 'plugins/module_utils/network/ios/config/snmp_server/.*',
            'plugins/module_utils/network/ios/config/static_routes/*', 'plugins/module_utils/network/ios/config/static_routes/.*',
            'plugins/module_utils/network/ios/config/vlans/*', 'plugins/module_utils/network/ios/config/vlans/.*',
            'plugins/module_utils/network/ios/facts/*', 'plugins/module_utils/network/ios/facts/.*',
            'plugins/module_utils/network/ios/facts/acl_interfaces/*', 'plugins/module_utils/network/ios/facts/acl_interfaces/.*',
            'plugins/module_utils/network/ios/facts/acls/*', 'plugins/module_utils/network/ios/facts/acls/.*',
            'plugins/module_utils/network/ios/facts/bgp_address_family/*', 'plugins/module_utils/network/ios/facts/bgp_address_family/.*',
            'plugins/module_utils/network/ios/facts/bgp_global/*', 'plugins/module_utils/network/ios/facts/bgp_global/.*',
            'plugins/module_utils/network/ios/facts/hostname/*', 'plugins/module_utils/network/ios/facts/hostname/.*',
            'plugins/module_utils/network/ios/facts/interfaces/*', 'plugins/module_utils/network/ios/facts/interfaces/.*',
            'plugins/module_utils/network/ios/facts/l2_interfaces/*', 'plugins/module_utils/network/ios/facts/l2_interfaces/.*',
            'plugins/module_utils/network/ios/facts/l3_interfaces/*', 'plugins/module_utils/network/ios/facts/l3_interfaces/.*',
            'plugins/module_utils/network/ios/facts/lacp/*', 'plugins/module_utils/network/ios/facts/lacp/.*',
            'plugins/module_utils/network/ios/facts/lacp_interfaces/*', 'plugins/module_utils/network/ios/facts/lacp_interfaces/.*',
            'plugins/module_utils/network/ios/facts/lag_interfaces/*', 'plugins/module_utils/network/ios/facts/lag_interfaces/.*',
            'plugins/module_utils/network/ios/facts/legacy/*', 'plugins/module_utils/network/ios/facts/legacy/.*',
            'plugins/module_utils/network/ios/facts/lldp_global/*', 'plugins/module_utils/network/ios/facts/lldp_global/.*',
            'plugins/module_utils/network/ios/facts/lldp_interfaces/*', 'plugins/module_utils/network/ios/facts/lldp_interfaces/.*',
            'plugins/module_utils/network/ios/facts/logging_global/*', 'plugins/module_utils/network/ios/facts/logging_global/.*',
            'plugins/module_utils/network/ios/facts/ntp_global/*', 'plugins/module_utils/network/ios/facts/ntp_global/.*',
            'plugins/module_utils/network/ios/facts/ospf_interfaces/*', 'plugins/module_utils/network/ios/facts/ospf_interfaces/.*',
            'plugins/module_utils/network/ios/facts/ospfv2/*', 'plugins/module_utils/network/ios/facts/ospfv2/.*',
            'plugins/module_utils/network/ios/facts/ospfv3/*', 'plugins/module_utils/network/ios/facts/ospfv3/.*',
            'plugins/module_utils/network/ios/facts/prefix_lists/*', 'plugins/module_utils/network/ios/facts/prefix_lists/.*',
            'plugins/module_utils/network/ios/facts/route_maps/*', 'plugins/module_utils/network/ios/facts/route_maps/.*',
            'plugins/module_utils/network/ios/facts/service/*', 'plugins/module_utils/network/ios/facts/service/.*',
            'plugins/module_utils/network/ios/facts/snmp_server/*', 'plugins/module_utils/network/ios/facts/snmp_server/.*',
            'plugins/module_utils/network/ios/facts/static_routes/*', 'plugins/module_utils/network/ios/facts/static_routes/.*',
            'plugins/module_utils/network/ios/facts/vlans/*', 'plugins/module_utils/network/ios/facts/vlans/.*',
            'plugins/module_utils/network/ios/providers/*', 'plugins/module_utils/network/ios/providers/.*',
            'plugins/module_utils/network/ios/providers/cli/*', 'plugins/module_utils/network/ios/providers/cli/.*',
            'plugins/module_utils/network/ios/providers/cli/config/*', 'plugins/module_utils/network/ios/providers/cli/config/.*',
            'plugins/module_utils/network/ios/providers/cli/config/bgp/*', 'plugins/module_utils/network/ios/providers/cli/config/bgp/.*',
            'plugins/module_utils/network/ios/rm_templates/*', 'plugins/module_utils/network/ios/rm_templates/.*',
            'plugins/module_utils/network/ios/utils/*', 'plugins/module_utils/network/ios/utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'plugins/plugin_utils/*', 'plugins/plugin_utils/.*',
            'plugins/terminal/*', 'plugins/terminal/.*',
        ],
        'ansible_collections.cisco.iosxr': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/action/*', 'plugins/action/.*',
            'plugins/cliconf/*', 'plugins/cliconf/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/filter/*', 'plugins/filter/.*',
            'plugins/inventory/*', 'plugins/inventory/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/module_utils/network/*', 'plugins/module_utils/network/.*',
            'plugins/module_utils/network/iosxr/*', 'plugins/module_utils/network/iosxr/.*',
            'plugins/module_utils/network/iosxr/argspec/*', 'plugins/module_utils/network/iosxr/argspec/.*',
            'plugins/module_utils/network/iosxr/argspec/acl_interfaces/*', 'plugins/module_utils/network/iosxr/argspec/acl_interfaces/.*',
            'plugins/module_utils/network/iosxr/argspec/acls/*', 'plugins/module_utils/network/iosxr/argspec/acls/.*',
            'plugins/module_utils/network/iosxr/argspec/bgp_address_family/*', 'plugins/module_utils/network/iosxr/argspec/bgp_address_family/.*',
            'plugins/module_utils/network/iosxr/argspec/bgp_global/*', 'plugins/module_utils/network/iosxr/argspec/bgp_global/.*',
            'plugins/module_utils/network/iosxr/argspec/bgp_neighbor_address_family/*', 'plugins/module_utils/network/iosxr/argspec/bgp_neighbor_address_family/.*',
            'plugins/module_utils/network/iosxr/argspec/facts/*', 'plugins/module_utils/network/iosxr/argspec/facts/.*',
            'plugins/module_utils/network/iosxr/argspec/hostname/*', 'plugins/module_utils/network/iosxr/argspec/hostname/.*',
            'plugins/module_utils/network/iosxr/argspec/interfaces/*', 'plugins/module_utils/network/iosxr/argspec/interfaces/.*',
            'plugins/module_utils/network/iosxr/argspec/l2_interfaces/*', 'plugins/module_utils/network/iosxr/argspec/l2_interfaces/.*',
            'plugins/module_utils/network/iosxr/argspec/l3_interfaces/*', 'plugins/module_utils/network/iosxr/argspec/l3_interfaces/.*',
            'plugins/module_utils/network/iosxr/argspec/lacp/*', 'plugins/module_utils/network/iosxr/argspec/lacp/.*',
            'plugins/module_utils/network/iosxr/argspec/lacp_interfaces/*', 'plugins/module_utils/network/iosxr/argspec/lacp_interfaces/.*',
            'plugins/module_utils/network/iosxr/argspec/lag_interfaces/*', 'plugins/module_utils/network/iosxr/argspec/lag_interfaces/.*',
            'plugins/module_utils/network/iosxr/argspec/lldp_global/*', 'plugins/module_utils/network/iosxr/argspec/lldp_global/.*',
            'plugins/module_utils/network/iosxr/argspec/lldp_interfaces/*', 'plugins/module_utils/network/iosxr/argspec/lldp_interfaces/.*',
            'plugins/module_utils/network/iosxr/argspec/logging_global/*', 'plugins/module_utils/network/iosxr/argspec/logging_global/.*',
            'plugins/module_utils/network/iosxr/argspec/ntp_global/*', 'plugins/module_utils/network/iosxr/argspec/ntp_global/.*',
            'plugins/module_utils/network/iosxr/argspec/ospf_interfaces/*', 'plugins/module_utils/network/iosxr/argspec/ospf_interfaces/.*',
            'plugins/module_utils/network/iosxr/argspec/ospfv2/*', 'plugins/module_utils/network/iosxr/argspec/ospfv2/.*',
            'plugins/module_utils/network/iosxr/argspec/ospfv3/*', 'plugins/module_utils/network/iosxr/argspec/ospfv3/.*',
            'plugins/module_utils/network/iosxr/argspec/ping/*', 'plugins/module_utils/network/iosxr/argspec/ping/.*',
            'plugins/module_utils/network/iosxr/argspec/prefix_lists/*', 'plugins/module_utils/network/iosxr/argspec/prefix_lists/.*',
            'plugins/module_utils/network/iosxr/argspec/snmp_server/*', 'plugins/module_utils/network/iosxr/argspec/snmp_server/.*',
            'plugins/module_utils/network/iosxr/argspec/static_routes/*', 'plugins/module_utils/network/iosxr/argspec/static_routes/.*',
            'plugins/module_utils/network/iosxr/config/*', 'plugins/module_utils/network/iosxr/config/.*',
            'plugins/module_utils/network/iosxr/config/acl_interfaces/*', 'plugins/module_utils/network/iosxr/config/acl_interfaces/.*',
            'plugins/module_utils/network/iosxr/config/acls/*', 'plugins/module_utils/network/iosxr/config/acls/.*',
            'plugins/module_utils/network/iosxr/config/bgp_address_family/*', 'plugins/module_utils/network/iosxr/config/bgp_address_family/.*',
            'plugins/module_utils/network/iosxr/config/bgp_global/*', 'plugins/module_utils/network/iosxr/config/bgp_global/.*',
            'plugins/module_utils/network/iosxr/config/bgp_neighbor_address_family/*', 'plugins/module_utils/network/iosxr/config/bgp_neighbor_address_family/.*',
            'plugins/module_utils/network/iosxr/config/hostname/*', 'plugins/module_utils/network/iosxr/config/hostname/.*',
            'plugins/module_utils/network/iosxr/config/interfaces/*', 'plugins/module_utils/network/iosxr/config/interfaces/.*',
            'plugins/module_utils/network/iosxr/config/l2_interfaces/*', 'plugins/module_utils/network/iosxr/config/l2_interfaces/.*',
            'plugins/module_utils/network/iosxr/config/l3_interfaces/*', 'plugins/module_utils/network/iosxr/config/l3_interfaces/.*',
            'plugins/module_utils/network/iosxr/config/lacp/*', 'plugins/module_utils/network/iosxr/config/lacp/.*',
            'plugins/module_utils/network/iosxr/config/lacp_interfaces/*', 'plugins/module_utils/network/iosxr/config/lacp_interfaces/.*',
            'plugins/module_utils/network/iosxr/config/lag_interfaces/*', 'plugins/module_utils/network/iosxr/config/lag_interfaces/.*',
            'plugins/module_utils/network/iosxr/config/lldp_global/*', 'plugins/module_utils/network/iosxr/config/lldp_global/.*',
            'plugins/module_utils/network/iosxr/config/lldp_interfaces/*', 'plugins/module_utils/network/iosxr/config/lldp_interfaces/.*',
            'plugins/module_utils/network/iosxr/config/logging_global/*', 'plugins/module_utils/network/iosxr/config/logging_global/.*',
            'plugins/module_utils/network/iosxr/config/ntp_global/*', 'plugins/module_utils/network/iosxr/config/ntp_global/.*',
            'plugins/module_utils/network/iosxr/config/ospf_interfaces/*', 'plugins/module_utils/network/iosxr/config/ospf_interfaces/.*',
            'plugins/module_utils/network/iosxr/config/ospfv2/*', 'plugins/module_utils/network/iosxr/config/ospfv2/.*',
            'plugins/module_utils/network/iosxr/config/ospfv3/*', 'plugins/module_utils/network/iosxr/config/ospfv3/.*',
            'plugins/module_utils/network/iosxr/config/ping/*', 'plugins/module_utils/network/iosxr/config/ping/.*',
            'plugins/module_utils/network/iosxr/config/prefix_lists/*', 'plugins/module_utils/network/iosxr/config/prefix_lists/.*',
            'plugins/module_utils/network/iosxr/config/snmp_server/*', 'plugins/module_utils/network/iosxr/config/snmp_server/.*',
            'plugins/module_utils/network/iosxr/config/static_routes/*', 'plugins/module_utils/network/iosxr/config/static_routes/.*',
            'plugins/module_utils/network/iosxr/facts/*', 'plugins/module_utils/network/iosxr/facts/.*',
            'plugins/module_utils/network/iosxr/facts/acl_interfaces/*', 'plugins/module_utils/network/iosxr/facts/acl_interfaces/.*',
            'plugins/module_utils/network/iosxr/facts/acls/*', 'plugins/module_utils/network/iosxr/facts/acls/.*',
            'plugins/module_utils/network/iosxr/facts/bgp_address_family/*', 'plugins/module_utils/network/iosxr/facts/bgp_address_family/.*',
            'plugins/module_utils/network/iosxr/facts/bgp_global/*', 'plugins/module_utils/network/iosxr/facts/bgp_global/.*',
            'plugins/module_utils/network/iosxr/facts/bgp_neighbor_address_family/*', 'plugins/module_utils/network/iosxr/facts/bgp_neighbor_address_family/.*',
            'plugins/module_utils/network/iosxr/facts/hostname/*', 'plugins/module_utils/network/iosxr/facts/hostname/.*',
            'plugins/module_utils/network/iosxr/facts/interfaces/*', 'plugins/module_utils/network/iosxr/facts/interfaces/.*',
            'plugins/module_utils/network/iosxr/facts/l2_interfaces/*', 'plugins/module_utils/network/iosxr/facts/l2_interfaces/.*',
            'plugins/module_utils/network/iosxr/facts/l3_interfaces/*', 'plugins/module_utils/network/iosxr/facts/l3_interfaces/.*',
            'plugins/module_utils/network/iosxr/facts/lacp/*', 'plugins/module_utils/network/iosxr/facts/lacp/.*',
            'plugins/module_utils/network/iosxr/facts/lacp_interfaces/*', 'plugins/module_utils/network/iosxr/facts/lacp_interfaces/.*',
            'plugins/module_utils/network/iosxr/facts/lag_interfaces/*', 'plugins/module_utils/network/iosxr/facts/lag_interfaces/.*',
            'plugins/module_utils/network/iosxr/facts/legacy/*', 'plugins/module_utils/network/iosxr/facts/legacy/.*',
            'plugins/module_utils/network/iosxr/facts/lldp_global/*', 'plugins/module_utils/network/iosxr/facts/lldp_global/.*',
            'plugins/module_utils/network/iosxr/facts/lldp_interfaces/*', 'plugins/module_utils/network/iosxr/facts/lldp_interfaces/.*',
            'plugins/module_utils/network/iosxr/facts/logging_global/*', 'plugins/module_utils/network/iosxr/facts/logging_global/.*',
            'plugins/module_utils/network/iosxr/facts/ntp_global/*', 'plugins/module_utils/network/iosxr/facts/ntp_global/.*',
            'plugins/module_utils/network/iosxr/facts/ospf_interfaces/*', 'plugins/module_utils/network/iosxr/facts/ospf_interfaces/.*',
            'plugins/module_utils/network/iosxr/facts/ospfv2/*', 'plugins/module_utils/network/iosxr/facts/ospfv2/.*',
            'plugins/module_utils/network/iosxr/facts/ospfv3/*', 'plugins/module_utils/network/iosxr/facts/ospfv3/.*',
            'plugins/module_utils/network/iosxr/facts/prefix_lists/*', 'plugins/module_utils/network/iosxr/facts/prefix_lists/.*',
            'plugins/module_utils/network/iosxr/facts/snmp_server/*', 'plugins/module_utils/network/iosxr/facts/snmp_server/.*',
            'plugins/module_utils/network/iosxr/facts/static_routes/*', 'plugins/module_utils/network/iosxr/facts/static_routes/.*',
            'plugins/module_utils/network/iosxr/providers/*', 'plugins/module_utils/network/iosxr/providers/.*',
            'plugins/module_utils/network/iosxr/providers/cli/*', 'plugins/module_utils/network/iosxr/providers/cli/.*',
            'plugins/module_utils/network/iosxr/providers/cli/config/*', 'plugins/module_utils/network/iosxr/providers/cli/config/.*',
            'plugins/module_utils/network/iosxr/providers/cli/config/bgp/*', 'plugins/module_utils/network/iosxr/providers/cli/config/bgp/.*',
            'plugins/module_utils/network/iosxr/rm_templates/*', 'plugins/module_utils/network/iosxr/rm_templates/.*',
            'plugins/module_utils/network/iosxr/utils/*', 'plugins/module_utils/network/iosxr/utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'plugins/netconf/*', 'plugins/netconf/.*',
            'plugins/sub_plugins/*', 'plugins/sub_plugins/.*',
            'plugins/sub_plugins/grpc/*', 'plugins/sub_plugins/grpc/.*',
            'plugins/sub_plugins/grpc/pb/*', 'plugins/sub_plugins/grpc/pb/.*',
            'plugins/terminal/*', 'plugins/terminal/.*',
        ],
        'ansible_collections.cisco.ise': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'meta/*', 'meta/.*',
            'playbooks/*', 'playbooks/.*',
            'playbooks/group_vars/*', 'playbooks/group_vars/.*',
            'playbooks/vars/*', 'playbooks/vars/.*',
            'plugins/*', 'plugins/.*',
            'plugins/action/*', 'plugins/action/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'plugins/plugin_utils/*', 'plugins/plugin_utils/.*',
            'roles/*', 'roles/.*',
            'roles/aws_deployment/*', 'roles/aws_deployment/.*',
            'roles/aws_deployment/defaults/*', 'roles/aws_deployment/defaults/.*',
            'roles/aws_deployment/tasks/*', 'roles/aws_deployment/tasks/.*',
            'roles/aws_deployment/tasks/aws/*', 'roles/aws_deployment/tasks/aws/.*',
            'roles/personas_deployment/*', 'roles/personas_deployment/.*',
            'roles/personas_deployment/defaults/*', 'roles/personas_deployment/defaults/.*',
            'roles/personas_deployment/handlers/*', 'roles/personas_deployment/handlers/.*',
            'roles/personas_deployment/meta/*', 'roles/personas_deployment/meta/.*',
            'roles/personas_deployment/tasks/*', 'roles/personas_deployment/tasks/.*',
            'roles/personas_deployment/tests/*', 'roles/personas_deployment/tests/.*',
            'roles/personas_deployment/vars/*', 'roles/personas_deployment/vars/.*',
        ],
        'ansible_collections.cisco.meraki': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'meta/*', 'meta/.*',
            'playbooks/*', 'playbooks/.*',
            'playbooks/files/*', 'playbooks/files/.*',
            'plugins/*', 'plugins/.*',
            'plugins/action/*', 'plugins/action/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/module_utils/network/*', 'plugins/module_utils/network/.*',
            'plugins/module_utils/network/meraki/*', 'plugins/module_utils/network/meraki/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'plugins/plugin_utils/*', 'plugins/plugin_utils/.*',
            'scripts/*', 'scripts/.*',
            'scripts/sublime-build/*', 'scripts/sublime-build/.*',
            'workflows/*', 'workflows/.*',
        ],
        'ansible_collections.cisco.mso': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/httpapi/*', 'plugins/httpapi/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.cisco.nso': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.cisco.nxos': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/action/*', 'plugins/action/.*',
            'plugins/cliconf/*', 'plugins/cliconf/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/filter/*', 'plugins/filter/.*',
            'plugins/httpapi/*', 'plugins/httpapi/.*',
            'plugins/inventory/*', 'plugins/inventory/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/module_utils/network/*', 'plugins/module_utils/network/.*',
            'plugins/module_utils/network/nxos/*', 'plugins/module_utils/network/nxos/.*',
            'plugins/module_utils/network/nxos/argspec/*', 'plugins/module_utils/network/nxos/argspec/.*',
            'plugins/module_utils/network/nxos/argspec/acl_interfaces/*', 'plugins/module_utils/network/nxos/argspec/acl_interfaces/.*',
            'plugins/module_utils/network/nxos/argspec/acls/*', 'plugins/module_utils/network/nxos/argspec/acls/.*',
            'plugins/module_utils/network/nxos/argspec/bfd_interfaces/*', 'plugins/module_utils/network/nxos/argspec/bfd_interfaces/.*',
            'plugins/module_utils/network/nxos/argspec/bgp_address_family/*', 'plugins/module_utils/network/nxos/argspec/bgp_address_family/.*',
            'plugins/module_utils/network/nxos/argspec/bgp_global/*', 'plugins/module_utils/network/nxos/argspec/bgp_global/.*',
            'plugins/module_utils/network/nxos/argspec/bgp_neighbor_address_family/*', 'plugins/module_utils/network/nxos/argspec/bgp_neighbor_address_family/.*',
            'plugins/module_utils/network/nxos/argspec/facts/*', 'plugins/module_utils/network/nxos/argspec/facts/.*',
            'plugins/module_utils/network/nxos/argspec/hostname/*', 'plugins/module_utils/network/nxos/argspec/hostname/.*',
            'plugins/module_utils/network/nxos/argspec/hsrp_interfaces/*', 'plugins/module_utils/network/nxos/argspec/hsrp_interfaces/.*',
            'plugins/module_utils/network/nxos/argspec/interfaces/*', 'plugins/module_utils/network/nxos/argspec/interfaces/.*',
            'plugins/module_utils/network/nxos/argspec/l2_interfaces/*', 'plugins/module_utils/network/nxos/argspec/l2_interfaces/.*',
            'plugins/module_utils/network/nxos/argspec/l3_interfaces/*', 'plugins/module_utils/network/nxos/argspec/l3_interfaces/.*',
            'plugins/module_utils/network/nxos/argspec/lacp/*', 'plugins/module_utils/network/nxos/argspec/lacp/.*',
            'plugins/module_utils/network/nxos/argspec/lacp_interfaces/*', 'plugins/module_utils/network/nxos/argspec/lacp_interfaces/.*',
            'plugins/module_utils/network/nxos/argspec/lag_interfaces/*', 'plugins/module_utils/network/nxos/argspec/lag_interfaces/.*',
            'plugins/module_utils/network/nxos/argspec/lldp_global/*', 'plugins/module_utils/network/nxos/argspec/lldp_global/.*',
            'plugins/module_utils/network/nxos/argspec/lldp_interfaces/*', 'plugins/module_utils/network/nxos/argspec/lldp_interfaces/.*',
            'plugins/module_utils/network/nxos/argspec/logging_global/*', 'plugins/module_utils/network/nxos/argspec/logging_global/.*',
            'plugins/module_utils/network/nxos/argspec/ntp_global/*', 'plugins/module_utils/network/nxos/argspec/ntp_global/.*',
            'plugins/module_utils/network/nxos/argspec/ospf_interfaces/*', 'plugins/module_utils/network/nxos/argspec/ospf_interfaces/.*',
            'plugins/module_utils/network/nxos/argspec/ospfv2/*', 'plugins/module_utils/network/nxos/argspec/ospfv2/.*',
            'plugins/module_utils/network/nxos/argspec/ospfv3/*', 'plugins/module_utils/network/nxos/argspec/ospfv3/.*',
            'plugins/module_utils/network/nxos/argspec/prefix_lists/*', 'plugins/module_utils/network/nxos/argspec/prefix_lists/.*',
            'plugins/module_utils/network/nxos/argspec/route_maps/*', 'plugins/module_utils/network/nxos/argspec/route_maps/.*',
            'plugins/module_utils/network/nxos/argspec/snmp_server/*', 'plugins/module_utils/network/nxos/argspec/snmp_server/.*',
            'plugins/module_utils/network/nxos/argspec/static_routes/*', 'plugins/module_utils/network/nxos/argspec/static_routes/.*',
            'plugins/module_utils/network/nxos/argspec/telemetry/*', 'plugins/module_utils/network/nxos/argspec/telemetry/.*',
            'plugins/module_utils/network/nxos/argspec/vlans/*', 'plugins/module_utils/network/nxos/argspec/vlans/.*',
            'plugins/module_utils/network/nxos/cmdref/*', 'plugins/module_utils/network/nxos/cmdref/.*',
            'plugins/module_utils/network/nxos/cmdref/telemetry/*', 'plugins/module_utils/network/nxos/cmdref/telemetry/.*',
            'plugins/module_utils/network/nxos/config/*', 'plugins/module_utils/network/nxos/config/.*',
            'plugins/module_utils/network/nxos/config/acl_interfaces/*', 'plugins/module_utils/network/nxos/config/acl_interfaces/.*',
            'plugins/module_utils/network/nxos/config/acls/*', 'plugins/module_utils/network/nxos/config/acls/.*',
            'plugins/module_utils/network/nxos/config/bfd_interfaces/*', 'plugins/module_utils/network/nxos/config/bfd_interfaces/.*',
            'plugins/module_utils/network/nxos/config/bgp_address_family/*', 'plugins/module_utils/network/nxos/config/bgp_address_family/.*',
            'plugins/module_utils/network/nxos/config/bgp_global/*', 'plugins/module_utils/network/nxos/config/bgp_global/.*',
            'plugins/module_utils/network/nxos/config/bgp_neighbor_address_family/*', 'plugins/module_utils/network/nxos/config/bgp_neighbor_address_family/.*',
            'plugins/module_utils/network/nxos/config/hostname/*', 'plugins/module_utils/network/nxos/config/hostname/.*',
            'plugins/module_utils/network/nxos/config/hsrp_interfaces/*', 'plugins/module_utils/network/nxos/config/hsrp_interfaces/.*',
            'plugins/module_utils/network/nxos/config/interfaces/*', 'plugins/module_utils/network/nxos/config/interfaces/.*',
            'plugins/module_utils/network/nxos/config/l2_interfaces/*', 'plugins/module_utils/network/nxos/config/l2_interfaces/.*',
            'plugins/module_utils/network/nxos/config/l3_interfaces/*', 'plugins/module_utils/network/nxos/config/l3_interfaces/.*',
            'plugins/module_utils/network/nxos/config/lacp/*', 'plugins/module_utils/network/nxos/config/lacp/.*',
            'plugins/module_utils/network/nxos/config/lacp_interfaces/*', 'plugins/module_utils/network/nxos/config/lacp_interfaces/.*',
            'plugins/module_utils/network/nxos/config/lag_interfaces/*', 'plugins/module_utils/network/nxos/config/lag_interfaces/.*',
            'plugins/module_utils/network/nxos/config/lldp_global/*', 'plugins/module_utils/network/nxos/config/lldp_global/.*',
            'plugins/module_utils/network/nxos/config/lldp_interfaces/*', 'plugins/module_utils/network/nxos/config/lldp_interfaces/.*',
            'plugins/module_utils/network/nxos/config/logging_global/*', 'plugins/module_utils/network/nxos/config/logging_global/.*',
            'plugins/module_utils/network/nxos/config/ntp_global/*', 'plugins/module_utils/network/nxos/config/ntp_global/.*',
            'plugins/module_utils/network/nxos/config/ospf_interfaces/*', 'plugins/module_utils/network/nxos/config/ospf_interfaces/.*',
            'plugins/module_utils/network/nxos/config/ospfv2/*', 'plugins/module_utils/network/nxos/config/ospfv2/.*',
            'plugins/module_utils/network/nxos/config/ospfv3/*', 'plugins/module_utils/network/nxos/config/ospfv3/.*',
            'plugins/module_utils/network/nxos/config/prefix_lists/*', 'plugins/module_utils/network/nxos/config/prefix_lists/.*',
            'plugins/module_utils/network/nxos/config/route_maps/*', 'plugins/module_utils/network/nxos/config/route_maps/.*',
            'plugins/module_utils/network/nxos/config/snmp_server/*', 'plugins/module_utils/network/nxos/config/snmp_server/.*',
            'plugins/module_utils/network/nxos/config/static_routes/*', 'plugins/module_utils/network/nxos/config/static_routes/.*',
            'plugins/module_utils/network/nxos/config/telemetry/*', 'plugins/module_utils/network/nxos/config/telemetry/.*',
            'plugins/module_utils/network/nxos/config/vlans/*', 'plugins/module_utils/network/nxos/config/vlans/.*',
            'plugins/module_utils/network/nxos/facts/*', 'plugins/module_utils/network/nxos/facts/.*',
            'plugins/module_utils/network/nxos/facts/acl_interfaces/*', 'plugins/module_utils/network/nxos/facts/acl_interfaces/.*',
            'plugins/module_utils/network/nxos/facts/acls/*', 'plugins/module_utils/network/nxos/facts/acls/.*',
            'plugins/module_utils/network/nxos/facts/bfd_interfaces/*', 'plugins/module_utils/network/nxos/facts/bfd_interfaces/.*',
            'plugins/module_utils/network/nxos/facts/bgp_address_family/*', 'plugins/module_utils/network/nxos/facts/bgp_address_family/.*',
            'plugins/module_utils/network/nxos/facts/bgp_global/*', 'plugins/module_utils/network/nxos/facts/bgp_global/.*',
            'plugins/module_utils/network/nxos/facts/bgp_neighbor_address_family/*', 'plugins/module_utils/network/nxos/facts/bgp_neighbor_address_family/.*',
            'plugins/module_utils/network/nxos/facts/hostname/*', 'plugins/module_utils/network/nxos/facts/hostname/.*',
            'plugins/module_utils/network/nxos/facts/hsrp_interfaces/*', 'plugins/module_utils/network/nxos/facts/hsrp_interfaces/.*',
            'plugins/module_utils/network/nxos/facts/interfaces/*', 'plugins/module_utils/network/nxos/facts/interfaces/.*',
            'plugins/module_utils/network/nxos/facts/l2_interfaces/*', 'plugins/module_utils/network/nxos/facts/l2_interfaces/.*',
            'plugins/module_utils/network/nxos/facts/l3_interfaces/*', 'plugins/module_utils/network/nxos/facts/l3_interfaces/.*',
            'plugins/module_utils/network/nxos/facts/lacp/*', 'plugins/module_utils/network/nxos/facts/lacp/.*',
            'plugins/module_utils/network/nxos/facts/lacp_interfaces/*', 'plugins/module_utils/network/nxos/facts/lacp_interfaces/.*',
            'plugins/module_utils/network/nxos/facts/lag_interfaces/*', 'plugins/module_utils/network/nxos/facts/lag_interfaces/.*',
            'plugins/module_utils/network/nxos/facts/legacy/*', 'plugins/module_utils/network/nxos/facts/legacy/.*',
            'plugins/module_utils/network/nxos/facts/lldp_global/*', 'plugins/module_utils/network/nxos/facts/lldp_global/.*',
            'plugins/module_utils/network/nxos/facts/lldp_interfaces/*', 'plugins/module_utils/network/nxos/facts/lldp_interfaces/.*',
            'plugins/module_utils/network/nxos/facts/logging_global/*', 'plugins/module_utils/network/nxos/facts/logging_global/.*',
            'plugins/module_utils/network/nxos/facts/ntp_global/*', 'plugins/module_utils/network/nxos/facts/ntp_global/.*',
            'plugins/module_utils/network/nxos/facts/ospf_interfaces/*', 'plugins/module_utils/network/nxos/facts/ospf_interfaces/.*',
            'plugins/module_utils/network/nxos/facts/ospfv2/*', 'plugins/module_utils/network/nxos/facts/ospfv2/.*',
            'plugins/module_utils/network/nxos/facts/ospfv3/*', 'plugins/module_utils/network/nxos/facts/ospfv3/.*',
            'plugins/module_utils/network/nxos/facts/prefix_lists/*', 'plugins/module_utils/network/nxos/facts/prefix_lists/.*',
            'plugins/module_utils/network/nxos/facts/route_maps/*', 'plugins/module_utils/network/nxos/facts/route_maps/.*',
            'plugins/module_utils/network/nxos/facts/snmp_server/*', 'plugins/module_utils/network/nxos/facts/snmp_server/.*',
            'plugins/module_utils/network/nxos/facts/static_routes/*', 'plugins/module_utils/network/nxos/facts/static_routes/.*',
            'plugins/module_utils/network/nxos/facts/telemetry/*', 'plugins/module_utils/network/nxos/facts/telemetry/.*',
            'plugins/module_utils/network/nxos/facts/vlans/*', 'plugins/module_utils/network/nxos/facts/vlans/.*',
            'plugins/module_utils/network/nxos/rm_templates/*', 'plugins/module_utils/network/nxos/rm_templates/.*',
            'plugins/module_utils/network/nxos/utils/*', 'plugins/module_utils/network/nxos/utils/.*',
            'plugins/module_utils/network/nxos/utils/telemetry/*', 'plugins/module_utils/network/nxos/utils/telemetry/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'plugins/modules/storage/*', 'plugins/modules/storage/.*',
            'plugins/netconf/*', 'plugins/netconf/.*',
            'plugins/terminal/*', 'plugins/terminal/.*',
        ],
        'ansible_collections.cisco.ucs': [
            '*',
            'meta/*', 'meta/.*',
            'misc/*', 'misc/.*',
            'playbooks/*', 'playbooks/.*',
            'playbooks/roles/*', 'playbooks/roles/.*',
            'playbooks/roles/servers/*', 'playbooks/roles/servers/.*',
            'playbooks/roles/servers/defaults/*', 'playbooks/roles/servers/defaults/.*',
            'playbooks/roles/servers/defaults/tasks/*', 'playbooks/roles/servers/defaults/tasks/.*',
            'playbooks/roles/servers/service_profile_templates/*', 'playbooks/roles/servers/service_profile_templates/.*',
            'playbooks/roles/servers/service_profile_templates/tasks/*', 'playbooks/roles/servers/service_profile_templates/tasks/.*',
            'playbooks/roles/servers/service_profiles/*', 'playbooks/roles/servers/service_profiles/.*',
            'playbooks/roles/servers/service_profiles/tasks/*', 'playbooks/roles/servers/service_profiles/tasks/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'roles/*', 'roles/.*',
        ],
        'ansible_collections.cloud.common': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/lookup/*', 'plugins/lookup/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/module_utils/turbo/*', 'plugins/module_utils/turbo/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'plugins/plugin_utils/*', 'plugins/plugin_utils/.*',
            'plugins/plugin_utils/turbo/*', 'plugins/plugin_utils/turbo/.*',
        ],
        'ansible_collections.cloudscale_ch.cloud': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/inventory/*', 'plugins/inventory/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.community.aws': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/connection/*', 'plugins/connection/.*',
            'plugins/inventory/*', 'plugins/inventory/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.community.azure': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
        ],
        'ansible_collections.community.ciscosmb': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/cliconf/*', 'plugins/cliconf/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'plugins/terminal/*', 'plugins/terminal/.*',
        ],
        'ansible_collections.community.crypto': [
            '*',
            'LICENSES/*', 'LICENSES/.*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/action/*', 'plugins/action/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/filter/*', 'plugins/filter/.*',
            'plugins/lookup/*', 'plugins/lookup/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/module_utils/acme/*', 'plugins/module_utils/acme/.*',
            'plugins/module_utils/crypto/*', 'plugins/module_utils/crypto/.*',
            'plugins/module_utils/crypto/module_backends/*', 'plugins/module_utils/crypto/module_backends/.*',
            'plugins/module_utils/ecs/*', 'plugins/module_utils/ecs/.*',
            'plugins/module_utils/gnupg/*', 'plugins/module_utils/gnupg/.*',
            'plugins/module_utils/openssh/*', 'plugins/module_utils/openssh/.*',
            'plugins/module_utils/openssh/backends/*', 'plugins/module_utils/openssh/backends/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'plugins/plugin_utils/*', 'plugins/plugin_utils/.*',
        ],
        'ansible_collections.community.digitalocean': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/inventory/*', 'plugins/inventory/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'scripts/*', 'scripts/.*',
            'scripts/inventory/*', 'scripts/inventory/.*',
        ],
        'ansible_collections.community.dns': [
            '*',
            'LICENSES/*', 'LICENSES/.*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/filter/*', 'plugins/filter/.*',
            'plugins/inventory/*', 'plugins/inventory/.*',
            'plugins/lookup/*', 'plugins/lookup/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/module_utils/conversion/*', 'plugins/module_utils/conversion/.*',
            'plugins/module_utils/hetzner/*', 'plugins/module_utils/hetzner/.*',
            'plugins/module_utils/hosttech/*', 'plugins/module_utils/hosttech/.*',
            'plugins/module_utils/module/*', 'plugins/module_utils/module/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'plugins/plugin_utils/*', 'plugins/plugin_utils/.*',
            'plugins/plugin_utils/inventory/*', 'plugins/plugin_utils/inventory/.*',
        ],
        'ansible_collections.community.docker': [
            '*',
            'LICENSES/*', 'LICENSES/.*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/action/*', 'plugins/action/.*',
            'plugins/connection/*', 'plugins/connection/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/inventory/*', 'plugins/inventory/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/module_utils/_api/*', 'plugins/module_utils/_api/.*',
            'plugins/module_utils/_api/api/*', 'plugins/module_utils/_api/api/.*',
            'plugins/module_utils/_api/credentials/*', 'plugins/module_utils/_api/credentials/.*',
            'plugins/module_utils/_api/transport/*', 'plugins/module_utils/_api/transport/.*',
            'plugins/module_utils/_api/types/*', 'plugins/module_utils/_api/types/.*',
            'plugins/module_utils/_api/utils/*', 'plugins/module_utils/_api/utils/.*',
            'plugins/module_utils/module_container/*', 'plugins/module_utils/module_container/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'plugins/plugin_utils/*', 'plugins/plugin_utils/.*',
        ],
        'ansible_collections.community.fortios': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/httpapi/*', 'plugins/httpapi/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/module_utils/fortianalyzer/*', 'plugins/module_utils/fortianalyzer/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.community.general': [
            '*',
            'LICENSES/*', 'LICENSES/.*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/action/*', 'plugins/action/.*',
            'plugins/become/*', 'plugins/become/.*',
            'plugins/cache/*', 'plugins/cache/.*',
            'plugins/callback/*', 'plugins/callback/.*',
            'plugins/connection/*', 'plugins/connection/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/filter/*', 'plugins/filter/.*',
            'plugins/inventory/*', 'plugins/inventory/.*',
            'plugins/lookup/*', 'plugins/lookup/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/module_utils/identity/*', 'plugins/module_utils/identity/.*',
            'plugins/module_utils/identity/keycloak/*', 'plugins/module_utils/identity/keycloak/.*',
            'plugins/module_utils/mh/*', 'plugins/module_utils/mh/.*',
            'plugins/module_utils/mh/mixins/*', 'plugins/module_utils/mh/mixins/.*',
            'plugins/module_utils/net_tools/*', 'plugins/module_utils/net_tools/.*',
            'plugins/module_utils/net_tools/pritunl/*', 'plugins/module_utils/net_tools/pritunl/.*',
            'plugins/module_utils/oracle/*', 'plugins/module_utils/oracle/.*',
            'plugins/module_utils/remote_management/*', 'plugins/module_utils/remote_management/.*',
            'plugins/module_utils/remote_management/lxca/*', 'plugins/module_utils/remote_management/lxca/.*',
            'plugins/module_utils/source_control/*', 'plugins/module_utils/source_control/.*',
            'plugins/module_utils/storage/*', 'plugins/module_utils/storage/.*',
            'plugins/module_utils/storage/emc/*', 'plugins/module_utils/storage/emc/.*',
            'plugins/module_utils/storage/hpe3par/*', 'plugins/module_utils/storage/hpe3par/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'plugins/test/*', 'plugins/test/.*',
        ],
        'ansible_collections.community.google': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/lookup/*', 'plugins/lookup/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'scripts/*', 'scripts/.*',
            'scripts/inventory/*', 'scripts/inventory/.*',
        ],
        'ansible_collections.community.grafana': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'hacking/*', 'hacking/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/callback/*', 'plugins/callback/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/lookup/*', 'plugins/lookup/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.community.hashi_vault': [
            '*',
            'LICENSES/*', 'LICENSES/.*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/filter/*', 'plugins/filter/.*',
            'plugins/lookup/*', 'plugins/lookup/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'plugins/plugin_utils/*', 'plugins/plugin_utils/.*',
        ],
        'ansible_collections.community.hrobot': [
            '*',
            'LICENSES/*', 'LICENSES/.*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/inventory/*', 'plugins/inventory/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.community.libvirt': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/connection/*', 'plugins/connection/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/inventory/*', 'plugins/inventory/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.community.mongodb': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/cache/*', 'plugins/cache/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/lookup/*', 'plugins/lookup/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'roles/*', 'roles/.*',
            'roles/mongodb_auth/*', 'roles/mongodb_auth/.*',
            'roles/mongodb_auth/defaults/*', 'roles/mongodb_auth/defaults/.*',
            'roles/mongodb_auth/meta/*', 'roles/mongodb_auth/meta/.*',
            'roles/mongodb_auth/molecule/*', 'roles/mongodb_auth/molecule/.*',
            'roles/mongodb_auth/molecule/default/*', 'roles/mongodb_auth/molecule/default/.*',
            'roles/mongodb_auth/molecule/default/tests/*', 'roles/mongodb_auth/molecule/default/tests/.*',
            'roles/mongodb_auth/molecule/virtualbox/*', 'roles/mongodb_auth/molecule/virtualbox/.*',
            'roles/mongodb_auth/molecule/virtualbox/tests/*', 'roles/mongodb_auth/molecule/virtualbox/tests/.*',
            'roles/mongodb_auth/tasks/*', 'roles/mongodb_auth/tasks/.*',
            'roles/mongodb_auth/vars/*', 'roles/mongodb_auth/vars/.*',
            'roles/mongodb_config/*', 'roles/mongodb_config/.*',
            'roles/mongodb_config/defaults/*', 'roles/mongodb_config/defaults/.*',
            'roles/mongodb_config/handlers/*', 'roles/mongodb_config/handlers/.*',
            'roles/mongodb_config/meta/*', 'roles/mongodb_config/meta/.*',
            'roles/mongodb_config/molecule/*', 'roles/mongodb_config/molecule/.*',
            'roles/mongodb_config/molecule/custom_db_path/*', 'roles/mongodb_config/molecule/custom_db_path/.*',
            'roles/mongodb_config/molecule/custom_db_path/tests/*', 'roles/mongodb_config/molecule/custom_db_path/tests/.*',
            'roles/mongodb_config/molecule/default/*', 'roles/mongodb_config/molecule/default/.*',
            'roles/mongodb_config/molecule/default/tests/*', 'roles/mongodb_config/molecule/default/tests/.*',
            'roles/mongodb_config/molecule/virtualbox/*', 'roles/mongodb_config/molecule/virtualbox/.*',
            'roles/mongodb_config/molecule/virtualbox/tests/*', 'roles/mongodb_config/molecule/virtualbox/tests/.*',
            'roles/mongodb_config/tasks/*', 'roles/mongodb_config/tasks/.*',
            'roles/mongodb_config/templates/*', 'roles/mongodb_config/templates/.*',
            'roles/mongodb_config/vars/*', 'roles/mongodb_config/vars/.*',
            'roles/mongodb_install/*', 'roles/mongodb_install/.*',
            'roles/mongodb_install/files/*', 'roles/mongodb_install/files/.*',
            'roles/mongodb_install/meta/*', 'roles/mongodb_install/meta/.*',
            'roles/mongodb_install/molecule/*', 'roles/mongodb_install/molecule/.*',
            'roles/mongodb_install/molecule/default/*', 'roles/mongodb_install/molecule/default/.*',
            'roles/mongodb_install/molecule/default/tests/*', 'roles/mongodb_install/molecule/default/tests/.*',
            'roles/mongodb_install/molecule/mongodb_hold_packages/*', 'roles/mongodb_install/molecule/mongodb_hold_packages/.*',
            'roles/mongodb_install/molecule/mongodb_hold_packages/tests/*', 'roles/mongodb_install/molecule/mongodb_hold_packages/tests/.*',
            'roles/mongodb_install/molecule/mongodb_nohold_packages/*', 'roles/mongodb_install/molecule/mongodb_nohold_packages/.*',
            'roles/mongodb_install/molecule/mongodb_nohold_packages/tests/*', 'roles/mongodb_install/molecule/mongodb_nohold_packages/tests/.*',
            'roles/mongodb_install/molecule/specific_mongodb_version/*', 'roles/mongodb_install/molecule/specific_mongodb_version/.*',
            'roles/mongodb_install/molecule/specific_mongodb_version/tests/*', 'roles/mongodb_install/molecule/specific_mongodb_version/tests/.*',
            'roles/mongodb_install/molecule/virtualbox/*', 'roles/mongodb_install/molecule/virtualbox/.*',
            'roles/mongodb_install/molecule/virtualbox/tests/*', 'roles/mongodb_install/molecule/virtualbox/tests/.*',
            'roles/mongodb_install/tasks/*', 'roles/mongodb_install/tasks/.*',
            'roles/mongodb_linux/*', 'roles/mongodb_linux/.*',
            'roles/mongodb_linux/defaults/*', 'roles/mongodb_linux/defaults/.*',
            'roles/mongodb_linux/files/*', 'roles/mongodb_linux/files/.*',
            'roles/mongodb_linux/meta/*', 'roles/mongodb_linux/meta/.*',
            'roles/mongodb_linux/molecule/*', 'roles/mongodb_linux/molecule/.*',
            'roles/mongodb_linux/molecule/default/*', 'roles/mongodb_linux/molecule/default/.*',
            'roles/mongodb_linux/molecule/default/tests/*', 'roles/mongodb_linux/molecule/default/tests/.*',
            'roles/mongodb_linux/molecule/virtualbox/*', 'roles/mongodb_linux/molecule/virtualbox/.*',
            'roles/mongodb_linux/molecule/virtualbox/tests/*', 'roles/mongodb_linux/molecule/virtualbox/tests/.*',
            'roles/mongodb_linux/tasks/*', 'roles/mongodb_linux/tasks/.*',
            'roles/mongodb_linux/vars/*', 'roles/mongodb_linux/vars/.*',
            'roles/mongodb_mongod/*', 'roles/mongodb_mongod/.*',
            'roles/mongodb_mongod/defaults/*', 'roles/mongodb_mongod/defaults/.*',
            'roles/mongodb_mongod/handlers/*', 'roles/mongodb_mongod/handlers/.*',
            'roles/mongodb_mongod/meta/*', 'roles/mongodb_mongod/meta/.*',
            'roles/mongodb_mongod/molecule/*', 'roles/mongodb_mongod/molecule/.*',
            'roles/mongodb_mongod/molecule/custom_db_path/*', 'roles/mongodb_mongod/molecule/custom_db_path/.*',
            'roles/mongodb_mongod/molecule/custom_db_path/tests/*', 'roles/mongodb_mongod/molecule/custom_db_path/tests/.*',
            'roles/mongodb_mongod/molecule/default/*', 'roles/mongodb_mongod/molecule/default/.*',
            'roles/mongodb_mongod/molecule/default/tests/*', 'roles/mongodb_mongod/molecule/default/tests/.*',
            'roles/mongodb_mongod/molecule/multiple_bind_ip/*', 'roles/mongodb_mongod/molecule/multiple_bind_ip/.*',
            'roles/mongodb_mongod/molecule/multiple_bind_ip/tests/*', 'roles/mongodb_mongod/molecule/multiple_bind_ip/tests/.*',
            'roles/mongodb_mongod/molecule/virtualbox/*', 'roles/mongodb_mongod/molecule/virtualbox/.*',
            'roles/mongodb_mongod/molecule/virtualbox/tests/*', 'roles/mongodb_mongod/molecule/virtualbox/tests/.*',
            'roles/mongodb_mongod/tasks/*', 'roles/mongodb_mongod/tasks/.*',
            'roles/mongodb_mongod/templates/*', 'roles/mongodb_mongod/templates/.*',
            'roles/mongodb_mongod/vars/*', 'roles/mongodb_mongod/vars/.*',
            'roles/mongodb_mongos/*', 'roles/mongodb_mongos/.*',
            'roles/mongodb_mongos/defaults/*', 'roles/mongodb_mongos/defaults/.*',
            'roles/mongodb_mongos/handlers/*', 'roles/mongodb_mongos/handlers/.*',
            'roles/mongodb_mongos/meta/*', 'roles/mongodb_mongos/meta/.*',
            'roles/mongodb_mongos/molecule/*', 'roles/mongodb_mongos/molecule/.*',
            'roles/mongodb_mongos/molecule/default/*', 'roles/mongodb_mongos/molecule/default/.*',
            'roles/mongodb_mongos/molecule/default/tests/*', 'roles/mongodb_mongos/molecule/default/tests/.*',
            'roles/mongodb_mongos/molecule/virtualbox/*', 'roles/mongodb_mongos/molecule/virtualbox/.*',
            'roles/mongodb_mongos/molecule/virtualbox/tests/*', 'roles/mongodb_mongos/molecule/virtualbox/tests/.*',
            'roles/mongodb_mongos/tasks/*', 'roles/mongodb_mongos/tasks/.*',
            'roles/mongodb_mongos/templates/*', 'roles/mongodb_mongos/templates/.*',
            'roles/mongodb_mongos/vars/*', 'roles/mongodb_mongos/vars/.*',
            'roles/mongodb_repository/*', 'roles/mongodb_repository/.*',
            'roles/mongodb_repository/defaults/*', 'roles/mongodb_repository/defaults/.*',
            'roles/mongodb_repository/meta/*', 'roles/mongodb_repository/meta/.*',
            'roles/mongodb_repository/molecule/*', 'roles/mongodb_repository/molecule/.*',
            'roles/mongodb_repository/molecule/default/*', 'roles/mongodb_repository/molecule/default/.*',
            'roles/mongodb_repository/molecule/default/tests/*', 'roles/mongodb_repository/molecule/default/tests/.*',
            'roles/mongodb_repository/molecule/virtualbox/*', 'roles/mongodb_repository/molecule/virtualbox/.*',
            'roles/mongodb_repository/molecule/virtualbox/tests/*', 'roles/mongodb_repository/molecule/virtualbox/tests/.*',
            'roles/mongodb_repository/tasks/*', 'roles/mongodb_repository/tasks/.*',
            'roles/mongodb_selinux/*', 'roles/mongodb_selinux/.*',
            'roles/mongodb_selinux/files/*', 'roles/mongodb_selinux/files/.*',
            'roles/mongodb_selinux/meta/*', 'roles/mongodb_selinux/meta/.*',
            'roles/mongodb_selinux/molecule/*', 'roles/mongodb_selinux/molecule/.*',
            'roles/mongodb_selinux/molecule/default/*', 'roles/mongodb_selinux/molecule/default/.*',
            'roles/mongodb_selinux/molecule/default/tests/*', 'roles/mongodb_selinux/molecule/default/tests/.*',
            'roles/mongodb_selinux/molecule/virtualbox/*', 'roles/mongodb_selinux/molecule/virtualbox/.*',
            'roles/mongodb_selinux/molecule/virtualbox/tests/*', 'roles/mongodb_selinux/molecule/virtualbox/tests/.*',
            'roles/mongodb_selinux/tasks/*', 'roles/mongodb_selinux/tasks/.*',
            'roles/mongodb_selinux/vars/*', 'roles/mongodb_selinux/vars/.*',
        ],
        'ansible_collections.community.mysql': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/module_utils/implementations/*', 'plugins/module_utils/implementations/.*',
            'plugins/module_utils/implementations/mariadb/*', 'plugins/module_utils/implementations/mariadb/.*',
            'plugins/module_utils/implementations/mysql/*', 'plugins/module_utils/implementations/mysql/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'test-containers/*', 'test-containers/.*',
            'test-containers/mariadb-py310-mysqlclient211/*', 'test-containers/mariadb-py310-mysqlclient211/.*',
            'test-containers/mariadb-py310-pymysql102/*', 'test-containers/mariadb-py310-pymysql102/.*',
            'test-containers/mariadb-py38-mysqlclient201/*', 'test-containers/mariadb-py38-mysqlclient201/.*',
            'test-containers/mariadb-py38-pymysql093/*', 'test-containers/mariadb-py38-pymysql093/.*',
            'test-containers/mariadb-py39-mysqlclient203/*', 'test-containers/mariadb-py39-mysqlclient203/.*',
            'test-containers/mariadb-py39-pymysql093/*', 'test-containers/mariadb-py39-pymysql093/.*',
            'test-containers/my57-py38-mysqlclient201/*', 'test-containers/my57-py38-mysqlclient201/.*',
            'test-containers/my57-py38-pymysql0711/*', 'test-containers/my57-py38-pymysql0711/.*',
            'test-containers/my57-py38-pymysql093/*', 'test-containers/my57-py38-pymysql093/.*',
            'test-containers/mysql-py310-mysqlclient211/*', 'test-containers/mysql-py310-mysqlclient211/.*',
            'test-containers/mysql-py310-pymysql102/*', 'test-containers/mysql-py310-pymysql102/.*',
            'test-containers/mysql-py38-mysqlclient201/*', 'test-containers/mysql-py38-mysqlclient201/.*',
            'test-containers/mysql-py38-pymysql093/*', 'test-containers/mysql-py38-pymysql093/.*',
            'test-containers/mysql-py39-mysqlclient203/*', 'test-containers/mysql-py39-mysqlclient203/.*',
            'test-containers/mysql-py39-pymysql093/*', 'test-containers/mysql-py39-pymysql093/.*',
        ],
        'ansible_collections.community.network': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/action/*', 'plugins/action/.*',
            'plugins/become/*', 'plugins/become/.*',
            'plugins/cache/*', 'plugins/cache/.*',
            'plugins/callback/*', 'plugins/callback/.*',
            'plugins/cliconf/*', 'plugins/cliconf/.*',
            'plugins/connection/*', 'plugins/connection/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/filter/*', 'plugins/filter/.*',
            'plugins/httpapi/*', 'plugins/httpapi/.*',
            'plugins/inventory/*', 'plugins/inventory/.*',
            'plugins/lookup/*', 'plugins/lookup/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/module_utils/network/*', 'plugins/module_utils/network/.*',
            'plugins/module_utils/network/a10/*', 'plugins/module_utils/network/a10/.*',
            'plugins/module_utils/network/aireos/*', 'plugins/module_utils/network/aireos/.*',
            'plugins/module_utils/network/aos/*', 'plugins/module_utils/network/aos/.*',
            'plugins/module_utils/network/apconos/*', 'plugins/module_utils/network/apconos/.*',
            'plugins/module_utils/network/aruba/*', 'plugins/module_utils/network/aruba/.*',
            'plugins/module_utils/network/avi/*', 'plugins/module_utils/network/avi/.*',
            'plugins/module_utils/network/bigswitch/*', 'plugins/module_utils/network/bigswitch/.*',
            'plugins/module_utils/network/cloudengine/*', 'plugins/module_utils/network/cloudengine/.*',
            'plugins/module_utils/network/cnos/*', 'plugins/module_utils/network/cnos/.*',
            'plugins/module_utils/network/edgeos/*', 'plugins/module_utils/network/edgeos/.*',
            'plugins/module_utils/network/edgeswitch/*', 'plugins/module_utils/network/edgeswitch/.*',
            'plugins/module_utils/network/enos/*', 'plugins/module_utils/network/enos/.*',
            'plugins/module_utils/network/eric_eccli/*', 'plugins/module_utils/network/eric_eccli/.*',
            'plugins/module_utils/network/exos/*', 'plugins/module_utils/network/exos/.*',
            'plugins/module_utils/network/exos/argspec/*', 'plugins/module_utils/network/exos/argspec/.*',
            'plugins/module_utils/network/exos/argspec/facts/*', 'plugins/module_utils/network/exos/argspec/facts/.*',
            'plugins/module_utils/network/exos/argspec/l2_interfaces/*', 'plugins/module_utils/network/exos/argspec/l2_interfaces/.*',
            'plugins/module_utils/network/exos/argspec/lldp_global/*', 'plugins/module_utils/network/exos/argspec/lldp_global/.*',
            'plugins/module_utils/network/exos/argspec/lldp_interfaces/*', 'plugins/module_utils/network/exos/argspec/lldp_interfaces/.*',
            'plugins/module_utils/network/exos/argspec/vlans/*', 'plugins/module_utils/network/exos/argspec/vlans/.*',
            'plugins/module_utils/network/exos/config/*', 'plugins/module_utils/network/exos/config/.*',
            'plugins/module_utils/network/exos/config/l2_interfaces/*', 'plugins/module_utils/network/exos/config/l2_interfaces/.*',
            'plugins/module_utils/network/exos/config/lldp_global/*', 'plugins/module_utils/network/exos/config/lldp_global/.*',
            'plugins/module_utils/network/exos/config/lldp_interfaces/*', 'plugins/module_utils/network/exos/config/lldp_interfaces/.*',
            'plugins/module_utils/network/exos/config/vlans/*', 'plugins/module_utils/network/exos/config/vlans/.*',
            'plugins/module_utils/network/exos/facts/*', 'plugins/module_utils/network/exos/facts/.*',
            'plugins/module_utils/network/exos/facts/l2_interfaces/*', 'plugins/module_utils/network/exos/facts/l2_interfaces/.*',
            'plugins/module_utils/network/exos/facts/legacy/*', 'plugins/module_utils/network/exos/facts/legacy/.*',
            'plugins/module_utils/network/exos/facts/lldp_global/*', 'plugins/module_utils/network/exos/facts/lldp_global/.*',
            'plugins/module_utils/network/exos/facts/lldp_interfaces/*', 'plugins/module_utils/network/exos/facts/lldp_interfaces/.*',
            'plugins/module_utils/network/exos/facts/vlans/*', 'plugins/module_utils/network/exos/facts/vlans/.*',
            'plugins/module_utils/network/exos/utils/*', 'plugins/module_utils/network/exos/utils/.*',
            'plugins/module_utils/network/ftd/*', 'plugins/module_utils/network/ftd/.*',
            'plugins/module_utils/network/icx/*', 'plugins/module_utils/network/icx/.*',
            'plugins/module_utils/network/ingate/*', 'plugins/module_utils/network/ingate/.*',
            'plugins/module_utils/network/ironware/*', 'plugins/module_utils/network/ironware/.*',
            'plugins/module_utils/network/netscaler/*', 'plugins/module_utils/network/netscaler/.*',
            'plugins/module_utils/network/netvisor/*', 'plugins/module_utils/network/netvisor/.*',
            'plugins/module_utils/network/nos/*', 'plugins/module_utils/network/nos/.*',
            'plugins/module_utils/network/ordnance/*', 'plugins/module_utils/network/ordnance/.*',
            'plugins/module_utils/network/slxos/*', 'plugins/module_utils/network/slxos/.*',
            'plugins/module_utils/network/sros/*', 'plugins/module_utils/network/sros/.*',
            'plugins/module_utils/network/voss/*', 'plugins/module_utils/network/voss/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'plugins/netconf/*', 'plugins/netconf/.*',
            'plugins/terminal/*', 'plugins/terminal/.*',
        ],
        'ansible_collections.community.okd': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'ci/*', 'ci/.*',
            'meta/*', 'meta/.*',
            'molecule/*', 'molecule/.*',
            'molecule/default/*', 'molecule/default/.*',
            'molecule/default/files/*', 'molecule/default/files/.*',
            'molecule/default/roles/*', 'molecule/default/roles/.*',
            'molecule/default/roles/openshift_adm_groups/*', 'molecule/default/roles/openshift_adm_groups/.*',
            'molecule/default/roles/openshift_adm_groups/defaults/*', 'molecule/default/roles/openshift_adm_groups/defaults/.*',
            'molecule/default/roles/openshift_adm_groups/library/*', 'molecule/default/roles/openshift_adm_groups/library/.*',
            'molecule/default/roles/openshift_adm_groups/meta/*', 'molecule/default/roles/openshift_adm_groups/meta/.*',
            'molecule/default/roles/openshift_adm_groups/tasks/*', 'molecule/default/roles/openshift_adm_groups/tasks/.*',
            'molecule/default/roles/openshift_adm_groups/templates/*', 'molecule/default/roles/openshift_adm_groups/templates/.*',
            'molecule/default/roles/openshift_adm_groups/templates/ad/*', 'molecule/default/roles/openshift_adm_groups/templates/ad/.*',
            'molecule/default/roles/openshift_adm_groups/templates/augmented-ad/*', 'molecule/default/roles/openshift_adm_groups/templates/augmented-ad/.*',
            'molecule/default/roles/openshift_adm_groups/templates/rfc2307/*', 'molecule/default/roles/openshift_adm_groups/templates/rfc2307/.*',
            'molecule/default/tasks/*', 'molecule/default/tasks/.*',
            'molecule/default/vars/*', 'molecule/default/vars/.*',
            'plugins/*', 'plugins/.*',
            'plugins/connection/*', 'plugins/connection/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/inventory/*', 'plugins/inventory/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.community.postgresql': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.community.proxysql': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'roles/*', 'roles/.*',
            'roles/proxysql/*', 'roles/proxysql/.*',
            'roles/proxysql/defaults/*', 'roles/proxysql/defaults/.*',
            'roles/proxysql/handlers/*', 'roles/proxysql/handlers/.*',
            'roles/proxysql/meta/*', 'roles/proxysql/meta/.*',
            'roles/proxysql/molecule/*', 'roles/proxysql/molecule/.*',
            'roles/proxysql/molecule/default/*', 'roles/proxysql/molecule/default/.*',
            'roles/proxysql/molecule/default/tests/*', 'roles/proxysql/molecule/default/tests/.*',
            'roles/proxysql/tasks/*', 'roles/proxysql/tasks/.*',
            'roles/proxysql/templates/*', 'roles/proxysql/templates/.*',
            'roles/proxysql/vars/*', 'roles/proxysql/vars/.*',
        ],
        'ansible_collections.community.rabbitmq': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/lookup/*', 'plugins/lookup/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.community.routeros': [
            '*',
            'LICENSES/*', 'LICENSES/.*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/cliconf/*', 'plugins/cliconf/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/filter/*', 'plugins/filter/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'plugins/terminal/*', 'plugins/terminal/.*',
        ],
        'ansible_collections.community.sap': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'plugins/modules/database/*', 'plugins/modules/database/.*',
            'plugins/modules/database/saphana/*', 'plugins/modules/database/saphana/.*',
            'plugins/modules/files/*', 'plugins/modules/files/.*',
            'plugins/modules/identity/*', 'plugins/modules/identity/.*',
            'plugins/modules/system/*', 'plugins/modules/system/.*',
        ],
        'ansible_collections.community.sap_libs': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.community.skydive': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/lookup/*', 'plugins/lookup/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/module_utils/network/*', 'plugins/module_utils/network/.*',
            'plugins/module_utils/network/skydive/*', 'plugins/module_utils/network/skydive/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.community.sops': [
            '*',
            'LICENSES/*', 'LICENSES/.*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'playbooks/*', 'playbooks/.*',
            'plugins/*', 'plugins/.*',
            'plugins/action/*', 'plugins/action/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/filter/*', 'plugins/filter/.*',
            'plugins/lookup/*', 'plugins/lookup/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'plugins/plugin_utils/*', 'plugins/plugin_utils/.*',
            'plugins/vars/*', 'plugins/vars/.*',
            'roles/*', 'roles/.*',
            'roles/_install_age/*', 'roles/_install_age/.*',
            'roles/_install_age/defaults/*', 'roles/_install_age/defaults/.*',
            'roles/_install_age/meta/*', 'roles/_install_age/meta/.*',
            'roles/_install_age/tasks/*', 'roles/_install_age/tasks/.*',
            'roles/_install_age/vars/*', 'roles/_install_age/vars/.*',
            'roles/install/*', 'roles/install/.*',
            'roles/install/defaults/*', 'roles/install/defaults/.*',
            'roles/install/meta/*', 'roles/install/meta/.*',
            'roles/install/tasks/*', 'roles/install/tasks/.*',
            'roles/install/vars/*', 'roles/install/vars/.*',
        ],
        'ansible_collections.community.vmware': [
            '*',
            'LICENSES/*', 'LICENSES/.*',
            'changelogs/*', 'changelogs/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/connection/*', 'plugins/connection/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/httpapi/*', 'plugins/httpapi/.*',
            'plugins/inventory/*', 'plugins/inventory/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'plugins/plugin_utils/*', 'plugins/plugin_utils/.*',
            'scripts/*', 'scripts/.*',
            'scripts/inventory/*', 'scripts/inventory/.*',
            'tools/*', 'tools/.*',
        ],
        'ansible_collections.community.windows': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/action/*', 'plugins/action/.*',
            'plugins/lookup/*', 'plugins/lookup/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.community.zabbix': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'molecule/*', 'molecule/.*',
            'molecule/zabbix_agent_tests/*', 'molecule/zabbix_agent_tests/.*',
            'molecule/zabbix_agent_tests/common/*', 'molecule/zabbix_agent_tests/common/.*',
            'molecule/zabbix_agent_tests/common/playbooks/*', 'molecule/zabbix_agent_tests/common/playbooks/.*',
            'molecule/zabbix_agent_tests/common/tests/*', 'molecule/zabbix_agent_tests/common/tests/.*',
            'molecule/zabbix_agent_tests/common/tests/agent2_common/*', 'molecule/zabbix_agent_tests/common/tests/agent2_common/.*',
            'molecule/zabbix_agent_tests/common/tests/autopsk/*', 'molecule/zabbix_agent_tests/common/tests/autopsk/.*',
            'molecule/zabbix_agent_tests/common/tests/common/*', 'molecule/zabbix_agent_tests/common/tests/common/.*',
            'molecule/zabbix_agent_tests/common/tests/no_auto_psk/*', 'molecule/zabbix_agent_tests/common/tests/no_auto_psk/.*',
            'molecule/zabbix_agent_tests/molecule/*', 'molecule/zabbix_agent_tests/molecule/.*',
            'molecule/zabbix_agent_tests/molecule/agent2/*', 'molecule/zabbix_agent_tests/molecule/agent2/.*',
            'molecule/zabbix_agent_tests/molecule/agent2/tests/*', 'molecule/zabbix_agent_tests/molecule/agent2/tests/.*',
            'molecule/zabbix_agent_tests/molecule/agent2/tests/agent2_common/*', 'molecule/zabbix_agent_tests/molecule/agent2/tests/agent2_common/.*',
            'molecule/zabbix_agent_tests/molecule/agent2/tests/common/*', 'molecule/zabbix_agent_tests/molecule/agent2/tests/common/.*',
            'molecule/zabbix_agent_tests/molecule/agent2/tests/no_auto_psk/*', 'molecule/zabbix_agent_tests/molecule/agent2/tests/no_auto_psk/.*',
            'molecule/zabbix_agent_tests/molecule/agent2autopsk/*', 'molecule/zabbix_agent_tests/molecule/agent2autopsk/.*',
            'molecule/zabbix_agent_tests/molecule/agent2autopsk/tests/*', 'molecule/zabbix_agent_tests/molecule/agent2autopsk/tests/.*',
            'molecule/zabbix_agent_tests/molecule/agent2autopsk/tests/agent2_common/*', 'molecule/zabbix_agent_tests/molecule/agent2autopsk/tests/agent2_common/.*',
            'molecule/zabbix_agent_tests/molecule/agent2autopsk/tests/autopsk/*', 'molecule/zabbix_agent_tests/molecule/agent2autopsk/tests/autopsk/.*',
            'molecule/zabbix_agent_tests/molecule/agent2autopsk/tests/common/*', 'molecule/zabbix_agent_tests/molecule/agent2autopsk/tests/common/.*',
            'molecule/zabbix_agent_tests/molecule/autopsk/*', 'molecule/zabbix_agent_tests/molecule/autopsk/.*',
            'molecule/zabbix_agent_tests/molecule/autopsk/tests/*', 'molecule/zabbix_agent_tests/molecule/autopsk/tests/.*',
            'molecule/zabbix_agent_tests/molecule/autopsk/tests/autopsk/*', 'molecule/zabbix_agent_tests/molecule/autopsk/tests/autopsk/.*',
            'molecule/zabbix_agent_tests/molecule/autopsk/tests/common/*', 'molecule/zabbix_agent_tests/molecule/autopsk/tests/common/.*',
            'molecule/zabbix_agent_tests/molecule/default/*', 'molecule/zabbix_agent_tests/molecule/default/.*',
            'molecule/zabbix_agent_tests/molecule/default/tests/*', 'molecule/zabbix_agent_tests/molecule/default/tests/.*',
            'molecule/zabbix_agent_tests/molecule/default/tests/common/*', 'molecule/zabbix_agent_tests/molecule/default/tests/common/.*',
            'molecule/zabbix_agent_tests/molecule/default/tests/no_auto_psk/*', 'molecule/zabbix_agent_tests/molecule/default/tests/no_auto_psk/.*',
            'molecule/zabbix_javagateway/*', 'molecule/zabbix_javagateway/.*',
            'molecule/zabbix_javagateway/tests/*', 'molecule/zabbix_javagateway/tests/.*',
            'molecule/zabbix_proxy/*', 'molecule/zabbix_proxy/.*',
            'molecule/zabbix_proxy/tests/*', 'molecule/zabbix_proxy/tests/.*',
            'molecule/zabbix_server/*', 'molecule/zabbix_server/.*',
            'molecule/zabbix_server/tests/*', 'molecule/zabbix_server/tests/.*',
            'molecule/zabbix_web/*', 'molecule/zabbix_web/.*',
            'molecule/zabbix_web/tests/*', 'molecule/zabbix_web/tests/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/httpapi/*', 'plugins/httpapi/.*',
            'plugins/inventory/*', 'plugins/inventory/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'roles/*', 'roles/.*',
            'roles/zabbix_agent/*', 'roles/zabbix_agent/.*',
            'roles/zabbix_agent/defaults/*', 'roles/zabbix_agent/defaults/.*',
            'roles/zabbix_agent/files/*', 'roles/zabbix_agent/files/.*',
            'roles/zabbix_agent/files/win_sample/*', 'roles/zabbix_agent/files/win_sample/.*',
            'roles/zabbix_agent/handlers/*', 'roles/zabbix_agent/handlers/.*',
            'roles/zabbix_agent/meta/*', 'roles/zabbix_agent/meta/.*',
            'roles/zabbix_agent/molecule/*', 'roles/zabbix_agent/molecule/.*',
            'roles/zabbix_agent/molecule/with-server/*', 'roles/zabbix_agent/molecule/with-server/.*',
            'roles/zabbix_agent/molecule/with-server/tests/*', 'roles/zabbix_agent/molecule/with-server/tests/.*',
            'roles/zabbix_agent/tasks/*', 'roles/zabbix_agent/tasks/.*',
            'roles/zabbix_agent/templates/*', 'roles/zabbix_agent/templates/.*',
            'roles/zabbix_agent/templates/userparameters/*', 'roles/zabbix_agent/templates/userparameters/.*',
            'roles/zabbix_agent/vars/*', 'roles/zabbix_agent/vars/.*',
            'roles/zabbix_javagateway/*', 'roles/zabbix_javagateway/.*',
            'roles/zabbix_javagateway/defaults/*', 'roles/zabbix_javagateway/defaults/.*',
            'roles/zabbix_javagateway/files/*', 'roles/zabbix_javagateway/files/.*',
            'roles/zabbix_javagateway/handlers/*', 'roles/zabbix_javagateway/handlers/.*',
            'roles/zabbix_javagateway/meta/*', 'roles/zabbix_javagateway/meta/.*',
            'roles/zabbix_javagateway/tasks/*', 'roles/zabbix_javagateway/tasks/.*',
            'roles/zabbix_javagateway/templates/*', 'roles/zabbix_javagateway/templates/.*',
            'roles/zabbix_javagateway/vars/*', 'roles/zabbix_javagateway/vars/.*',
            'roles/zabbix_proxy/*', 'roles/zabbix_proxy/.*',
            'roles/zabbix_proxy/defaults/*', 'roles/zabbix_proxy/defaults/.*',
            'roles/zabbix_proxy/files/*', 'roles/zabbix_proxy/files/.*',
            'roles/zabbix_proxy/handlers/*', 'roles/zabbix_proxy/handlers/.*',
            'roles/zabbix_proxy/meta/*', 'roles/zabbix_proxy/meta/.*',
            'roles/zabbix_proxy/tasks/*', 'roles/zabbix_proxy/tasks/.*',
            'roles/zabbix_proxy/templates/*', 'roles/zabbix_proxy/templates/.*',
            'roles/zabbix_proxy/vars/*', 'roles/zabbix_proxy/vars/.*',
            'roles/zabbix_server/*', 'roles/zabbix_server/.*',
            'roles/zabbix_server/defaults/*', 'roles/zabbix_server/defaults/.*',
            'roles/zabbix_server/files/*', 'roles/zabbix_server/files/.*',
            'roles/zabbix_server/handlers/*', 'roles/zabbix_server/handlers/.*',
            'roles/zabbix_server/meta/*', 'roles/zabbix_server/meta/.*',
            'roles/zabbix_server/tasks/*', 'roles/zabbix_server/tasks/.*',
            'roles/zabbix_server/templates/*', 'roles/zabbix_server/templates/.*',
            'roles/zabbix_server/vars/*', 'roles/zabbix_server/vars/.*',
            'roles/zabbix_web/*', 'roles/zabbix_web/.*',
            'roles/zabbix_web/defaults/*', 'roles/zabbix_web/defaults/.*',
            'roles/zabbix_web/handlers/*', 'roles/zabbix_web/handlers/.*',
            'roles/zabbix_web/meta/*', 'roles/zabbix_web/meta/.*',
            'roles/zabbix_web/tasks/*', 'roles/zabbix_web/tasks/.*',
            'roles/zabbix_web/templates/*', 'roles/zabbix_web/templates/.*',
            'roles/zabbix_web/vars/*', 'roles/zabbix_web/vars/.*',
            'scripts/*', 'scripts/.*',
            'scripts/inventory/*', 'scripts/inventory/.*',
        ],
        'ansible_collections.containers.podman': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/become/*', 'plugins/become/.*',
            'plugins/connection/*', 'plugins/connection/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/module_utils/podman/*', 'plugins/module_utils/podman/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.cyberark.conjur': [
            '*',
            'examples/*', 'examples/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/lookup/*', 'plugins/lookup/.*',
            'roles/*', 'roles/.*',
            'roles/conjur_host_identity/*', 'roles/conjur_host_identity/.*',
            'roles/conjur_host_identity/defaults/*', 'roles/conjur_host_identity/defaults/.*',
            'roles/conjur_host_identity/meta/*', 'roles/conjur_host_identity/meta/.*',
            'roles/conjur_host_identity/tasks/*', 'roles/conjur_host_identity/tasks/.*',
            'roles/conjur_host_identity/templates/*', 'roles/conjur_host_identity/templates/.*',
            'roles/conjur_host_identity/tests/*', 'roles/conjur_host_identity/tests/.*',
            'roles/conjur_host_identity/tests/.pytest_cache/*', 'roles/conjur_host_identity/tests/.pytest_cache/.*',
            'roles/conjur_host_identity/tests/.pytest_cache/v/*', 'roles/conjur_host_identity/tests/.pytest_cache/v/.*',
            'roles/conjur_host_identity/tests/.pytest_cache/v/cache/*', 'roles/conjur_host_identity/tests/.pytest_cache/v/cache/.*',
            'roles/conjur_host_identity/tests/junit/*', 'roles/conjur_host_identity/tests/junit/.*',
            'roles/conjur_host_identity/tests/test_cases/*', 'roles/conjur_host_identity/tests/test_cases/.*',
            'roles/conjur_host_identity/tests/test_cases/bad-ssl-config/*', 'roles/conjur_host_identity/tests/test_cases/bad-ssl-config/.*',
            'roles/conjur_host_identity/tests/test_cases/cleanup-conjur-identity/*', 'roles/conjur_host_identity/tests/test_cases/cleanup-conjur-identity/.*',
            'roles/conjur_host_identity/tests/test_cases/cleanup-conjur-identity/tests/*', 'roles/conjur_host_identity/tests/test_cases/cleanup-conjur-identity/tests/.*',
            'roles/conjur_host_identity/tests/test_cases/configure-conjur-identity/*', 'roles/conjur_host_identity/tests/test_cases/configure-conjur-identity/.*',
            'roles/conjur_host_identity/tests/test_cases/configure-conjur-identity/tests/*', 'roles/conjur_host_identity/tests/test_cases/configure-conjur-identity/tests/.*',
            'roles/conjur_host_identity/tests/test_cases/misconfig-conjur-identity/*', 'roles/conjur_host_identity/tests/test_cases/misconfig-conjur-identity/.*',
            'roles/conjur_host_identity/tests/test_cases/not-conjurized/*', 'roles/conjur_host_identity/tests/test_cases/not-conjurized/.*',
        ],
        'ansible_collections.cyberark.pas': [
            '*',
            'custom-cred-types/*', 'custom-cred-types/.*',
            'custom-cred-types/cyberark-pas-restapi/*', 'custom-cred-types/cyberark-pas-restapi/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/event_source/*', 'plugins/event_source/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'roles/*', 'roles/.*',
            'roles/aimprovider/*', 'roles/aimprovider/.*',
            'roles/aimprovider/defaults/*', 'roles/aimprovider/defaults/.*',
            'roles/aimprovider/tasks/*', 'roles/aimprovider/tasks/.*',
            'rulebooks/*', 'rulebooks/.*',
        ],
        'ansible_collections.dellemc.enterprise_sonic': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/archive_fragments/*', 'changelogs/archive_fragments/.*',
            'changelogs/archive_fragments/2.0.0/*', 'changelogs/archive_fragments/2.0.0/.*',
            'changelogs/archive_fragments/2.1.0/*', 'changelogs/archive_fragments/2.1.0/.*',
            'changelogs/archive_fragments/2.2.0/*', 'changelogs/archive_fragments/2.2.0/.*',
            'meta/*', 'meta/.*',
            'playbooks/*', 'playbooks/.*',
            'playbooks/bgp_l3_fabric/*', 'playbooks/bgp_l3_fabric/.*',
            'playbooks/bgp_l3_fabric/group_vars/*', 'playbooks/bgp_l3_fabric/group_vars/.*',
            'playbooks/bgp_l3_fabric/templates/*', 'playbooks/bgp_l3_fabric/templates/.*',
            'playbooks/common_examples/*', 'playbooks/common_examples/.*',
            'plugins/*', 'plugins/.*',
            'plugins/action/*', 'plugins/action/.*',
            'plugins/cliconf/*', 'plugins/cliconf/.*',
            'plugins/httpapi/*', 'plugins/httpapi/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/module_utils/network/*', 'plugins/module_utils/network/.*',
            'plugins/module_utils/network/sonic/*', 'plugins/module_utils/network/sonic/.*',
            'plugins/module_utils/network/sonic/argspec/*', 'plugins/module_utils/network/sonic/argspec/.*',
            'plugins/module_utils/network/sonic/argspec/aaa/*', 'plugins/module_utils/network/sonic/argspec/aaa/.*',
            'plugins/module_utils/network/sonic/argspec/acl_interfaces/*', 'plugins/module_utils/network/sonic/argspec/acl_interfaces/.*',
            'plugins/module_utils/network/sonic/argspec/bfd/*', 'plugins/module_utils/network/sonic/argspec/bfd/.*',
            'plugins/module_utils/network/sonic/argspec/bgp/*', 'plugins/module_utils/network/sonic/argspec/bgp/.*',
            'plugins/module_utils/network/sonic/argspec/bgp_af/*', 'plugins/module_utils/network/sonic/argspec/bgp_af/.*',
            'plugins/module_utils/network/sonic/argspec/bgp_as_paths/*', 'plugins/module_utils/network/sonic/argspec/bgp_as_paths/.*',
            'plugins/module_utils/network/sonic/argspec/bgp_communities/*', 'plugins/module_utils/network/sonic/argspec/bgp_communities/.*',
            'plugins/module_utils/network/sonic/argspec/bgp_ext_communities/*', 'plugins/module_utils/network/sonic/argspec/bgp_ext_communities/.*',
            'plugins/module_utils/network/sonic/argspec/bgp_neighbors/*', 'plugins/module_utils/network/sonic/argspec/bgp_neighbors/.*',
            'plugins/module_utils/network/sonic/argspec/bgp_neighbors_af/*', 'plugins/module_utils/network/sonic/argspec/bgp_neighbors_af/.*',
            'plugins/module_utils/network/sonic/argspec/copp/*', 'plugins/module_utils/network/sonic/argspec/copp/.*',
            'plugins/module_utils/network/sonic/argspec/dhcp_relay/*', 'plugins/module_utils/network/sonic/argspec/dhcp_relay/.*',
            'plugins/module_utils/network/sonic/argspec/facts/*', 'plugins/module_utils/network/sonic/argspec/facts/.*',
            'plugins/module_utils/network/sonic/argspec/interfaces/*', 'plugins/module_utils/network/sonic/argspec/interfaces/.*',
            'plugins/module_utils/network/sonic/argspec/ip_neighbor/*', 'plugins/module_utils/network/sonic/argspec/ip_neighbor/.*',
            'plugins/module_utils/network/sonic/argspec/l2_acls/*', 'plugins/module_utils/network/sonic/argspec/l2_acls/.*',
            'plugins/module_utils/network/sonic/argspec/l2_interfaces/*', 'plugins/module_utils/network/sonic/argspec/l2_interfaces/.*',
            'plugins/module_utils/network/sonic/argspec/l3_acls/*', 'plugins/module_utils/network/sonic/argspec/l3_acls/.*',
            'plugins/module_utils/network/sonic/argspec/l3_interfaces/*', 'plugins/module_utils/network/sonic/argspec/l3_interfaces/.*',
            'plugins/module_utils/network/sonic/argspec/lag_interfaces/*', 'plugins/module_utils/network/sonic/argspec/lag_interfaces/.*',
            'plugins/module_utils/network/sonic/argspec/lldp_global/*', 'plugins/module_utils/network/sonic/argspec/lldp_global/.*',
            'plugins/module_utils/network/sonic/argspec/logging/*', 'plugins/module_utils/network/sonic/argspec/logging/.*',
            'plugins/module_utils/network/sonic/argspec/mac/*', 'plugins/module_utils/network/sonic/argspec/mac/.*',
            'plugins/module_utils/network/sonic/argspec/mclag/*', 'plugins/module_utils/network/sonic/argspec/mclag/.*',
            'plugins/module_utils/network/sonic/argspec/ntp/*', 'plugins/module_utils/network/sonic/argspec/ntp/.*',
            'plugins/module_utils/network/sonic/argspec/port_breakout/*', 'plugins/module_utils/network/sonic/argspec/port_breakout/.*',
            'plugins/module_utils/network/sonic/argspec/port_group/*', 'plugins/module_utils/network/sonic/argspec/port_group/.*',
            'plugins/module_utils/network/sonic/argspec/prefix_lists/*', 'plugins/module_utils/network/sonic/argspec/prefix_lists/.*',
            'plugins/module_utils/network/sonic/argspec/radius_server/*', 'plugins/module_utils/network/sonic/argspec/radius_server/.*',
            'plugins/module_utils/network/sonic/argspec/route_maps/*', 'plugins/module_utils/network/sonic/argspec/route_maps/.*',
            'plugins/module_utils/network/sonic/argspec/static_routes/*', 'plugins/module_utils/network/sonic/argspec/static_routes/.*',
            'plugins/module_utils/network/sonic/argspec/system/*', 'plugins/module_utils/network/sonic/argspec/system/.*',
            'plugins/module_utils/network/sonic/argspec/tacacs_server/*', 'plugins/module_utils/network/sonic/argspec/tacacs_server/.*',
            'plugins/module_utils/network/sonic/argspec/users/*', 'plugins/module_utils/network/sonic/argspec/users/.*',
            'plugins/module_utils/network/sonic/argspec/vlan_mapping/*', 'plugins/module_utils/network/sonic/argspec/vlan_mapping/.*',
            'plugins/module_utils/network/sonic/argspec/vlans/*', 'plugins/module_utils/network/sonic/argspec/vlans/.*',
            'plugins/module_utils/network/sonic/argspec/vrfs/*', 'plugins/module_utils/network/sonic/argspec/vrfs/.*',
            'plugins/module_utils/network/sonic/argspec/vxlans/*', 'plugins/module_utils/network/sonic/argspec/vxlans/.*',
            'plugins/module_utils/network/sonic/config/*', 'plugins/module_utils/network/sonic/config/.*',
            'plugins/module_utils/network/sonic/config/aaa/*', 'plugins/module_utils/network/sonic/config/aaa/.*',
            'plugins/module_utils/network/sonic/config/acl_interfaces/*', 'plugins/module_utils/network/sonic/config/acl_interfaces/.*',
            'plugins/module_utils/network/sonic/config/bfd/*', 'plugins/module_utils/network/sonic/config/bfd/.*',
            'plugins/module_utils/network/sonic/config/bgp/*', 'plugins/module_utils/network/sonic/config/bgp/.*',
            'plugins/module_utils/network/sonic/config/bgp_af/*', 'plugins/module_utils/network/sonic/config/bgp_af/.*',
            'plugins/module_utils/network/sonic/config/bgp_as_paths/*', 'plugins/module_utils/network/sonic/config/bgp_as_paths/.*',
            'plugins/module_utils/network/sonic/config/bgp_communities/*', 'plugins/module_utils/network/sonic/config/bgp_communities/.*',
            'plugins/module_utils/network/sonic/config/bgp_ext_communities/*', 'plugins/module_utils/network/sonic/config/bgp_ext_communities/.*',
            'plugins/module_utils/network/sonic/config/bgp_neighbors/*', 'plugins/module_utils/network/sonic/config/bgp_neighbors/.*',
            'plugins/module_utils/network/sonic/config/bgp_neighbors_af/*', 'plugins/module_utils/network/sonic/config/bgp_neighbors_af/.*',
            'plugins/module_utils/network/sonic/config/copp/*', 'plugins/module_utils/network/sonic/config/copp/.*',
            'plugins/module_utils/network/sonic/config/dhcp_relay/*', 'plugins/module_utils/network/sonic/config/dhcp_relay/.*',
            'plugins/module_utils/network/sonic/config/interfaces/*', 'plugins/module_utils/network/sonic/config/interfaces/.*',
            'plugins/module_utils/network/sonic/config/ip_neighbor/*', 'plugins/module_utils/network/sonic/config/ip_neighbor/.*',
            'plugins/module_utils/network/sonic/config/l2_acls/*', 'plugins/module_utils/network/sonic/config/l2_acls/.*',
            'plugins/module_utils/network/sonic/config/l2_interfaces/*', 'plugins/module_utils/network/sonic/config/l2_interfaces/.*',
            'plugins/module_utils/network/sonic/config/l3_acls/*', 'plugins/module_utils/network/sonic/config/l3_acls/.*',
            'plugins/module_utils/network/sonic/config/l3_interfaces/*', 'plugins/module_utils/network/sonic/config/l3_interfaces/.*',
            'plugins/module_utils/network/sonic/config/lag_interfaces/*', 'plugins/module_utils/network/sonic/config/lag_interfaces/.*',
            'plugins/module_utils/network/sonic/config/lldp_global/*', 'plugins/module_utils/network/sonic/config/lldp_global/.*',
            'plugins/module_utils/network/sonic/config/logging/*', 'plugins/module_utils/network/sonic/config/logging/.*',
            'plugins/module_utils/network/sonic/config/mac/*', 'plugins/module_utils/network/sonic/config/mac/.*',
            'plugins/module_utils/network/sonic/config/mclag/*', 'plugins/module_utils/network/sonic/config/mclag/.*',
            'plugins/module_utils/network/sonic/config/ntp/*', 'plugins/module_utils/network/sonic/config/ntp/.*',
            'plugins/module_utils/network/sonic/config/port_breakout/*', 'plugins/module_utils/network/sonic/config/port_breakout/.*',
            'plugins/module_utils/network/sonic/config/port_group/*', 'plugins/module_utils/network/sonic/config/port_group/.*',
            'plugins/module_utils/network/sonic/config/prefix_lists/*', 'plugins/module_utils/network/sonic/config/prefix_lists/.*',
            'plugins/module_utils/network/sonic/config/radius_server/*', 'plugins/module_utils/network/sonic/config/radius_server/.*',
            'plugins/module_utils/network/sonic/config/route_maps/*', 'plugins/module_utils/network/sonic/config/route_maps/.*',
            'plugins/module_utils/network/sonic/config/static_routes/*', 'plugins/module_utils/network/sonic/config/static_routes/.*',
            'plugins/module_utils/network/sonic/config/system/*', 'plugins/module_utils/network/sonic/config/system/.*',
            'plugins/module_utils/network/sonic/config/tacacs_server/*', 'plugins/module_utils/network/sonic/config/tacacs_server/.*',
            'plugins/module_utils/network/sonic/config/users/*', 'plugins/module_utils/network/sonic/config/users/.*',
            'plugins/module_utils/network/sonic/config/vlan_mapping/*', 'plugins/module_utils/network/sonic/config/vlan_mapping/.*',
            'plugins/module_utils/network/sonic/config/vlans/*', 'plugins/module_utils/network/sonic/config/vlans/.*',
            'plugins/module_utils/network/sonic/config/vrfs/*', 'plugins/module_utils/network/sonic/config/vrfs/.*',
            'plugins/module_utils/network/sonic/config/vxlans/*', 'plugins/module_utils/network/sonic/config/vxlans/.*',
            'plugins/module_utils/network/sonic/facts/*', 'plugins/module_utils/network/sonic/facts/.*',
            'plugins/module_utils/network/sonic/facts/aaa/*', 'plugins/module_utils/network/sonic/facts/aaa/.*',
            'plugins/module_utils/network/sonic/facts/acl_interfaces/*', 'plugins/module_utils/network/sonic/facts/acl_interfaces/.*',
            'plugins/module_utils/network/sonic/facts/bfd/*', 'plugins/module_utils/network/sonic/facts/bfd/.*',
            'plugins/module_utils/network/sonic/facts/bgp/*', 'plugins/module_utils/network/sonic/facts/bgp/.*',
            'plugins/module_utils/network/sonic/facts/bgp_af/*', 'plugins/module_utils/network/sonic/facts/bgp_af/.*',
            'plugins/module_utils/network/sonic/facts/bgp_as_paths/*', 'plugins/module_utils/network/sonic/facts/bgp_as_paths/.*',
            'plugins/module_utils/network/sonic/facts/bgp_communities/*', 'plugins/module_utils/network/sonic/facts/bgp_communities/.*',
            'plugins/module_utils/network/sonic/facts/bgp_ext_communities/*', 'plugins/module_utils/network/sonic/facts/bgp_ext_communities/.*',
            'plugins/module_utils/network/sonic/facts/bgp_neighbors/*', 'plugins/module_utils/network/sonic/facts/bgp_neighbors/.*',
            'plugins/module_utils/network/sonic/facts/bgp_neighbors_af/*', 'plugins/module_utils/network/sonic/facts/bgp_neighbors_af/.*',
            'plugins/module_utils/network/sonic/facts/copp/*', 'plugins/module_utils/network/sonic/facts/copp/.*',
            'plugins/module_utils/network/sonic/facts/dhcp_relay/*', 'plugins/module_utils/network/sonic/facts/dhcp_relay/.*',
            'plugins/module_utils/network/sonic/facts/interfaces/*', 'plugins/module_utils/network/sonic/facts/interfaces/.*',
            'plugins/module_utils/network/sonic/facts/ip_neighbor/*', 'plugins/module_utils/network/sonic/facts/ip_neighbor/.*',
            'plugins/module_utils/network/sonic/facts/l2_acls/*', 'plugins/module_utils/network/sonic/facts/l2_acls/.*',
            'plugins/module_utils/network/sonic/facts/l2_interfaces/*', 'plugins/module_utils/network/sonic/facts/l2_interfaces/.*',
            'plugins/module_utils/network/sonic/facts/l3_acls/*', 'plugins/module_utils/network/sonic/facts/l3_acls/.*',
            'plugins/module_utils/network/sonic/facts/l3_interfaces/*', 'plugins/module_utils/network/sonic/facts/l3_interfaces/.*',
            'plugins/module_utils/network/sonic/facts/lag_interfaces/*', 'plugins/module_utils/network/sonic/facts/lag_interfaces/.*',
            'plugins/module_utils/network/sonic/facts/lldp_global/*', 'plugins/module_utils/network/sonic/facts/lldp_global/.*',
            'plugins/module_utils/network/sonic/facts/logging/*', 'plugins/module_utils/network/sonic/facts/logging/.*',
            'plugins/module_utils/network/sonic/facts/mac/*', 'plugins/module_utils/network/sonic/facts/mac/.*',
            'plugins/module_utils/network/sonic/facts/mclag/*', 'plugins/module_utils/network/sonic/facts/mclag/.*',
            'plugins/module_utils/network/sonic/facts/ntp/*', 'plugins/module_utils/network/sonic/facts/ntp/.*',
            'plugins/module_utils/network/sonic/facts/port_breakout/*', 'plugins/module_utils/network/sonic/facts/port_breakout/.*',
            'plugins/module_utils/network/sonic/facts/port_group/*', 'plugins/module_utils/network/sonic/facts/port_group/.*',
            'plugins/module_utils/network/sonic/facts/prefix_lists/*', 'plugins/module_utils/network/sonic/facts/prefix_lists/.*',
            'plugins/module_utils/network/sonic/facts/radius_server/*', 'plugins/module_utils/network/sonic/facts/radius_server/.*',
            'plugins/module_utils/network/sonic/facts/route_maps/*', 'plugins/module_utils/network/sonic/facts/route_maps/.*',
            'plugins/module_utils/network/sonic/facts/static_routes/*', 'plugins/module_utils/network/sonic/facts/static_routes/.*',
            'plugins/module_utils/network/sonic/facts/system/*', 'plugins/module_utils/network/sonic/facts/system/.*',
            'plugins/module_utils/network/sonic/facts/tacacs_server/*', 'plugins/module_utils/network/sonic/facts/tacacs_server/.*',
            'plugins/module_utils/network/sonic/facts/users/*', 'plugins/module_utils/network/sonic/facts/users/.*',
            'plugins/module_utils/network/sonic/facts/vlan_mapping/*', 'plugins/module_utils/network/sonic/facts/vlan_mapping/.*',
            'plugins/module_utils/network/sonic/facts/vlans/*', 'plugins/module_utils/network/sonic/facts/vlans/.*',
            'plugins/module_utils/network/sonic/facts/vrfs/*', 'plugins/module_utils/network/sonic/facts/vrfs/.*',
            'plugins/module_utils/network/sonic/facts/vxlans/*', 'plugins/module_utils/network/sonic/facts/vxlans/.*',
            'plugins/module_utils/network/sonic/utils/*', 'plugins/module_utils/network/sonic/utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'plugins/terminal/*', 'plugins/terminal/.*',
        ],
        'ansible_collections.dellemc.openmanage': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'meta/*', 'meta/.*',
            'playbooks/*', 'playbooks/.*',
            'playbooks/idrac/*', 'playbooks/idrac/.*',
            'playbooks/idrac/deprecated/*', 'playbooks/idrac/deprecated/.*',
            'playbooks/ome/*', 'playbooks/ome/.*',
            'playbooks/ome/application/*', 'playbooks/ome/application/.*',
            'playbooks/ome/compliance/*', 'playbooks/ome/compliance/.*',
            'playbooks/ome/firmware/*', 'playbooks/ome/firmware/.*',
            'playbooks/ome/firmware/baseline/*', 'playbooks/ome/firmware/baseline/.*',
            'playbooks/ome/firmware/baseline/component_reports_filtering/*', 'playbooks/ome/firmware/baseline/component_reports_filtering/.*',
            'playbooks/ome/firmware/catalog/*', 'playbooks/ome/firmware/catalog/.*',
            'playbooks/ome/inventory/*', 'playbooks/ome/inventory/.*',
            'playbooks/ome/powerstate/*', 'playbooks/ome/powerstate/.*',
            'playbooks/ome/profile/*', 'playbooks/ome/profile/.*',
            'playbooks/ome/template/*', 'playbooks/ome/template/.*',
            'playbooks/ome/user/*', 'playbooks/ome/user/.*',
            'playbooks/redfish/*', 'playbooks/redfish/.*',
            'playbooks/redfish/firmware/*', 'playbooks/redfish/firmware/.*',
            'playbooks/redfish/storage/*', 'playbooks/redfish/storage/.*',
            'playbooks/roles/*', 'playbooks/roles/.*',
            'playbooks/roles/idrac_attributes/*', 'playbooks/roles/idrac_attributes/.*',
            'playbooks/roles/idrac_bios/*', 'playbooks/roles/idrac_bios/.*',
            'playbooks/roles/idrac_certificate/*', 'playbooks/roles/idrac_certificate/.*',
            'playbooks/roles/idrac_export_server_config_profile/*', 'playbooks/roles/idrac_export_server_config_profile/.*',
            'playbooks/roles/idrac_firmware/*', 'playbooks/roles/idrac_firmware/.*',
            'playbooks/roles/idrac_gather_facts/*', 'playbooks/roles/idrac_gather_facts/.*',
            'playbooks/roles/idrac_import_server_config_profile/*', 'playbooks/roles/idrac_import_server_config_profile/.*',
            'playbooks/roles/idrac_os_deployment/*', 'playbooks/roles/idrac_os_deployment/.*',
            'playbooks/roles/idrac_reset/*', 'playbooks/roles/idrac_reset/.*',
            'playbooks/roles/idrac_server_powerstate/*', 'playbooks/roles/idrac_server_powerstate/.*',
            'playbooks/roles/idrac_storage_controller/*', 'playbooks/roles/idrac_storage_controller/.*',
            'playbooks/roles/redfish_firmware/*', 'playbooks/roles/redfish_firmware/.*',
            'playbooks/roles/redfish_storage_volume/*', 'playbooks/roles/redfish_storage_volume/.*',
            'playbooks/roles/vars_files/*', 'playbooks/roles/vars_files/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/inventory/*', 'plugins/inventory/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'roles/*', 'roles/.*',
            'roles/idrac_attributes/*', 'roles/idrac_attributes/.*',
            'roles/idrac_attributes/defaults/*', 'roles/idrac_attributes/defaults/.*',
            'roles/idrac_attributes/handlers/*', 'roles/idrac_attributes/handlers/.*',
            'roles/idrac_attributes/meta/*', 'roles/idrac_attributes/meta/.*',
            'roles/idrac_attributes/molecule/*', 'roles/idrac_attributes/molecule/.*',
            'roles/idrac_attributes/molecule/default/*', 'roles/idrac_attributes/molecule/default/.*',
            'roles/idrac_attributes/molecule/idrac_attr/*', 'roles/idrac_attributes/molecule/idrac_attr/.*',
            'roles/idrac_attributes/molecule/lifecycle_controller_attr/*', 'roles/idrac_attributes/molecule/lifecycle_controller_attr/.*',
            'roles/idrac_attributes/molecule/system_attr/*', 'roles/idrac_attributes/molecule/system_attr/.*',
            'roles/idrac_attributes/tasks/*', 'roles/idrac_attributes/tasks/.*',
            'roles/idrac_attributes/tests/*', 'roles/idrac_attributes/tests/.*',
            'roles/idrac_attributes/vars/*', 'roles/idrac_attributes/vars/.*',
            'roles/idrac_bios/*', 'roles/idrac_bios/.*',
            'roles/idrac_bios/defaults/*', 'roles/idrac_bios/defaults/.*',
            'roles/idrac_bios/handlers/*', 'roles/idrac_bios/handlers/.*',
            'roles/idrac_bios/meta/*', 'roles/idrac_bios/meta/.*',
            'roles/idrac_bios/molecule/*', 'roles/idrac_bios/molecule/.*',
            'roles/idrac_bios/molecule/clear_pending_attributes/*', 'roles/idrac_bios/molecule/clear_pending_attributes/.*',
            'roles/idrac_bios/molecule/default/*', 'roles/idrac_bios/molecule/default/.*',
            'roles/idrac_bios/molecule/negative_scenarios_with_maintenance_window/*', 'roles/idrac_bios/molecule/negative_scenarios_with_maintenance_window/.*',
            'roles/idrac_bios/molecule/reset_bios/*', 'roles/idrac_bios/molecule/reset_bios/.*',
            'roles/idrac_bios/molecule/reset_bios_with_reset_type_as_force_restart/*', 'roles/idrac_bios/molecule/reset_bios_with_reset_type_as_force_restart/.*',
            'roles/idrac_bios/molecule/update_attributes_immediate/*', 'roles/idrac_bios/molecule/update_attributes_immediate/.*',
            'roles/idrac_bios/molecule/update_attributes_immediate_with_jobwait/*', 'roles/idrac_bios/molecule/update_attributes_immediate_with_jobwait/.*',
            'roles/idrac_bios/molecule/update_attributes_on_reset/*', 'roles/idrac_bios/molecule/update_attributes_on_reset/.*',
            'roles/idrac_bios/molecule/update_attributes_on_reset_with_maintenance_window/*', 'roles/idrac_bios/molecule/update_attributes_on_reset_with_maintenance_window/.*',
            'roles/idrac_bios/molecule/update_attributes_with_maintenance_window/*', 'roles/idrac_bios/molecule/update_attributes_with_maintenance_window/.*',
            'roles/idrac_bios/tasks/*', 'roles/idrac_bios/tasks/.*',
            'roles/idrac_bios/tests/*', 'roles/idrac_bios/tests/.*',
            'roles/idrac_bios/vars/*', 'roles/idrac_bios/vars/.*',
            'roles/idrac_certificate/*', 'roles/idrac_certificate/.*',
            'roles/idrac_certificate/defaults/*', 'roles/idrac_certificate/defaults/.*',
            'roles/idrac_certificate/handlers/*', 'roles/idrac_certificate/handlers/.*',
            'roles/idrac_certificate/meta/*', 'roles/idrac_certificate/meta/.*',
            'roles/idrac_certificate/molecule/*', 'roles/idrac_certificate/molecule/.*',
            'roles/idrac_certificate/molecule/CA/*', 'roles/idrac_certificate/molecule/CA/.*',
            'roles/idrac_certificate/molecule/CSC/*', 'roles/idrac_certificate/molecule/CSC/.*',
            'roles/idrac_certificate/molecule/CTC/*', 'roles/idrac_certificate/molecule/CTC/.*',
            'roles/idrac_certificate/molecule/HTTPS/*', 'roles/idrac_certificate/molecule/HTTPS/.*',
            'roles/idrac_certificate/molecule/default/*', 'roles/idrac_certificate/molecule/default/.*',
            'roles/idrac_certificate/molecule/generateCSR/*', 'roles/idrac_certificate/molecule/generateCSR/.*',
            'roles/idrac_certificate/molecule/reset/*', 'roles/idrac_certificate/molecule/reset/.*',
            'roles/idrac_certificate/tasks/*', 'roles/idrac_certificate/tasks/.*',
            'roles/idrac_certificate/tests/*', 'roles/idrac_certificate/tests/.*',
            'roles/idrac_certificate/vars/*', 'roles/idrac_certificate/vars/.*',
            'roles/idrac_export_server_config_profile/*', 'roles/idrac_export_server_config_profile/.*',
            'roles/idrac_export_server_config_profile/defaults/*', 'roles/idrac_export_server_config_profile/defaults/.*',
            'roles/idrac_export_server_config_profile/handlers/*', 'roles/idrac_export_server_config_profile/handlers/.*',
            'roles/idrac_export_server_config_profile/meta/*', 'roles/idrac_export_server_config_profile/meta/.*',
            'roles/idrac_export_server_config_profile/molecule/*', 'roles/idrac_export_server_config_profile/molecule/.*',
            'roles/idrac_export_server_config_profile/molecule/default/*', 'roles/idrac_export_server_config_profile/molecule/default/.*',
            'roles/idrac_export_server_config_profile/tasks/*', 'roles/idrac_export_server_config_profile/tasks/.*',
            'roles/idrac_export_server_config_profile/tests/*', 'roles/idrac_export_server_config_profile/tests/.*',
            'roles/idrac_export_server_config_profile/vars/*', 'roles/idrac_export_server_config_profile/vars/.*',
            'roles/idrac_firmware/*', 'roles/idrac_firmware/.*',
            'roles/idrac_firmware/defaults/*', 'roles/idrac_firmware/defaults/.*',
            'roles/idrac_firmware/handlers/*', 'roles/idrac_firmware/handlers/.*',
            'roles/idrac_firmware/meta/*', 'roles/idrac_firmware/meta/.*',
            'roles/idrac_firmware/molecule/*', 'roles/idrac_firmware/molecule/.*',
            'roles/idrac_firmware/molecule/cifs_share/*', 'roles/idrac_firmware/molecule/cifs_share/.*',
            'roles/idrac_firmware/molecule/default/*', 'roles/idrac_firmware/molecule/default/.*',
            'roles/idrac_firmware/molecule/ftp_share/*', 'roles/idrac_firmware/molecule/ftp_share/.*',
            'roles/idrac_firmware/molecule/http_share/*', 'roles/idrac_firmware/molecule/http_share/.*',
            'roles/idrac_firmware/molecule/https_share/*', 'roles/idrac_firmware/molecule/https_share/.*',
            'roles/idrac_firmware/molecule/httpsproxy_share/*', 'roles/idrac_firmware/molecule/httpsproxy_share/.*',
            'roles/idrac_firmware/molecule/negative_scenarios/*', 'roles/idrac_firmware/molecule/negative_scenarios/.*',
            'roles/idrac_firmware/molecule/nfs_share/*', 'roles/idrac_firmware/molecule/nfs_share/.*',
            'roles/idrac_firmware/tasks/*', 'roles/idrac_firmware/tasks/.*',
            'roles/idrac_firmware/tests/*', 'roles/idrac_firmware/tests/.*',
            'roles/idrac_firmware/vars/*', 'roles/idrac_firmware/vars/.*',
            'roles/idrac_gather_facts/*', 'roles/idrac_gather_facts/.*',
            'roles/idrac_gather_facts/defaults/*', 'roles/idrac_gather_facts/defaults/.*',
            'roles/idrac_gather_facts/handlers/*', 'roles/idrac_gather_facts/handlers/.*',
            'roles/idrac_gather_facts/meta/*', 'roles/idrac_gather_facts/meta/.*',
            'roles/idrac_gather_facts/molecule/*', 'roles/idrac_gather_facts/molecule/.*',
            'roles/idrac_gather_facts/molecule/backplane/*', 'roles/idrac_gather_facts/molecule/backplane/.*',
            'roles/idrac_gather_facts/molecule/bios/*', 'roles/idrac_gather_facts/molecule/bios/.*',
            'roles/idrac_gather_facts/molecule/controller/*', 'roles/idrac_gather_facts/molecule/controller/.*',
            'roles/idrac_gather_facts/molecule/cpu/*', 'roles/idrac_gather_facts/molecule/cpu/.*',
            'roles/idrac_gather_facts/molecule/default/*', 'roles/idrac_gather_facts/molecule/default/.*',
            'roles/idrac_gather_facts/molecule/enclosure/*', 'roles/idrac_gather_facts/molecule/enclosure/.*',
            'roles/idrac_gather_facts/molecule/enclosureemm/*', 'roles/idrac_gather_facts/molecule/enclosureemm/.*',
            'roles/idrac_gather_facts/molecule/fan/*', 'roles/idrac_gather_facts/molecule/fan/.*',
            'roles/idrac_gather_facts/molecule/firmware/*', 'roles/idrac_gather_facts/molecule/firmware/.*',
            'roles/idrac_gather_facts/molecule/hostnic/*', 'roles/idrac_gather_facts/molecule/hostnic/.*',
            'roles/idrac_gather_facts/molecule/idrac/*', 'roles/idrac_gather_facts/molecule/idrac/.*',
            'roles/idrac_gather_facts/molecule/license/*', 'roles/idrac_gather_facts/molecule/license/.*',
            'roles/idrac_gather_facts/molecule/memory/*', 'roles/idrac_gather_facts/molecule/memory/.*',
            'roles/idrac_gather_facts/molecule/negative/*', 'roles/idrac_gather_facts/molecule/negative/.*',
            'roles/idrac_gather_facts/molecule/nic/*', 'roles/idrac_gather_facts/molecule/nic/.*',
            'roles/idrac_gather_facts/molecule/passensor/*', 'roles/idrac_gather_facts/molecule/passensor/.*',
            'roles/idrac_gather_facts/molecule/pciedevice/*', 'roles/idrac_gather_facts/molecule/pciedevice/.*',
            'roles/idrac_gather_facts/molecule/physicaldisk/*', 'roles/idrac_gather_facts/molecule/physicaldisk/.*',
            'roles/idrac_gather_facts/molecule/powersupply/*', 'roles/idrac_gather_facts/molecule/powersupply/.*',
            'roles/idrac_gather_facts/molecule/sensorsbattery/*', 'roles/idrac_gather_facts/molecule/sensorsbattery/.*',
            'roles/idrac_gather_facts/molecule/sensorsintrusion/*', 'roles/idrac_gather_facts/molecule/sensorsintrusion/.*',
            'roles/idrac_gather_facts/molecule/sensorsvoltage/*', 'roles/idrac_gather_facts/molecule/sensorsvoltage/.*',
            'roles/idrac_gather_facts/molecule/systemmetrics/*', 'roles/idrac_gather_facts/molecule/systemmetrics/.*',
            'roles/idrac_gather_facts/molecule/virtualdisk/*', 'roles/idrac_gather_facts/molecule/virtualdisk/.*',
            'roles/idrac_gather_facts/tasks/*', 'roles/idrac_gather_facts/tasks/.*',
            'roles/idrac_gather_facts/tests/*', 'roles/idrac_gather_facts/tests/.*',
            'roles/idrac_gather_facts/vars/*', 'roles/idrac_gather_facts/vars/.*',
            'roles/idrac_import_server_config_profile/*', 'roles/idrac_import_server_config_profile/.*',
            'roles/idrac_import_server_config_profile/defaults/*', 'roles/idrac_import_server_config_profile/defaults/.*',
            'roles/idrac_import_server_config_profile/handlers/*', 'roles/idrac_import_server_config_profile/handlers/.*',
            'roles/idrac_import_server_config_profile/meta/*', 'roles/idrac_import_server_config_profile/meta/.*',
            'roles/idrac_import_server_config_profile/molecule/*', 'roles/idrac_import_server_config_profile/molecule/.*',
            'roles/idrac_import_server_config_profile/molecule/cifs_share/*', 'roles/idrac_import_server_config_profile/molecule/cifs_share/.*',
            'roles/idrac_import_server_config_profile/molecule/default/*', 'roles/idrac_import_server_config_profile/molecule/default/.*',
            'roles/idrac_import_server_config_profile/molecule/http_share/*', 'roles/idrac_import_server_config_profile/molecule/http_share/.*',
            'roles/idrac_import_server_config_profile/molecule/http_share_with_proxy_parameters/*', 'roles/idrac_import_server_config_profile/molecule/http_share_with_proxy_parameters/.*',
            'roles/idrac_import_server_config_profile/molecule/http_share_with_showerror_certificate_warning/*', 'roles/idrac_import_server_config_profile/molecule/http_share_with_showerror_certificate_warning/.*',
            'roles/idrac_import_server_config_profile/molecule/https_share/*', 'roles/idrac_import_server_config_profile/molecule/https_share/.*',
            'roles/idrac_import_server_config_profile/molecule/https_share_with_proxy_parameters/*', 'roles/idrac_import_server_config_profile/molecule/https_share_with_proxy_parameters/.*',
            'roles/idrac_import_server_config_profile/molecule/import_buffer_json/*', 'roles/idrac_import_server_config_profile/molecule/import_buffer_json/.*',
            'roles/idrac_import_server_config_profile/molecule/import_buffer_xml/*', 'roles/idrac_import_server_config_profile/molecule/import_buffer_xml/.*',
            'roles/idrac_import_server_config_profile/molecule/import_multiple_target/*', 'roles/idrac_import_server_config_profile/molecule/import_multiple_target/.*',
            'roles/idrac_import_server_config_profile/molecule/nfs_share/*', 'roles/idrac_import_server_config_profile/molecule/nfs_share/.*',
            'roles/idrac_import_server_config_profile/molecule/resources/*', 'roles/idrac_import_server_config_profile/molecule/resources/.*',
            'roles/idrac_import_server_config_profile/molecule/resources/tests/*', 'roles/idrac_import_server_config_profile/molecule/resources/tests/.*',
            'roles/idrac_import_server_config_profile/tasks/*', 'roles/idrac_import_server_config_profile/tasks/.*',
            'roles/idrac_import_server_config_profile/tests/*', 'roles/idrac_import_server_config_profile/tests/.*',
            'roles/idrac_import_server_config_profile/vars/*', 'roles/idrac_import_server_config_profile/vars/.*',
            'roles/idrac_os_deployment/*', 'roles/idrac_os_deployment/.*',
            'roles/idrac_os_deployment/defaults/*', 'roles/idrac_os_deployment/defaults/.*',
            'roles/idrac_os_deployment/defaults/main/*', 'roles/idrac_os_deployment/defaults/main/.*',
            'roles/idrac_os_deployment/handlers/*', 'roles/idrac_os_deployment/handlers/.*',
            'roles/idrac_os_deployment/meta/*', 'roles/idrac_os_deployment/meta/.*',
            'roles/idrac_os_deployment/tasks/*', 'roles/idrac_os_deployment/tasks/.*',
            'roles/idrac_os_deployment/templates/*', 'roles/idrac_os_deployment/templates/.*',
            'roles/idrac_os_deployment/tests/*', 'roles/idrac_os_deployment/tests/.*',
            'roles/idrac_os_deployment/vars/*', 'roles/idrac_os_deployment/vars/.*',
            'roles/idrac_reset/*', 'roles/idrac_reset/.*',
            'roles/idrac_reset/defaults/*', 'roles/idrac_reset/defaults/.*',
            'roles/idrac_reset/handlers/*', 'roles/idrac_reset/handlers/.*',
            'roles/idrac_reset/meta/*', 'roles/idrac_reset/meta/.*',
            'roles/idrac_reset/tasks/*', 'roles/idrac_reset/tasks/.*',
            'roles/idrac_reset/templates/*', 'roles/idrac_reset/templates/.*',
            'roles/idrac_reset/tests/*', 'roles/idrac_reset/tests/.*',
            'roles/idrac_reset/vars/*', 'roles/idrac_reset/vars/.*',
            'roles/idrac_server_powerstate/*', 'roles/idrac_server_powerstate/.*',
            'roles/idrac_server_powerstate/defaults/*', 'roles/idrac_server_powerstate/defaults/.*',
            'roles/idrac_server_powerstate/handlers/*', 'roles/idrac_server_powerstate/handlers/.*',
            'roles/idrac_server_powerstate/meta/*', 'roles/idrac_server_powerstate/meta/.*',
            'roles/idrac_server_powerstate/molecule/*', 'roles/idrac_server_powerstate/molecule/.*',
            'roles/idrac_server_powerstate/molecule/default/*', 'roles/idrac_server_powerstate/molecule/default/.*',
            'roles/idrac_server_powerstate/molecule/forceoff/*', 'roles/idrac_server_powerstate/molecule/forceoff/.*',
            'roles/idrac_server_powerstate/molecule/forcerestart/*', 'roles/idrac_server_powerstate/molecule/forcerestart/.*',
            'roles/idrac_server_powerstate/molecule/gracefulrestart/*', 'roles/idrac_server_powerstate/molecule/gracefulrestart/.*',
            'roles/idrac_server_powerstate/molecule/gracefulshutdown/*', 'roles/idrac_server_powerstate/molecule/gracefulshutdown/.*',
            'roles/idrac_server_powerstate/molecule/nmi/*', 'roles/idrac_server_powerstate/molecule/nmi/.*',
            'roles/idrac_server_powerstate/molecule/on/*', 'roles/idrac_server_powerstate/molecule/on/.*',
            'roles/idrac_server_powerstate/molecule/powercycle/*', 'roles/idrac_server_powerstate/molecule/powercycle/.*',
            'roles/idrac_server_powerstate/molecule/pushpowerbutton/*', 'roles/idrac_server_powerstate/molecule/pushpowerbutton/.*',
            'roles/idrac_server_powerstate/tasks/*', 'roles/idrac_server_powerstate/tasks/.*',
            'roles/idrac_server_powerstate/tests/*', 'roles/idrac_server_powerstate/tests/.*',
            'roles/idrac_server_powerstate/vars/*', 'roles/idrac_server_powerstate/vars/.*',
            'roles/idrac_storage_controller/*', 'roles/idrac_storage_controller/.*',
            'roles/idrac_storage_controller/defaults/*', 'roles/idrac_storage_controller/defaults/.*',
            'roles/idrac_storage_controller/handlers/*', 'roles/idrac_storage_controller/handlers/.*',
            'roles/idrac_storage_controller/meta/*', 'roles/idrac_storage_controller/meta/.*',
            'roles/idrac_storage_controller/tasks/*', 'roles/idrac_storage_controller/tasks/.*',
            'roles/idrac_storage_controller/tests/*', 'roles/idrac_storage_controller/tests/.*',
            'roles/idrac_storage_controller/vars/*', 'roles/idrac_storage_controller/vars/.*',
            'roles/redfish_firmware/*', 'roles/redfish_firmware/.*',
            'roles/redfish_firmware/defaults/*', 'roles/redfish_firmware/defaults/.*',
            'roles/redfish_firmware/handlers/*', 'roles/redfish_firmware/handlers/.*',
            'roles/redfish_firmware/meta/*', 'roles/redfish_firmware/meta/.*',
            'roles/redfish_firmware/molecule/*', 'roles/redfish_firmware/molecule/.*',
            'roles/redfish_firmware/molecule/default/*', 'roles/redfish_firmware/molecule/default/.*',
            'roles/redfish_firmware/molecule/negative/*', 'roles/redfish_firmware/molecule/negative/.*',
            'roles/redfish_firmware/tasks/*', 'roles/redfish_firmware/tasks/.*',
            'roles/redfish_firmware/tests/*', 'roles/redfish_firmware/tests/.*',
            'roles/redfish_firmware/vars/*', 'roles/redfish_firmware/vars/.*',
            'roles/redfish_storage_volume/*', 'roles/redfish_storage_volume/.*',
            'roles/redfish_storage_volume/defaults/*', 'roles/redfish_storage_volume/defaults/.*',
            'roles/redfish_storage_volume/handlers/*', 'roles/redfish_storage_volume/handlers/.*',
            'roles/redfish_storage_volume/meta/*', 'roles/redfish_storage_volume/meta/.*',
            'roles/redfish_storage_volume/molecule/*', 'roles/redfish_storage_volume/molecule/.*',
            'roles/redfish_storage_volume/molecule/default/*', 'roles/redfish_storage_volume/molecule/default/.*',
            'roles/redfish_storage_volume/molecule/initialization/*', 'roles/redfish_storage_volume/molecule/initialization/.*',
            'roles/redfish_storage_volume/molecule/mirrored/*', 'roles/redfish_storage_volume/molecule/mirrored/.*',
            'roles/redfish_storage_volume/molecule/nonredundant/*', 'roles/redfish_storage_volume/molecule/nonredundant/.*',
            'roles/redfish_storage_volume/molecule/spannedmirrors/*', 'roles/redfish_storage_volume/molecule/spannedmirrors/.*',
            'roles/redfish_storage_volume/molecule/spannedstripeswithparity/*', 'roles/redfish_storage_volume/molecule/spannedstripeswithparity/.*',
            'roles/redfish_storage_volume/molecule/stripedwithparity/*', 'roles/redfish_storage_volume/molecule/stripedwithparity/.*',
            'roles/redfish_storage_volume/tasks/*', 'roles/redfish_storage_volume/tasks/.*',
            'roles/redfish_storage_volume/tests/*', 'roles/redfish_storage_volume/tests/.*',
            'roles/redfish_storage_volume/vars/*', 'roles/redfish_storage_volume/vars/.*',
        ],
        'ansible_collections.dellemc.powerflex': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'meta/*', 'meta/.*',
            'playbooks/*', 'playbooks/.*',
            'playbooks/modules/*', 'playbooks/modules/.*',
            'playbooks/roles/*', 'playbooks/roles/.*',
            'playbooks/roles/group_vars/*', 'playbooks/roles/group_vars/.*',
            'playbooks/roles/host_vars/*', 'playbooks/roles/host_vars/.*',
            'playbooks/roles/vars_files/*', 'playbooks/roles/vars_files/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/module_utils/storage/*', 'plugins/module_utils/storage/.*',
            'plugins/module_utils/storage/dell/*', 'plugins/module_utils/storage/dell/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'roles/*', 'roles/.*',
            'roles/powerflex_common/*', 'roles/powerflex_common/.*',
            'roles/powerflex_common/defaults/*', 'roles/powerflex_common/defaults/.*',
            'roles/powerflex_common/meta/*', 'roles/powerflex_common/meta/.*',
            'roles/powerflex_common/tasks/*', 'roles/powerflex_common/tasks/.*',
            'roles/powerflex_common/vars/*', 'roles/powerflex_common/vars/.*',
            'roles/powerflex_gateway/*', 'roles/powerflex_gateway/.*',
            'roles/powerflex_gateway/defaults/*', 'roles/powerflex_gateway/defaults/.*',
            'roles/powerflex_gateway/handlers/*', 'roles/powerflex_gateway/handlers/.*',
            'roles/powerflex_gateway/meta/*', 'roles/powerflex_gateway/meta/.*',
            'roles/powerflex_gateway/molecule/*', 'roles/powerflex_gateway/molecule/.*',
            'roles/powerflex_gateway/molecule/gateway_installation/*', 'roles/powerflex_gateway/molecule/gateway_installation/.*',
            'roles/powerflex_gateway/molecule/gateway_installation_invalid_path_rpm/*', 'roles/powerflex_gateway/molecule/gateway_installation_invalid_path_rpm/.*',
            'roles/powerflex_gateway/molecule/gateway_uninstallation/*', 'roles/powerflex_gateway/molecule/gateway_uninstallation/.*',
            'roles/powerflex_gateway/tasks/*', 'roles/powerflex_gateway/tasks/.*',
            'roles/powerflex_gateway/templates/*', 'roles/powerflex_gateway/templates/.*',
            'roles/powerflex_gateway/vars/*', 'roles/powerflex_gateway/vars/.*',
            'roles/powerflex_lia/*', 'roles/powerflex_lia/.*',
            'roles/powerflex_lia/defaults/*', 'roles/powerflex_lia/defaults/.*',
            'roles/powerflex_lia/meta/*', 'roles/powerflex_lia/meta/.*',
            'roles/powerflex_lia/molecule/*', 'roles/powerflex_lia/molecule/.*',
            'roles/powerflex_lia/molecule/lia_install/*', 'roles/powerflex_lia/molecule/lia_install/.*',
            'roles/powerflex_lia/molecule/lia_installation_invalid_path_rpm/*', 'roles/powerflex_lia/molecule/lia_installation_invalid_path_rpm/.*',
            'roles/powerflex_lia/molecule/lia_uninstallation/*', 'roles/powerflex_lia/molecule/lia_uninstallation/.*',
            'roles/powerflex_lia/tasks/*', 'roles/powerflex_lia/tasks/.*',
            'roles/powerflex_lia/vars/*', 'roles/powerflex_lia/vars/.*',
            'roles/powerflex_mdm/*', 'roles/powerflex_mdm/.*',
            'roles/powerflex_mdm/defaults/*', 'roles/powerflex_mdm/defaults/.*',
            'roles/powerflex_mdm/meta/*', 'roles/powerflex_mdm/meta/.*',
            'roles/powerflex_mdm/molecule/*', 'roles/powerflex_mdm/molecule/.*',
            'roles/powerflex_mdm/molecule/mdm_installation/*', 'roles/powerflex_mdm/molecule/mdm_installation/.*',
            'roles/powerflex_mdm/molecule/mdm_uninstallation/*', 'roles/powerflex_mdm/molecule/mdm_uninstallation/.*',
            'roles/powerflex_mdm/tasks/*', 'roles/powerflex_mdm/tasks/.*',
            'roles/powerflex_mdm/vars/*', 'roles/powerflex_mdm/vars/.*',
            'roles/powerflex_sdc/*', 'roles/powerflex_sdc/.*',
            'roles/powerflex_sdc/defaults/*', 'roles/powerflex_sdc/defaults/.*',
            'roles/powerflex_sdc/handlers/*', 'roles/powerflex_sdc/handlers/.*',
            'roles/powerflex_sdc/meta/*', 'roles/powerflex_sdc/meta/.*',
            'roles/powerflex_sdc/molecule/*', 'roles/powerflex_sdc/molecule/.*',
            'roles/powerflex_sdc/molecule/sdc_install_map_volume_uninstall_negative/*', 'roles/powerflex_sdc/molecule/sdc_install_map_volume_uninstall_negative/.*',
            'roles/powerflex_sdc/molecule/sdc_installation/*', 'roles/powerflex_sdc/molecule/sdc_installation/.*',
            'roles/powerflex_sdc/molecule/sdc_installation_invalid_path_rpm/*', 'roles/powerflex_sdc/molecule/sdc_installation_invalid_path_rpm/.*',
            'roles/powerflex_sdc/molecule/sdc_uninstallation/*', 'roles/powerflex_sdc/molecule/sdc_uninstallation/.*',
            'roles/powerflex_sdc/molecule/wrong_sdc_credentials/*', 'roles/powerflex_sdc/molecule/wrong_sdc_credentials/.*',
            'roles/powerflex_sdc/molecule/wrong_sdc_ip/*', 'roles/powerflex_sdc/molecule/wrong_sdc_ip/.*',
            'roles/powerflex_sdc/tasks/*', 'roles/powerflex_sdc/tasks/.*',
            'roles/powerflex_sdc/templates/*', 'roles/powerflex_sdc/templates/.*',
            'roles/powerflex_sdc/vars/*', 'roles/powerflex_sdc/vars/.*',
            'roles/powerflex_sdr/*', 'roles/powerflex_sdr/.*',
            'roles/powerflex_sdr/defaults/*', 'roles/powerflex_sdr/defaults/.*',
            'roles/powerflex_sdr/meta/*', 'roles/powerflex_sdr/meta/.*',
            'roles/powerflex_sdr/molecule/*', 'roles/powerflex_sdr/molecule/.*',
            'roles/powerflex_sdr/molecule/sdr_installation/*', 'roles/powerflex_sdr/molecule/sdr_installation/.*',
            'roles/powerflex_sdr/molecule/sdr_installation_invalid_path_rpm/*', 'roles/powerflex_sdr/molecule/sdr_installation_invalid_path_rpm/.*',
            'roles/powerflex_sdr/molecule/sdr_installation_invalid_pd/*', 'roles/powerflex_sdr/molecule/sdr_installation_invalid_pd/.*',
            'roles/powerflex_sdr/molecule/sdr_uninstallation/*', 'roles/powerflex_sdr/molecule/sdr_uninstallation/.*',
            'roles/powerflex_sdr/tasks/*', 'roles/powerflex_sdr/tasks/.*',
            'roles/powerflex_sdr/vars/*', 'roles/powerflex_sdr/vars/.*',
            'roles/powerflex_sds/*', 'roles/powerflex_sds/.*',
            'roles/powerflex_sds/defaults/*', 'roles/powerflex_sds/defaults/.*',
            'roles/powerflex_sds/meta/*', 'roles/powerflex_sds/meta/.*',
            'roles/powerflex_sds/molecule/*', 'roles/powerflex_sds/molecule/.*',
            'roles/powerflex_sds/molecule/sds_installation/*', 'roles/powerflex_sds/molecule/sds_installation/.*',
            'roles/powerflex_sds/molecule/sds_uninstallation/*', 'roles/powerflex_sds/molecule/sds_uninstallation/.*',
            'roles/powerflex_sds/tasks/*', 'roles/powerflex_sds/tasks/.*',
            'roles/powerflex_sds/vars/*', 'roles/powerflex_sds/vars/.*',
            'roles/powerflex_tb/*', 'roles/powerflex_tb/.*',
            'roles/powerflex_tb/defaults/*', 'roles/powerflex_tb/defaults/.*',
            'roles/powerflex_tb/meta/*', 'roles/powerflex_tb/meta/.*',
            'roles/powerflex_tb/molecule/*', 'roles/powerflex_tb/molecule/.*',
            'roles/powerflex_tb/molecule/tb_installation/*', 'roles/powerflex_tb/molecule/tb_installation/.*',
            'roles/powerflex_tb/molecule/tb_uninstallation/*', 'roles/powerflex_tb/molecule/tb_uninstallation/.*',
            'roles/powerflex_tb/molecule/wrong_tb_credentials/*', 'roles/powerflex_tb/molecule/wrong_tb_credentials/.*',
            'roles/powerflex_tb/tasks/*', 'roles/powerflex_tb/tasks/.*',
            'roles/powerflex_tb/vars/*', 'roles/powerflex_tb/vars/.*',
            'roles/powerflex_webui/*', 'roles/powerflex_webui/.*',
            'roles/powerflex_webui/defaults/*', 'roles/powerflex_webui/defaults/.*',
            'roles/powerflex_webui/meta/*', 'roles/powerflex_webui/meta/.*',
            'roles/powerflex_webui/molecule/*', 'roles/powerflex_webui/molecule/.*',
            'roles/powerflex_webui/molecule/webui_installation/*', 'roles/powerflex_webui/molecule/webui_installation/.*',
            'roles/powerflex_webui/molecule/webui_installation_invalid_path_rpm/*', 'roles/powerflex_webui/molecule/webui_installation_invalid_path_rpm/.*',
            'roles/powerflex_webui/molecule/webui_uninstallation/*', 'roles/powerflex_webui/molecule/webui_uninstallation/.*',
            'roles/powerflex_webui/tasks/*', 'roles/powerflex_webui/tasks/.*',
            'roles/powerflex_webui/vars/*', 'roles/powerflex_webui/vars/.*',
        ],
        'ansible_collections.dellemc.unity': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'meta/*', 'meta/.*',
            'playbooks/*', 'playbooks/.*',
            'playbooks/modules/*', 'playbooks/modules/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/module_utils/storage/*', 'plugins/module_utils/storage/.*',
            'plugins/module_utils/storage/dell/*', 'plugins/module_utils/storage/dell/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.f5networks.f5_modules': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/action/*', 'plugins/action/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/filter/*', 'plugins/filter/.*',
            'plugins/lookup/*', 'plugins/lookup/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'plugins/terminal/*', 'plugins/terminal/.*',
        ],
        'ansible_collections.fortinet.fortimanager': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/httpapi/*', 'plugins/httpapi/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.fortinet.fortios': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/httpapi/*', 'plugins/httpapi/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/module_utils/common/*', 'plugins/module_utils/common/.*',
            'plugins/module_utils/fortimanager/*', 'plugins/module_utils/fortimanager/.*',
            'plugins/module_utils/fortios/*', 'plugins/module_utils/fortios/.*',
            'plugins/module_utils/fortios/argspec/*', 'plugins/module_utils/fortios/argspec/.*',
            'plugins/module_utils/fortios/argspec/facts/*', 'plugins/module_utils/fortios/argspec/facts/.*',
            'plugins/module_utils/fortios/argspec/system/*', 'plugins/module_utils/fortios/argspec/system/.*',
            'plugins/module_utils/fortios/facts/*', 'plugins/module_utils/fortios/facts/.*',
            'plugins/module_utils/fortios/facts/system/*', 'plugins/module_utils/fortios/facts/system/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.frr.frr': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/cliconf/*', 'plugins/cliconf/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/module_utils/network/*', 'plugins/module_utils/network/.*',
            'plugins/module_utils/network/frr/*', 'plugins/module_utils/network/frr/.*',
            'plugins/module_utils/network/frr/providers/*', 'plugins/module_utils/network/frr/providers/.*',
            'plugins/module_utils/network/frr/providers/cli/*', 'plugins/module_utils/network/frr/providers/cli/.*',
            'plugins/module_utils/network/frr/providers/cli/config/*', 'plugins/module_utils/network/frr/providers/cli/config/.*',
            'plugins/module_utils/network/frr/providers/cli/config/bgp/*', 'plugins/module_utils/network/frr/providers/cli/config/bgp/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'plugins/terminal/*', 'plugins/terminal/.*',
        ],
        'ansible_collections.gluster.gluster': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.google.cloud': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'meta/*', 'meta/.*',
            'molecule/*', 'molecule/.*',
            'molecule/gcloud/*', 'molecule/gcloud/.*',
            'molecule/gcloud/files/*', 'molecule/gcloud/files/.*',
            'molecule/gcloud/tests/*', 'molecule/gcloud/tests/.*',
            'molecule/gcsfuse/*', 'molecule/gcsfuse/.*',
            'molecule/gcsfuse/files/*', 'molecule/gcsfuse/files/.*',
            'molecule/gcsfuse/tests/*', 'molecule/gcsfuse/tests/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/filter/*', 'plugins/filter/.*',
            'plugins/inventory/*', 'plugins/inventory/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'roles/*', 'roles/.*',
            'roles/gcloud/*', 'roles/gcloud/.*',
            'roles/gcloud/defaults/*', 'roles/gcloud/defaults/.*',
            'roles/gcloud/meta/*', 'roles/gcloud/meta/.*',
            'roles/gcloud/tasks/*', 'roles/gcloud/tasks/.*',
            'roles/gcloud/tasks/archive/*', 'roles/gcloud/tasks/archive/.*',
            'roles/gcloud/tasks/package/*', 'roles/gcloud/tasks/package/.*',
            'roles/gcloud/vars/*', 'roles/gcloud/vars/.*',
            'roles/gcp_http_lb/*', 'roles/gcp_http_lb/.*',
            'roles/gcp_http_lb/defaults/*', 'roles/gcp_http_lb/defaults/.*',
            'roles/gcp_http_lb/meta/*', 'roles/gcp_http_lb/meta/.*',
            'roles/gcp_http_lb/tasks/*', 'roles/gcp_http_lb/tasks/.*',
            'roles/gcp_http_lb/tests/*', 'roles/gcp_http_lb/tests/.*',
            'roles/gcp_http_lb/vars/*', 'roles/gcp_http_lb/vars/.*',
            'roles/gcsfuse/*', 'roles/gcsfuse/.*',
            'roles/gcsfuse/defaults/*', 'roles/gcsfuse/defaults/.*',
            'roles/gcsfuse/handlers/*', 'roles/gcsfuse/handlers/.*',
            'roles/gcsfuse/meta/*', 'roles/gcsfuse/meta/.*',
            'roles/gcsfuse/tasks/*', 'roles/gcsfuse/tasks/.*',
            'roles/gcsfuse/vars/*', 'roles/gcsfuse/vars/.*',
            'scripts/*', 'scripts/.*',
            'test-fixtures/*', 'test-fixtures/.*',
            'test-fixtures/cloud-function-source/*', 'test-fixtures/cloud-function-source/.*',
        ],
        'ansible_collections.grafana.grafana': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'examples/*', 'examples/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'roles/*', 'roles/.*',
            'roles/grafana/*', 'roles/grafana/.*',
            'roles/grafana/defaults/*', 'roles/grafana/defaults/.*',
            'roles/grafana/handlers/*', 'roles/grafana/handlers/.*',
            'roles/grafana/meta/*', 'roles/grafana/meta/.*',
            'roles/grafana/molecule/*', 'roles/grafana/molecule/.*',
            'roles/grafana/molecule/alternative/*', 'roles/grafana/molecule/alternative/.*',
            'roles/grafana/molecule/alternative/tests/*', 'roles/grafana/molecule/alternative/tests/.*',
            'roles/grafana/molecule/default/*', 'roles/grafana/molecule/default/.*',
            'roles/grafana/molecule/default/tests/*', 'roles/grafana/molecule/default/tests/.*',
            'roles/grafana/tasks/*', 'roles/grafana/tasks/.*',
            'roles/grafana/templates/*', 'roles/grafana/templates/.*',
            'roles/grafana/vars/*', 'roles/grafana/vars/.*',
            'roles/grafana/vars/distro/*', 'roles/grafana/vars/distro/.*',
            'roles/grafana_agent/*', 'roles/grafana_agent/.*',
            'roles/grafana_agent/defaults/*', 'roles/grafana_agent/defaults/.*',
            'roles/grafana_agent/handlers/*', 'roles/grafana_agent/handlers/.*',
            'roles/grafana_agent/meta/*', 'roles/grafana_agent/meta/.*',
            'roles/grafana_agent/tasks/*', 'roles/grafana_agent/tasks/.*',
            'roles/grafana_agent/tasks/install/*', 'roles/grafana_agent/tasks/install/.*',
            'roles/grafana_agent/tasks/preflight/*', 'roles/grafana_agent/tasks/preflight/.*',
            'roles/grafana_agent/templates/*', 'roles/grafana_agent/templates/.*',
            'roles/grafana_agent/vars/*', 'roles/grafana_agent/vars/.*',
            'tools/*', 'tools/.*',
            'tools/includes/*', 'tools/includes/.*',
        ],
        'ansible_collections.hetzner.hcloud': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/inventory/*', 'plugins/inventory/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/module_utils/vendor/*', 'plugins/module_utils/vendor/.*',
            'plugins/module_utils/vendor/hcloud/*', 'plugins/module_utils/vendor/hcloud/.*',
            'plugins/module_utils/vendor/hcloud/actions/*', 'plugins/module_utils/vendor/hcloud/actions/.*',
            'plugins/module_utils/vendor/hcloud/certificates/*', 'plugins/module_utils/vendor/hcloud/certificates/.*',
            'plugins/module_utils/vendor/hcloud/core/*', 'plugins/module_utils/vendor/hcloud/core/.*',
            'plugins/module_utils/vendor/hcloud/datacenters/*', 'plugins/module_utils/vendor/hcloud/datacenters/.*',
            'plugins/module_utils/vendor/hcloud/deprecation/*', 'plugins/module_utils/vendor/hcloud/deprecation/.*',
            'plugins/module_utils/vendor/hcloud/firewalls/*', 'plugins/module_utils/vendor/hcloud/firewalls/.*',
            'plugins/module_utils/vendor/hcloud/floating_ips/*', 'plugins/module_utils/vendor/hcloud/floating_ips/.*',
            'plugins/module_utils/vendor/hcloud/helpers/*', 'plugins/module_utils/vendor/hcloud/helpers/.*',
            'plugins/module_utils/vendor/hcloud/images/*', 'plugins/module_utils/vendor/hcloud/images/.*',
            'plugins/module_utils/vendor/hcloud/isos/*', 'plugins/module_utils/vendor/hcloud/isos/.*',
            'plugins/module_utils/vendor/hcloud/load_balancer_types/*', 'plugins/module_utils/vendor/hcloud/load_balancer_types/.*',
            'plugins/module_utils/vendor/hcloud/load_balancers/*', 'plugins/module_utils/vendor/hcloud/load_balancers/.*',
            'plugins/module_utils/vendor/hcloud/locations/*', 'plugins/module_utils/vendor/hcloud/locations/.*',
            'plugins/module_utils/vendor/hcloud/networks/*', 'plugins/module_utils/vendor/hcloud/networks/.*',
            'plugins/module_utils/vendor/hcloud/placement_groups/*', 'plugins/module_utils/vendor/hcloud/placement_groups/.*',
            'plugins/module_utils/vendor/hcloud/primary_ips/*', 'plugins/module_utils/vendor/hcloud/primary_ips/.*',
            'plugins/module_utils/vendor/hcloud/server_types/*', 'plugins/module_utils/vendor/hcloud/server_types/.*',
            'plugins/module_utils/vendor/hcloud/servers/*', 'plugins/module_utils/vendor/hcloud/servers/.*',
            'plugins/module_utils/vendor/hcloud/ssh_keys/*', 'plugins/module_utils/vendor/hcloud/ssh_keys/.*',
            'plugins/module_utils/vendor/hcloud/volumes/*', 'plugins/module_utils/vendor/hcloud/volumes/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'scripts/*', 'scripts/.*',
        ],
        'ansible_collections.hpe.nimble': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.ibm.qradar': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/action/*', 'plugins/action/.*',
            'plugins/httpapi/*', 'plugins/httpapi/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.ibm.spectrum_virtualize': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'meta/*', 'meta/.*',
            'playbooks/*', 'playbooks/.*',
            'playbooks/volume_migration/*', 'playbooks/volume_migration/.*',
            'plugins/*', 'plugins/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'roles/*', 'roles/.*',
        ],
        'ansible_collections.ibm.storage_virtualize': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'playbooks/*', 'playbooks/.*',
            'playbooks/multi_volume_create_host_mapping_zone_multipath/*', 'playbooks/multi_volume_create_host_mapping_zone_multipath/.*',
            'playbooks/volume_migration/*', 'playbooks/volume_migration/.*',
            'playbooks/volume_migration_on_svc_iscsi/*', 'playbooks/volume_migration_on_svc_iscsi/.*',
            'plugins/*', 'plugins/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.infinidat.infinibox': [
            '*',
            'bin/*', 'bin/.*',
            'ibox_vars/*', 'ibox_vars/.*',
            'meta/*', 'meta/.*',
            'playbooks/*', 'playbooks/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/filter/*', 'plugins/filter/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'test-args/*', 'test-args/.*',
        ],
        'ansible_collections.infoblox.nios_modules': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'meta/*', 'meta/.*',
            'playbooks/*', 'playbooks/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/inventory/*', 'plugins/inventory/.*',
            'plugins/lookup/*', 'plugins/lookup/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.inspur.ispim': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.inspur.sm': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'playbooks/*', 'playbooks/.*',
            'playbooks/modules/*', 'playbooks/modules/.*',
            'playbooks/modules/overall/*', 'playbooks/modules/overall/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.junipernetworks.junos': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/action/*', 'plugins/action/.*',
            'plugins/cliconf/*', 'plugins/cliconf/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/module_utils/network/*', 'plugins/module_utils/network/.*',
            'plugins/module_utils/network/junos/*', 'plugins/module_utils/network/junos/.*',
            'plugins/module_utils/network/junos/argspec/*', 'plugins/module_utils/network/junos/argspec/.*',
            'plugins/module_utils/network/junos/argspec/acl_interfaces/*', 'plugins/module_utils/network/junos/argspec/acl_interfaces/.*',
            'plugins/module_utils/network/junos/argspec/acls/*', 'plugins/module_utils/network/junos/argspec/acls/.*',
            'plugins/module_utils/network/junos/argspec/bgp_address_family/*', 'plugins/module_utils/network/junos/argspec/bgp_address_family/.*',
            'plugins/module_utils/network/junos/argspec/bgp_global/*', 'plugins/module_utils/network/junos/argspec/bgp_global/.*',
            'plugins/module_utils/network/junos/argspec/facts/*', 'plugins/module_utils/network/junos/argspec/facts/.*',
            'plugins/module_utils/network/junos/argspec/hostname/*', 'plugins/module_utils/network/junos/argspec/hostname/.*',
            'plugins/module_utils/network/junos/argspec/interfaces/*', 'plugins/module_utils/network/junos/argspec/interfaces/.*',
            'plugins/module_utils/network/junos/argspec/l2_interfaces/*', 'plugins/module_utils/network/junos/argspec/l2_interfaces/.*',
            'plugins/module_utils/network/junos/argspec/l3_interfaces/*', 'plugins/module_utils/network/junos/argspec/l3_interfaces/.*',
            'plugins/module_utils/network/junos/argspec/lacp/*', 'plugins/module_utils/network/junos/argspec/lacp/.*',
            'plugins/module_utils/network/junos/argspec/lacp_interfaces/*', 'plugins/module_utils/network/junos/argspec/lacp_interfaces/.*',
            'plugins/module_utils/network/junos/argspec/lag_interfaces/*', 'plugins/module_utils/network/junos/argspec/lag_interfaces/.*',
            'plugins/module_utils/network/junos/argspec/lldp_global/*', 'plugins/module_utils/network/junos/argspec/lldp_global/.*',
            'plugins/module_utils/network/junos/argspec/lldp_interfaces/*', 'plugins/module_utils/network/junos/argspec/lldp_interfaces/.*',
            'plugins/module_utils/network/junos/argspec/logging_global/*', 'plugins/module_utils/network/junos/argspec/logging_global/.*',
            'plugins/module_utils/network/junos/argspec/ntp_global/*', 'plugins/module_utils/network/junos/argspec/ntp_global/.*',
            'plugins/module_utils/network/junos/argspec/ospf_interfaces/*', 'plugins/module_utils/network/junos/argspec/ospf_interfaces/.*',
            'plugins/module_utils/network/junos/argspec/ospfv2/*', 'plugins/module_utils/network/junos/argspec/ospfv2/.*',
            'plugins/module_utils/network/junos/argspec/ospfv3/*', 'plugins/module_utils/network/junos/argspec/ospfv3/.*',
            'plugins/module_utils/network/junos/argspec/prefix_lists/*', 'plugins/module_utils/network/junos/argspec/prefix_lists/.*',
            'plugins/module_utils/network/junos/argspec/routing_instances/*', 'plugins/module_utils/network/junos/argspec/routing_instances/.*',
            'plugins/module_utils/network/junos/argspec/routing_options/*', 'plugins/module_utils/network/junos/argspec/routing_options/.*',
            'plugins/module_utils/network/junos/argspec/security_policies/*', 'plugins/module_utils/network/junos/argspec/security_policies/.*',
            'plugins/module_utils/network/junos/argspec/security_policies_global/*', 'plugins/module_utils/network/junos/argspec/security_policies_global/.*',
            'plugins/module_utils/network/junos/argspec/security_zones/*', 'plugins/module_utils/network/junos/argspec/security_zones/.*',
            'plugins/module_utils/network/junos/argspec/snmp_server/*', 'plugins/module_utils/network/junos/argspec/snmp_server/.*',
            'plugins/module_utils/network/junos/argspec/static_routes/*', 'plugins/module_utils/network/junos/argspec/static_routes/.*',
            'plugins/module_utils/network/junos/argspec/vlans/*', 'plugins/module_utils/network/junos/argspec/vlans/.*',
            'plugins/module_utils/network/junos/config/*', 'plugins/module_utils/network/junos/config/.*',
            'plugins/module_utils/network/junos/config/acl_interfaces/*', 'plugins/module_utils/network/junos/config/acl_interfaces/.*',
            'plugins/module_utils/network/junos/config/acls/*', 'plugins/module_utils/network/junos/config/acls/.*',
            'plugins/module_utils/network/junos/config/bgp_address_family/*', 'plugins/module_utils/network/junos/config/bgp_address_family/.*',
            'plugins/module_utils/network/junos/config/bgp_global/*', 'plugins/module_utils/network/junos/config/bgp_global/.*',
            'plugins/module_utils/network/junos/config/hostname/*', 'plugins/module_utils/network/junos/config/hostname/.*',
            'plugins/module_utils/network/junos/config/interfaces/*', 'plugins/module_utils/network/junos/config/interfaces/.*',
            'plugins/module_utils/network/junos/config/l2_interfaces/*', 'plugins/module_utils/network/junos/config/l2_interfaces/.*',
            'plugins/module_utils/network/junos/config/l3_interfaces/*', 'plugins/module_utils/network/junos/config/l3_interfaces/.*',
            'plugins/module_utils/network/junos/config/lacp/*', 'plugins/module_utils/network/junos/config/lacp/.*',
            'plugins/module_utils/network/junos/config/lacp_interfaces/*', 'plugins/module_utils/network/junos/config/lacp_interfaces/.*',
            'plugins/module_utils/network/junos/config/lag_interfaces/*', 'plugins/module_utils/network/junos/config/lag_interfaces/.*',
            'plugins/module_utils/network/junos/config/lldp_global/*', 'plugins/module_utils/network/junos/config/lldp_global/.*',
            'plugins/module_utils/network/junos/config/lldp_interfaces/*', 'plugins/module_utils/network/junos/config/lldp_interfaces/.*',
            'plugins/module_utils/network/junos/config/logging_global/*', 'plugins/module_utils/network/junos/config/logging_global/.*',
            'plugins/module_utils/network/junos/config/ntp_global/*', 'plugins/module_utils/network/junos/config/ntp_global/.*',
            'plugins/module_utils/network/junos/config/ospf_interfaces/*', 'plugins/module_utils/network/junos/config/ospf_interfaces/.*',
            'plugins/module_utils/network/junos/config/ospfv2/*', 'plugins/module_utils/network/junos/config/ospfv2/.*',
            'plugins/module_utils/network/junos/config/ospfv3/*', 'plugins/module_utils/network/junos/config/ospfv3/.*',
            'plugins/module_utils/network/junos/config/prefix_lists/*', 'plugins/module_utils/network/junos/config/prefix_lists/.*',
            'plugins/module_utils/network/junos/config/routing_instances/*', 'plugins/module_utils/network/junos/config/routing_instances/.*',
            'plugins/module_utils/network/junos/config/routing_options/*', 'plugins/module_utils/network/junos/config/routing_options/.*',
            'plugins/module_utils/network/junos/config/security_policies/*', 'plugins/module_utils/network/junos/config/security_policies/.*',
            'plugins/module_utils/network/junos/config/security_policies_global/*', 'plugins/module_utils/network/junos/config/security_policies_global/.*',
            'plugins/module_utils/network/junos/config/security_zones/*', 'plugins/module_utils/network/junos/config/security_zones/.*',
            'plugins/module_utils/network/junos/config/snmp_server/*', 'plugins/module_utils/network/junos/config/snmp_server/.*',
            'plugins/module_utils/network/junos/config/static_routes/*', 'plugins/module_utils/network/junos/config/static_routes/.*',
            'plugins/module_utils/network/junos/config/vlans/*', 'plugins/module_utils/network/junos/config/vlans/.*',
            'plugins/module_utils/network/junos/facts/*', 'plugins/module_utils/network/junos/facts/.*',
            'plugins/module_utils/network/junos/facts/acl_interfaces/*', 'plugins/module_utils/network/junos/facts/acl_interfaces/.*',
            'plugins/module_utils/network/junos/facts/acls/*', 'plugins/module_utils/network/junos/facts/acls/.*',
            'plugins/module_utils/network/junos/facts/bgp_address_family/*', 'plugins/module_utils/network/junos/facts/bgp_address_family/.*',
            'plugins/module_utils/network/junos/facts/bgp_global/*', 'plugins/module_utils/network/junos/facts/bgp_global/.*',
            'plugins/module_utils/network/junos/facts/hostname/*', 'plugins/module_utils/network/junos/facts/hostname/.*',
            'plugins/module_utils/network/junos/facts/interfaces/*', 'plugins/module_utils/network/junos/facts/interfaces/.*',
            'plugins/module_utils/network/junos/facts/l2_interfaces/*', 'plugins/module_utils/network/junos/facts/l2_interfaces/.*',
            'plugins/module_utils/network/junos/facts/l3_interfaces/*', 'plugins/module_utils/network/junos/facts/l3_interfaces/.*',
            'plugins/module_utils/network/junos/facts/lacp/*', 'plugins/module_utils/network/junos/facts/lacp/.*',
            'plugins/module_utils/network/junos/facts/lacp_interfaces/*', 'plugins/module_utils/network/junos/facts/lacp_interfaces/.*',
            'plugins/module_utils/network/junos/facts/lag_interfaces/*', 'plugins/module_utils/network/junos/facts/lag_interfaces/.*',
            'plugins/module_utils/network/junos/facts/legacy/*', 'plugins/module_utils/network/junos/facts/legacy/.*',
            'plugins/module_utils/network/junos/facts/lldp_global/*', 'plugins/module_utils/network/junos/facts/lldp_global/.*',
            'plugins/module_utils/network/junos/facts/lldp_interfaces/*', 'plugins/module_utils/network/junos/facts/lldp_interfaces/.*',
            'plugins/module_utils/network/junos/facts/logging_global/*', 'plugins/module_utils/network/junos/facts/logging_global/.*',
            'plugins/module_utils/network/junos/facts/ntp_global/*', 'plugins/module_utils/network/junos/facts/ntp_global/.*',
            'plugins/module_utils/network/junos/facts/ospf_interfaces/*', 'plugins/module_utils/network/junos/facts/ospf_interfaces/.*',
            'plugins/module_utils/network/junos/facts/ospfv2/*', 'plugins/module_utils/network/junos/facts/ospfv2/.*',
            'plugins/module_utils/network/junos/facts/ospfv3/*', 'plugins/module_utils/network/junos/facts/ospfv3/.*',
            'plugins/module_utils/network/junos/facts/prefix_lists/*', 'plugins/module_utils/network/junos/facts/prefix_lists/.*',
            'plugins/module_utils/network/junos/facts/routing_instances/*', 'plugins/module_utils/network/junos/facts/routing_instances/.*',
            'plugins/module_utils/network/junos/facts/routing_options/*', 'plugins/module_utils/network/junos/facts/routing_options/.*',
            'plugins/module_utils/network/junos/facts/security_policies/*', 'plugins/module_utils/network/junos/facts/security_policies/.*',
            'plugins/module_utils/network/junos/facts/security_policies_global/*', 'plugins/module_utils/network/junos/facts/security_policies_global/.*',
            'plugins/module_utils/network/junos/facts/security_zones/*', 'plugins/module_utils/network/junos/facts/security_zones/.*',
            'plugins/module_utils/network/junos/facts/snmp_server/*', 'plugins/module_utils/network/junos/facts/snmp_server/.*',
            'plugins/module_utils/network/junos/facts/static_routes/*', 'plugins/module_utils/network/junos/facts/static_routes/.*',
            'plugins/module_utils/network/junos/facts/vlans/*', 'plugins/module_utils/network/junos/facts/vlans/.*',
            'plugins/module_utils/network/junos/utils/*', 'plugins/module_utils/network/junos/utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'plugins/netconf/*', 'plugins/netconf/.*',
            'plugins/terminal/*', 'plugins/terminal/.*',
        ],
        'ansible_collections.kubernetes.core': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/action/*', 'plugins/action/.*',
            'plugins/connection/*', 'plugins/connection/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/filter/*', 'plugins/filter/.*',
            'plugins/inventory/*', 'plugins/inventory/.*',
            'plugins/lookup/*', 'plugins/lookup/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/module_utils/client/*', 'plugins/module_utils/client/.*',
            'plugins/module_utils/k8s/*', 'plugins/module_utils/k8s/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.lowlydba.sqlserver': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.microsoft.ad': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/action/*', 'plugins/action/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/filter/*', 'plugins/filter/.*',
            'plugins/inventory/*', 'plugins/inventory/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'plugins/plugin_utils/*', 'plugins/plugin_utils/.*',
            'plugins/plugin_utils/_ldap/*', 'plugins/plugin_utils/_ldap/.*',
        ],
        'ansible_collections.netapp.aws': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.netapp.azure': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.netapp.cloudmanager': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'execution_environments/*', 'execution_environments/.*',
            'execution_environments/from_galaxy/*', 'execution_environments/from_galaxy/.*',
            'execution_environments/from_github/*', 'execution_environments/from_github/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.netapp.elementsw': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.netapp.ontap': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'execution_environments/*', 'execution_environments/.*',
            'execution_environments/from_galaxy/*', 'execution_environments/from_galaxy/.*',
            'execution_environments/from_github/*', 'execution_environments/from_github/.*',
            'meta/*', 'meta/.*',
            'playbooks/*', 'playbooks/.*',
            'playbooks/examples/*', 'playbooks/examples/.*',
            'playbooks/examples/filter/*', 'playbooks/examples/filter/.*',
            'playbooks/examples/json_query/*', 'playbooks/examples/json_query/.*',
            'playbooks/examples/rest_apis/*', 'playbooks/examples/rest_apis/.*',
            'playbooks/examples/support/*', 'playbooks/examples/support/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/filter/*', 'plugins/filter/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'roles/*', 'roles/.*',
            'roles/na_ontap_cluster_config/*', 'roles/na_ontap_cluster_config/.*',
            'roles/na_ontap_cluster_config/defaults/*', 'roles/na_ontap_cluster_config/defaults/.*',
            'roles/na_ontap_cluster_config/handlers/*', 'roles/na_ontap_cluster_config/handlers/.*',
            'roles/na_ontap_cluster_config/meta/*', 'roles/na_ontap_cluster_config/meta/.*',
            'roles/na_ontap_cluster_config/tasks/*', 'roles/na_ontap_cluster_config/tasks/.*',
            'roles/na_ontap_cluster_config/tests/*', 'roles/na_ontap_cluster_config/tests/.*',
            'roles/na_ontap_cluster_config/vars/*', 'roles/na_ontap_cluster_config/vars/.*',
            'roles/na_ontap_nas_create/*', 'roles/na_ontap_nas_create/.*',
            'roles/na_ontap_nas_create/defaults/*', 'roles/na_ontap_nas_create/defaults/.*',
            'roles/na_ontap_nas_create/handlers/*', 'roles/na_ontap_nas_create/handlers/.*',
            'roles/na_ontap_nas_create/meta/*', 'roles/na_ontap_nas_create/meta/.*',
            'roles/na_ontap_nas_create/tasks/*', 'roles/na_ontap_nas_create/tasks/.*',
            'roles/na_ontap_nas_create/tests/*', 'roles/na_ontap_nas_create/tests/.*',
            'roles/na_ontap_nas_create/vars/*', 'roles/na_ontap_nas_create/vars/.*',
            'roles/na_ontap_san_create/*', 'roles/na_ontap_san_create/.*',
            'roles/na_ontap_san_create/defaults/*', 'roles/na_ontap_san_create/defaults/.*',
            'roles/na_ontap_san_create/handlers/*', 'roles/na_ontap_san_create/handlers/.*',
            'roles/na_ontap_san_create/meta/*', 'roles/na_ontap_san_create/meta/.*',
            'roles/na_ontap_san_create/tasks/*', 'roles/na_ontap_san_create/tasks/.*',
            'roles/na_ontap_san_create/tests/*', 'roles/na_ontap_san_create/tests/.*',
            'roles/na_ontap_san_create/vars/*', 'roles/na_ontap_san_create/vars/.*',
            'roles/na_ontap_snapmirror_create/*', 'roles/na_ontap_snapmirror_create/.*',
            'roles/na_ontap_snapmirror_create/defaults/*', 'roles/na_ontap_snapmirror_create/defaults/.*',
            'roles/na_ontap_snapmirror_create/handlers/*', 'roles/na_ontap_snapmirror_create/handlers/.*',
            'roles/na_ontap_snapmirror_create/meta/*', 'roles/na_ontap_snapmirror_create/meta/.*',
            'roles/na_ontap_snapmirror_create/tasks/*', 'roles/na_ontap_snapmirror_create/tasks/.*',
            'roles/na_ontap_snapmirror_create/tests/*', 'roles/na_ontap_snapmirror_create/tests/.*',
            'roles/na_ontap_snapmirror_create/vars/*', 'roles/na_ontap_snapmirror_create/vars/.*',
            'roles/na_ontap_vserver_create/*', 'roles/na_ontap_vserver_create/.*',
            'roles/na_ontap_vserver_create/defaults/*', 'roles/na_ontap_vserver_create/defaults/.*',
            'roles/na_ontap_vserver_create/handlers/*', 'roles/na_ontap_vserver_create/handlers/.*',
            'roles/na_ontap_vserver_create/meta/*', 'roles/na_ontap_vserver_create/meta/.*',
            'roles/na_ontap_vserver_create/tasks/*', 'roles/na_ontap_vserver_create/tasks/.*',
            'roles/na_ontap_vserver_create/tests/*', 'roles/na_ontap_vserver_create/tests/.*',
            'roles/na_ontap_vserver_create/vars/*', 'roles/na_ontap_vserver_create/vars/.*',
            'roles/na_ontap_vserver_delete/*', 'roles/na_ontap_vserver_delete/.*',
            'roles/na_ontap_vserver_delete/defaults/*', 'roles/na_ontap_vserver_delete/defaults/.*',
            'roles/na_ontap_vserver_delete/handlers/*', 'roles/na_ontap_vserver_delete/handlers/.*',
            'roles/na_ontap_vserver_delete/meta/*', 'roles/na_ontap_vserver_delete/meta/.*',
            'roles/na_ontap_vserver_delete/tasks/*', 'roles/na_ontap_vserver_delete/tasks/.*',
            'roles/na_ontap_vserver_delete/tests/*', 'roles/na_ontap_vserver_delete/tests/.*',
            'roles/na_ontap_vserver_delete/vars/*', 'roles/na_ontap_vserver_delete/vars/.*',
        ],
        'ansible_collections.netapp.storagegrid': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.netapp.um_info': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.netapp_eseries.santricity': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/lookup/*', 'plugins/lookup/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'roles/*', 'roles/.*',
            'roles/nar_santricity_common/*', 'roles/nar_santricity_common/.*',
            'roles/nar_santricity_common/defaults/*', 'roles/nar_santricity_common/defaults/.*',
            'roles/nar_santricity_common/meta/*', 'roles/nar_santricity_common/meta/.*',
            'roles/nar_santricity_common/tasks/*', 'roles/nar_santricity_common/tasks/.*',
            'roles/nar_santricity_common/tasks/collect_facts/*', 'roles/nar_santricity_common/tasks/collect_facts/.*',
            'roles/nar_santricity_host/*', 'roles/nar_santricity_host/.*',
            'roles/nar_santricity_host/defaults/*', 'roles/nar_santricity_host/defaults/.*',
            'roles/nar_santricity_host/meta/*', 'roles/nar_santricity_host/meta/.*',
            'roles/nar_santricity_host/tasks/*', 'roles/nar_santricity_host/tasks/.*',
            'roles/nar_santricity_host/tasks/interface/*', 'roles/nar_santricity_host/tasks/interface/.*',
            'roles/nar_santricity_host/tasks/snapshot/*', 'roles/nar_santricity_host/tasks/snapshot/.*',
            'roles/nar_santricity_host/templates/*', 'roles/nar_santricity_host/templates/.*',
            'roles/nar_santricity_management/*', 'roles/nar_santricity_management/.*',
            'roles/nar_santricity_management/defaults/*', 'roles/nar_santricity_management/defaults/.*',
            'roles/nar_santricity_management/meta/*', 'roles/nar_santricity_management/meta/.*',
            'roles/nar_santricity_management/tasks/*', 'roles/nar_santricity_management/tasks/.*',
            'vars/*', 'vars/.*',
        ],
        'ansible_collections.netbox.netbox': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'hacking/*', 'hacking/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/inventory/*', 'plugins/inventory/.*',
            'plugins/lookup/*', 'plugins/lookup/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.ngine_io.cloudstack': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/inventory/*', 'plugins/inventory/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'scripts/*', 'scripts/.*',
            'scripts/inventory/*', 'scripts/inventory/.*',
        ],
        'ansible_collections.ngine_io.exoscale': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.ngine_io.vultr': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/inventory/*', 'plugins/inventory/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.openstack.cloud': [
            '*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/inventory/*', 'plugins/inventory/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.openvswitch.openvswitch': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.ovirt.ovirt': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'examples/*', 'examples/.*',
            'examples/filters/*', 'examples/filters/.*',
            'exported-artifacts/*', 'exported-artifacts/.*',
            'licenses/*', 'licenses/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/callback/*', 'plugins/callback/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/filter/*', 'plugins/filter/.*',
            'plugins/inventory/*', 'plugins/inventory/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'plugins/test/*', 'plugins/test/.*',
            'roles/*', 'roles/.*',
            'roles/cluster_upgrade/*', 'roles/cluster_upgrade/.*',
            'roles/cluster_upgrade/defaults/*', 'roles/cluster_upgrade/defaults/.*',
            'roles/cluster_upgrade/examples/*', 'roles/cluster_upgrade/examples/.*',
            'roles/cluster_upgrade/tasks/*', 'roles/cluster_upgrade/tasks/.*',
            'roles/disaster_recovery/*', 'roles/disaster_recovery/.*',
            'roles/disaster_recovery/defaults/*', 'roles/disaster_recovery/defaults/.*',
            'roles/disaster_recovery/examples/*', 'roles/disaster_recovery/examples/.*',
            'roles/disaster_recovery/files/*', 'roles/disaster_recovery/files/.*',
            'roles/disaster_recovery/tasks/*', 'roles/disaster_recovery/tasks/.*',
            'roles/disaster_recovery/tasks/clean/*', 'roles/disaster_recovery/tasks/clean/.*',
            'roles/disaster_recovery/tasks/recover/*', 'roles/disaster_recovery/tasks/recover/.*',
            'roles/engine_setup/*', 'roles/engine_setup/.*',
            'roles/engine_setup/defaults/*', 'roles/engine_setup/defaults/.*',
            'roles/engine_setup/examples/*', 'roles/engine_setup/examples/.*',
            'roles/engine_setup/tasks/*', 'roles/engine_setup/tasks/.*',
            'roles/engine_setup/templates/*', 'roles/engine_setup/templates/.*',
            'roles/engine_setup/tests/*', 'roles/engine_setup/tests/.*',
            'roles/engine_setup/vars/*', 'roles/engine_setup/vars/.*',
            'roles/hosted_engine_setup/*', 'roles/hosted_engine_setup/.*',
            'roles/hosted_engine_setup/defaults/*', 'roles/hosted_engine_setup/defaults/.*',
            'roles/hosted_engine_setup/examples/*', 'roles/hosted_engine_setup/examples/.*',
            'roles/hosted_engine_setup/files/*', 'roles/hosted_engine_setup/files/.*',
            'roles/hosted_engine_setup/hooks/*', 'roles/hosted_engine_setup/hooks/.*',
            'roles/hosted_engine_setup/hooks/after_add_host/*', 'roles/hosted_engine_setup/hooks/after_add_host/.*',
            'roles/hosted_engine_setup/hooks/after_setup/*', 'roles/hosted_engine_setup/hooks/after_setup/.*',
            'roles/hosted_engine_setup/hooks/enginevm_after_engine_setup/*', 'roles/hosted_engine_setup/hooks/enginevm_after_engine_setup/.*',
            'roles/hosted_engine_setup/hooks/enginevm_before_engine_setup/*', 'roles/hosted_engine_setup/hooks/enginevm_before_engine_setup/.*',
            'roles/hosted_engine_setup/tasks/*', 'roles/hosted_engine_setup/tasks/.*',
            'roles/hosted_engine_setup/tasks/bootstrap_local_vm/*', 'roles/hosted_engine_setup/tasks/bootstrap_local_vm/.*',
            'roles/hosted_engine_setup/tasks/create_target_vm/*', 'roles/hosted_engine_setup/tasks/create_target_vm/.*',
            'roles/hosted_engine_setup/tasks/pre_checks/*', 'roles/hosted_engine_setup/tasks/pre_checks/.*',
            'roles/hosted_engine_setup/templates/*', 'roles/hosted_engine_setup/templates/.*',
            'roles/image_template/*', 'roles/image_template/.*',
            'roles/image_template/defaults/*', 'roles/image_template/defaults/.*',
            'roles/image_template/examples/*', 'roles/image_template/examples/.*',
            'roles/image_template/tasks/*', 'roles/image_template/tasks/.*',
            'roles/image_template/vars/*', 'roles/image_template/vars/.*',
            'roles/infra/*', 'roles/infra/.*',
            'roles/infra/defaults/*', 'roles/infra/defaults/.*',
            'roles/infra/examples/*', 'roles/infra/examples/.*',
            'roles/infra/examples/vars/*', 'roles/infra/examples/vars/.*',
            'roles/infra/roles/*', 'roles/infra/roles/.*',
            'roles/infra/roles/aaa_jdbc/*', 'roles/infra/roles/aaa_jdbc/.*',
            'roles/infra/roles/aaa_jdbc/defaults/*', 'roles/infra/roles/aaa_jdbc/defaults/.*',
            'roles/infra/roles/aaa_jdbc/tasks/*', 'roles/infra/roles/aaa_jdbc/tasks/.*',
            'roles/infra/roles/clusters/*', 'roles/infra/roles/clusters/.*',
            'roles/infra/roles/clusters/tasks/*', 'roles/infra/roles/clusters/tasks/.*',
            'roles/infra/roles/clusters/vars/*', 'roles/infra/roles/clusters/vars/.*',
            'roles/infra/roles/datacenter_cleanup/*', 'roles/infra/roles/datacenter_cleanup/.*',
            'roles/infra/roles/datacenter_cleanup/defaults/*', 'roles/infra/roles/datacenter_cleanup/defaults/.*',
            'roles/infra/roles/datacenter_cleanup/tasks/*', 'roles/infra/roles/datacenter_cleanup/tasks/.*',
            'roles/infra/roles/datacenters/*', 'roles/infra/roles/datacenters/.*',
            'roles/infra/roles/datacenters/defaults/*', 'roles/infra/roles/datacenters/defaults/.*',
            'roles/infra/roles/datacenters/tasks/*', 'roles/infra/roles/datacenters/tasks/.*',
            'roles/infra/roles/external_providers/*', 'roles/infra/roles/external_providers/.*',
            'roles/infra/roles/external_providers/tasks/*', 'roles/infra/roles/external_providers/tasks/.*',
            'roles/infra/roles/hosts/*', 'roles/infra/roles/hosts/.*',
            'roles/infra/roles/hosts/defaults/*', 'roles/infra/roles/hosts/defaults/.*',
            'roles/infra/roles/hosts/tasks/*', 'roles/infra/roles/hosts/tasks/.*',
            'roles/infra/roles/mac_pools/*', 'roles/infra/roles/mac_pools/.*',
            'roles/infra/roles/mac_pools/tasks/*', 'roles/infra/roles/mac_pools/tasks/.*',
            'roles/infra/roles/networks/*', 'roles/infra/roles/networks/.*',
            'roles/infra/roles/networks/tasks/*', 'roles/infra/roles/networks/tasks/.*',
            'roles/infra/roles/permissions/*', 'roles/infra/roles/permissions/.*',
            'roles/infra/roles/permissions/tasks/*', 'roles/infra/roles/permissions/tasks/.*',
            'roles/infra/roles/storages/*', 'roles/infra/roles/storages/.*',
            'roles/infra/roles/storages/tasks/*', 'roles/infra/roles/storages/tasks/.*',
            'roles/infra/tasks/*', 'roles/infra/tasks/.*',
            'roles/remove_stale_lun/*', 'roles/remove_stale_lun/.*',
            'roles/remove_stale_lun/defaults/*', 'roles/remove_stale_lun/defaults/.*',
            'roles/remove_stale_lun/examples/*', 'roles/remove_stale_lun/examples/.*',
            'roles/remove_stale_lun/tasks/*', 'roles/remove_stale_lun/tasks/.*',
            'roles/repositories/*', 'roles/repositories/.*',
            'roles/repositories/defaults/*', 'roles/repositories/defaults/.*',
            'roles/repositories/examples/*', 'roles/repositories/examples/.*',
            'roles/repositories/tasks/*', 'roles/repositories/tasks/.*',
            'roles/repositories/vars/*', 'roles/repositories/vars/.*',
            'roles/shutdown_env/*', 'roles/shutdown_env/.*',
            'roles/shutdown_env/defaults/*', 'roles/shutdown_env/defaults/.*',
            'roles/shutdown_env/examples/*', 'roles/shutdown_env/examples/.*',
            'roles/shutdown_env/tasks/*', 'roles/shutdown_env/tasks/.*',
            'roles/vm_infra/*', 'roles/vm_infra/.*',
            'roles/vm_infra/defaults/*', 'roles/vm_infra/defaults/.*',
            'roles/vm_infra/examples/*', 'roles/vm_infra/examples/.*',
            'roles/vm_infra/tasks/*', 'roles/vm_infra/tasks/.*',
        ],
        'ansible_collections.purestorage.flasharray': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'playbooks/*', 'playbooks/.*',
            'playbooks/files/*', 'playbooks/files/.*',
            'playbooks/roles/*', 'playbooks/roles/.*',
            'playbooks/tasks/*', 'playbooks/tasks/.*',
            'playbooks/templates/*', 'playbooks/templates/.*',
            'playbooks/vars/*', 'playbooks/vars/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'roles/*', 'roles/.*',
        ],
        'ansible_collections.purestorage.flashblade': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'playbooks/*', 'playbooks/.*',
            'playbooks/files/*', 'playbooks/files/.*',
            'playbooks/roles/*', 'playbooks/roles/.*',
            'playbooks/tasks/*', 'playbooks/tasks/.*',
            'playbooks/templates/*', 'playbooks/templates/.*',
            'playbooks/vars/*', 'playbooks/vars/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'roles/*', 'roles/.*',
        ],
        'ansible_collections.purestorage.fusion': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'playbooks/*', 'playbooks/.*',
            'playbooks/simple/*', 'playbooks/simple/.*',
            'playbooks/tasks/*', 'playbooks/tasks/.*',
            'playbooks/templates/*', 'playbooks/templates/.*',
            'playbooks/vars/*', 'playbooks/vars/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/inventory/*', 'plugins/inventory/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.sensu.sensu_go': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'docker/*', 'docker/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/action/*', 'plugins/action/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/filter/*', 'plugins/filter/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'roles/*', 'roles/.*',
            'roles/agent/*', 'roles/agent/.*',
            'roles/agent/defaults/*', 'roles/agent/defaults/.*',
            'roles/agent/handlers/*', 'roles/agent/handlers/.*',
            'roles/agent/meta/*', 'roles/agent/meta/.*',
            'roles/agent/tasks/*', 'roles/agent/tasks/.*',
            'roles/agent/tasks/linux/*', 'roles/agent/tasks/linux/.*',
            'roles/agent/tasks/windows/*', 'roles/agent/tasks/windows/.*',
            'roles/agent/templates/*', 'roles/agent/templates/.*',
            'roles/agent/vars/*', 'roles/agent/vars/.*',
            'roles/backend/*', 'roles/backend/.*',
            'roles/backend/defaults/*', 'roles/backend/defaults/.*',
            'roles/backend/handlers/*', 'roles/backend/handlers/.*',
            'roles/backend/meta/*', 'roles/backend/meta/.*',
            'roles/backend/tasks/*', 'roles/backend/tasks/.*',
            'roles/backend/templates/*', 'roles/backend/templates/.*',
            'roles/backend/vars/*', 'roles/backend/vars/.*',
            'roles/install/*', 'roles/install/.*',
            'roles/install/defaults/*', 'roles/install/defaults/.*',
            'roles/install/meta/*', 'roles/install/meta/.*',
            'roles/install/tasks/*', 'roles/install/tasks/.*',
            'roles/install/tasks/apt/*', 'roles/install/tasks/apt/.*',
            'roles/install/tasks/dnf/*', 'roles/install/tasks/dnf/.*',
            'roles/install/tasks/msi/*', 'roles/install/tasks/msi/.*',
            'roles/install/tasks/yum/*', 'roles/install/tasks/yum/.*',
            'roles/install/vars/*', 'roles/install/vars/.*',
            'tools/*', 'tools/.*',
            'vagrant/*', 'vagrant/.*',
            'vagrant/windows/*', 'vagrant/windows/.*',
        ],
        'ansible_collections.servicenow.servicenow': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'config/*', 'config/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/inventory/*', 'plugins/inventory/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'update_sets/*', 'update_sets/.*',
        ],
        'ansible_collections.splunk.es': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/action/*', 'plugins/action/.*',
            'plugins/httpapi/*', 'plugins/httpapi/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.t_systems_mms.icinga_director': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'examples/*', 'examples/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/inventory/*', 'plugins/inventory/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'roles/*', 'roles/.*',
            'roles/ansible_icinga/*', 'roles/ansible_icinga/.*',
            'roles/ansible_icinga/defaults/*', 'roles/ansible_icinga/defaults/.*',
            'roles/ansible_icinga/handlers/*', 'roles/ansible_icinga/handlers/.*',
            'roles/ansible_icinga/meta/*', 'roles/ansible_icinga/meta/.*',
            'roles/ansible_icinga/tasks/*', 'roles/ansible_icinga/tasks/.*',
        ],
        'ansible_collections.telekom_mms.icinga_director': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'examples/*', 'examples/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/inventory/*', 'plugins/inventory/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'roles/*', 'roles/.*',
            'roles/ansible_icinga/*', 'roles/ansible_icinga/.*',
            'roles/ansible_icinga/defaults/*', 'roles/ansible_icinga/defaults/.*',
            'roles/ansible_icinga/handlers/*', 'roles/ansible_icinga/handlers/.*',
            'roles/ansible_icinga/meta/*', 'roles/ansible_icinga/meta/.*',
            'roles/ansible_icinga/tasks/*', 'roles/ansible_icinga/tasks/.*',
        ],
        'ansible_collections.theforeman.foreman': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/callback/*', 'plugins/callback/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/filter/*', 'plugins/filter/.*',
            'plugins/inventory/*', 'plugins/inventory/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'roles/*', 'roles/.*',
            'roles/activation_keys/*', 'roles/activation_keys/.*',
            'roles/activation_keys/tasks/*', 'roles/activation_keys/tasks/.*',
            'roles/auth_sources_ldap/*', 'roles/auth_sources_ldap/.*',
            'roles/auth_sources_ldap/tasks/*', 'roles/auth_sources_ldap/tasks/.*',
            'roles/compute_profiles/*', 'roles/compute_profiles/.*',
            'roles/compute_profiles/tasks/*', 'roles/compute_profiles/tasks/.*',
            'roles/compute_resources/*', 'roles/compute_resources/.*',
            'roles/compute_resources/tasks/*', 'roles/compute_resources/tasks/.*',
            'roles/content_credentials/*', 'roles/content_credentials/.*',
            'roles/content_credentials/tasks/*', 'roles/content_credentials/tasks/.*',
            'roles/content_rhel/*', 'roles/content_rhel/.*',
            'roles/content_rhel/defaults/*', 'roles/content_rhel/defaults/.*',
            'roles/content_rhel/tasks/*', 'roles/content_rhel/tasks/.*',
            'roles/content_view_publish/*', 'roles/content_view_publish/.*',
            'roles/content_view_publish/tasks/*', 'roles/content_view_publish/tasks/.*',
            'roles/content_view_version_cleanup/*', 'roles/content_view_version_cleanup/.*',
            'roles/content_view_version_cleanup/tasks/*', 'roles/content_view_version_cleanup/tasks/.*',
            'roles/content_views/*', 'roles/content_views/.*',
            'roles/content_views/tasks/*', 'roles/content_views/tasks/.*',
            'roles/convert2rhel/*', 'roles/convert2rhel/.*',
            'roles/convert2rhel/defaults/*', 'roles/convert2rhel/defaults/.*',
            'roles/convert2rhel/tasks/*', 'roles/convert2rhel/tasks/.*',
            'roles/domains/*', 'roles/domains/.*',
            'roles/domains/tasks/*', 'roles/domains/tasks/.*',
            'roles/hostgroups/*', 'roles/hostgroups/.*',
            'roles/hostgroups/tasks/*', 'roles/hostgroups/tasks/.*',
            'roles/lifecycle_environments/*', 'roles/lifecycle_environments/.*',
            'roles/lifecycle_environments/tasks/*', 'roles/lifecycle_environments/tasks/.*',
            'roles/locations/*', 'roles/locations/.*',
            'roles/locations/tasks/*', 'roles/locations/tasks/.*',
            'roles/manifest/*', 'roles/manifest/.*',
            'roles/manifest/defaults/*', 'roles/manifest/defaults/.*',
            'roles/manifest/tasks/*', 'roles/manifest/tasks/.*',
            'roles/operatingsystems/*', 'roles/operatingsystems/.*',
            'roles/operatingsystems/tasks/*', 'roles/operatingsystems/tasks/.*',
            'roles/organizations/*', 'roles/organizations/.*',
            'roles/organizations/tasks/*', 'roles/organizations/tasks/.*',
            'roles/provisioning_templates/*', 'roles/provisioning_templates/.*',
            'roles/provisioning_templates/tasks/*', 'roles/provisioning_templates/tasks/.*',
            'roles/repositories/*', 'roles/repositories/.*',
            'roles/repositories/tasks/*', 'roles/repositories/tasks/.*',
            'roles/settings/*', 'roles/settings/.*',
            'roles/settings/tasks/*', 'roles/settings/tasks/.*',
            'roles/subnets/*', 'roles/subnets/.*',
            'roles/subnets/tasks/*', 'roles/subnets/tasks/.*',
            'roles/sync_plans/*', 'roles/sync_plans/.*',
            'roles/sync_plans/tasks/*', 'roles/sync_plans/tasks/.*',
        ],
        'ansible_collections.vmware.vmware_rest': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'config/*', 'config/.*',
            'manual/*', 'manual/.*',
            'manual/source/*', 'manual/source/.*',
            'manual/source/vmware_rest_scenarios/*', 'manual/source/vmware_rest_scenarios/.*',
            'manual/source/vmware_rest_scenarios/appliance/*', 'manual/source/vmware_rest_scenarios/appliance/.*',
            'manual/source/vmware_rest_scenarios/vcenter/*', 'manual/source/vmware_rest_scenarios/vcenter/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/lookup/*', 'plugins/lookup/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'plugins/plugin_utils/*', 'plugins/plugin_utils/.*',
        ],
        'ansible_collections.vultr.cloud': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/inventory/*', 'plugins/inventory/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
        'ansible_collections.vyos.vyos': [
            '*',
            'changelogs/*', 'changelogs/.*',
            'changelogs/fragments/*', 'changelogs/fragments/.*',
            'meta/*', 'meta/.*',
            'plugins/*', 'plugins/.*',
            'plugins/action/*', 'plugins/action/.*',
            'plugins/cliconf/*', 'plugins/cliconf/.*',
            'plugins/doc_fragments/*', 'plugins/doc_fragments/.*',
            'plugins/filter/*', 'plugins/filter/.*',
            'plugins/inventory/*', 'plugins/inventory/.*',
            'plugins/module_utils/*', 'plugins/module_utils/.*',
            'plugins/module_utils/network/*', 'plugins/module_utils/network/.*',
            'plugins/module_utils/network/vyos/*', 'plugins/module_utils/network/vyos/.*',
            'plugins/module_utils/network/vyos/argspec/*', 'plugins/module_utils/network/vyos/argspec/.*',
            'plugins/module_utils/network/vyos/argspec/bgp_address_family/*', 'plugins/module_utils/network/vyos/argspec/bgp_address_family/.*',
            'plugins/module_utils/network/vyos/argspec/bgp_global/*', 'plugins/module_utils/network/vyos/argspec/bgp_global/.*',
            'plugins/module_utils/network/vyos/argspec/facts/*', 'plugins/module_utils/network/vyos/argspec/facts/.*',
            'plugins/module_utils/network/vyos/argspec/firewall_global/*', 'plugins/module_utils/network/vyos/argspec/firewall_global/.*',
            'plugins/module_utils/network/vyos/argspec/firewall_interfaces/*', 'plugins/module_utils/network/vyos/argspec/firewall_interfaces/.*',
            'plugins/module_utils/network/vyos/argspec/firewall_rules/*', 'plugins/module_utils/network/vyos/argspec/firewall_rules/.*',
            'plugins/module_utils/network/vyos/argspec/hostname/*', 'plugins/module_utils/network/vyos/argspec/hostname/.*',
            'plugins/module_utils/network/vyos/argspec/interfaces/*', 'plugins/module_utils/network/vyos/argspec/interfaces/.*',
            'plugins/module_utils/network/vyos/argspec/l3_interfaces/*', 'plugins/module_utils/network/vyos/argspec/l3_interfaces/.*',
            'plugins/module_utils/network/vyos/argspec/lag_interfaces/*', 'plugins/module_utils/network/vyos/argspec/lag_interfaces/.*',
            'plugins/module_utils/network/vyos/argspec/lldp_global/*', 'plugins/module_utils/network/vyos/argspec/lldp_global/.*',
            'plugins/module_utils/network/vyos/argspec/lldp_interfaces/*', 'plugins/module_utils/network/vyos/argspec/lldp_interfaces/.*',
            'plugins/module_utils/network/vyos/argspec/logging_global/*', 'plugins/module_utils/network/vyos/argspec/logging_global/.*',
            'plugins/module_utils/network/vyos/argspec/ntp_global/*', 'plugins/module_utils/network/vyos/argspec/ntp_global/.*',
            'plugins/module_utils/network/vyos/argspec/ospf_interfaces/*', 'plugins/module_utils/network/vyos/argspec/ospf_interfaces/.*',
            'plugins/module_utils/network/vyos/argspec/ospfv2/*', 'plugins/module_utils/network/vyos/argspec/ospfv2/.*',
            'plugins/module_utils/network/vyos/argspec/ospfv3/*', 'plugins/module_utils/network/vyos/argspec/ospfv3/.*',
            'plugins/module_utils/network/vyos/argspec/prefix_lists/*', 'plugins/module_utils/network/vyos/argspec/prefix_lists/.*',
            'plugins/module_utils/network/vyos/argspec/route_maps/*', 'plugins/module_utils/network/vyos/argspec/route_maps/.*',
            'plugins/module_utils/network/vyos/argspec/snmp_server/*', 'plugins/module_utils/network/vyos/argspec/snmp_server/.*',
            'plugins/module_utils/network/vyos/argspec/static_routes/*', 'plugins/module_utils/network/vyos/argspec/static_routes/.*',
            'plugins/module_utils/network/vyos/config/*', 'plugins/module_utils/network/vyos/config/.*',
            'plugins/module_utils/network/vyos/config/bgp_address_family/*', 'plugins/module_utils/network/vyos/config/bgp_address_family/.*',
            'plugins/module_utils/network/vyos/config/bgp_global/*', 'plugins/module_utils/network/vyos/config/bgp_global/.*',
            'plugins/module_utils/network/vyos/config/firewall_global/*', 'plugins/module_utils/network/vyos/config/firewall_global/.*',
            'plugins/module_utils/network/vyos/config/firewall_interfaces/*', 'plugins/module_utils/network/vyos/config/firewall_interfaces/.*',
            'plugins/module_utils/network/vyos/config/firewall_rules/*', 'plugins/module_utils/network/vyos/config/firewall_rules/.*',
            'plugins/module_utils/network/vyos/config/hostname/*', 'plugins/module_utils/network/vyos/config/hostname/.*',
            'plugins/module_utils/network/vyos/config/interfaces/*', 'plugins/module_utils/network/vyos/config/interfaces/.*',
            'plugins/module_utils/network/vyos/config/l3_interfaces/*', 'plugins/module_utils/network/vyos/config/l3_interfaces/.*',
            'plugins/module_utils/network/vyos/config/lag_interfaces/*', 'plugins/module_utils/network/vyos/config/lag_interfaces/.*',
            'plugins/module_utils/network/vyos/config/lldp_global/*', 'plugins/module_utils/network/vyos/config/lldp_global/.*',
            'plugins/module_utils/network/vyos/config/lldp_interfaces/*', 'plugins/module_utils/network/vyos/config/lldp_interfaces/.*',
            'plugins/module_utils/network/vyos/config/logging_global/*', 'plugins/module_utils/network/vyos/config/logging_global/.*',
            'plugins/module_utils/network/vyos/config/ntp_global/*', 'plugins/module_utils/network/vyos/config/ntp_global/.*',
            'plugins/module_utils/network/vyos/config/ospf_interfaces/*', 'plugins/module_utils/network/vyos/config/ospf_interfaces/.*',
            'plugins/module_utils/network/vyos/config/ospfv2/*', 'plugins/module_utils/network/vyos/config/ospfv2/.*',
            'plugins/module_utils/network/vyos/config/ospfv3/*', 'plugins/module_utils/network/vyos/config/ospfv3/.*',
            'plugins/module_utils/network/vyos/config/prefix_lists/*', 'plugins/module_utils/network/vyos/config/prefix_lists/.*',
            'plugins/module_utils/network/vyos/config/route_maps/*', 'plugins/module_utils/network/vyos/config/route_maps/.*',
            'plugins/module_utils/network/vyos/config/snmp_server/*', 'plugins/module_utils/network/vyos/config/snmp_server/.*',
            'plugins/module_utils/network/vyos/config/static_routes/*', 'plugins/module_utils/network/vyos/config/static_routes/.*',
            'plugins/module_utils/network/vyos/facts/*', 'plugins/module_utils/network/vyos/facts/.*',
            'plugins/module_utils/network/vyos/facts/bgp_address_family/*', 'plugins/module_utils/network/vyos/facts/bgp_address_family/.*',
            'plugins/module_utils/network/vyos/facts/bgp_global/*', 'plugins/module_utils/network/vyos/facts/bgp_global/.*',
            'plugins/module_utils/network/vyos/facts/firewall_global/*', 'plugins/module_utils/network/vyos/facts/firewall_global/.*',
            'plugins/module_utils/network/vyos/facts/firewall_interfaces/*', 'plugins/module_utils/network/vyos/facts/firewall_interfaces/.*',
            'plugins/module_utils/network/vyos/facts/firewall_rules/*', 'plugins/module_utils/network/vyos/facts/firewall_rules/.*',
            'plugins/module_utils/network/vyos/facts/hostname/*', 'plugins/module_utils/network/vyos/facts/hostname/.*',
            'plugins/module_utils/network/vyos/facts/interfaces/*', 'plugins/module_utils/network/vyos/facts/interfaces/.*',
            'plugins/module_utils/network/vyos/facts/l3_interfaces/*', 'plugins/module_utils/network/vyos/facts/l3_interfaces/.*',
            'plugins/module_utils/network/vyos/facts/lag_interfaces/*', 'plugins/module_utils/network/vyos/facts/lag_interfaces/.*',
            'plugins/module_utils/network/vyos/facts/legacy/*', 'plugins/module_utils/network/vyos/facts/legacy/.*',
            'plugins/module_utils/network/vyos/facts/lldp_global/*', 'plugins/module_utils/network/vyos/facts/lldp_global/.*',
            'plugins/module_utils/network/vyos/facts/lldp_interfaces/*', 'plugins/module_utils/network/vyos/facts/lldp_interfaces/.*',
            'plugins/module_utils/network/vyos/facts/logging_global/*', 'plugins/module_utils/network/vyos/facts/logging_global/.*',
            'plugins/module_utils/network/vyos/facts/ntp_global/*', 'plugins/module_utils/network/vyos/facts/ntp_global/.*',
            'plugins/module_utils/network/vyos/facts/ospf_interfaces/*', 'plugins/module_utils/network/vyos/facts/ospf_interfaces/.*',
            'plugins/module_utils/network/vyos/facts/ospfv2/*', 'plugins/module_utils/network/vyos/facts/ospfv2/.*',
            'plugins/module_utils/network/vyos/facts/ospfv3/*', 'plugins/module_utils/network/vyos/facts/ospfv3/.*',
            'plugins/module_utils/network/vyos/facts/prefix_lists/*', 'plugins/module_utils/network/vyos/facts/prefix_lists/.*',
            'plugins/module_utils/network/vyos/facts/route_maps/*', 'plugins/module_utils/network/vyos/facts/route_maps/.*',
            'plugins/module_utils/network/vyos/facts/snmp_server/*', 'plugins/module_utils/network/vyos/facts/snmp_server/.*',
            'plugins/module_utils/network/vyos/facts/static_routes/*', 'plugins/module_utils/network/vyos/facts/static_routes/.*',
            'plugins/module_utils/network/vyos/rm_templates/*', 'plugins/module_utils/network/vyos/rm_templates/.*',
            'plugins/module_utils/network/vyos/utils/*', 'plugins/module_utils/network/vyos/utils/.*',
            'plugins/modules/*', 'plugins/modules/.*',
            'plugins/terminal/*', 'plugins/terminal/.*',
        ],
        'ansible_collections.wti.remote': [
            '*',
            'meta/*', 'meta/.*',
            'playbooks/*', 'playbooks/.*',
            'playbooks/cpm_config/*', 'playbooks/cpm_config/.*',
            'playbooks/cpm_firmwareupdate/*', 'playbooks/cpm_firmwareupdate/.*',
            'playbooks/cpm_hostname/*', 'playbooks/cpm_hostname/.*',
            'playbooks/cpm_interface/*', 'playbooks/cpm_interface/.*',
            'playbooks/cpm_iptables/*', 'playbooks/cpm_iptables/.*',
            'playbooks/cpm_plugconfig/*', 'playbooks/cpm_plugconfig/.*',
            'playbooks/cpm_plugcontrol/*', 'playbooks/cpm_plugcontrol/.*',
            'playbooks/cpm_serial_ports/*', 'playbooks/cpm_serial_ports/.*',
            'playbooks/cpm_snmp/*', 'playbooks/cpm_snmp/.*',
            'playbooks/cpm_status/*', 'playbooks/cpm_status/.*',
            'playbooks/cpm_syslog_client/*', 'playbooks/cpm_syslog_client/.*',
            'playbooks/cpm_syslog_server/*', 'playbooks/cpm_syslog_server/.*',
            'playbooks/cpm_time_date/*', 'playbooks/cpm_time_date/.*',
            'playbooks/cpm_user/*', 'playbooks/cpm_user/.*',
            'plugins/*', 'plugins/.*',
            'plugins/lookup/*', 'plugins/lookup/.*',
            'plugins/modules/*', 'plugins/modules/.*',
        ],
    },
    install_requires=[
        'ansible-core ~= 2.15.7',
    ],
    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Environment :: Console',
        'Framework :: Ansible',
        'Intended Audience :: Developers',
        'Intended Audience :: Information Technology',
        'Intended Audience :: System Administrators',
        'License :: OSI Approved :: GNU General Public License v3 or later (GPLv3+)',
        'Natural Language :: English',
        'Operating System :: POSIX',
        'Programming Language :: Python :: 3.9',
        'Programming Language :: Python :: 3.10',
        'Programming Language :: Python :: 3.11',
        'Topic :: System :: Installation/Setup',
        'Topic :: System :: Systems Administration',
        'Topic :: Utilities',
    ],
    data_files=[],
    entry_points={
        'console_scripts': [
            'ansible-community=ansible_collections.ansible_community:main'
        ]
    },
    # Installing as zip files would break due to references to __file__
    zip_safe=False
)