/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.formula.geometry;

import java.util.Comparator;
import org.psjava.ds.geometry.Point2D;
import org.psjava.ds.numbersystrem.MultipliableNumberSystem;
import org.psjava.formula.geometry.DistanceSquareBetweenPoints;

public class PointByDistanceComparator {
    public static <T> Comparator<Point2D<T>> create(final Point2D<T> ref, final MultipliableNumberSystem<T> ns) {
        return new Comparator<Point2D<T>>(){

            @Override
            public int compare(Point2D<T> p1, Point2D<T> p2) {
                return ns.compare(this.calcDistanceSquare(p1), this.calcDistanceSquare(p2));
            }

            private T calcDistanceSquare(Point2D<T> p) {
                return DistanceSquareBetweenPoints.calc(ns, ref, p);
            }
        };
    }

    private PointByDistanceComparator() {
    }
}

