/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.RangeStreamer;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.EndpointsByReplica;
import org.apache.cassandra.locator.EndpointsForRange;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.RangesAtEndpoint;
import org.apache.cassandra.locator.RangesByEndpoint;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.streaming.StreamOperation;
import org.apache.cassandra.streaming.StreamPlan;
import org.apache.cassandra.streaming.StreamState;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
public class RangeRelocator {
    private static final Logger logger = LoggerFactory.getLogger(StorageService.class);
    private final StreamPlan streamPlan = new StreamPlan(StreamOperation.RELOCATION);
    private final InetAddressAndPort localAddress = FBUtilities.getBroadcastAddressAndPort();
    private final TokenMetadata tokenMetaCloneAllSettled;
    private final TokenMetadata tokenMetaClone;
    private final Collection<Token> tokens;
    private final List<String> keyspaceNames;

    RangeRelocator(Collection<Token> tokens, List<String> keyspaceNames, TokenMetadata tmd) {
        this.tokens = tokens;
        this.keyspaceNames = keyspaceNames;
        this.tokenMetaCloneAllSettled = tmd.cloneAfterAllSettled();
        this.tokenMetaClone = tmd.cloneOnlyTokenMap();
    }

    @VisibleForTesting
    public RangeRelocator() {
        this.tokens = null;
        this.keyspaceNames = null;
        this.tokenMetaCloneAllSettled = null;
        this.tokenMetaClone = null;
    }

    private static Multimap<InetAddressAndPort, RangeStreamer.FetchReplica> calculateRangesToFetchWithPreferredEndpoints(RangesAtEndpoint fetchRanges, AbstractReplicationStrategy strategy, String keyspace, TokenMetadata tmdBefore, TokenMetadata tmdAfter) {
        EndpointsByReplica preferredEndpoints = RangeStreamer.calculateRangesToFetchWithPreferredEndpoints(DatabaseDescriptor.getEndpointSnitch()::sortedByProximity, strategy, fetchRanges, StorageService.useStrictConsistency, tmdBefore, tmdAfter, keyspace, Arrays.asList(new RangeStreamer.FailureDetectorSourceFilter(FailureDetector.instance), new RangeStreamer.ExcludeLocalNodeFilter()));
        return RangeStreamer.convertPreferredEndpointsToWorkMap(preferredEndpoints);
    }

    public static RangesByEndpoint calculateRangesToStreamWithEndpoints(RangesAtEndpoint streamRanges, AbstractReplicationStrategy strat, TokenMetadata tmdBefore, TokenMetadata tmdAfter) {
        RangesByEndpoint.Builder endpointRanges = new RangesByEndpoint.Builder();
        for (Replica toStream : streamRanges) {
            EndpointsForRange oldEndpoints = strat.calculateNaturalReplicas((Token)toStream.range().right, tmdBefore);
            EndpointsForRange newEndpoints = strat.calculateNaturalReplicas((Token)toStream.range().right, tmdAfter);
            logger.debug("Need to stream {}, current endpoints {}, new endpoints {}", new Object[]{toStream, oldEndpoints, newEndpoints});
            for (Replica newEndpoint : newEndpoints) {
                Replica oldEndpoint;
                if (newEndpoint.equals(oldEndpoint = oldEndpoints.byEndpoint().get(newEndpoint.endpoint()))) continue;
                if (oldEndpoint == null) {
                    if (toStream.isTransient() && newEndpoint.isFull()) {
                        throw new AssertionError((Object)String.format("Need to stream %s, but only have %s which is transient and not full", newEndpoint, toStream));
                    }
                    for (Range<Token> intersection : newEndpoint.range().intersectionWith(toStream.range())) {
                        endpointRanges.put(newEndpoint.endpoint(), newEndpoint.decorateSubrange(intersection));
                    }
                    continue;
                }
                Set<Range<Token>> subsToStream = Collections.singleton(toStream.range());
                if (oldEndpoint.isFull() == newEndpoint.isFull() || oldEndpoint.isFull()) {
                    subsToStream = toStream.range().subtract(oldEndpoint.range());
                }
                subsToStream.stream().flatMap(range -> range.intersectionWith(newEndpoint.range()).stream()).forEach(tokenRange -> endpointRanges.put(newEndpoint.endpoint(), newEndpoint.decorateSubrange((Range<Token>)tokenRange)));
            }
        }
        return endpointRanges.build();
    }

    public void calculateToFromStreams() {
        logger.debug("Current tmd: {}, Updated tmd: {}", (Object)this.tokenMetaClone, (Object)this.tokenMetaCloneAllSettled);
        for (String keyspace : this.keyspaceNames) {
            AbstractReplicationStrategy strategy = Keyspace.open(keyspace).getReplicationStrategy();
            logger.info("Calculating ranges to stream and request for keyspace {}", (Object)keyspace);
            for (Token newToken : this.tokens) {
                Pair<RangesAtEndpoint, RangesAtEndpoint> streamAndFetchOwnRanges;
                Collection<Token> currentTokens = this.tokenMetaClone.getTokens(this.localAddress);
                if (currentTokens.size() > 1 || currentTokens.isEmpty()) {
                    throw new AssertionError((Object)("Unexpected current tokens: " + currentTokens));
                }
                if (this.tokenMetaClone.getTopology().getDatacenterEndpoints().get((Object)DatabaseDescriptor.getEndpointSnitch().getLocalDatacenter()).size() > 1) {
                    RangesAtEndpoint currentReplicas = strategy.getAddressReplicas(this.localAddress);
                    RangesAtEndpoint updatedReplicas = strategy.getPendingAddressRanges(this.tokenMetaClone, newToken, this.localAddress);
                    streamAndFetchOwnRanges = RangeRelocator.calculateStreamAndFetchRanges(currentReplicas, updatedReplicas);
                } else {
                    streamAndFetchOwnRanges = Pair.create(RangesAtEndpoint.empty(this.localAddress), RangesAtEndpoint.empty(this.localAddress));
                }
                RangesByEndpoint rangesToStream = RangeRelocator.calculateRangesToStreamWithEndpoints((RangesAtEndpoint)streamAndFetchOwnRanges.left, strategy, this.tokenMetaClone, this.tokenMetaCloneAllSettled);
                logger.info("Endpoint ranges to stream to " + rangesToStream);
                for (InetAddressAndPort address2 : rangesToStream.keySet()) {
                    logger.debug("Will stream range {} of keyspace {} to endpoint {}", new Object[]{rangesToStream.get(address2), keyspace, address2});
                    RangesAtEndpoint ranges = rangesToStream.get(address2);
                    this.streamPlan.transferRanges(address2, keyspace, ranges, new String[0]);
                }
                Multimap<InetAddressAndPort, RangeStreamer.FetchReplica> rangesToFetch = RangeRelocator.calculateRangesToFetchWithPreferredEndpoints((RangesAtEndpoint)streamAndFetchOwnRanges.right, strategy, keyspace, this.tokenMetaClone, this.tokenMetaCloneAllSettled);
                rangesToFetch.asMap().forEach((address, sourceAndOurReplicas) -> {
                    RangesAtEndpoint full = sourceAndOurReplicas.stream().filter(pair -> pair.remote.isFull()).map(pair -> pair.local).collect(RangesAtEndpoint.collector(this.localAddress));
                    RangesAtEndpoint trans = sourceAndOurReplicas.stream().filter(pair -> pair.remote.isTransient()).map(pair -> pair.local).collect(RangesAtEndpoint.collector(this.localAddress));
                    logger.debug("Will request range {} of keyspace {} from endpoint {}", new Object[]{rangesToFetch.get(address), keyspace, address});
                    this.streamPlan.requestRanges((InetAddressAndPort)address, keyspace, full, trans);
                });
                logger.debug("Keyspace {}: work map {}.", (Object)keyspace, rangesToFetch);
            }
        }
    }

    public static Pair<RangesAtEndpoint, RangesAtEndpoint> calculateStreamAndFetchRanges(RangesAtEndpoint currentRanges, RangesAtEndpoint updatedRanges) {
        RangesAtEndpoint.Builder toStream = RangesAtEndpoint.builder(currentRanges.endpoint());
        RangesAtEndpoint.Builder toFetch = RangesAtEndpoint.builder(currentRanges.endpoint());
        logger.debug("Calculating toStream");
        RangeRelocator.computeRanges(currentRanges, updatedRanges, toStream);
        logger.debug("Calculating toFetch");
        RangeRelocator.computeRanges(updatedRanges, currentRanges, toFetch);
        logger.debug("To stream {}", (Object)toStream);
        logger.debug("To fetch {}", (Object)toFetch);
        return Pair.create(toStream.build(), toFetch.build());
    }

    private static void computeRanges(RangesAtEndpoint srcRanges, RangesAtEndpoint dstRanges, RangesAtEndpoint.Builder ranges) {
        for (Replica src : srcRanges) {
            boolean intersect = false;
            RangesAtEndpoint remainder = null;
            for (Replica dst : dstRanges) {
                logger.debug("Comparing {} and {}", (Object)src, (Object)dst);
                if (!src.intersectsOnRange(dst) || src.isFull() && dst.isTransient()) continue;
                if (remainder == null) {
                    remainder = src.subtractIgnoreTransientStatus(dst.range());
                } else {
                    RangesAtEndpoint.Builder newRemainder = new RangesAtEndpoint.Builder(remainder.endpoint());
                    for (Replica replica : remainder) {
                        newRemainder.addAll(replica.subtractIgnoreTransientStatus(dst.range()));
                    }
                    remainder = newRemainder.build();
                }
                intersect = true;
            }
            if (!intersect) {
                assert (remainder == null);
                logger.debug("    Doesn't intersect adding {}", (Object)src);
                ranges.add(src);
                continue;
            }
            ranges.addAll(remainder);
            logger.debug("    Intersects adding {}", remainder);
        }
    }

    public Future<StreamState> stream() {
        return this.streamPlan.execute();
    }

    public boolean streamsNeeded() {
        return !this.streamPlan.isEmpty();
    }
}

