#include <shared/system.h>
#include "BeebState.h"
#include "misc.h"
#include <type_traits>

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////

static_assert(!std::is_convertible<BBCMicroState, BeebState>::value);
static_assert(!std::is_convertible<BBCMicroReadOnlyState, BeebState>::value);
static_assert(std::is_convertible<BBCMicroUniqueState, BeebState>::value);

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////

BeebState::BeebState(const BBCMicroUniqueState &src)
    : BBCMicroUniqueState(src)
    , creation_time(GetUTCTimeNow()) {
}

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
