#ifndef HEADER_50FB61B12F8C4CCEB9C1F801782A6C15 // -*- mode:c++ -*-
#define HEADER_50FB61B12F8C4CCEB9C1F801782A6C15

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

#include "conf.h"

#include <shared/enum_decl.h>
#include "roms.inl"
#include <shared/enum_end.h>

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

struct ROMTypeMetadata {
    ROMType type;
    const char *description = nullptr; //shown in UI
    size_t num_bytes = 0;
};

const ROMTypeMetadata *GetROMTypeMetadata(ROMType type);

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

struct OSROMTypeMetadata {
    OSROMType type;
    const char *description = nullptr; //shown in UI
    size_t file_size_bytes = 0;
    size_t rom_offset = 0;
    size_t rom_size_bytes = 0;
};

const OSROMTypeMetadata *GetOSROMTypeMetadata(OSROMType type);
uint8_t GetNumNonOSSidewaysROMs(OSROMType type);

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

#endif
