#ifndef HEADER_DE4FC9D40C6B4B689588DF36DEF47B9F
#define HEADER_DE4FC9D40C6B4B689588DF36DEF47B9F

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

#include "SN76489.h"
#include "conf.h"

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

// 250,000 Hz
static constexpr uint64_t SHIFT_CONSTANTS(2MHZ, SOUND_CLOCK, 3);
static constexpr uint64_t SHIFT_CONSTANTS(CYCLE_COUNT, SOUND_CLOCK, LSHIFT_SOUND_CLOCK_TO_2MHZ + LSHIFT_2MHZ_TO_CYCLE_COUNT);

// Sound chip clock frequency.
static constexpr unsigned SOUND_CLOCK_HZ = CYCLES_PER_SECOND >> RSHIFT_CYCLE_COUNT_TO_SOUND_CLOCK;

#define SOUND_CLOCKS_FROM_MS(N) (SOUND_CLOCK_HZ * (N) / 1000)

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

struct SoundDataUnit {
    SN76489::Output sn_output;
    float disc_drive_sound;
};
typedef struct SoundDataUnit SoundDataUnit;

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

#endif
