/*
 * The format here is
 *   name
 *   gate,c1,c2
 *   bb (bounding box: xmin, xmax, ymin, ymax)
 *   geometry (unused) (width1, width2, length, #segments, area)
 *   weak (boolean) (marks weak transistors, whether pullups or pass gates)
 *
 * Note: the geometry is of the MOSFET channel: the two widths are
 * the lengths of the two edges where the poly is crossing the active
 * area. These will be equal if the channel is straight or makes an
 * equal number of right and left turns. The number of segments should
 * be 1 for a rectangular channel, or 2 for an L shape, 3 for a Z
 * or U, and will allow for taking into account corner effects.
 * 
 * At time of writing JSSim doesn't use transistor strength information
 * except to discard weak transistors and to treat pullups as
 * described in segdefs.js specially.
 *
 */
var transdefs = [
['t1',1646,13,663,[560,721,2656,2730],[415,415,11,5,4566],false],
['t2',1646,14,663,[560,721,1902,1976],[415,415,11,5,4566],false],
['t3',1646,663,15,[560,721,1147,1221],[415,415,11,5,4566],false],
['t4',1646,663,16,[560,721,1999,2073],[415,415,11,5,4566],false],
['t5',1646,663,17,[560,721,1245,1319],[415,415,11,5,4566],false],
['t6',21,13,663,[586,757,2616,2672],[271,271,10,4,2749],false],
['t7',21,13,663,[612,763,2562,2604],[182,182,10,2,1869],false],
['t8',22,14,663,[586,757,1861,1918],[271,271,10,4,2752],false],
['t9',22,14,663,[612,763,1808,1850],[182,182,10,2,1872],false],
['t10',23,663,15,[586,757,1107,1163],[271,271,10,4,2752],false],
['t11',23,663,15,[612,763,1054,1096],[182,182,10,2,1866],false],
['t12',24,663,16,[586,757,2057,2112],[271,271,10,4,2747],false],
['t13',24,663,16,[612,763,2125,2165],[180,180,10,2,1846],false],
['t14',25,663,17,[586,757,1303,1358],[271,271,10,4,2747],false],
['t15',25,663,17,[612,763,1371,1410],[180,180,10,2,1845],false],
['t17',13,1854,31,[439,550,2533,2574],[241,241,11,3,2532],false],
['t18',13,31,1854,[439,549,2584,2627],[241,241,11,3,2584],false],
['t19',13,31,1854,[439,549,2636,2705],[346,346,11,9,3655],false],
['t20',13,31,1854,[122,549,2602,2735],[861,861,10,24,8878],false],
['t22',14,1855,31,[439,550,1779,1820],[241,241,11,3,2532],false],
['t23',14,31,1855,[439,549,1830,1872],[241,241,11,3,2584],false],
['t24',14,31,1855,[439,549,1882,1950],[346,346,11,9,3655],false],
['t25',14,1855,31,[122,549,1847,1981],[862,862,10,24,8882],false],
['t27',15,1856,31,[439,550,1025,1066],[241,241,11,3,2532],false],
['t28',15,31,1856,[439,549,1076,1118],[241,241,11,3,2584],false],
['t29',15,31,1856,[439,549,1128,1196],[346,346,11,9,3655],false],
['t30',15,31,1856,[122,549,1093,1227],[862,862,10,24,8881],false],
['t32',16,1857,31,[439,550,2155,2196],[241,241,11,3,2532],false],
['t33',16,31,1857,[439,549,2103,2145],[241,241,11,3,2584],false],
['t34',16,31,1857,[439,549,2025,2093],[346,346,11,9,3655],false],
['t35',16,31,1857,[122,549,1994,2124],[858,858,10,24,8846],false],
['t37',17,31,1858,[439,550,1401,1442],[241,241,11,3,2532],false],
['t38',17,31,1858,[439,549,1348,1391],[241,241,11,3,2584],false],
['t39',17,31,1858,[439,549,1270,1339],[346,346,11,9,3655],false],
['t40',17,1858,31,[122,549,1240,1370],[858,858,10,24,8845],false],
['t41',18,1859,31,[122,549,485,590],[830,830,10,24,8554],false],
['t42',18,1859,31,[439,550,646,688],[241,241,11,3,2528],false],
['t44',18,31,1859,[439,549,594,636],[240,240,11,3,2576],false],
['t45',18,31,1859,[439,549,516,585],[345,345,11,9,3647],false],
['t46',21,1854,663,[122,550,2371,2513],[879,879,10,24,9062],false],
['t47',21,663,1854,[439,550,2396,2470],[308,308,11,7,3219],false],
['t48',21,663,1854,[439,550,2480,2522],[243,243,11,3,2645],false],
['t49',22,1855,663,[122,550,1617,1759],[879,879,10,24,9061],false],
['t50',22,663,1855,[439,550,1642,1716],[308,308,11,7,3219],false],
['t51',22,663,1855,[439,550,1726,1768],[243,243,11,3,2645],false],
['t52',23,1856,663,[122,550,863,1005],[879,879,10,24,9062],false],
['t53',23,663,1856,[439,550,888,962],[308,308,11,7,3219],false],
['t54',23,663,1856,[439,550,972,1014],[243,243,11,3,2645],false],
['t55',24,1857,663,[122,550,2213,2358],[883,883,10,24,9100],false],
['t56',24,663,1857,[439,550,2259,2333],[308,308,11,7,3219],false],
['t57',24,663,1857,[439,550,2208,2250],[243,243,11,3,2645],false],
['t58',25,663,1858,[122,550,1458,1604],[883,883,10,24,9104],false],
['t59',25,663,1858,[439,550,1505,1579],[308,308,11,7,3219],false],
['t60',25,663,1858,[439,550,1453,1496],[243,243,11,3,2645],false],
['t61',26,1859,663,[122,550,707,850],[880,880,10,24,9072],false],
['t62',26,663,1859,[439,550,751,825],[308,308,11,7,3219],false],
['t63',26,663,1859,[439,550,699,741],[243,243,11,3,2645],false],
['t70',27,21,663,[581,759,2441,2513],[416,416,11,5,4499],false],
['t71',28,22,663,[581,759,1686,1759],[416,416,11,5,4499],false],
['t72',29,23,663,[581,759,932,1005],[417,417,11,5,4512],false],
['t73',30,24,663,[581,759,2216,2289],[416,416,11,5,4499],false],
['t74',32,25,663,[581,759,1462,1535],[416,416,11,5,4499],false],
['t75',33,26,663,[581,759,708,781],[416,416,11,5,4505],false],
['t76',1646,21,663,[560,723,2379,2451],[418,418,11,5,4481],false],
['t77',1646,22,663,[560,723,1624,1697],[418,418,11,5,4481],false],
['t78',1646,23,663,[560,723,870,943],[418,418,11,5,4481],false],
['t79',1646,24,663,[560,723,2279,2351],[418,418,11,5,4481],false],
['t80',1646,25,663,[560,723,1525,1597],[418,418,11,5,4481],false],
['t81',1646,26,663,[560,719,770,843],[410,410,11,5,4391],false],
['t82',1647,30,71,[718,754,2190,2203],[36,36,13,1,477],false],
['t83',1647,28,68,[718,754,1772,1785],[36,36,13,1,477],false],
['t84',1647,29,62,[718,754,1017,1031],[36,36,13,1,477],false],
['t85',1647,32,65,[718,754,1436,1449],[36,36,13,1,477],false],
['t86',1646,663,18,[732,772,618,628],[40,40,10,1,411],false],
['t87',1646,663,18,[588,756,552,628],[367,367,10,7,3871],false],
['t88',26,663,18,[616,699,552,562],[84,84,10,1,840],false],
['t89',26,663,18,[570,757,494,542],[381,381,9,6,3783],false],
['t90',19,31,1860,[125,549,354,473],[692,692,10,26,7332],false],
['t91',1646,19,663,[696,753,387,424],[123,123,10,3,1246],false],
['t92',1646,19,663,[588,765,414,455],[278,278,10,7,2906],false],
['t93',20,19,663,[586,769,319,403],[502,502,10,10,5191],false],
['t95',20,663,1860,[448,612,143,228],[609,609,10,13,6189],false],
['t96',20,663,1860,[183,612,112,167],[831,831,10,21,8396],false],
['t97',19,31,1860,[448,561,394,435],[246,246,10,3,2583],false],
['t98',19,31,1860,[448,561,343,383],[247,247,10,3,2529],false],
['t100',19,1860,31,[448,564,239,332],[489,489,10,7,4989],false],
['t101',1646,20,663,[639,680,113,310],[380,380,11,3,4079],false],
['t102',1073,663,20,[691,765,114,271],[397,397,10,9,4004],false],
['t103',1647,33,34,[740,753,679,716],[37,37,13,1,476],false],
['t104',1511,663,6,[915,927,756,835],[79,79,12,1,932],false],
['t105',1511,7,663,[947,959,756,835],[79,79,12,1,954],false],
['t106',1647,35,53,[998,1012,681,717],[35,35,13,1,469],false],
['t107',35,663,36,[905,975,573,719],[410,410,10,9,4195],false],
['t108',1646,663,36,[831,921,573,719],[402,402,10,9,3984],false],
['t110',36,37,663,[1024,1125,564,719],[510,510,10,10,5205],false],
['t111',1646,37,663,[1168,1178,664,729],[65,65,10,1,651],false],
['t112',1646,37,663,[1115,1178,565,719],[332,332,10,5,3398],false],
['t113',36,663,1865,[918,958,453,542],[198,198,10,3,1931],false],
['t114',36,663,1865,[866,907,453,542],[197,197,11,3,2148],false],
['t115',36,663,1865,[806,856,422,542],[235,235,11,8,2463],false],
['t116',36,663,1865,[791,855,202,406],[515,515,10,14,5336],false],
['t117',36,663,1865,[803,934,121,198],[278,278,10,7,2925],false],
['t118',37,31,1865,[1124,1165,455,531],[173,173,10,3,1721],false],
['t119',37,31,1865,[1072,1113,455,531],[173,173,10,3,1715],false],
['t121',37,1865,31,[968,1062,454,542],[352,352,11,7,3635],false],
['t122',37,31,1865,[1165,1186,419,531],[122,122,10,2,1265],false],
['t123',37,31,1865,[1133,1191,188,404],[525,525,10,16,5425],false],
['t124',37,31,1865,[1049,1184,116,173],[262,262,11,10,2648],false],
['t125',1072,1861,31,[1209,1269,447,534],[189,189,10,8,1992],false],
['t126',1072,1861,31,[1209,1272,184,457],[650,650,11,17,6763],false],
['t127',1072,1861,31,[1216,1340,121,170],[270,270,10,9,2708],false],
['t128',803,1862,31,[2040,2100,447,534],[190,190,10,8,2000],false],
['t129',803,1862,31,[2040,2103,184,457],[650,650,11,17,6763],false],
['t130',803,1862,31,[2046,2171,121,170],[271,271,10,9,2711],false],
['t131',807,31,1863,[1958,2018,447,534],[189,189,10,8,1991],false],
['t132',807,31,1863,[1955,2018,184,457],[650,650,11,17,6763],false],
['t133',807,31,1863,[1887,2012,121,170],[270,270,10,9,2702],false],
['t134',804,31,1864,[2789,2848,447,535],[189,189,10,8,1991],false],
['t135',804,31,1864,[2786,2849,184,457],[650,650,11,17,6763],false],
['t136',804,31,1864,[2718,2842,121,170],[270,270,10,9,2708],false],
['t137',1072,31,1861,[1281,1322,444,537],[200,200,10,7,2115],false],
['t138',803,31,1862,[2112,2153,444,537],[201,201,10,7,2125],false],
['t139',807,31,1863,[1905,1946,444,537],[200,200,10,7,2119],false],
['t140',804,31,1864,[2736,2777,444,537],[201,201,10,7,2125],false],
['t141',1072,31,1861,[1335,1375,444,537],[200,200,10,7,2115],false],
['t142',803,31,1862,[2165,2206,444,537],[201,201,10,7,2125],false],
['t143',807,31,1863,[1852,1893,444,537],[200,200,10,7,2119],false],
['t144',804,31,1864,[2682,2723,444,537],[201,201,10,7,2125],false],
['t145',1072,663,38,[1492,1535,588,718],[277,277,11,5,2913],false],
['t146',1072,31,1861,[1388,1428,444,537],[202,202,10,9,2104],false],
['t147',1072,38,663,[1429,1477,555,566],[48,48,11,1,529],false],
['t148',803,663,39,[2323,2365,589,718],[276,276,11,5,2900],false],
['t149',803,31,1862,[2218,2259,444,537],[203,203,10,9,2113],false],
['t150',803,39,663,[2260,2307,555,566],[48,48,11,1,531],false],
['t151',807,663,40,[1693,1735,589,718],[277,277,11,5,2911],false],
['t152',807,31,1863,[1799,1840,444,537],[203,203,10,9,2107],false],
['t153',807,40,663,[1753,1799,555,566],[46,46,11,1,506],false],
['t154',804,663,41,[2523,2566,589,718],[275,275,11,5,2894],false],
['t155',804,31,1864,[2629,2670,444,537],[203,203,10,9,2113],false],
['t156',804,41,663,[2583,2630,555,566],[47,47,11,1,519],false],
['t157',1646,663,38,[1537,1596,556,721],[301,301,10,7.5,3045],false],
['t158',1646,663,38,[1580,1591,664,720],[56,56,11,1,605],false],
['t159',1646,663,39,[2367,2427,556,721],[301,301,10,7,3054],false],
['t160',1646,663,39,[2411,2422,663,721],[58,58,11,1,624],false],
['t161',1646,663,40,[1631,1691,556,721],[301,301,10,7,3054],false],
['t162',1646,663,40,[1636,1647,664,721],[57,57,11,1,615],false],
['t163',1646,663,41,[2461,2521,556,721],[301,301,10,7,3051],false],
['t164',1646,663,41,[2467,2477,663,721],[58,58,11,1,624],false],
['t166',38,663,1861,[1495,1537,444,526],[180,180,10,7,1891],false],
['t167',38,663,1861,[1442,1483,444,534],[188,188,10,7.5,1980],false],
['t169',39,663,1862,[2325,2368,444,526],[180,180,10,7,1891],false],
['t170',39,663,1862,[2272,2314,444,534],[188,188,10,7,1983],false],
['t172',40,663,1863,[1690,1732,444,526],[180,180,10,7,1891],false],
['t173',40,663,1863,[1743,1785,444,534],[187,187,10,7,1978],false],
['t175',41,663,1864,[2520,2563,444,526],[180,180,10,7,1891],false],
['t176',41,663,1864,[2574,2615,444,534],[188,188,10,7,1981],false],
['t177',38,663,1861,[1549,1608,447,526],[181,181,10,8,1916],false],
['t178',38,663,1861,[1545,1608,185,457],[650,650,10,17,6608],false],
['t179',38,663,1861,[1478,1608,121,171],[280,280,10,9,2854],false],
['t180',39,663,1862,[2379,2438,447,526],[180,180,10,8,1914],false],
['t181',39,663,1862,[2376,2438,185,457],[650,650,10,17,6608],false],
['t182',39,663,1862,[2308,2438,121,171],[281,281,10,9,2860],false],
['t183',40,1863,663,[1619,1678,447,526],[182,182,10,8,1926],false],
['t184',40,1863,663,[1619,1681,185,457],[650,650,10,17,6608],false],
['t185',40,1863,663,[1619,1749,121,171],[281,281,10,9,2862],false],
['t186',41,1864,663,[2449,2508,447,526],[182,182,10,8,1929],false],
['t187',41,1864,663,[2449,2512,185,457],[650,650,10,17,6608],false],
['t188',41,1864,663,[2449,2579,121,171],[281,281,10,9,2865],false],
['t190',43,663,42,[1145,1155,891,977],[86,86,10,1,839],false],
['t191',43,663,42,[1142,1151,1006,1051],[45,45,10,1,435],false],
['t192',44,663,42,[1145,1155,1268,1354],[86,86,10,1,839],false],
['t193',44,663,42,[1142,1151,1383,1428],[45,45,10,1,435],false],
['t194',45,663,42,[1145,1155,1645,1731],[86,86,10,1,839],false],
['t195',45,663,42,[1142,1151,1760,1805],[45,45,10,1,435],false],
['t196',46,663,42,[1145,1155,2022,2108],[86,86,10,1,839],false],
['t197',46,663,42,[1142,1151,2137,2182],[45,45,10,1,435],false],
['t198',47,663,42,[1145,1155,1158,1244],[86,86,10,1,840],false],
['t199',47,663,42,[1142,1151,1084,1129],[44,44,10,1,432],false],
['t200',48,663,42,[1145,1155,1535,1621],[86,86,10,1,840],false],
['t201',48,663,42,[1142,1151,1461,1506],[44,44,10,1,434],false],
['t202',49,663,42,[1145,1155,1912,1998],[86,86,10,1,840],false],
['t203',49,663,42,[1142,1151,1838,1883],[44,44,10,1,432],false],
['t204',50,663,42,[1145,1155,2289,2375],[86,86,10,1,839],false],
['t205',50,663,42,[1142,1151,2215,2260],[45,45,10,1,434],false],
['t206',164,2675,663,[1093,1133,946,1055],[140,140,10,5,1425],false],
['t207',164,663,2676,[1093,1135,1079,1190],[142,142,10,5,1456],false],
['t208',164,2677,663,[1093,1134,1323,1432],[140,140,10,5,1458],false],
['t209',164,663,2678,[1093,1134,1456,1567],[142,142,10,5,1462],false],
['t210',164,2679,663,[1093,1134,1700,1809],[140,140,10,5,1480],false],
['t211',164,663,2680,[1093,1135,1833,1944],[142,142,11,5,1507],false],
['t212',164,663,2681,[1093,1134,2077,2186],[140,140,10,5,1490],false],
['t213',164,663,2682,[1093,1135,2210,2320],[141,141,10,5,1461],false],
['t222',53,2675,43,[1075,1086,1009,1055],[47,47,11,1,498],false],
['t223',53,2675,43,[1075,1112,933,980],[74,74,10,4,756],false],
['t224',34,2677,44,[1075,1086,1386,1432],[47,47,11,1,498],false],
['t225',34,2677,44,[1075,1112,1310,1357],[75,75,10,4,764],false],
['t226',65,2679,45,[1075,1086,1763,1809],[47,47,11,1,498],false],
['t227',65,2679,45,[1075,1112,1687,1734],[75,75,10,4,766],false],
['t228',71,2681,46,[1075,1086,2140,2186],[47,47,11,1,498],false],
['t229',71,2681,46,[1075,1112,2064,2111],[75,75,10,4,766],false],
['t230',56,2676,47,[1075,1086,1079,1126],[47,47,11,1,503],false],
['t231',56,2676,47,[1075,1112,1154,1204],[77,77,10,4,789],false],
['t232',62,2678,48,[1075,1086,1456,1503],[47,47,11,1,506],false],
['t233',62,2678,48,[1075,1112,1531,1581],[77,77,10,4,787],false],
['t234',68,2680,49,[1075,1086,1833,1880],[47,47,11,1,503],false],
['t235',68,2680,49,[1075,1112,1908,1958],[77,77,10,4,787],false],
['t236',74,2682,50,[1075,1086,2210,2257],[47,47,11,1,506],false],
['t237',74,2682,50,[1075,1112,2286,2335],[76,76,10,4,782],false],
['t238',163,43,2683,[1054,1065,932,1055],[124,124,11,1,1315],false],
['t239',163,47,2684,[1054,1065,1079,1203],[124,124,11,1,1324],false],
['t240',163,44,2685,[1054,1064,1309,1432],[123,123,10,1,1238],false],
['t241',163,48,2686,[1054,1064,1456,1580],[125,125,10,1,1252],false],
['t242',163,45,2687,[1054,1065,1686,1809],[123,123,11,1,1312],false],
['t243',163,49,2688,[1054,1065,1833,1957],[124,124,11,1,1324],false],
['t244',163,46,2689,[1054,1065,2063,2186],[123,123,10,1,1274],false],
['t245',163,50,2690,[1054,1065,2210,2333],[124,124,10,1,1279],false],
['t246',1662,2683,663,[1034,1047,932,968],[38,38,10,3,404],false],
['t247',1662,2683,663,[1009,1044,998,1055],[81,81,10,4,811],false],
['t251',1662,53,663,[969,995,893,973],[104,104,10,4,1073],false],
['t252',1662,53,663,[961,971,999,1048],[49,49,10,1,482],false],
['t253',1651,54,663,[921,965,947,1056],[143,143,10,5,1495],false],
['t254',1658,55,663,[847,864,889,1015],[131,131,10,7,1347],false],
['t255',1660,2684,663,[1034,1047,1166,1203],[38,38,10,3,405],false],
['t256',1660,2684,663,[1009,1044,1082,1137],[78,78,10,4,785],false],
['t260',1660,56,663,[969,995,1162,1245],[106,106,10,4,1103],false],
['t261',1660,56,663,[961,971,1086,1136],[49,49,10,1,484],false],
['t262',393,663,57,[921,965,1078,1188],[144,144,10,5,1510],false],
['t263',1656,58,663,[847,864,1119,1245],[131,131,10,7,1349],false],
['t264',1661,2685,663,[1034,1047,1309,1345],[37,37,10,3,401],false],
['t265',1661,2685,663,[1009,1044,1375,1432],[81,81,10,4,814],false],
['t269',1661,34,663,[969,995,1270,1350],[103,103,10,4,1071],false],
['t270',1661,34,663,[961,971,1376,1425],[49,49,10,1,485],false],
['t271',310,60,663,[921,965,1324,1433],[143,143,10,5,1501],false],
['t272',1657,61,663,[847,864,1266,1392],[131,131,10,7,1340],false],
['t273',1659,2686,663,[1034,1047,1544,1580],[38,38,10,3,405],false],
['t274',1659,2686,663,[1009,1044,1460,1514],[78,78,10,4,785],false],
['t278',1659,62,663,[969,995,1539,1622],[107,107,10,4,1103],false],
['t279',1659,62,663,[961,971,1464,1513],[49,49,10,1,484],false],
['t280',311,663,63,[921,965,1455,1565],[144,144,10,5,1513],false],
['t281',1655,64,663,[847,864,1496,1623],[132,132,10,7,1352],false],
['t282',1668,2687,663,[1034,1047,1686,1722],[37,37,10,3,401],false],
['t283',1668,2687,663,[1009,1044,1752,1809],[81,81,10,4,812],false],
['t287',1668,65,663,[969,995,1647,1727],[103,103,10,4,1073],false],
['t288',1668,65,663,[961,971,1753,1802],[49,49,10,1,485],false],
['t289',386,66,663,[921,965,1701,1810],[143,143,10,5,1501],false],
['t290',1667,67,663,[847,864,1644,1769],[131,131,10,7,1340],false],
['t291',1654,2688,663,[1034,1047,1921,1957],[38,38,10,3,405],false],
['t292',1654,2688,663,[1009,1044,1837,1891],[78,78,10,4,785],false],
['t296',1654,68,663,[969,995,1916,1999],[107,107,10,4,1104],false],
['t297',1654,68,663,[961,971,1840,1890],[49,49,10,1,484],false],
['t298',387,663,69,[921,965,1832,1942],[144,144,10,5,1510],false],
['t299',1653,70,663,[847,864,1873,2000],[131,131,10,7,1349],false],
['t300',1673,2689,663,[1034,1047,2063,2099],[37,37,10,3,401],false],
['t301',1673,2689,663,[1009,1044,2129,2186],[81,81,10,4,810],false],
['t305',1673,71,663,[969,995,2024,2104],[104,104,10,4,1075],false],
['t306',1673,71,663,[961,971,2130,2179],[49,49,10,1,485],false],
['t307',1593,72,663,[921,965,2078,2187],[143,143,10,5,1501],false],
['t308',1671,73,663,[847,864,2021,2146],[131,131,10,7,1340],false],
['t309',1672,2690,663,[1034,1047,2298,2333],[37,37,10,3,395],false],
['t310',1672,2690,663,[1009,1044,2213,2268],[78,78,10,4,789],false],
['t314',1672,74,663,[969,995,2293,2376],[106,106,10,4,1096],false],
['t315',1672,74,663,[961,971,2218,2267],[49,49,10,1,482],false],
['t316',610,75,663,[921,965,2209,2320],[145,145,10,5,1519],false],
['t317',1670,663,76,[847,864,2250,2377],[132,132,10,7,1354],false],
['t326',7,54,1662,[910,924,962,983],[21,21,14,1,299],false],
['t327',7,57,1660,[910,924,1152,1173],[21,21,13,1,279],false],
['t328',7,60,1661,[910,924,1339,1360],[21,21,14,1,293],false],
['t329',7,63,1659,[910,924,1529,1550],[21,21,13,1,276],false],
['t330',7,66,1668,[909,924,1716,1737],[21,21,14,1,296],false],
['t331',7,69,1654,[910,924,1906,1927],[21,21,13,1,279],false],
['t332',7,72,1673,[910,924,2093,2114],[21,21,14,1,285],false],
['t333',7,1672,75,[910,923,2283,2304],[21,21,14,1,286],false],
['t334',6,1662,55,[877,890,962,983],[21,21,13,1,277],false],
['t335',6,1660,58,[876,890,1152,1173],[21,21,13,1,278],false],
['t336',6,1661,61,[877,890,1339,1360],[21,21,13,1,266],false],
['t337',6,1659,64,[877,890,1529,1550],[21,21,13,1,270],false],
['t338',6,1668,67,[877,889,1716,1737],[21,21,12,1,260],false],
['t339',6,1654,70,[878,890,1906,1927],[21,21,12,1,261],false],
['t340',6,1673,73,[877,890,2093,2114],[21,21,13,1,272],false],
['t341',6,76,1672,[877,890,2283,2304],[21,21,13,1,276],false],
['t342',83,663,7,[1156,1192,2479,2717],[341,341,10,5,3530],false],
['t343',1511,663,7,[1087,1143,2479,2708],[293,293,10,4,3039],false],
['t344',1511,663,6,[1074,1118,2522,2721],[337,337,10,10,3272],false],
['t345',81,6,663,[964,1071,2506,2755],[345,345,10,5,3489],false],
['t348',1647,27,74,[718,754,2526,2539],[36,36,13,1,467],false],
['t349',1318,663,5,[1017,1031,2568,2827],[260,260,10,3,2800],false],
['t350',5,31,1646,[937,988,2547,2772],[302,302,10,4,3227],false],
['t352',5,31,1646,[937,947,2775,2811],[35,35,10,1,367],false],
['t353',5,31,1646,[937,947,2618,2758],[140,140,10,1,1443],false],
['t354',1318,1646,663,[844,864,2526,2823],[308,308,10,3,3156],false],
['t355',1318,1646,663,[906,916,2526,2823],[298,298,11,1,3169],false],
['t356',1318,663,1646,[875,886,2526,2823],[298,298,11,1,3170],false],
['t357',1083,10,663,[713,826,2884,2911],[129,129,11,3,1394],false],
['t358',770,768,663,[640,657,3054,3125],[74,74,11,3,799],false],
['t361',10,663,8,[668,678,3054,3254],[199,199,9,1,1886],false],
['t362',9,8,663,[686,704,3081,3290],[220,220,10,5,2308],false],
['t366',849,663,9,[711,727,3081,3164],[95,95,10,5,976],false],
['t367',1138,11,663,[754,775,3031,3105],[85,85,10,3,871],false],
['t368',1512,663,12,[782,795,3024,3185],[162,162,10,3,1642],false],
['t369',1139,12,2691,[806,822,2941,3274],[339,339,10,3,3406],false],
['t370',766,2691,663,[824,840,2941,3274],[338,338,10,3,3441],false],
['t371',94,663,77,[1497,1517,2491,2666],[190,190,11,5,1957],false],
['t374',712,663,80,[1354,1368,2590,2665],[77,77,10,3,806],false],
['t375',712,77,663,[1477,1488,2526,2688],[162,162,10,1,1679],false],
['t376',712,79,663,[1421,1435,2548,2616],[71,71,11,5,749],false],
['t377',79,1674,663,[1392,1443,2487,2590],[149,149,11,5,1770],false],
['t378',94,663,79,[1447,1467,2547,2620],[83,83,10,3,828],false],
['t380',80,2692,663,[1317,1328,2491,2691],[199,199,11,1,2180],false],
['t382',42,78,2692,[1280,1308,2503,2691],[205,205,10,2,2127],false],
['t383',85,663,78,[1267,1277,2573,2691],[118,118,10,1,1183],false],
['t384',1511,82,81,[1081,1111,2805,2818],[29,29,13,1,389],false],
['t385',1511,83,84,[1164,1193,2805,2818],[30,30,13,1,393],false],
['t386',1507,85,86,[1258,1273,2780,2793],[15,15,13,1,201],false],
['t387',94,31,1666,[1256,1267,1004,1019],[15,15,11,1,165],false],
['t388',94,1664,31,[1258,1268,1240,1254],[14,14,9,1,134],false],
['t389',94,1665,31,[1265,1280,1292,1303],[15,15,11,1,161],false],
['t390',94,31,1663,[1248,1258,1634,1648],[14,14,9,1,134],false],
['t391',94,1676,31,[1263,1278,1684,1695],[15,15,11,1,162],false],
['t392',94,1652,31,[1236,1246,1991,2006],[15,15,10,1,154],false],
['t393',94,1675,31,[1236,1246,2014,2030],[16,16,10,1,166],false],
['t394',94,1674,31,[1246,1256,2366,2380],[14,14,11,1,154],false],
['t395',88,1652,1676,[1266,1278,1926,1981],[56,56,12,1,657],false],
['t396',88,1652,1676,[1269,1281,1839,1896],[58,58,12,1,721],false],
['t397',90,1675,1652,[1266,1279,2019,2092],[74,74,12,1,892],false],
['t398',90,1675,1652,[1271,1283,2121,2158],[36,36,11,1,406],false],
['t399',89,1674,1675,[1271,1283,2213,2269],[56,56,12,1,698],false],
['t400',89,1674,1675,[1271,1283,2299,2352],[53,53,12,1,640],false],
['t401',92,1666,1664,[1249,1262,1085,1199],[115,115,11,3,1320],false],
['t402',91,1664,1665,[1235,1259,1316,1425],[121,121,12,2,1430],false],
['t403',93,1663,1665,[1235,1259,1483,1593],[122,122,12,2,1407],false],
['t404',77,1663,663,[1201,1249,1647,1780],[170,170,11,4,2021],false],
['t405',45,663,77,[1188,1197,1674,1707],[33,33,10,1,317],false],
['t406',45,663,77,[1188,1223,1735,1812],[128,128,10,5,1301],false],
['t407',49,663,88,[1205,1224,1887,1938],[60,60,10,2,590],false],
['t408',49,663,77,[1184,1224,1834,1938],[152,152,10,6,1604],false],
['t409',50,89,663,[1205,1224,2263,2315],[61,61,10,2,602],false],
['t410',50,663,77,[1184,1224,2210,2315],[154,154,10,6,1625],false],
['t411',46,90,663,[1205,1224,2083,2136],[62,62,10,2,610],false],
['t412',46,663,77,[1184,1224,2083,2189],[155,155,10,6,1634],false],
['t416',47,663,92,[1196,1206,1125,1176],[52,52,9,1,490],false],
['t419',44,91,663,[1202,1214,1339,1389],[52,52,9,3,502],false],
['t420',48,663,93,[1187,1200,1500,1551],[52,52,10,3,527],false],
['t422',1511,94,663,[1236,1248,787,861],[74,74,12,1,874],false],
['t423',251,663,95,[1428,1439,785,859],[74,74,11,1,807],false],
['t424',95,96,2693,[1448,1461,883,905],[23,23,13,1,298],false],
['t425',95,116,2694,[1448,1461,1229,1252],[23,23,13,1,298],false],
['t426',95,113,2695,[1448,1461,1260,1283],[23,23,13,1,294],false],
['t427',95,117,2696,[1446,1461,1606,1629],[23,23,14,1.5,303],false],
['t428',95,114,2697,[1448,1461,1637,1660],[23,23,13,1,297],false],
['t429',95,118,2698,[1447,1461,1983,2006],[23,23,13,1.5,294],false],
['t430',95,115,2699,[1448,1461,2014,2037],[23,23,13,1,290],false],
['t431',95,119,2700,[1447,1461,2360,2383],[23,23,14,1.5,304],false],
['t432',1511,2693,97,[1425,1438,883,905],[23,23,13,1,294],false],
['t433',1511,2694,101,[1424,1438,1229,1252],[23,23,13,1,302],false],
['t434',1511,2695,98,[1424,1438,1260,1283],[23,23,13,1,298],false],
['t435',1511,2696,102,[1425,1438,1606,1629],[23,23,13,1,301],false],
['t436',1511,2697,99,[1425,1438,1637,1660],[23,23,13,1,297],false],
['t437',1511,2698,103,[1424,1438,1983,2006],[23,23,13,1,306],false],
['t438',1511,2699,100,[1424,1438,2014,2037],[23,23,13,1,302],false],
['t439',1511,2700,104,[1425,1438,2360,2383],[23,23,13,1,299],false],
['t440',1666,2701,663,[1402,1415,944,1046],[104,104,10,3,1085],false],
['t441',1665,2702,663,[1402,1415,1321,1424],[104,104,10,3,1085],false],
['t442',1676,2703,663,[1402,1415,1698,1801],[104,104,10,3,1085],false],
['t443',1675,2704,663,[1402,1415,2075,2178],[104,104,10,3,1085],false],
['t444',1664,2705,663,[1402,1415,1088,1192],[105,105,10,3,1093],false],
['t445',1663,2706,663,[1402,1415,1466,1569],[105,105,10,3,1093],false],
['t446',1652,2707,663,[1402,1415,1843,1946],[105,105,10,3,1093],false],
['t447',1674,2708,663,[1402,1415,2220,2323],[105,105,10,3,1093],false],
['t448',53,2701,97,[1385,1395,1020,1046],[27,27,10,1,264],false],
['t449',53,2701,97,[1382,1395,919,994],[76,76,10,3,753],false],
['t450',34,2702,98,[1385,1395,1397,1424],[27,27,10,1,264],false],
['t451',34,2702,98,[1382,1395,1296,1371],[76,76,10,3,753],false],
['t452',65,2703,99,[1385,1395,1774,1801],[27,27,10,1,264],false],
['t453',65,2703,99,[1382,1395,1673,1748],[76,76,10,3,753],false],
['t454',71,2704,100,[1382,1395,2051,2125],[76,76,10,3,753],false],
['t455',71,2704,100,[1385,1395,2151,2178],[27,27,10,1,264],false],
['t456',56,2705,101,[1385,1395,1088,1115],[27,27,10,1,264],false],
['t457',56,2705,101,[1382,1395,1141,1217],[78,78,10,3,766],false],
['t458',62,2706,102,[1385,1395,1466,1492],[27,27,10,1,264],false],
['t459',62,2706,102,[1382,1395,1518,1594],[78,78,10,3,766],false],
['t460',68,2707,103,[1385,1395,1843,1869],[27,27,10,1,264],false],
['t461',68,2707,103,[1382,1395,1895,1971],[78,78,10,3,766],false],
['t462',74,2708,104,[1385,1395,2220,2246],[27,27,10,1,264],false],
['t463',74,2708,104,[1382,1395,2272,2349],[78,78,10,3,766],false],
['t473',105,97,663,[1359,1369,984,1035],[52,52,10,1,520],false],
['t475',106,98,663,[1359,1369,1361,1412],[52,52,10,1,520],false],
['t477',107,99,663,[1359,1369,1738,1790],[52,52,10,1,520],false],
['t479',108,663,100,[1359,1369,2115,2167],[52,52,10,1,520],false],
['t481',109,101,663,[1359,1369,1100,1151],[52,52,10,1,519],false],
['t483',110,102,663,[1359,1369,1477,1528],[52,52,10,1,519],false],
['t485',111,103,663,[1359,1369,1854,1906],[52,52,10,1,519],false],
['t487',112,104,663,[1359,1369,2231,2283],[52,52,10,1,519],false],
['t488',53,663,105,[1334,1348,984,1045],[63,63,10,3,653],false],
['t489',34,663,106,[1334,1348,1361,1422],[63,63,10,3,653],false],
['t490',65,663,107,[1334,1348,1738,1799],[63,63,10,3,653],false],
['t491',71,663,108,[1334,1348,2115,2176],[63,63,10,3,653],false],
['t492',56,663,109,[1334,1348,1090,1151],[62,62,10,3,653],false],
['t493',62,663,110,[1334,1348,1467,1528],[62,62,10,3,653],false],
['t494',68,663,111,[1334,1348,1844,1906],[62,62,10,3,653],false],
['t495',74,112,663,[1334,1348,2222,2283],[62,62,10,3,653],false],
['t496',1666,663,105,[1312,1326,985,1045],[62,62,10,3,625],false],
['t497',1665,663,106,[1312,1326,1362,1422],[62,62,10,3,624],false],
['t498',1676,663,107,[1312,1326,1739,1799],[62,62,10,3,624],false],
['t499',1675,663,108,[1312,1326,2116,2176],[62,62,10,3,624],false],
['t500',1664,663,109,[1312,1326,1090,1151],[63,63,10,3,634],false],
['t501',1663,663,110,[1312,1326,1467,1528],[63,63,10,3,634],false],
['t502',1652,663,111,[1312,1326,1844,1905],[63,63,10,3,634],false],
['t503',1674,112,663,[1312,1326,2222,2283],[63,63,10,3,634],false],
['t504',1511,120,121,[1555,1577,2804,2818],[23,23,14,1,323],false],
['t505',1511,122,701,[1628,1651,2804,2819],[23,23,15,1,331],false],
['t506',1511,123,124,[1658,1681,2804,2820],[23,23,15,1.5,336],false],
['t507',1511,125,126,[1731,1753,2804,2819],[22,22,15,1,322],false],
['t508',1511,127,128,[1775,1789,2805,2818],[14,14,13,1.5,187],false],
['t509',1511,130,129,[1827,1843,2805,2820],[16,16,15,1.5,214],false],
['t510',1511,131,132,[1873,1889,2805,2818],[16,16,14,1,215],false],
['t511',1511,663,139,[1684,1697,2515,2712],[202,202,10,5,2097],false],
['t512',1511,663,137,[1713,1726,2515,2712],[202,202,10,5,2097],false],
['t518',133,1647,663,[2002,2021,2519,2689],[178,178,11,3,1889],false],
['t519',1511,663,1647,[1967,1989,2514,2679],[171,171,16,4,1772],false],
['t520',1507,31,1647,[1986,2000,2710,2722],[14,14,12,1,165],false],
['t521',1507,133,663,[1933,1965,2621,2693],[124,124,10,3,1206],false],
['t522',1511,663,135,[1836,1850,2515,2618],[106,106,10,5,1121],false],
['t523',1511,663,134,[1881,1894,2515,2618],[105,105,10,5,1101],false],
['t527',1511,663,136,[1767,1778,2514,2618],[104,104,11,1,1104],false],
['t528',131,134,663,[1905,1918,2514,2618],[106,106,10,5,1091],false],
['t529',130,663,135,[1815,1828,2514,2618],[106,106,10,5.5,1105],false],
['t530',128,136,663,[1787,1803,2510,2620],[120,120,10,5,1210],false],
['t531',126,137,663,[1735,1749,2527,2768],[244,244,10,5,2392],false],
['t532',124,663,139,[1660,1675,2527,2768],[244,244,10,5,2595],false],
['t533',122,138,663,[1632,1648,2519,2767],[254,254,10,5,2579],false],
['t534',1511,140,663,[1581,1601,2469,2711],[253,253,10,4,2536],false],
['t535',1511,663,138,[1610,1624,2481,2711],[233,233,11,3,2584],false],
['t536',120,663,140,[1553,1568,2447,2735],[295,295,10,7,3108],false],
['t537',115,663,143,[1467,1497,2047,2188],[205,205,10,5,2066],false],
['t538',119,154,663,[1467,1497,2213,2350],[197,197,10,5,1984],false],
['t539',114,663,147,[1467,1497,1670,1811],[206,206,10,5,2067],false],
['t540',118,144,663,[1467,1497,1836,1973],[197,197,10,5,1983],false],
['t541',113,663,151,[1467,1497,1293,1434],[205,205,10,5,2064],false],
['t542',117,148,663,[1467,1497,1459,1596],[197,197,10,5,1986],false],
['t543',96,663,156,[1467,1497,916,1056],[205,205,10,5,2060],false],
['t544',116,152,663,[1467,1497,1082,1218],[197,197,10,5,1990],false],
['t545',1511,140,663,[1508,1523,785,858],[75,75,12,3,937],false],
['t546',1511,663,138,[1540,1554,785,858],[75,75,11,3,867],false],
['t547',138,142,144,[1546,1557,1926,1946],[20,20,12,1,235],false],
['t548',138,141,143,[1546,1557,2075,2095],[20,20,12,1,235],false],
['t549',140,1653,144,[1512,1534,1844,1945],[110,110,12,3,1347],false],
['t550',140,1671,143,[1513,1535,2076,2177],[111,111,12,3,1312],false],
['t553',138,146,148,[1546,1558,1549,1569],[20,20,12,1,241],false],
['t554',138,145,147,[1546,1557,1697,1718],[20,20,12,1,235],false],
['t555',140,1655,148,[1513,1535,1467,1567],[111,111,12,3,1309],false],
['t556',140,1667,147,[1512,1534,1699,1800],[111,111,12,3,1318],false],
['t559',138,150,152,[1546,1557,1172,1192],[20,20,11,1,233],false],
['t560',138,149,151,[1546,1558,1320,1341],[20,20,12,1,241],false],
['t561',140,1656,152,[1513,1535,1090,1190],[111,111,12,3,1312],false],
['t562',140,1657,151,[1512,1535,1322,1423],[112,112,12,3,1312],false],
['t565',138,153,154,[1546,1557,2303,2323],[20,20,12,1,235],false],
['t566',140,1670,154,[1512,1535,2221,2321],[111,111,12,3,1341],false],
['t568',138,155,156,[1546,1557,943,963],[20,20,11,1,233],false],
['t569',140,1658,156,[1512,1535,944,1045],[111,111,12,3,1295],false],
['t571',1511,137,663,[1695,1707,771,843],[72,72,12,1,878],false],
['t572',1511,663,139,[1662,1674,771,843],[72,72,12,1,879],false],
['t573',139,1658,1870,[1657,1680,950,1040],[101,101,12,2,1186],false],
['t574',139,1656,1874,[1657,1680,1096,1188],[103,103,12,2,1223],false],
['t575',139,1657,1871,[1657,1680,1328,1417],[100,100,12,2,1181],false],
['t576',139,1655,1875,[1657,1680,1472,1565],[104,104,12,2,1233],false],
['t577',139,1667,1872,[1657,1680,1705,1794],[100,100,12,2,1155],false],
['t578',139,1653,1876,[1657,1680,1849,1942],[103,103,12,2,1197],false],
['t579',139,1671,1873,[1656,1680,2082,2171],[101,101,12,2,1211],false],
['t580',139,1670,1877,[1656,1680,2226,2319],[104,104,12,2,1256],false],
['t582',31,155,1870,[1607,1645,891,927],[14,14,82,3,1162],true],
['t584',155,1774,663,[1576,1617,967,1001],[80,80,10,3,801],false],
['t585',149,663,1777,[1576,1617,1344,1378],[80,80,10,3,803],false],
['t586',145,1776,663,[1576,1617,1721,1755],[80,80,10,3,806],false],
['t587',141,1775,663,[1576,1617,2098,2132],[81,81,10,3,815],false],
['t588',150,663,1773,[1576,1617,1137,1167],[74,74,10,3,745],false],
['t589',146,1772,663,[1576,1617,1514,1544],[74,74,10,3,746],false],
['t590',142,1771,663,[1576,1617,1891,1921],[74,74,10,3,742],false],
['t591',153,1770,663,[1576,1617,2269,2298],[73,73,10,3,734],false],
['t592',1774,1870,663,[1575,1645,967,1057],[211,211,10,5,2221],false],
['t593',1777,663,1871,[1575,1645,1344,1434],[211,211,10,5,2224],false],
['t594',1776,663,1872,[1575,1645,1721,1811],[211,211,10,5,2224],false],
['t595',1775,663,1873,[1575,1645,2098,2188],[211,211,10,5,2224],false],
['t596',1773,1874,663,[1575,1645,1078,1167],[211,211,10,5,2222],false],
['t597',1772,1875,663,[1575,1645,1454,1544],[211,211,10,5,2222],false],
['t598',1771,1876,663,[1575,1645,1831,1921],[211,211,10,5,2222],false],
['t599',1770,1877,663,[1575,1645,2208,2298],[211,211,10,5,2222],false],
['t602',31,149,1871,[1607,1645,1269,1305],[14,14,83,3,1148],true],
['t605',31,150,1874,[1606,1645,1211,1245],[14,14,77,3,1113],true],
['t606',31,145,1872,[1607,1645,1645,1682],[14,14,82,3,1146],true],
['t609',31,146,1875,[1606,1645,1588,1621],[14,14,77,3,1114],true],
['t612',31,141,1873,[1607,1645,2022,2058],[14,14,82,3,1138],true],
['t615',31,142,1876,[1606,1645,1964,1998],[14,14,77,3,1123],true],
['t619',31,153,1877,[1606,1645,2342,2375],[14,14,75,3,1089],true],
['t621',136,610,663,[1727,1740,2248,2338],[89,89,12,1,1080],false],
['t622',137,1877,610,[1695,1715,2257,2355],[106,106,12,3,1261],false],
['t623',135,663,1593,[1728,1740,2095,2184],[88,88,12,1,1046],false],
['t624',137,1873,1593,[1695,1715,2042,2140],[106,106,12,3,1271],false],
['t625',134,387,663,[1728,1740,1871,1960],[88,88,12,1,1081],false],
['t626',137,1876,387,[1695,1715,1881,1978],[105,105,12,3,1267],false],
['t627',137,1875,311,[1695,1715,1504,1601],[105,105,12,3,1243],false],
['t628',137,1874,393,[1695,1715,1127,1224],[105,105,12,3,1237],false],
['t629',137,1872,386,[1695,1715,1664,1763],[106,106,12,3,1242],false],
['t630',137,1871,310,[1695,1715,1287,1386],[106,106,12,3,1240],false],
['t631',137,1870,1651,[1695,1716,910,1009],[107,107,12,3,1300],false],
['t632',1511,157,158,[2059,2082,2804,2820],[23,23,15,1.5,335],false],
['t633',1511,123,159,[2132,2155,2804,2819],[23,23,15,1,334],false],
['t634',159,663,161,[2136,2151,2528,2768],[245,245,10,5,2600],false],
['t635',158,663,162,[2061,2075,2527,2768],[246,246,10,5,2606],false],
['t636',1511,663,161,[2113,2127,2515,2713],[202,202,10,5,2100],false],
['t637',1511,663,162,[2084,2098,2515,2713],[202,202,10,5,2100],false],
['t640',166,663,163,[2229,2252,2492,2700],[221,221,10,5,2324],false],
['t643',163,164,663,[2208,2221,2489,2688],[199,199,11,3,2022],false],
['t644',1507,165,166,[2207,2227,2807,2821],[21,21,14,1,288],false],
['t645',1511,167,168,[3013,3035,2804,2819],[21,21,15,1.5,306],false],
['t646',1511,170,169,[3049,3071,2804,2819],[22,22,15,1,320],false],
['t647',168,663,171,[3017,3031,2527,2767],[245,245,10,5,2599],false],
['t648',453,663,172,[2914,2928,2527,2767],[245,245,10,5,2601],false],
['t649',451,663,173,[2811,2825,2527,2767],[245,245,10,5,2601],false],
['t650',449,663,174,[2707,2722,2527,2767],[245,245,10,5,2601],false],
['t651',447,663,175,[2604,2618,2527,2767],[245,245,10,5,2601],false],
['t652',446,177,663,[2942,2956,2527,2767],[245,245,10,5,2601],false],
['t653',440,178,663,[2838,2853,2527,2767],[245,245,10,5,2601],false],
['t654',444,179,663,[2735,2750,2527,2767],[245,245,10,5,2601],false],
['t655',441,180,663,[2632,2646,2527,2767],[245,245,10,5,2601],false],
['t656',442,181,663,[2529,2543,2527,2767],[245,245,10,5,2601],false],
['t657',1511,663,177,[2965,2979,2515,2714],[203,203,10,5,2112],false],
['t658',1511,663,171,[2994,3008,2515,2714],[203,203,10,5,2112],false],
['t659',1511,663,178,[2862,2875,2515,2714],[203,203,10,5,2112],false],
['t660',1511,663,172,[2891,2904,2515,2714],[203,203,10,5,2112],false],
['t661',1511,663,179,[2759,2772,2515,2714],[204,204,10,5,2116],false],
['t662',1511,663,173,[2787,2801,2515,2714],[204,204,10,5,2116],false],
['t663',1511,663,180,[2655,2669,2515,2714],[203,203,10,5,2115],false],
['t664',1511,663,174,[2684,2698,2515,2714],[203,203,10,5,2115],false],
['t665',1511,663,181,[2552,2566,2515,2714],[203,203,10,5,2115],false],
['t666',1511,663,175,[2581,2595,2515,2714],[203,203,10,5,2115],false],
['t677',1511,663,176,[2501,2520,2527,2735],[216,216,10,7,2236],false],
['t678',176,95,663,[2454,2583,2413,2727],[448,448,10,9,4651],false],
['t679',95,663,94,[2431,2446,2503,2711],[215,215,10,5,2130],false],
['t682',1511,94,663,[2405,2419,2516,2714],[199,199,11,3,2127],false],
['t685',94,663,184,[2374,2395,2506,2670],[173,173,11,3,1862],false],
['t686',78,663,185,[2331,2345,2555,2621],[67,67,10,3,685],false],
['t687',78,184,663,[2316,2363,2476,2621],[182,182,11,3,1963],false],
['t688',94,663,185,[2310,2321,2583,2650],[67,67,9,3,609],false],
['t690',185,186,663,[2287,2302,2476,2610],[136,136,11,3,1578],false],
['t691',1511,162,663,[1876,1888,764,836],[73,73,12,1,859],false],
['t692',1511,663,161,[1909,1921,764,836],[73,73,12,1,859],false],
['t693',1511,138,663,[2015,2027,787,861],[74,74,12,1,874],false],
['t694',1511,663,140,[2040,2059,775,849],[81,81,11,2,903],false],
['t695',251,663,95,[2105,2117,758,832],[75,75,12,1,930],false],
['t696',162,610,1878,[1840,1864,2289,2381],[105,105,12,3,1248],false],
['t697',162,387,1879,[1839,1863,1912,2004],[105,105,12,3,1224],false],
['t698',162,311,1880,[1839,1863,1534,1627],[104,104,12,3,1240],false],
['t699',162,393,1881,[1840,1863,1157,1250],[104,104,12,3,1233],false],
['t700',162,1593,1882,[1839,1863,2016,2109],[105,105,12,3,1240],false],
['t701',162,386,1883,[1840,1863,1639,1731],[104,104,12,3,1202],false],
['t702',162,310,1884,[1839,1863,1261,1354],[104,104,13,3,1293],false],
['t703',162,1651,1885,[1840,1863,885,977],[104,104,12,3,1260],false],
['t704',161,255,1885,[1857,1887,968,1057],[107,107,12,3,1265],false],
['t705',161,259,1881,[1857,1887,1078,1167],[107,107,12,3,1314],false],
['t706',161,256,1884,[1857,1886,1345,1435],[107,107,12,3,1244],false],
['t707',161,265,1880,[1857,1887,1455,1545],[107,107,12,3,1311],false],
['t708',161,257,1883,[1857,1887,1722,1812],[107,107,12,3,1251],false],
['t709',161,266,1879,[1857,1887,1832,1922],[107,107,12,3,1262],false],
['t710',161,258,1882,[1857,1887,2099,2189],[108,108,12,3,1250],false],
['t711',161,267,1878,[1857,1887,2209,2299],[107,107,12,3,1320],false],
['t713',31,190,1885,[1920,1957,891,929],[14,14,84,3,1174],true],
['t715',190,1778,663,[1933,1972,969,1005],[65,65,10,2,654],false],
['t716',191,1766,663,[1933,1972,1345,1382],[65,65,10,2,657],false],
['t717',192,1762,663,[1933,1972,1723,1758],[65,65,10,2,652],false],
['t718',193,1757,663,[1933,1972,2100,2135],[64,64,10,2,647],false],
['t719',194,1769,663,[1933,1971,1133,1166],[61,61,10,2,617],false],
['t720',195,1765,663,[1933,1971,1510,1543],[62,62,10,2,622],false],
['t721',196,1761,663,[1933,1971,1886,1921],[62,62,10,2,627],false],
['t722',197,1760,663,[1933,1971,2263,2298],[63,63,10,2,632],false],
['t723',1778,1885,663,[1880,1961,978,1057],[199,199,10,5,2067],false],
['t724',1766,1884,663,[1880,1961,1355,1435],[200,200,10,5,2069],false],
['t725',1762,1883,663,[1880,1961,1732,1812],[200,200,10,5,2069],false],
['t726',1757,1882,663,[1880,1961,2110,2189],[200,200,10,5,2069],false],
['t727',1769,663,1881,[1880,1961,1078,1157],[200,200,10,5,2072],false],
['t728',1765,663,1880,[1880,1961,1455,1535],[200,200,10,5,2072],false],
['t729',1761,663,1879,[1880,1961,1832,1912],[200,200,10,5,2072],false],
['t730',1760,663,1878,[1880,1961,2209,2289],[200,200,10,5,2073],false],
['t731',31,194,1881,[1920,1958,1210,1244],[15,15,79,3,1156],true],
['t732',31,191,1884,[1920,1957,1268,1305],[14,14,84,3,1185],true],
['t737',31,195,1880,[1920,1958,1586,1621],[15,15,80,3,1171],true],
['t738',31,192,1883,[1920,1957,1645,1682],[14,14,83,3,1171],true],
['t743',31,196,1879,[1920,1958,1963,1999],[15,15,81,3,1186],true],
['t744',31,193,1882,[1920,1957,2023,2059],[14,14,82,3,1156],true],
['t749',31,197,1878,[1920,1958,2340,2376],[15,15,82,3,1201],true],
['t752',140,267,198,[2003,2045,2221,2313],[122,122,12,4,1497],false],
['t753',138,197,198,[1999,2009,2297,2319],[21,21,10,1,221],false],
['t755',140,266,200,[2003,2045,1844,1936],[122,122,12,4,1494],false],
['t756',140,258,199,[2003,2045,2087,2176],[118,118,12,4,1416],false],
['t757',138,196,200,[1999,2009,1921,1942],[21,21,11,1,228],false],
['t758',138,193,199,[1999,2010,2078,2099],[21,21,11,1,241],false],
['t761',140,265,202,[2003,2045,1467,1559],[122,122,12,4,1487],false],
['t762',140,257,201,[2003,2045,1710,1799],[119,119,12,4,1448],false],
['t763',138,195,202,[1998,2009,1544,1565],[21,21,11,1,241],false],
['t764',138,192,201,[1998,2010,1701,1723],[21,21,12,1,247],false],
['t767',140,259,204,[2003,2045,1090,1182],[122,122,12,4,1460],false],
['t768',140,256,203,[2003,2045,1333,1422],[119,119,12,4,1397],false],
['t769',138,194,204,[1999,2010,1167,1188],[21,21,11,1,234],false],
['t770',138,191,203,[1999,2010,1324,1346],[21,21,11,1,235],false],
['t773',140,255,205,[2003,2045,957,1045],[119,119,12,4,1380],false],
['t774',138,190,205,[1999,2010,947,968],[21,21,11,1,234],false],
['t776',214,199,663,[2049,2080,2045,2188],[186,186,10,3,1899],false],
['t777',218,198,663,[2049,2080,2210,2353],[187,187,10,3,1912],false],
['t778',213,201,663,[2049,2080,1668,1812],[187,187,10,3,1909],false],
['t779',217,200,663,[2049,2080,1833,1976],[186,186,10,3,1902],false],
['t780',212,203,663,[2049,2080,1291,1435],[188,188,10,3,1919],false],
['t781',216,202,663,[2049,2080,1456,1598],[185,185,10,3,1892],false],
['t782',211,205,663,[2049,2080,914,1058],[189,189,10,3,1929],false],
['t783',215,204,663,[2049,2080,1080,1221],[184,184,10,3,1882],false],
['t787',242,1768,1779,[2289,2312,1096,1208],[124,124,12,2,1476],false],
['t788',243,1767,1768,[2289,2312,1297,1411],[125,125,12,2,1454],false],
['t789',245,1764,1767,[2290,2313,1487,1600],[124,124,12,2,1461],false],
['t790',249,184,663,[2329,2364,1706,1813],[149,149,10,6,1490],false],
['t791',184,663,1764,[2303,2338,1666,1804],[163,163,10,4,1773],false],
['t792',246,207,663,[2326,2343,1882,1932],[58,58,9,2,537],false],
['t793',246,184,663,[2324,2364,1833,1932],[150,150,11,6,1588],false],
['t794',247,206,663,[2326,2343,2260,2310],[57,57,9,2,532],false],
['t795',247,663,184,[2324,2364,2211,2310],[151,151,11,6,1592],false],
['t796',207,1759,1763,[2280,2302,1865,1974],[119,119,11,2,1353],false],
['t797',250,208,663,[2326,2345,2084,2139],[63,63,10,2,637],false],
['t798',250,663,184,[2325,2363,2084,2189],[156,156,10,6,1586],false],
['t799',208,1758,1759,[2280,2301,2055,2176],[139,139,11,4,1591],false],
['t800',206,186,1758,[2280,2301,2194,2304],[120,120,11,2,1334],false],
['t801',94,1779,31,[2281,2292,953,967],[14,14,11,1,153],false],
['t802',94,31,1768,[2272,2286,1234,1244],[14,14,10,1,147],false],
['t803',94,1767,31,[2272,2286,1275,1286],[14,14,11,1,159],false],
['t804',94,31,1764,[2287,2297,1658,1672],[14,14,10,1,147],false],
['t805',94,1763,31,[2271,2286,1695,1705],[15,15,10,1,151],false],
['t806',94,31,1759,[2289,2299,2002,2014],[12,12,10,1,121],false],
['t807',94,1758,31,[2272,2286,2032,2043],[15,15,11,1,159],false],
['t808',94,31,186,[2292,2307,2337,2347],[15,15,10,1,151],false],
['t809',95,211,2709,[2089,2103,883,905],[22,22,14,1,309],false],
['t810',95,215,2710,[2088,2103,1229,1252],[23,23,15,1,335],false],
['t811',95,212,2711,[2088,2103,1260,1282],[23,23,15,1,335],false],
['t812',95,216,2712,[2088,2103,1606,1629],[23,23,15,1,331],false],
['t813',95,213,2713,[2088,2103,1636,1659],[23,23,15,1,331],false],
['t814',95,217,2714,[2087,2103,1983,2005],[23,23,15,1,344],false],
['t815',95,214,2715,[2087,2103,2013,2036],[23,23,15,1,344],false],
['t816',95,218,2716,[2088,2103,2359,2383],[23,23,14,1,335],false],
['t825',1779,663,226,[2232,2246,974,1044],[72,72,10,3,735],false],
['t826',1767,663,227,[2232,2246,1351,1420],[72,72,10,3,735],false],
['t827',1763,663,228,[2232,2246,1728,1797],[72,72,10,3,735],false],
['t828',1758,663,229,[2232,2246,2104,2174],[72,72,10,3,736],false],
['t829',1768,663,230,[2232,2246,1092,1162],[72,72,10,3,740],false],
['t830',1764,663,231,[2232,2246,1469,1538],[72,72,10,3,740],false],
['t831',1759,663,232,[2232,2246,1845,1915],[72,72,10,3,740],false],
['t832',186,663,233,[2232,2246,2222,2292],[72,72,10,3,740],false],
['t833',252,663,226,[2211,2221,978,1044],[66,66,10,1,664],false],
['t834',238,663,227,[2211,2221,1355,1420],[66,66,10,1,664],false],
['t835',239,663,228,[2211,2221,1731,1797],[66,66,10,1,664],false],
['t836',240,663,229,[2211,2221,2108,2174],[66,66,10,1,664],false],
['t837',234,663,230,[2211,2221,1092,1158],[66,66,10,1,664],false],
['t838',235,663,231,[2211,2221,1469,1534],[66,66,10,1,664],false],
['t839',236,663,232,[2211,2221,1845,1911],[66,66,10,1,664],false],
['t840',237,663,233,[2211,2221,2222,2288],[66,66,10,1,664],false],
['t842',226,210,663,[2183,2194,952,1011],[59,59,11,1,631],false],
['t844',227,219,663,[2183,2194,1329,1388],[59,59,11,1,631],false],
['t846',228,220,663,[2183,2194,1706,1765],[59,59,11,1,631],false],
['t848',229,221,663,[2183,2194,2083,2141],[59,59,11,1,631],false],
['t850',230,222,663,[2183,2194,1124,1183],[59,59,11,1,631],false],
['t852',231,223,663,[2183,2194,1501,1560],[59,59,11,1,631],false],
['t854',232,224,663,[2183,2194,1878,1936],[59,59,11,1,631],false],
['t856',233,225,663,[2183,2194,2254,2313],[59,59,11,1,631],false],
['t857',252,210,2717,[2136,2165,912,957],[64,64,9,4,623],false],
['t858',252,210,2717,[2152,2182,983,1038],[76,76,11,4,788],false],
['t859',238,219,2718,[2136,2165,1288,1333],[64,64,9,4,624],false],
['t860',238,219,2718,[2152,2182,1359,1414],[75,75,11,4,785],false],
['t861',239,220,2719,[2136,2165,1665,1710],[64,64,9,4,622],false],
['t862',239,220,2719,[2152,2182,1736,1791],[75,75,11,4,787],false],
['t863',240,221,2720,[2136,2165,2042,2087],[64,64,9,4,618],false],
['t864',240,221,2720,[2152,2182,2113,2168],[76,76,11,4,791],false],
['t865',234,222,2721,[2136,2165,1179,1227],[67,67,9,4,652],false],
['t866',234,222,2721,[2152,2182,1100,1153],[73,73,11,4,759],false],
['t867',235,223,2722,[2136,2165,1556,1604],[67,67,10,4,666],false],
['t868',235,223,2722,[2152,2182,1477,1530],[73,73,11,4,762],false],
['t869',236,224,2723,[2136,2165,1932,1980],[67,67,9,4,656],false],
['t870',236,224,2723,[2152,2182,1854,1906],[73,73,11,4,760],false],
['t871',237,225,2724,[2136,2165,2309,2357],[68,68,9,4,660],false],
['t872',237,225,2724,[2152,2182,2231,2283],[72,72,11,4,756],false],
['t873',1779,2717,663,[2131,2187,972,1058],[132,132,10,2,1362],false],
['t874',1767,2718,663,[2131,2187,1350,1434],[131,131,10,2,1353],false],
['t875',1763,2719,663,[2131,2187,1726,1811],[131,131,10,2,1355],false],
['t876',1758,2720,663,[2131,2187,2103,2188],[131,131,10,2,1359],false],
['t877',1768,2721,663,[2131,2187,1080,1163],[128,128,10,2,1327],false],
['t878',1764,2722,663,[2131,2187,1457,1540],[128,128,10,2,1330],false],
['t879',1759,2723,663,[2131,2187,1834,1916],[128,128,10,2,1329],false],
['t880',186,2724,663,[2131,2187,2211,2293],[128,128,10,2,1324],false],
['t881',1511,2709,210,[2108,2122,883,905],[22,22,14,1,309],false],
['t882',1511,2710,222,[2108,2122,1229,1252],[23,23,14,1,326],false],
['t883',1511,2711,219,[2108,2122,1260,1282],[23,23,14,1,326],false],
['t884',1511,2712,223,[2108,2123,1606,1629],[23,23,15,1,335],false],
['t885',1511,2713,220,[2108,2123,1636,1659],[23,23,15,1,335],false],
['t886',1511,2714,224,[2108,2123,1983,2005],[23,23,15,1,332],false],
['t887',1511,2715,221,[2108,2123,2013,2036],[23,23,15,1,332],false],
['t888',1511,2716,225,[2108,2123,2359,2383],[23,23,14,1,337],false],
['t889',1511,663,94,[2236,2248,788,862],[74,74,12,1,869],false],
['t890',1511,663,251,[2355,2365,781,885],[104,104,10,1,1045],false],
['t893',1780,252,663,[2408,2418,979,1045],[67,67,9,1,632],false],
['t894',260,2725,663,[2470,2491,1078,1192],[126,126,9,3,1181],false],
['t895',260,234,663,[2499,2509,1132,1192],[60,60,10,1,603],false],
['t896',262,663,2726,[2470,2491,1455,1570],[126,126,9,3,1184],false],
['t897',262,663,235,[2500,2509,1509,1570],[60,60,10,1,575],false],
['t898',263,663,2727,[2470,2491,1832,1947],[126,126,9,3,1186],false],
['t899',263,663,236,[2500,2509,1886,1947],[60,60,10,1,575],false],
['t900',264,663,2728,[2470,2491,2209,2323],[126,126,9,3,1186],false],
['t901',264,237,663,[2500,2509,2263,2323],[61,61,10,1,580],false],
['t902',261,663,2729,[2470,2491,1319,1434],[127,127,9,3,1187],false],
['t903',261,238,663,[2499,2509,1319,1380],[60,60,10,1,606],false],
['t904',273,663,2730,[2470,2491,1697,1811],[126,126,9,3,1178],false],
['t905',273,239,663,[2500,2509,1697,1757],[60,60,10,1,574],false],
['t906',274,663,2731,[2470,2491,2074,2188],[126,126,9,3,1178],false],
['t907',274,240,663,[2500,2509,2074,2134],[60,60,10,1,577],false],
['t908',234,2732,663,[2405,2423,1078,1193],[121,121,11,2,1238],false],
['t909',235,2733,663,[2406,2423,1455,1570],[121,121,11,2,1234],false],
['t910',236,2734,663,[2405,2423,1832,1947],[121,121,11,2,1239],false],
['t911',237,2735,663,[2405,2423,2209,2324],[121,121,11,2,1239],false],
['t912',238,2736,663,[2405,2423,1323,1434],[118,118,11,2,1207],false],
['t913',239,663,2737,[2406,2423,1700,1811],[117,117,11,2,1195],false],
['t914',240,663,2738,[2406,2423,2077,2188],[117,117,11,2,1195],false],
['t915',241,663,242,[2341,2364,1125,1174],[61,61,10,2,633],false],
['t916',248,243,663,[2342,2364,1326,1379],[66,66,11,2.5,682],false],
['t917',244,663,245,[2342,2364,1513,1562],[61,61,10,2,638],false],
['t918',163,2725,241,[2451,2471,1078,1221],[152,152,10,3,1587],false],
['t919',163,2729,248,[2451,2471,1291,1434],[153,153,10,3,1543],false],
['t920',163,2726,244,[2451,2471,1455,1598],[153,153,10,3,1517],false],
['t921',163,2730,249,[2451,2471,1669,1811],[152,152,10,3,1516],false],
['t922',163,2727,246,[2451,2471,1832,1975],[153,153,10,3,1500],false],
['t923',163,2731,250,[2451,2471,2046,2188],[152,152,10,3,1579],false],
['t924',163,2728,247,[2451,2471,2209,2352],[153,153,11,3,1604],false],
['t925',164,248,2736,[2415,2443,1303,1434],[147,147,10,4,1553],false],
['t926',164,2732,241,[2415,2444,1078,1214],[151,151,11,4,1612],false],
['t927',164,244,2733,[2416,2443,1455,1590],[149,149,10,4,1589],false],
['t928',164,2737,249,[2416,2444,1680,1811],[147,147,10,4,1587],false],
['t929',164,246,2734,[2416,2444,1832,1967],[151,151,11,4,1651],false],
['t930',164,2738,250,[2416,2444,2057,2188],[146,146,11,4,1617],false],
['t931',164,247,2735,[2416,2444,2209,2344],[151,151,11,4,1645],false],
['t949',1511,663,176,[2488,2499,785,859],[73,73,12,1,868],false],
['t950',251,663,95,[2608,2621,764,838],[74,74,12,1,893],false],
['t951',1511,663,174,[2669,2680,788,861],[73,73,11,1,780],false],
['t952',174,284,610,[2640,2652,2298,2321],[23,23,11,1,258],false],
['t953',174,283,1593,[2640,2652,2076,2098],[22,22,11,1,249],false],
['t954',174,282,387,[2640,2651,1920,1943],[23,23,11,1,257],false],
['t955',174,281,386,[2640,2652,1699,1721],[22,22,11,1,255],false],
['t956',174,280,311,[2640,2652,1544,1567],[23,23,12,1,264],false],
['t957',174,279,310,[2640,2651,1322,1345],[22,22,11,1,236],false],
['t958',174,278,393,[2640,2652,1167,1190],[23,23,12,1,264],false],
['t959',174,254,1651,[2640,2651,946,968],[22,22,11,1,249],false],
['t960',95,610,31,[2617,2639,2298,2376],[91,91,10,3,936],false],
['t961',95,1670,31,[2617,2628,2217,2290],[73,73,11,1,779],false],
['t962',95,267,31,[2591,2607,2208,2290],[88,88,10,3,911],false],
['t963',95,258,31,[2591,2607,2107,2190],[88,88,10,3,894],false],
['t964',95,1671,31,[2617,2628,2106,2179],[74,74,11,1,783],false],
['t965',95,1593,31,[2617,2639,2020,2098],[90,90,10,3,928],false],
['t966',95,387,31,[2617,2639,1920,1999],[91,91,10,3,944],false],
['t967',95,1653,31,[2617,2628,1840,1913],[73,73,11,1,779],false],
['t968',95,266,31,[2591,2607,1830,1912],[88,88,10,3,912],false],
['t969',95,257,31,[2591,2607,1730,1813],[88,88,10,3,896],false],
['t970',95,1667,31,[2617,2628,1728,1802],[74,74,11,1,783],false],
['t971',95,386,31,[2617,2639,1643,1721],[90,90,10,3,940],false],
['t972',95,311,31,[2617,2639,1544,1622],[90,90,10,3,936],false],
['t973',95,1655,31,[2617,2628,1463,1536],[73,73,11,1,779],false],
['t974',95,265,31,[2591,2607,1453,1536],[88,88,10,3,919],false],
['t975',95,256,31,[2591,2607,1353,1435],[88,88,10,3,896],false],
['t976',95,1657,31,[2617,2628,1352,1425],[74,74,11,1,783],false],
['t977',95,310,31,[2617,2639,1266,1345],[90,90,10,3,953],false],
['t978',95,393,31,[2617,2639,1167,1246],[91,91,10,3,927],false],
['t979',95,1656,31,[2617,2628,1087,1160],[73,73,10,1,758],false],
['t980',95,259,31,[2591,2607,1077,1159],[88,88,10,3,919],false],
['t981',95,255,31,[2591,2607,976,1059],[88,88,10,3,896],false],
['t982',95,1658,31,[2617,2628,975,1049],[74,74,10,1,761],false],
['t983',95,1651,31,[2617,2639,890,968],[90,90,10,3,933],false],
['t984',255,268,663,[2544,2564,983,1055],[82,82,10,2,829],false],
['t985',256,269,663,[2544,2564,1361,1432],[81,81,10,2,815],false],
['t986',257,270,663,[2544,2564,1737,1808],[81,81,10,2,818],false],
['t987',258,271,663,[2544,2564,2115,2186],[80,80,10,2,811],false],
['t988',259,663,272,[2544,2564,1081,1156],[84,84,10,2,848],false],
['t989',265,663,275,[2544,2564,1458,1533],[85,85,10,2,862],false],
['t990',266,663,276,[2544,2564,1834,1910],[85,85,10,2,860],false],
['t991',267,663,277,[2544,2564,2212,2288],[86,86,10,2,867],false],
['t1000',176,1780,268,[2518,2532,968,992],[23,23,14,1,317],false],
['t1001',176,260,272,[2518,2532,1101,1124],[23,23,14,1,307],false],
['t1002',176,261,269,[2519,2532,1388,1411],[23,23,13,1,287],false],
['t1003',176,262,275,[2518,2532,1478,1500],[23,23,14,1,308],false],
['t1004',176,273,270,[2519,2532,1765,1788],[23,23,13,1,294],false],
['t1005',176,263,276,[2519,2532,1854,1877],[23,23,13,1,300],false],
['t1006',176,274,271,[2519,2533,2142,2165],[23,23,14,1,321],false],
['t1007',176,264,277,[2518,2533,2232,2254],[23,23,15,1,332],false],
['t1008',455,663,285,[3190,3205,2527,2768],[246,246,10,5,2605],false],
['t1009',423,663,286,[3116,3130,2528,2768],[245,245,10,5,2600],false],
['t1010',1511,663,285,[3168,3181,2515,2713],[202,202,10,5,2103],false],
['t1011',1511,663,286,[3139,3153,2515,2713],[202,202,10,5,2103],false],
['t1014',170,2739,663,[3087,3102,2440,2686],[249,249,10,5,2757],false],
['t1016',94,287,2739,[3070,3080,2440,2686],[246,246,10,1,2472],false],
['t1017',179,255,1886,[2747,2765,959,1058],[105,105,11,3,1205],false],
['t1018',179,259,1887,[2747,2765,1078,1176],[104,104,12,3,1205],false],
['t1019',179,256,1888,[2746,2765,1336,1435],[105,105,12,3,1266],false],
['t1020',179,265,1889,[2746,2765,1455,1553],[105,105,12,3,1312],false],
['t1021',179,257,1890,[2747,2765,1713,1812],[105,105,11,3,1205],false],
['t1022',179,266,1891,[2747,2765,1832,1931],[105,105,12,3,1216],false],
['t1023',179,258,1892,[2747,2765,2090,2189],[105,105,11,3,1191],false],
['t1024',179,267,1893,[2747,2765,2209,2308],[105,105,12,3,1207],false],
['t1026',31,254,1886,[2697,2735,891,928],[14,14,81,3,1167],true],
['t1028',1754,1886,663,[2673,2740,979,1063],[220,220,10,7,2326],false],
['t1029',254,1754,663,[2669,2710,975,1002],[69,69,10,3,719],false],
['t1030',1751,663,1887,[2673,2740,1075,1155],[220,220,10,7,2319],false],
['t1031',278,663,1751,[2669,2710,1136,1160],[63,63,10,3,650],false],
['t1032',31,278,1887,[2697,2735,1211,1244],[14,14,75,3,1066],true],
['t1035',31,279,1888,[2697,2735,1268,1305],[14,14,83,3,1143],true],
['t1038',1748,1888,663,[2673,2740,1356,1440],[221,221,10,7,2328],false],
['t1039',279,663,1748,[2669,2710,1352,1379],[70,70,10,3,721],false],
['t1040',1745,1889,663,[2673,2740,1453,1532],[220,220,10,7,2319],false],
['t1041',280,1745,663,[2669,2710,1514,1537],[63,63,10,3,649],false],
['t1043',31,280,1889,[2697,2735,1588,1621],[14,14,75,3,1065],true],
['t1046',31,281,1890,[2697,2735,1645,1682],[14,14,83,3,1144],true],
['t1048',1742,1890,663,[2673,2740,1733,1817],[221,221,10,7,2328],false],
['t1049',281,663,1742,[2669,2710,1730,1757],[70,70,10,3,722],false],
['t1050',1739,1891,663,[2673,2740,1830,1910],[220,220,10,7,2319],false],
['t1051',282,1739,663,[2669,2710,1891,1915],[63,63,10,3,649],false],
['t1053',31,282,1891,[2697,2735,1966,1998],[14,14,75,3,1064],true],
['t1056',31,283,1892,[2697,2735,2023,2059],[14,14,83,3,1145],true],
['t1058',1736,1892,663,[2673,2740,2111,2194],[221,221,10,7,2328],false],
['t1059',283,663,1736,[2669,2710,2107,2133],[68,68,10,3,708],false],
['t1060',1733,1893,663,[2673,2740,2206,2287],[220,220,10,7,2319],false],
['t1061',284,1733,663,[2669,2710,2267,2292],[64,64,10,3,662],false],
['t1063',31,284,1893,[2697,2735,2342,2375],[14,14,77,3,1084],true],
['t1065',175,1894,610,[2818,2830,2241,2329],[88,88,11,1,987],false],
['t1066',173,1893,610,[2788,2811,2226,2322],[108,108,11,5,1296],false],
['t1067',175,1895,387,[2818,2830,1864,1952],[88,88,12,1,1040],false],
['t1068',173,1891,387,[2788,2810,1849,1946],[108,108,12,5,1323],false],
['t1069',175,1896,311,[2818,2830,1487,1575],[88,88,12,1,1061],false],
['t1070',173,1889,311,[2788,2810,1472,1569],[108,108,12,5,1309],false],
['t1071',175,1897,393,[2817,2830,1110,1198],[88,88,12,1,1068],false],
['t1072',173,1887,393,[2788,2811,1095,1192],[108,108,11,5,1327],false],
['t1073',175,1898,1593,[2818,2830,2069,2157],[88,88,11,1,987],false],
['t1074',173,1892,1593,[2788,2810,2075,2171],[108,108,12,5,1304],false],
['t1075',175,1899,386,[2818,2830,1692,1780],[88,88,12,1,1040],false],
['t1076',173,1890,386,[2788,2810,1698,1795],[107,107,12,5,1335],false],
['t1077',175,1900,310,[2818,2830,1315,1403],[88,88,12,1,1061],false],
['t1078',173,1888,310,[2788,2810,1321,1418],[107,107,12,5,1297],false],
['t1079',175,1901,1651,[2817,2830,938,1026],[88,88,12,1,1068],false],
['t1080',173,1886,1651,[2788,2810,944,1041],[108,108,11,5,1295],false],
['t1081',31,288,1901,[2890,2928,891,928],[14,14,83,3,1182],true],
['t1084',178,1658,1901,[2853,2875,962,1060],[107,107,12,3,1263],false],
['t1085',178,1656,1897,[2853,2875,1075,1173],[109,109,12,3,1255],false],
['t1086',178,1657,1900,[2854,2875,1339,1437],[107,107,12,3,1267],false],
['t1087',178,1655,1896,[2854,2875,1452,1550],[108,108,12,3,1307],false],
['t1088',178,1667,1899,[2853,2874,1716,1813],[107,107,12,3,1254],false],
['t1089',178,1653,1895,[2853,2875,1828,1927],[109,109,12,3,1274],false],
['t1090',178,1671,1898,[2853,2875,2092,2191],[108,108,12,3,1305],false],
['t1091',178,1670,1894,[2853,2875,2205,2303],[108,108,12,3,1286],false],
['t1092',1755,1901,663,[2875,2950,986,1064],[215,215,11,7,2226],false],
['t1093',288,1755,663,[2921,2956,970,1003],[69,69,10,3,670],false],
['t1094',1752,663,1897,[2875,2950,1075,1150],[216,216,11,7,2238],false],
['t1095',289,663,1752,[2921,2956,1136,1166],[64,64,10,3,619],false],
['t1098',31,289,1897,[2890,2928,1211,1244],[15,15,75,3,1094],true],
['t1101',31,290,1900,[2891,2928,1268,1305],[14,14,82,3,1178],true],
['t1102',1749,663,1900,[2875,2950,1363,1441],[215,215,11,7,2226],false],
['t1103',290,1749,663,[2921,2956,1346,1380],[70,70,10,3,681],false],
['t1104',1746,1896,663,[2875,2950,1452,1527],[216,216,11,7,2238],false],
['t1105',291,1746,663,[2921,2956,1513,1543],[63,63,10,3,609],false],
['t1107',31,292,1899,[2891,2928,1645,1682],[14,14,83,3,1192],true],
['t1110',31,291,1896,[2890,2928,1588,1621],[15,15,74,3,1080],true],
['t1112',1743,1899,663,[2875,2950,1740,1818],[215,215,11,7,2226],false],
['t1113',292,663,1743,[2921,2956,1723,1757],[71,71,10,3,690],false],
['t1114',1740,1895,663,[2875,2950,1829,1903],[216,216,11,7,2238],false],
['t1115',293,1740,663,[2921,2956,1890,1919],[62,62,10,3,599],false],
['t1117',31,294,1898,[2891,2928,2022,2059],[14,14,84,3,1206],true],
['t1120',31,293,1895,[2890,2928,1966,1998],[15,15,73,3,1065],true],
['t1122',1737,1898,663,[2875,2950,2116,2195],[216,216,11,7,2231],false],
['t1123',294,663,1737,[2921,2956,2100,2134],[71,71,10,3,686],false],
['t1124',1734,1894,663,[2875,2950,2205,2280],[216,216,11,7,2233],false],
['t1125',295,1734,663,[2921,2956,2267,2296],[62,62,10,3,604],false],
['t1127',31,295,1894,[2890,2928,2342,2374],[15,15,74,3,1072],true],
['t1129',171,1670,295,[2999,3011,2266,2288],[22,22,12,1,262],false],
['t1130',177,295,610,[2979,2991,2337,2359],[21,21,12,1,246],false],
['t1131',171,1653,293,[2999,3011,1889,1911],[22,22,12,1,249],false],
['t1132',177,293,387,[2980,2991,1960,1981],[21,21,12,1,245],false],
['t1133',171,1655,291,[2999,3011,1512,1534],[22,22,12,1,255],false],
['t1134',177,291,311,[2980,2991,1583,1604],[21,21,11,1,233],false],
['t1135',171,1656,289,[2998,3011,1135,1156],[22,22,12,1,268],false],
['t1136',177,289,393,[2980,2991,1206,1227],[21,21,11,1,239],false],
['t1137',171,1671,294,[3000,3011,2111,2133],[22,22,12,1,256],false],
['t1138',177,294,1593,[2979,2992,2041,2062],[21,21,12,1,258],false],
['t1139',171,1667,292,[2999,3011,1734,1756],[22,22,12,1,256],false],
['t1140',177,292,386,[2980,2992,1663,1685],[21,21,12,1,251],false],
['t1141',171,1657,290,[2999,3011,1357,1378],[22,22,12,1,256],false],
['t1142',177,290,310,[2979,2992,1286,1307],[21,21,12,1,258],false],
['t1143',171,1658,288,[3000,3011,980,1001],[22,22,11,1,236],false],
['t1144',177,288,1651,[2980,2991,909,930],[21,21,12,1,245],false],
['t1145',180,610,303,[3041,3052,2337,2359],[22,22,11,1,249],false],
['t1146',171,267,303,[3022,3034,2229,2250],[21,21,12,1,246],false],
['t1147',180,387,301,[3041,3052,1960,1982],[22,22,11,1,242],false],
['t1148',171,266,301,[3022,3034,1852,1873],[21,21,12,1,252],false],
['t1149',180,311,299,[3040,3052,1583,1605],[22,22,12,1,269],false],
['t1150',171,265,299,[3022,3034,1474,1496],[21,21,12,1,258],false],
['t1151',180,393,297,[3040,3051,1205,1228],[22,22,11,1,243],false],
['t1152',171,259,297,[3022,3034,1097,1118],[21,21,12,1,252],false],
['t1153',180,1593,302,[3041,3052,2040,2062],[22,22,11,1,242],false],
['t1154',171,258,302,[3022,3034,2149,2170],[21,21,12,1,246],false],
['t1155',180,386,300,[3040,3052,1663,1685],[22,22,12,1,269],false],
['t1156',171,257,300,[3022,3034,1772,1793],[21,21,12,1,252],false],
['t1157',180,310,298,[3040,3051,1286,1308],[22,22,11,1,243],false],
['t1158',171,256,298,[3022,3034,1395,1416],[21,21,12,1,258],false],
['t1159',180,1651,296,[3040,3052,908,931],[22,22,12,1,271],false],
['t1160',171,255,296,[3022,3034,1018,1039],[21,21,12,1,252],false],
['t1161',286,255,1902,[3185,3196,965,1053],[88,88,12,1,1036],false],
['t1162',286,259,1903,[3185,3196,1083,1171],[88,88,12,1,1036],false],
['t1163',286,256,1904,[3185,3196,1342,1429],[88,88,11,1,984],false],
['t1164',286,265,1905,[3185,3196,1460,1547],[88,88,11,1,984],false],
['t1165',286,257,1906,[3185,3197,1718,1806],[88,88,12,1,1010],false],
['t1166',286,266,1907,[3185,3197,1836,1924],[88,88,12,1,1010],false],
['t1167',286,258,1908,[3185,3197,2095,2183],[88,88,12,1,1063],false],
['t1168',286,267,1909,[3185,3197,2213,2301],[88,88,12,1,1063],false],
['t1170',31,296,1902,[3134,3171,891,928],[14,14,82,3,1136],true],
['t1172',181,255,663,[3069,3091,965,1064],[109,109,13,3,1350],false],
['t1173',181,259,663,[3070,3091,1072,1171],[108,108,12,3,1261],false],
['t1174',181,256,663,[3069,3092,1341,1440],[109,109,12,3,1318],false],
['t1175',181,265,663,[3070,3092,1449,1548],[109,109,12,3,1320],false],
['t1176',181,257,663,[3069,3091,1718,1817],[109,109,12,3,1291],false],
['t1177',181,266,663,[3069,3091,1826,1924],[109,109,12,3,1280],false],
['t1178',181,258,663,[3069,3091,2095,2194],[109,109,13,3,1353],false],
['t1179',181,267,663,[3070,3091,2202,2301],[108,108,12,3,1252],false],
['t1180',1756,1902,663,[3108,3176,981,1061],[215,215,10,7,2276],false],
['t1181',296,1756,663,[3102,3139,968,1001],[69,69,10,3,715],false],
['t1182',1753,663,1903,[3108,3176,1077,1154],[215,215,10,7,2267],false],
['t1183',297,663,1753,[3102,3139,1138,1168],[65,65,10,3,665],false],
['t1184',31,297,1903,[3134,3171,1211,1245],[14,14,75,3,1083],true],
['t1187',31,298,1904,[3134,3171,1269,1305],[14,14,82,3,1168],true],
['t1190',1750,663,1904,[3108,3176,1359,1438],[214,214,10,7,2270],false],
['t1191',298,1750,663,[3102,3139,1345,1378],[69,69,10,3,714],false],
['t1192',1747,1905,663,[3108,3176,1454,1531],[215,215,10,7,2266],false],
['t1193',299,1747,663,[3102,3139,1515,1545],[64,64,10,3,655],false],
['t1195',31,299,1905,[3134,3171,1589,1622],[14,14,74,3,1069],true],
['t1198',31,300,1906,[3134,3171,1645,1682],[14,14,83,3,1182],true],
['t1200',1744,1906,663,[3108,3176,1735,1816],[214,214,10,7,2270],false],
['t1201',300,663,1744,[3102,3139,1722,1755],[70,70,10,3,724],false],
['t1202',1741,1907,663,[3108,3176,1832,1907],[215,215,10,7,2265],false],
['t1203',301,1741,663,[3102,3139,1892,1921],[63,63,10,3,645],false],
['t1205',31,301,1907,[3134,3171,1966,1998],[14,14,73,3,1054],true],
['t1208',31,302,1908,[3134,3171,2022,2060],[14,14,84,3,1197],true],
['t1210',1738,1908,663,[3108,3176,2112,2192],[214,214,10,7,2270],false],
['t1211',302,663,1738,[3102,3139,2099,2132],[70,70,10,3,719],false],
['t1212',1735,1909,663,[3108,3176,2208,2284],[215,215,10,7,2266],false],
['t1213',303,1735,663,[3102,3139,2269,2298],[63,63,10,3,649],false],
['t1215',31,303,1909,[3134,3171,2342,2375],[14,14,74,3,1061],true],
['t1217',1511,179,663,[2733,2744,764,837],[73,73,11,1,818],false],
['t1218',1511,663,173,[2764,2776,764,837],[73,73,12,1,841],false],
['t1219',1511,175,663,[2827,2838,765,837],[73,73,11,1,818],false],
['t1220',1511,663,178,[2858,2870,765,837],[73,73,12,1,841],false],
['t1221',1511,177,663,[2959,2970,767,840],[73,73,11,1,818],false],
['t1222',1511,663,171,[2991,3002,767,840],[73,73,12,1,841],false],
['t1223',1511,180,663,[3054,3065,767,840],[73,73,11,1,818],false],
['t1224',1511,663,181,[3085,3097,767,840],[73,73,12,1,841],false],
['t1225',1511,286,663,[3171,3183,765,838],[73,73,11,1,818],false],
['t1226',1511,663,172,[3203,3215,765,838],[73,73,12,1,841],false],
['t1227',287,663,309,[3272,3294,2514,2616],[125,125,10,5,1262],false],
['t1228',287,663,308,[3302,3312,2514,2616],[102,102,10,1,1025],false],
['t1229',785,663,308,[3320,3340,2514,2627],[127,127,10,5,1313],false],
['t1230',1007,663,309,[3253,3264,2514,2618],[103,103,11,1,1134],false],
['t1233',308,310,663,[3282,3293,1430,1521],[91,91,12,1,1078],false],
['t1234',309,663,311,[3255,3270,1462,1552],[91,91,11,3,1067],false],
['t1235',172,1905,311,[3229,3242,1462,1551],[89,89,12,1,1087],false],
['t1236',172,1909,610,[3229,3241,2217,2305],[89,89,12,1,1080],false],
['t1237',172,1907,387,[3229,3241,1839,1928],[89,89,12,1,1080],false],
['t1238',172,1903,393,[3230,3242,1086,1174],[89,89,12,1,1051],false],
['t1239',172,1904,310,[3229,3242,1339,1427],[88,88,12,1,1072],false],
['t1240',172,1908,1593,[3229,3241,2093,2181],[88,88,12,1,1072],false],
['t1241',172,1906,386,[3229,3241,1716,1804],[88,88,12,1,1072],false],
['t1242',172,1902,1651,[3230,3242,962,1050],[88,88,12,1,1042],false],
['t1243',1124,663,321,[4181,4202,2474,2583],[119,119,11,3,1279],false],
['t1244',467,314,663,[4127,4142,2527,2768],[246,246,10,5,2606],false],
['t1245',465,315,663,[4024,4039,2528,2768],[245,245,10,5,2603],false],
['t1246',439,316,663,[3921,3935,2528,2768],[245,245,10,5,2603],false],
['t1247',463,317,663,[3818,3832,2528,2768],[245,245,10,5,2603],false],
['t1248',461,318,663,[3715,3730,2528,2768],[245,245,10,5,2603],false],
['t1249',419,319,663,[3612,3626,2528,2768],[245,245,10,5,2603],false],
['t1250',459,320,663,[3508,3523,2528,2768],[245,245,10,5,2603],false],
['t1251',457,329,663,[3405,3420,2528,2768],[245,245,10,5,2603],false],
['t1252',433,663,322,[4052,4067,2528,2768],[245,245,10,5,2603],false],
['t1253',431,663,323,[3949,3964,2528,2768],[245,245,10,5,2603],false],
['t1254',420,663,324,[3846,3861,2528,2768],[245,245,10,5,2603],false],
['t1255',429,663,325,[3743,3757,2528,2768],[245,245,10,5,2603],false],
['t1256',427,663,326,[3640,3655,2528,2768],[245,245,10,5,2603],false],
['t1257',422,663,327,[3537,3551,2528,2768],[245,245,10,5,2603],false],
['t1258',425,663,328,[3434,3448,2528,2768],[245,245,10,5,2603],false],
['t1259',1511,663,322,[4076,4089,2515,2714],[203,203,10,5,2112],false],
['t1260',1511,663,314,[4105,4118,2515,2714],[203,203,10,5,2112],false],
['t1261',1511,663,323,[3973,3986,2515,2714],[203,203,10,5,2115],false],
['t1262',1511,663,315,[4002,4015,2515,2714],[203,203,10,5,2115],false],
['t1263',1511,663,324,[3870,3883,2514,2714],[204,204,10,5,2119],false],
['t1264',1511,663,316,[3898,3912,2514,2714],[204,204,10,5,2119],false],
['t1265',1511,663,325,[3766,3780,2515,2714],[203,203,10,5,2113],false],
['t1266',1511,663,317,[3795,3809,2515,2714],[203,203,10,5,2113],false],
['t1267',1511,663,326,[3664,3677,2515,2714],[203,203,10,5,2112],false],
['t1268',1511,663,318,[3693,3706,2515,2714],[203,203,10,5,2112],false],
['t1269',1511,663,327,[3560,3574,2515,2714],[203,203,10,5,2115],false],
['t1270',1511,663,319,[3589,3603,2515,2714],[203,203,10,5,2115],false],
['t1271',1511,663,328,[3457,3471,2515,2714],[203,203,10,5,2113],false],
['t1272',1511,663,320,[3486,3500,2515,2714],[203,203,10,5,2113],false],
['t1289',287,663,321,[4160,4169,2512,2614],[102,102,10,1,1005],false],
['t1290',1511,663,329,[3383,3397,2515,2714],[202,202,10,5,2181],false],
['t1291',1511,663,285,[3411,3447,782,844],[85,85,12,4,1040],false],
['t1292',1511,329,663,[3361,3393,781,844],[83,83,12,2,1007],false],
['t1293',1511,328,663,[3526,3540,771,844],[74,74,12,3,870],false],
['t1294',1511,327,663,[3473,3508,782,838],[80,80,11,2,908],false],
['t1295',1511,663,326,[3604,3640,765,836],[93,93,12,4,1116],false],
['t1296',1511,319,663,[3575,3589,784,853],[70,70,11,3,817],false],
['t1297',1511,329,663,[3653,3666,785,855],[71,71,11,3.5,808],false],
['t1298',1511,663,320,[3687,3698,767,839],[72,72,11,1,811],false],
['t1299',1511,317,663,[3741,3770,777,839],[79,79,12,2,957],false],
['t1300',1511,663,322,[3789,3804,766,839],[75,75,12,3,897],false],
['t1301',1511,318,663,[3862,3890,773,845],[100,100,11,4,1073],false],
['t1302',1511,324,663,[3844,3855,786,858],[72,72,12,1,831],false],
['t1303',1511,663,315,[4005,4016,785,856],[71,71,11,1,774],false],
['t1304',1511,323,663,[3935,3993,785,843],[104,104,12,5,1232],false],
['t1305',285,610,365,[3385,3397,2318,2339],[22,22,12,1,249],false],
['t1306',329,365,267,[3373,3385,2224,2246],[22,22,12,1,260],false],
['t1308',285,1593,364,[3385,3397,2059,2080],[22,22,12,1,261],false],
['t1309',285,387,363,[3385,3397,1941,1962],[22,22,12,1,261],false],
['t1310',329,364,258,[3373,3385,2152,2174],[22,22,12,1,260],false],
['t1311',329,363,266,[3373,3385,1847,1869],[22,22,12,1,265],false],
['t1314',285,311,361,[3385,3397,1564,1585],[22,22,12,1,255],false],
['t1315',285,386,362,[3385,3397,1682,1704],[22,22,12,1,255],false],
['t1316',329,361,265,[3373,3385,1470,1492],[22,22,12,1,261],false],
['t1317',329,362,257,[3373,3385,1775,1797],[22,22,12,1,265],false],
['t1320',285,310,360,[3385,3397,1305,1326],[22,22,12,1,255],false],
['t1321',285,393,359,[3385,3397,1186,1208],[22,22,12,1,255],false],
['t1322',329,360,256,[3373,3385,1398,1420],[22,22,12,1,261],false],
['t1323',329,359,259,[3373,3384,1093,1115],[22,22,11,1,246],false],
['t1326',285,1651,358,[3385,3397,928,949],[22,22,12,1,255],false],
['t1327',329,358,255,[3373,3384,1021,1043],[22,22,11,1,246],false],
['t1329',320,373,610,[3647,3659,2336,2358],[22,22,12,1,256],false],
['t1330',329,1670,373,[3621,3633,2300,2321],[22,22,12,1,253],false],
['t1331',326,1683,1670,[3598,3610,2240,2361],[122,122,12,1,1472],false],
['t1332',319,1910,1683,[3566,3589,2264,2361],[109,109,12,5,1311],false],
['t1333',328,610,1910,[3545,3568,2264,2361],[107,107,12,3,1265],false],
['t1334',320,371,387,[3647,3659,1959,1981],[22,22,12,1,256],false],
['t1335',329,1653,371,[3620,3633,1922,1944],[22,22,12,1,261],false],
['t1336',326,1689,1653,[3598,3610,1862,1984],[122,122,12,1,1472],false],
['t1337',319,1911,1689,[3566,3589,1887,1984],[109,109,12,5,1311],false],
['t1338',328,387,1911,[3545,3567,1887,1984],[107,107,11,3,1244],false],
['t1339',320,369,311,[3647,3659,1582,1604],[22,22,12,1,256],false],
['t1340',329,1655,369,[3621,3633,1545,1567],[22,22,12,1,249],false],
['t1341',326,1694,1655,[3598,3610,1485,1607],[122,122,12,1,1472],false],
['t1342',319,1912,1694,[3566,3589,1510,1607],[109,109,12,5,1311],false],
['t1343',328,311,1912,[3545,3568,1510,1607],[108,108,12,3,1276],false],
['t1344',320,367,393,[3647,3659,1205,1227],[22,22,12,1,255],false],
['t1345',329,1656,367,[3621,3633,1168,1190],[22,22,12,1,249],false],
['t1346',326,1698,1656,[3598,3610,1108,1230],[122,122,12,1,1472],false],
['t1347',319,1913,1698,[3566,3589,1133,1230],[109,109,12,5,1311],false],
['t1348',328,393,1913,[3545,3567,1133,1230],[107,107,11,3,1231],false],
['t1349',320,372,1593,[3647,3659,2040,2062],[22,22,12,1,256],false],
['t1350',329,1671,372,[3620,3633,2077,2098],[22,22,12,1,261],false],
['t1351',326,1682,1671,[3598,3610,2037,2159],[122,122,12,1,1478],false],
['t1352',319,1914,1682,[3566,3589,2037,2134],[109,109,12,5,1290],false],
['t1353',328,1593,1914,[3545,3567,2037,2134],[107,107,11,3,1225],false],
['t1354',320,370,386,[3647,3659,1662,1684],[22,22,12,1,256],false],
['t1355',329,1667,370,[3621,3633,1700,1721],[22,22,12,1,249],false],
['t1356',326,1687,1667,[3598,3610,1660,1782],[122,122,12,1,1478],false],
['t1357',319,1915,1687,[3566,3589,1660,1756],[109,109,12,5,1290],false],
['t1358',328,386,1915,[3545,3568,1660,1756],[107,107,12,3,1273],false],
['t1359',320,368,310,[3647,3659,1285,1308],[22,22,12,1,255],false],
['t1360',329,1657,368,[3621,3633,1323,1344],[22,22,12,1,249],false],
['t1361',326,1693,1657,[3598,3610,1283,1405],[122,122,12,1,1478],false],
['t1362',319,1916,1693,[3566,3589,1283,1379],[109,109,12,5,1290],false],
['t1363',328,310,1916,[3545,3567,1283,1379],[107,107,11,3,1225],false],
['t1364',320,366,1651,[3647,3659,908,931],[22,22,12,1,262],false],
['t1365',329,1658,366,[3620,3632,946,967],[22,22,12,1,249],false],
['t1366',326,1697,1658,[3598,3610,906,1028],[122,122,12,1,1478],false],
['t1367',319,1917,1697,[3566,3589,906,1002],[109,109,12,5,1276],false],
['t1368',328,1651,1917,[3545,3568,906,1002],[107,107,12,3,1278],false],
['t1369',324,1919,610,[3835,3853,2257,2355],[104,104,12,3,1249],false],
['t1370',322,610,1918,[3807,3825,2257,2355],[104,104,12,3,1249],false],
['t1371',324,1921,387,[3835,3853,1880,1978],[104,104,12,3,1207],false],
['t1372',322,387,1920,[3807,3825,1880,1978],[104,104,12,3,1207],false],
['t1373',324,1923,311,[3835,3853,1503,1601],[104,104,12,3,1218],false],
['t1374',322,311,1922,[3807,3825,1503,1601],[104,104,12,3,1218],false],
['t1375',324,1925,393,[3835,3853,1127,1224],[104,104,12,3,1214],false],
['t1376',322,393,1924,[3807,3825,1127,1224],[104,104,12,3,1214],false],
['t1377',324,1927,1593,[3835,3853,2042,2140],[104,104,12,3,1242],false],
['t1378',322,1593,1926,[3807,3825,2042,2140],[104,104,12,3,1242],false],
['t1379',324,1929,386,[3835,3853,1665,1763],[104,104,12,3,1208],false],
['t1380',322,386,1928,[3807,3825,1665,1763],[104,104,12,3,1208],false],
['t1381',324,1931,310,[3835,3853,1288,1386],[103,103,12,3,1233],false],
['t1382',322,310,1930,[3807,3825,1288,1386],[103,103,12,3,1233],false],
['t1383',324,1933,1651,[3835,3853,912,1009],[103,103,12,3,1194],false],
['t1384',322,1651,1932,[3807,3825,912,1009],[104,104,12,3,1210],false],
['t1385',315,610,342,[4025,4038,2326,2348],[22,22,12,1,272],false],
['t1386',323,343,610,[3992,4005,2326,2348],[22,22,12,1,272],false],
['t1387',315,387,344,[4025,4037,1949,1971],[22,22,12,1,268],false],
['t1388',323,345,387,[3993,4005,1949,1971],[22,22,12,1,268],false],
['t1389',315,311,346,[4025,4038,1572,1594],[22,22,12,1,271],false],
['t1390',323,347,311,[3992,4005,1572,1594],[22,22,12,1,271],false],
['t1391',315,393,348,[4025,4037,1195,1217],[22,22,12,1,264],false],
['t1392',323,349,393,[3993,4005,1195,1217],[22,22,12,1,264],false],
['t1393',315,1593,350,[4025,4037,2050,2072],[22,22,12,1,268],false],
['t1394',323,351,1593,[3993,4005,2050,2072],[22,22,12,1,268],false],
['t1395',315,386,352,[4025,4038,1673,1695],[22,22,12,1,271],false],
['t1396',323,353,386,[3992,4005,1673,1695],[22,22,12,1,271],false],
['t1397',315,310,354,[4025,4037,1296,1318],[22,22,12,1,264],false],
['t1398',323,355,310,[3993,4005,1296,1318],[22,22,12,1,264],false],
['t1399',315,1651,356,[4025,4037,919,941],[22,22,12,1,255],false],
['t1400',323,357,1651,[3993,4005,919,941],[22,22,12,1,255],false],
['t1402',31,358,1917,[3452,3490,891,928],[14,14,83,3,1185],true],
['t1404',1781,1917,663,[3427,3499,967,1056],[206,206,10,5,2095],false],
['t1405',358,1781,663,[3421,3463,967,999],[74,74,10,3,739],false],
['t1408',31,359,1913,[3453,3490,1211,1245],[14,14,75,3,1074],true],
['t1411',31,360,1916,[3452,3490,1268,1304],[14,14,83,3,1196],true],
['t1412',1729,663,1913,[3427,3499,1079,1167],[205,205,10,5,2087],false],
['t1413',359,1729,663,[3421,3463,1140,1167],[66,66,10,3,664],false],
['t1414',1725,1916,663,[3427,3499,1345,1433],[206,206,10,5,2096],false],
['t1415',360,663,1725,[3421,3463,1345,1376],[73,73,10,3,731],false],
['t1417',31,362,1915,[3452,3490,1645,1681],[14,14,82,3,1182],true],
['t1420',31,361,1912,[3453,3490,1588,1622],[14,14,76,3,1088],true],
['t1422',1721,1912,663,[3427,3499,1457,1544],[205,205,10,5,2087],false],
['t1423',361,1721,663,[3421,3463,1516,1544],[67,67,10,3,674],false],
['t1424',1715,663,1915,[3427,3499,1722,1811],[206,206,10,5,2096],false],
['t1425',362,1715,663,[3421,3463,1722,1754],[73,73,10,3,731],false],
['t1427',31,364,1914,[3452,3490,2023,2059],[14,14,82,3,1181],true],
['t1430',31,363,1911,[3453,3490,1965,1999],[14,14,76,3,1088],true],
['t1432',1707,1911,663,[3427,3499,1834,1922],[205,205,10,5,2087],false],
['t1433',363,1707,663,[3421,3463,1894,1922],[67,67,10,3,674],false],
['t1434',1714,663,1914,[3427,3499,2099,2188],[206,206,10,5,2096],false],
['t1435',364,1714,663,[3421,3463,2099,2131],[72,72,10,3,724],false],
['t1437',31,365,1910,[3453,3490,2343,2377],[14,14,76,3,1097],true],
['t1439',1706,1910,663,[3427,3499,2211,2299],[205,205,10,5,2087],false],
['t1440',365,1706,663,[3421,3463,2271,2299],[68,68,10,3,681],false],
['t1441',327,255,1917,[3509,3520,968,1056],[88,88,11,1,990],false],
['t1442',327,259,1913,[3509,3520,1079,1167],[88,88,11,1,990],false],
['t1443',327,256,1916,[3508,3520,1345,1433],[88,88,12,1,1015],false],
['t1444',327,265,1912,[3508,3520,1457,1545],[88,88,12,1,1015],false],
['t1445',327,257,1915,[3508,3520,1723,1811],[88,88,12,1,1042],false],
['t1446',327,266,1911,[3508,3520,1834,1922],[88,88,12,1,1042],false],
['t1447',327,258,1914,[3509,3521,2100,2188],[88,88,12,1,1094],false],
['t1448',327,267,1910,[3509,3521,2211,2299],[88,88,12,1,1094],false],
['t1449',317,1697,1932,[3768,3780,968,1057],[88,88,12,1,1093],false],
['t1450',317,1698,1924,[3768,3780,1080,1168],[88,88,12,1,1093],false],
['t1451',317,1693,1930,[3768,3780,1346,1434],[88,88,12,1,1042],false],
['t1452',317,1694,1922,[3768,3780,1457,1545],[88,88,12,1,1042],false],
['t1453',317,1687,1928,[3768,3780,1723,1811],[88,88,12,1,1069],false],
['t1454',317,1689,1920,[3768,3780,1834,1922],[88,88,12,1,1069],false],
['t1455',317,1682,1926,[3768,3780,2100,2188],[88,88,12,1,1068],false],
['t1456',317,1683,1918,[3768,3780,2211,2299],[88,88,12,1,1068],false],
['t1458',31,366,1932,[3711,3749,891,928],[14,14,82,3,1171],true],
['t1460',1782,1932,663,[3687,3759,968,1057],[206,206,10,5,2095],false],
['t1461',366,1782,663,[3680,3722,974,1005],[73,73,10,3,728],false],
['t1464',31,367,1924,[3712,3749,1211,1245],[14,14,76,3,1088],true],
['t1467',31,368,1930,[3711,3749,1268,1304],[14,14,82,3,1182],true],
['t1468',1730,663,1924,[3687,3759,1080,1167],[205,205,10,5,2087],false],
['t1469',367,1730,663,[3680,3722,1134,1162],[67,67,10,3,671],false],
['t1470',1726,1930,663,[3687,3759,1345,1434],[206,206,10,5,2094],false],
['t1471',368,1726,663,[3680,3722,1351,1382],[72,72,10,3,725],false],
['t1473',31,370,1928,[3711,3749,1645,1681],[14,14,81,3,1174],true],
['t1476',31,369,1922,[3712,3749,1588,1622],[14,14,76,3,1095],true],
['t1478',1722,1922,663,[3687,3759,1457,1545],[205,205,10,5,2087],false],
['t1479',369,1722,663,[3680,3722,1511,1539],[68,68,10,3,677],false],
['t1480',1717,663,1928,[3687,3759,1722,1811],[206,206,10,5,2094],false],
['t1481',370,1717,663,[3680,3722,1728,1759],[73,73,10,3,729],false],
['t1483',31,372,1926,[3711,3749,2023,2059],[14,14,81,3,1179],true],
['t1486',31,371,1920,[3712,3749,1965,2000],[14,14,76,3,1090],true],
['t1488',1709,1920,663,[3687,3759,1834,1922],[205,205,10,5,2087],false],
['t1489',371,1709,663,[3680,3722,1888,1917],[67,67,10,3,673],false],
['t1490',1716,663,1926,[3687,3759,2100,2188],[206,206,10,5,2094],false],
['t1491',372,1716,663,[3680,3722,2105,2136],[73,73,10,3,727],false],
['t1493',31,373,1918,[3712,3749,2343,2376],[14,14,75,3,1073],true],
['t1495',1708,1918,663,[3687,3759,2211,2298],[205,205,10,5,2080],false],
['t1496',373,1708,663,[3680,3722,2265,2293],[67,67,10,3,668],false],
['t1497',318,1683,1919,[3881,3893,2212,2300],[88,88,12,1,1065],false],
['t1498',318,1682,1927,[3881,3893,2101,2188],[87,87,12,1,1059],false],
['t1499',318,1689,1921,[3881,3893,1834,1922],[88,88,12,1,1069],false],
['t1500',318,1687,1929,[3881,3893,1723,1811],[88,88,12,1,1069],false],
['t1501',318,1694,1923,[3881,3893,1457,1545],[88,88,12,1,1042],false],
['t1502',318,1693,1931,[3881,3893,1346,1434],[88,88,12,1,1042],false],
['t1503',318,1698,1925,[3881,3893,1080,1168],[88,88,12,1,1093],false],
['t1504',318,1697,1933,[3881,3893,968,1057],[88,88,12,1,1093],false],
['t1506',31,357,1933,[3915,3952,891,928],[14,14,82,3,1178],true],
['t1508',357,663,1732,[3940,3975,962,1002],[66,66,10,2,651],false],
['t1509',1732,1933,663,[3901,3974,968,1057],[206,206,10,5,2095],false],
['t1510',31,355,1931,[3915,3953,1268,1304],[14,14,82,3,1182],true],
['t1511',31,349,1925,[3915,3952,1211,1245],[14,14,76,3,1088],true],
['t1516',349,1728,663,[3940,3975,1136,1175],[64,64,10,2,628],false],
['t1517',1728,1925,663,[3901,3974,1080,1167],[205,205,10,5,2087],false],
['t1518',355,1724,663,[3940,3975,1339,1379],[66,66,10,2,645],false],
['t1519',1724,663,1931,[3901,3974,1345,1434],[206,206,10,5,2096],false],
['t1520',31,353,1929,[3915,3953,1646,1681],[14,14,81,3,1168],true],
['t1521',31,347,1923,[3915,3952,1588,1623],[14,14,77,3,1101],true],
['t1526',347,1720,663,[3940,3975,1513,1552],[64,64,10,2,632],false],
['t1527',1720,1923,663,[3901,3974,1457,1545],[205,205,10,5,2087],false],
['t1528',353,1713,663,[3940,3975,1717,1757],[66,66,10,2,645],false],
['t1529',1713,663,1929,[3901,3974,1723,1811],[206,206,10,5,2096],false],
['t1530',31,351,1927,[3915,3953,2023,2059],[14,14,81,3,1167],true],
['t1531',31,345,1921,[3915,3952,1965,2000],[14,14,77,3,1101],true],
['t1536',345,1705,663,[3940,3975,1891,1930],[64,64,10,2,632],false],
['t1537',1705,1921,663,[3901,3974,1834,1922],[205,205,10,5,2087],false],
['t1538',351,1712,663,[3940,3975,2094,2134],[65,65,10,2,642],false],
['t1539',1712,663,1927,[3901,3974,2100,2188],[206,206,10,5,2089],false],
['t1541',31,343,1919,[3915,3952,2343,2375],[14,14,75,3,1056],true],
['t1543',343,1704,663,[3940,3975,2268,2306],[64,64,10,2,628],false],
['t1544',1704,1919,663,[3901,3974,2212,2299],[205,205,10,5,2078],false],
['t1545',314,610,1934,[4138,4150,2212,2300],[88,88,12,1,1016],false],
['t1546',314,1593,1688,[4138,4150,2101,2189],[88,88,12,1,1016],false],
['t1547',314,387,1700,[4138,4149,1834,1922],[88,88,11,1,999],false],
['t1548',314,386,1699,[4138,4149,1723,1811],[88,88,11,1,999],false],
['t1549',314,311,1701,[4138,4149,1457,1545],[88,88,11,1,990],false],
['t1550',314,310,1702,[4138,4149,1346,1434],[88,88,11,1,990],false],
['t1551',314,393,1703,[4138,4149,1080,1168],[88,88,11,1,991],false],
['t1552',314,1651,1784,[4138,4149,968,1057],[88,88,11,1,991],false],
['t1554',31,356,1784,[4080,4118,891,928],[14,14,82,3,1178],true],
['t1556',356,1783,663,[4057,4090,962,1002],[64,64,10,2,623],false],
['t1557',1783,1784,663,[4056,4128,968,1057],[206,206,10,5,2095],false],
['t1558',31,354,1702,[4080,4118,1268,1304],[14,14,82,3,1182],true],
['t1559',31,348,1703,[4081,4118,1211,1245],[14,14,76,3,1088],true],
['t1564',348,663,1731,[4057,4090,1136,1175],[62,62,10,2,605],false],
['t1565',1731,1703,663,[4056,4128,1080,1167],[205,205,10,5,2087],false],
['t1566',354,1727,663,[4057,4090,1339,1379],[63,63,10,2,618],false],
['t1567',1727,1702,663,[4056,4128,1345,1434],[206,206,10,5,2096],false],
['t1568',31,352,1699,[4080,4118,1646,1681],[14,14,81,3,1168],true],
['t1569',31,346,1701,[4081,4118,1588,1623],[14,14,77,3,1101],true],
['t1574',346,663,1723,[4057,4090,1513,1552],[62,62,10,2,610],false],
['t1575',1723,1701,663,[4056,4128,1457,1545],[205,205,10,5,2087],false],
['t1576',352,1719,663,[4057,4090,1717,1757],[63,63,10,2,617],false],
['t1577',1719,1699,663,[4056,4128,1723,1811],[206,206,10,5,2096],false],
['t1578',31,350,1688,[4080,4118,2023,2059],[14,14,81,3,1167],true],
['t1579',31,344,1700,[4081,4118,1965,2000],[14,14,77,3,1101],true],
['t1584',344,663,1711,[4057,4090,1891,1930],[62,62,10,2,610],false],
['t1585',1711,1700,663,[4056,4128,1834,1922],[205,205,10,5,2087],false],
['t1586',350,1718,663,[4057,4090,2094,2134],[63,63,10,2,615],false],
['t1587',1718,1688,663,[4056,4128,2100,2189],[206,206,10,5,2096],false],
['t1588',31,342,1934,[4080,4118,2343,2375],[14,14,75,3,1056],true],
['t1591',342,663,1710,[4057,4090,2268,2306],[62,62,10,2,606],false],
['t1592',1710,1934,663,[4056,4128,2212,2299],[205,205,10,5,2078],false],
['t1593',1511,314,663,[4120,4134,783,857],[75,75,12,3,881],false],
['t1594',1511,663,374,[4073,4104,762,854],[112,112,10,4,1124],false],
['t1597',287,663,375,[4249,4271,2496,2601],[117,117,10,3,1190],false],
['t1598',1026,663,375,[4240,4278,2644,2732],[131,131,10,5,1365],false],
['t1599',287,663,376,[4296,4315,2510,2621],[127,127,10,5,1338],false],
['t1600',1005,663,376,[4302,4316,2662,2764],[104,104,11,3,1134],false],
['t1602',1511,316,663,[4211,4225,784,859],[76,76,12,3,931],false],
['t1603',1511,325,663,[4182,4196,784,858],[75,75,12,3,930],false],
['t1604',374,478,663,[4317,4329,909,983],[74,74,12,1,923],false],
['t1605',384,2740,379,[4317,4327,1009,1112],[103,103,10,1,1002],false],
['t1607',380,663,2740,[4298,4308,1009,1112],[103,103,10,1,1030],false],
['t1609',1160,384,663,[4319,4347,1322,1359],[55,55,10,2,562],false],
['t1610',1703,2741,663,[4282,4300,1240,1318],[85,85,11,2,943],false],
['t1611',1702,2741,663,[4284,4295,1352,1426],[73,73,10,1,759],false],
['t1614',1784,380,2741,[4253,4264,1061,1172],[111,111,11,1,1213],false],
['t1616',385,2742,2741,[4252,4262,1287,1367],[80,80,10,1,803],false],
['t1617',385,2742,2741,[4252,4263,1396,1426],[30,30,10,1,309],false],
['t1618',383,2743,381,[4275,4286,1500,1603],[103,103,11,1,1095],false],
['t1620',382,663,385,[4256,4297,1468,1491],[54,54,10,2,539],false],
['t1621',382,663,2743,[4256,4267,1500,1603],[103,103,11,1,1092],false],
['t1623',1699,382,2744,[4249,4259,1746,1819],[73,73,9,1,691],false],
['t1624',785,383,663,[4283,4327,1723,1734],[44,44,11,1,482],false],
['t1625',376,386,663,[4299,4311,1779,1865],[86,86,12,1,998],false],
['t1626',375,387,663,[4262,4274,1950,2039],[88,88,12,1,1098],false],
['t1627',1701,663,2742,[4231,4242,1303,1413],[110,110,11,1,1235],false],
['t1628',1700,2744,663,[4253,4264,1839,1913],[73,73,10,1,760],false],
['t1629',1688,663,2744,[4225,4238,1850,1924],[75,75,10,3,778],false],
['t1630',316,1693,663,[4192,4216,1343,1438],[107,107,12,3,1307],false],
['t1631',316,1694,663,[4192,4217,1452,1548],[108,108,12,3,1332],false],
['t1632',316,1687,663,[4192,4217,1720,1815],[107,107,13,3,1340],false],
['t1633',316,1689,663,[4192,4216,1829,1924],[107,107,12,3,1302],false],
['t1634',325,1702,1693,[4183,4195,1277,1366],[88,88,12,1,1045],false],
['t1635',325,1701,1694,[4183,4195,1526,1613],[87,87,12,1,1034],false],
['t1636',325,1699,1687,[4183,4195,1654,1743],[88,88,12,1,1048],false],
['t1637',325,1700,1689,[4182,4195,1903,1991],[87,87,12,1,1083],false],
['t1638',321,663,1593,[4227,4242,2119,2207],[89,89,12,3,1052],false],
['t1639',316,1683,663,[4192,4217,2206,2301],[108,108,12,3,1316],false],
['t1640',316,1682,663,[4192,4216,2097,2191],[107,107,12,3,1307],false],
['t1641',325,1934,1683,[4183,4195,2280,2367],[87,87,12,1,1057],false],
['t1642',325,1688,1682,[4182,4195,2031,2119],[88,88,12,1,1097],false],
['t1643',316,1698,663,[4192,4216,1075,1170],[107,107,12,3,1313],false],
['t1644',316,663,1697,[4192,4216,966,1060],[107,107,12,3,1262],false],
['t1645',325,1703,1698,[4183,4195,1149,1236],[87,87,12,1,1032],false],
['t1646',325,1697,1784,[4182,4194,900,988],[88,88,12,1,1045],false],
['t1648',1511,388,391,[5658,5680,462,475],[22,22,13,1,278],false],
['t1649',389,663,392,[5643,5678,399,423],[49,49,10,2,477],false],
['t1651',392,391,31,[5700,5714,431,446],[15,15,14,1,202],false],
['t1652',1511,663,392,[5654,5684,356,367],[29,29,11,1,312],false],
['t1654',391,663,389,[5628,5694,253,321],[226,226,10,6,2349],false],
['t1655',531,393,389,[5641,5730,229,242],[89,89,13,1,1136],false],
['t1656',983,390,393,[5697,5733,202,216],[36,36,13,1,489],false],
['t1657',664,663,388,[5595,5664,420,508],[145,145,11,3,1638],false],
['t1659',395,663,396,[5643,5678,663,682],[45,45,10,2,440],false],
['t1660',396,398,31,[5700,5714,642,656],[14,14,14,1,189],false],
['t1662',1511,663,396,[5654,5684,718,729],[30,30,11,1,324],false],
['t1664',398,663,395,[5628,5694,764,830],[222,222,10,6,2305],false],
['t1665',531,395,310,[5641,5731,843,856],[89,89,13,1.5,1131],false],
['t1666',1511,394,398,[5657,5678,609,623],[21,21,14,1,292],false],
['t1667',983,397,310,[5697,5734,869,882],[37,37,13,1,491],false],
['t1668',670,663,394,[5609,5751,566,586],[150,150,12,3,1806],false],
['t1671',1511,404,407,[5657,5678,1284,1297],[21,21,13,1,267],false],
['t1672',1511,403,399,[5657,5678,1402,1414],[21,21,13,1,267],false],
['t1673',405,663,408,[5643,5678,1221,1245],[48,48,10,2,476],false],
['t1674',400,663,401,[5643,5678,1455,1475],[45,45,10,2,446],false],
['t1676',408,407,31,[5700,5714,1254,1268],[14,14,14,1,191],false],
['t1677',401,31,403,[5700,5714,1427,1443],[15,15,14,1,209],false],
['t1679',1511,663,408,[5654,5684,1178,1189],[30,30,11,1,318],false],
['t1680',1511,663,401,[5654,5684,1510,1521],[30,30,11,1,318],false],
['t1683',407,663,405,[5628,5694,1075,1143],[226,226,10,6,2346],false],
['t1684',403,663,400,[5628,5694,1556,1622],[223,223,10,6,2311],false],
['t1685',531,405,311,[5641,5730,1051,1064],[89,89,13,1,1132],false],
['t1686',531,386,400,[5641,5731,1635,1648],[90,90,13,1.5,1140],false],
['t1687',983,406,311,[5697,5734,1024,1038],[37,37,13,1,492],false],
['t1688',983,402,386,[5697,5734,1661,1674],[36,36,13,1,482],false],
['t1689',676,399,663,[5625,5757,1355,1391],[157,157,11,5,1831],false],
['t1690',669,663,404,[5625,5757,1308,1345],[158,158,12,5,1868],false],
['t1691',413,663,584,[5497,5515,1368,1490],[129,129,12,2,1524],false],
['t1694',1690,663,413,[5495,5508,1801,1896],[96,96,10,3,976],false],
['t1696',584,663,414,[5510,5534,2076,2168],[106,106,10,2,1072],false],
['t1697',478,1697,31,[4368,4385,974,1057],[88,88,10,3,891],false],
['t1698',478,1698,31,[4369,4385,1068,1159],[104,104,10,5,1047],false],
['t1699',478,1693,31,[4368,4386,1344,1436],[104,104,11,5.5,1029],false],
['t1700',478,1694,31,[4362,4384,1452,1530],[102,102,10,5,1045],false],
['t1701',478,1687,31,[4368,4385,1721,1811],[103,103,10,5,1074],false],
['t1702',478,1689,31,[4368,4385,1822,1913],[104,104,9,5,1020],false],
['t1703',478,1682,31,[4369,4387,2098,2188],[104,104,11,5.5,1029],false],
['t1704',478,1683,31,[4369,4385,2231,2322],[103,103,10,5,1079],false],
['t1705',470,663,415,[4569,4584,2528,2768],[245,245,10,5,2600],false],
['t1706',469,416,663,[4466,4480,2528,2768],[245,245,10,5,2603],false],
['t1707',437,663,417,[4494,4508,2528,2768],[245,245,10,5,2603],false],
['t1708',435,663,418,[4391,4405,2527,2768],[246,246,10,5,2606],false],
['t1709',1511,663,415,[4546,4560,2515,2714],[203,203,10,5,2112],false],
['t1710',1511,663,417,[4517,4531,2515,2714],[203,203,10,5,2112],false],
['t1711',1511,663,416,[4443,4457,2515,2714],[204,204,10,5,2116],false],
['t1712',1511,663,418,[4414,4428,2515,2714],[204,204,10,5,2116],false],
['t1717',1511,419,757,[3608,3629,2804,2819],[21,21,15,1,312],false],
['t1718',1511,420,760,[3845,3866,2804,2820],[22,22,15,1.5,313],false],
['t1719',1511,422,421,[3535,3557,2804,2819],[21,21,15,1.5,308],false],
['t1720',1511,423,745,[3114,3135,2804,2820],[21,21,15,1.5,309],false],
['t1721',1511,425,424,[3432,3454,2804,2820],[22,22,15,1.5,309],false],
['t1722',1511,427,426,[3638,3659,2804,2820],[22,22,15,1.5,309],false],
['t1723',1511,429,428,[3741,3762,2804,2819],[21,21,15,1.5,308],false],
['t1724',1511,431,430,[3948,3969,2804,2819],[21,21,15,1.5,308],false],
['t1725',1511,433,432,[4051,4072,2804,2820],[22,22,15,1.5,309],false],
['t1726',1511,435,434,[4390,4411,2804,2820],[21,21,15,1.5,326],false],
['t1727',1511,437,436,[4493,4514,2804,2820],[21,21,15,1.5,317],false],
['t1728',1511,439,438,[3917,3939,2804,2819],[21,21,15,1,308],false],
['t1729',1511,440,745,[2837,2859,2804,2820],[22,22,15,1.5,316],false],
['t1730',1511,441,739,[2631,2653,2804,2820],[22,22,15,1.5,316],false],
['t1731',1511,442,979,[2528,2549,2804,2820],[22,22,15,1.5,310],false],
['t1732',1511,444,443,[2734,2755,2804,2820],[22,22,15,1.5,309],false],
['t1733',1511,446,445,[2940,2962,2804,2820],[21,21,15,1.5,309],false],
['t1734',1511,447,738,[2601,2622,2804,2819],[21,21,15,1,308],false],
['t1735',1511,449,448,[2704,2725,2804,2819],[21,21,15,1,308],false],
['t1736',1511,451,450,[2807,2829,2804,2819],[21,21,15,1,308],false],
['t1737',1511,453,452,[2910,2931,2804,2819],[21,21,15,1,308],false],
['t1738',1511,455,454,[3187,3208,2804,2819],[21,21,15,1,308],false],
['t1739',1511,457,456,[3402,3423,2804,2819],[21,21,15,1,308],false],
['t1740',1511,459,458,[3505,3526,2804,2819],[21,21,15,1,308],false],
['t1741',1511,461,460,[3711,3732,2804,2819],[21,21,15,1,308],false],
['t1742',1511,463,462,[3814,3835,2804,2819],[21,21,15,1,308],false],
['t1743',1511,465,464,[4021,4042,2804,2819],[21,21,15,1,308],false],
['t1744',1511,467,466,[4124,4145,2804,2819],[21,21,15,1,308],false],
['t1745',1511,469,468,[4462,4484,2804,2819],[21,21,15,1,317],false],
['t1746',1511,470,471,[4565,4586,2804,2819],[21,21,15,1,308],false],
['t1747',477,478,663,[4664,4734,2411,2727],[450,450,11,7,4686],false],
['t1748',485,663,472,[4905,4919,2484,2647],[165,165,11,5,1775],false],
['t1750',484,473,663,[4878,4888,2467,2629],[162,162,10,1,1620],false],
['t1754',482,663,474,[4821,4845,2497,2562],[78,78,11,2,839],false],
['t1755',481,475,663,[4766,4779,2470,2631],[163,163,11,3,1751],false],
['t1757',480,663,476,[4724,4737,2495,2561],[67,67,10,3,703],false],
['t1758',1511,663,477,[4617,4631,2513,2712],[200,200,10,3,2137],false],
['t1761',1511,480,479,[4742,4756,2812,2822],[14,14,10,1,140],false],
['t1762',1507,481,476,[4747,4761,2747,2763],[16,16,14,1,217],false],
['t1763',1511,483,482,[4784,4799,2811,2822],[15,15,11,1,168],false],
['t1764',1507,474,484,[4825,4838,2757,2774],[16,16,13,1,211],false],
['t1765',1507,485,486,[4885,4900,2812,2822],[15,15,10,1,150],false],
['t1766',416,520,1938,[4448,4460,2245,2267],[21,21,12,1,250],false],
['t1767',418,663,1938,[4422,4434,2245,2267],[22,22,12,1,256],false],
['t1768',416,517,1940,[4448,4460,2024,2046],[22,22,12,1,265],false],
['t1769',416,516,1939,[4449,4460,1861,1884],[23,23,11,1,258],false],
['t1770',418,1940,381,[4423,4435,1975,1996],[21,21,12,1,245],false],
['t1771',418,381,1939,[4423,4435,1905,1926],[21,21,12,1,246],false],
['t1772',416,512,1941,[4447,4459,1490,1511],[21,21,12,1,254],false],
['t1773',416,513,1942,[4448,4460,1638,1660],[22,22,12,1,269],false],
['t1774',418,1941,663,[4423,4435,1490,1511],[21,21,11,1.5,243],false],
['t1775',418,1942,663,[4423,4435,1613,1634],[21,21,11,1,243],false],
['t1782',416,509,1944,[4448,4460,1236,1258],[22,22,12,1,253],false],
['t1783',416,508,1943,[4450,4460,1107,1130],[22,22,10,1,226],false],
['t1784',418,1943,379,[4422,4433,1143,1165],[22,22,11,1,237],false],
['t1785',418,379,1944,[4422,4433,1236,1258],[22,22,11,1,240],false],
['t1786',416,765,1945,[4423,4445,951,963],[21,21,12,1,265],false],
['t1787',418,1945,663,[4424,4435,1027,1049],[22,22,11,1,242],false],
['t1790',1511,416,663,[4426,4437,804,876],[72,72,12,1,834],false],
['t1791',1511,663,418,[4393,4421,785,852],[84,84,11,2,1002],false],
['t1792',477,500,492,[4692,4706,2228,2250],[22,22,14,1,309],false],
['t1793',477,501,493,[4692,4706,2150,2172],[22,22,14,1,309],false],
['t1795',1697,495,663,[4532,4542,963,1014],[51,51,11,1,548],false],
['t1797',1698,663,494,[4532,4542,1123,1174],[51,51,11,1,541],false],
['t1799',1693,497,663,[4532,4542,1340,1391],[51,51,11,1,548],false],
['t1801',1694,663,496,[4532,4542,1501,1552],[51,51,11,1,541],false],
['t1803',1687,499,663,[4532,4542,1717,1768],[51,51,11,1,548],false],
['t1805',1689,663,498,[4532,4542,1877,1928],[51,51,11,1,541],false],
['t1807',1682,501,663,[4532,4542,2094,2145],[51,51,11,1,548],false],
['t1809',1683,663,500,[4532,4542,2255,2306],[51,51,11,1,541],false],
['t1810',477,498,502,[4692,4706,1850,1873],[22,22,14,1,309],false],
['t1811',477,499,503,[4692,4706,1772,1794],[22,22,14,1,309],false],
['t1812',477,496,504,[4692,4706,1474,1496],[22,22,14,1,309],false],
['t1813',477,497,505,[4692,4706,1395,1418],[22,22,14,1,309],false],
['t1814',477,1696,1945,[4692,4706,973,995],[22,22,14,1,310],false],
['t1815',477,1695,1943,[4692,4706,1141,1164],[23,23,14,1,327],false],
['t1816',477,1692,1944,[4692,4706,1350,1372],[22,22,14,1,304],false],
['t1817',477,1691,1941,[4692,4706,1518,1541],[23,23,14,1,321],false],
['t1818',477,1686,1942,[4692,4706,1727,1749],[22,22,14,1,304],false],
['t1819',477,1685,1939,[4692,4706,1895,1918],[23,23,14,1,321],false],
['t1820',477,1681,1940,[4692,4706,2104,2126],[22,22,14,1,303],false],
['t1821',477,1680,1938,[4692,4706,2273,2296],[23,23,14,1,320],false],
['t1822',415,1945,506,[4660,4672,973,995],[22,22,12,1,267],false],
['t1823',415,1943,507,[4660,4672,1141,1164],[23,23,12,1,282],false],
['t1824',415,1944,510,[4660,4672,1350,1372],[22,22,12,1,267],false],
['t1825',415,1941,511,[4660,4672,1518,1541],[23,23,12,1,282],false],
['t1826',415,1942,514,[4660,4672,1727,1749],[22,22,12,1,267],false],
['t1827',415,1939,515,[4660,4672,1895,1918],[23,23,12,1,282],false],
['t1828',415,1940,518,[4660,4672,2104,2126],[22,22,12,1,267],false],
['t1829',415,1938,519,[4660,4672,2273,2296],[23,23,12,1,282],false],
['t1830',417,1945,508,[4580,4592,975,998],[23,23,12,1,266],false],
['t1831',417,1943,509,[4580,4592,1140,1162],[22,22,12,1,256],false],
['t1832',417,1944,512,[4580,4592,1352,1375],[23,23,12,1,273],false],
['t1833',417,1941,513,[4580,4592,1518,1540],[22,22,12,1,262],false],
['t1834',417,1942,516,[4580,4592,1729,1752],[23,23,11,1,260],false],
['t1835',417,1939,517,[4580,4592,1894,1916],[22,22,11,1,249],false],
['t1836',417,1940,520,[4580,4592,2106,2129],[23,23,11,1,259],false],
['t1837',417,1938,521,[4580,4592,2272,2294],[22,22,11,1,249],false],
['t1840',1651,663,506,[4628,4648,986,1045],[69,69,10,3,686],false],
['t1841',506,508,663,[4607,4617,986,1037],[52,52,9,1,490],false],
['t1844',393,507,663,[4628,4648,1092,1150],[68,68,10,3,679],false],
['t1845',507,509,663,[4607,4617,1100,1150],[50,50,9,1,475],false],
['t1848',310,510,663,[4628,4648,1363,1422],[69,69,10,3,686],false],
['t1849',510,663,512,[4607,4617,1363,1415],[52,52,9,1,490],false],
['t1852',311,511,663,[4628,4648,1469,1527],[68,68,10,3,679],false],
['t1853',511,513,663,[4607,4617,1477,1527],[50,50,9,1,475],false],
['t1856',386,514,663,[4628,4648,1740,1799],[69,69,10,3,686],false],
['t1857',514,663,516,[4607,4617,1740,1791],[52,52,9,1,490],false],
['t1860',387,515,663,[4628,4648,1846,1904],[68,68,10,3,679],false],
['t1861',515,517,663,[4607,4617,1854,1904],[50,50,9,1,475],false],
['t1864',1593,518,663,[4628,4648,2117,2176],[69,69,10,3,686],false],
['t1865',518,663,520,[4607,4617,2117,2169],[52,52,9,1,490],false],
['t1868',610,519,663,[4628,4648,2223,2282],[68,68,10,3,679],false],
['t1869',519,521,663,[4607,4617,2232,2282],[50,50,9,1,475],false],
['t1870',477,494,522,[4692,4706,1096,1119],[22,22,14,1,315],false],
['t1871',477,495,523,[4692,4706,1018,1040],[22,22,14,1,315],false],
['t1872',1511,417,663,[4573,4588,783,857],[76,76,12,3,931],false],
['t1873',1511,663,415,[4602,4617,783,857],[76,76,12,3,927],false],
['t1874',1511,663,477,[4653,4667,782,856],[75,75,12,3,894],false],
['t1875',1507,525,524,[5000,5013,2754,2770],[16,16,13,1,209],false],
['t1876',1511,526,527,[5054,5067,2780,2797],[17,17,14,1,228],false],
['t1877',1507,529,528,[5129,5151,2771,2785],[22,22,13,1,295],false],
['t1878',1511,414,530,[5158,5171,2829,2844],[15,15,13,1,188],false],
['t1879',1160,533,663,[5236,5250,2658,2760],[103,103,10,3,1088],false],
['t1880',533,610,663,[5200,5288,2411,2426],[90,90,11,3,1050],false],
['t1881',537,663,531,[5352,5363,2631,2758],[127,127,10,1,1310],false],
['t1882',537,531,663,[5378,5387,2603,2758],[155,155,9,1,1464],false],
['t1885',1511,663,531,[5321,5355,2527,2691],[257,257,10,3,2587],false],
['t1886',1511,532,663,[5289,5303,2514,2713],[201,201,11,5,2116],false],
['t1887',534,663,532,[5265,5280,2528,2768],[243,243,10,5,2496],false],
['t1889',287,533,663,[5235,5248,2495,2598],[105,105,10,3,1042],false],
['t1890',1511,534,535,[5264,5286,2805,2819],[22,22,14,1,311],false],
['t1891',1511,537,536,[5337,5359,2805,2819],[22,22,14,1,310],false],
['t1892',1647,574,572,[4670,4684,624,661],[36,36,13,1,483],false],
['t1893',255,663,572,[4697,4758,597,717],[233,233,10,9,2407],false],
['t1895',578,543,663,[5014,5024,983,1035],[52,52,10,1,503],false],
['t1896',578,663,541,[5014,5024,1101,1158],[57,57,10,1,557],false],
['t1897',578,550,663,[5013,5024,1356,1412],[56,56,11,1,599],false],
['t1898',578,548,663,[5013,5024,1478,1535],[57,57,11,1,606],false],
['t1899',578,558,663,[5013,5024,1733,1789],[56,56,11,1,616],false],
['t1900',578,556,663,[5013,5024,1855,1912],[57,57,11,1,624],false],
['t1901',578,566,663,[5013,5024,2111,2166],[56,56,11,1,594],false],
['t1902',578,564,663,[5013,5024,2232,2289],[57,57,11,1,607],false],
['t1903',472,2745,2746,[4960,4970,889,956],[67,67,10,1,672],false],
['t1904',472,2745,2746,[4960,4971,985,1051],[67,67,10,1,687],false],
['t1905',472,2747,2748,[4960,4971,1103,1240],[137,137,10,1,1410],false],
['t1906',472,2749,2750,[4960,4971,1272,1409],[137,137,10,1,1414],false],
['t1907',472,2751,2752,[4960,4971,1481,1617],[137,137,10,1,1410],false],
['t1908',472,2753,2754,[4960,4971,1650,1787],[137,137,10,1,1414],false],
['t1909',472,2755,2756,[4960,4971,1858,1995],[137,137,10,1,1410],false],
['t1910',472,2757,2758,[4960,4971,2027,2164],[136,136,10,1,1409],false],
['t1911',472,2759,2760,[4960,4971,2235,2371],[137,137,10,1,1410],false],
['t1912',473,663,538,[4869,4889,960,1010],[60,60,10,2,555],false],
['t1913',473,663,547,[4856,4866,1100,1153],[53,53,10,1,547],false],
['t1914',473,663,542,[4870,4890,1126,1181],[65,65,10,2,681],false],
['t1915',473,663,551,[4869,4889,1338,1387],[60,60,9,2,573],false],
['t1916',473,663,554,[4856,4866,1360,1412],[52,52,10,1,520],false],
['t1917',473,663,555,[4856,4866,1477,1530],[53,53,10,1,536],false],
['t1918',473,663,549,[4870,4889,1503,1558],[63,63,11,2,675],false],
['t1919',473,663,559,[4869,4889,1716,1765],[60,60,9,2,552],false],
['t1920',473,663,562,[4856,4866,1738,1790],[52,52,10,1,536],false],
['t1921',473,663,563,[4856,4866,1854,1907],[53,53,10,1,553],false],
['t1922',473,663,557,[4870,4889,1881,1933],[63,63,9,2,600],false],
['t1923',473,663,567,[4869,4890,2093,2141],[60,60,10,2,584],false],
['t1924',473,663,570,[4856,4866,2115,2166],[51,51,10,1,531],false],
['t1925',473,663,571,[4856,4866,2231,2284],[53,53,10,1,553],false],
['t1926',473,663,565,[4870,4889,2258,2312],[64,64,10,2,630],false],
['t1928',538,543,663,[5037,5048,978,1022],[45,45,9,3,413],false],
['t1929',544,2745,543,[4980,5001,889,994],[116,116,10,3,1210],false],
['t1930',544,2745,543,[4982,4991,1023,1057],[33,33,9,1,314],false],
['t1931',1696,2746,663,[4938,4949,896,1031],[135,135,10,1,1395],false],
['t1932',1696,663,538,[4916,4929,896,947],[52,52,10,3,530],false],
['t1934',544,663,538,[4899,4927,1020,1064],[61,61,10,2,632],false],
['t1935',1696,573,663,[4794,4804,785,829],[44,44,10,1,459],false],
['t1936',1696,546,2761,[4831,4844,991,1058],[69,69,10,3,727],false],
['t1937',1696,546,2761,[4820,4831,883,961],[78,78,11,1,832],false],
['t1938',544,2761,2762,[4801,4812,1046,1058],[12,12,10,1,129],false],
['t1939',544,2761,2762,[4798,4812,883,1016],[135,135,11,5,1432],false],
['t1940',544,663,540,[4763,4772,785,829],[44,44,9,1,407],false],
['t1941',472,2762,663,[4776,4787,1021,1049],[29,29,10,1,289],false],
['t1942',472,2762,663,[4776,4790,883,990],[108,108,10,3,1143],false],
['t1945',523,544,663,[4744,4754,979,1031],[52,52,10,1,523],false],
['t1947',542,541,663,[5037,5048,1114,1158],[45,45,9,3,411],false],
['t1948',545,541,2748,[4982,4991,1078,1113],[35,35,9,1,330],false],
['t1949',545,541,2748,[4982,4991,1142,1240],[98,98,9,1,885],false],
['t1950',1695,2747,663,[4941,4951,1103,1240],[137,137,9,1,1276],false],
['t1951',1695,542,663,[4916,4929,1190,1240],[51,51,10,3,536],false],
['t1953',545,542,663,[4899,4927,1075,1117],[59,59,10,2,609],false],
['t1954',1695,547,2763,[4831,4844,1078,1146],[70,70,10,3,737],false],
['t1955',1695,547,2763,[4820,4831,1174,1245],[71,71,11,1,757],false],
['t1956',545,2763,2764,[4801,4812,1078,1091],[13,13,10,1,138],false],
['t1957',545,2763,2764,[4798,4812,1120,1245],[126,126,10,3,1308],false],
['t1960',522,545,663,[4744,4754,1105,1156],[51,51,10,1,514],false],
['t1962',551,663,550,[5037,5048,1356,1400],[45,45,9,3,412],false],
['t1963',552,550,2749,[4982,4991,1401,1434],[34,34,10,1,327],false],
['t1964',552,550,2749,[4982,4991,1272,1371],[99,99,9,1,872],false],
['t1965',1692,2750,663,[4941,4952,1272,1409],[137,137,10,1,1417],false],
['t1966',1692,663,551,[4916,4929,1272,1325],[54,54,10,3,555],false],
['t1968',552,663,551,[4899,4927,1398,1441],[61,61,10,2,632],false],
['t1969',1692,554,2765,[4831,4844,1369,1435],[69,69,10,3,722],false],
['t1970',1692,554,2765,[4820,4831,1268,1339],[71,71,10,1,716],false],
['t1971',552,2765,2766,[4802,4812,1423,1435],[12,12,10,1,124],false],
['t1972',552,2765,2766,[4799,4812,1268,1393],[126,126,10,3,1309],false],
['t1975',505,663,552,[4744,4754,1357,1409],[52,52,10,1,521],false],
['t1977',549,548,663,[5037,5048,1492,1535],[45,45,9,3,411],false],
['t1978',553,548,2751,[4982,4991,1456,1491],[35,35,9,1,330],false],
['t1979',553,548,2751,[4982,4991,1520,1617],[98,98,9,1,885],false],
['t1980',1691,2752,663,[4941,4951,1481,1617],[137,137,9,1,1276],false],
['t1981',1691,549,663,[4916,4929,1567,1617],[51,51,10,3,536],false],
['t1983',553,549,663,[4899,4927,1452,1494],[59,59,10,2,611],false],
['t1984',1691,555,2767,[4831,4844,1455,1523],[70,70,10,3,738],false],
['t1985',1691,555,2767,[4820,4831,1552,1623],[71,71,11,1,757],false],
['t1986',553,2767,2768,[4801,4812,1455,1469],[13,13,10,1,139],false],
['t1987',553,2767,2768,[4798,4812,1498,1623],[126,126,10,3,1308],false],
['t1990',504,553,663,[4744,4754,1482,1534],[51,51,10,1,514],false],
['t1992',559,663,558,[5037,5048,1733,1777],[45,45,9,3,413],false],
['t1993',560,558,2753,[4982,4991,1778,1812],[34,34,10,1,327],false],
['t1994',560,558,2753,[4982,4991,1650,1749],[99,99,9,1,872],false],
['t1995',1686,2754,663,[4941,4952,1650,1787],[137,137,10,1,1417],false],
['t1996',1686,663,559,[4916,4929,1650,1702],[54,54,10,3,555],false],
['t1998',560,663,559,[4899,4927,1775,1818],[61,61,10,2,625],false],
['t1999',1686,562,2769,[4831,4844,1746,1812],[69,69,10,3,722],false],
['t2000',1686,562,2769,[4821,4831,1646,1716],[71,71,10,1,716],false],
['t2001',560,2769,2770,[4802,4812,1800,1812],[12,12,10,1,124],false],
['t2002',560,2769,2770,[4799,4812,1646,1771],[126,126,10,3,1309],false],
['t2005',503,663,560,[4744,4754,1734,1786],[52,52,10,1,521],false],
['t2007',557,556,663,[5037,5048,1869,1912],[45,45,9,3,410],false],
['t2008',561,556,2755,[4982,4991,1833,1868],[35,35,9,1,330],false],
['t2009',561,556,2755,[4982,4991,1897,1995],[98,98,9,1,885],false],
['t2010',1685,2756,663,[4941,4951,1858,1995],[137,137,9,1,1276],false],
['t2011',1685,557,663,[4916,4929,1944,1995],[51,51,10,3,535],false],
['t2013',561,557,663,[4899,4927,1829,1871],[60,60,10,2,621],false],
['t2014',1685,563,2771,[4831,4844,1832,1900],[70,70,10,3,738],false],
['t2015',1685,563,2771,[4820,4831,1929,2000],[71,71,11,1,757],false],
['t2016',561,2771,2772,[4801,4812,1832,1846],[13,13,10,1,139],false],
['t2017',561,2771,2772,[4798,4812,1875,2000],[126,126,10,3,1308],false],
['t2020',502,561,663,[4744,4754,1860,1911],[51,51,10,1,514],false],
['t2022',567,663,566,[5037,5048,2111,2154],[45,45,9,3,408],false],
['t2023',568,566,2757,[4982,4991,2155,2189],[34,34,10,1,327],false],
['t2024',568,566,2757,[4982,4991,2027,2126],[98,98,9,1,868],false],
['t2025',1681,2758,663,[4941,4952,2027,2164],[136,136,10,1,1411],false],
['t2026',1681,663,567,[4916,4929,2027,2079],[53,53,10,3,550],false],
['t2028',568,663,567,[4899,4927,2152,2195],[61,61,10,2,629],false],
['t2029',1681,570,2773,[4831,4844,2123,2189],[69,69,10,3,722],false],
['t2030',1681,570,2773,[4821,4831,2023,2093],[70,70,10,1,711],false],
['t2031',568,2773,2774,[4802,4812,2177,2189],[12,12,10,1,124],false],
['t2032',568,2773,2774,[4799,4812,2023,2147],[126,126,10,3,1304],false],
['t2035',493,663,568,[4744,4754,2111,2163],[51,51,10,1,516],false],
['t2037',565,564,663,[5037,5048,2246,2289],[45,45,9,3,410],false],
['t2038',569,564,2759,[4982,4991,2210,2245],[35,35,9,1,330],false],
['t2039',569,564,2759,[4982,4991,2274,2371],[98,98,9,1,885],false],
['t2040',1680,2760,663,[4941,4951,2235,2371],[137,137,9,1,1276],false],
['t2041',1680,565,663,[4916,4929,2321,2371],[51,51,10,3,536],false],
['t2043',569,565,663,[4899,4927,2206,2248],[60,60,10,2,616],false],
['t2044',1680,571,2775,[4831,4844,2209,2277],[70,70,10,3,738],false],
['t2045',1680,571,2775,[4820,4831,2306,2377],[71,71,11,1,757],false],
['t2046',569,2775,2776,[4801,4812,2209,2223],[13,13,10,1,139],false],
['t2047',569,2775,2776,[4798,4812,2252,2377],[126,126,10,3,1308],false],
['t2050',492,569,663,[4744,4754,2237,2288],[51,51,10,1,514],false],
['t2051',475,663,2764,[4776,4790,1098,1245],[149,149,10,3,1613],false],
['t2052',475,2766,663,[4776,4790,1268,1415],[148,148,11,3,1638],false],
['t2053',475,2768,663,[4776,4789,1475,1623],[149,149,11,3,1604],false],
['t2054',475,2770,663,[4776,4789,1646,1793],[148,148,11,3,1592],false],
['t2055',475,2772,663,[4776,4789,1852,2000],[149,149,11,3,1606],false],
['t2056',475,2774,663,[4776,4789,2023,2170],[148,148,10,3,1596],false],
['t2057',475,2776,663,[4776,4789,2229,2377],[149,149,10,3,1608],false],
['t2059',538,663,539,[4879,4890,783,828],[45,45,11,1,478],false],
['t2062',576,663,582,[5101,5114,986,1050],[65,65,10,3,653],false],
['t2063',576,663,581,[5101,5114,1087,1152],[66,66,10,3,664],false],
['t2064',576,579,31,[5114,5124,1236,1251],[15,15,10,1,142],false],
['t2065',576,580,31,[5114,5124,1262,1277],[15,15,10,1,147],false],
['t2066',576,663,586,[5101,5114,1364,1427],[65,65,10,3,676],false],
['t2067',576,663,585,[5101,5114,1465,1529],[66,66,10,3,694],false],
['t2068',576,590,663,[5100,5114,1741,1805],[66,66,10,3,675],false],
['t2069',576,589,663,[5100,5114,1842,1907],[66,66,10,3,701],false],
['t2070',576,31,587,[5114,5124,1991,2005],[15,15,10,1,150],false],
['t2071',576,31,588,[5114,5124,2017,2032],[15,15,10,1,149],false],
['t2072',576,594,663,[5101,5114,2118,2182],[65,65,10,3,662],false],
['t2073',576,593,663,[5101,5114,2219,2283],[66,66,10,3,667],false],
['t2074',576,663,575,[5130,5149,2494,2570],[94,94,10,5,956],false],
['t2075',576,31,591,[5114,5124,2368,2382],[15,15,10,1,151],false],
['t2076',576,595,31,[5114,5124,885,900],[15,15,11,1,160],false],
['t2077',576,583,31,[5114,5124,1613,1628],[15,15,10,1,142],false],
['t2078',576,31,1690,[5114,5124,1640,1655],[15,15,10,1,147],false],
['t2079',576,592,31,[5167,5182,2666,2676],[15,15,10,1,153],false],
['t2081',543,595,579,[5169,5181,1019,1062],[43,43,12,1,507],false],
['t2082',543,595,579,[5170,5181,918,991],[72,72,11,1,793],false],
['t2083',582,595,663,[5136,5160,962,1062],[123,123,11,5,1441],false],
['t2084',582,595,663,[5143,5155,909,932],[23,23,12,1,276],false],
['t2085',546,582,663,[5078,5091,986,1050],[65,65,10,3,673],false],
['t2087',547,663,581,[5078,5092,1087,1151],[65,65,10,3,675],false],
['t2088',541,579,580,[5158,5182,1132,1251],[129,129,12,4,1542],false],
['t2089',581,663,579,[5139,5158,1146,1230],[91,91,13,4,1136],false],
['t2090',581,663,579,[5142,5176,1084,1111],[49,49,12,2,581],false],
['t2092',550,580,583,[5169,5181,1396,1439],[43,43,12,1,507],false],
['t2093',550,580,583,[5170,5181,1295,1368],[73,73,11,1,800],false],
['t2094',586,580,663,[5136,5160,1339,1439],[123,123,11,5,1441],false],
['t2095',586,580,663,[5143,5155,1286,1310],[23,23,12,1,276],false],
['t2096',554,586,663,[5078,5091,1364,1427],[65,65,10,3,673],false],
['t2098',555,663,585,[5078,5092,1465,1529],[65,65,10,3,675],false],
['t2099',548,584,583,[5158,5182,1510,1629],[129,129,12,4,1543],false],
['t2100',585,663,583,[5139,5158,1523,1607],[91,91,13,4,1134],false],
['t2101',585,663,583,[5142,5176,1461,1489],[49,49,12,2,584],false],
['t2103',558,1690,587,[5169,5181,1774,1817],[43,43,12,1,507],false],
['t2104',558,1690,587,[5170,5181,1672,1745],[73,73,11,1,800],false],
['t2105',590,1690,663,[5136,5160,1716,1817],[123,123,11,5,1439],false],
['t2106',590,1690,663,[5143,5155,1664,1687],[23,23,12,1.5,276],false],
['t2107',562,663,590,[5078,5091,1741,1805],[65,65,10,3,672],false],
['t2109',563,589,663,[5078,5092,1842,1906],[65,65,10,3,675],false],
['t2110',556,587,588,[5158,5182,1887,2005],[128,128,12,4,1533],false],
['t2111',589,663,587,[5139,5158,1900,1983],[90,90,13,4,1124],false],
['t2112',589,663,587,[5142,5176,1838,1866],[50,50,12,2,594],false],
['t2114',566,588,591,[5169,5181,2150,2193],[43,43,12,1,507],false],
['t2115',566,588,591,[5170,5181,2050,2122],[73,73,11,1,795],false],
['t2116',594,588,663,[5136,5160,2093,2193],[123,123,11,5,1440],false],
['t2117',594,588,663,[5143,5155,2041,2064],[23,23,12,1,276],false],
['t2118',570,663,594,[5078,5091,2118,2182],[65,65,10,3,672],false],
['t2120',571,593,663,[5078,5092,2219,2283],[65,65,10,3,675],false],
['t2121',564,591,592,[5158,5182,2264,2383],[129,129,12,4,1539],false],
['t2122',593,663,591,[5139,5158,2277,2361],[91,91,13,4,1129],false],
['t2123',593,663,591,[5142,5176,2215,2243],[50,50,12,2,588],false],
['t2124',575,663,592,[5174,5195,2480,2627],[165,165,11,5,1902],false],
['t2126',529,575,663,[5113,5123,2494,2561],[67,67,10,1,698],false],
['t2127',1511,576,663,[5064,5095,2514,2705],[213,213,11,5,2322],false],
['t2129',478,663,576,[5039,5072,2503,2706],[234,234,11,5,2421],false],
['t2130',524,578,663,[5018,5042,2513,2678],[179,179,11,3,1904],false],
['t2132',577,663,525,[4972,5004,2532,2586],[76,76,10,2,785],false],
['t2135',526,577,663,[4958,4968,2493,2558],[66,66,10,1,655],false],
['t2138',1511,603,596,[5657,5678,2076,2089],[21,21,13,1,267],false],
['t2139',1511,597,605,[5657,5678,2194,2207],[21,21,13,1,267],false],
['t2140',598,663,606,[5643,5678,2013,2037],[48,48,10,2,473],false],
['t2141',599,663,600,[5643,5678,2247,2267],[45,45,10,2,447],false],
['t2143',606,31,603,[5700,5714,2046,2061],[15,15,14,1,209],false],
['t2144',600,605,31,[5700,5714,2221,2235],[14,14,14,1,191],false],
['t2146',1511,663,606,[5654,5684,1970,1981],[30,30,11,1,318],false],
['t2147',1511,663,600,[5654,5684,2303,2314],[30,30,11,1,318],false],
['t2150',603,663,598,[5628,5694,1868,1935],[225,225,10,6,2335],false],
['t2151',605,663,599,[5628,5694,2349,2415],[223,223,10,6,2314],false],
['t2152',531,387,598,[5641,5730,1843,1856],[90,90,13,1,1139],false],
['t2153',531,599,1593,[5641,5731,2428,2440],[90,90,13,1.5,1132],false],
['t2154',983,601,387,[5697,5734,1816,1830],[36,36,13,1,487],false],
['t2155',983,1593,602,[5697,5734,2454,2467],[37,37,13,1,487],false],
['t2156',683,663,597,[5625,5757,2147,2183],[157,157,11,5,1808],false],
['t2157',677,596,663,[5625,5757,2101,2137],[158,158,11,5,1766],false],
['t2158',686,663,607,[5625,5758,2892,2930],[158,158,12,5.5,1913],false],
['t2160',1511,611,607,[5658,5679,2869,2882],[21,21,13,1,270],false],
['t2161',608,663,612,[5643,5678,2806,2829],[48,48,10,2,476],false],
['t2163',612,31,611,[5700,5714,2838,2853],[14,14,14,1,193],false],
['t2164',1511,663,612,[5655,5684,2763,2774],[29,29,11,1,305],false],
['t2166',611,663,608,[5628,5694,2660,2728],[225,225,10,6,2338],false],
['t2167',531,610,608,[5641,5730,2636,2649],[89,89,13,1,1136],false],
['t2168',983,609,610,[5697,5734,2609,2623],[37,37,13,1,493],false],
['t2169',478,616,2777,[5342,5355,2355,2377],[23,23,14,1,308],false],
['t2170',478,632,2778,[5341,5355,2021,2042],[21,21,14,1,300],false],
['t2171',478,615,2779,[5341,5355,1977,2000],[23,23,14,1,322],false],
['t2172',478,627,2780,[5341,5355,1644,1665],[21,21,14,1,295],false],
['t2173',478,614,2781,[5341,5355,1601,1623],[23,23,14,1,317],false],
['t2174',478,622,2782,[5341,5355,1268,1289],[21,21,14,1,292],false],
['t2175',478,613,2783,[5341,5355,1224,1247],[23,23,14,1,314],false],
['t2176',478,617,2784,[5342,5355,891,912],[21,21,14,1,292],false],
['t2177',1511,2777,634,[5321,5335,2355,2377],[23,23,14,1.5,308],false],
['t2178',1511,2778,633,[5321,5334,2021,2042],[21,21,13,1,283],false],
['t2179',1511,2779,629,[5321,5335,1977,2000],[23,23,14,1.5,304],false],
['t2180',1511,2780,628,[5321,5334,1644,1665],[21,21,14,1,285],false],
['t2181',1511,2781,624,[5321,5335,1601,1623],[23,23,14,1.5,307],false],
['t2182',1511,2782,623,[5321,5335,1268,1289],[21,21,14,1,288],false],
['t2183',1511,2783,619,[5321,5335,1224,1247],[23,23,14,1.5,310],false],
['t2184',1511,2784,618,[5321,5334,891,912],[21,21,13,1,285],false],
['t2185',543,2785,618,[5283,5294,992,1028],[36,36,10,1,369],false],
['t2186',543,2785,618,[5278,5302,904,966],[76,76,10,2,822],false],
['t2187',579,2785,663,[5289,5316,953,1059],[121,121,11,2.5,1261],false],
['t2189',621,618,663,[5254,5273,981,1039],[65,65,10,3,680],false],
['t2191',543,621,663,[5234,5249,989,1056],[73,73,10,3,739],false],
['t2192',579,621,663,[5209,5231,989,1056],[78,78,10,5,805],false],
['t2193',541,2786,619,[5283,5294,1109,1144],[35,35,10,1,358],false],
['t2194',541,2786,619,[5278,5302,1170,1236],[79,79,11,2,863],false],
['t2195',580,2786,663,[5289,5314,1081,1184],[117,117,10,2,1234],false],
['t2197',620,619,663,[5254,5273,1098,1155],[65,65,10,3,674],false],
['t2199',541,663,620,[5234,5249,1080,1148],[73,73,10,3,741],false],
['t2200',580,663,620,[5209,5231,1080,1147],[77,77,10,5,795],false],
['t2201',550,2787,623,[5283,5294,1369,1405],[36,36,10,1,369],false],
['t2202',550,2787,623,[5278,5302,1281,1343],[76,76,10,2,817],false],
['t2203',583,2787,663,[5289,5316,1329,1436],[121,121,12,2.5,1264],false],
['t2205',626,623,663,[5254,5273,1358,1416],[65,65,10,3,681],false],
['t2207',550,626,663,[5234,5249,1366,1433],[73,73,10,3,738],false],
['t2208',583,626,663,[5209,5231,1366,1433],[78,78,10,5,806],false],
['t2209',548,2788,624,[5283,5294,1486,1520],[35,35,10,1,358],false],
['t2210',548,2788,624,[5278,5302,1547,1613],[79,79,11,2,868],false],
['t2211',584,2788,663,[5289,5314,1458,1561],[117,117,10,2,1226],false],
['t2213',625,624,663,[5254,5273,1475,1532],[65,65,10,3,673],false],
['t2215',548,663,625,[5234,5249,1457,1524],[73,73,10,3,741],false],
['t2216',584,663,625,[5209,5231,1457,1524],[77,77,10,5,793],false],
['t2217',558,2789,628,[5283,5294,1746,1781],[36,36,10,1,369],false],
['t2218',558,2789,628,[5278,5302,1657,1720],[75,75,10,2,788],false],
['t2219',587,2789,663,[5289,5316,1706,1812],[121,121,11,2.5,1261],false],
['t2221',631,628,663,[5254,5273,1735,1792],[65,65,10,3,680],false],
['t2223',558,631,663,[5234,5249,1742,1810],[73,73,10,3,739],false],
['t2224',587,631,663,[5209,5231,1742,1810],[78,78,10,5,805],false],
['t2225',556,2790,629,[5283,5294,1863,1897],[35,35,10,1,358],false],
['t2226',556,2790,629,[5278,5302,1924,1989],[79,79,11,2,866],false],
['t2227',588,2790,663,[5289,5314,1835,1938],[117,117,10,2,1228],false],
['t2229',630,629,663,[5254,5273,1852,1909],[65,65,10,3,674],false],
['t2231',556,663,630,[5234,5249,1834,1901],[73,73,10,3,741],false],
['t2232',588,663,630,[5209,5231,1834,1901],[77,77,10,5,793],false],
['t2233',566,2791,633,[5283,5294,2123,2158],[36,36,10,1,369],false],
['t2234',566,2791,633,[5278,5302,2035,2097],[75,75,10,2,786],false],
['t2235',591,2791,663,[5289,5316,2083,2189],[121,121,12,2.5,1263],false],
['t2237',636,633,663,[5254,5273,2112,2169],[65,65,10,3,681],false],
['t2239',566,636,663,[5234,5249,2120,2187],[73,73,10,3,739],false],
['t2240',591,636,663,[5209,5231,2119,2187],[78,78,10,5,806],false],
['t2241',564,2792,634,[5283,5294,2240,2274],[35,35,10,1,358],false],
['t2242',564,2792,634,[5278,5302,2301,2366],[79,79,11,2,867],false],
['t2243',592,2792,663,[5289,5314,2212,2315],[117,117,10,2,1227],false],
['t2245',635,634,663,[5254,5273,2229,2286],[65,65,10,3,673],false],
['t2247',564,663,635,[5234,5249,2211,2278],[73,73,10,3,741],false],
['t2248',592,663,635,[5209,5231,2211,2278],[77,77,10,5,793],false],
['t2250',412,663,645,[5414,5434,912,1056],[155,155,10,5,1629],false],
['t2251',617,412,663,[5365,5401,927,1050],[197,197,11,5.5,2081],false],
['t2252',638,663,645,[5414,5434,1080,1225],[156,156,10,5,1639],false],
['t2254',613,663,638,[5366,5401,1089,1210],[193,193,10,5,2032],false],
['t2255',639,663,645,[5414,5434,1289,1432],[155,155,10,5,1629],false],
['t2257',622,639,663,[5364,5401,1304,1428],[199,199,11,5.5,2094],false],
['t2258',640,663,645,[5414,5434,1457,1602],[156,156,10,5,1639],false],
['t2260',614,640,663,[5366,5401,1466,1586],[191,191,10,5,2017],false],
['t2261',641,663,645,[5414,5434,1665,1809],[155,155,10,5,1629],false],
['t2263',627,641,663,[5365,5401,1680,1804],[198,198,11,5.5,2090],false],
['t2264',642,663,645,[5414,5434,1834,1979],[156,156,10,5,1639],false],
['t2266',615,663,642,[5366,5401,1843,1963],[192,192,10,5,2021],false],
['t2268',643,645,663,[5414,5434,2042,2186],[155,155,10,5,1634],false],
['t2269',632,643,663,[5364,5401,2057,2182],[199,199,11,5.5,2101],false],
['t2271',644,645,663,[5414,5434,2211,2356],[156,156,10,5,1639],false],
['t2272',616,644,663,[5366,5401,2220,2340],[191,191,10,5,2018],false],
['t2274',532,642,387,[5457,5471,1849,1938],[88,88,13,2,1081],false],
['t2275',532,644,610,[5458,5471,2227,2315],[88,88,12,2,1017],false],
['t2276',532,640,311,[5458,5472,1473,1561],[89,89,12,3,1091],false],
['t2277',532,638,393,[5458,5472,1096,1184],[88,88,12,3,1102],false],
['t2278',532,641,386,[5458,5471,1706,1794],[88,88,12,3,1064],false],
['t2279',532,643,1593,[5458,5471,2083,2171],[88,88,12,2,1016],false],
['t2280',532,639,310,[5458,5472,1329,1417],[89,89,12,3,1096],false],
['t2281',532,412,1651,[5458,5472,952,1041],[88,88,12,3,1091],false],
['t2282',1511,576,663,[4950,4962,774,847],[73,73,12,1,865],false],
['t2284',595,663,646,[5143,5184,733,849],[255,255,10,7,2577],false],
['t2285',374,478,663,[5270,5343,843,856],[73,73,12,1,907],false],
['t2286',649,663,652,[4956,5076,462,571],[559,559,10,17,5618],false],
['t2287',1574,663,652,[5086,5205,463,564],[547,547,10,19,5504],false],
['t2289',652,653,663,[5249,5380,462,570],[574,574,10,20,5992],false],
['t2291',1574,653,663,[5391,5511,462,563],[533,533,10,19,5469],false],
['t2292',983,649,1651,[4978,4998,611,652],[48,48,13,2,606],false],
['t2293',531,1651,650,[5014,5027,596,682],[86,86,12,1,1046],false],
['t2294',691,661,663,[5243,5372,596,609],[130,130,12,1,1606],false],
['t2296',1511,654,661,[5201,5214,614,635],[21,21,13,1,271],false],
['t2297',654,650,663,[5038,5103,574,665],[228,228,10,10,2386],false],
['t2298',1511,663,651,[5114,5142,599,610],[28,28,10,1,290],false],
['t2299',650,663,651,[5114,5150,630,641],[36,36,11,1,388],false],
['t2302',651,31,654,[5200,5213,671,685],[14,14,13,1,183],false],
['t2303',1511,532,663,[5435,5449,751,824],[74,74,12,3,900],false],
['t2304',1785,663,411,[5406,5448,692,824],[165,165,11,5,1779],false],
['t2305',658,663,411,[5378,5417,683,829],[174,174,11,5,1841],false],
['t2308',579,658,663,[5312,5337,632,750],[133,133,10,3,1372],false],
['t2309',579,663,659,[5245,5278,745,779],[58,58,10,3,583],false],
['t2310',539,658,663,[5276,5304,632,742],[128,128,10,2,1344],false],
['t2311',659,663,1785,[5069,5119,749,848],[138,138,11,4,1384],false],
['t2314',540,1785,663,[5008,5050,730,837],[140,140,10,4,1452],false],
['t2315',573,663,1785,[5044,5069,730,848],[133,133,10,3,1385],false],
['t2316',662,31,664,[5956,6405,361,491],[780,780,10,24,7508],false],
['t2317',662,31,664,[5956,6087,421,462],[285,285,10,7,2921],false],
['t2318',662,31,664,[5956,6087,371,412],[284,284,11,7,2979],false],
['t2320',662,31,664,[5956,6087,309,362],[286,286,10,8,2899],false],
['t2321',1574,663,662,[5768,5922,425,500],[483,483,11,9,5131],false],
['t2322',665,663,662,[5768,5922,345,415],[478,478,10,9,5093],false],
['t2324',665,663,664,[5951,6087,266,307],[238,238,12,5,2801],false],
['t2325',665,663,664,[5951,6086,215,259],[287,287,12,7,3467],false],
['t2326',665,663,664,[5951,6087,163,208],[288,288,13,7,3549],false],
['t2327',665,664,663,[5951,6376,109,176],[773,773,12,15,8979],false],
['t2328',1574,663,665,[5759,5918,171,289],[477,477,10,9,4875],false],
['t2329',390,663,665,[5696,5878,145,237],[515,515,11,13,5489],false],
['t2330',663,663,664,[6411,6457,452,516],[95,95,14,2,1372],false],
['t2331',666,31,669,[5956,6405,1183,1313],[781,781,10,24,7511],false],
['t2332',666,31,669,[5956,6087,1243,1284],[285,285,10,7,2921],false],
['t2333',666,31,669,[5956,6087,1193,1234],[284,284,11,7,2979],false],
['t2335',666,31,669,[5956,6087,1131,1184],[286,286,10,8,2903],false],
['t2337',667,31,670,[5956,6087,723,774],[283,283,10,8,2874],false],
['t2338',667,31,670,[5956,6087,673,714],[284,284,11,7,2983],false],
['t2339',667,31,670,[5956,6087,623,664],[286,286,10,7,2925],false],
['t2340',667,31,670,[5956,6405,591,721],[785,785,10,24,7915],false],
['t2341',1574,663,666,[5768,5922,1247,1322],[483,483,11,9,5131],false],
['t2342',1574,663,667,[5768,5922,586,660],[484,484,11,9,5137],false],
['t2343',671,663,666,[5768,5922,1167,1237],[478,478,10,9,5093],false],
['t2344',672,663,667,[5769,5922,670,741],[478,478,10,9,5093],false],
['t2346',671,663,669,[5951,6087,1088,1129],[238,238,12,5,2801],false],
['t2347',671,663,669,[5951,6086,1037,1081],[287,287,12,7,3467],false],
['t2348',671,663,669,[5951,6087,985,1030],[288,288,13,7,3549],false],
['t2349',671,669,663,[5951,6429,960,1030],[803,803,12,20,9533],false],
['t2350',672,663,670,[5951,6430,874,947],[807,807,12,20,9519],false],
['t2351',672,663,670,[5951,6087,878,922],[288,288,13,7,3549],false],
['t2352',672,663,670,[5951,6086,827,870],[287,287,12,7,3467],false],
['t2353',672,663,670,[5951,6087,778,819],[238,238,12,5,2798],false],
['t2355',1574,663,671,[5759,5918,993,1111],[477,477,10,9,4875],false],
['t2356',1574,663,672,[5759,5918,796,914],[476,476,10,9,4869],false],
['t2357',406,663,671,[5696,5878,967,1059],[515,515,11,13,5489],false],
['t2358',397,663,672,[5695,5878,848,940],[516,516,11,13,5502],false],
['t2359',663,663,669,[6411,6457,1274,1338],[95,95,15,2,1380],false],
['t2360',663,663,670,[6411,6457,566,634],[99,99,14,2,1434],false],
['t2361',674,31,677,[5956,6405,1976,2105],[780,780,10,24,7504],false],
['t2362',674,31,677,[5956,6087,2035,2076],[285,285,10,7,2921],false],
['t2363',674,31,677,[5956,6087,1985,2026],[284,284,11,7,2979],false],
['t2365',674,31,677,[5956,6087,1923,1976],[285,285,10,8,2896],false],
['t2367',675,31,676,[5956,6087,1515,1566],[284,284,10,8,2881],false],
['t2368',675,31,676,[5956,6087,1465,1506],[284,284,11,7,2983],false],
['t2369',675,31,676,[5956,6087,1415,1456],[286,286,10,7,2925],false],
['t2370',675,31,676,[5956,6405,1383,1514],[786,786,10,24,7922],false],
['t2371',1574,663,674,[5768,5922,2039,2114],[483,483,11,9,5131],false],
['t2372',1574,663,675,[5768,5922,1378,1452],[484,484,11,9,5137],false],
['t2373',679,663,674,[5768,5922,1959,2029],[478,478,10,9,5093],false],
['t2374',680,663,675,[5769,5922,1462,1533],[478,478,10,9,5093],false],
['t2376',679,663,677,[5951,6087,1880,1921],[238,238,12,5,2801],false],
['t2377',679,663,677,[5951,6086,1829,1873],[287,287,12,7,3467],false],
['t2378',679,663,677,[5951,6087,1777,1822],[288,288,13,7,3549],false],
['t2379',679,663,677,[5951,6429,1752,1823],[804,804,12,20,9541],false],
['t2380',680,663,676,[5951,6087,1670,1714],[288,288,13,7,3549],false],
['t2381',680,663,676,[5951,6086,1619,1662],[287,287,12,7,3467],false],
['t2382',680,663,676,[5951,6087,1570,1611],[238,238,12,5,2798],false],
['t2384',680,676,663,[5951,6430,1667,1739],[807,807,12,20,9512],false],
['t2385',1574,663,679,[5759,5918,1785,1903],[477,477,10,9,4875],false],
['t2386',1574,663,680,[5759,5918,1588,1706],[476,476,10,9,4869],false],
['t2387',601,663,679,[5696,5878,1759,1851],[515,515,11,13,5489],false],
['t2388',402,663,680,[5695,5878,1640,1732],[516,516,11,13,5502],false],
['t2389',663,663,677,[6412,6457,2066,2130],[94,94,14,2,1343],false],
['t2390',663,663,676,[6411,6457,1359,1426],[99,99,14,2,1387],false],
['t2391',663,663,683,[6425,6439,2889,2971],[82,82,14,1,1137],false],
['t2392',663,663,686,[6389,6404,2889,2971],[82,82,15,1,1209],false],
['t2393',681,31,686,[5956,6342,2864,3042],[733,733,10,18,6886],false],
['t2394',681,31,686,[5956,6087,2828,2869],[285,285,10,7,2921],false],
['t2395',681,31,686,[5956,6087,2778,2819],[284,284,11,7,2979],false],
['t2397',681,31,686,[5956,6087,2716,2769],[286,286,10,8,2900],false],
['t2399',682,31,683,[5956,6087,2308,2359],[284,284,10,8,2877],false],
['t2400',682,31,683,[5956,6087,2257,2299],[284,284,11,7,2983],false],
['t2401',682,31,683,[5956,6087,2208,2249],[286,286,10,7,2925],false],
['t2402',682,31,683,[5956,6396,2176,2326],[776,776,10,20,7750],false],
['t2403',1574,663,681,[5768,5922,2832,2906],[483,483,11,9,5131],false],
['t2404',1574,663,682,[5768,5922,2170,2245],[484,484,11,9,5137],false],
['t2405',684,663,681,[5768,5922,2752,2822],[478,478,10,9,5093],false],
['t2406',685,663,682,[5769,5922,2255,2325],[478,478,10,9,5093],false],
['t2408',684,663,686,[5951,6087,2673,2714],[238,238,12,5,2801],false],
['t2409',684,663,686,[5951,6086,2622,2666],[287,287,12,7,3467],false],
['t2410',684,663,686,[5951,6087,2570,2614],[288,288,13,7,3549],false],
['t2411',684,686,663,[5951,6412,2545,2650],[803,803,12,20,9490],false],
['t2412',685,663,683,[5951,6412,2432,2532],[797,797,12,20,9430],false],
['t2413',685,663,683,[5951,6087,2463,2507],[288,288,13,7,3549],false],
['t2414',685,663,683,[5951,6086,2411,2455],[287,287,12,7,3467],false],
['t2415',685,663,683,[5951,6087,2363,2404],[238,238,12,5,2798],false],
['t2417',1574,663,684,[5759,5918,2577,2696],[477,477,10,9,4875],false],
['t2418',1574,663,685,[5759,5918,2381,2499],[476,476,10,9,4869],false],
['t2419',609,663,684,[5696,5878,2552,2644],[515,515,11,13,5489],false],
['t2420',602,663,685,[5695,5878,2432,2525],[516,516,11,13,5502],false],
['t2421',653,691,31,[5375,5517,212,409],[940,940,10,15,9560],false],
['t2422',653,691,31,[5376,5508,135,222],[422,422,10,9,4341],false],
['t2423',653,691,31,[5384,5509,399,441],[217,217,11,4,2228],false],
['t2424',802,31,1946,[3678,3741,184,457],[650,650,11,17,6763],false],
['t2425',802,31,1946,[3684,3809,121,170],[271,271,10,9,2714],false],
['t2426',802,31,1946,[3678,3738,447,535],[191,191,10,8,2008],false],
['t2427',801,1947,31,[4508,4571,184,457],[650,650,11,17,6763],false],
['t2428',801,1947,31,[4508,4568,447,534],[190,190,10,8,2001],false],
['t2429',801,1947,31,[4515,4639,121,170],[271,271,10,9,2717],false],
['t2430',806,1948,31,[3593,3656,184,457],[650,650,11,17,6763],false],
['t2431',806,1948,31,[3525,3650,121,170],[270,270,10,9,2708],false],
['t2432',806,1948,31,[3596,3656,447,535],[190,190,10,8,1998],false],
['t2433',805,31,1949,[4424,4487,184,457],[650,650,11,17,6763],false],
['t2434',805,31,1949,[4427,4486,447,534],[189,189,10,8,1988],false],
['t2435',805,31,1949,[4356,4480,121,170],[271,271,10,9,2714],false],
['t2436',802,31,1946,[3750,3791,444,537],[201,201,10,7,2131],false],
['t2437',801,31,1947,[4580,4621,444,538],[202,202,10,7,2137],false],
['t2438',806,31,1948,[3543,3584,444,537],[201,201,10,7,2129],false],
['t2439',805,31,1949,[4374,4415,444,537],[201,201,10,7,2131],false],
['t2440',802,31,1946,[3803,3844,444,537],[201,201,10,7,2131],false],
['t2441',801,31,1947,[4634,4674,444,538],[202,202,10,7,2137],false],
['t2442',806,31,1948,[3490,3531,444,537],[201,201,10,7,2129],false],
['t2443',805,31,1949,[4321,4361,444,537],[201,201,10,7,2131],false],
['t2444',802,31,1946,[3856,3897,444,537],[204,204,10,9,2119],false],
['t2445',802,663,687,[3961,4003,589,718],[275,275,11,5,2891],false],
['t2446',802,687,663,[3898,3945,555,566],[47,47,11,1,521],false],
['t2447',801,31,1947,[4687,4728,444,538],[204,204,10,9,2125],false],
['t2448',801,663,688,[4791,4834,589,718],[276,276,11,5,2898],false],
['t2449',801,688,663,[4728,4775,555,566],[47,47,11,1,523],false],
['t2450',806,663,689,[3331,3373,590,718],[274,274,11,5,2885],false],
['t2451',806,689,663,[3391,3437,555,566],[46,46,11,1,512],false],
['t2452',806,31,1948,[3437,3478,444,537],[204,204,10,9,2117],false],
['t2453',805,31,1949,[4268,4308,444,537],[204,204,10,9,2119],false],
['t2454',805,663,690,[4221,4267,555,566],[46,46,11,1,511],false],
['t2455',805,690,663,[4161,4204,589,718],[274,274,11,5,2880],false],
['t2456',1646,663,687,[4005,4065,556,722],[302,302,10,7,3060],false],
['t2457',1646,663,687,[4049,4060,664,722],[58,58,11,1,618],false],
['t2458',1646,663,688,[4836,4895,556,722],[303,303,10,7,3069],false],
['t2459',1646,663,688,[4879,4890,664,722],[58,58,11,1,618],false],
['t2460',1646,663,689,[3274,3285,664,722],[58,58,11,1,618],false],
['t2461',1646,663,689,[3269,3329,556,721],[303,303,10,7,3069],false],
['t2462',1646,663,690,[4105,4115,664,722],[57,57,11,1,615],false],
['t2463',1646,663,690,[4100,4159,556,722],[302,302,10,7,3060],false],
['t2465',687,663,1946,[3911,3952,444,534],[188,188,10,7,1983],false],
['t2466',687,663,1946,[3963,4006,444,526],[180,180,10,7,1892],false],
['t2468',688,663,1947,[4741,4783,444,535],[189,189,10,7,1995],false],
['t2469',688,663,1947,[4794,4836,444,526],[181,181,10,7,1903],false],
['t2470',689,663,1948,[3328,3370,444,526],[181,181,10,7,1896],false],
['t2472',689,663,1948,[3382,3423,444,534],[188,188,10,7,1983],false],
['t2474',690,663,1949,[4158,4201,444,526],[178,178,10,7,1866],false],
['t2475',690,1949,663,[4212,4254,444,534],[185,185,10,7,1959],false],
['t2476',687,1946,663,[4014,4076,185,457],[650,650,10,17,6608],false],
['t2477',687,1946,663,[3946,4076,121,171],[281,281,10,9,2865],false],
['t2478',687,1946,663,[4017,4076,447,526],[180,180,10,8,1914],false],
['t2479',688,663,1947,[4844,4907,185,457],[650,650,10,17,6608],false],
['t2480',688,663,1947,[4848,4907,447,526],[181,181,10,8,1920],false],
['t2481',688,663,1947,[4777,4907,121,171],[281,281,10,9,2862],false],
['t2482',689,663,1948,[3257,3319,185,457],[650,650,10,17,6608],false],
['t2483',689,663,1948,[3257,3387,121,171],[281,281,10,9,2862],false],
['t2484',689,663,1948,[3257,3316,447,526],[182,182,10,8,1929],false],
['t2485',690,663,1949,[4087,4150,185,457],[650,650,10,17,6608],false],
['t2486',690,663,1949,[4087,4217,121,171],[282,282,10,9,2868],false],
['t2487',690,663,1949,[4087,4146,447,526],[182,182,10,8,1929],false],
['t2488',663,663,691,[5487,5562,95,134],[100,100,14,2,1410],false],
['t2489',652,691,663,[4947,5087,190,396],[934,934,11,13,10686],false],
['t2490',652,691,663,[4941,5087,385,441],[244,244,12,4,2703],false],
['t2491',652,691,663,[4947,5141,124,202],[417,417,11,5,4780],false],
['t2492',1511,693,694,[916,931,3209,3223],[14,14,14,1,198],false],
['t2493',1511,696,695,[945,961,3248,3262],[16,16,14,1,213],false],
['t2494',979,663,700,[990,1012,3081,3165],[95,95,11,3,1001],false],
['t2495',846,663,2793,[971,981,3081,3214],[132,132,11,1,1424],false],
['t2496',695,2793,699,[953,963,3081,3214],[132,132,11,1,1410],false],
['t2497',693,663,699,[927,943,3073,3155],[87,87,10,3,906],false],
['t2498',698,697,663,[874,892,3082,3200],[123,123,11,4,1272],false],
['t2500',1507,698,699,[900,913,3047,3062],[15,15,13,1,197],false],
['t2504',84,663,82,[1047,1058,3131,3209],[78,78,10,1,808],false],
['t2507',697,663,84,[1118,1142,2953,3055],[115,115,10,3,1171],false],
['t2508',700,663,84,[1096,1106,2981,3083],[102,102,10,1,1025],false],
['t2509',891,663,84,[1128,1137,3094,3191],[97,97,9,1,886],false],
['t2510',851,663,84,[1096,1106,3126,3228],[103,103,9,1,971],false],
['t2512',705,84,663,[1147,1167,3062,3173],[120,120,11,3,1280],false],
['t2513',706,701,663,[1250,1259,3118,3199],[82,82,9,1,772],false],
['t2514',703,663,702,[1286,1296,3189,3233],[44,44,10,1,440],false],
['t2515',981,663,701,[1179,1189,3106,3173],[67,67,11,1,717],false],
['t2516',850,663,701,[1196,1217,3107,3182],[93,93,10,5,985],false],
['t2517',849,663,701,[1224,1237,3107,3173],[66,66,10,3,716],false],
['t2518',1511,703,704,[1275,1291,3272,3286],[15,15,14,1,214],false],
['t2519',1507,705,866,[1173,1188,3007,3020],[15,15,13,1,192],false],
['t2520',1507,866,706,[1263,1277,3009,3021],[15,15,12,1,184],false],
['t2521',1507,707,702,[1414,1429,3224,3237],[15,15,12,1,188],false],
['t2522',1511,709,708,[1478,1491,3203,3218],[15,15,13,1,188],false],
['t2524',715,663,711,[1590,1613,2992,3105],[126,126,10,3,1277],false],
['t2525',697,663,711,[1551,1577,2974,3084],[126,126,11,3,1328],false],
['t2526',700,663,711,[1532,1552,2974,3084],[120,120,10,3,1213],false],
['t2527',833,663,711,[1603,1615,3129,3233],[105,105,10,3,1079],false],
['t2528',12,663,711,[1578,1594,3126,3233],[114,114,10,3,1209],false],
['t2529',891,663,711,[1543,1573,3126,3233],[128,128,9,3,1232],false],
['t2532',714,713,663,[1404,1444,2980,3080],[130,130,10,5,1281],false],
['t2533',708,663,710,[1481,1496,3109,3162],[59,59,10,3,598],false],
['t2534',2,713,663,[1433,1465,3104,3186],[123,123,10,5,1289],false],
['t2535',707,663,713,[1410,1426,3071,3186],[121,121,10,3,1230],false],
['t2537',713,712,2794,[1339,1376,3015,3134],[236,236,10,5,2501],false],
['t2538',10,663,2794,[1318,1376,3050,3250],[247,247,11,5,2651],false],
['t2539',9,2794,663,[1384,1396,3030,3235],[206,206,10,3,2191],false],
['t2540',1507,714,710,[1448,1461,2918,2932],[14,14,12,1,173],false],
['t2541',1507,715,866,[1598,1611,2911,2927],[16,16,13,1,199],false],
['t2542',836,2795,2796,[1816,1827,2941,3118],[177,177,11,1,1888],false],
['t2543',717,663,2796,[1839,1880,3089,3191],[186,186,9,3,1774],false],
['t2544',11,663,2796,[1838,1848,3037,3064],[27,27,10,1,271],false],
['t2545',11,663,2796,[1829,1872,2906,3008],[158,158,10,4,1619],false],
['t2546',891,132,2795,[1798,1809,2941,3118],[177,177,11,1,1890],false],
['t2548',1651,718,663,[1925,1944,3037,3146],[118,118,11,3,1227],false],
['t2550',1192,717,663,[1894,1913,3060,3132],[81,81,11,3,836],false],
['t2552',1507,719,720,[2021,2035,3267,3281],[14,14,14,1,197],false],
['t2555',721,663,719,[2007,2018,3094,3159],[65,65,11,1,688],false],
['t2556',720,157,663,[1975,1985,3041,3112],[71,71,10,1,690],false],
['t2557',1511,125,721,[1985,1999,3197,3212],[15,15,14,1,201],false],
['t2559',723,165,663,[2083,2098,3077,3189],[118,118,10,3,1146],false],
['t2560',719,663,165,[2059,2075,3077,3189],[118,118,11,3,1266],false],
['t2561',1511,723,722,[2102,2115,3227,3242],[14,14,14,1,197],false],
['t2562',1507,724,718,[2319,2332,3038,3053],[15,15,13,1,196],false],
['t2563',1511,726,725,[2377,2391,3200,3215],[15,15,14,1,204],false],
['t2564',646,2797,726,[2350,2360,3080,3215],[135,135,10,1,1397],false],
['t2566',959,663,2797,[2301,2333,3138,3261],[156,156,10,3,1516],false],
['t2567',724,663,2797,[2323,2341,3080,3217],[145,145,10,3,1410],false],
['t2568',724,2798,663,[2247,2288,3036,3154],[146,146,11,6,1586],false],
['t2569',727,663,2798,[2230,2242,3023,3154],[132,132,11,3,1430],false],
['t2570',959,663,2798,[2197,2230,2999,3082],[105,105,11,2,1105],false],
['t2571',959,663,2798,[2197,2208,3112,3154],[43,43,10,1,443],false],
['t2572',958,722,2798,[2172,2263,2979,3054],[155,155,11,4,1636],false],
['t2573',851,663,727,[2146,2156,3118,3185],[67,67,10,1,693],false],
['t2577',733,663,86,[2463,2483,3047,3159],[120,120,10,5,1228],false],
['t2579',730,663,728,[2419,2439,3084,3159],[85,85,10,3,875],false],
['t2580',725,663,728,[2396,2411,3083,3159],[78,78,11,3,860],false],
['t2581',1511,730,727,[2444,2457,3200,3215],[14,14,14,1,195],false],
['t2582',1507,731,718,[2599,2612,3038,3053],[15,15,13,1,201],false],
['t2583',1309,663,448,[2698,2718,3092,3165],[83,83,10,3,828],false],
['t2585',694,448,663,[2679,2691,3093,3165],[73,73,10,3,746],false],
['t2586',646,663,732,[2650,2667,3093,3165],[79,79,11,3,839],false],
['t2587',727,732,663,[2629,2642,3098,3165],[68,68,10,3,709],false],
['t2589',959,732,663,[2598,2609,3111,3178],[66,66,10,1,685],false],
['t2590',731,663,732,[2573,2583,3115,3187],[72,72,10,1,719],false],
['t2591',1511,734,732,[2548,2562,3212,3228],[15,15,14,1,219],false],
['t2592',728,733,663,[2542,2562,3115,3187],[81,81,10,3,855],false],
['t2594',734,663,733,[2520,2535,3110,3187],[81,81,10,3,783],false],
['t2595',1507,866,735,[2743,2757,3014,3027],[15,15,13,1,190],false],
['t2597',835,2799,663,[2809,2820,3093,3227],[134,134,11,1,1465],false],
['t2598',846,450,2799,[2826,2837,3093,3227],[134,134,11,1,1409],false],
['t2599',697,443,663,[2778,2793,3089,3163],[79,79,10,3,801],false],
['t2600',735,663,443,[2756,2770,3080,3163],[85,85,10,3,893],false],
['t2604',740,663,736,[2921,2940,3077,3133],[70,70,10,4,726],false],
['t2605',737,663,738,[2874,2890,3065,3134],[71,71,10,5,741],false],
['t2606',1507,737,736,[2894,2908,3148,3162],[14,14,14,1,201],false],
['t2607',820,663,169,[3142,3162,3083,3154],[81,81,10,3,825],false],
['t2610',742,445,663,[3121,3131,3083,3149],[66,66,10,1,665],false],
['t2612',743,663,741,[3074,3093,3106,3162],[64,64,10,3,648],false],
['t2613',1507,742,741,[3115,3128,3203,3217],[14,14,13,1,185],false],
['t2614',1511,743,739,[3059,3073,3192,3207],[14,14,13,1,189],false],
['t2617',11,452,2800,[2970,2982,3038,3174],[137,137,11,3,1418],false],
['t2618',821,2800,663,[2987,3014,3048,3174],[141,141,10,4,1444],false],
['t2619',821,2801,739,[3033,3046,3074,3207],[134,134,10,3,1425],false],
['t2620',1138,663,2801,[3015,3029,3074,3207],[134,134,10,3,1455],false],
['t2621',1511,740,452,[2946,2959,3159,3174],[15,15,13,1,196],false],
['t2623',1081,167,663,[3292,3302,3050,3116],[66,66,10,1,647],false],
['t2624',772,167,2802,[3291,3301,3143,3274],[131,131,10,1,1320],false],
['t2625',1018,2802,663,[3274,3283,3143,3274],[131,131,10,1,1293],false],
['t2626',846,663,2803,[3239,3249,3141,3274],[133,133,10,1,1377],false],
['t2627',832,2803,167,[3221,3232,3141,3274],[133,133,10,1,1385],false],
['t2628',1365,2804,663,[3204,3256,3015,3120],[147,147,10,3,1519],false],
['t2629',694,167,2804,[3186,3205,2966,3100],[142,142,11,2,1473],false],
['t2630',833,746,663,[3410,3429,3068,3139],[80,80,10,3,850],false],
['t2632',746,663,2805,[3364,3381,3001,3128],[132,132,11,3.5,1322],false],
['t2634',12,2805,745,[3346,3361,3001,3128],[132,132,10,3,1353],false],
['t2635',796,663,747,[3538,3557,3093,3150],[66,66,10,3,663],false],
['t2636',747,663,424,[3516,3526,3093,3159],[66,66,9,1,624],false],
['t2639',748,663,424,[3516,3542,3186,3248],[77,77,10,2,769],false],
['t2640',835,424,2806,[3495,3506,3125,3256],[132,132,11,1,1403],false],
['t2641',1359,2806,663,[3477,3488,3125,3256],[132,132,10,1,1365],false],
['t2642',1507,748,749,[3549,3565,3262,3278],[15,15,15,1,232],false],
['t2645',753,663,751,[3629,3650,3059,3115],[67,67,11,3,715],false],
['t2646',750,663,458,[3581,3600,3078,3151],[82,82,10,3,793],false],
['t2647',1507,750,751,[3604,3618,3163,3177],[14,14,14,1,198],false],
['t2648',1511,753,454,[3633,3647,3210,3224],[14,14,14,1,194],false],
['t2649',835,426,663,[3757,3767,3091,3157],[66,66,10,1,660],false],
['t2650',850,663,426,[3730,3740,3137,3204],[67,67,11,1,711],false],
['t2652',833,421,663,[3681,3702,3041,3109],[79,79,10,3,797],false],
['t2653',833,663,426,[3717,3740,3041,3109],[80,80,10,3,833],false],
['t2655',795,428,663,[3818,3835,3057,3133],[82,82,11,3,894],false],
['t2656',954,460,663,[3792,3808,3057,3133],[82,82,10,3,855],false],
['t2660',1507,755,754,[3892,3905,3048,3062],[14,14,14,1,189],false],
['t2661',756,663,755,[3866,3885,3078,3136],[67,67,10,3,649],false],
['t2663',833,462,663,[3948,3967,3079,3154],[90,90,10,5,901],false],
['t2664',754,663,462,[3928,3939,3075,3141],[67,67,11,1,707],false],
['t2665',759,663,462,[3928,3938,3165,3230],[66,66,10,1,660],false],
['t2666',1511,756,757,[3870,3883,3225,3238],[13,13,13,1,177],false],
['t2667',1507,749,759,[3916,3931,3263,3277],[15,15,15,1,218],false],
['t2670',793,663,430,[4027,4043,3059,3134],[81,81,10,3,810],false],
['t2671',792,760,663,[4002,4015,3059,3125],[67,67,10,3,718],false],
['t2672',832,2807,663,[4163,4183,3009,3148],[150,150,10,5,1586],false],
['t2673',1359,432,2807,[4145,4155,3009,3142],[132,132,10,1,1370],false],
['t2676',1583,663,432,[4121,4134,3075,3142],[68,68,10,3,727],false],
['t2677',762,761,663,[4094,4104,3091,3134],[43,43,10,1,434],false],
['t2678',1507,1583,761,[4077,4091,3196,3209],[13,13,14,1,181],false],
['t2679',1511,762,796,[4141,4154,3227,3242],[15,15,12,1,184],false],
['t2680',1160,763,2808,[4314,4360,3184,3265],[116,116,10,3,1249],false],
['t2681',1010,2809,663,[4277,4307,3069,3159],[109,109,10,2,1124],false],
['t2682',791,2808,663,[4296,4342,3184,3265],[116,116,11,3,1271],false],
['t2684',764,763,2809,[4314,4324,3057,3159],[103,103,10,1,1063],false],
['t2686',718,663,764,[4234,4251,3058,3132],[81,81,10,3,798],false],
['t2688',471,2810,436,[4461,4472,3014,3212],[198,198,11,1,2166],false],
['t2690',468,2811,2810,[4444,4454,3014,3212],[198,198,10,1,2048],false],
['t2691',434,663,2811,[4426,4436,3014,3212],[198,198,10,1,2050],false],
['t2692',1041,765,663,[4390,4401,2989,3160],[171,171,11,1,1872],false],
['t2693',763,663,765,[4361,4380,2989,3160],[180,180,10,3,1895],false],
['t2694',1507,766,767,[844,857,3300,3315],[16,16,13,1,209],false],
['t2696',1511,770,12,[639,653,3008,3021],[14,14,12,1,173],false],
['t2697',1507,768,771,[545,558,2987,3002],[15,15,13,1,193],false],
['t2699',771,772,663,[548,562,3037,3177],[145,145,10,3,1405],false],
['t2700',1364,663,775,[4615,4625,3228,3293],[65,65,11,1,695],false],
['t2701',694,663,536,[4713,4731,3057,3165],[116,116,10,3,1200],false],
['t2702',697,536,663,[4688,4706,3057,3165],[116,116,10,3,1190],false],
['t2704',775,536,663,[4665,4678,3070,3173],[104,104,10,3,1084],false],
['t2706',891,663,775,[4610,4627,3115,3188],[79,79,10,3,833],false],
['t2707',788,663,775,[4582,4593,3205,3271],[66,66,11,1,720],false],
['t2708',835,663,775,[4582,4595,3116,3182],[67,67,10,3,701],false],
['t2710',774,663,775,[4585,4596,3013,3079],[66,66,10,1,685],false],
['t2711',535,774,663,[4526,4566,3022,3066],[73,73,10,2,744],false],
['t2712',1041,486,663,[4807,4817,3014,3078],[64,64,10,1,656],false],
['t2714',776,486,663,[4782,4798,3014,3083],[74,74,10,3,765],false],
['t2715',1511,479,776,[4772,4785,3226,3240],[14,14,13,1,189],false],
['t2717',780,663,528,[4883,4892,3104,3169],[65,65,10,1,625],false],
['t2718',778,663,528,[4852,4862,3104,3169],[65,65,10,1,625],false],
['t2719',1507,310,1582,[4892,4905,3050,3064],[14,14,13,1,181],false],
['t2720',1511,483,778,[4842,4857,3219,3233],[15,15,14,1,212],false],
['t2721',1511,780,779,[4864,4878,3219,3233],[14,14,14,1,199],false],
['t2722',987,2812,781,[5001,5011,3005,3136],[131,131,10,1,1317],false],
['t2723',1107,2813,781,[4974,4984,3078,3211],[134,134,11,1,1453],false],
['t2724',784,663,2812,[5018,5029,3005,3136],[131,131,11,1,1400],false],
['t2726',530,2814,781,[4974,4996,2909,3039],[143,143,11,4,1487],false],
['t2727',1582,2813,663,[4956,4967,3078,3211],[134,134,10,1,1383],false],
['t2728',783,663,2814,[4921,4963,2910,3000],[144,144,10,3,1423],false],
['t2729',1511,782,783,[4931,4944,3228,3241],[14,14,13,1,185],false],
['t2730',787,785,663,[5083,5098,2992,3081],[94,94,10,3,948],false],
['t2731',1511,784,785,[5057,5069,3033,3047],[14,14,13,1,186],false],
['t2733',1507,781,787,[5072,5086,3201,3215],[14,14,14,1,189],false],
['t2734',944,788,2815,[4635,4648,3379,3585],[208,208,11,5,2209],false],
['t2735',1392,789,663,[4532,4552,3461,3532],[80,80,10,3,827],false],
['t2736',1095,663,789,[4559,4570,3466,3532],[66,66,11,1,721],false],
['t2737',125,2815,663,[4617,4631,3379,3585],[208,208,11,5,2179],false],
['t2739',851,663,535,[4510,4540,3554,3619],[84,84,11,3,903],false],
['t2740',789,663,535,[4510,4522,3461,3531],[71,71,10,3,692],false],
['t2743',1010,663,791,[4378,4395,3431,3496],[71,71,11,3,745],false],
['t2745',1344,2816,464,[4295,4305,3504,3637],[132,132,10,1,1332],false],
['t2746',825,663,464,[4270,4280,3545,3610],[65,65,10,1,683],false],
['t2747',832,663,2816,[4312,4322,3504,3637],[132,132,11,1,1410],false],
['t2748',924,663,464,[4239,4259,3566,3630],[74,74,10,2,708],false],
['t2750',1385,663,793,[4178,4189,3535,3580],[45,45,11,1,478],false],
['t2751',1355,663,792,[4132,4141,3511,3563],[51,51,10,1,492],false],
['t2752',1063,793,663,[4155,4165,3543,3587],[44,44,10,1,453],false],
['t2753',1022,663,792,[4106,4124,3513,3563],[57,57,11,3,612],false],
['t2754',1430,663,793,[4209,4219,3535,3580],[45,45,10,1,452],false],
['t2757',1378,2817,663,[4051,4065,3395,3528],[134,134,10,3,1388],false],
['t2758',879,2817,757,[4033,4047,3395,3528],[134,134,11,3,1437],false],
['t2760',1019,663,795,[3987,4006,3489,3561],[81,81,10,3,835],false],
['t2761',1441,663,795,[3960,3980,3488,3561],[82,82,11,3,884],false],
['t2763',1366,663,2818,[3781,3853,3499,3583],[146,146,11,3,1525],false],
['t2764',828,663,454,[3887,3897,3538,3604],[66,66,10,1,646],false],
['t2765',879,2818,454,[3802,3874,3499,3583],[146,146,10,3,1519],false],
['t2766',953,646,663,[3750,3779,3395,3583],[207,207,10,4,2194],false],
['t2768',1393,663,2819,[3653,3694,3520,3637],[148,148,10,3,1503],false],
['t2769',799,663,749,[3701,3720,3476,3548],[81,81,11,3,859],false],
['t2770',879,2819,796,[3635,3677,3520,3637],[147,147,11,3,1608],false],
['t2771',1512,749,663,[3684,3693,3484,3548],[64,64,9,1,607],false],
['t2774',1041,663,797,[3568,3600,3536,3598],[83,83,10,3,856],false],
['t2776',1511,799,798,[3715,3730,3587,3601],[15,15,15,1,219],false],
['t2777',1512,800,663,[3457,3472,3516,3581],[66,66,12,3,857],false],
['t2779',574,663,801,[4575,4678,567,719],[488,488,11,9,5115],false],
['t2780',1646,663,801,[4517,4597,555,719],[440,440,10,13,4553],false],
['t2782',809,663,802,[3745,3848,567,719],[489,489,11,9,5121],false],
['t2783',1646,663,802,[3687,3766,555,719],[440,440,10,13,4553],false],
['t2785',811,663,803,[2107,2209,567,719],[489,489,11,9,5119],false],
['t2786',1646,663,803,[2049,2128,555,719],[440,440,10,13,4553],false],
['t2788',813,663,804,[2681,2782,567,719],[484,484,11,9,5071],false],
['t2789',1646,663,804,[2760,2840,555,719],[440,440,10,13,4553],false],
['t2791',815,663,805,[4319,4420,567,719],[485,485,11,9,5084],false],
['t2792',1646,663,805,[4398,4478,555,719],[440,440,10,13,4553],false],
['t2794',817,663,806,[3489,3589,567,719],[485,485,11,9,5079],false],
['t2795',1646,663,806,[3568,3647,555,719],[440,440,10,13,4553],false],
['t2797',819,663,807,[1850,1951,567,719],[485,485,11,9,5080],false],
['t2798',1646,663,807,[1930,2009,555,719],[440,440,10,13,4553],false],
['t2799',1647,809,808,[3840,3853,624,661],[36,36,13,1,483],false],
['t2800',256,808,663,[3866,3928,597,717],[233,233,10,9,2407],false],
['t2802',1647,811,810,[2202,2215,624,661],[36,36,13,1,483],false],
['t2803',266,810,663,[2228,2290,597,717],[233,233,10,9,2407],false],
['t2805',1647,813,812,[2673,2687,624,661],[36,36,13,1,483],false],
['t2806',257,812,663,[2598,2660,597,717],[233,233,10,9,2407],false],
['t2808',1647,815,814,[4311,4325,624,661],[36,36,13,1,483],false],
['t2809',259,814,663,[4236,4298,597,717],[233,233,10,9,2407],false],
['t2811',1647,817,816,[3481,3494,624,661],[36,36,13,1,483],false],
['t2812',265,816,663,[3406,3467,597,717],[233,233,10,9,2407],false],
['t2814',1647,819,818,[1843,1856,624,661],[36,36,13,1,483],false],
['t2815',258,818,663,[1768,1829,597,717],[233,233,10,9,2407],false],
['t2817',1407,820,663,[3105,3116,3444,3513],[69,69,11,1,774],false],
['t2818',911,663,820,[3123,3147,3446,3513],[81,81,10,3,815],false],
['t2821',946,821,663,[3074,3090,3444,3512],[74,74,10,3,730],false],
['t2824',903,823,663,[3047,3058,3544,3625],[80,80,11,1,858],false],
['t2825',902,822,663,[3016,3027,3544,3588],[44,44,11,1,465],false],
['t2826',1507,824,822,[2974,2987,3295,3309],[14,14,13,1,185],false],
['t2827',824,825,663,[2968,2978,3476,3540],[65,65,9,1,613],false],
['t2829',827,663,826,[2890,2901,3526,3570],[44,44,11,1,474],false],
['t2831',1512,663,827,[2833,2848,3486,3553],[67,67,14,1.5,853],false],
['t2832',829,663,828,[2789,2808,3462,3533],[80,80,10,3,807],false],
['t2834',1507,826,829,[2809,2825,3374,3387],[16,16,13,1,213],false],
['t2835',1512,830,663,[2696,2709,3519,3586],[68,68,13,1,883],false],
['t2836',956,2820,663,[2641,2655,3417,3550],[134,134,10,3,1385],false],
['t2837',830,831,2820,[2659,2672,3417,3550],[134,134,10,3,1363],false],
['t2839',957,663,833,[2565,2584,3463,3636],[183,183,10,5,1844],false],
['t2840',834,663,832,[2610,2631,3398,3672],[292,292,10,5,3015],false],
['t2841',1507,834,831,[2620,2634,3303,3327],[24,24,14,1,324],false],
['t2845',906,835,663,[3218,3300,3555,3754],[268,268,11,4,2863],false],
['t2846',1512,663,837,[2444,2454,3508,3571],[64,64,10,1,637],false],
['t2847',1512,663,836,[2481,2495,3508,3571],[65,65,10,3,659],false],
['t2851',11,837,663,[2412,2421,3521,3588],[67,67,9,1,617],false],
['t2853',891,129,2821,[2218,2295,3407,3480],[146,146,10,3,1518],false],
['t2854',837,2821,663,[2278,2342,3389,3512],[177,177,10,6,1802],false],
['t2855',872,838,663,[2364,2397,3548,3704],[280,280,10,3,2789],false],
['t2856',1372,1951,663,[2196,2222,3910,4043],[147,147,11,3,1561],false],
['t2857',1372,839,663,[2328,2338,3615,3659],[44,44,10,1,427],false],
['t2858',839,2822,841,[2173,2183,3680,3812],[132,132,9,1,1248],false],
['t2860',841,663,840,[2229,2238,3588,3653],[65,65,9,1,599],false],
['t2863',1149,2822,663,[2258,2271,3522,3653],[135,135,10,3,1319],false],
['t2864',965,663,2822,[2282,2294,3522,3654],[133,133,9,3,1281],false],
['t2865',1321,663,1951,[2176,2186,3910,4043],[132,132,10,1,1368],false],
['t2866',835,1951,841,[2144,2165,3904,4043],[149,149,10,3,1501],false],
['t2867',1039,2823,841,[2119,2137,3910,4115],[212,212,10,3,2199],false],
['t2868',1426,2824,2823,[2102,2119,3910,4115],[212,212,10,3,2138],false],
['t2869',860,663,2824,[2084,2102,3910,4115],[212,212,10,3,2154],false],
['t2871',891,127,663,[2159,2198,3425,3480],[82,82,10,3,859],false],
['t2872',844,663,842,[2145,2156,3448,3550],[103,103,11,1,1092],false],
['t2875',123,2825,663,[2005,2063,3451,3624],[221,221,11,3.5,2401],false],
['t2877',840,123,663,[2072,2111,3458,3530],[102,102,10,3,1026],false],
['t2878',711,121,2825,[1978,2044,3451,3618],[224,224,10,4,2263],false],
['t2879',969,2826,709,[2001,2012,3920,4118],[198,198,11,1,2091],false],
['t2880',1320,2827,2826,[1984,1994,3920,4118],[198,198,11,1,2105],false],
['t2882',874,663,2827,[1966,1977,3920,4118],[198,198,11,1,2221],false],
['t2883',1507,881,844,[2067,2080,3829,3843],[14,14,13,1,177],false],
['t2884',1081,663,704,[1911,1921,3494,3561],[67,67,10,1,689],false],
['t2885',1348,2828,704,[1935,1959,3755,3887],[146,146,11,3,1554],false],
['t2886',874,2828,663,[1952,1976,3755,3887],[146,146,10,3,1507],false],
['t2887',850,663,704,[1911,1921,3585,3649],[64,64,10,1,629],false],
['t2888',851,663,704,[1884,1894,3585,3650],[65,65,9,1,596],false],
['t2889',1320,2829,704,[1842,1853,3560,3692],[132,132,11,1,1449],false],
['t2890',835,2830,704,[1911,1921,3916,4049],[133,133,10,1,1334],false],
['t2891',1371,663,2830,[1893,1903,3916,4049],[133,133,11,1,1413],false],
['t2894',879,663,2829,[1825,1835,3560,3692],[132,132,10,1,1331],false],
['t2895',1439,846,663,[1802,1811,3626,3692],[66,66,10,1,643],false],
['t2896',856,849,663,[1640,1685,3519,3698],[214,214,10,3,2221],false],
['t2899',1186,663,848,[1724,1734,3698,3800],[102,102,10,1,1055],false],
['t2901',847,848,663,[1712,1744,3884,3974],[112,112,10,2,1105],false],
['t2902',852,663,847,[1742,1753,3918,3984],[66,66,10,1,686],false],
['t2903',1512,663,847,[1760,1779,3918,3990],[83,83,10,5,829],false],
['t2906',854,663,851,[1590,1605,3866,3975],[115,115,10,3,1174],false],
['t2907',1512,851,663,[1614,1631,3866,3975],[117,117,10,3,1168],false],
['t2908',971,663,850,[1644,1673,3824,4028],[223,223,10,3,2232],false],
['t2909',1511,852,4,[1740,1756,4023,4035],[16,16,12,1,190],false],
['t2910',1507,855,854,[1597,1611,4031,4045],[14,14,14,1,186],false],
['t2911',1507,856,848,[1634,1647,3413,3434],[21,21,13,1,269],false],
['t2912',1511,851,857,[1610,1623,3616,3630],[14,14,13,1,184],false],
['t2914',858,663,860,[1482,1514,3479,3528],[72,72,10,2,743],false],
['t2915',1507,858,859,[1551,1564,3533,3547],[14,14,13,1,175],false],
['t2916',1512,857,663,[1560,1573,3466,3494],[28,28,13,1,353],false],
['t2917',857,663,859,[1578,1591,3522,3566],[46,46,9,3,432],false],
['t2919',870,663,696,[1460,1473,3506,3610],[105,105,10,3,1020],false],
['t2922',864,861,2831,[1498,1517,3858,3952],[103,103,10,3,1094],false],
['t2923',971,2831,663,[1515,1535,3858,3952],[103,103,11,3,1112],false],
['t2924',1512,862,663,[1429,1442,3466,3536],[70,70,13,1,909],false],
['t2925',865,663,864,[1278,1305,3499,3531],[49,49,10,2,485],false],
['t2927',1507,866,865,[1291,1305,3563,3577],[14,14,14,1,197],false],
['t2928',867,663,866,[1339,1358,3501,3639],[147,147,10,3,1480],false],
['t2930',1511,868,867,[1327,1340,3690,3703],[14,14,13,1,176],false],
['t2931',1507,870,869,[1458,1473,3654,3668],[15,15,13,1,205],false],
['t2932',1336,663,2832,[1410,1430,3777,3916],[149,149,11,3,1576],false],
['t2933',862,2832,869,[1427,1448,3777,3916],[149,149,10,3,1511],false],
['t2935',1511,835,862,[1432,1445,3948,3963],[14,14,13,1,184],false],
['t2936',1507,872,873,[2339,2360,3708,3720],[21,21,12,1,255],false],
['t2940',878,873,663,[2344,2357,3943,4007],[65,65,10,3,679],false],
['t2941',877,663,874,[2311,2321,3937,4007],[71,71,10,1,711],false],
['t2942',876,663,875,[2255,2274,3936,4007],[79,79,10,3,811],false],
['t2943',1511,876,877,[2263,2278,4040,4054],[15,15,14,1,205],false],
['t2944',1511,878,879,[2336,2352,4040,4054],[15,15,14,1,214],false],
['t2946',885,663,880,[2517,2530,3863,3936],[73,73,10,3,754],false],
['t2947',884,881,663,[2489,2506,3863,3936],[79,79,10,3,821],false],
['t2948',882,663,881,[2470,2481,3868,3936],[68,68,11,1,725],false],
['t2950',1512,663,881,[2470,2480,3779,3845],[66,66,10,1,663],false],
['t2951',1511,882,960,[2479,2494,3996,4011],[15,15,15,1,228],false],
['t2952',1511,884,883,[2501,2516,3996,4011],[15,15,15,1,219],false],
['t2953',1329,2833,663,[2706,2719,3826,3955],[130,130,10,3,1388],false],
['t2954',1400,1952,885,[2658,2684,3819,3955],[150,150,10,5,1482],false],
['t2955',772,885,2833,[2687,2702,3826,3955],[130,130,11,3,1463],false],
['t2957',835,663,1952,[2618,2642,3887,4019],[145,145,10,5,1504],false],
['t2958',832,663,1952,[2646,2663,3861,3993],[140,140,10,4,1473],false],
['t2959',696,663,1952,[2600,2612,3891,4019],[129,129,10,3,1360],false],
['t2960',914,1952,663,[2569,2587,3887,4028],[148,148,11,3,1528],false],
['t2961',911,663,1952,[2602,2645,3776,3866],[148,148,10,4,1461],false],
['t2962',888,694,663,[2867,2887,3878,3992],[135,135,10,5,1337],false],
['t2963',772,663,2834,[2852,2940,4047,4057],[88,88,10,1,909],false],
['t2965',1512,694,663,[2847,2870,3877,3992],[127,127,11,3,1335],false],
['t2966',1358,2834,886,[2852,2940,4064,4075],[88,88,11,1,974],false],
['t2968',1507,889,888,[2898,2910,3803,3818],[15,15,13,1,187],false],
['t2969',1511,772,830,[2819,2835,3740,3755],[16,16,15,1,236],false],
['t2970',1511,892,891,[2892,2904,3709,3725],[15,15,13,1,192],false],
['t2971',895,889,663,[2964,2974,3942,4007],[65,65,10,1,657],false],
['t2972',892,889,663,[2961,2974,3849,3918],[71,71,9,3,670],false],
['t2975',893,663,889,[2938,2952,3905,3970],[67,67,10,3,708],false],
['t2976',898,893,663,[2911,2931,3905,3977],[82,82,10,3,812],false],
['t2977',900,663,897,[3060,3071,3862,3907],[45,45,10,1,467],false],
['t2979',1507,896,897,[3033,3046,3903,3916],[13,13,13,1,173],false],
['t2980',896,663,894,[3059,3069,3943,3987],[44,44,10,1,438],false],
['t2982',1511,895,894,[3043,3058,4002,4016],[15,15,13,1,197],false],
['t2983',1511,898,886,[2989,3001,4060,4076],[15,15,12,1,184],false],
['t2984',1511,825,827,[3089,3102,4002,4024],[22,22,13,1,289],false],
['t2985',1511,900,828,[3041,3055,3773,3787],[14,14,13,1,187],false],
['t2986',1511,902,823,[3160,3173,3710,3724],[15,15,13,1,192],false],
['t2987',1507,904,903,[3186,3199,3843,3858],[15,15,13,1,197],false],
['t2988',12,2835,663,[3421,3432,3851,4056],[205,205,11,1,2245],false],
['t2990',1329,663,2836,[3357,3376,3891,4028],[146,146,10,3,1499],false],
['t2991',1329,125,2835,[3404,3414,3851,4056],[205,205,10,1,2060],false],
['t2993',909,2836,907,[3339,3358,3891,4028],[146,146,10,3,1501],false],
['t2994',1507,906,907,[3314,3326,3885,3907],[22,22,12,1,262],false],
['t2995',1511,909,832,[3338,3352,4064,4078],[14,14,14,1,200],false],
['t2997',1507,910,912,[3582,3597,4108,4122],[14,14,14,1,197],false],
['t2998',910,663,911,[3584,3594,3971,4074],[103,103,9,1,973],false],
['t2999',800,912,663,[3552,3565,3971,4036],[65,65,10,3,684],false],
['t3001',917,2837,663,[3676,3705,3851,3978],[144,144,10,5,1440],false],
['t3002',1511,800,914,[3645,3658,4008,4029],[21,21,13,1,283],false],
['t3003',913,663,914,[3628,3638,3933,3999],[66,66,10,1,666],false],
['t3004',797,915,2837,[3659,3688,3851,3978],[145,145,10,5,1455],false],
['t3007',1507,913,915,[3633,3646,3885,3898],[13,13,13,1,173],false],
['t3008',1511,917,696,[3694,3709,4015,4027],[14,14,12,1,176],false],
['t3009',1327,2838,663,[3947,3958,3885,4017],[132,132,11,1,1443],false],
['t3010',879,919,2838,[3930,3940,3885,4017],[132,132,10,1,1326],false],
['t3012',920,918,663,[3975,3988,3873,3917],[45,45,10,3,447],false],
['t3014',1511,919,920,[3953,3968,3726,3739],[15,15,14,1,201],false],
['t3015',1385,663,924,[4224,4235,3953,3998],[44,44,11,1,475],false],
['t3016',1061,2839,924,[4228,4238,3829,3916],[87,87,10,1,902],false],
['t3017',1511,921,925,[4156,4170,3958,3973],[15,15,14,1,201],false],
['t3018',1019,663,925,[4134,4144,3860,3902],[43,43,10,1,443],false],
['t3019',921,663,923,[4177,4194,3870,3919],[56,56,10,3,590],false],
['t3020',922,2839,663,[4208,4219,3817,3904],[87,87,11,1,953],false],
['t3021',1507,922,923,[4174,4188,3787,3801],[14,14,14,1,189],false],
['t3025',1394,2840,434,[4364,4380,3821,3952],[137,137,11,3,1487],false],
['t3026',1394,663,2841,[4381,4392,4011,4143],[132,132,11,1,1486],false],
['t3027',879,2842,663,[4409,4423,3821,3952],[133,133,11,3,1479],false],
['t3028',879,2840,663,[4382,4398,3821,3952],[137,137,11,3,1467],false],
['t3029',1396,2842,468,[4427,4440,3821,3952],[133,133,10,3,1378],false],
['t3030',1160,2841,1068,[4364,4375,4011,4143],[132,132,11,1,1448],false],
['t3033',1442,663,2843,[4489,4507,3857,3994],[147,147,10,5,1554],false],
['t3034',926,2843,471,[4515,4525,3845,3978],[133,133,11,1,1419],false],
['t3035',850,663,926,[4552,4566,3888,3953],[74,74,10,5,747],false],
['t3037',1367,663,2843,[4465,4481,3857,3994],[139,139,10,3,1428],false],
['t3039',1438,2844,663,[4723,4737,3852,3991],[141,141,11,5,1514],false],
['t3040',879,479,2844,[4706,4719,3852,3991],[141,141,10,5,1497],false],
['t3042',1396,483,663,[4835,4851,3867,3935],[73,73,11,3,806],false],
['t3043',1092,663,483,[4814,4828,3864,3935],[72,72,10,3,759],false],
['t3044',1094,2845,527,[4769,4784,3852,3990],[140,140,10,3,1464],false],
['t3045',926,663,2845,[4787,4801,3852,3990],[140,140,11,3,1507],false],
['t3046',850,483,663,[4841,4852,3778,3844],[66,66,11,1,721],false],
['t3049',943,663,779,[4884,4895,3873,3938],[65,65,11,1,685],false],
['t3050',850,663,779,[4885,4894,3785,3850],[64,64,10,1,627],false],
['t3052',931,663,891,[913,1031,3510,3659],[257,257,10,8,2669],false],
['t3056',933,928,2846,[1039,1049,3791,3924],[133,133,10,1,1298],false],
['t3057',940,2846,663,[1057,1066,3791,3924],[133,133,9,1,1259],false],
['t3058',938,663,930,[1089,1099,3858,3924],[66,66,10,1,662],false],
['t3060',936,2847,929,[1133,1143,3813,3947],[134,134,10,1,1381],false],
['t3061',934,663,2847,[1151,1161,3813,3947],[134,134,10,1,1383],false],
['t3062',1507,931,1087,[1011,1033,3692,3706],[22,22,14,1,319],false],
['t3064',1077,663,932,[996,1007,3897,3964],[67,67,11,1,728],false],
['t3065',1511,932,933,[1017,1030,3948,3964],[15,15,14,1,209],false],
['t3066',1511,934,935,[1202,1217,3993,4007],[15,15,15,1,223],false],
['t3067',1511,936,937,[1152,1167,3993,4007],[15,15,14,1,214],false],
['t3068',1511,938,939,[1078,1093,3981,3995],[15,15,14,1,209],false],
['t3069',1511,940,941,[1054,1070,3981,3995],[15,15,14,1,209],false],
['t3071',1160,942,663,[3443,3454,4389,4433],[43,43,11,1,481],false],
['t3072',1160,663,2848,[3407,3422,4293,4492],[200,200,10,5,2091],false],
['t3073',1326,2848,2849,[3390,3403,4293,4492],[200,200,11,3,2180],false],
['t3075',945,2849,943,[3372,3384,4293,4492],[200,200,10,3,2004],false],
['t3076',1440,663,943,[3368,3388,4721,4796],[83,83,11,3,907],false],
['t3077',879,663,2850,[3280,3299,4355,4501],[155,155,10,5,1628],false],
['t3079',1435,2850,944,[3263,3282,4355,4497],[151,151,10,3,1551],false],
['t3080',1415,663,944,[3216,3230,4757,4822],[66,66,10,3,730],false],
['t3081',880,663,944,[3221,3237,4643,4719],[82,82,10,3,856],false],
['t3082',1389,663,2851,[3211,3237,4355,4507],[178,178,11,5,1825],false],
['t3083',838,2851,944,[3235,3255,4362,4507],[153,153,11,5,1679],false],
['t3084',1337,663,2851,[3193,3203,4355,4487],[132,132,10,1,1322],false],
['t3085',1342,663,945,[3279,3293,4641,4707],[67,67,11,3,718],false],
['t3088',1383,2852,947,[3053,3066,4462,4596],[134,134,10,3,1437],false],
['t3089',1420,663,947,[3031,3045,4593,4662],[70,70,10,3,739],false],
['t3091',832,663,2852,[3054,3063,4309,4440],[131,131,9,1,1237],false],
['t3092',948,2853,663,[3022,3033,4323,4455],[133,133,11,1,1452],false],
['t3093',879,946,2853,[3023,3034,4153,4286],[132,132,11,1,1449],false],
['t3094',1511,832,950,[2974,2989,4471,4482],[14,14,11,1,160],false],
['t3095',1512,663,950,[2963,2975,4357,4431],[74,74,12,1,919],false],
['t3096',1353,663,954,[2969,2983,4695,4760],[67,67,11,3,731],false],
['t3097',919,663,954,[2970,2986,4607,4671],[66,66,10,5,691],false],
['t3098',1376,663,954,[2947,2956,4685,4751],[66,66,10,1,646],false],
['t3099',1325,2854,663,[2922,2933,4681,4769],[88,88,11,1,932],false],
['t3101',950,904,2854,[2905,2916,4681,4769],[88,88,11,1,958],false],
['t3102',1511,952,951,[2926,2941,4499,4512],[15,15,14,1.5,201],false],
['t3103',952,663,953,[2876,2904,4442,4511],[85,85,10,5,894],false],
['t3106',838,951,2855,[2919,2929,4355,4444],[88,88,10,1,888],false],
['t3108',1428,2855,663,[2886,2912,4349,4444],[110,110,10,3,1155],false],
['t3109',1381,663,956,[2798,2809,4656,4700],[44,44,12,1,510],false],
['t3111',1350,2856,957,[2678,2692,4367,4499],[133,133,10,3,1355],false],
['t3112',835,663,2856,[2695,2708,4367,4499],[133,133,10,3,1385],false],
['t3114',1411,957,663,[2682,2693,4581,4648],[67,67,11,1,751],false],
['t3115',1423,663,957,[2657,2671,4580,4656],[80,80,10,3,754],false],
['t3116',945,2857,957,[2656,2666,4396,4529],[132,132,10,1,1370],false],
['t3117',1403,663,2857,[2638,2648,4396,4529],[132,132,10,1,1348],false],
['t3118',835,663,2858,[2576,2587,4387,4520],[132,132,11,1,1425],false],
['t3119',1357,2858,958,[2558,2569,4387,4520],[132,132,11,1,1395],false],
['t3120',880,663,958,[2530,2542,4650,4717],[67,67,11,3,719],false],
['t3121',1410,663,958,[2531,2542,4559,4624],[66,66,10,3,659],false],
['t3122',1421,663,958,[2531,2545,4443,4508],[66,66,11,3,688],false],
['t3124',1399,959,663,[2507,2522,4406,4472],[68,68,11,3,768],false],
['t3125',1349,663,959,[2485,2501,4407,4472],[71,71,11,3,770],false],
['t3127',1373,883,663,[2459,2473,4407,4450],[45,45,10,3,469],false],
['t3128',1322,663,883,[2436,2449,4408,4450],[44,44,10,3,461],false],
['t3129',1427,663,883,[2412,2426,4408,4451],[44,44,10,3,484],false],
['t3132',838,663,960,[2385,2395,4281,4346],[65,65,9,1,617],false],
['t3133',1512,879,663,[2364,2383,4406,4712],[327,327,10,7,3334],false],
['t3134',1356,663,879,[2339,2357,4406,4703],[322,322,11,11,3419],false],
['t3135',1380,879,663,[2315,2333,4406,4703],[312,312,10,9,3332],false],
['t3136',1328,663,879,[2290,2308,4406,4703],[317,317,10,7,3255],false],
['t3137',963,879,663,[2267,2284,4406,4703],[307,307,10,7,3091],false],
['t3139',1507,875,962,[2221,2243,4204,4218],[22,22,14,1,319],false],
['t3141',962,663,963,[2214,2224,4373,4483],[110,110,10,1,1105],false],
['t3142',1405,663,963,[2220,2236,4517,4626],[115,115,10,3,1219],false],
['t3143',1419,663,963,[2194,2208,4517,4626],[111,111,11,3,1229],false],
['t3144',860,877,663,[2092,2105,4351,4416],[67,67,10,3,686],false],
['t3145',1418,877,663,[2092,2102,4440,4505],[65,65,10,1,673],false],
['t3147',967,663,877,[2067,2080,4351,4416],[67,67,10,3,725],false],
['t3149',1379,663,965,[2070,2081,4639,4706],[67,67,11,1,729],false],
['t3150',966,965,663,[2046,2059,4639,4706],[68,68,9,3,662],false],
['t3152',1422,663,966,[2018,2031,4639,4706],[68,68,10,3,730],false],
['t3153',1507,967,866,[2059,2074,4489,4504],[15,15,14,1,218],false],
['t3154',704,970,663,[1940,1963,4647,4747],[135,135,10,6,1392],false],
['t3155',1398,663,969,[1978,1989,4666,4710],[44,44,11,1,466],false],
['t3158',1341,4,2859,[1751,1761,4505,4711],[206,206,9,1,1940],false],
['t3159',973,2859,663,[1731,1743,4512,4711],[199,199,10,3,1917],false],
['t3160',976,663,2860,[1682,1712,4258,4464],[223,223,11,5,2449],false],
['t3161',860,2860,4,[1703,1730,4262,4464],[218,218,11,3,2381],false],
['t3163',1149,663,4,[1751,1760,4364,4463],[99,99,9,1,937],false],
['t3164',1408,971,663,[1781,1794,4408,4474],[67,67,10,3,692],false],
['t3165',1412,663,971,[1801,1816,4400,4474],[76,76,11,3,842],false],
['t3166',1507,866,973,[1691,1706,4521,4533],[15,15,12,1,179],false],
['t3167',978,663,2861,[1539,1551,4376,4480],[105,105,11,3,1101],false],
['t3170',1388,2861,767,[1557,1569,4376,4480],[104,104,11,3,1115],false],
['t3171',977,663,976,[1601,1620,4426,4480],[62,62,11,3,666],false],
['t3174',697,663,4,[1640,1662,4643,4749],[117,117,10,3,1251],false],
['t3175',1363,663,977,[1564,1576,4656,4699],[43,43,11,1,482],false],
['t3176',1434,663,977,[1595,1606,4656,4699],[43,43,11,1,459],false],
['t3177',965,663,4,[1673,1684,4648,4750],[101,101,10,1,1052],false],
['t3178',1341,977,663,[1620,1630,4653,4699],[46,46,10,1,469],false],
['t3179',1511,861,978,[1522,1536,4336,4350],[15,15,14,1,208],false],
['t3180',1416,663,979,[1431,1440,4661,4763],[102,102,10,1,999],false],
['t3184',1402,980,663,[1461,1472,4641,4707],[66,66,11,1,705],false],
['t3185',980,663,981,[1460,1473,4381,4447],[69,69,10,5,722],false],
['t3186',1574,663,982,[5266,5353,3131,3182],[128,128,11,3,1365],false],
['t3189',982,983,663,[5213,5337,3049,3171],[272,272,10,3,2840],false],
['t3190',1511,663,983,[5192,5326,3009,3160],[274,274,11,3,2991],false],
['t3192',1347,663,984,[6131,6174,3168,3179],[43,43,11,1,456],false],
['t3193',1370,663,984,[6131,6174,3143,3154],[43,43,11,1,456],false],
['t3194',1397,663,984,[6131,6174,3112,3123],[43,43,11,1,457],false],
['t3196',1160,2862,985,[6251,6339,3170,3180],[88,88,10,1,913],false],
['t3197',1446,2862,985,[6371,6424,3169,3220],[94,94,10,2,970],false],
['t3198',1041,663,2862,[6329,6407,3193,3220],[94,94,10,2,991],false],
['t3199',1026,663,2862,[6212,6306,3193,3203],[94,94,10,1,973],false],
['t3201',1003,2863,986,[6268,6401,3308,3319],[132,132,11,1,1449],false],
['t3202',1370,2864,2863,[6268,6401,3291,3301],[132,132,10,1,1331],false],
['t3203',985,663,2864,[6268,6401,3273,3283],[132,132,11,1,1410],false],
['t3205',1107,988,663,[5152,5163,3688,3731],[43,43,11,1,456],false],
['t3206',1107,987,663,[5142,5163,3632,3671],[51,51,10,2,531],false],
['t3208',988,663,2865,[5053,5140,3670,3731],[137,137,10,4,1409],false],
['t3209',1006,2865,990,[5047,5083,3692,3717],[51,51,10,2,523],false],
['t3210',1006,2865,990,[5103,5119,3692,3768],[81,81,11,2,872],false],
['t3212',991,987,663,[5075,5120,3632,3641],[45,45,10,1,425],false],
['t3214',1037,663,989,[4999,5012,3712,3763],[52,52,10,3,541],false],
['t3215',1511,991,782,[5053,5067,3602,3616],[14,14,13,1,187],false],
['t3217',1507,386,993,[5281,5294,3705,3719],[14,14,13,1,184],false],
['t3218',1507,1578,387,[5325,5339,3727,3741],[14,14,14,1,197],false],
['t3219',1511,994,1005,[5661,5674,3593,3608],[15,15,13,1,196],false],
['t3221',997,1005,663,[5712,5776,3626,3636],[64,64,10,1,629],false],
['t3222',1507,996,997,[5659,5673,3652,3666],[15,15,13,1,197],false],
['t3223',993,663,2866,[5396,5489,3691,3707],[99,99,10,3,981],false],
['t3224',1107,992,663,[5325,5368,3601,3611],[44,44,10,1,440],false],
['t3225',1107,2866,996,[5396,5489,3673,3689],[99,99,11,3,1064],false],
['t3226',992,2867,996,[5512,5569,3647,3657],[56,56,10,1,551],false],
['t3227',992,2867,996,[5598,5626,3629,3640],[28,28,11,1,297],false],
['t3228',994,2867,663,[5512,5607,3607,3640],[117,117,11,3,1288],false],
['t3229',412,2868,996,[5396,5489,3647,3663],[99,99,10,3,998],false],
['t3230',1027,992,663,[5336,5380,3629,3640],[44,44,11,1,482],false],
['t3231',1027,663,2868,[5396,5489,3629,3645],[99,99,10,3,1032],false],
['t3232',1507,311,998,[5282,5295,3448,3464],[15,15,13,1,196],false],
['t3233',1511,1000,1001,[5406,5421,3358,3372],[15,15,14,1,210],false],
['t3234',1511,1002,1003,[5693,5709,3214,3227],[15,15,14,1.5,190],false],
['t3236',1026,2869,1004,[6159,6248,3514,3524],[89,89,10,1,922],false],
['t3237',1446,2869,663,[6159,6248,3496,3507],[89,89,11,1,1000],false],
['t3238',1160,663,2870,[6159,6248,3465,3479],[90,90,11,3,956],false],
['t3239',1013,2870,1004,[6159,6248,3448,3462],[91,91,10,3,948],false],
['t3242',1041,2871,1014,[6293,6353,3562,3650],[146,146,11,3,1501],false],
['t3243',1347,663,2872,[6184,6324,3603,3619],[145,145,10,3,1526],false],
['t3244',1124,663,1012,[6095,6139,3590,3601],[44,44,10,1,459],false],
['t3245',1124,2872,2871,[6184,6324,3585,3601],[145,145,11,3,1581],false],
['t3247',1012,663,2871,[6184,6254,3563,3575],[72,72,10,3,724],false],
['t3248',1347,1012,663,[6096,6139,3566,3576],[42,42,10,1,437],false],
['t3249',1397,663,1015,[6341,6385,3430,3441],[45,45,11,1,491],false],
['t3250',1003,663,2873,[6195,6284,3408,3421],[90,90,10,3,867],false],
['t3251',1004,663,2873,[6111,6163,3387,3423],[105,105,10,3,1061],false],
['t3252',986,2873,1015,[6193,6280,3384,3398],[89,89,11,3,955],false],
['t3253',1370,1013,2874,[6005,6092,3455,3466],[87,87,10,1,900],false],
['t3255',1446,2874,663,[6005,6092,3437,3448],[87,87,11,1,930],false],
['t3256',1347,1003,663,[6107,6175,3334,3345],[69,69,11,1,753],false],
['t3259',1107,1008,663,[5388,5433,3493,3504],[45,45,11,1,482],false],
['t3260',1107,663,2875,[5471,5567,3493,3504],[96,96,11,1,1023],false],
['t3263',1511,1011,1007,[5650,5663,3424,3439],[15,15,13,1,188],false],
['t3264',1507,1576,1006,[5623,5636,3460,3475],[14,14,13,1,184],false],
['t3265',998,2875,1006,[5471,5567,3476,3487],[96,96,11,1,1055],false],
['t3266',1011,2876,1006,[5438,5537,3450,3461],[98,98,11,1,1106],false],
['t3267',1576,1007,663,[5603,5677,3396,3407],[73,73,11,1,802],false],
['t3268',1008,663,2876,[5438,5537,3433,3443],[98,98,10,1,1019],false],
['t3269',1010,663,2877,[5538,5626,3354,3371],[91,91,10,3,961],false],
['t3270',1000,2877,1006,[5530,5626,3334,3354],[105,105,11,3,1158],false],
['t3271',1000,663,1008,[5470,5520,3334,3345],[49,49,11,1,556],false],
['t3272',1009,1006,663,[5530,5574,3311,3322],[44,44,11,1,472],false],
['t3273',1009,1008,663,[5478,5520,3308,3322],[44,44,10,3,468],false],
['t3274',1511,891,1009,[5614,5628,3287,3301],[14,14,13,1,185],false],
['t3276',1002,663,1010,[5575,5650,3240,3256],[81,81,10,2,852],false],
['t3278',838,2878,663,[3544,3560,4369,4510],[152,152,10,5,1591],false],
['t3279',1332,456,2878,[3526,3542,4369,4510],[148,148,10,5,1526],false],
['t3281',772,2879,456,[3506,3519,4369,4510],[142,142,10,3,1431],false],
['t3282',1424,1018,663,[3478,3495,4317,4361],[52,52,10,2,516],false],
['t3283',1424,663,2879,[3485,3501,4369,4510],[149,149,11,5,1588],false],
['t3285',1390,663,1956,[3714,3727,4348,4482],[135,135,11,3,1421],false],
['t3286',1338,663,1956,[3655,3702,4428,4541],[150,150,10,3,1518],false],
['t3287',1431,1020,663,[3670,3691,4354,4406],[62,62,10,2,652],false],
['t3289',879,2880,1019,[3675,3685,4148,4282],[134,134,10,1,1346],false],
['t3290',1020,2881,2880,[3657,3667,4148,4282],[134,134,10,1,1387],false],
['t3292',1360,663,2881,[3615,3639,4307,4450],[155,155,10,5,1577],false],
['t3293',1384,663,2881,[3597,3618,4305,4450],[158,158,10,7,1650],false],
['t3294',1354,663,2882,[3437,3456,4544,4685],[149,149,10,3,1572],false],
['t3295',1377,943,663,[3430,3441,4711,4778],[67,67,11,1,735],false],
['t3296',942,2882,943,[3420,3437,4544,4685],[148,148,10,3,1495],false],
['t3297',838,2883,663,[3548,3558,4682,4771],[89,89,10,1,892],false],
['t3298',1332,798,2883,[3530,3540,4682,4771],[89,89,10,1,866],false],
['t3300',1343,2884,663,[3767,3780,4683,4771],[92,92,10,3,956],false],
['t3301',1436,663,2884,[3745,3756,4751,4838],[87,87,11,1,926],false],
['t3302',1414,663,1022,[3714,3725,4747,4791],[44,44,11,1,479],false],
['t3303',879,1022,2884,[3746,3755,4643,4728],[85,85,9,1,803],false],
['t3304',879,1956,438,[3748,3774,4408,4547],[151,151,11,5,1683],false],
['t3306',914,663,1022,[3691,3701,4747,4791],[44,44,11,1,466],false],
['t3309',1507,1579,1024,[5698,5712,3787,3802],[14,14,14,1,201],false],
['t3310',1511,1026,1025,[5681,5695,3853,3866],[14,14,14,1,197],false],
['t3311',1511,1096,1027,[5060,5074,3972,3985],[14,14,13,1,193],false],
['t3312',1507,749,1028,[5134,5148,3952,3967],[14,14,14,1,193],false],
['t3313',1041,663,2885,[6011,6145,4021,4031],[134,134,11,1,1420],false],
['t3314',1056,663,2885,[6011,6144,3990,4001],[133,133,11,1,1458],false],
['t3316',984,1039,2885,[5995,6149,3965,3978],[155,155,11,3,1664],false],
['t3317',1015,663,1039,[6083,6149,3941,3952],[67,67,11,1,711],false],
['t3318',1042,663,1039,[5995,6060,3942,3952],[65,65,10,1,655],false],
['t3320',1040,663,1042,[6197,6231,3862,3889],[51,51,10,2,504],false],
['t3322',1397,1040,663,[6036,6079,3874,3884],[43,43,11,1,456],false],
['t3323',1370,663,1042,[6126,6172,3850,3872],[58,58,10,2,586],false],
['t3324',1014,1042,2886,[6160,6248,3838,3852],[89,89,11,3,989],false],
['t3325',1043,2886,663,[6272,6360,3816,3827],[88,88,10,1,915],false],
['t3328',1041,2886,663,[6160,6248,3816,3829],[89,89,10,3,893],false],
['t3330',1446,663,1041,[6060,6085,3747,3803],[71,71,10,2,707],false],
['t3331',1347,2887,663,[6154,6242,3788,3798],[88,88,10,1,911],false],
['t3332',1044,663,1043,[6154,6198,3750,3763],[45,45,10,3,470],false],
['t3333',1005,663,1044,[6154,6198,3704,3716],[44,44,10,3,467],false],
['t3334',1005,1043,2887,[6154,6242,3771,3781],[88,88,10,1,886],false],
['t3335',1347,663,1044,[6220,6262,3703,3713],[42,42,10,1,412],false],
['t3336',412,663,2888,[5624,5756,3926,3937],[132,132,11,1,1399],false],
['t3338',1128,2888,1034,[5624,5756,3944,3955],[132,132,12,1,1527],false],
['t3339',645,1024,2889,[5355,5486,4047,4072],[146,146,11,3,1532],false],
['t3340',1158,2889,2890,[5355,5486,4029,4054],[146,146,11,3,1587],false],
['t3341',989,2890,663,[5355,5486,4012,4036],[146,146,11,3,1563],false],
['t3342',1025,2891,2892,[5273,5405,3932,3954],[142,142,10,4,1512],false],
['t3343',645,1024,2892,[5394,5522,3930,3975],[160,160,10,5,1596],false],
['t3345',1511,1038,1026,[5648,5661,3752,3766],[14,14,13,1,179],false],
['t3346',1579,1026,663,[5703,5770,3739,3749],[67,67,11,1,712],false],
['t3347',1027,2892,663,[5294,5367,3962,3975],[75,75,10,5,824],false],
['t3348',1049,1035,663,[5227,5270,3893,3903],[43,43,10,1,421],false],
['t3349',1049,663,2891,[5262,5382,3920,3934],[122,122,10,3,1258],false],
['t3350',1107,2893,663,[5500,5600,3815,3829],[101,101,10,3,1068],false],
['t3351',1107,1035,663,[5297,5348,3892,3902],[51,51,10,1,500],false],
['t3352',1578,1024,2893,[5500,5600,3797,3812],[101,101,10,3,1093],false],
['t3353',1035,2894,1024,[5500,5600,3770,3787],[105,105,11,3,1108],false],
['t3354',1038,663,2894,[5500,5600,3753,3769],[105,105,10,3,1053],false],
['t3355',1027,1035,663,[5341,5375,3785,3822],[61,61,10,2,616],false],
['t3356',1028,1029,663,[5088,5135,3925,3937],[47,47,12,1,542],false],
['t3358',1511,1032,1029,[5055,5068,3913,3927],[14,14,13,1,185],false],
['t3360',989,1035,663,[5347,5398,3761,3772],[51,51,11,1,557],false],
['t3363',1032,663,1030,[4983,5027,3887,3899],[44,44,12,1,505],false],
['t3364',1031,663,1033,[4996,5040,3837,3850],[45,45,11,3,501],false],
['t3365',1507,1031,1030,[4972,4986,3860,3873],[14,14,13,1,185],false],
['t3366',1511,1037,1033,[4996,5011,3811,3825],[15,15,14,1,206],false],
['t3368',1050,1048,663,[5027,5071,4147,4157],[44,44,11,1,472],false],
['t3370',1507,1045,1048,[5113,5127,4135,4149],[14,14,14,1,201],false],
['t3371',1045,663,1046,[5028,5071,4114,4125],[43,43,11,1,476],false],
['t3373',1047,663,1049,[5113,5167,4062,4072],[54,54,10,1,561],false],
['t3374',1511,1047,1046,[5043,5056,4063,4077],[14,14,13,1,181],false],
['t3375',1511,1050,1051,[5003,5017,4173,4188],[14,14,14,1,206],false],
['t3376',1153,663,2895,[6186,6197,3984,4073],[89,89,11,1,946],false],
['t3377',1154,2896,1052,[6157,6245,4250,4261],[88,88,10,1,915],false],
['t3378',1052,2895,1054,[6225,6325,4026,4046],[115,115,10,4,1180],false],
['t3380',1053,663,1052,[6267,6311,4233,4244],[44,44,11,1,472],false],
['t3382',1156,1053,663,[6251,6296,4195,4206],[45,45,11,1,488],false],
['t3383',1446,1053,663,[6178,6228,4201,4214],[51,51,10,3,547],false],
['t3384',1446,2896,663,[6157,6245,4233,4244],[88,88,11,1,941],false],
['t3386',1125,663,1054,[6283,6324,4091,4102],[42,42,11,1,456],false],
['t3387',1040,1054,663,[6283,6325,4060,4071],[42,42,11,1,459],false],
['t3388',1054,1039,663,[5985,6059,4119,4137],[81,81,10,3,835],false],
['t3389',1347,2895,1054,[6203,6236,3998,4073],[97,97,10,2,982],false],
['t3390',1003,663,2895,[6329,6360,4005,4018],[32,32,10,3,345],false],
['t3391',1003,663,2895,[6254,6301,3984,4029],[94,94,10,4,944],false],
['t3392',1026,1056,663,[6078,6121,4079,4090],[44,44,11,1,468],false],
['t3393',1041,1056,663,[5994,6038,4069,4080],[44,44,11,1,479],false],
['t3395',1160,1056,663,[5985,6029,4094,4104],[43,43,10,1,450],false],
['t3397',1128,663,2897,[5624,5742,4044,4057],[119,119,11,3,1297],false],
['t3398',412,663,2897,[5611,5742,4018,4031],[132,132,10,3,1317],false],
['t3399',1034,2897,1057,[5642,5773,3997,4037],[162,162,10,2,1673],false],
['t3401',1511,1058,1059,[5718,5731,4215,4229],[13,13,14,1,189],false],
['t3402',411,663,1059,[5673,5739,4190,4203],[68,68,10,3,681],false],
['t3403',1114,663,1059,[5673,5739,4165,4179],[68,68,11,3,722],false],
['t3404',1437,2898,466,[4237,4248,4332,4465],[133,133,11,1,1412],false],
['t3405',696,663,2898,[4255,4265,4332,4465],[133,133,10,1,1374],false],
['t3407',1413,663,466,[4215,4230,4518,4584],[67,67,11,3,752],false],
['t3408',1391,663,2899,[4186,4199,4477,4610],[134,134,10,3,1451],false],
['t3409',879,2899,466,[4212,4223,4309,4441],[132,132,11,1,1449],false],
['t3410',1339,663,2899,[4165,4178,4494,4626],[134,134,11,5,1405],false],
['t3411',1432,2900,663,[4164,4176,4300,4440],[142,142,9,3,1330],false],
['t3412',1432,663,2899,[4186,4204,4300,4440],[150,150,10,5,1489],false],
['t3413',1361,663,2900,[4116,4154,4373,4498],[150,150,11,5,1710],false],
['t3414',838,1061,2900,[4143,4207,4247,4335],[141,141,11,4,1515],false],
['t3416',1507,918,1062,[3908,3924,4392,4405],[16,16,14,1,216],false],
['t3417',1333,663,2901,[4057,4070,4248,4334],[87,87,10,3,953],false],
['t3418',1062,1063,663,[4079,4091,4546,4589],[44,44,10,3,451],false],
['t3419',823,663,1063,[4075,4085,4406,4450],[44,44,10,1,443],false],
['t3420',832,2901,1063,[4080,4090,4236,4323],[87,87,10,1,867],false],
['t3422',838,1063,2902,[4027,4040,4532,4621],[90,90,10,3,928],false],
['t3423',1425,2902,663,[4039,4051,4652,4740],[89,89,12,1,1022],false],
['t3424',1355,663,2902,[4014,4027,4656,4744],[89,89,11,3,983],false],
['t3425',1340,1051,2903,[4532,4546,4434,4522],[89,89,11,3,954],false],
['t3426',1433,1065,663,[4495,4505,4606,4650],[44,44,11,1,466],false],
['t3427',1362,663,1067,[4460,4470,4449,4493],[44,44,10,1,453],false],
['t3428',1065,1067,663,[4491,4501,4468,4511],[43,43,10,1,431],false],
['t3431',838,2903,663,[4514,4527,4434,4522],[89,89,10,3,905],false],
['t3432',1095,1067,663,[4488,4498,4401,4445],[44,44,10,1,433],false],
['t3434',1069,663,1068,[4422,4432,4430,4493],[64,64,10,1,639],false],
['t3435',1095,663,1068,[4422,4432,4339,4404],[65,65,10,1,632],false],
['t3437',1392,663,1068,[4366,4409,4478,4525],[79,79,11,3,807],false],
['t3438',1362,663,1068,[4400,4410,4389,4456],[67,67,10,1,649],false],
['t3439',1386,1069,663,[4391,4408,4645,4700],[61,61,10,3,623],false],
['t3440',1334,1069,663,[4381,4425,4614,4624],[44,44,11,1,466],false],
['t3442',1647,1071,1070,[1371,1384,624,661],[37,37,13,1,487],false],
['t3443',267,663,1070,[1398,1459,597,717],[233,233,10,9,2403],false],
['t3446',1071,663,1072,[1276,1379,567,719],[487,487,11,9,5106],false],
['t3447',1646,663,1072,[1218,1298,555,719],[440,440,10,13,4559],false],
['t3448',1647,56,1073,[708,744,296,309],[35,35,13,1,462],false],
['t3449',1417,1074,663,[913,923,3892,3934],[43,43,10,1,428],false],
['t3452',1076,663,1075,[938,954,3868,3934],[72,72,10,3,718],false],
['t3453',1511,1076,1074,[928,944,3979,3992],[16,16,14,1,214],false],
['t3454',1507,1075,1077,[1011,1026,4034,4049],[15,15,14,1,210],false],
['t3455',1507,1078,1079,[857,872,3670,3685],[14,14,14,1,210],false],
['t3456',1511,1080,911,[786,800,3654,3668],[14,14,14,1,203],false],
['t3457',1511,1082,1081,[696,709,3795,3809],[14,14,13,1,185],false],
['t3458',1511,1083,1084,[613,626,3719,3732],[13,13,13,1,169],false],
['t3460',1086,2904,663,[703,713,3857,3989],[132,132,10,1,1368],false],
['t3461',1086,663,1085,[724,745,3867,3947],[99,99,10,5,995],false],
['t3462',1084,663,2905,[641,657,3858,3994],[142,142,10,3,1481],false],
['t3463',1088,2905,1087,[659,675,3858,3994],[142,142,10,3,1487],false],
['t3465',1084,663,1090,[618,642,3600,3669],[83,83,10,3,839],false],
['t3467',1512,663,1090,[599,627,3512,3575],[81,81,10,3,797],false],
['t3468',1512,663,1087,[676,686,3631,3697],[66,66,11,1,702],false],
['t3469',1082,1087,2904,[685,696,3857,3989],[132,132,10,1,1367],false],
['t3470',1138,663,1086,[750,763,3587,3653],[67,67,10,3,678],false],
['t3473',1089,1085,663,[754,764,3881,3947],[67,67,10,1,669],false],
['t3474',1507,1089,1079,[794,807,3795,3809],[14,14,14,1,197],false],
['t3475',1080,1079,663,[810,833,3693,3751],[71,71,10,2,713],false],
['t3476',1511,1088,1085,[736,752,4000,4015],[15,15,15,1,228],false],
['t3477',1090,2906,1079,[800,833,3833,3954],[145,145,10,3,1502],false],
['t3478',1088,663,2906,[818,851,3833,3954],[145,145,10,3,1496],false],
['t3480',1078,1081,663,[736,837,3543,3580],[127,127,10,4,1314],false],
['t3481',1368,663,1092,[4688,4698,4741,4787],[46,46,10,1,477],false],
['t3482',1395,663,1092,[4657,4668,4745,4787],[43,43,10,1,448],false],
['t3484',1345,663,1093,[4752,4766,4690,4738],[51,51,10,3,537],false],
['t3485',1443,663,1093,[4724,4737,4690,4733],[44,44,10,3,476],false],
['t3487',1346,663,1097,[4842,4852,4680,4723],[43,43,10,1,437],false],
['t3488',1444,663,1097,[4835,4851,4746,4795],[55,55,10,3,563],false],
['t3489',1369,663,1096,[4778,4791,4384,4454],[70,70,11,3,760],false],
['t3491',1097,663,782,[4826,4840,4427,4470],[44,44,10,3,468],false],
['t3493',838,663,1095,[4852,4865,4285,4388],[104,104,10,3,1060],false],
['t3494',1095,663,1096,[4799,4816,4386,4456],[80,80,9,5,783],false],
['t3496',1095,663,782,[4850,4862,4415,4458],[44,44,10,3,444],false],
['t3498',1511,1099,947,[4907,4921,4668,4682],[14,14,14,1,197],false],
['t3499',1511,479,1101,[5043,5056,4274,4289],[15,15,13,1,192],false],
['t3500',1507,1593,1567,[5375,5391,4244,4258],[15,15,13,1,201],false],
['t3501',1507,1566,1103,[5728,5741,4459,4473],[14,14,13,1,181],false],
['t3502',1511,1104,1124,[5738,5751,4414,4429],[15,15,13,1,193],false],
['t3503',1511,468,1105,[4980,4995,4318,4332],[15,15,14,1,210],false],
['t3505',1099,1107,663,[5043,5208,4671,4682],[164,164,11,1,1747],false],
['t3509',1096,663,2907,[5126,5208,4644,4655],[81,81,11,1,867],false],
['t3510',1123,663,1108,[5480,5522,4566,4577],[43,43,10,1,440],false],
['t3511',1511,1123,1109,[5457,5472,4527,4541],[14,14,14,1.5,191],false],
['t3513',1124,2908,1126,[6030,6118,4339,4350],[88,88,11,1,937],false],
['t3514',1005,663,2908,[6030,6118,4321,4331],[88,88,10,1,911],false],
['t3515',1370,1125,663,[6075,6118,4295,4308],[45,45,10,3,473],false],
['t3517',1093,663,1121,[5095,5149,4565,4582],[60,60,11,3,631],false],
['t3518',1093,2907,1115,[5126,5208,4627,4638],[81,81,11,1,868],false],
['t3519',1511,1568,1121,[5217,5230,4553,4567],[14,14,13,1,193],false],
['t3520',1511,1569,1115,[5211,5224,4583,4596],[13,13,13,1,167],false],
['t3524',1110,1109,2909,[5390,5509,4504,4520],[125,125,11,4,1350],false],
['t3525',1127,2909,663,[5404,5530,4486,4502],[131,131,10,2,1330],false],
['t3526',1103,1124,663,[5754,5822,4488,4513],[81,81,10,2,842],false],
['t3527',1104,2910,663,[5568,5699,4417,4428],[131,131,11,1,1436],false],
['t3530',1111,1566,2910,[5568,5699,4399,4410],[131,131,10,1,1360],false],
['t3531',1057,2911,1566,[5388,5520,4398,4407],[132,132,10,1,1287],false],
['t3532',1568,1111,663,[5317,5361,4359,4386],[60,60,11,3.5,648],false],
['t3533',1568,663,2911,[5388,5520,4380,4390],[132,132,10,1,1364],false],
['t3535',1107,1111,663,[5317,5362,4456,4467],[44,44,11,1,481],false],
['t3537',1116,1121,663,[5095,5139,4545,4555],[43,43,10,1,449],false],
['t3538',838,663,1116,[5073,5139,4520,4530],[66,66,10,1,643],false],
['t3539',1511,1117,1120,[5010,5023,4456,4470],[14,14,13,1,181],false],
['t3540',1117,663,1110,[5336,5380,4483,4494],[44,44,11,1,470],false],
['t3542',1569,1112,663,[5159,5174,4318,4361],[48,48,10,3,511],false],
['t3544',1570,2912,663,[5602,5733,4353,4363],[131,131,10,1,1320],false],
['t3545',1570,1111,663,[5317,5361,4328,4339],[43,43,11,1,461],false],
['t3546',1010,2912,1566,[5602,5733,4334,4345],[131,131,11,1,1397],false],
['t3547',1107,1566,2913,[5602,5733,4303,4324],[141,141,11,3,1542],false],
['t3548',1567,2913,663,[5602,5733,4286,4307],[149,149,10,5,1578],false],
['t3550',1112,2914,663,[5574,5707,4261,4274],[134,134,10,3,1363],false],
['t3551',1112,663,1111,[5317,5361,4297,4308],[43,43,11,1,486],false],
['t3552',1058,1566,2914,[5574,5707,4242,4257],[134,134,11,3,1500],false],
['t3553',1507,1114,1113,[5163,5177,4239,4252],[14,14,13,1,181],false],
['t3554',1507,1118,1119,[5048,5061,4377,4393],[16,16,13,1,204],false],
['t3555',1118,663,1120,[4994,5032,4405,4439],[61,61,10,2.5,604],false],
['t3557',1105,663,1119,[5055,5108,4349,4360],[53,53,11,1,576],false],
['t3558',1101,1113,663,[5090,5156,4268,4279],[66,66,10,1,679],false],
['t3559',1507,1127,610,[5553,5576,4506,4520],[22,22,15,1.5,310],false],
['t3560',1507,1129,1128,[5710,5726,4553,4567],[16,16,14,1,223],false],
['t3561',1131,1122,663,[5484,5531,4640,4653],[48,48,11,3,530],false],
['t3562',1107,663,1122,[5484,5531,4616,4627],[47,47,11,1,503],false],
['t3563',1110,663,1122,[5418,5461,4617,4629],[44,44,10,3,462],false],
['t3564',1511,1131,1130,[5565,5578,4637,4653],[16,16,12,1,195],false],
['t3566',945,868,2915,[1252,1263,4412,4545],[132,132,11,1,1407],false],
['t3567',1404,2915,663,[1269,1280,4412,4545],[132,132,10,1,1368],false],
['t3569',1136,2916,663,[1140,1150,4300,4433],[133,133,10,1,1374],false],
['t3570',1352,855,2916,[1161,1171,4317,4449],[132,132,10,1,1331],false],
['t3571',1140,2917,855,[1186,1199,4324,4458],[135,135,10,3,1373],false],
['t3572',1134,663,2917,[1204,1216,4324,4458],[137,137,10,5,1424],false],
['t3573',1511,1134,850,[1199,1214,4493,4507],[14,14,14,1,205],false],
['t3574',1511,835,1136,[1125,1138,4473,4485],[14,14,12,1,165],false],
['t3576',1331,1138,663,[1336,1346,4669,4735],[66,66,10,1,684],false],
['t3577',1409,663,1139,[1367,1377,4669,4735],[66,66,11,1,705],false],
['t3581',1387,939,2918,[983,1004,4364,4500],[148,148,10,3,1445],false],
['t3582',772,2919,663,[1015,1040,4535,4680],[159,159,11,2,1728],false],
['t3583',838,2918,663,[1000,1022,4364,4500],[148,148,10,3,1566],false],
['t3584',12,663,2919,[1025,1052,4330,4478],[165,165,11,5.5,1726],false],
['t3585',1324,937,2919,[1049,1077,4333,4465],[150,150,10,5,1561],false],
['t3587',1352,1140,663,[1198,1208,4660,4704],[43,43,10,1,438],false],
['t3588',772,935,2920,[1149,1159,4672,4804],[132,132,10,1,1367],false],
['t3589',1375,2920,663,[1167,1177,4672,4804],[132,132,10,1,1365],false],
['t3591',1511,1570,1141,[5283,5297,4763,4778],[16,16,14,1,218],false],
['t3592',1147,663,1122,[5495,5545,4740,4753],[52,52,10,3,510],false],
['t3593',1144,663,1122,[5495,5545,4717,4732],[52,52,10,3,570],false],
['t3594',1507,1143,610,[5627,5642,4716,4731],[15,15,14,1,218],false],
['t3595',1511,1144,1067,[5659,5673,4758,4773],[15,15,14,1,205],false],
['t3596',1511,1147,1068,[5659,5673,4780,4796],[16,16,14,1,219],false],
['t3598',12,941,2921,[1005,1015,4729,4860],[131,131,10,1,1314],false],
['t3599',1429,663,2921,[1036,1063,4752,4877],[142,142,10,2,1474],false],
['t3600',1335,663,2921,[1078,1088,4752,4885],[132,132,10,1,1370],false],
['t3601',1204,663,1148,[632,645,4331,4396],[66,66,10,3.5,657],false],
['t3602',1203,663,1148,[653,673,4331,4400],[80,80,10,3,804],false],
['t3603',1374,2922,2923,[738,751,4203,4401],[199,199,10,3,2110],false],
['t3605',1169,663,2922,[717,731,4203,4401],[199,199,10,5,2021],false],
['t3606',1075,1148,663,[688,699,4329,4391],[63,63,11,1,687],false],
['t3607',1152,1149,2923,[731,760,4507,4704],[216,216,10,3,2119],false],
['t3609',842,2922,2923,[759,773,4203,4402],[200,200,10,5,1954],false],
['t3610',960,663,2922,[781,794,4203,4402],[200,200,10,3,2033],false],
['t3611',930,663,1148,[636,654,4139,4211],[80,80,10,3,822],false],
['t3612',929,663,1148,[663,679,4139,4211],[78,78,11,3,825],false],
['t3613',928,1148,663,[690,700,4146,4212],[66,66,10,1,669],false],
['t3614',1351,1152,2924,[784,797,4432,4563],[133,133,10,3,1351],false],
['t3616',1401,1150,663,[830,839,4721,4766],[44,44,9,1,420],false],
['t3617',1330,663,1151,[860,870,4721,4766],[44,44,10,1,451],false],
['t3618',1382,1151,663,[887,897,4712,4755],[44,44,10,1,459],false],
['t3619',832,2924,663,[801,814,4432,4563],[133,133,10,3,1357],false],
['t3620',1150,663,2925,[827,842,4405,4608],[206,206,10,5,2108],false],
['t3621',1151,2926,1152,[862,878,4405,4608],[205,205,10,5,2157],false],
['t3623',879,2925,2926,[844,861,4405,4608],[206,206,11,5,2165],false],
['t3625',1157,1153,663,[6225,6270,4416,4432],[51,51,10,2,498],false],
['t3627',1446,2927,1153,[6192,6281,4394,4404],[88,88,11,1,938],false],
['t3628',1156,663,2927,[6256,6301,4372,4382],[44,44,10,1,461],false],
['t3629',1156,663,2927,[6330,6372,4383,4392],[42,42,9,1,373],false],
['t3630',1026,1154,663,[6164,6208,4301,4311],[43,43,10,1,438],false],
['t3631',1026,663,2927,[6145,6233,4372,4382],[88,88,10,1,886],false],
['t3632',1156,1154,663,[6231,6274,4301,4311],[43,43,10,1,431],false],
['t3634',1124,2928,663,[6058,6146,4462,4473],[88,88,10,1,883],false],
['t3635',1005,2928,663,[5948,6036,4462,4473],[88,88,10,1,907],false],
['t3636',1126,1155,2928,[6029,6119,4439,4449],[90,90,10,1,928],false],
['t3640',1446,663,1157,[6152,6196,4525,4535],[43,43,10,1,430],false],
['t3641',1155,663,1157,[6218,6265,4525,4535],[46,46,10,1,467],false],
['t3642',1155,1156,663,[6267,6277,4477,4520],[43,43,11,1,476],false],
['t3643',1165,2929,663,[6077,6210,4893,4903],[132,132,10,1,1371],false],
['t3644',1165,663,1158,[6151,6224,4913,4934],[84,84,10,2,884],false],
['t3645',1164,1128,2929,[6077,6210,4874,4886],[132,132,11,1,1492],false],
['t3646',1163,2930,1128,[6077,6210,4844,4854],[132,132,11,1,1409],false],
['t3647',1158,663,2930,[6077,6210,4826,4837],[132,132,11,1,1486],false],
['t3649',1143,2931,663,[6077,6210,4795,4806],[132,132,10,1,1371],false],
['t3650',1107,1128,2931,[6077,6210,4777,4788],[132,132,11,1,1449],false],
['t3651',1010,2932,1128,[6077,6210,4747,4757],[132,132,10,1,1371],false],
['t3652',1162,663,2932,[6077,6210,4729,4739],[132,132,11,1,1409],false],
['t3653',1108,1128,663,[6139,6210,4692,4708],[77,77,11,3,803],false],
['t3655',1122,2933,1128,[6078,6210,4667,4678],[132,132,11,1,1446],false],
['t3656',1511,1161,1160,[6053,6066,4624,4638],[14,14,14,1,185],false],
['t3657',1161,663,2933,[6078,6210,4650,4660],[132,132,11,1,1407],false],
['t3659',1129,663,1160,[6092,6210,4599,4610],[118,118,11,1,1292],false],
['t3660',1511,1162,1130,[5977,5992,4718,4733],[16,16,14,1,222],false],
['t3661',1511,1067,1163,[6016,6030,4850,4866],[15,15,14,1,207],false],
['t3662',1511,1068,1164,[6016,6030,4889,4904],[15,15,14,1,202],false],
['t3663',1511,1165,646,[6016,6030,4912,4928],[17,17,14,1,225],false],
['t3664',1323,1169,663,[699,709,4700,4744],[44,44,10,1,459],false],
['t3665',1374,663,1169,[704,715,4628,4673],[44,44,11,1,485],false],
['t3667',891,2934,2935,[82,282,3139,3149],[200,200,11,1,2131],false],
['t3668',1511,1170,1171,[199,212,3203,3217],[14,14,13,1,188],false],
['t3670',1138,2935,1171,[93,282,3157,3194],[216,216,10,2,2319],false],
['t3671',1192,663,2934,[82,282,3121,3132],[200,200,10,1,2072],false],
['t3672',1507,1172,1173,[89,105,3277,3291],[16,16,14,1,222],false],
['t3674',1170,663,1173,[119,186,3232,3262],[87,87,10,2,846],false],
['t3675',1172,663,1175,[113,218,3315,3326],[105,105,11,1,1143],false],
['t3676',1507,1174,1175,[110,133,3399,3413],[22,22,14,1,312],false],
['t3677',1177,663,1176,[205,281,3376,3397],[86,86,10,2,880],false],
['t3679',1176,663,1175,[127,224,3342,3367],[111,111,10,2,1130],false],
['t3681',1178,663,1175,[245,347,3316,3326],[102,102,11,1,1086],false],
['t3682',1511,1178,1177,[312,326,3382,3398],[16,16,14,1,222],false],
['t3683',1511,1179,2,[315,328,3687,3702],[16,16,13,1,204],false],
['t3684',849,1181,663,[112,211,3987,4004],[108,108,9,4,1108],false],
['t3686',1081,663,1180,[425,442,4033,4045],[17,17,11,1,186],false],
['t3687',1081,663,1180,[321,405,4034,4054],[93,93,11,3,985],false],
['t3689',1180,1182,663,[306,415,3996,4014],[117,117,10,3,1204],false],
['t3690',1086,663,1182,[337,439,3972,3983],[102,102,11,1,1146],false],
['t3692',1182,1181,663,[138,241,3948,3975],[118,118,11,3,1305],false],
['t3693',1181,1185,663,[118,221,3784,3797],[103,103,10,3,1086],false],
['t3694',1507,1184,1183,[272,286,3907,3922],[15,15,13,1,201],false],
['t3696',1195,1083,663,[379,451,3900,3951],[113,113,11,2,1213],false],
['t3698',1184,2936,663,[131,245,3843,3899],[160,160,10,4,1688],false],
['t3699',1192,2936,663,[158,185,3831,3841],[26,26,11,1,280],false],
['t3700',1192,2936,663,[206,312,3830,3841],[106,106,11,1,1164],false],
['t3701',1185,1195,2936,[222,345,3843,3881],[168,168,10,6,1794],false],
['t3703',2,663,1185,[231,332,3758,3771],[103,103,10,5,1109],false],
['t3704',1186,663,1185,[102,203,3752,3771],[110,110,10,2,1159],false],
['t3706',1507,1187,1188,[173,186,3711,3725],[15,15,13,1,197],false],
['t3707',1179,1188,663,[188,262,3690,3700],[74,74,11,1,808],false],
['t3708',1187,1186,663,[117,244,3657,3725],[196,196,10,3,2008],false],
['t3709',2,1186,663,[272,336,3656,3667],[64,64,10,3,656],false],
['t3710',2,1186,663,[356,388,3643,3724],[104,104,10,2,994],false],
['t3712',1512,1189,663,[93,171,3556,3612],[123,123,10,2,1288],false],
['t3713',1512,663,1186,[93,214,3635,3700],[175,175,10,2,1815],false],
['t3715',1190,663,1189,[133,246,3548,3559],[113,113,10,1,1172],false],
['t3716',1511,1191,1189,[225,246,3521,3536],[22,22,14,1,316],false],
['t3717',1511,1190,1193,[254,276,3521,3536],[22,22,14,1,318],false],
['t3718',1172,663,1189,[100,204,3526,3536],[103,103,11,1,1132],false],
['t3719',1191,1193,663,[112,217,3495,3508],[106,106,11,3,1161],false],
['t3720',1174,663,1193,[112,215,3449,3482],[127,127,10,4,1295],false],
['t3722',1193,663,1192,[139,246,3438,3459],[117,117,11,3,1255],false],
['t3724',990,1183,663,[127,196,4096,4144],[121,121,10,3,1242],false],
['t3726',1212,663,1183,[100,204,4072,4085],[104,104,11,3,1165],false],
['t3727',1270,1513,663,[783,805,5478,5489],[22,22,11,1,239],false],
['t3728',1270,1522,663,[901,923,5478,5489],[22,22,11,1,239],false],
['t3729',1270,1835,663,[989,1011,5478,5489],[22,22,11,1,236],false],
['t3730',1270,1808,663,[1048,1070,5478,5489],[22,22,11,1,239],false],
['t3731',1270,1608,663,[1175,1196,5478,5489],[22,22,11,1,233],false],
['t3732',1270,1523,663,[1233,1255,5478,5489],[22,22,11,1,236],false],
['t3733',1270,1809,663,[1380,1403,5478,5489],[22,22,11,1,239],false],
['t3734',1270,1841,663,[1440,1462,5478,5489],[22,22,11,1,233],false],
['t3735',1270,1627,663,[1528,1550,5478,5489],[22,22,11,1,236],false],
['t3736',1270,1602,663,[1684,1706,5478,5489],[22,22,11,1,230],false],
['t3737',1270,1613,663,[2126,2148,5478,5489],[22,22,11,1,233],false],
['t3738',1270,1604,663,[2282,2304,5478,5489],[22,22,11,1,239],false],
['t3739',1270,1800,663,[2370,2392,5478,5489],[22,22,11,1,230],false],
['t3740',1270,1792,663,[2517,2539,5478,5489],[22,22,11,1,233],false],
['t3741',1270,1834,663,[2694,2716,5478,5489],[22,22,11,1,236],false],
['t3742',1270,1804,663,[2909,2931,5478,5489],[22,22,11,1,233],false],
['t3743',1270,1810,663,[3027,3049,5478,5489],[22,22,11,1,233],false],
['t3744',1270,1842,663,[3086,3108,5478,5489],[22,22,11,1,239],false],
['t3745',1270,1815,663,[3144,3167,5478,5489],[22,22,11,1,236],false],
['t3746',1270,1628,663,[3174,3196,5478,5489],[22,22,11,1,236],false],
['t3747',1270,1516,663,[3271,3293,5478,5489],[22,22,11,1,230],false],
['t3748',1270,1624,663,[3565,3588,5478,5489],[22,22,11,1,236],false],
['t3749',1270,1843,663,[3595,3617,5478,5489],[22,22,11,1,230],false],
['t3750',1270,1816,663,[3654,3676,5478,5489],[22,22,11,1,236],false],
['t3751',1270,1526,663,[3898,3921,5478,5489],[22,22,11,1,236],false],
['t3752',1270,1806,663,[3928,3950,5478,5489],[22,22,11,1,233],false],
['t3753',1270,1533,663,[4016,4038,5478,5489],[22,22,11,1,230],false],
['t3754',1270,1807,663,[4322,4345,5478,5489],[22,22,11,1,239],false],
['t3755',1270,1851,663,[4823,4845,5478,5489],[22,22,11,1,236],false],
['t3756',1270,1601,663,[5008,5030,5478,5489],[22,22,11,1,236],false],
['t3757',1271,1845,663,[4499,4521,5447,5457],[22,22,11,1,232],false],
['t3758',1271,1849,663,[4222,4244,5447,5457],[23,23,11,1,240],false],
['t3759',1271,1538,663,[4134,4156,5447,5457],[22,22,11,1,236],false],
['t3760',1271,1625,663,[4075,4098,5447,5457],[23,23,11,1,244],false],
['t3761',1271,1812,663,[4045,4067,5447,5457],[22,22,11,1,232],false],
['t3762',1271,1611,663,[3840,3862,5447,5457],[22,22,11,1,236],false],
['t3763',1271,1797,663,[3810,3832,5447,5457],[23,23,11,1,240],false],
['t3764',1271,1629,663,[3683,3706,5447,5457],[23,23,11,1,244],false],
['t3765',1271,1829,663,[3359,3382,5447,5457],[23,23,11,1,240],false],
['t3766',1271,1610,663,[3330,3352,5447,5457],[22,22,11,1,236],false],
['t3767',1271,1847,663,[3203,3226,5447,5457],[23,23,11,1,240],false],
['t3768',1271,1524,663,[2879,2901,5447,5457],[23,23,11,1,240],false],
['t3769',1271,1519,663,[2066,2089,5447,5457],[23,23,11,1,240],false],
['t3770',1271,1822,663,[1713,1736,5447,5457],[23,23,11,1,240],false],
['t3771',1271,1535,663,[1468,1491,5447,5457],[23,23,11,1,244],false],
['t3772',1271,1793,663,[812,835,5447,5457],[23,23,11,1,240],false],
['t3773',1197,1513,663,[783,805,5420,5431],[23,23,11,1,240],false],
['t3774',1197,1522,663,[901,923,5420,5431],[23,23,11,1,240],false],
['t3775',1197,1529,663,[1018,1041,5420,5431],[22,22,11,1,236],false],
['t3776',1197,1794,663,[1145,1167,5420,5431],[22,22,11,1,232],false],
['t3777',1197,1535,663,[1469,1491,5420,5431],[22,22,11,1,232],false],
['t3778',1197,1602,663,[1684,1706,5420,5431],[22,22,11,1,232],false],
['t3779',1197,1822,663,[1713,1736,5420,5431],[22,22,11,1,236],false],
['t3780',1197,1519,663,[2067,2089,5420,5431],[22,22,11,1,236],false],
['t3781',1197,1825,663,[2576,2598,5420,5431],[22,22,11,1,236],false],
['t3782',1197,1795,663,[2791,2813,5420,5431],[22,22,11,1,236],false],
['t3783',1197,1828,663,[2850,2872,5420,5431],[22,22,11,1,236],false],
['t3784',1197,1524,663,[2880,2902,5420,5431],[22,22,11,1,236],false],
['t3785',1197,1804,663,[2909,2930,5420,5431],[21,21,11,1,228],false],
['t3786',1197,1618,663,[2938,2960,5420,5431],[22,22,11,1,232],false],
['t3787',1197,1810,663,[3027,3049,5420,5431],[22,22,11,1,236],false],
['t3788',1197,1623,663,[3056,3078,5420,5431],[23,23,11,1,240],false],
['t3789',1197,1842,663,[3086,3108,5420,5431],[23,23,11,1,240],false],
['t3790',1197,1815,663,[3145,3167,5420,5431],[22,22,11,1,236],false],
['t3791',1197,1610,663,[3330,3352,5420,5431],[22,22,11,1,236],false],
['t3792',1197,1624,663,[3566,3587,5420,5431],[22,22,11,1,232],false],
['t3793',1197,1843,663,[3595,3617,5420,5431],[23,23,11,1,240],false],
['t3794',1197,1816,663,[3654,3676,5420,5431],[22,22,11,1,236],false],
['t3795',1197,1629,663,[3684,3705,5420,5431],[22,22,11,1,232],false],
['t3796',1197,1848,663,[3713,3735,5420,5431],[22,22,11,1,232],false],
['t3797',1197,1611,663,[3840,3862,5420,5431],[23,23,11,1,240],false],
['t3798',1197,1526,663,[3898,3921,5420,5431],[22,22,11,1,236],false],
['t3799',1197,1620,663,[3957,3979,5420,5431],[22,22,11,1,232],false],
['t3800',1197,1533,663,[4016,4038,5420,5431],[22,22,11,1,236],false],
['t3801',1197,1812,663,[4045,4067,5420,5431],[22,22,11,1,232],false],
['t3802',1197,1625,663,[4075,4097,5420,5431],[23,23,11,1,240],false],
['t3803',1197,1538,663,[4133,4156,5420,5431],[23,23,11,1,240],false],
['t3804',1197,1632,663,[4587,4609,5420,5431],[22,22,11,1,232],false],
['t3805',1197,1600,663,[4852,4874,5420,5431],[22,22,11,1,232],false],
['t3806',1197,1820,663,[4881,4904,5420,5431],[23,23,11,1,240],false],
['t3807',1197,1639,663,[4911,4933,5420,5431],[22,22,11,1,236],false],
['t3808',1197,1853,663,[5097,5119,5420,5431],[22,22,11,1,232],false],
['t3809',1511,1205,1201,[582,596,4376,4389],[14,14,14,1,198],false],
['t3810',1511,1203,970,[651,664,4438,4452],[14,14,13,1,189],false],
['t3811',1148,663,1,[561,641,4609,4739],[200,200,10,6,2053],false],
['t3814',835,2937,663,[538,547,4485,4616],[131,131,9,1,1242],false],
['t3816',1201,663,1204,[588,602,4446,4512],[67,67,10,3,703],false],
['t3817',832,2937,663,[529,547,4324,4462],[147,147,10,5,1628],false],
['t3818',846,1205,2937,[511,524,4324,4457],[134,134,10,3,1388],false],
['t3819',1507,1788,990,[425,446,4137,4151],[21,21,14,1,286],false],
['t3820',1507,1183,1209,[211,223,4164,4180],[15,15,12,1,191],false],
['t3821',1210,2938,663,[105,271,4267,4309],[208,208,10,4,2067],false],
['t3822',1215,1212,2938,[87,139,4245,4309],[105,105,10,4,1063],false],
['t3823',1215,1212,2938,[161,271,4246,4269],[122,122,10,5,1253],false],
['t3825',1511,1210,1213,[302,315,4257,4284],[27,27,13,1,343],false],
['t3828',1788,1213,663,[353,409,4246,4310],[110,110,10,2,1134],false],
['t3829',3,1211,663,[310,379,4193,4203],[69,69,10,1,692],false],
['t3830',1209,1211,663,[274,349,4164,4174],[75,75,11,1,818],false],
['t3831',1183,663,1212,[106,192,4175,4232],[133,133,10,4,1352],false],
['t3832',1214,663,1216,[121,195,4404,4417],[75,75,10,3,794],false],
['t3833',1216,663,1215,[117,182,4358,4371],[66,66,11,3,734],false],
['t3836',1507,1214,1215,[107,127,4335,4347],[21,21,13,1,263],false],
['t3837',1211,1217,663,[173,239,4460,4470],[66,66,10,1,682],false],
['t3839',1511,1217,1214,[92,112,4431,4445],[20,20,14,1,289],false],
['t3840',891,1217,663,[82,149,4460,4470],[66,66,10,1,686],false],
['t3841',1511,1218,1083,[336,351,4540,4554],[15,15,14,1,210],false],
['t3842',1269,1852,663,[4941,4963,5389,5399],[22,22,11,1,236],false],
['t3843',1269,1599,663,[4734,4757,5389,5399],[22,22,11,1,236],false],
['t3844',1269,1598,663,[4528,4551,5389,5399],[23,23,11,1,242],false],
['t3845',1269,1527,663,[4293,4315,5389,5399],[22,22,11,1,233],false],
['t3846',1269,1849,663,[4222,4244,5389,5399],[22,22,11,1,236],false],
['t3847',1269,1817,663,[4163,4185,5389,5399],[22,22,11,1,239],false],
['t3848',1269,1806,663,[3927,3950,5389,5399],[22,22,11,1,239],false],
['t3849',1269,1797,663,[3810,3832,5389,5399],[23,23,11,1,242],false],
['t3850',1269,1525,663,[3389,3411,5389,5399],[22,22,11,1,239],false],
['t3851',1269,1829,663,[3359,3382,5389,5399],[22,22,11,1,239],false],
['t3852',1269,1796,663,[3300,3322,5389,5399],[22,22,11,1,239],false],
['t3853',1269,1516,663,[3271,3293,5389,5399],[22,22,11,1,236],false],
['t3854',1269,1847,663,[3203,3225,5389,5399],[22,22,11,1,239],false],
['t3855',1269,1615,663,[2664,2687,5389,5399],[22,22,11,1,239],false],
['t3856',1269,1801,663,[2635,2657,5389,5399],[22,22,11,1,233],false],
['t3857',1269,1792,663,[2517,2540,5389,5399],[22,22,11,1,236],false],
['t3858',1269,1510,663,[2487,2510,5389,5399],[23,23,11,1,242],false],
['t3859',1269,1800,663,[2370,2392,5389,5399],[22,22,11,1,239],false],
['t3860',1269,1604,663,[2281,2304,5389,5399],[22,22,11,1,239],false],
['t3861',1269,1832,663,[2155,2177,5389,5399],[22,22,11,1,236],false],
['t3862',1269,1613,663,[2125,2148,5389,5399],[22,22,11,1,239],false],
['t3863',1269,1798,663,[1772,1794,5389,5399],[22,22,11,1,236],false],
['t3864',1269,1627,663,[1528,1550,5389,5399],[22,22,11,1,236],false],
['t3865',1269,1841,663,[1439,1462,5389,5399],[22,22,11,1,239],false],
['t3866',1269,1809,663,[1381,1403,5389,5399],[22,22,11,1,236],false],
['t3867',1269,1608,663,[1175,1197,5389,5399],[22,22,11,1,236],false],
['t3868',1269,1514,663,[1115,1138,5389,5399],[22,22,11,1,236],false],
['t3869',1269,1808,663,[1048,1070,5389,5399],[22,22,11,1,239],false],
['t3870',1269,1616,663,[959,982,5389,5399],[22,22,11,1,239],false],
['t3871',1198,1513,663,[783,805,5363,5374],[22,22,11,1,239],false],
['t3872',1198,1793,663,[813,835,5363,5374],[22,22,11,1,233],false],
['t3873',1198,1522,663,[901,923,5363,5374],[22,22,11,1,239],false],
['t3874',1198,1802,663,[930,952,5363,5374],[22,22,11,1,236],false],
['t3875',1198,1808,663,[1048,1070,5363,5374],[22,22,11,1,236],false],
['t3876',1198,1794,663,[1145,1167,5363,5374],[22,22,11,1,236],false],
['t3877',1198,1608,663,[1175,1197,5363,5374],[22,22,11,1,236],false],
['t3878',1198,1809,663,[1380,1403,5363,5374],[23,23,11,1,242],false],
['t3879',1198,1841,663,[1440,1462,5363,5374],[22,22,11,1,236],false],
['t3880',1198,1535,663,[1469,1491,5363,5374],[22,22,11,1,236],false],
['t3881',1198,1627,663,[1528,1550,5363,5374],[22,22,11,1,239],false],
['t3882',1198,1602,663,[1684,1707,5363,5374],[23,23,11,1,242],false],
['t3883',1198,1822,663,[1713,1735,5363,5374],[22,22,11,1,230],false],
['t3884',1198,1519,663,[2067,2089,5363,5374],[22,22,11,1,236],false],
['t3885',1198,1613,663,[2126,2148,5363,5374],[22,22,11,1,236],false],
['t3886',1198,1791,663,[2252,2274,5363,5374],[22,22,11,1,236],false],
['t3887',1198,1604,663,[2281,2304,5363,5374],[23,23,11,1,242],false],
['t3888',1198,1520,663,[2340,2363,5363,5374],[22,22,11,1,239],false],
['t3889',1198,1792,663,[2517,2539,5363,5374],[22,22,11,1,233],false],
['t3890',1198,1825,663,[2576,2598,5363,5374],[22,22,11,1,233],false],
['t3891',1198,1521,663,[2606,2628,5363,5374],[22,22,11,1,233],false],
['t3892',1198,1834,663,[2694,2716,5363,5374],[22,22,11,1,233],false],
['t3893',1198,1795,663,[2791,2813,5363,5374],[22,22,11,1,236],false],
['t3894',1198,1609,663,[2820,2843,5363,5374],[22,22,11,1,236],false],
['t3895',1198,1828,663,[2850,2872,5363,5374],[22,22,11,1,239],false],
['t3896',1198,1524,663,[2880,2902,5363,5374],[22,22,11,1,236],false],
['t3897',1198,1618,663,[2938,2961,5363,5374],[22,22,11,1,236],false],
['t3898',1198,1837,663,[2968,2990,5363,5374],[22,22,11,1,236],false],
['t3899',1198,1810,663,[3027,3049,5363,5374],[22,22,11,1,239],false],
['t3900',1198,1623,663,[3056,3079,5363,5374],[22,22,11,1,236],false],
['t3901',1198,1842,663,[3086,3107,5363,5374],[22,22,11,1,233],false],
['t3902',1198,1815,663,[3144,3167,5363,5374],[22,22,11,1,236],false],
['t3903',1198,1847,663,[3203,3226,5363,5374],[22,22,11,1,239],false],
['t3904',1198,1838,663,[3477,3499,5363,5374],[22,22,11,1,236],false],
['t3905',1198,1532,663,[3507,3529,5363,5374],[22,22,11,1,239],false],
['t3906',1198,1624,663,[3566,3588,5363,5374],[22,22,11,1,233],false],
['t3907',1198,1843,663,[3595,3617,5363,5374],[22,22,11,1,233],false],
['t3908',1198,1816,663,[3654,3676,5363,5374],[22,22,11,1,233],false],
['t3909',1198,1629,663,[3683,3706,5363,5374],[22,22,11,1,236],false],
['t3910',1198,1848,663,[3713,3735,5363,5374],[22,22,11,1,233],false],
['t3911',1198,1797,663,[3810,3832,5363,5374],[22,22,11,1,233],false],
['t3912',1198,1611,663,[3839,3862,5363,5374],[22,22,11,1,239],false],
['t3913',1198,1620,663,[3957,3979,5363,5374],[22,22,11,1,239],false],
['t3914',1198,1533,663,[4016,4038,5363,5374],[22,22,11,1,236],false],
['t3915',1198,1812,663,[4045,4067,5363,5374],[22,22,11,1,236],false],
['t3916',1198,1625,663,[4075,4097,5363,5374],[22,22,11,1,236],false],
['t3917',1198,1849,663,[4222,4244,5363,5374],[22,22,11,1,239],false],
['t3918',1198,1534,663,[4410,4433,5363,5374],[22,22,11,1,239],false],
['t3919',1198,1813,663,[4440,4462,5363,5374],[22,22,11,1,236],false],
['t3920',1198,1818,663,[4558,4580,5363,5374],[22,22,11,1,233],false],
['t3921',1198,1632,663,[4587,4609,5363,5374],[22,22,11,1,239],false],
['t3922',1198,1850,663,[4617,4639,5363,5374],[22,22,11,1,233],false],
['t3923',1198,1819,663,[4763,4786,5363,5374],[22,22,11,1,239],false],
['t3924',1198,1820,663,[4882,4904,5363,5374],[22,22,11,1,236],false],
['t3925',1198,1852,663,[4941,4963,5363,5374],[22,22,11,1,239],false],
['t3926',1198,1640,663,[5066,5089,5363,5374],[23,23,11,1,242],false],
['t3927',1266,1793,663,[812,835,5305,5316],[22,22,11,1,239],false],
['t3928',1266,1802,663,[930,953,5305,5316],[22,22,11,1,239],false],
['t3929',1266,1616,663,[960,981,5305,5316],[22,22,11,1,233],false],
['t3930',1266,1835,663,[989,1011,5305,5316],[23,23,11,1,242],false],
['t3931',1266,1808,663,[1047,1070,5305,5316],[23,23,11,1,242],false],
['t3932',1266,1608,663,[1175,1196,5305,5316],[22,22,11,1,233],false],
['t3933',1266,1809,663,[1380,1403,5305,5316],[22,22,11,1,239],false],
['t3934',1266,1841,663,[1439,1462,5305,5316],[22,22,11,1,239],false],
['t3935',1266,1535,663,[1469,1491,5305,5316],[22,22,11,1,233],false],
['t3936',1266,1627,663,[1528,1550,5305,5316],[22,22,11,1,239],false],
['t3937',1266,1822,663,[1713,1735,5305,5316],[22,22,11,1,233],false],
['t3938',1266,1798,663,[1772,1794,5305,5316],[22,22,11,1,239],false],
['t3939',1266,1519,663,[2066,2089,5305,5316],[22,22,11,1,239],false],
['t3940',1266,1613,663,[2126,2148,5305,5316],[22,22,11,1,236],false],
['t3941',1266,1832,663,[2155,2177,5305,5316],[22,22,11,1,233],false],
['t3942',1266,1791,663,[2252,2275,5305,5316],[22,22,11,1,239],false],
['t3943',1266,1604,663,[2282,2304,5305,5316],[22,22,11,1,233],false],
['t3944',1266,1800,663,[2370,2393,5305,5316],[22,22,11,1,239],false],
['t3945',1266,1510,663,[2488,2510,5305,5316],[22,22,11,1,236],false],
['t3946',1266,1825,663,[2576,2598,5305,5316],[22,22,11,1,233],false],
['t3947',1266,1521,663,[2606,2628,5305,5316],[22,22,11,1,236],false],
['t3948',1266,1801,663,[2635,2657,5305,5316],[22,22,11,1,230],false],
['t3949',1266,1615,663,[2664,2686,5305,5316],[22,22,11,1,236],false],
['t3950',1266,1834,663,[2694,2716,5305,5316],[22,22,11,1,236],false],
['t3951',1266,1515,663,[2762,2784,5305,5316],[22,22,11,1,236],false],
['t3952',1266,1609,663,[2821,2843,5305,5316],[22,22,11,1,236],false],
['t3953',1266,1828,663,[2850,2872,5305,5316],[22,22,11,1,233],false],
['t3954',1266,1804,663,[2909,2931,5305,5316],[22,22,11,1,230],false],
['t3955',1266,1618,663,[2939,2960,5305,5316],[22,22,11,1,230],false],
['t3956',1266,1837,663,[2968,2990,5305,5316],[22,22,11,1,233],false],
['t3957',1266,1810,663,[3026,3049,5305,5316],[22,22,11,1,236],false],
['t3958',1266,1628,663,[3174,3196,5305,5316],[22,22,11,1,236],false],
['t3959',1266,1847,663,[3204,3225,5305,5316],[22,22,11,1,233],false],
['t3960',1266,1516,663,[3271,3293,5305,5316],[22,22,11,1,236],false],
['t3961',1266,1525,663,[3389,3411,5305,5316],[22,22,11,1,236],false],
['t3962',1266,1838,663,[3477,3499,5305,5316],[22,22,11,1,236],false],
['t3963',1266,1816,663,[3654,3676,5305,5316],[22,22,11,1,239],false],
['t3964',1266,1629,663,[3683,3706,5305,5316],[22,22,11,1,236],false],
['t3965',1266,1797,663,[3810,3832,5305,5316],[22,22,11,1,239],false],
['t3966',1266,1817,663,[4163,4185,5305,5316],[22,22,11,1,239],false],
['t3967',1266,1849,663,[4222,4244,5305,5316],[22,22,11,1,236],false],
['t3968',1266,1527,663,[4293,4315,5305,5316],[22,22,11,1,239],false],
['t3969',1266,1807,663,[4322,4345,5305,5316],[22,22,11,1,236],false],
['t3970',1266,1534,663,[4411,4433,5305,5316],[22,22,11,1,236],false],
['t3971',1266,1813,663,[4440,4462,5305,5316],[22,22,11,1,236],false],
['t3972',1266,1845,663,[4499,4521,5305,5316],[22,22,11,1,236],false],
['t3973',1266,1598,663,[4528,4551,5305,5316],[22,22,11,1,239],false],
['t3974',1266,1632,663,[4587,4609,5305,5316],[22,22,11,1,239],false],
['t3975',1266,1599,663,[4734,4757,5305,5316],[22,22,11,1,239],false],
['t3976',1266,1851,663,[4823,4845,5305,5316],[22,22,11,1,236],false],
['t3977',1266,1600,663,[4852,4875,5305,5316],[22,22,11,1,239],false],
['t3978',1266,1820,663,[4882,4904,5305,5316],[22,22,11,1,239],false],
['t3979',1266,1639,663,[4911,4933,5305,5316],[22,22,11,1,236],false],
['t3980',1266,1852,663,[4941,4963,5305,5316],[22,22,11,1,236],false],
['t3981',1266,1821,663,[5038,5060,5305,5316],[22,22,11,1,233],false],
['t3982',1268,1639,663,[4911,4933,5332,5342],[22,22,11,1,233],false],
['t3983',1268,1600,663,[4852,4874,5332,5342],[22,22,11,1,233],false],
['t3984',1268,1851,663,[4822,4845,5332,5342],[22,22,11,1,239],false],
['t3985',1268,1599,663,[4734,4757,5332,5342],[22,22,11,1,239],false],
['t3986',1268,1598,663,[4529,4551,5332,5342],[22,22,11,1,233],false],
['t3987',1268,1845,663,[4499,4521,5332,5342],[22,22,11,1,230],false],
['t3988',1268,1840,663,[4381,4403,5332,5342],[22,22,11,1,236],false],
['t3989',1268,1527,663,[4293,4315,5332,5342],[22,22,11,1,236],false],
['t3990',1268,1630,663,[4193,4215,5332,5342],[22,22,11,1,236],false],
['t3991',1268,1817,663,[4163,4185,5332,5342],[22,22,11,1,233],false],
['t3992',1268,1538,663,[4133,4156,5332,5342],[22,22,11,1,236],false],
['t3993',1268,1526,663,[3898,3921,5332,5342],[22,22,11,1,236],false],
['t3994',1268,1525,663,[3388,3411,5332,5342],[22,22,11,1,239],false],
['t3995',1268,1829,663,[3359,3381,5332,5342],[22,22,11,1,239],false],
['t3996',1268,1610,663,[3330,3352,5332,5342],[22,22,11,1,236],false],
['t3997',1268,1796,663,[3300,3322,5332,5342],[22,22,11,1,236],false],
['t3998',1268,1516,663,[3271,3293,5332,5342],[22,22,11,1,233],false],
['t3999',1268,1628,663,[3174,3196,5332,5342],[22,22,11,1,236],false],
['t4000',1268,1804,663,[2909,2931,5332,5342],[22,22,11,1,233],false],
['t4001',1268,1515,663,[2761,2784,5332,5342],[22,22,11,1,239],false],
['t4002',1268,1615,663,[2664,2687,5332,5342],[23,23,11,1,242],false],
['t4003',1268,1801,663,[2635,2657,5332,5342],[22,22,11,1,236],false],
['t4004',1268,1510,663,[2488,2510,5332,5342],[22,22,11,1,239],false],
['t4005',1268,1800,663,[2370,2392,5332,5342],[22,22,11,1,233],false],
['t4006',1268,1832,663,[2155,2177,5332,5342],[22,22,11,1,239],false],
['t4007',1268,1798,663,[1772,1794,5332,5342],[22,22,11,1,236],false],
['t4008',1268,1529,663,[1019,1041,5332,5342],[22,22,11,1,233],false],
['t4009',1268,1835,663,[989,1011,5332,5342],[22,22,11,1,239],false],
['t4010',1268,1616,663,[960,981,5332,5342],[22,22,11,1,233],false],
['t4011',1199,1827,663,[1204,1226,5248,5259],[22,22,11,1,236],false],
['t4012',1199,1803,663,[1263,1285,5248,5259],[23,23,11,1,242],false],
['t4013',1199,1617,663,[1292,1314,5248,5259],[22,22,11,1,233],false],
['t4014',1199,1836,663,[1322,1344,5248,5259],[22,22,11,1,233],false],
['t4015',1199,1530,663,[1351,1373,5248,5259],[22,22,11,1,236],false],
['t4016',1199,1612,663,[1801,1824,5248,5259],[22,22,11,1,239],false],
['t4017',1199,1506,663,[1948,1971,5248,5259],[23,23,11,1,242],false],
['t4018',1199,1520,663,[2341,2363,5248,5259],[22,22,11,1,236],false],
['t4019',1199,1614,663,[2399,2422,5248,5259],[22,22,11,1,239],false],
['t4020',1199,1792,663,[2517,2539,5248,5259],[22,22,11,1,233],false],
['t4021',1199,1801,663,[2635,2657,5248,5259],[22,22,11,1,230],false],
['t4022',1199,1804,663,[2909,2932,5248,5259],[23,23,11,1,242],false],
['t4023',1199,1623,663,[3056,3078,5248,5259],[22,22,11,1,233],false],
['t4024',1199,1619,663,[3447,3470,5248,5259],[22,22,11,1,236],false],
['t4025',1199,1624,663,[3565,3587,5248,5259],[22,22,11,1,239],false],
['t4026',1199,1537,663,[3625,3646,5248,5259],[22,22,11,1,233],false],
['t4027',1199,1611,663,[3839,3862,5248,5259],[23,23,11,1,242],false],
['t4028',1199,1830,663,[3869,3891,5248,5259],[22,22,11,1,236],false],
['t4029',1199,1625,663,[4075,4097,5248,5259],[22,22,11,1,236],false],
['t4030',1199,1817,663,[4163,4186,5248,5259],[22,22,11,1,239],false],
['t4031',1199,1600,663,[4852,4875,5248,5259],[23,23,11,1,242],false],
['t4032',1267,1819,663,[4764,4785,5274,5284],[21,21,11,1,228],false],
['t4033',1267,1850,663,[4616,4639,5274,5284],[23,23,11,1,244],false],
['t4034',1267,1818,663,[4558,4580,5274,5284],[22,22,11,1,236],false],
['t4035',1267,1840,663,[4381,4403,5274,5284],[22,22,11,1,236],false],
['t4036',1267,1630,663,[4193,4215,5274,5284],[22,22,11,1,232],false],
['t4037',1267,1538,663,[4133,4156,5274,5284],[22,22,11,1,236],false],
['t4038',1267,1625,663,[4075,4097,5274,5284],[23,23,11,1,240],false],
['t4039',1267,1812,663,[4045,4067,5274,5284],[22,22,11,1,232],false],
['t4040',1267,1533,663,[4016,4038,5274,5284],[21,21,11,1,228],false],
['t4041',1267,1620,663,[3957,3979,5274,5284],[22,22,11,1,236],false],
['t4042',1267,1806,663,[3928,3949,5274,5284],[22,22,11,1,232],false],
['t4043',1267,1526,663,[3898,3920,5274,5284],[22,22,11,1,236],false],
['t4044',1267,1611,663,[3839,3861,5274,5284],[22,22,11,1,236],false],
['t4045',1267,1843,663,[3595,3617,5274,5284],[22,22,11,1,236],false],
['t4046',1267,1624,663,[3566,3587,5274,5284],[22,22,11,1,232],false],
['t4047',1267,1811,663,[3536,3558,5274,5284],[22,22,11,1,236],false],
['t4048',1267,1829,663,[3359,3382,5274,5284],[23,23,11,1,240],false],
['t4049',1267,1610,663,[3330,3352,5274,5284],[22,22,11,1,232],false],
['t4050',1267,1796,663,[3300,3322,5274,5284],[23,23,11,1,240],false],
['t4051',1267,1815,663,[3144,3167,5274,5284],[23,23,11,1,240],false],
['t4052',1267,1623,663,[3056,3078,5274,5284],[22,22,11,1,236],false],
['t4053',1267,1524,663,[2879,2901,5274,5284],[22,22,11,1,236],false],
['t4054',1267,1792,663,[2517,2539,5274,5284],[22,22,11,1,236],false],
['t4055',1267,1794,663,[1145,1167,5274,5284],[23,23,11,1,240],false],
['t4056',1267,1514,663,[1115,1138,5274,5284],[23,23,11,1,244],false],
['t4057',1267,1529,663,[1018,1041,5274,5284],[22,22,11,1,236],false],
['t4058',1267,1522,663,[900,923,5274,5284],[23,23,11,1,244],false],
['t4059',1267,1607,663,[841,864,5274,5284],[23,23,11,1,240],false],
['t4060',1267,1513,663,[783,805,5274,5284],[22,22,11,1,236],false],
['t4061',1511,1192,1220,[80,103,4514,4528],[23,23,13,1,307],false],
['t4062',1511,1222,1223,[628,642,5248,5262],[14,14,14,1.5,196],false],
['t4064',2,1223,663,[575,633,5195,5231],[84,84,10,3,855],false],
['t4066',1224,663,1528,[478,642,5128,5140],[164,164,11,1,1839],false],
['t4067',1224,663,1528,[464,642,5142,5169],[195,195,10,4,1987],false],
['t4068',1240,1224,663,[496,628,5097,5108],[133,133,11,1,1413],false],
['t4069',1240,1528,31,[673,683,5086,5233],[147,147,10,1,1518],false],
['t4070',1240,1528,31,[579,590,5003,5040],[38,38,11,1,403],false],
['t4073',1227,663,1237,[97,319,4906,4949],[253,253,10,5,2694],false],
['t4074',1227,663,1964,[97,319,4959,4969],[222,222,10,1,2300],false],
['t4075',1227,663,1964,[97,319,4993,5003],[222,222,11,1,2419],false],
['t4076',1227,663,1964,[97,319,5024,5035],[222,222,11,1,2357],false],
['t4077',1227,663,1964,[97,319,5058,5068],[222,222,10,1,2291],false],
['t4078',1227,663,1964,[97,319,5088,5099],[222,222,11,1,2429],false],
['t4079',1227,663,1964,[97,319,5122,5134],[222,222,11,1,2519],false],
['t4081',1237,31,1964,[111,337,5236,5256],[236,236,10,3,2250],false],
['t4082',1237,1964,31,[94,337,5212,5223],[242,242,11,1,2579],false],
['t4083',1237,31,1964,[94,337,5181,5193],[242,242,11,1,2728],false],
['t4084',1237,1964,31,[330,351,4915,5176],[272,272,10,2,2816],false],
['t4086',1508,1228,663,[100,162,4738,4810],[183,183,10,4,1874],false],
['t4088',1228,1227,663,[83,358,4826,4869],[325,325,11,6.5,3278],false],
['t4089',1234,663,1231,[94,201,4638,4649],[106,106,11,1,1119],false],
['t4090',1507,31,1225,[418,454,4978,4989],[36,36,11,1,387],false],
['t4091',1507,1225,31,[367,464,4950,5017],[174,174,11,3,1823],false],
['t4092',1507,1226,663,[445,616,4916,4930],[173,173,11,3,1960],false],
['t4093',1226,663,1225,[486,649,4968,5005],[257,257,10,7,2716],false],
['t4094',1226,663,1225,[474,649,4938,4958],[184,184,11,3,2012],false],
['t4095',1225,663,1240,[613,658,4997,5061],[98,98,10,3,1013],false],
['t4096',2,663,1226,[459,628,4891,4908],[174,174,11,3,1987],false],
['t4098',1238,1226,663,[478,652,4856,4873],[180,180,11,3,1926],false],
['t4100',849,1238,663,[400,410,4782,4852],[70,70,10,1,704],false],
['t4101',1230,663,1228,[209,345,4758,4798],[180,180,10,4,1823],false],
['t4102',1231,1236,663,[120,186,4682,4693],[66,66,11,1,702],false],
['t4103',1231,663,1228,[84,184,4694,4784],[179,179,10,4,1852],false],
['t4104',1507,1229,1236,[204,219,4710,4723],[15,15,13,1,201],false],
['t4105',1229,1233,663,[230,298,4741,4761],[77,77,10,2,830],false],
['t4108',1511,1230,1233,[311,324,4729,4748],[19,19,13,1,252],false],
['t4110',2,663,1231,[243,351,4638,4648],[107,107,11,1,1147],false],
['t4111',1220,1234,663,[94,200,4600,4610],[106,106,11,1,1124],false],
['t4112',1232,663,1234,[105,201,4558,4586],[115,115,10,4,1123],false],
['t4114',1086,1234,663,[238,342,4600,4616],[107,107,10,5,1111],false],
['t4115',1218,663,1234,[225,328,4573,4586],[104,104,10,3,1020],false],
['t4116',1081,1235,663,[178,281,4544,4557],[103,103,11,3,1086],false],
['t4118',1511,1232,1235,[141,154,4529,4543],[14,14,13,1,188],false],
['t4119',1265,1852,663,[4941,4963,5217,5227],[22,22,11,1,239],false],
['t4120',1265,1639,663,[4912,4934,5217,5227],[22,22,11,1,234],false],
['t4121',1265,1820,663,[4883,4903,5217,5227],[20,20,11,1,216],false],
['t4122',1265,1638,663,[4794,4815,5217,5227],[21,21,11,1,227],false],
['t4123',1265,1621,663,[4352,4374,5217,5227],[22,22,11,1,237],false],
['t4124',1265,1839,663,[3987,4009,5217,5227],[22,22,11,1,229],false],
['t4125',1265,1620,663,[3958,3979,5217,5227],[22,22,11,1,230],false],
['t4126',1265,1525,663,[3389,3411,5217,5227],[21,21,11,1,228],false],
['t4127',1265,1815,663,[3144,3166,5217,5227],[22,22,11,1,239],false],
['t4128',1265,1524,663,[2880,2901,5217,5227],[21,21,11,1,225],false],
['t4129',1265,1605,663,[2547,2569,5217,5227],[22,22,11,1,236],false],
['t4130',1265,1510,663,[2489,2510,5217,5227],[21,21,11,1,225],false],
['t4131',1265,1833,663,[2429,2451,5217,5227],[22,22,11,1,231],false],
['t4132',1265,1800,663,[2371,2392,5217,5227],[21,21,11,1,227],false],
['t4133',1265,1824,663,[2312,2333,5217,5227],[22,22,11,1,230],false],
['t4134',1265,1604,663,[2282,2304,5217,5227],[22,22,11,1,231],false],
['t4135',1265,1832,663,[2155,2177,5217,5227],[22,22,11,1,237],false],
['t4136',1265,1799,663,[2097,2119,5217,5227],[22,22,11,1,233],false],
['t4137',1265,1823,663,[2038,2059,5217,5227],[22,22,11,1,233],false],
['t4138',1265,1790,663,[1979,2001,5217,5227],[21,21,11,1,228],false],
['t4139',1265,1831,663,[1831,1854,5217,5227],[23,23,11,1,244],false],
['t4140',1265,1798,663,[1772,1794,5217,5227],[22,22,11,1,236],false],
['t4141',1265,1789,663,[1655,1677,5217,5227],[22,22,11,1,235],false],
['t4142',1265,1627,663,[1528,1551,5217,5227],[23,23,11,1,241],false],
['t4143',1265,1814,663,[1499,1521,5217,5227],[22,22,11,1,229],false],
['t4144',1265,1622,663,[1410,1432,5217,5227],[22,22,11,1,238],false],
['t4145',1265,1608,663,[1174,1197,5217,5227],[23,23,11,1,240],false],
['t4146',1265,1616,663,[959,982,5217,5227],[23,23,11,1,248],false],
['t4147',1200,1808,663,[1048,1070,5190,5201],[22,22,11,1,233],false],
['t4148',1200,1827,663,[1204,1225,5190,5201],[21,21,11,1,228],false],
['t4149',1200,1803,663,[1263,1285,5190,5201],[22,22,11,1,231],false],
['t4150',1200,1622,663,[1410,1432,5190,5201],[23,23,11,1,240],false],
['t4151',1200,1814,663,[1499,1521,5190,5201],[22,22,11,1,230],false],
['t4152',1200,1505,663,[1625,1648,5190,5201],[23,23,11,1,243],false],
['t4153',1200,1822,663,[1713,1736,5190,5201],[22,22,11,1,239],false],
['t4154',1200,1831,663,[1831,1853,5190,5201],[22,22,11,1,235],false],
['t4155',1200,1506,663,[1950,1971,5190,5201],[22,22,11,1,229],false],
['t4156',1200,1799,663,[2097,2118,5190,5201],[21,21,11,1,229],false],
['t4157',1200,1509,663,[2224,2245,5190,5201],[21,21,11,1,225],false],
['t4158',1200,1824,663,[2312,2333,5190,5201],[21,21,11,1,224],false],
['t4159',1200,1520,663,[2341,2363,5190,5201],[21,21,11,1,229],false],
['t4160',1200,1614,663,[2400,2422,5190,5201],[23,23,11,1,241],false],
['t4161',1200,1833,663,[2429,2451,5190,5201],[21,21,11,1,228],false],
['t4162',1200,1792,663,[2518,2539,5190,5201],[21,21,11,1,223],false],
['t4163',1200,1605,663,[2547,2569,5190,5201],[22,22,11,1,232],false],
['t4164',1200,1801,663,[2636,2657,5190,5201],[21,21,11,1,227],false],
['t4165',1200,1804,663,[2910,2931,5190,5201],[21,21,11,1,225],false],
['t4166',1200,1531,663,[2998,3019,5190,5201],[21,21,11,1,225],false],
['t4167',1200,1623,663,[3057,3078,5190,5201],[22,22,11,1,229],false],
['t4168',1200,1624,663,[3566,3588,5190,5201],[22,22,11,1,235],false],
['t4169',1200,1625,663,[4076,4097,5190,5201],[21,21,11,1,225],false],
['t4170',1262,1808,663,[1048,1070,5133,5144],[22,22,11,1,236],false],
['t4171',1262,1535,663,[1470,1491,5133,5144],[22,22,11,1,233],false],
['t4172',1262,1505,663,[1625,1647,5133,5144],[22,22,11,1,232],false],
['t4173',1262,1822,663,[1713,1736,5133,5144],[23,23,11,1,242],false],
['t4174',1262,1519,663,[2067,2089,5133,5144],[22,22,11,1,237],false],
['t4175',1262,1509,663,[2222,2245,5133,5144],[22,22,11,1,239],false],
['t4176',1262,1834,663,[2694,2716,5133,5144],[22,22,11,1,233],false],
['t4177',1262,1531,663,[2996,3019,5133,5144],[23,23,11,1,245],false],
['t4178',1262,1532,663,[3507,3529,5133,5144],[21,21,11,1,228],false],
['t4179',1262,1811,663,[3537,3559,5133,5144],[22,22,11,1,230],false],
['t4180',1262,1843,663,[3595,3617,5133,5144],[22,22,11,1,232],false],
['t4181',1262,1816,663,[3653,3676,5133,5144],[24,24,11,1,252],false],
['t4182',1262,1629,663,[3684,3706,5133,5144],[22,22,11,1,232],false],
['t4183',1262,1517,663,[3780,3803,5133,5144],[23,23,11,1,245],false],
['t4184',1262,1830,663,[3868,3891,5133,5144],[23,23,11,1,242],false],
['t4185',1262,1839,663,[3986,4009,5133,5144],[23,23,11,1,245],false],
['t4186',1262,1527,663,[4292,4315,5133,5144],[23,23,11,1,249],false],
['t4187',1262,1598,663,[4527,4551,5133,5144],[24,24,11,1,252],false],
['t4188',1262,1850,663,[4616,4638,5133,5144],[22,22,11,1,239],false],
['t4189',1262,1599,663,[4734,4756,5133,5144],[23,23,11,1,242],false],
['t4190',1262,1819,663,[4763,4786,5133,5144],[23,23,11,1,242],false],
['t4191',1264,1852,663,[4941,4962,5159,5170],[22,22,11,1,233],false],
['t4192',1264,1639,663,[4911,4933,5159,5170],[22,22,11,1,236],false],
['t4193',1264,1820,663,[4881,4903,5159,5170],[22,22,11,1,236],false],
['t4194',1264,1600,663,[4852,4875,5159,5170],[23,23,11,1,242],false],
['t4195',1264,1638,663,[4792,4815,5159,5170],[23,23,11,1,242],false],
['t4196',1264,1626,663,[4468,4492,5159,5170],[24,24,11,1,252],false],
['t4197',1264,1621,663,[4350,4374,5159,5170],[24,24,11,1,252],false],
['t4198',1264,1817,663,[4162,4186,5159,5170],[24,24,11,1,252],false],
['t4199',1264,1812,663,[4045,4068,5159,5170],[23,23,11,1,242],false],
['t4200',1264,1839,663,[3987,4009,5159,5170],[21,21,11,1,226],false],
['t4201',1264,1620,663,[3956,3979,5159,5170],[23,23,11,1,245],false],
['t4202',1264,1830,663,[3868,3891,5159,5170],[23,23,11,1,249],false],
['t4203',1264,1611,663,[3839,3861,5159,5170],[22,22,11,1,239],false],
['t4204',1264,1537,663,[3624,3647,5159,5170],[23,23,11,1,245],false],
['t4205',1264,1619,663,[3448,3470,5159,5170],[22,22,11,1,232],false],
['t4206',1264,1525,663,[3388,3411,5159,5170],[23,23,11,1,245],false],
['t4207',1264,1815,663,[3144,3167,5159,5170],[23,23,11,1,242],false],
['t4208',1264,1524,663,[2878,2901,5159,5170],[23,23,11,1,245],false],
['t4209',1264,1510,663,[2487,2510,5159,5170],[23,23,11,1,245],false],
['t4210',1264,1800,663,[2369,2392,5159,5170],[23,23,11,1,242],false],
['t4211',1264,1604,663,[2281,2304,5159,5170],[23,23,11,1,249],false],
['t4212',1264,1832,663,[2155,2177,5159,5170],[22,22,11,1,237],false],
['t4213',1264,1823,663,[2038,2060,5159,5170],[22,22,11,1,236],false],
['t4214',1264,1603,663,[2008,2030,5159,5170],[22,22,11,1,234],false],
['t4215',1264,1790,663,[1977,2001,5159,5170],[23,23,11,1,249],false],
['t4216',1264,1612,663,[1801,1824,5159,5170],[23,23,11,1,248],false],
['t4217',1264,1798,663,[1772,1794,5159,5170],[22,22,11,1,236],false],
['t4218',1264,1518,663,[1743,1765,5159,5170],[22,22,11,1,237],false],
['t4219',1264,1627,663,[1528,1550,5159,5170],[22,22,11,1,238],false],
['t4220',1264,1836,663,[1322,1345,5159,5170],[23,23,11,1,243],false],
['t4221',1264,1617,663,[1292,1314,5159,5170],[22,22,11,1,238],false],
['t4222',1264,1616,663,[960,982,5159,5170],[21,21,11,1,227],false],
['t4224',1511,1241,1243,[6214,6227,5190,5211],[22,22,13,1,275],false],
['t4225',1511,1242,1244,[6214,6227,5160,5182],[22,22,13,1,275],false],
['t4227',664,663,1243,[6305,6426,5160,5190],[149,149,11,3,1670],false],
['t4228',691,1244,663,[6287,6401,5071,5119],[150,150,11,3,1823],false],
['t4229',1511,8,1245,[6156,6213,5099,5113],[56,56,14,1,784],false],
['t4230',1245,663,1247,[6294,6414,5225,5239],[122,122,10,3,1264],false],
['t4232',670,663,1247,[6269,6396,5249,5263],[128,128,11,3,1469],false],
['t4233',1511,1248,1247,[6158,6171,5281,5304],[22,22,13,1,292],false],
['t4234',1245,663,1254,[6283,6404,5351,5366],[122,122,11,3,1391],false],
['t4235',1245,663,1253,[6284,6404,5414,5429],[121,121,11,3,1348],false],
['t4236',1245,663,1252,[6283,6404,5490,5504],[122,122,11,3,1346],false],
['t4237',1245,663,1251,[6284,6404,5553,5567],[121,121,10,3,1284],false],
['t4239',686,663,1250,[6277,6405,5608,5620],[128,128,12,1,1582],false],
['t4240',683,1251,663,[6277,6404,5576,5591],[129,129,12,3,1459],false],
['t4245',1511,1255,1251,[6181,6195,5552,5575],[23,23,14,1,327],false],
['t4246',1511,1256,1252,[6181,6195,5480,5501],[22,22,14,1,306],false],
['t4247',1511,1257,1253,[6157,6171,5415,5438],[22,22,14,1,319],false],
['t4248',1511,1258,1254,[6157,6171,5341,5365],[23,23,14,1,325],false],
['t4249',1511,1249,1250,[6161,6175,5603,5625],[22,22,14,1,305],false],
['t4250',677,663,1252,[6275,6404,5466,5481],[130,130,12,3,1598],false],
['t4251',676,1253,663,[6275,6404,5437,5452],[130,130,12,3,1518],false],
['t4252',669,663,1254,[6277,6404,5328,5343],[129,129,12,3,1603],false],
['t4254',1225,1259,663,[5294,5456,5019,5079],[210,210,11,2,2315],false],
['t4257',1259,1261,663,[5328,5486,5118,5135],[181,181,11,9,1916],false],
['t4258',1259,663,1260,[5328,5486,5144,5161],[183,183,10,9,1788],false],
['t4259',1273,663,1260,[5509,5668,5144,5165],[190,190,10,9,1855],false],
['t4260',1279,1261,663,[5509,5668,5119,5135],[179,179,11,9,1857],false],
['t4262',1259,1263,663,[5328,5486,5194,5210],[181,181,11,9,1916],false],
['t4263',1259,663,1262,[5328,5486,5220,5236],[183,183,10,9,1788],false],
['t4264',1272,663,1262,[5509,5668,5220,5240],[190,190,10,9,1855],false],
['t4265',1278,1263,663,[5509,5668,5194,5210],[179,179,11,9,1857],false],
['t4268',1259,1264,663,[5328,5486,5269,5286],[181,181,11,9,1916],false],
['t4269',1259,663,1200,[5328,5486,5295,5311],[183,183,10,9,1788],false],
['t4270',1284,663,1200,[5509,5668,5295,5315],[190,190,10,9,1855],false],
['t4271',1299,1264,663,[5509,5668,5269,5285],[179,179,11,9,1857],false],
['t4275',1259,1265,663,[5328,5486,5344,5361],[181,181,11,9,1916],false],
['t4276',1259,663,1199,[5328,5486,5370,5386],[183,183,10,9,1788],false],
['t4277',1283,663,1199,[5509,5668,5370,5390],[190,190,10,9,1855],false],
['t4278',1298,1265,663,[5509,5668,5344,5360],[179,179,11,9,1857],false],
['t4280',1259,1267,663,[5328,5486,5419,5436],[181,181,11,9,1916],false],
['t4281',1259,663,1266,[5328,5486,5445,5461],[183,183,10,9,1788],false],
['t4282',1282,663,1266,[5509,5668,5445,5466],[190,190,10,9,1855],false],
['t4283',1297,1267,663,[5509,5668,5420,5435],[179,179,11,9,1857],false],
['t4286',1259,1268,663,[5328,5486,5494,5511],[181,181,11,9,1916],false],
['t4287',1259,663,1198,[5328,5486,5520,5536],[183,183,10,9,1788],false],
['t4288',1281,663,1198,[5509,5668,5520,5541],[190,190,10,9,1855],false],
['t4289',1296,1268,663,[5509,5668,5495,5511],[179,179,11,9,1857],false],
['t4293',1259,1269,663,[5328,5486,5569,5586],[181,181,11,9,1916],false],
['t4294',1259,663,1197,[5328,5486,5595,5611],[183,183,10,9,1788],false],
['t4295',1280,663,1197,[5509,5668,5595,5616],[190,190,10,9,1855],false],
['t4296',1290,1269,663,[5509,5668,5570,5586],[179,179,11,9,1857],false],
['t4299',1259,1271,663,[5328,5486,5644,5661],[181,181,11,9,1916],false],
['t4300',1259,663,1270,[5328,5486,5670,5686],[183,183,10,9,1788],false],
['t4301',1300,663,1270,[5509,5668,5670,5691],[190,190,10,9,1855],false],
['t4302',1302,1271,663,[5509,5668,5645,5661],[179,179,11,9,1857],false],
['t4303',1278,663,1272,[5697,5790,5215,5235],[103,103,10,3,1004],false],
['t4304',1279,663,1273,[5697,5790,5140,5160],[103,103,10,3,1004],false],
['t4307',1274,1278,663,[5711,5814,5194,5205],[103,103,11,1,1109],false],
['t4308',1277,1279,663,[5711,5814,5119,5130],[103,103,11,1,1109],false],
['t4311',1528,1274,1275,[5971,5985,5193,5208],[14,14,14,1,202],false],
['t4312',1528,1277,1276,[5971,5985,5118,5133],[14,14,14,1,202],false],
['t4313',1304,1272,1274,[5959,5974,5222,5236],[15,15,14,1,207],false],
['t4314',1304,1273,1277,[5959,5974,5146,5161],[15,15,14,1,207],false],
['t4315',1245,663,1275,[6083,6185,5216,5229],[103,103,10,3,1081],false],
['t4318',1241,1275,663,[6082,6185,5194,5208],[104,104,11,3,1137],false],
['t4319',1242,663,1276,[6082,6185,5166,5179],[104,104,10,3,1036],false],
['t4320',1245,663,1276,[6080,6185,5137,5158],[115,115,11,2,1299],false],
['t4321',1290,663,1280,[5697,5790,5591,5611],[103,103,10,3,1004],false],
['t4322',1296,663,1281,[5697,5790,5516,5535],[103,103,10,3,1004],false],
['t4323',1297,663,1282,[5697,5790,5441,5460],[103,103,10,3,1004],false],
['t4324',1298,663,1283,[5697,5790,5365,5385],[103,103,10,3,1004],false],
['t4325',1299,663,1284,[5697,5790,5290,5310],[103,103,10,3,1004],false],
['t4331',1285,1290,663,[5711,5814,5570,5580],[103,103,11,1,1109],false],
['t4332',1286,1296,663,[5711,5814,5495,5505],[103,103,11,1,1109],false],
['t4333',1287,1297,663,[5711,5814,5419,5430],[103,103,11,1,1109],false],
['t4334',1288,1298,663,[5711,5814,5344,5355],[103,103,11,1,1109],false],
['t4335',1289,1299,663,[5711,5814,5269,5280],[103,103,11,1,1109],false],
['t4341',1528,1285,1291,[5971,5985,5569,5583],[14,14,14,1,202],false],
['t4342',1528,1286,1294,[5971,5985,5494,5508],[14,14,14,1,202],false],
['t4343',1528,1287,1292,[5971,5985,5419,5433],[14,14,14,1,202],false],
['t4344',1528,1288,1295,[5971,5985,5344,5358],[14,14,14,1,202],false],
['t4345',1528,1289,1293,[5971,5985,5269,5283],[14,14,14,1,202],false],
['t4346',1304,1280,1285,[5959,5974,5597,5611],[15,15,14,1,207],false],
['t4347',1304,1281,1286,[5959,5974,5522,5536],[15,15,14,1,207],false],
['t4348',1304,1282,1287,[5959,5974,5447,5461],[15,15,14,1,207],false],
['t4349',1304,1283,1288,[5959,5974,5372,5386],[15,15,14,1,207],false],
['t4350',1304,1284,1289,[5959,5974,5297,5311],[15,15,14,1,207],false],
['t4356',1255,1291,663,[6025,6128,5534,5548],[104,104,11,3,1138],false],
['t4357',1256,663,1294,[6025,6127,5506,5520],[104,104,11,3,1163],false],
['t4358',1257,1292,663,[6024,6127,5421,5435],[104,104,11,3,1130],false],
['t4359',1258,663,1295,[6020,6123,5357,5370],[106,106,10,3,1090],false],
['t4360',1248,663,1293,[6020,6122,5271,5285],[103,103,11,3,1140],false],
['t4362',1448,1305,663,[6154,6315,5732,5743],[162,162,11,1,1769],false],
['t4363',1168,663,1306,[5774,5948,5861,5903],[270,270,11,7,2853],false],
['t4364',1168,663,1306,[5782,5842,5892,5930],[128,128,11,3,1387],false],
['t4365',1307,663,1306,[5768,5950,5913,5995],[490,490,11,12,5159],false],
['t4367',1307,663,1965,[5927,6088,6088,6174],[598,598,11,13,6419],false],
['t4368',1307,663,1965,[5927,6356,6150,6205],[838,838,10,21,8687],false],
['t4369',1168,1307,663,[5856,5897,6004,6203],[384,384,11,3,4087],false],
['t4370',1308,663,1307,[5771,5845,6042,6203],[404,404,10,9.5,4204],false],
['t4371',1306,1965,31,[5989,6411,5843,5960],[681,681,10,26,7377],false],
['t4372',1306,31,1965,[5977,6088,5882,5924],[242,242,11,3,2537],false],
['t4373',1306,31,1965,[5977,6087,5934,5975],[241,241,11,3,2543],false],
['t4375',1306,31,1965,[5974,6088,5985,6078],[482,482,11,7,5004],false],
['t4376',1302,663,1300,[5697,5790,5666,5686],[103,103,10,3,1004],false],
['t4378',1301,1302,663,[5711,5814,5645,5655],[103,103,11,1,1109],false],
['t4380',1528,663,1304,[6070,6136,5685,5695],[66,66,10,1,661],false],
['t4381',1304,1300,1301,[5959,5974,5673,5686],[15,15,13,1,189],false],
['t4383',1528,1301,1303,[5971,5985,5644,5658],[14,14,14,1,202],false],
['t4385',1245,663,1303,[6070,6174,5631,5655],[117,117,11,3,1269],false],
['t4386',1249,663,1303,[6031,6134,5609,5620],[103,103,11,1,1153],false],
['t4387',1507,1308,1305,[5794,5830,6006,6021],[35,35,15,1,511],false],
['t4388',1260,1534,663,[4410,4432,5075,5086],[22,22,11,1,236],false],
['t4389',1260,1813,663,[4439,4462,5075,5086],[23,23,11,1,244],false],
['t4390',1260,1845,663,[4498,4520,5075,5086],[22,22,11,1,236],false],
['t4391',1260,1851,663,[4822,4843,5075,5086],[21,21,11,1,224],false],
['t4392',1260,1513,663,[783,804,5075,5086],[22,22,11,1,230],false],
['t4393',1260,1793,663,[811,834,5075,5086],[23,23,11,1,246],false],
['t4394',1260,1608,663,[1174,1196,5075,5086],[22,22,11,1,234],false],
['t4395',1260,1617,663,[1292,1314,5075,5086],[22,22,11,1,234],false],
['t4396',1260,1836,663,[1322,1344,5075,5086],[22,22,11,1,239],false],
['t4397',1260,1809,663,[1380,1403,5075,5086],[23,23,11,1,240],false],
['t4398',1260,1841,663,[1440,1462,5075,5086],[22,22,11,1,239],false],
['t4399',1260,1627,663,[1528,1550,5075,5086],[22,22,11,1,233],false],
['t4400',1260,1789,663,[1655,1676,5075,5086],[21,21,11,1,223],false],
['t4401',1260,1602,663,[1684,1706,5075,5086],[22,22,11,1,239],false],
['t4402',1260,1612,663,[1801,1824,5075,5086],[23,23,11,1,243],false],
['t4403',1260,1506,663,[1947,1970,5075,5086],[23,23,11,1,244],false],
['t4404',1260,1790,663,[1977,2001,5075,5086],[24,24,11,1,256],false],
['t4405',1260,1823,663,[2038,2059,5075,5086],[22,22,11,1,233],false],
['t4406',1260,1613,663,[2125,2148,5075,5086],[23,23,11,1,241],false],
['t4407',1260,1791,663,[2251,2273,5075,5086],[22,22,11,1,236],false],
['t4408',1260,1604,663,[2280,2304,5075,5086],[24,24,11,1,256],false],
['t4409',1260,1605,663,[2545,2569,5075,5086],[24,24,11,1,256],false],
['t4410',1260,1609,663,[2819,2843,5075,5086],[24,24,11,1,252],false],
['t4411',1260,1828,663,[2849,2873,5075,5086],[24,24,11,1,256],false],
['t4412',1260,1837,663,[2966,2990,5075,5086],[24,24,11,1,252],false],
['t4413',1260,1810,663,[3026,3049,5075,5086],[23,23,11,1,244],false],
['t4414',1260,1842,663,[3084,3108,5075,5086],[24,24,11,1,252],false],
['t4415',1260,1610,663,[3328,3352,5075,5086],[24,24,11,1,256],false],
['t4416',1260,1805,663,[3417,3441,5075,5086],[24,24,11,1,252],false],
['t4417',1260,1838,663,[3477,3500,5075,5086],[22,22,11,1,234],false],
['t4418',1260,1843,663,[3594,3618,5075,5086],[23,23,11,1,248],false],
['t4419',1260,1816,663,[3654,3676,5075,5086],[23,23,11,1,242],false],
['t4420',1260,1629,663,[3683,3706,5075,5086],[23,23,11,1,241],false],
['t4421',1260,1517,663,[3780,3803,5075,5086],[23,23,11,1,240],false],
['t4422',1260,1797,663,[3810,3831,5075,5086],[21,21,11,1,228],false],
['t4423',1260,1533,663,[4015,4038,5075,5086],[23,23,11,1,240],false],
['t4424',1260,663,1849,[4222,4245,5075,5086],[23,23,11,1,240],false],
['t4425',1263,1852,663,[4941,4962,5102,5112],[22,22,11,1,233],false],
['t4426',1263,1639,663,[4911,4933,5102,5112],[22,22,11,1,233],false],
['t4427',1263,1820,663,[4882,4903,5102,5112],[21,21,11,1,227],false],
['t4428',1263,1600,663,[4852,4874,5102,5112],[22,22,11,1,233],false],
['t4429',1263,1638,663,[4794,4815,5102,5112],[22,22,11,1,233],false],
['t4430',1263,1621,663,[4352,4374,5102,5112],[22,22,11,1,239],false],
['t4431',1263,1817,663,[4164,4185,5102,5112],[22,22,11,1,233],false],
['t4432',1263,1625,663,[4075,4097,5102,5112],[22,22,11,1,236],false],
['t4433',1263,1812,663,[4046,4067,5102,5112],[21,21,11,1,223],false],
['t4434',1263,1533,663,[4016,4038,5102,5112],[22,22,11,1,236],false],
['t4435',1263,1620,663,[3957,3979,5102,5112],[22,22,11,1,230],false],
['t4436',1263,1611,663,[3839,3862,5102,5112],[22,22,11,1,239],false],
['t4437',1263,1624,663,[3565,3588,5102,5112],[22,22,11,1,236],false],
['t4438',1263,1619,663,[3448,3470,5102,5112],[22,22,11,1,233],false],
['t4439',1263,1805,663,[3419,3440,5102,5112],[21,21,11,1,227],false],
['t4440',1263,1525,663,[3389,3411,5102,5112],[22,22,11,1,236],false],
['t4441',1263,1815,663,[3144,3167,5102,5112],[22,22,11,1,236],false],
['t4442',1263,1536,663,[3115,3137,5102,5112],[22,22,11,1,230],false],
['t4443',1263,1623,663,[3056,3078,5102,5112],[22,22,11,1,239],false],
['t4444',1263,1804,663,[2909,2931,5102,5112],[21,21,11,1,227],false],
['t4445',1263,1524,663,[2880,2901,5102,5112],[22,22,11,1,233],false],
['t4446',1263,1828,663,[2850,2872,5102,5112],[22,22,11,1,239],false],
['t4447',1263,1801,663,[2635,2657,5102,5112],[22,22,11,1,233],false],
['t4448',1263,1792,663,[2517,2539,5102,5112],[22,22,11,1,233],false],
['t4449',1263,1510,663,[2488,2510,5102,5112],[22,22,11,1,233],false],
['t4450',1263,1800,663,[2370,2391,5102,5112],[22,22,11,1,230],false],
['t4451',1263,1520,663,[2341,2362,5102,5112],[22,22,11,1,233],false],
['t4452',1263,1824,663,[2311,2333,5102,5112],[22,22,11,1,233],false],
['t4453',1263,1832,663,[2155,2177,5102,5112],[22,22,11,1,233],false],
['t4454',1263,1799,663,[2096,2118,5102,5112],[22,22,11,1,233],false],
['t4455',1263,1831,663,[1831,1853,5102,5112],[22,22,11,1,233],false],
['t4456',1263,1798,663,[1773,1794,5102,5112],[22,22,11,1,230],false],
['t4457',1263,1622,663,[1410,1432,5102,5112],[22,22,11,1,236],false],
['t4458',1263,1803,663,[1263,1285,5102,5112],[22,22,11,1,239],false],
['t4459',1263,1616,663,[960,982,5102,5112],[22,22,11,1,233],false],
['t4461',1512,1309,663,[588,659,5427,5438],[72,72,11,1,806],false],
['t4462',1512,1309,663,[497,567,5426,5445],[79,79,10,3,802],false],
['t4463',2,1309,663,[513,645,5396,5407],[132,132,11,1,1423],false],
['t4464',1507,1310,1311,[472,485,5321,5334],[14,14,13,1,176],false],
['t4465',1310,1309,663,[498,645,5362,5383],[158,158,11,3,1643],false],
['t4466',1222,663,2939,[498,635,5339,5352],[138,138,10,3,1404],false],
['t4467',1312,1311,2939,[510,624,5286,5332],[149,149,11,2,1642],false],
['t4469',1511,849,1312,[553,566,5271,5286],[15,15,13,1,205],false],
['t4470',1528,663,1313,[563,657,5602,5617],[95,95,11,3,1058],false],
['t4471',1528,1313,663,[563,657,5576,5589],[95,95,11,3,1052],false],
['t4472',1528,663,1313,[563,657,5544,5568],[106,106,11,3,1135],false],
['t4474',1309,1313,663,[515,657,5482,5493],[141,141,11,1.5,1580],false],
['t4475',1309,663,1313,[515,657,5513,5524],[141,141,11,1,1507],false],
['t4476',1507,1234,1314,[74,104,5287,5300],[30,30,13,1,391],false],
['t4478',1319,1178,663,[508,524,5600,5727],[133,133,10,3,1333],false],
['t4479',1318,1168,663,[233,409,5521,5570],[215,215,10,4,2266],false],
['t4480',1318,1168,663,[134,212,5521,5532],[78,78,11,1,870],false],
['t4483',2,1318,663,[336,384,5411,5425],[50,50,11,3,538],false],
['t4484',2,663,1318,[336,384,5380,5395],[51,51,10,3,533],false],
['t4485',2,1318,663,[336,384,5353,5367],[50,50,10,3,518],false],
['t4486',2,663,1318,[335,384,5322,5335],[50,50,11,3,568],false],
['t4487',2,663,1318,[196,384,5437,5494],[234,234,11,6,2461],false],
['t4488',1508,663,1318,[209,310,5386,5397],[101,101,10,1,1044],false],
['t4489',1508,1318,663,[209,310,5411,5434],[115,115,10,3,1195],false],
['t4490',1508,663,1318,[101,186,5399,5409],[85,85,10,1,876],false],
['t4491',1508,1318,663,[101,186,5425,5435],[85,85,10,1,879],false],
['t4492',1314,663,1318,[116,305,5324,5334],[189,189,10,1,1851],false],
['t4493',1314,1318,663,[90,307,5354,5369],[220,220,10,5,2365],false],
['t4494',1507,1319,1481,[513,535,5761,5775],[22,22,14,1,307],false],
['t4495',1225,1320,1505,[1624,1638,4984,4998],[14,14,14,1,196],false],
['t4496',1225,1321,1506,[1948,1963,4984,4998],[14,14,14,1,196],false],
['t4497',1225,1322,1509,[2222,2237,4984,4998],[14,14,14,1,196],false],
['t4498',1225,1323,1513,[781,796,4984,4998],[14,14,14,1,200],false],
['t4499',1225,1324,1514,[1115,1129,4984,4998],[14,14,14,1,196],false],
['t4500',1225,1325,1515,[2761,2776,4984,4998],[14,14,14,1,196],false],
['t4501',1225,1326,1516,[3270,3285,4984,4998],[14,14,14,1,196],false],
['t4502',1225,1327,1517,[3780,3795,4984,4998],[14,14,14,1,196],false],
['t4503',1225,1328,1519,[2066,2080,4984,4998],[14,14,14,1,196],false],
['t4504',1225,1329,1521,[2605,2619,4984,4998],[14,14,14,1,196],false],
['t4505',1225,1330,1522,[899,913,4984,4998],[14,14,14,1,200],false],
['t4506',1225,1331,1523,[1232,1247,4984,4998],[14,14,14,1,196],false],
['t4507',1225,1332,1525,[3388,3402,4984,4998],[14,14,14,1,196],false],
['t4508',1225,1333,1526,[3898,3912,4984,4998],[14,14,14,1,196],false],
['t4509',1225,1334,1527,[4292,4306,4984,4998],[14,14,14,1,196],false],
['t4510',1225,1335,1529,[1017,1031,4984,4998],[14,14,14,1,200],false],
['t4511',1225,1336,1530,[1350,1365,4984,4998],[14,14,14,1,196],false],
['t4512',1225,1337,1531,[2997,3011,4984,4998],[14,14,14,1,196],false],
['t4513',1225,1338,1532,[3506,3520,4984,4998],[14,14,14,1,196],false],
['t4514',1225,1339,1533,[4016,4030,4984,4998],[14,14,14,1,196],false],
['t4515',1225,1340,1534,[4410,4424,4984,4998],[14,14,14,1,196],false],
['t4516',1225,1341,1535,[1468,1483,4984,4998],[14,14,14,1,196],false],
['t4517',1225,1342,1536,[3115,3129,4984,4998],[14,14,14,1,196],false],
['t4518',1225,1343,1537,[3624,3638,4984,4998],[14,14,14,1,196],false],
['t4519',1225,1344,1538,[4134,4148,4984,4998],[14,14,14,1,196],false],
['t4520',1225,1094,1598,[4528,4542,4984,4998],[14,14,14,1,196],false],
['t4521',1225,1345,1599,[4734,4749,4984,4998],[14,14,14,1,196],false],
['t4522',1225,1346,1600,[4852,4866,4984,4998],[14,14,14,1,196],false],
['t4523',1225,1347,1601,[5008,5023,4984,4998],[14,14,14,1,196],false],
['t4524',1225,1348,1602,[1682,1697,4984,4998],[14,14,14,1,196],false],
['t4525',1225,1349,1604,[2281,2295,4984,4998],[14,14,14,1,196],false],
['t4526',1225,1350,1605,[2546,2560,4984,4998],[14,14,14,1,196],false],
['t4527',1225,1351,1607,[840,854,4984,4998],[14,14,14,1,200],false],
['t4528',1225,1352,1608,[1173,1187,4984,4998],[14,14,14,1,196],false],
['t4529',1225,1353,1609,[2820,2834,4984,4998],[14,14,14,1,196],false],
['t4530',1225,1354,1610,[3329,3343,4984,4998],[14,14,14,1,196],false],
['t4531',1225,1355,1611,[3839,3853,4984,4998],[14,14,14,1,196],false],
['t4532',1225,1356,1613,[2124,2138,4984,4998],[14,14,14,1,196],false],
['t4533',1225,1357,1614,[2398,2413,4984,4998],[14,14,14,1,196],false],
['t4534',1225,1358,1615,[2663,2678,4984,4998],[14,14,14,1,196],false],
['t4535',1225,1359,1618,[2937,2952,4984,4998],[14,14,14,1,196],false],
['t4536',1225,1360,1619,[3446,3461,4984,4998],[14,14,14,1,196],false],
['t4537',1225,1361,1620,[3956,3971,4984,4998],[14,14,14,1,196],false],
['t4538',1225,1362,1621,[4350,4365,4984,4998],[14,14,14,1,196],false],
['t4539',1225,1363,1622,[1409,1423,4984,4998],[14,14,14,1,196],false],
['t4540',1225,1364,1626,[4468,4483,4984,4998],[14,14,14,1,196],false],
['t4541',1225,1365,1628,[3173,3188,4984,4998],[14,14,14,1,196],false],
['t4542',1225,1366,1629,[3682,3697,4984,4998],[14,14,14,1,196],false],
['t4543',1225,1367,1630,[4192,4207,4984,4998],[14,14,14,1,196],false],
['t4544',1225,1368,1632,[4586,4601,4984,4998],[14,14,14,1,196],false],
['t4545',1225,1369,1638,[4793,4807,4984,4998],[14,14,14,1,196],false],
['t4546',1225,1141,1639,[4910,4925,4984,4998],[14,14,14,1,196],false],
['t4547',1225,1370,1640,[5067,5081,4984,4998],[14,14,14,1,196],false],
['t4548',1225,1371,1789,[1654,1668,4984,4998],[14,14,14,1,196],false],
['t4549',1225,1372,1790,[1978,1992,4984,4998],[14,14,14,1,196],false],
['t4550',1225,1373,1791,[2252,2267,4984,4998],[14,14,14,1,196],false],
['t4551',1225,1374,1793,[811,826,4984,4998],[14,14,14,1,200],false],
['t4552',1225,1375,1794,[1145,1159,4984,4998],[14,14,14,1,196],false],
['t4553',1225,1376,1795,[2791,2806,4984,4998],[14,14,14,1,196],false],
['t4554',1225,1377,1796,[3300,3315,4984,4998],[14,14,14,1,196],false],
['t4555',1225,1378,1797,[3810,3825,4984,4998],[14,14,14,1,196],false],
['t4556',1225,1379,1798,[1771,1786,4984,4998],[14,14,14,1,196],false],
['t4557',1225,1380,1799,[2096,2110,4984,4998],[14,14,14,1,196],false],
['t4558',1225,1381,1801,[2635,2649,4984,4998],[14,14,14,1,196],false],
['t4559',1225,1382,1802,[929,943,4984,4998],[14,14,14,1,200],false],
['t4560',1225,1383,1804,[2909,2923,4984,4998],[14,14,14,1,196],false],
['t4561',1225,1384,1805,[3418,3432,4984,4998],[14,14,14,1,196],false],
['t4562',1225,1385,1806,[3928,3942,4984,4998],[14,14,14,1,196],false],
['t4563',1225,1386,1807,[4322,4336,4984,4998],[14,14,14,1,196],false],
['t4564',1225,1387,1808,[1047,1061,4984,4998],[14,14,14,1,200],false],
['t4565',1225,1388,1809,[1380,1395,4984,4998],[14,14,14,1,196],false],
['t4566',1225,1389,1810,[3027,3041,4984,4998],[14,14,14,1,196],false],
['t4567',1225,1390,1811,[3536,3550,4984,4998],[14,14,14,1,196],false],
['t4568',1225,1391,1812,[4046,4060,4984,4998],[14,14,14,1,196],false],
['t4569',1225,1392,1813,[4440,4454,4984,4998],[14,14,14,1,196],false],
['t4570',1225,1393,1816,[3654,3668,4984,4998],[14,14,14,1,196],false],
['t4571',1225,1394,1817,[4164,4178,4984,4998],[14,14,14,1,196],false],
['t4572',1225,1395,1818,[4558,4572,4984,4998],[14,14,14,1,196],false],
['t4573',1225,1396,1819,[4764,4779,4984,4998],[14,14,14,1,196],false],
['t4574',1225,1397,1821,[5038,5053,4984,4998],[14,14,14,1,196],false],
['t4575',1225,1398,1822,[1712,1726,4984,4998],[14,14,14,1,196],false],
['t4576',1225,1399,1824,[2311,2325,4984,4998],[14,14,14,1,196],false],
['t4577',1225,1400,1825,[2575,2590,4984,4998],[14,14,14,1,196],false],
['t4578',1225,1401,1826,[870,884,4984,4998],[14,14,14,1,200],false],
['t4579',1261,1826,663,[870,893,5045,5055],[22,22,10,1,220],false],
['t4580',1261,1616,663,[959,981,5045,5055],[22,22,10,1,220],false],
['t4581',1261,1808,663,[1047,1069,5045,5055],[22,22,10,1,223],false],
['t4582',1261,1803,663,[1262,1284,5045,5055],[22,22,10,1,223],false],
['t4583',1261,1622,663,[1409,1431,5045,5055],[22,22,10,1,214],false],
['t4584',1261,1535,663,[1468,1490,5045,5055],[22,22,10,1,220],false],
['t4585',1261,1846,663,[1556,1579,5045,5055],[22,22,10,1,220],false],
['t4586',1261,1505,663,[1624,1646,5045,5055],[22,22,10,1,220],false],
['t4587',1261,1822,663,[1713,1734,5045,5055],[22,22,10,1,214],false],
['t4588',1261,1518,663,[1742,1764,5045,5055],[22,22,10,1,217],false],
['t4589',1261,1798,663,[1772,1793,5045,5055],[22,22,10,1,217],false],
['t4590',1261,1831,663,[1830,1853,5045,5055],[22,22,10,1,223],false],
['t4591',1261,1603,663,[2007,2029,5045,5055],[22,22,10,1,220],false],
['t4592',1261,1519,663,[2066,2088,5045,5055],[22,22,10,1,217],false],
['t4593',1261,1799,663,[2095,2118,5045,5055],[22,22,10,1,220],false],
['t4594',1261,1832,663,[2154,2177,5045,5055],[22,22,10,1,223],false],
['t4595',1261,1509,663,[2222,2244,5045,5055],[22,22,10,1,220],false],
['t4596',1261,1824,663,[2311,2332,5045,5055],[21,21,10,1,211],false],
['t4597',1261,1520,663,[2340,2361,5045,5055],[21,21,10,1,211],false],
['t4598',1261,1800,663,[2369,2391,5045,5055],[22,22,10,1,220],false],
['t4599',1261,1510,663,[2486,2509,5045,5055],[22,22,10,1,223],false],
['t4600',1261,1792,663,[2517,2538,5045,5055],[22,22,10,1,215],false],
['t4601',1261,1801,663,[2634,2656,5045,5055],[22,22,10,1,223],false],
['t4602',1261,1834,663,[2693,2715,5045,5055],[22,22,10,1,218],false],
['t4603',1261,1524,663,[2878,2900,5045,5055],[22,22,10,1,217],false],
['t4604',1261,1804,663,[2908,2930,5045,5055],[22,22,10,1,223],false],
['t4605',1261,1531,663,[2996,3018,5045,5055],[22,22,10,1,217],false],
['t4606',1261,1623,663,[3055,3077,5045,5055],[21,21,10,1,211],false],
['t4607',1261,1536,663,[3113,3136,5045,5055],[22,22,10,1,223],false],
['t4608',1261,1815,663,[3143,3166,5045,5055],[23,23,10,1,224],false],
['t4609',1261,1525,663,[3388,3410,5045,5055],[22,22,10,1,218],false],
['t4610',1261,1619,663,[3446,3469,5045,5055],[23,23,10,1,229],false],
['t4611',1261,1532,663,[3505,3527,5045,5055],[21,21,10,1,212],false],
['t4612',1261,1811,663,[3534,3557,5045,5055],[22,22,10,1,223],false],
['t4613',1261,1624,663,[3565,3586,5045,5055],[22,22,10,1,217],false],
['t4614',1261,1537,663,[3623,3646,5045,5055],[23,23,10,1,227],false],
['t4615',1261,1611,663,[3839,3860,5045,5055],[22,22,10,1,217],false],
['t4616',1261,1830,663,[3867,3890,5045,5055],[23,23,10,1,226],false],
['t4617',1261,1620,663,[3956,3978,5045,5055],[22,22,10,1,220],false],
['t4618',1261,1839,663,[3986,4008,5045,5055],[22,22,10,1,223],false],
['t4619',1261,1812,663,[4045,4066,5045,5055],[22,22,10,1,214],false],
['t4620',1261,1625,663,[4074,4096,5045,5055],[22,22,10,1,214],false],
['t4621',1261,1844,663,[4104,4126,5045,5055],[22,22,10,1,220],false],
['t4622',1261,1817,663,[4162,4185,5045,5055],[22,22,10,1,223],false],
['t4623',1261,1527,663,[4292,4314,5045,5055],[22,22,10,1,223],false],
['t4624',1261,1621,663,[4351,4373,5045,5055],[22,22,10,1,220],false],
['t4625',1261,1626,663,[4469,4491,5045,5055],[22,22,10,1,220],false],
['t4626',1261,1598,663,[4527,4550,5045,5055],[22,22,10,1,223],false],
['t4627',1261,1850,663,[4616,4638,5045,5055],[22,22,10,1,220],false],
['t4628',1261,1599,663,[4734,4756,5045,5055],[22,22,10,1,217],false],
['t4629',1261,1819,663,[4763,4785,5045,5055],[22,22,10,1,217],false],
['t4630',1261,1638,663,[4793,4814,5045,5055],[22,22,10,1,217],false],
['t4631',1261,1600,663,[4851,4873,5045,5055],[22,22,10,1,217],false],
['t4632',1261,1820,663,[4881,4903,5045,5055],[22,22,10,1,214],false],
['t4633',1261,1639,663,[4911,4932,5045,5055],[22,22,10,1,217],false],
['t4634',1261,1852,663,[4940,4963,5045,5055],[23,23,10,1,229],false],
['t4635',1225,1418,1612,[1800,1814,4984,4998],[14,14,14,1,196],false],
['t4636',1225,1422,1518,[1741,1756,4984,4998],[14,14,14,1,196],false],
['t4637',1225,1412,1627,[1527,1541,4984,4998],[14,14,14,1,196],false],
['t4638',1225,1408,1814,[1498,1513,4984,4998],[14,14,14,1,196],false],
['t4639',1225,1402,1836,[1321,1335,4984,4998],[14,14,14,1,196],false],
['t4640',1225,1416,1617,[1291,1305,4984,4998],[14,14,14,1,196],false],
['t4641',1225,1409,1803,[1262,1277,4984,4998],[14,14,14,1,196],false],
['t4642',1225,1404,1827,[1203,1217,4984,4998],[14,14,14,1,196],false],
['t4643',1225,1417,1616,[957,972,4984,4998],[14,14,14,1,200],false],
['t4644',1225,1403,1833,[2428,2443,4984,4998],[14,14,14,1,196],false],
['t4645',1225,1410,1800,[2370,2384,4984,4998],[14,14,14,1,196],false],
['t4646',1225,1421,1520,[2340,2354,4984,4998],[14,14,14,1,196],false],
['t4647',1225,1405,1823,[2036,2051,4984,4998],[14,14,14,1,196],false],
['t4648',1225,1419,1603,[2006,2021,4984,4998],[14,14,14,1,196],false],
['t4649',1225,1413,1625,[4074,4089,4984,4998],[14,14,14,1,196],false],
['t4650',1225,1414,1624,[3564,3579,4984,4998],[14,14,14,1,196],false],
['t4651',1225,1407,1815,[3145,3159,4984,4998],[14,14,14,1,196],false],
['t4652',1225,1415,1623,[3055,3070,4984,4998],[14,14,14,1,196],false],
['t4653',1225,1420,1524,[2879,2893,4984,4998],[14,14,14,1,196],false],
['t4654',1225,1411,1792,[2517,2532,4984,4998],[14,14,14,1,196],false],
['t4655',1225,1423,1510,[2487,2502,4984,4998],[14,14,14,1,196],false],
['t4656',1225,1001,1820,[4882,4896,4984,4998],[14,14,14,1,196],false],
['t4657',1313,1820,663,[4882,4904,5018,5028],[22,22,11,1,236],false],
['t4658',1313,1625,663,[4074,4096,5018,5028],[22,22,11,1,236],false],
['t4659',1313,1624,663,[3564,3587,5018,5028],[22,22,11,1,236],false],
['t4660',1313,1815,663,[3145,3167,5018,5028],[22,22,11,1,236],false],
['t4661',1313,1623,663,[3055,3077,5018,5028],[22,22,11,1,236],false],
['t4662',1313,1524,663,[2879,2901,5018,5028],[22,22,11,1,236],false],
['t4663',1313,1792,663,[2517,2539,5018,5028],[22,22,11,1,236],false],
['t4664',1313,1510,663,[2487,2509,5018,5028],[22,22,11,1,236],false],
['t4665',1313,1833,663,[2428,2450,5018,5028],[22,22,11,1,236],false],
['t4666',1313,1800,663,[2370,2392,5018,5028],[22,22,11,1,236],false],
['t4667',1313,1520,663,[2340,2362,5018,5028],[22,22,11,1,236],false],
['t4668',1313,1823,663,[2036,2059,5018,5028],[22,22,11,1,236],false],
['t4669',1313,1603,663,[2006,2029,5018,5028],[22,22,11,1,236],false],
['t4670',1313,1612,663,[1800,1822,5018,5028],[22,22,11,1,236],false],
['t4671',1313,1518,663,[1741,1763,5018,5028],[22,22,11,1,236],false],
['t4672',1313,1627,663,[1527,1549,5018,5028],[22,22,11,1,236],false],
['t4673',1313,1814,663,[1498,1520,5018,5028],[22,22,11,1,236],false],
['t4674',1313,1836,663,[1321,1343,5018,5028],[22,22,11,1,236],false],
['t4675',1313,1617,663,[1291,1313,5018,5028],[22,22,11,1,236],false],
['t4676',1313,1803,663,[1262,1284,5018,5028],[22,22,11,1,236],false],
['t4677',1313,1827,663,[1203,1225,5018,5028],[22,22,11,1,236],false],
['t4678',1313,1616,663,[957,980,5018,5028],[22,22,11,1,236],false],
['t4679',1225,948,1828,[2850,2864,4984,4998],[14,14,14,1,196],false],
['t4680',1225,1424,1829,[3359,3373,4984,4998],[14,14,14,1,196],false],
['t4681',1225,1425,1830,[3869,3883,4984,4998],[14,14,14,1,196],false],
['t4682',1225,1426,1831,[1830,1844,4984,4998],[14,14,14,1,196],false],
['t4683',1225,1427,1832,[2154,2168,4984,4998],[14,14,14,1,196],false],
['t4684',1225,1428,1834,[2693,2707,4984,4998],[14,14,14,1,196],false],
['t4685',1225,1429,1835,[987,1002,4984,4998],[14,14,14,1,200],false],
['t4686',1225,1430,1837,[2967,2982,4984,4998],[14,14,14,1,196],false],
['t4687',1225,1431,1838,[3476,3491,4984,4998],[14,14,14,1,196],false],
['t4688',1225,1432,1839,[3986,4001,4984,4998],[14,14,14,1,196],false],
['t4689',1225,1433,1840,[4380,4395,4984,4998],[14,14,14,1,196],false],
['t4690',1225,1434,1841,[1439,1453,4984,4998],[14,14,14,1,196],false],
['t4691',1225,1435,1842,[3085,3100,4984,4998],[14,14,14,1,196],false],
['t4692',1225,1436,1843,[3594,3609,4984,4998],[14,14,14,1,196],false],
['t4693',1225,1437,1844,[4104,4119,4984,4998],[14,14,14,1,196],false],
['t4694',1225,1438,1845,[4498,4513,4984,4998],[14,14,14,1,196],false],
['t4695',1225,1439,1846,[1556,1571,4984,4998],[14,14,14,1,196],false],
['t4696',1225,1440,1847,[3203,3218,4984,4998],[14,14,14,1,196],false],
['t4697',1225,1441,1848,[3712,3727,4984,4998],[14,14,14,1,196],false],
['t4698',1225,1442,1849,[4222,4237,4984,4998],[14,14,14,1,196],false],
['t4699',1225,1443,1850,[4616,4631,4984,4998],[14,14,14,1,196],false],
['t4700',1225,1444,1851,[4823,4837,4984,4998],[14,14,14,1,196],false],
['t4701',1225,1130,1852,[4940,4955,4984,4998],[14,14,14,1,196],false],
['t4702',1225,1446,1853,[5097,5111,4984,4998],[14,14,14,1,196],false],
['t4703',1511,1448,788,[6104,6126,5755,5769],[22,22,14,1,315],false],
['t4704',1450,1574,663,[5513,5528,6032,6042],[16,16,10,1,164],false],
['t4705',1450,1574,663,[5531,5541,6044,6214],[170,170,10,1,1635],false],
['t4706',1450,663,1574,[5407,5510,6022,6204],[700,700,10,7,6891],false],
['t4707',1450,1574,663,[5431,5498,6022,6042],[78,78,10,2,788],false],
['t4709',1451,1449,663,[5571,5618,6029,6137],[204,204,11,6,2071],false],
['t4710',1452,663,1450,[5404,5418,5905,5977],[73,73,12,3,859],false],
['t4711',1449,1453,1450,[5429,5444,5905,5978],[74,74,11,3,839],false],
['t4712',1454,31,1574,[5492,5607,5947,5960],[115,115,13,1,1497],false],
['t4713',1454,1574,31,[5500,5615,5852,5927],[278,278,12,4,3283],false],
['t4714',1454,31,1574,[5620,5642,5947,5960],[22,22,13,1,288],false],
['t4715',1454,2940,1451,[5474,5488,5788,5825],[37,37,14,1,506],false],
['t4716',1507,1305,2940,[5495,5508,5788,5825],[37,37,13,1,492],false],
['t4717',1456,663,1452,[5188,5232,5745,5896],[312,312,10,5,3236],false],
['t4718',1452,663,1453,[5258,5348,5779,5890],[381,381,11,8,4047],false],
['t4720',1453,663,1454,[5392,5441,5746,5873],[249,249,11,4,2722],false],
['t4723',663,663,1456,[5131,5146,5799,5882],[83,83,15,1,1254],false],
['t4724',663,1511,663,[5015,5030,5736,5818],[82,82,14,1,1194],false],
['t4725',663,1461,663,[4276,4290,5767,5848],[81,81,14,1,1130],false],
['t4856',663,1459,663,[4637,4651,5749,5831],[82,82,14,1,1189],false],
['t4857',1459,663,1476,[4570,4614,5738,5841],[136,136,12,2,1588],false],
['t4859',1460,1508,31,[4426,4499,5698,5808],[316,316,10,9,3304],false],
['t4860',1460,1508,31,[4426,4436,5707,5729],[22,22,10,1,228],false],
['t4861',1476,663,1508,[4367,4413,5716,5825],[228,228,10,10,2357],false],
['t4863',1476,1460,663,[4526,4568,5787,5887],[180,180,11,4,1877],false],
['t4864',1476,663,1508,[4409,4518,5828,5859],[192,192,11,9.5,1969],false],
['t4866',1461,663,1462,[4242,4257,5734,5862],[128,128,12,3,1543],false],
['t4868',1462,663,1463,[4197,4210,5783,5885],[104,104,11,3,1105],false],
['t4870',1511,1464,1463,[4155,4168,5759,5781],[22,22,12,1,271],false],
['t4871',1507,1466,1464,[4103,4117,5781,5811],[29,29,14,1,397],false],
['t4872',1507,663,1465,[4106,4163,5820,5850],[78,78,10,2.5,755],false],
['t4873',1464,1465,663,[4095,4163,5862,5875],[69,69,10,3,734],false],
['t4874',1464,663,1474,[3961,4034,5823,5875],[122,122,10,4,1187],false],
['t4878',1474,1466,663,[3912,3990,5736,5785],[117,117,10,3,1249],false],
['t4879',1466,663,1474,[3934,3959,5841,5883],[58,58,10,2,592],false],
['t4880',1466,663,1474,[3935,3990,5798,5814],[62,62,10,2,603],false],
['t4881',1465,1466,663,[3883,3893,5866,5889],[23,23,10,1,230],false],
['t4882',1465,1466,663,[3896,3909,5761,5839],[80,80,10,3,829],false],
['t4883',1507,1471,1466,[3871,3884,5722,5751],[29,29,13,1,389],false],
['t4885',1471,663,1968,[3756,3786,5768,5896],[148,148,10,4,1422],false],
['t4886',1471,663,1467,[3807,3846,5743,5896],[181,181,11,6,1930],false],
['t4887',1471,1968,663,[3787,3797,5768,5869],[101,101,10,1,977],false],
['t4889',1463,1968,1472,[3694,3724,5816,5904],[107,107,10,3,1057],false],
['t4890',1463,1968,1472,[3725,3747,5755,5904],[160,160,10,3,1617],false],
['t4892',1473,1512,663,[3582,3669,5710,5874],[367,367,9,6,3721],false],
['t4893',1467,1473,663,[3646,3656,5778,5812],[34,34,10,1,335],false],
['t4894',1467,1473,663,[3585,3656,5842,5906],[125,125,10,2,1251],false],
['t4895',1467,1512,31,[3504,3545,5776,5892],[197,197,10,9,2002],false],
['t4896',1467,1512,31,[3504,3513,5865,5892],[27,27,10,1,256],false],
['t4897',1512,663,2,[3219,3228,5784,5810],[26,26,9,1,226],false],
['t4898',1512,663,2,[3211,3297,5749,5893],[330,330,9,7,3371],false],
['t4899',1512,663,2,[3288,3297,5831,5895],[63,63,10,1,617],false],
['t4900',1468,663,2,[3121,3228,5734,5893],[426,426,10,9,4442],false],
['t4903',1507,1468,1470,[3087,3100,5786,5822],[36,36,13,1,456],false],
['t4904',1486,663,1470,[3023,3072,5796,5892],[135,135,10,2,1304],false],
['t4905',1501,663,1477,[1021,1033,5750,5878],[128,128,12,1,1517],false],
['t4907',1477,663,1478,[968,990,5781,5854],[85,85,10,3,864],false],
['t4909',1478,663,1479,[895,909,5757,5824],[69,69,11,3,760],false],
['t4910',1511,1478,1606,[927,940,5860,5875],[15,15,13,1,192],false],
['t4911',1507,1479,663,[873,884,5781,5848],[67,67,10,1,692],false],
['t4912',1507,1606,1480,[890,903,5863,5878],[15,15,13,1,194],false],
['t4914',1479,663,1480,[835,857,5757,5862],[116,116,10,2,1201],false],
['t4916',1606,1481,663,[773,789,5748,5856],[114,114,11,3,1232],false],
['t4917',1481,663,1480,[809,819,5758,5856],[99,99,10,1,965],false],
['t4919',1480,663,1481,[743,763,5768,5881],[122,122,11,3,1298],false],
['t4920',1528,1513,31,[783,803,5526,5537],[20,20,11,1,214],false],
['t4921',1528,1793,31,[811,833,5526,5537],[21,21,11,1,224],false],
['t4922',1528,1607,31,[841,862,5526,5537],[20,20,11,1,217],false],
['t4923',1528,1826,31,[871,892,5526,5537],[21,21,11,1,229],false],
['t4924',1528,1522,31,[901,920,5526,5537],[19,19,11,1,205],false],
['t4925',1528,1802,31,[929,950,5526,5537],[21,21,11,1,224],false],
['t4926',1528,1616,31,[959,979,5526,5537],[20,20,11,1,217],false],
['t4927',1528,1835,31,[988,1010,5526,5537],[21,21,11,1,229],false],
['t4928',1528,1529,31,[1019,1038,5526,5537],[19,19,11,1,205],false],
['t4929',1528,1808,31,[1047,1069,5526,5537],[22,22,11,1,232],false],
['t4930',1528,1514,31,[1115,1136,5526,5537],[21,21,11,1,221],false],
['t4931',1528,1794,31,[1145,1166,5526,5537],[21,21,11,1,224],false],
['t4932',1528,1608,31,[1175,1195,5526,5537],[20,20,11,1,217],false],
['t4933',1528,1827,31,[1204,1225,5526,5537],[21,21,11,1,229],false],
['t4934',1528,1523,31,[1234,1253,5526,5537],[19,19,11,1,205],false],
['t4935',1528,1803,31,[1262,1283,5526,5537],[21,21,11,1,224],false],
['t4936',1528,1617,31,[1292,1313,5526,5537],[20,20,11,1,217],false],
['t4937',1528,1836,31,[1321,1343,5526,5537],[21,21,11,1,229],false],
['t4938',1528,1530,31,[1352,1371,5526,5537],[19,19,11,1,205],false],
['t4939',1528,1809,31,[1380,1401,5526,5537],[21,21,11,1,224],false],
['t4940',1528,1622,31,[1410,1430,5526,5537],[20,20,11,1,217],false],
['t4941',1528,1841,31,[1439,1461,5526,5537],[21,21,11,1,229],false],
['t4942',1528,1535,31,[1469,1489,5526,5537],[20,20,11,1,213],false],
['t4943',1528,1814,31,[1498,1519,5526,5537],[21,21,11,1,224],false],
['t4944',1528,1627,31,[1528,1548,5526,5537],[20,20,11,1,213],false],
['t4945',1528,1846,31,[1557,1578,5526,5537],[21,21,11,1,223],false],
['t4946',1528,1505,31,[1625,1645,5526,5537],[20,20,11,1,217],false],
['t4947',1528,1789,31,[1654,1675,5526,5537],[21,21,11,1,224],false],
['t4948',1528,1602,31,[1684,1704,5526,5537],[20,20,11,1,217],false],
['t4949',1528,1822,31,[1713,1734,5526,5537],[21,21,11,1,229],false],
['t4950',1528,1518,31,[1743,1763,5526,5537],[19,19,11,1,205],false],
['t4951',1528,1798,31,[1771,1792,5526,5537],[21,21,11,1,224],false],
['t4952',1528,1612,31,[1801,1822,5526,5537],[20,20,11,1,217],false],
['t4953',1528,1831,31,[1831,1851,5526,5537],[21,21,11,1,221],false],
['t4954',1528,1506,31,[1950,1969,5526,5537],[20,20,11,1,209],false],
['t4955',1528,1790,31,[1978,1999,5526,5537],[21,21,11,1,224],false],
['t4956',1528,1603,31,[2008,2028,5526,5537],[20,20,11,1,217],false],
['t4957',1528,1823,31,[2037,2059,5526,5537],[21,21,11,1,229],false],
['t4958',1528,1519,31,[2068,2087,5526,5537],[19,19,11,1,205],false],
['t4959',1528,1799,31,[2096,2117,5526,5537],[21,21,11,1,224],false],
['t4960',1528,1613,31,[2126,2146,5526,5537],[20,20,11,1,217],false],
['t4961',1528,1832,31,[2155,2176,5526,5537],[21,21,11,1,220],false],
['t4962',1528,1509,31,[2222,2244,5526,5537],[21,21,11,1,229],false],
['t4963',1528,1791,31,[2252,2274,5526,5537],[21,21,11,1,224],false],
['t4964',1528,1604,31,[2282,2303,5526,5537],[20,20,11,1,217],false],
['t4965',1528,1824,31,[2312,2333,5526,5537],[21,21,11,1,229],false],
['t4966',1528,1520,31,[2342,2361,5526,5537],[19,19,11,1,205],false],
['t4967',1528,1800,31,[2370,2391,5526,5537],[21,21,11,1,224],false],
['t4968',1528,1614,31,[2400,2420,5526,5537],[20,20,11,1,217],false],
['t4969',1528,1833,31,[2429,2449,5526,5537],[19,19,11,1,206],false],
['t4970',1528,1510,31,[2489,2508,5526,5537],[19,19,11,1,207],false],
['t4971',1528,1792,31,[2517,2538,5526,5537],[21,21,11,1,224],false],
['t4972',1528,1605,31,[2547,2568,5526,5537],[20,20,11,1,217],false],
['t4973',1528,1825,31,[2576,2598,5526,5537],[21,21,11,1,229],false],
['t4974',1528,1521,31,[2607,2626,5526,5537],[19,19,11,1,205],false],
['t4975',1528,1801,31,[2635,2656,5526,5537],[21,21,11,1,224],false],
['t4976',1528,1615,31,[2665,2685,5526,5537],[20,20,11,1,217],false],
['t4977',1528,1834,31,[2694,2715,5526,5537],[21,21,11,1,228],false],
['t4978',1528,1515,31,[2762,2783,5526,5537],[21,21,11,1,218],false],
['t4979',1528,1795,31,[2791,2812,5526,5537],[21,21,11,1,224],false],
['t4980',1528,1609,31,[2821,2842,5526,5537],[20,20,11,1,217],false],
['t4981',1528,1828,31,[2851,2872,5526,5537],[21,21,11,1,229],false],
['t4982',1528,1524,31,[2881,2900,5526,5537],[19,19,11,1,205],false],
['t4983',1528,1804,31,[2909,2930,5526,5537],[21,21,11,1,224],false],
['t4984',1528,1618,31,[2939,2959,5526,5537],[20,20,11,1,217],false],
['t4985',1528,1837,31,[2968,2990,5526,5537],[21,21,11,1,229],false],
['t4986',1528,1531,31,[2998,3018,5526,5537],[19,19,11,1,205],false],
['t4987',1528,1810,31,[3027,3048,5526,5537],[21,21,11,1,224],false],
['t4988',1528,1623,31,[3057,3077,5526,5537],[20,20,11,1,217],false],
['t4989',1528,1842,31,[3086,3107,5526,5537],[21,21,11,1,229],false],
['t4990',1528,1536,31,[3116,3136,5526,5537],[20,20,11,1,213],false],
['t4991',1528,1815,31,[3145,3166,5526,5537],[21,21,11,1,224],false],
['t4992',1528,1628,31,[3175,3195,5526,5537],[20,20,11,1,213],false],
['t4993',1528,1847,31,[3204,3225,5526,5537],[21,21,11,1,223],false],
['t4994',1528,1516,31,[3271,3292,5526,5537],[21,21,11,1,218],false],
['t4995',1528,1796,31,[3301,3322,5526,5537],[21,21,11,1,224],false],
['t4996',1528,1610,31,[3330,3351,5526,5537],[20,20,11,1,217],false],
['t4997',1528,1829,31,[3360,3381,5526,5537],[21,21,11,1,229],false],
['t4998',1528,1525,31,[3390,3409,5526,5537],[19,19,11,1,205],false],
['t4999',1528,1805,31,[3418,3439,5526,5537],[21,21,11,1,224],false],
['t5000',1528,1619,31,[3448,3468,5526,5537],[20,20,11,1,217],false],
['t5001',1528,1838,31,[3477,3499,5526,5537],[21,21,11,1,229],false],
['t5002',1528,1532,31,[3508,3527,5526,5537],[19,19,11,1,205],false],
['t5003',1528,1811,31,[3536,3557,5526,5537],[21,21,11,1,224],false],
['t5004',1528,1624,31,[3566,3586,5526,5537],[20,20,11,1,217],false],
['t5005',1528,1843,31,[3595,3616,5526,5537],[21,21,11,1,229],false],
['t5006',1528,1537,31,[3625,3645,5526,5537],[20,20,11,1,213],false],
['t5007',1528,1816,31,[3654,3675,5526,5537],[21,21,11,1,224],false],
['t5008',1528,1629,31,[3684,3704,5526,5537],[20,20,11,1,213],false],
['t5009',1528,1848,31,[3713,3735,5526,5537],[22,22,11,1,230],false],
['t5010',1528,1517,31,[3781,3802,5526,5537],[21,21,11,1,218],false],
['t5011',1528,1797,31,[3810,3832,5526,5537],[21,21,11,1,224],false],
['t5012',1528,1611,31,[3840,3861,5526,5537],[20,20,11,1,217],false],
['t5013',1528,1830,31,[3870,3891,5526,5537],[21,21,11,1,229],false],
['t5014',1528,1526,31,[3900,3919,5526,5537],[19,19,11,1,205],false],
['t5015',1528,1806,31,[3928,3949,5526,5537],[21,21,11,1,224],false],
['t5016',1528,1620,31,[3958,3978,5526,5537],[20,20,11,1,217],false],
['t5017',1528,1839,31,[3987,4009,5526,5537],[21,21,11,1,229],false],
['t5018',1528,1533,31,[4018,4037,5526,5537],[19,19,11,1,205],false],
['t5019',1528,1812,31,[4046,4067,5526,5537],[21,21,11,1,224],false],
['t5020',1528,1625,31,[4076,4096,5526,5537],[20,20,11,1,217],false],
['t5021',1528,1844,31,[4105,4126,5526,5537],[21,21,11,1,229],false],
['t5022',1528,1538,31,[4135,4155,5526,5537],[20,20,11,1,213],false],
['t5023',1528,1817,31,[4164,4185,5526,5537],[21,21,11,1,224],false],
['t5024',1528,1630,31,[4194,4214,5526,5537],[20,20,11,1,213],false],
['t5025',1528,1849,31,[4223,4244,5526,5537],[22,22,11,1,230],false],
['t5026',1528,1527,31,[4294,4314,5526,5537],[20,20,11,1,212],false],
['t5027',1528,1807,31,[4323,4344,5526,5537],[21,21,11,1,224],false],
['t5028',1528,1621,31,[4353,4373,5526,5537],[20,20,11,1,217],false],
['t5029',1528,1840,31,[4382,4403,5526,5537],[21,21,11,1,229],false],
['t5030',1528,1534,31,[4412,4431,5526,5537],[19,19,11,1,205],false],
['t5031',1528,1813,31,[4440,4461,5526,5537],[21,21,11,1,224],false],
['t5032',1528,1626,31,[4470,4491,5526,5537],[20,20,11,1,217],false],
['t5033',1528,1845,31,[4499,4521,5526,5537],[21,21,11,1,229],false],
['t5034',1528,1598,31,[4530,4550,5526,5537],[20,20,11,1,213],false],
['t5035',1528,1818,31,[4559,4580,5526,5537],[21,21,11,1,224],false],
['t5036',1528,1632,31,[4589,4609,5526,5537],[20,20,11,1,213],false],
['t5037',1528,1850,31,[4617,4638,5526,5537],[21,21,11,1,219],false],
['t5038',1528,1599,31,[4736,4756,5526,5537],[19,19,11,1,207],false],
['t5039',1528,1819,31,[4765,4786,5526,5537],[21,21,11,1,224],false],
['t5040',1528,1638,31,[4795,4815,5526,5537],[20,20,11,1,217],false],
['t5041',1528,1851,31,[4824,4845,5526,5537],[21,21,11,1,229],false],
['t5042',1528,1600,31,[4854,4874,5526,5537],[20,20,11,1,209],false],
['t5043',1528,1820,31,[4883,4904,5526,5537],[21,21,11,1,224],false],
['t5044',1528,1639,31,[4913,4933,5526,5537],[20,20,11,1,217],false],
['t5045',1528,1852,31,[4942,4963,5526,5537],[21,21,11,1,221],false],
['t5046',1528,1601,31,[5009,5030,5526,5537],[21,21,11,1,220],false],
['t5047',1528,1821,31,[5039,5060,5526,5537],[21,21,11,1,224],false],
['t5048',1528,1640,31,[5069,5089,5526,5537],[20,20,11,1,217],false],
['t5049',1528,1853,31,[5098,5118,5526,5537],[20,20,11,1,216],false],
['t5050',1511,1484,1483,[2821,2834,5760,5775],[15,15,13,1,202],false],
['t5051',1507,1470,1483,[2865,2878,5744,5760],[15,15,13,1,201],false],
['t5052',1511,1486,1485,[3025,3039,5760,5775],[15,15,13,1.5,192],false],
['t5053',1507,1487,1486,[2971,2984,5745,5760],[15,15,13,1,202],false],
['t5054',1487,663,1470,[2956,2966,5817,5945],[129,129,10,1,1292],false],
['t5057',1470,1487,663,[2894,2905,5803,5916],[113,113,10,1,1154],false],
['t5058',1512,663,1487,[2861,2871,5833,5944],[111,111,10,1,1106],false],
['t5059',1483,1487,663,[2838,2849,5801,5915],[113,113,10,1,1171],false],
['t5060',4,663,1485,[2755,2791,5819,5865],[71,71,10,2,713],false],
['t5061',1484,1485,663,[2800,2811,5799,5865],[66,66,10,1,681],false],
['t5062',1507,1,1489,[1742,1755,5697,5714],[17,17,13,1,221],false],
['t5063',663,663,1501,[970,984,5906,5990],[83,83,14,1,1199],false],
['t5064',663,1507,663,[2180,2260,5784,5799],[81,81,15,1,1191],false],
['t5065',663,2941,1492,[2171,2195,5725,5739],[15,15,24,1,350],false],
['t5066',1507,1491,1493,[2632,2645,5785,5800],[15,15,13,1,197],false],
['t5069',1493,1484,663,[2612,2673,5812,5887],[126,126,9,3,1193],false],
['t5070',663,1492,663,[2504,2519,5808,5890],[82,82,14,1,1184],false],
['t5071',1492,663,1491,[2522,2573,5778,5878],[137,137,12,4,1617],false],
['t5072',1502,2941,1496,[2145,2158,5725,5739],[15,15,13,1,193],false],
['t5073',1496,2942,1496,[2120,2132,5745,5821],[13,13,76,1,951],false],
['t5074',1507,2943,2942,[2080,2093,5822,5836],[14,14,13,1,179],false],
['t5075',1511,1502,2943,[2059,2072,5822,5836],[14,14,13,1,179],false],
['t5076',31,663,1502,[2048,2120,5857,5869],[72,72,12,1,878],false],
['t5077',663,1496,663,[1859,1897,5770,5843],[96,96,15,2,1439],false],
['t5078',1496,3,663,[1790,1917,5741,5753],[128,128,12,1,1583],false],
['t5080',2,1498,663,[1678,1748,5867,6036],[229,229,10,2,2242],false],
['t5081',1489,663,1498,[1585,1629,5712,5941],[262,262,11,5,2906],false],
['t5083',1508,1498,663,[1616,1723,5799,5933],[231,231,11,2,2556],false],
['t5084',1472,1498,663,[1647,1720,5846,6012],[229,229,11,2,2438],false],
['t5085',1498,1499,663,[1585,1686,5988,6108],[307,307,11,5,3210],false],
['t5088',1499,663,1971,[1277,1431,6091,6132],[328,328,11,3,3553],false],
['t5089',1499,663,1971,[1277,1431,6029,6070],[328,328,11,3,3503],false],
['t5090',1499,663,1971,[1277,1431,5967,6008],[329,329,10,3,3282],false],
['t5091',1499,663,1971,[1278,1431,5904,5946],[327,327,10,3,3404],false],
['t5092',1499,663,1500,[1479,1551,5946,6038],[155,155,10,2,1517],false],
['t5093',1499,1500,663,[1480,1551,6060,6101],[165,165,10,3,1656],false],
['t5094',1499,1500,663,[1480,1551,6121,6163],[164,164,10,3,1663],false],
['t5095',1500,1971,31,[1464,1507,5759,5901],[261,261,10,5,2563],false],
['t5096',1500,1971,31,[1407,1450,5759,5869],[230,230,10,4,2285],false],
['t5097',1500,1971,31,[1349,1392,5759,5869],[230,230,11,4,2298],false],
['t5098',1500,1971,31,[1292,1335,5759,5869],[230,230,10,4,2285],false],
['t5099',1500,1971,31,[1234,1277,5760,5869],[229,229,11,4,2323],false],
['t5100',1500,1971,31,[1177,1219,5759,5869],[230,230,10,4,2311],false],
['t5101',1500,1971,31,[1119,1163,5759,5892],[268,268,11,4,2710],false],
]
