<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/collectors/freebsd.plugin/integrations/devstat.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/collectors/freebsd.plugin/metadata.yaml"
sidebar_label: "devstat"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/FreeBSD"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# devstat


<img src="https://netdata.cloud/img/hard-drive.svg" width="150"/>


Plugin: freebsd.plugin
Module: devstat

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

Collect information per hard disk available on host.

The plugin calls `sysctl` function to collect necessary data.

This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.

## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per devstat instance

These metrics give a general vision about I/O events on disks.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| system.io | io, out | KiB/s |

### Per disk



This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| disk.io | reads, writes, frees | KiB/s |
| disk.ops | reads, writes, other, frees | operations/s |
| disk.qops | operations | operations |
| disk.util | utilization | % of time working |
| disk.iotime | reads, writes, other, frees | milliseconds/s |
| disk.await | reads, writes, other, frees | milliseconds/operation |
| disk.avgsz | reads, writes, frees | KiB/operation |
| disk.svctm | svctm | milliseconds/operation |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ 10min_disk_utilization ](https://github.com/netdata/netdata/blob/master/src/health/health.d/disks.conf) | disk.util | average percentage of time ${label:device} disk was busy over the last 10 minutes |


## Setup


### Prerequisites

No action required.

### Configuration

#### Options



<details open><summary>Config options</summary>



| Option | Description | Default | Required |
|:-----|:------------|:--------|:---------:|
| enable new disks detected at runtime | Enable or disable possibility to detect new disks. | auto | no |
| performance metrics for pass devices | Enable or disable metrics for disks with type `PASS`. | auto | no |
| total bandwidth for all disks | Enable or disable total bandwidth metric for all disks. | yes | no |
| bandwidth for all disks | Enable or disable bandwidth for all disks metric. | auto | no |
| operations for all disks | Enable or disable operations for all disks metric. | auto | no |
| queued operations for all disks | Enable or disable queued operations for all disks  metric. | auto | no |
| utilization percentage for all disks | Enable or disable utilization percentage for all disks metric. | auto | no |
| i/o time for all disks | Enable or disable I/O time for all disks metric. | auto | no |
| average completed i/o time for all disks | Enable or disable average completed I/O time for all disks metric. | auto | no |
| average completed i/o bandwidth for all disks | Enable or disable average completed I/O bandwidth for all disks metric. | auto | no |
| average service time for all disks | Enable or disable average service time for all disks metric. | auto | no |
| disable by default disks matching | Do not create charts for disks listed. |  | no |


</details>



#### via File

The configuration file name for this integration is `netdata.conf`.
Configuration for this specific integration is located in the `[plugin:freebsd:kern.devstat]` section within that file.

The file format is a modified INI syntax. The general structure is:

```ini
[section1]
    option1 = some value
    option2 = some other value

[section2]
    option3 = some third value
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config netdata.conf
```

##### Examples
There are no configuration examples.


