<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/collectors/proc.plugin/integrations/btrfs.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/collectors/proc.plugin/metadata.yaml"
sidebar_label: "BTRFS"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Linux Systems/Filesystem/BTRFS"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# BTRFS


<img src="https://netdata.cloud/img/filesystem.svg" width="150"/>


Plugin: proc.plugin
Module: /sys/fs/btrfs

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This integration provides usage and error statistics from the BTRFS filesystem.



This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.

## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per btrfs filesystem



Labels:

| Label      | Description     |
|:-----------|:----------------|
| filesystem_uuid | TBD |
| filesystem_label | TBD |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| btrfs.disk | unallocated, data_free, data_used, meta_free, meta_used, sys_free, sys_used | MiB |
| btrfs.data | free, used | MiB |
| btrfs.metadata | free, used, reserved | MiB |
| btrfs.system | free, used | MiB |
| btrfs.commits | commits | commits |
| btrfs.commits_perc_time | commits | percentage |
| btrfs.commit_timings | last, max | ms |

### Per btrfs device



Labels:

| Label      | Description     |
|:-----------|:----------------|
| device_id | TBD |
| filesystem_uuid | TBD |
| filesystem_label | TBD |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| btrfs.device_errors | write_errs, read_errs, flush_errs, corruption_errs, generation_errs | errors |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ btrfs_allocated ](https://github.com/netdata/netdata/blob/master/src/health/health.d/btrfs.conf) | btrfs.disk | percentage of allocated BTRFS physical disk space |
| [ btrfs_data ](https://github.com/netdata/netdata/blob/master/src/health/health.d/btrfs.conf) | btrfs.data | utilization of BTRFS data space |
| [ btrfs_metadata ](https://github.com/netdata/netdata/blob/master/src/health/health.d/btrfs.conf) | btrfs.metadata | utilization of BTRFS metadata space |
| [ btrfs_system ](https://github.com/netdata/netdata/blob/master/src/health/health.d/btrfs.conf) | btrfs.system | utilization of BTRFS system space |
| [ btrfs_device_read_errors ](https://github.com/netdata/netdata/blob/master/src/health/health.d/btrfs.conf) | btrfs.device_errors | number of encountered BTRFS read errors |
| [ btrfs_device_write_errors ](https://github.com/netdata/netdata/blob/master/src/health/health.d/btrfs.conf) | btrfs.device_errors | number of encountered BTRFS write errors |
| [ btrfs_device_flush_errors ](https://github.com/netdata/netdata/blob/master/src/health/health.d/btrfs.conf) | btrfs.device_errors | number of encountered BTRFS flush errors |
| [ btrfs_device_corruption_errors ](https://github.com/netdata/netdata/blob/master/src/health/health.d/btrfs.conf) | btrfs.device_errors | number of encountered BTRFS corruption errors |
| [ btrfs_device_generation_errors ](https://github.com/netdata/netdata/blob/master/src/health/health.d/btrfs.conf) | btrfs.device_errors | number of encountered BTRFS generation errors |


## Setup


### Prerequisites

No action required.

### Configuration

#### Options



There are no configuration options.



#### via File

There is no configuration file.

##### Examples
There are no configuration examples.


