<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/collectors/windows.plugin/integrations/windows_services.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/collectors/windows.plugin/metadata.yaml"
sidebar_label: "Windows Services"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Windows Systems"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Windows Services


<img src="https://netdata.cloud/img/windows.svg" width="150"/>


Plugin: windows.plugin
Module: PerflibServices

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors Windows Services Status and States.


It queries Service Management to get the metrics.


This collector is only supported on the following platforms:

- windows

This collector only supports collecting metrics from a single instance of this integration.


### Default Behavior

#### Auto-Detection

The collector automatically detects all of the metrics, no further configuration is required.


#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.

## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per Windows Service

These metrics refer to Windows Services.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| service | The service name |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| windows.service_state | running, stopped, start_pending, stop_pending, continue_pending, pause_pending, paused, unknown | state |



## Alerts

There are no alerts configured by default for this integration.


## Setup


### Prerequisites

No action required.

### Configuration

#### Options





| Option | Description | Default | Required |
|:-----|:------------|:--------|:---------:|
| update every | Data collection frequency. | 30 | no |




#### via File

The configuration file name for this integration is `netdata.conf`.
Configuration for this specific integration is located in the `[plugin:windows:PerflibServices]` section within that file.

The file format is a modified INI syntax. The general structure is:

```ini
[section1]
    option1 = some value
    option2 = some other value

[section2]
    option3 = some third value
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config netdata.conf
```

##### Examples
There are no configuration examples.


