package pmi

import (
	"github.com/netdata/netdata/go/plugins/pkg/confopt"
	"github.com/netdata/netdata/go/plugins/pkg/web"
	"github.com/netdata/netdata/go/plugins/plugin/ibm.d/framework"
)

// Config defines the user-facing configuration for the WebSphere PMI module.
// Each field participates in the autogenerated documentation, so keep the
// comments concise but explicit about behaviour and defaults.
type Config struct {
	framework.Config `yaml:",inline" json:",inline"`
	web.HTTPConfig   `yaml:",inline" json:",inline"`

	// Vnode allows binding the collector to a virtual node.
	Vnode string `yaml:"vnode,omitempty" json:"vnode" ui:"group:Connection"`

	// PMIStatsType selects which PMI statistics tier to request (`basic`, `extended`, `all`, or `custom`).
	PMIStatsType string `yaml:"pmi_stats_type,omitempty" json:"pmi_stats_type" ui:"group:PMI Settings"`

	// PMIRefreshRate overrides the global PMI servlet refresh interval in seconds when a value >0 is provided.
	PMIRefreshRate int `yaml:"pmi_refresh_rate,omitempty" json:"pmi_refresh_rate" ui:"group:PMI Settings"`

	// PMICustomStatsPaths adds extra PMI XML paths when `pmi_stats_type` is set to `custom`.
	PMICustomStatsPaths []string `yaml:"pmi_custom_stats_paths,omitempty" json:"pmi_custom_stats_paths" ui:"group:PMI Settings"`

	// ClusterName appends the WebSphere cluster identifier label to every exported time-series.
	ClusterName string `yaml:"cluster_name,omitempty" json:"cluster_name" ui:"group:Identity"`

	// CellName appends the WebSphere cell identifier label to every exported time-series.
	CellName string `yaml:"cell_name,omitempty" json:"cell_name" ui:"group:Identity"`

	// NodeName appends the WebSphere node identifier label to every exported time-series.
	NodeName string `yaml:"node_name,omitempty" json:"node_name" ui:"group:Identity"`

	// ServerType records the WebSphere server type label (for example `app_server`, `dmgr`, `nodeagent`).
	ServerType string `yaml:"server_type,omitempty" json:"server_type" ui:"group:Identity"`

	// CustomLabels adds arbitrary static labels to every time-series (keys and values must be non-empty).
	CustomLabels map[string]string `yaml:"custom_labels,omitempty" json:"custom_labels" ui:"group:Identity"`

	// CollectJVMMetrics toggles JVM runtime metrics; defaults to enabled when unset.
	CollectJVMMetrics confopt.AutoBool `yaml:"collect_jvm_metrics,omitempty" json:"collect_jvm_metrics" ui:"group:Other Metrics"`

	// CollectThreadPoolMetrics toggles thread-pool metrics; defaults to enabled when unset.
	CollectThreadPoolMetrics confopt.AutoBool `yaml:"collect_threadpool_metrics,omitempty" json:"collect_threadpool_metrics" ui:"group:Thread Pools"`

	// CollectJDBCMetrics toggles JDBC connection-pool metrics; defaults to enabled when unset.
	CollectJDBCMetrics confopt.AutoBool `yaml:"collect_jdbc_metrics,omitempty" json:"collect_jdbc_metrics" ui:"group:JDBC"`

	// CollectJCAMetrics toggles JCA resource-adapter metrics; defaults to enabled when unset.
	CollectJCAMetrics confopt.AutoBool `yaml:"collect_jca_metrics,omitempty" json:"collect_jca_metrics" ui:"group:JCA"`

	// CollectJMSMetrics toggles JMS destination metrics; defaults to enabled when unset.
	CollectJMSMetrics confopt.AutoBool `yaml:"collect_jms_metrics,omitempty" json:"collect_jms_metrics" ui:"group:JMS"`

	// CollectWebAppMetrics toggles Web application metrics (includes servlet/session data); defaults to enabled when unset.
	CollectWebAppMetrics confopt.AutoBool `yaml:"collect_webapp_metrics,omitempty" json:"collect_webapp_metrics" ui:"group:Applications"`

	// CollectSessionMetrics toggles HTTP session manager metrics; defaults to enabled when unset.
	CollectSessionMetrics confopt.AutoBool `yaml:"collect_session_metrics,omitempty" json:"collect_session_metrics" ui:"group:Other Metrics"`

	// CollectTransactionMetrics toggles transaction manager metrics; defaults to enabled when unset.
	CollectTransactionMetrics confopt.AutoBool `yaml:"collect_transaction_metrics,omitempty" json:"collect_transaction_metrics" ui:"group:Other Metrics"`

	// CollectClusterMetrics toggles cluster-level health metrics; defaults to enabled when unset.
	CollectClusterMetrics confopt.AutoBool `yaml:"collect_cluster_metrics,omitempty" json:"collect_cluster_metrics" ui:"group:Other Metrics"`

	// CollectServletMetrics enables servlet response-time metrics; defaults to enabled when unset (may add high-cardinality charts).
	CollectServletMetrics confopt.AutoBool `yaml:"collect_servlet_metrics,omitempty" json:"collect_servlet_metrics" ui:"group:Servlets"`

	// CollectEJBMetrics enables Enterprise Java Bean workload metrics; defaults to enabled when unset.
	CollectEJBMetrics confopt.AutoBool `yaml:"collect_ejb_metrics,omitempty" json:"collect_ejb_metrics" ui:"group:EJBs"`

	// CollectJDBCAdvanced enables additional JDBC latency/timing statistics; defaults to disabled when unset.
	CollectJDBCAdvanced confopt.AutoBool `yaml:"collect_jdbc_advanced,omitempty" json:"collect_jdbc_advanced" ui:"group:JDBC"`

	// MaxThreadPools caps the number of thread pools charted per server (0 disables the limit).
	MaxThreadPools int `yaml:"max_threadpools,omitempty" json:"max_threadpools" ui:"group:Thread Pools"`

	// MaxJDBCPools caps the number of JDBC connection pools charted (0 disables the limit).
	MaxJDBCPools int `yaml:"max_jdbc_pools,omitempty" json:"max_jdbc_pools" ui:"group:JDBC"`

	// MaxJCAPools caps the number of JCA resource adapters charted (0 disables the limit).
	MaxJCAPools int `yaml:"max_jca_pools,omitempty" json:"max_jca_pools" ui:"group:JCA"`

	// MaxJMSDestinations caps the number of JMS destinations charted (0 disables the limit).
	MaxJMSDestinations int `yaml:"max_jms_destinations,omitempty" json:"max_jms_destinations" ui:"group:JMS"`

	// MaxApplications caps the number of web applications charted (0 disables the limit).
	MaxApplications int `yaml:"max_applications,omitempty" json:"max_applications" ui:"group:Applications"`

	// MaxServlets caps the number of servlet contexts charted when servlet collection is enabled (0 disables the limit).
	MaxServlets int `yaml:"max_servlets,omitempty" json:"max_servlets" ui:"group:Servlets"`

	// MaxEJBs caps the number of Enterprise Java Beans charted (0 disables the limit).
	MaxEJBs int `yaml:"max_ejbs,omitempty" json:"max_ejbs" ui:"group:EJBs"`

	// CollectAppsMatching filters Web applications by name using glob patterns (supports `*`, `?`, `!` prefixes).
	CollectAppsMatching string `yaml:"collect_apps_matching,omitempty" json:"collect_apps_matching" ui:"group:Applications"`

	// CollectPoolsMatching filters JDBC and JCA pools by name using glob patterns (supports `*`, `?`, `!` prefixes).
	CollectPoolsMatching string `yaml:"collect_pools_matching,omitempty" json:"collect_pools_matching" ui:"group:Thread Pools"`

	// CollectJMSMatching filters JMS destinations by name using glob patterns (supports `*`, `?`, `!` prefixes).
	CollectJMSMatching string `yaml:"collect_jms_matching,omitempty" json:"collect_jms_matching" ui:"group:JMS"`

	// CollectServletsMatching filters servlet contexts by name using glob patterns (supports `*`, `?`, `!` prefixes).
	CollectServletsMatching string `yaml:"collect_servlets_matching,omitempty" json:"collect_servlets_matching" ui:"group:Servlets"`

	// CollectEJBsMatching filters Enterprise Java Beans by name using glob patterns (supports `*`, `?`, `!` prefixes).
	CollectEJBsMatching string `yaml:"collect_ejbs_matching,omitempty" json:"collect_ejbs_matching" ui:"group:EJBs"`
}
