## [unreleased]

### Merged Pull Requests:

- Fix(go.d/vnodes): add additionalProperties to config_schema.json ([#21503](https://github.com/netdata/netdata/issues/21503))
- Fix(edit-config): ignore container variable inherited from /etc/profile ([#21505](https://github.com/netdata/netdata/issues/21505))
- Fix: add procfile parsing for non-seekable files ([#21507](https://github.com/netdata/netdata/issues/21507))
- Fix(go.d/proxysql): correct backend status metric mapping ([#21524](https://github.com/netdata/netdata/issues/21524))
- Fix(go.d/pkg/logs):  fix ParserConfig.CSV omitempty behavior ([#21526](https://github.com/netdata/netdata/issues/21526))
- Use the same type for all time_group_value values ([#21528](https://github.com/netdata/netdata/issues/21528))
- Fix(diskspace.plugin): exclude ZFS datasets ([#21532](https://github.com/netdata/netdata/issues/21532))

## [2.8.4] - 2025-12-17

### Merged Pull Requests:

- Build(deps): update go toolchain to v1.25.5 ([#21459](https://github.com/netdata/netdata/issues/21459))
- Chore(go.d): include Go version in build info ([#21473](https://github.com/netdata/netdata/issues/21473))

## [2.8.3] - 2025-12-15

### Merged Pull Requests:

- Update bundled components for static builds. ([#21401](https://github.com/netdata/netdata/issues/21401))
- Disable MongoDB exporter for Ubuntu 20.04, 22.04, and 24.04 packages. ([#21403](https://github.com/netdata/netdata/issues/21403))
- Change chart variable (Windows.plugin) ([#21412](https://github.com/netdata/netdata/issues/21412))
- Fix shutdown timeout handling in completion wait function ([#21395](https://github.com/netdata/netdata/issues/21395))
- Fix validation of extent index in journal file ([#21400](https://github.com/netdata/netdata/issues/21400))
- Improve check for DBENGINE max datafile size allowed ([#21390](https://github.com/netdata/netdata/issues/21390))
- Fix(go.d/pkg/ndexec): return the output along with the error ([#21405](https://github.com/netdata/netdata/issues/21405))
- Fix(rabbitmq): remove "rabbitmq_version" check ([#21411](https://github.com/netdata/netdata/issues/21411))
- Chore(go.d/snmp): add collection stats ([#21409](https://github.com/netdata/netdata/issues/21409))
- Chore(go.d): log skipped data collection ([#21423](https://github.com/netdata/netdata/issues/21423))
- Chore(go.d/snmp): remove non-default update_every from sd config ([#21424](https://github.com/netdata/netdata/issues/21424))
- Chore(go.d): log data collection duration when skipping tick ([#21425](https://github.com/netdata/netdata/issues/21425))
- Fix(go.d): avoid blocking all jobs when stopping a slow job ([#21448](https://github.com/netdata/netdata/issues/21448))
- Use improved compression algorithms when building DEB packages. ([#21310](https://github.com/netdata/netdata/issues/21310))
- Fix(go.d): correct Windows install paths ([#21451](https://github.com/netdata/netdata/issues/21451))
- Adjust hardware collection (windows.plugin) ([#21433](https://github.com/netdata/netdata/issues/21433))
- AD fixes (windows.plugin) ([#21454](https://github.com/netdata/netdata/issues/21454))
- Fix(go.d/ap):  handle unknown values in station statistics gracefully ([#21461](https://github.com/netdata/netdata/issues/21461))
- Improve streaming connection loss detection ([#21430](https://github.com/netdata/netdata/issues/21430))

## [2.8.2] - 2025-12-03

### Merged Pull Requests:

- Improve replication logic by checking if parent is caught up with child ([#21352](https://github.com/netdata/netdata/issues/21352))
- Improve stale replication ([#21357](https://github.com/netdata/netdata/issues/21357))
- Fix(docker): add netdata user to nvidia device group on non-Debian systems ([#21358](https://github.com/netdata/netdata/issues/21358))
- Add netdata user to video group ([#21359](https://github.com/netdata/netdata/issues/21359))
- Fix(docker): fix bugs and refactor Docker entrypoint script ([#21364](https://github.com/netdata/netdata/issues/21364))
- Adjust windows sensors initialization ([#21374](https://github.com/netdata/netdata/issues/21374))
- Ci: fix MCP Registry publishing workflow ([#21342](https://github.com/netdata/netdata/issues/21342))
- Chore(go.d): disable redis lib logging ([#21344](https://github.com/netdata/netdata/issues/21344))
- Fix(go.d): prefer env-provided dirs over build-time defaults ([#21345](https://github.com/netdata/netdata/issues/21345))
- Remove retention check during datafile initialization ([#21387](https://github.com/netdata/netdata/issues/21387))
- Replace dots with slashes in OTEL metric families for hierarchical grouping ([#21371](https://github.com/netdata/netdata/issues/21371))

## [2.8.1] - 2025-11-21

### Merged Pull Requests:

- Remove log message ([#21325](https://github.com/netdata/netdata/issues/21325))
- Fix compilation when DBENGINE is disabled ([#21323](https://github.com/netdata/netdata/issues/21323))
- Fix(cgroups): improve podman container name resolution ([#21317](https://github.com/netdata/netdata/issues/21317))
- Improve(health/dyncfg): Add source unit field to alert value ([#21326](https://github.com/netdata/netdata/issues/21326))
- Disable apps plugin pss mem by default ([#21330](https://github.com/netdata/netdata/issues/21330))
- Fix(go.d): fix dyncfg vnodes configs ([#21332](https://github.com/netdata/netdata/issues/21332))

## [2.8.0] - 2025-11-19

### Merged Pull Requests:

- Improve(go.d/rabbitmq): add support for old RabbitMQ whoami tags format ([#21049](https://github.com/netdata/netdata/issues/21049))
- Ai-docs ([#21043](https://github.com/netdata/netdata/issues/21043))
- Feat(go.d/snmp): add optional ICMP ping metrics ([#21052](https://github.com/netdata/netdata/issues/21052))
- Regenerate integrations docs ([#21053](https://github.com/netdata/netdata/issues/21053))
- Feat(go.d/snmp): enable ping by default ([#21054](https://github.com/netdata/netdata/issues/21054))
- Regenerate integrations docs ([#21055](https://github.com/netdata/netdata/issues/21055))
- Chore(go.d/snmp): remove legacy custom oid collection ([#21056](https://github.com/netdata/netdata/issues/21056))
- Regenerate integrations docs ([#21058](https://github.com/netdata/netdata/issues/21058))
- Chore(go.d/ddsmp): profile definition cleanup ([#21062](https://github.com/netdata/netdata/issues/21062))
- Feat(go.d/snmp): add `ping_only` option ([#21064](https://github.com/netdata/netdata/issues/21064))
- Regenerate integrations docs ([#21065](https://github.com/netdata/netdata/issues/21065))
- Add helper to run external commands without additional privileges. ([#20990](https://github.com/netdata/netdata/issues/20990))
- Win plugin files with .plugin extension ([#21068](https://github.com/netdata/netdata/issues/21068))
- Add missing extension go.d (Windows) ([#21070](https://github.com/netdata/netdata/issues/21070))
- Declare flatten-serde-json at the workspace. ([#21072](https://github.com/netdata/netdata/issues/21072))
- Convert go collectors to use ndexec module for external command invocation ([#21067](https://github.com/netdata/netdata/issues/21067))
- Ml: implement fixed time-based training windows - corrected ([#21046](https://github.com/netdata/netdata/issues/21046))
- Build(deps): bump openssl version in static build ([#21074](https://github.com/netdata/netdata/issues/21074))
- Docs: add note about using ``--init` when not running with `pid: host` ([#21075](https://github.com/netdata/netdata/issues/21075))
- Make `nd-run` silent unless exiting with an error ([#21076](https://github.com/netdata/netdata/issues/21076))
- Build(go): add config dirs ([#21077](https://github.com/netdata/netdata/issues/21077))
- Docs: update SNMP collector metadata to reflect profile-based collection ([#21078](https://github.com/netdata/netdata/issues/21078))
- Regenerate integrations docs ([#21079](https://github.com/netdata/netdata/issues/21079))
- Clean up handling of compiler flags in our build code. ([#20821](https://github.com/netdata/netdata/issues/20821))
- Fix libbpf.a build path ([#21051](https://github.com/netdata/netdata/issues/21051))
- Adjust Disk Size (Windows.plugin) ([#21081](https://github.com/netdata/netdata/issues/21081))
- Fix duplicate header leak in ACLK HTTPS client ([#21084](https://github.com/netdata/netdata/issues/21084))
- Remote MCP support (streamable http and sse) ([#21036](https://github.com/netdata/netdata/issues/21036))
- MCP docs and log spamming fix ([#21087](https://github.com/netdata/netdata/issues/21087))
- Register Netdata to MCP Registry ([#21088](https://github.com/netdata/netdata/issues/21088))
- Fix app.mem_usage  (Windows) ([#21085](https://github.com/netdata/netdata/issues/21085))
- Fix cgroup-network spawn server cleanup on fatal exit ([#21080](https://github.com/netdata/netdata/issues/21080))
- Correctly split MCP registry update to it’s own workflow. ([#21089](https://github.com/netdata/netdata/issues/21089))
- Improve installer (Windows) ([#21090](https://github.com/netdata/netdata/issues/21090))
- Build(deps): bump github.com/docker/docker from 28.4.0+incompatible to 28.5.0+incompatible in /src/go ([#21095](https://github.com/netdata/netdata/issues/21095))
- Build(deps): bump github.com/go-ldap/ldap/v3 from 3.4.11 to 3.4.12 in /src/go ([#21094](https://github.com/netdata/netdata/issues/21094))
- Hide  mem_private_usage on Windows. ([#21093](https://github.com/netdata/netdata/issues/21093))
- Fix(packaging/docker): add missing nd-run ([#21097](https://github.com/netdata/netdata/issues/21097))
- Event loop cleanup ([#21091](https://github.com/netdata/netdata/issues/21091))
- Add documentation and fallback to /host/ for getting the machine id ([#21044](https://github.com/netdata/netdata/issues/21044))
- Update building-native-packages-locally.md ([#21101](https://github.com/netdata/netdata/issues/21101))
- Use datafile block pos ([#21098](https://github.com/netdata/netdata/issues/21098))
- Improve(go.d/snmp): Add APC PowerNet-MIB sysObjectID mappings and categories ([#21104](https://github.com/netdata/netdata/issues/21104))
- Update `cloud-notifications` documentation ([#21105](https://github.com/netdata/netdata/issues/21105))
- Regenerate integrations docs ([#21106](https://github.com/netdata/netdata/issues/21106))
- Improve logging and packet handling for unknown packet IDs ([#21099](https://github.com/netdata/netdata/issues/21099))
- Fix invalid map.csv ([#21108](https://github.com/netdata/netdata/issues/21108))
- Fix freeipmi crash ([#21109](https://github.com/netdata/netdata/issues/21109))
- Update installer documentation ([#21096](https://github.com/netdata/netdata/issues/21096))
- Ibm.d.plugin: i, db2, mq, websphere ([#21066](https://github.com/netdata/netdata/issues/21066))
- Build(deps): bump github.com/prometheus/common from 0.66.1 to 0.67.1 in /src/go ([#21111](https://github.com/netdata/netdata/issues/21111))
- Build(deps): bump github.com/ibmdb/go_ibm_db from 0.4.5 to 0.5.3 in /src/go ([#21110](https://github.com/netdata/netdata/issues/21110))
- Fix windows build ([#21113](https://github.com/netdata/netdata/issues/21113))
- Address NULL access (windows.plugin) ([#21112](https://github.com/netdata/netdata/issues/21112))
- Properly include client compoents for IBM MQ libraries. ([#21117](https://github.com/netdata/netdata/issues/21117))
- Add openSUSE Leap 16.0 and Ubuntu 25.10 to CI and package builds. ([#21100](https://github.com/netdata/netdata/issues/21100))
- Make native package dependencies consistent between DEB/RPM packages. ([#21118](https://github.com/netdata/netdata/issues/21118))
- Properly check for ODBC for IBM plugin at configuration time. ([#21116](https://github.com/netdata/netdata/issues/21116))
- Fix issues with IBM libs plugin. ([#21120](https://github.com/netdata/netdata/issues/21120))
- Improve free disk space calculation for Windows ([#21121](https://github.com/netdata/netdata/issues/21121))
- Update IBM plugin documentation. ([#21122](https://github.com/netdata/netdata/issues/21122))
- Fix(ibm.d): various fixes ([#21123](https://github.com/netdata/netdata/issues/21123))
- Fix(ibm.d/mq): change default ExponentialBackoff attempts to 2 ([#21124](https://github.com/netdata/netdata/issues/21124))
- Chore: go.d/ibm.d various fixes ([#21128](https://github.com/netdata/netdata/issues/21128))
- Build: update go otel deps ([#21129](https://github.com/netdata/netdata/issues/21129))
- Build(deps): bump github/codeql-action from 3 to 4 ([#21133](https://github.com/netdata/netdata/issues/21133))
- Build(deps): bump golang.org/x/net from 0.44.0 to 0.46.0 in /src/go ([#21137](https://github.com/netdata/netdata/issues/21137))
- Build(deps): bump github.com/gofrs/flock from 0.12.1 to 0.13.0 in /src/go ([#21134](https://github.com/netdata/netdata/issues/21134))
- Build(deps): bump github.com/docker/docker from 28.5.0+incompatible to 28.5.1+incompatible in /src/go ([#21135](https://github.com/netdata/netdata/issues/21135))
- Build(deps): bump github.com/gohugoio/hashstructure from 0.5.0 to 0.6.0 in /src/go ([#21138](https://github.com/netdata/netdata/issues/21138))
- Chore: move go.d/ibm.d shared pkgs out of go.d ([#21132](https://github.com/netdata/netdata/issues/21132))
- Improve(go.d/snmp): automatically disable SNMP bulkwalk when not supported ([#21139](https://github.com/netdata/netdata/issues/21139))
- Improve agent startup on windows ([#21125](https://github.com/netdata/netdata/issues/21125))
- Add Fedora 43 to CI and package builds. ([#21142](https://github.com/netdata/netdata/issues/21142))
- Skip status file on windows on crash ([#21140](https://github.com/netdata/netdata/issues/21140))
- Chore(go.d): update dyncfg path ([#21141](https://github.com/netdata/netdata/issues/21141))
- Updated child node behaviour change ([#21073](https://github.com/netdata/netdata/issues/21073))
- Switch to using a relative RUNPATH for IBM plugin library lookup. ([#21131](https://github.com/netdata/netdata/issues/21131))
- Fix AS400 metrics ([#21147](https://github.com/netdata/netdata/issues/21147))
- Additional checks during cgroup discovery ([#21148](https://github.com/netdata/netdata/issues/21148))
- Customize node name addition ([#21151](https://github.com/netdata/netdata/issues/21151))
- Fix NaN check in anomaly score calculation ([#21149](https://github.com/netdata/netdata/issues/21149))
- Skip adding Sentry breadcrumb during shutdown timeout ([#21150](https://github.com/netdata/netdata/issues/21150))
- Add `ServiceNow` integration ([#21154](https://github.com/netdata/netdata/issues/21154))
- Regenerate integrations docs ([#21156](https://github.com/netdata/netdata/issues/21156))
- Type 2 attestation added ([#21157](https://github.com/netdata/netdata/issues/21157))
- Docs: update Notifications description in cloud-notifications meta ([#21159](https://github.com/netdata/netdata/issues/21159))
- Regenerate integrations docs ([#21160](https://github.com/netdata/netdata/issues/21160))
- As400 improvements ([#21158](https://github.com/netdata/netdata/issues/21158))
- Enable Rust-based systemd journal handling code in Docker builds. ([#21161](https://github.com/netdata/netdata/issues/21161))
- Use parallelization for LTO processing to reduce build times. ([#20809](https://github.com/netdata/netdata/issues/20809))
- Fix feature size calculation and add error handling for KMeans training ([#21155](https://github.com/netdata/netdata/issues/21155))
- Rework maintenance thread ([#20694](https://github.com/netdata/netdata/issues/20694))
- Add Windows install types and release channels doc + update map.csv ([#21119](https://github.com/netdata/netdata/issues/21119))
- Libunwind ([#21163](https://github.com/netdata/netdata/issues/21163))
- Build(deps): bump github.com/ibmdb/go_ibm_db from 0.5.3 to 0.5.4 in /src/go ([#21167](https://github.com/netdata/netdata/issues/21167))
- Build(deps): bump github.com/ibm-messaging/mq-golang/v5 from 5.6.4 to 5.6.5 in /src/go ([#21166](https://github.com/netdata/netdata/issues/21166))
- Docs: fix map.csv for win ([#21168](https://github.com/netdata/netdata/issues/21168))
- Build(deps): bump azure/trusted-signing-action from 0.5.9 to 0.5.10 ([#21173](https://github.com/netdata/netdata/issues/21173))
- Build(deps): bump github.com/redis/go-redis/v9 from 9.14.0 to 9.14.1 in /src/go ([#21174](https://github.com/netdata/netdata/issues/21174))
- Fix /api/v3 data update_every after filtering ([#21170](https://github.com/netdata/netdata/issues/21170))
- Swagger docs ([#21086](https://github.com/netdata/netdata/issues/21086))
- Stacktrace-common: define USE_NOTRACE if no HAVE_BACKTRACE ([#21165](https://github.com/netdata/netdata/issues/21165))
- Update swagger json from yaml ([#21176](https://github.com/netdata/netdata/issues/21176))
- Periodic sync data on windows ([#21175](https://github.com/netdata/netdata/issues/21175))
- Docs: remove ``` from cloud-notifications meta ([#21178](https://github.com/netdata/netdata/issues/21178))
- Regenerate integrations docs ([#21179](https://github.com/netdata/netdata/issues/21179))
- Chore(go.d/snmp): refactor static_tags to structured key/value format ([#21180](https://github.com/netdata/netdata/issues/21180))
- Fix(health/dyncfg): add mising "repeat" in userconfig response ([#21181](https://github.com/netdata/netdata/issues/21181))
- Windows Sensors (Part II) ([#20988](https://github.com/netdata/netdata/issues/20988))
- Regenerate integrations docs ([#21185](https://github.com/netdata/netdata/issues/21185))
- Calculate weights for multiple nodes in parallel ([#21184](https://github.com/netdata/netdata/issues/21184))
- Prometheus - exporting metrics ([#21187](https://github.com/netdata/netdata/issues/21187))
- Initialize cli earlier during agent startup ([#21188](https://github.com/netdata/netdata/issues/21188))
- Fix ML concurrent dimension training  ([#21183](https://github.com/netdata/netdata/issues/21183))
- Ci: remove update-website.yml workflow ([#21191](https://github.com/netdata/netdata/issues/21191))
- Netdata API ([#21193](https://github.com/netdata/netdata/issues/21193))
- Alerts api summary option ([#21192](https://github.com/netdata/netdata/issues/21192))
- MSSQL Small fixes (windows.plugin) ([#21197](https://github.com/netdata/netdata/issues/21197))
- As400 part3: performance optimizations ([#21164](https://github.com/netdata/netdata/issues/21164))
- Fix(packagin/otel-plugin): remove cap_net_bind_service ([#21198](https://github.com/netdata/netdata/issues/21198))
- SQL Server Jobs (windows.plugin) ([#21182](https://github.com/netdata/netdata/issues/21182))
- Regenerate integrations docs ([#21202](https://github.com/netdata/netdata/issues/21202))
- Improvement(go.d/mysql): Measure redo log occupancy ([#21153](https://github.com/netdata/netdata/issues/21153))
- Regenerate integrations docs ([#21205](https://github.com/netdata/netdata/issues/21205))
- Acquire and release metric as needed during journal v2 migration ([#21200](https://github.com/netdata/netdata/issues/21200))
- Ibm.d: various fixes ([#21204](https://github.com/netdata/netdata/issues/21204))
- Build(deps): bump github.com/redis/go-redis/v9 from 9.14.1 to 9.16.0 in /src/go ([#21208](https://github.com/netdata/netdata/issues/21208))
- Build(deps): bump actions/upload-artifact from 4.6.2 to 5.0.0 ([#21206](https://github.com/netdata/netdata/issues/21206))
- Docs: add SNMP profile format doc ([#21201](https://github.com/netdata/netdata/issues/21201))
- Docs: add snmp profile format to snmp collector doc ([#21210](https://github.com/netdata/netdata/issues/21210))
- Regenerate integrations docs ([#21211](https://github.com/netdata/netdata/issues/21211))
- Add Expanded Chart Analysis doc and update map.csv ([#21213](https://github.com/netdata/netdata/issues/21213))
- Events Feed ([#21215](https://github.com/netdata/netdata/issues/21215))
- Dashboards and Charts ([#21216](https://github.com/netdata/netdata/issues/21216))
- Monitor Anything ([#21217](https://github.com/netdata/netdata/issues/21217))
- Systemd-journal ([#21222](https://github.com/netdata/netdata/issues/21222))
- Charts ([#21219](https://github.com/netdata/netdata/issues/21219))
- Docs: improve snmp profile format documentation ([#21223](https://github.com/netdata/netdata/issues/21223))
- Active_journal_centralization_guide_no_encryption.md ([#21221](https://github.com/netdata/netdata/issues/21221))
- Passive-journal-centralization-without-encryption.md ([#21220](https://github.com/netdata/netdata/issues/21220))
- Doc: improve COLLECTORS.md generation ([#21225](https://github.com/netdata/netdata/issues/21225))
- Docs: fix COLLECTORS.md generation ([#21228](https://github.com/netdata/netdata/issues/21228))
- Regenerate integrations docs ([#21229](https://github.com/netdata/netdata/issues/21229))
- Build(deps): bump github.com/prometheus/common from 0.67.1 to 0.67.2 in /src/go ([#21232](https://github.com/netdata/netdata/issues/21232))
- Build(deps): bump go.mongodb.org/mongo-driver from 1.17.4 to 1.17.6 in /src/go ([#21231](https://github.com/netdata/netdata/issues/21231))
- Docs: improve COLLECTORS.md generation ([#21233](https://github.com/netdata/netdata/issues/21233))
- Update MCP Registry publishing workflow and migrate server.json to latest schema ([#21230](https://github.com/netdata/netdata/issues/21230))
- Regenerate integrations docs ([#21234](https://github.com/netdata/netdata/issues/21234))
- Fix handling of auto updater and data files during native package removal. ([#21203](https://github.com/netdata/netdata/issues/21203))
- Make OpenTelemetry plugin a required dependency for native DEB/RPM packages. ([#21194](https://github.com/netdata/netdata/issues/21194))
- CPU Temperature (windows.plugin) ([#20992](https://github.com/netdata/netdata/issues/20992))
- Regenerate integrations docs ([#21237](https://github.com/netdata/netdata/issues/21237))
- Apps.plugin: add PSS-based memory estimation ([#21199](https://github.com/netdata/netdata/issues/21199))
- Regenerate integrations docs ([#21241](https://github.com/netdata/netdata/issues/21241))
- Handle problematic repo configuration states in kickstart. ([#21226](https://github.com/netdata/netdata/issues/21226))
- Extend code signing in Windows CI to cover drivers. ([#21242](https://github.com/netdata/netdata/issues/21242))
- Check metric count during journal creation ([#21238](https://github.com/netdata/netdata/issues/21238))
- Switch to git-cliff for changelog generation. ([#21218](https://github.com/netdata/netdata/issues/21218))
- WebSocket: Increase inactivity timeout from 5 to 30 minutes ([#21244](https://github.com/netdata/netdata/issues/21244))
- Chore(go.d): add prefix-based func registration ([#21245](https://github.com/netdata/netdata/issues/21245))
- Fix(uninstaller): define rm_file before first use ([#21246](https://github.com/netdata/netdata/issues/21246))
- Build(deps): bump kenji-miyake/setup-git-cliff from 1 to 2 ([#21247](https://github.com/netdata/netdata/issues/21247))
- Route dyncfg GET requests through plugin ([#21249](https://github.com/netdata/netdata/issues/21249))
- Fix(go.d/ping): preserve original ping error by using %w for wrapping ([#21251](https://github.com/netdata/netdata/issues/21251))
- Improve ML shutdown checks ([#21250](https://github.com/netdata/netdata/issues/21250))
- Fix systemd-cat-native crash on realloc ([#21254](https://github.com/netdata/netdata/issues/21254))
- Format code - MSSQL (windows.plugin) ([#21256](https://github.com/netdata/netdata/issues/21256))
- Build(deps): bump github.com/ibm-messaging/mq-golang/v5 from 5.6.5 to 5.6.6 in /src/go ([#21259](https://github.com/netdata/netdata/issues/21259))
- Additional tests to MSSQL (windows.plugin) ([#21255](https://github.com/netdata/netdata/issues/21255))
- Adjust page cache locking ([#21240](https://github.com/netdata/netdata/issues/21240))
- Chore(go.d): add shared dyncfg package ([#21263](https://github.com/netdata/netdata/issues/21263))
- Fix tier check ([#21248](https://github.com/netdata/netdata/issues/21248))
- Fix aral race condition ([#21258](https://github.com/netdata/netdata/issues/21258))
- Update documentation to reflect SOC 2 Type 2 certification ([#21265](https://github.com/netdata/netdata/issues/21265))
- Improve agent startup ([#21260](https://github.com/netdata/netdata/issues/21260))
- Add missing modulo operator to alerts ([#21267](https://github.com/netdata/netdata/issues/21267))
- Improve websocket thread shutdown ([#21264](https://github.com/netdata/netdata/issues/21264))
- Build(deps): bump github.com/docker/docker from 28.5.1+incompatible to 28.5.2+incompatible in /src/go ([#21268](https://github.com/netdata/netdata/issues/21268))
- Security and Privacy ([#21271](https://github.com/netdata/netdata/issues/21271))
- Improve(go.d/sd/pipeline): add `services` config ([#21269](https://github.com/netdata/netdata/issues/21269))
- Chore(go.d/sd): make module optional in the template ([#21273](https://github.com/netdata/netdata/issues/21273))
- Compute timestamps needed for status file ([#21272](https://github.com/netdata/netdata/issues/21272))
- Detect netdata CLI initialization failure ([#21275](https://github.com/netdata/netdata/issues/21275))
- Doc: add SNMP to snmp profile format doc title ([#21277](https://github.com/netdata/netdata/issues/21277))
- Build(deps): bump golang.org/x/sync from 0.17.0 to 0.18.0 in /src/go ([#21278](https://github.com/netdata/netdata/issues/21278))
- Add openSUSE Tumbleweed to CI and package builds. ([#21276](https://github.com/netdata/netdata/issues/21276))
- MSSQL Replication - Publisher (Windows.plugin) ([#21235](https://github.com/netdata/netdata/issues/21235))
- Initialize reusable buffers when streaming ML to parent ([#21279](https://github.com/netdata/netdata/issues/21279))
- Improve forced new datafile on startup ([#21282](https://github.com/netdata/netdata/issues/21282))
- Adjust tier retention calculation ([#21280](https://github.com/netdata/netdata/issues/21280))
- Regenerate integrations docs ([#21284](https://github.com/netdata/netdata/issues/21284))
- Report failures to update native packages. ([#21144](https://github.com/netdata/netdata/issues/21144))
- Update our user/group account handling to use sysusers.d when possible. ([#21162](https://github.com/netdata/netdata/issues/21162))
- Additional check when executing a CLI command ([#21286](https://github.com/netdata/netdata/issues/21286))
- Always set ephemerality label with the correct value ([#21274](https://github.com/netdata/netdata/issues/21274))
- Installation Update ([#21292](https://github.com/netdata/netdata/issues/21292))
- Reorganize MSSQL collection. ([#21290](https://github.com/netdata/netdata/issues/21290))
- Fix repository URLs for openSUSE Tumbleweed. ([#21296](https://github.com/netdata/netdata/issues/21296))
- Sensors (windows.plugin) ([#21266](https://github.com/netdata/netdata/issues/21266))
- Account deletion update ([#21293](https://github.com/netdata/netdata/issues/21293))
- Feat(go.d): add generic sql collector ([#21281](https://github.com/netdata/netdata/issues/21281))
- Regenerate integrations docs ([#21297](https://github.com/netdata/netdata/issues/21297))
- Docs: remove prometheus SQL Exporter ([#21306](https://github.com/netdata/netdata/issues/21306))
- Regenerate integrations docs ([#21307](https://github.com/netdata/netdata/issues/21307))
- Docs: add ScyllaDB prometheus ([#21308](https://github.com/netdata/netdata/issues/21308))
- Regenerate integrations docs ([#21309](https://github.com/netdata/netdata/issues/21309))
- Fix csvjsonarray format returning invalid JSON with extra closing bracket when no data present ([#21304](https://github.com/netdata/netdata/issues/21304))
- Improve(go.d/nvidia_smi): add autodetection_retry option ([#21311](https://github.com/netdata/netdata/issues/21311))
- Regenerate integrations docs ([#21312](https://github.com/netdata/netdata/issues/21312))
- Improve(go.d/sql): add per-query execution time charts ([#21313](https://github.com/netdata/netdata/issues/21313))
- Regenerate integrations docs ([#21314](https://github.com/netdata/netdata/issues/21314))
- Additional checks during initial context load ([#21298](https://github.com/netdata/netdata/issues/21298))
- MSSQL Options (windows.plugin) ([#21301](https://github.com/netdata/netdata/issues/21301))
- Proper locking when searching for datafile ([#21302](https://github.com/netdata/netdata/issues/21302))
- Reset backfill requests on child reconnect ([#21315](https://github.com/netdata/netdata/issues/21315))
- Add helm repo when adding kuberentes to the nodes ([#21318](https://github.com/netdata/netdata/issues/21318))
- Regenerate integrations docs ([#21316](https://github.com/netdata/netdata/issues/21316))

## [2.7.0] - 2025-09-25

### Merged Pull Requests:

- Update otel-collector components deps ([#20693](https://github.com/netdata/netdata/issues/20693))
- Replace legacy functions-table.md with comprehensive UI documentation ([#20697](https://github.com/netdata/netdata/issues/20697))
- Add Getting Started Netdata guide ([#20642](https://github.com/netdata/netdata/issues/20642))
- Escape < character in plaintext ([#20699](https://github.com/netdata/netdata/issues/20699))
- Update UPDATE.md ([#20701](https://github.com/netdata/netdata/issues/20701))
- Fix(nvme)!: query controller instead of namespace for SMART metrics ([#20704](https://github.com/netdata/netdata/issues/20704))
- Ensure chat exists before handling message input ([#20700](https://github.com/netdata/netdata/issues/20700))
- Build(deps): bump k8s.io/client-go from 0.33.2 to 0.33.3 in /src/go ([#20705](https://github.com/netdata/netdata/issues/20705))
- Build(deps): bump github.com/gosnmp/gosnmp from 1.41.0 to 1.42.0 in /src/go ([#20707](https://github.com/netdata/netdata/issues/20707))
- Build(deps): bump github.com/gosnmp/gosnmp from 1.42.0 to 1.42.1 in /src/go ([#20709](https://github.com/netdata/netdata/issues/20709))
- Update LIBBPF ([#20696](https://github.com/netdata/netdata/issues/20696))
- Improve(go.d/snmp): add profile device meta to vnode labels ([#20718](https://github.com/netdata/netdata/issues/20718))
- Mark the completion from the worker thread ([#20719](https://github.com/netdata/netdata/issues/20719))
- Detect missing ACLK MQTT packet acknowledgents ([#20711](https://github.com/netdata/netdata/issues/20711))
- Remove H2O web server code from Netdata. ([#20713](https://github.com/netdata/netdata/issues/20713))
- Enable services status (windows.plugin) ([#20720](https://github.com/netdata/netdata/issues/20720))
- Docs: add Network-connections to the functions table ([#20721](https://github.com/netdata/netdata/issues/20721))
- Avoid static initialization ([#20722](https://github.com/netdata/netdata/issues/20722))
- Update README.md ([#20724](https://github.com/netdata/netdata/issues/20724))
- Update README.md ([#20723](https://github.com/netdata/netdata/issues/20723))
- Fix SSL certificate detection for Rocky Linux and static curl ([#20695](https://github.com/netdata/netdata/issues/20695))
- Ignore timestamps recording in gzip metadata (for reproducible builds) ([#20714](https://github.com/netdata/netdata/issues/20714))
- SNMP: make units ucum ([#20710](https://github.com/netdata/netdata/issues/20710))
- Reset chart variable after release ([#20727](https://github.com/netdata/netdata/issues/20727))
- Deployment Guides: add and update documentation for deployment strate… ([#20712](https://github.com/netdata/netdata/issues/20712))
- Revert "Deployment Guides: add and update documentation for deployment strate" ([#20728](https://github.com/netdata/netdata/issues/20728))
- Build(deps): bump github.com/bmatcuk/doublestar/v4 from 4.9.0 to 4.9.1 in /src/go ([#20730](https://github.com/netdata/netdata/issues/20730))
- Improve thread shutdown handling for MSSQL plugin ([#20725](https://github.com/netdata/netdata/issues/20725))
- Add additional database checks during shutdown  ([#20731](https://github.com/netdata/netdata/issues/20731))
- Build(deps): bump openssl and curl version in static build ([#20734](https://github.com/netdata/netdata/issues/20734))
- Thread creation code cleanup ([#20732](https://github.com/netdata/netdata/issues/20732))
- Build(deps): bump github.com/docker/docker from 28.3.2+incompatible to 28.3.3+incompatible in /src/go ([#20739](https://github.com/netdata/netdata/issues/20739))
- Fix SNDR thread startup ([#20740](https://github.com/netdata/netdata/issues/20740))
- Revert "Revert "Deployment Guides: add and update documentation for deployment strate"" ([#20729](https://github.com/netdata/netdata/issues/20729))
- Docs: remove customize.md ([#20742](https://github.com/netdata/netdata/issues/20742))
- Chore(go.d/snmp-profiles): use same metric name for cpu usage  ([#20745](https://github.com/netdata/netdata/issues/20745))
- Use netdata mutex cond and lock ([#20737](https://github.com/netdata/netdata/issues/20737))
- Update deployment-with-centralization-points.md ([#20748](https://github.com/netdata/netdata/issues/20748))
- Remove redundant defines ([#20744](https://github.com/netdata/netdata/issues/20744))
- Change remaining pthread_ cases ([#20746](https://github.com/netdata/netdata/issues/20746))
- Split collection (Windows.plugin) ([#20677](https://github.com/netdata/netdata/issues/20677))
- Regenerate integrations docs ([#20749](https://github.com/netdata/netdata/issues/20749))
- Streaming routing documentation ([#20743](https://github.com/netdata/netdata/issues/20743))
- Chore(go.d/snmp): add org to vendor map ([#20750](https://github.com/netdata/netdata/issues/20750))
- Record proxy information when establishing ACLK ([#20747](https://github.com/netdata/netdata/issues/20747))
- Chore(go.d/snmp): remove SNMP prefix from hostname ([#20751](https://github.com/netdata/netdata/issues/20751))
- Build(deps): bump github.com/miekg/dns from 1.1.67 to 1.1.68 in /src/go ([#20753](https://github.com/netdata/netdata/issues/20753))
- Chore(go.d/snmp): add _vnode_type host label and rm duplicates ([#20754](https://github.com/netdata/netdata/issues/20754))
- Chore(go.d/snmp): add _clean_hostname host label ([#20755](https://github.com/netdata/netdata/issues/20755))
- Chore(go.d/snmp): update hostname to not include IP ([#20756](https://github.com/netdata/netdata/issues/20756))
- Improve Disk Usage Measure (Windows.plugin) ([#20752](https://github.com/netdata/netdata/issues/20752))
- Chore(go.d/snmp): update org to vendor mapping ([#20757](https://github.com/netdata/netdata/issues/20757))
- Add Oracle Linux 10 to CI and package builds. ([#20684](https://github.com/netdata/netdata/issues/20684))
- Update welcome-to-netdata.md ([#20760](https://github.com/netdata/netdata/issues/20760))
- Fix(go.d/snmp-profile): fix extends in cradlepoint.yaml ([#20762](https://github.com/netdata/netdata/issues/20762))
- Fix(go.d): validate custom binary path ([#20761](https://github.com/netdata/netdata/issues/20761))
- Chore(go.d): remove patternProperties from config_schema.json ([#20763](https://github.com/netdata/netdata/issues/20763))
- Feat(system-info): add default network interface IP detection ([#20764](https://github.com/netdata/netdata/issues/20764))
- Fix packet timeout handling ([#20766](https://github.com/netdata/netdata/issues/20766))
- Add default iface info to host labels ([#20767](https://github.com/netdata/netdata/issues/20767))
- Chore(go.d/snmp): add _net_default_iface_ip host label ([#20768](https://github.com/netdata/netdata/issues/20768))
- Feat(go.d/snmp): add configurable device down threshold for vnodes ([#20770](https://github.com/netdata/netdata/issues/20770))
- Regenerate integrations docs ([#20771](https://github.com/netdata/netdata/issues/20771))
- Add publish latency to the aclk-state command ([#20769](https://github.com/netdata/netdata/issues/20769))
- Update machine-learning-and-assisted-troubleshooting.md ([#20772](https://github.com/netdata/netdata/issues/20772))
- Aclk improvements ([#20775](https://github.com/netdata/netdata/issues/20775))
- Fix MSSQL Charts ([#20774](https://github.com/netdata/netdata/issues/20774))
- Add Debian 13 to CI and package builds. ([#20776](https://github.com/netdata/netdata/issues/20776))
- Docs(go.d/memcached): add UNIX socket access prerequisite ([#20780](https://github.com/netdata/netdata/issues/20780))
- Regenerate integrations docs ([#20781](https://github.com/netdata/netdata/issues/20781))
- Docs(go.d/mysql): add MariaDB 10.5.9+ SLAVE MONITOR privilege ([#20782](https://github.com/netdata/netdata/issues/20782))
- Regenerate integrations docs ([#20783](https://github.com/netdata/netdata/issues/20783))
- Fix(go.d/ddsnmp): respect metric tag order from profile definition ([#20784](https://github.com/netdata/netdata/issues/20784))
- Feat(go.d/ddsnmp): add metric aggregation support for SNMP profiles ([#20786](https://github.com/netdata/netdata/issues/20786))
- Chore(go.d/ddsnmp): replace Mappings with MultiValue for state-based metrics ([#20787](https://github.com/netdata/netdata/issues/20787))
- Virtual node version adjustment ([#20777](https://github.com/netdata/netdata/issues/20777))
- Build(deps): bump golang.org/x/net from 0.42.0 to 0.43.0 in /src/go ([#20796](https://github.com/netdata/netdata/issues/20796))
- Build(deps): bump github.com/redis/go-redis/v9 from 9.11.0 to 9.12.0 in /src/go ([#20794](https://github.com/netdata/netdata/issues/20794))
- Fix(go.d): resolve potential toctou vulnerability in binary path validation ([#20798](https://github.com/netdata/netdata/issues/20798))
- Ci: handle boolean values in EOL API responses for newly released distros ([#20792](https://github.com/netdata/netdata/issues/20792))
- Fix pathvalidate non unix ([#20801](https://github.com/netdata/netdata/issues/20801))
- Add OpenTelemetry plugin implementation. ([#20765](https://github.com/netdata/netdata/issues/20765))
- Fix ping latency calculation ([#20800](https://github.com/netdata/netdata/issues/20800))
- Feat(aclk): Add detailed pulse metrics for ACLK telemetry ([#20802](https://github.com/netdata/netdata/issues/20802))
- Feat(go.d/ddsnmp): sysobjectid-based metadata override support for SNMP profiles ([#20803](https://github.com/netdata/netdata/issues/20803))
- Build(deps): bump github.com/redis/go-redis/v9 from 9.12.0 to 9.12.1 in /src/go ([#20804](https://github.com/netdata/netdata/issues/20804))
- Feat(go.d/snmp): add SNMP sysObjectID mappings for device identification ([#20805](https://github.com/netdata/netdata/issues/20805))
- Improve(go.d/zfspool): add Ubuntu zpool binary path to config ([#20806](https://github.com/netdata/netdata/issues/20806))
- Clear packet id when processed from PUBACK ([#20808](https://github.com/netdata/netdata/issues/20808))
- Monitor memory reclamation and buffer compact ([#20810](https://github.com/netdata/netdata/issues/20810))
- Add more MSSQL metrics (windows.plugin) ([#20788](https://github.com/netdata/netdata/issues/20788))
- Improve(go.d/snmp): optimize Check() to avoid heavy collection ([#20813](https://github.com/netdata/netdata/issues/20813))
- Fix(go.d/ddsnmp): fix match_pattern regex behavior in metadata and metric collection ([#20814](https://github.com/netdata/netdata/issues/20814))
- Render latency chart if ACLK online ([#20811](https://github.com/netdata/netdata/issues/20811))
- Fix Charts (windows.plugin) ([#20815](https://github.com/netdata/netdata/issues/20815))
- Fix(go.d/ddsnmp): correct profile matching, metadata precedence, and OID handling ([#20819](https://github.com/netdata/netdata/issues/20819))
- Add ACLK buffer usage metrics ([#20820](https://github.com/netdata/netdata/issues/20820))
- Build(deps): bump k8s.io/client-go from 0.33.3 to 0.33.4 in /src/go ([#20826](https://github.com/netdata/netdata/issues/20826))
- Refactor(go.d): move nd directories to dedicated pluginconfig package ([#20827](https://github.com/netdata/netdata/issues/20827))
- Feat(go.d/snmp): add YAML overrides for sysobjectids mapping ([#20828](https://github.com/netdata/netdata/issues/20828))
- Improve(go.d/snmp): add more models to meta_overrides.yaml ([#20830](https://github.com/netdata/netdata/issues/20830))
- Chore(go.d/snmp): merge sysObjectIDs.json into meta_overrides.yaml ([#20831](https://github.com/netdata/netdata/issues/20831))
- Chore(go.d/snmp): update category of h3c devices in meta_overrides.yaml ([#20835](https://github.com/netdata/netdata/issues/20835))
- Switch to a Debian 13 base for our Docker images. ([#20816](https://github.com/netdata/netdata/issues/20816))
- Mqtt adjust buffer size ([#20834](https://github.com/netdata/netdata/issues/20834))
- Chore(go.d/snmp): load & merge per-vendor SNMP metadata overrides ([#20837](https://github.com/netdata/netdata/issues/20837))
- Use atomics for mqtt statistics ([#20836](https://github.com/netdata/netdata/issues/20836))
- Improve ACLK message parsing ([#20838](https://github.com/netdata/netdata/issues/20838))
- Improve(go.d/snmp): update netgear/dlink category in snmp meta ([#20839](https://github.com/netdata/netdata/issues/20839))
- Revert "Switch to a Debian 13 base for our Docker images." ([#20842](https://github.com/netdata/netdata/issues/20842))
- Improve(go.d/snmp): update h3c categories in snmp meta ([#20844](https://github.com/netdata/netdata/issues/20844))
- Store virtual host labels ([#20841](https://github.com/netdata/netdata/issues/20841))
- Build(deps): bump actions/checkout from 4 to 5 ([#20833](https://github.com/netdata/netdata/issues/20833))
- Do not set virtual host flag on agent restart ([#20845](https://github.com/netdata/netdata/issues/20845))
- Ci: fix docker-test.sh handling to fail on error ([#20847](https://github.com/netdata/netdata/issues/20847))
- Build(deps): bump github.com/vmware/govmomi from 0.51.0 to 0.52.0 in /src/go ([#20852](https://github.com/netdata/netdata/issues/20852))
- Ci: bump GoTestTools/gotestfmt-action version ([#20850](https://github.com/netdata/netdata/issues/20850))
- Revert "Revert "Switch to a Debian 13 base for our Docker images."" ([#20848](https://github.com/netdata/netdata/issues/20848))
- Improve(go.d/snmp): update snmp meta copilot ([#20861](https://github.com/netdata/netdata/issues/20861))
- Add cargo lock file. ([#20855](https://github.com/netdata/netdata/issues/20855))
- Add build-time check to reject known bad compiler flags. ([#20851](https://github.com/netdata/netdata/issues/20851))
- Chore(go.d/snmp): more vendor-scoped meta yaml files ([#20863](https://github.com/netdata/netdata/issues/20863))
- Kickstarter Fix for DNF5 System ([#20823](https://github.com/netdata/netdata/issues/20823))
- Windows Plugin (Sensors) ([#20840](https://github.com/netdata/netdata/issues/20840))
- Update documentation (Windows.plugin) ([#20864](https://github.com/netdata/netdata/issues/20864))
- Update documentation ([#20865](https://github.com/netdata/netdata/issues/20865))
- Regenerate integrations docs ([#20818](https://github.com/netdata/netdata/issues/20818))
- Improve(go.d/snmp): add more entries in juniper metadata file ([#20867](https://github.com/netdata/netdata/issues/20867))
- Rename default port for the OpenTelemetry Collector ([#20868](https://github.com/netdata/netdata/issues/20868))
- Fix Table field comparison in SNMP collector table tests ([#20871](https://github.com/netdata/netdata/issues/20871))
- Fix(go.d): create vnode internal data_collection_status charts in the main context ([#20872](https://github.com/netdata/netdata/issues/20872))
- Build(deps): bump github.com/coreos/go-systemd/v22 from 22.5.0 to 22.6.0 in /src/go ([#20874](https://github.com/netdata/netdata/issues/20874))
- Chore(go.d/ddsnmp): use plugincofng for loading profiles ([#20878](https://github.com/netdata/netdata/issues/20878))
- Improve(go.d/snmp): add zyxel snmp meta file ([#20879](https://github.com/netdata/netdata/issues/20879))
- Fix(go.d): fix goroutine leak and panic risk in Docker exec ([#20881](https://github.com/netdata/netdata/issues/20881))
- Improve(go.d/snmp): update tplink snmp meta ([#20882](https://github.com/netdata/netdata/issues/20882))
- Improve(go.d/snmp): add MikroTik type and model detection ([#20883](https://github.com/netdata/netdata/issues/20883))
- Fix(go.d/snmp): handle invalid SFP temperature readings for empty slots ([#20884](https://github.com/netdata/netdata/issues/20884))
- Build(deps): bump github.com/stretchr/testify from 1.10.0 to 1.11.0 in /src/go ([#20886](https://github.com/netdata/netdata/issues/20886))
- Improve(go.d/snmp): add mikrotik mtxrHlProcessorTemperature ([#20885](https://github.com/netdata/netdata/issues/20885))
- Updated logging documentation and added natural siem integration ([#20829](https://github.com/netdata/netdata/issues/20829))
- Troubleshooting: add troubleshoot and custom investigations docs ([#20759](https://github.com/netdata/netdata/issues/20759))
- Windows: round sleep to clock resolution to prevent sub-ms early-wake logs ([#20887](https://github.com/netdata/netdata/issues/20887))
- Improve(go.d/snmp): update Fortinet meta ([#20888](https://github.com/netdata/netdata/issues/20888))
- Improve(go.d/snmp): update Allied Telesis meta ([#20889](https://github.com/netdata/netdata/issues/20889))
- Improve exporting documentation clarity and structure ([#20890](https://github.com/netdata/netdata/issues/20890))
- Move exporting integrations to their own folder ([#20894](https://github.com/netdata/netdata/issues/20894))
- Improve(cgroups): skip KubeVirt helper containers in virt-launcher pods ([#20896](https://github.com/netdata/netdata/issues/20896))
- Improve snmp ubiquiti unifi ap model ([#20895](https://github.com/netdata/netdata/issues/20895))
- Fixing Supported Linux Platforms and Versions ([#20893](https://github.com/netdata/netdata/issues/20893))
- Refactor(go.d/snmp): recreate client on SNMPv3 "packet is not authentic" errors ([#20897](https://github.com/netdata/netdata/issues/20897))
- Improve(go.d/snmp): make snmp v3 auth and priv keys hidden in UI ([#20898](https://github.com/netdata/netdata/issues/20898))
- Update demo link formatting in documentation ([#20899](https://github.com/netdata/netdata/issues/20899))
- Improved alerting docs ([#20891](https://github.com/netdata/netdata/issues/20891))
- Fix processes function: Add PPID grouping and fix WOps typo ([#20902](https://github.com/netdata/netdata/issues/20902))
- Build(deps): bump k8s.io/client-go from 0.33.4 to 0.34.0 in /src/go ([#20908](https://github.com/netdata/netdata/issues/20908))
- Build(deps): bump github.com/stretchr/testify from 1.11.0 to 1.11.1 in /src/go ([#20906](https://github.com/netdata/netdata/issues/20906))
- Update link for opt-out section ([#20909](https://github.com/netdata/netdata/issues/20909))
- Update view-plan-and-billing.md ([#20910](https://github.com/netdata/netdata/issues/20910))
- Fix(go.d): try rel path before checking well-known path for user and stock dirs ([#20912](https://github.com/netdata/netdata/issues/20912))
- Chore(go.d): add build-time configuration directory paths ([#20913](https://github.com/netdata/netdata/issues/20913))
- SIGNL4 Alert Notification ([#20911](https://github.com/netdata/netdata/issues/20911))
- Fix(netdata-updater): resolve "run: command not found" error in offline install ([#20915](https://github.com/netdata/netdata/issues/20915))
- Regenerate integrations docs ([#20916](https://github.com/netdata/netdata/issues/20916))
- Chore(go.d): remove unused resolve hostname functionality ([#20922](https://github.com/netdata/netdata/issues/20922))
- Docs(go.d/nginx): improve prerequisites for NGINX collector ([#20924](https://github.com/netdata/netdata/issues/20924))
- Regenerate integrations docs ([#20925](https://github.com/netdata/netdata/issues/20925))
- Fix(go.d/weblog): remove path pattern validation in dyncfg ([#20923](https://github.com/netdata/netdata/issues/20923))
- Build(deps): bump github.com/prometheus/common from 0.65.0 to 0.66.1 in /src/go ([#20930](https://github.com/netdata/netdata/issues/20930))
- Build(deps): bump github.com/docker/docker from 28.3.3+incompatible to 28.4.0+incompatible in /src/go ([#20929](https://github.com/netdata/netdata/issues/20929))
- Build(deps): bump github.com/redis/go-redis/v9 from 9.12.1 to 9.13.0 in /src/go ([#20928](https://github.com/netdata/netdata/issues/20928))
- Build(deps): bump actions/labeler from 5 to 6 ([#20935](https://github.com/netdata/netdata/issues/20935))
- Build(deps): bump actions/setup-go from 5 to 6 ([#20934](https://github.com/netdata/netdata/issues/20934))
- Build(deps): bump actions/setup-python from 5 to 6 ([#20936](https://github.com/netdata/netdata/issues/20936))
- Build(deps): bump golang.org/x/text from 0.28.0 to 0.29.0 in /src/go ([#20937](https://github.com/netdata/netdata/issues/20937))
- Add documentation for account deletion process ([#20927](https://github.com/netdata/netdata/issues/20927))
- MCP WEB CHAT: add ollama, deepseek support ([#20741](https://github.com/netdata/netdata/issues/20741))
- Update account.md ([#20940](https://github.com/netdata/netdata/issues/20940))
- Update sqlite to version 3.50.4 ([#20791](https://github.com/netdata/netdata/issues/20791))
- Chore(go.d/pkgs/logs): validation fixes, resource safety, and cleanup ([#20931](https://github.com/netdata/netdata/issues/20931))
- Update libbpf to 1.6.2 ([#20875](https://github.com/netdata/netdata/issues/20875))
- Migrate the map from Learn repo to netdata/netdata ([#20942](https://github.com/netdata/netdata/issues/20942))
- Add map.csv to triggers for Docs ingest workflow ([#20945](https://github.com/netdata/netdata/issues/20945))
- Update account.md ([#20946](https://github.com/netdata/netdata/issues/20946))
- Change MSSQL Cleanup and Queries (windows.plugin) ([#20892](https://github.com/netdata/netdata/issues/20892))
- Add Network Labels to Windows. ([#20938](https://github.com/netdata/netdata/issues/20938))
- Replace uv mutex and condition variables with netdata equivalents ([#20941](https://github.com/netdata/netdata/issues/20941))
- BSD Compilation ([#20944](https://github.com/netdata/netdata/issues/20944))
- Fix use after free in metric registry ([#20947](https://github.com/netdata/netdata/issues/20947))
- Build(deps): bump golang.org/x/net from 0.43.0 to 0.44.0 in /src/go ([#20949](https://github.com/netdata/netdata/issues/20949))
- Build(deps): bump github.com/jackc/pgx/v5 from 5.7.5 to 5.7.6 in /src/go ([#20950](https://github.com/netdata/netdata/issues/20950))
- Move whole category and fix leftovers ([#20951](https://github.com/netdata/netdata/issues/20951))
- Fix(health/rocketchat): add missing "Content-Type: application/json" header ([#20954](https://github.com/netdata/netdata/issues/20954))
- Improve(go.d/snmp): add transform for Host-Resources-MIB storage metrics ([#20957](https://github.com/netdata/netdata/issues/20957))
- Chore(go.d/snmp): remove hrStorageTable from mikrotik-router.yaml ([#20958](https://github.com/netdata/netdata/issues/20958))
- Improve(go.d/snmp): add net-snmp.yaml profile ([#20959](https://github.com/netdata/netdata/issues/20959))
- Ensure memory ordering when updating partition list and the bitmap ([#20956](https://github.com/netdata/netdata/issues/20956))
- Fix FreeBSD (Part II) ([#20955](https://github.com/netdata/netdata/issues/20955))
- Chore(go.d/sd/snmp): remove skipping servers in snmp discovery ([#20960](https://github.com/netdata/netdata/issues/20960))
- Improve(go.d/ddsnmp): add composite virtual metrics ([#20962](https://github.com/netdata/netdata/issues/20962))
- Improve(go.d/ddsnmp): add composite metrics for CPU & Load Average in std-ucd-mib ([#20964](https://github.com/netdata/netdata/issues/20964))
- Build(deps): bump k8s.io/client-go from 0.34.0 to 0.34.1 in /src/go ([#20968](https://github.com/netdata/netdata/issues/20968))
- Build(deps): bump github.com/redis/go-redis/v9 from 9.13.0 to 9.14.0 in /src/go ([#20966](https://github.com/netdata/netdata/issues/20966))
- Improve(go.d/ddsnmp): add group_by for virtual metrics ([#20970](https://github.com/netdata/netdata/issues/20970))
- Improve(go.d/ddsnmp): add per_row mode for virtual metrics ([#20971](https://github.com/netdata/netdata/issues/20971))
- Docs(go.d/snmp): remove legacy "custom oid" cfg examples ([#20972](https://github.com/netdata/netdata/issues/20972))
- Regenerate integrations docs ([#20973](https://github.com/netdata/netdata/issues/20973))
- Docs(go.d): add UI configuration instructions and restructure Configuration section ([#20975](https://github.com/netdata/netdata/issues/20975))
- Regenerate integrations docs ([#20976](https://github.com/netdata/netdata/issues/20976))
- Docs: restructure Setup, update SNMP prerequisites, and fix SNMP options ([#20977](https://github.com/netdata/netdata/issues/20977))
- Regenerate integrations docs ([#20978](https://github.com/netdata/netdata/issues/20978))
- Perf(go.d/ddsnmp): cache group key per aggregator per metric ([#20979](https://github.com/netdata/netdata/issues/20979))
- Docs: improve config options table with grouped section headers ([#20980](https://github.com/netdata/netdata/issues/20980))
- Regenerate integrations docs ([#20982](https://github.com/netdata/netdata/issues/20982))
- Chore: add `-c` option to gen docs for a single collector ([#20981](https://github.com/netdata/netdata/issues/20981))
- Enhance README with publishing instructions for docs ([#20952](https://github.com/netdata/netdata/issues/20952))
- Document accuracy implications of sampling algorithm ([#20991](https://github.com/netdata/netdata/issues/20991))
- Fix(macos.plugin): drop SyncookiesFailed metric on macOS 16+ ([#20994](https://github.com/netdata/netdata/issues/20994))
- Fix(go.d): skip writing HOST line for vnodes with no collected metrics ([#20995](https://github.com/netdata/netdata/issues/20995))
- Ci: rm macos 13, add macos 26 ([#20993](https://github.com/netdata/netdata/issues/20993))
- Chore(go.d): skip HOST for vnodes during Cleanup with stale label ([#20996](https://github.com/netdata/netdata/issues/20996))
- Update welcome-to-netdata.md ([#20986](https://github.com/netdata/netdata/issues/20986))
- Docs: add "per cpu core utilization" option to proc/stat meta ([#20997](https://github.com/netdata/netdata/issues/20997))
- Regenerate integrations docs ([#20998](https://github.com/netdata/netdata/issues/20998))
- Docs: Use fallback title "Config options" when folding title is empty ([#20999](https://github.com/netdata/netdata/issues/20999))
- Regenerate integrations docs ([#21000](https://github.com/netdata/netdata/issues/21000))
- Docs: add "cpu idle state" procstat config option ([#21001](https://github.com/netdata/netdata/issues/21001))
- Regenerate integrations docs ([#21002](https://github.com/netdata/netdata/issues/21002))
- Docs: add grouped headers to config options ([#20987](https://github.com/netdata/netdata/issues/20987))
- Regenerate integrations docs ([#21007](https://github.com/netdata/netdata/issues/21007))
- Deps(mcp/bridge/stdio-golang): switch to github.com/coder/websocket ([#21006](https://github.com/netdata/netdata/issues/21006))
- Fix(go.d): correct buf truncate in processMetrics ([#21008](https://github.com/netdata/netdata/issues/21008))
- Update best-practices.md ([#20984](https://github.com/netdata/netdata/issues/20984))
- Chore(go.d): use forked gosnmp to fix SNMPv3 REPORT handling for UniFi APs ([#21009](https://github.com/netdata/netdata/issues/21009))
- Chore: refactor get_doc_integrations.py to use main() and improve structure ([#20983](https://github.com/netdata/netdata/issues/20983))
- Chore(go.d/snmp): remove recreating client on "packet is not authentic" ([#21010](https://github.com/netdata/netdata/issues/21010))
- Handle virtual host disconnection ([#20860](https://github.com/netdata/netdata/issues/20860))
- Rework dbengine async wakeup on windows ([#21003](https://github.com/netdata/netdata/issues/21003))
- Fix Mermaid diagrams across multiple files ([#21011](https://github.com/netdata/netdata/issues/21011))
- Improve(go.d/ddsnmp): add alternatives support for virtual metrics ([#21013](https://github.com/netdata/netdata/issues/21013))
- Chore(go.d): don’t log "no such file or directory" for user SNMP profiles ([#21014](https://github.com/netdata/netdata/issues/21014))
- Docs: Update ToC - add realtime-monitoring and reorganize functions ([#21012](https://github.com/netdata/netdata/issues/21012))
- Fix MDX compilation errors in realtime-monitoring.md ([#21015](https://github.com/netdata/netdata/issues/21015))
- Fix MDX parsing errors in realtime-monitoring.md ([#21016](https://github.com/netdata/netdata/issues/21016))
- Docs: Add comprehensive scalability architecture documentation ([#21018](https://github.com/netdata/netdata/issues/21018))
- Docs: Rename 'Top Monitoring' to 'Top Consumers' in Functions documentation ([#21019](https://github.com/netdata/netdata/issues/21019))
- Docs: Remove parentheses from Top Consumers title to fix URL issues ([#21020](https://github.com/netdata/netdata/issues/21020))
- Fix duplicate ToC entries for Top Consumers ([#21021](https://github.com/netdata/netdata/issues/21021))
- Improve(go.d/ddsnmp): refactor IF-MIB profile with unified virtual metrics and 64-bit preference ([#21017](https://github.com/netdata/netdata/issues/21017))
- Chore(go.d/ddsnmp): update vmBuildGroupKey in per-row mode without group_by ([#21022](https://github.com/netdata/netdata/issues/21022))
- Improve(go.d/snmp): add `manual_profiles` option ([#21023](https://github.com/netdata/netdata/issues/21023))
- Build(deps): bump openssl and curl version in static build ([#21024](https://github.com/netdata/netdata/issues/21024))
- Build(deps): update go toolchain to v1.25.1 ([#21025](https://github.com/netdata/netdata/issues/21025))
- Update README.md ([#21027](https://github.com/netdata/netdata/issues/21027))
- Chore(go.d/snmp): remove/disable legacy components ([#21026](https://github.com/netdata/netdata/issues/21026))
- Regenerate integrations docs ([#21028](https://github.com/netdata/netdata/issues/21028))
- Chore(docs): rename REST API sidebar to Netdata APIs ([#21029](https://github.com/netdata/netdata/issues/21029))
- Revert "chore(docs): rename REST API sidebar to Netdata APIs" ([#21031](https://github.com/netdata/netdata/issues/21031))
- Update scalability.md ([#21030](https://github.com/netdata/netdata/issues/21030))
- Ml: implement fixed time-based training windows ([#20638](https://github.com/netdata/netdata/issues/20638))
- Docs: fix mdx parsing scalability.md ([#21032](https://github.com/netdata/netdata/issues/21032))
- Fix(docs): update mermaid diagrams leftovers plus syntax issues ([#21034](https://github.com/netdata/netdata/issues/21034))
- Improve(go.d/ddsnmp): switch profile matching to `selector` ([#21039](https://github.com/netdata/netdata/issues/21039))
- Chore(go.d/ddsnmp): Improve profile sorting by match specificity ([#21042](https://github.com/netdata/netdata/issues/21042))
- Context loading priority to vnodes ([#21040](https://github.com/netdata/netdata/issues/21040))
- Add documentation on using custom CA certificates to Learn ([#21041](https://github.com/netdata/netdata/issues/21041))
- Revert "ml: implement fixed time-based training windows ([#20638](https://github.com/netdata/netdata/issues/20638))" ([#21045](https://github.com/netdata/netdata/issues/21045))
- Properly integrate Rust code checks in CI. ([#20862](https://github.com/netdata/netdata/issues/20862))

## [2.6.0] - 2025-07-17

### Merged Pull Requests:

- Revert "Revert "fix(go.d/couchdb): correct db size charts unit"" ([#20235](https://github.com/netdata/netdata/issues/20235))
- Make all threads joinable and join on agent shutdown ([#20228](https://github.com/netdata/netdata/issues/20228))
- Let the user override the default stack size ([#20236](https://github.com/netdata/netdata/issues/20236))
- Fix build issue on old distros ([#20243](https://github.com/netdata/netdata/issues/20243))
- Session claim id in docker ([#20240](https://github.com/netdata/netdata/issues/20240))
- Fix(go.d/sd/snmp): fix snmpv3 credentials ([#20247](https://github.com/netdata/netdata/issues/20247))
- Fix(go.d/snmp): use ifDescr for interface name if ifName is empty ([#20248](https://github.com/netdata/netdata/issues/20248))
- Fix(go.d/snmp): use 32bit counters if 64 aren't available ([#20249](https://github.com/netdata/netdata/issues/20249))
- Update Netdata README ([#20251](https://github.com/netdata/netdata/issues/20251))
- Docs: fix license link and remove GH alerts syntax from FAQ ([#20252](https://github.com/netdata/netdata/issues/20252))
- Fix obsolete chart cleanup to properly handle vnodes ([#20254](https://github.com/netdata/netdata/issues/20254))
- Chore(go.d/snmp): make enable_profiles configurable (needed for dev) ([#20255](https://github.com/netdata/netdata/issues/20255))
- Fix(go.d/sd/snmp): fix snmnpv3 again ([#20256](https://github.com/netdata/netdata/issues/20256))
- Clearify the path of `plugins.d/go.d.plugin` in docs ([#20258](https://github.com/netdata/netdata/issues/20258))
- Update documentation for native DEB/RPM packages ([#20257](https://github.com/netdata/netdata/issues/20257))
- Docs: reword go.d Troubleshooting section for clarity ([#20259](https://github.com/netdata/netdata/issues/20259))
- Fix(go.d/mysql): fix MariaDB User CPU Time ([#20262](https://github.com/netdata/netdata/issues/20262))
- Minor fixes ([#20263](https://github.com/netdata/netdata/issues/20263))
- Update Netdata README with improved structure ([#20265](https://github.com/netdata/netdata/issues/20265))
- Schedule journal file indexing after database file rotation ([#20264](https://github.com/netdata/netdata/issues/20264))
- Build(deps): bump golang.org/x/net from 0.39.0 to 0.40.0 in /src/go ([#20270](https://github.com/netdata/netdata/issues/20270))
- Build(deps): bump github.com/miekg/dns from 1.1.65 to 1.1.66 in /src/go ([#20268](https://github.com/netdata/netdata/issues/20268))
- SNMP first cisco yaml file pass ([#20246](https://github.com/netdata/netdata/issues/20246))
- Chore(go.d/snmp): small cleanup snmp profiles code ([#20274](https://github.com/netdata/netdata/issues/20274))
- Switch to poll from epoll ([#20273](https://github.com/netdata/netdata/issues/20273))
- Switch to uv threads ([#20250](https://github.com/netdata/netdata/issues/20250))
- Improve MSSQL (Part III) ([#20230](https://github.com/netdata/netdata/issues/20230))
- Docs: update mssql meta ([#20278](https://github.com/netdata/netdata/issues/20278))
- Regenerate integrations docs ([#20279](https://github.com/netdata/netdata/issues/20279))
- Improved StatsD documentation ([#20282](https://github.com/netdata/netdata/issues/20282))
- New Windows Metrics (CPU and Memory) ([#20277](https://github.com/netdata/netdata/issues/20277))
- Regenerate integrations docs ([#20284](https://github.com/netdata/netdata/issues/20284))
- Model Context Protocol Server (MCP) for Netdata ([#20244](https://github.com/netdata/netdata/issues/20244))
- Add "unix://" scheme to DOCKER_HOST in run.sh ([#20286](https://github.com/netdata/netdata/issues/20286))
- Improve agent shutdown ([#20280](https://github.com/netdata/netdata/issues/20280))
- Comment metric tags that could be metrics ([#20272](https://github.com/netdata/netdata/issues/20272))
- Fix(go.d): sanitize vnode labels before creating vnode ([#20293](https://github.com/netdata/netdata/issues/20293))
- Build(deps): bump k8s.io/client-go from 0.33.0 to 0.33.1 in /src/go ([#20295](https://github.com/netdata/netdata/issues/20295))
- Build(deps): bump github.com/prometheus/common from 0.63.0 to 0.64.0 in /src/go ([#20296](https://github.com/netdata/netdata/issues/20296))
- Minor code adjustments ([#20290](https://github.com/netdata/netdata/issues/20290))
- Fix when docker socket group id points to an existing group in container ([#20288](https://github.com/netdata/netdata/issues/20288))
- Build(deps): bump github.com/jackc/pgx/v5 from 5.7.4 to 5.7.5 in /src/go ([#20299](https://github.com/netdata/netdata/issues/20299))
- Updating SOC2 compliance status ([#20300](https://github.com/netdata/netdata/issues/20300))
- Docs: Observability centralization points ([#20292](https://github.com/netdata/netdata/issues/20292))
- Fix(go.d/snmp): replace newline control chars with spaces in system info ([#20301](https://github.com/netdata/netdata/issues/20301))
- Docs: fix `<br>` in streaming ([#20302](https://github.com/netdata/netdata/issues/20302))
- Fix heap-use-after-free in plugins.d inflight functions ([#20304](https://github.com/netdata/netdata/issues/20304))
- Fix use after free of streaming current parent ([#20305](https://github.com/netdata/netdata/issues/20305))
- Improve metasync shutdown ([#20303](https://github.com/netdata/netdata/issues/20303))
- Improve user transition log messages ([#20308](https://github.com/netdata/netdata/issues/20308))
- Docs: fix tip in streaming readme ([#20310](https://github.com/netdata/netdata/issues/20310))
- Plugins dyncfg is always on localhost ([#20312](https://github.com/netdata/netdata/issues/20312))
- Netdata ai ([#20309](https://github.com/netdata/netdata/issues/20309))
- Docs: fix netdata-assistant.md ([#20314](https://github.com/netdata/netdata/issues/20314))
- IIS W3SCV W3MP Metrics (windows.plugin) ([#20245](https://github.com/netdata/netdata/issues/20245))
- Regenerate integrations docs ([#20315](https://github.com/netdata/netdata/issues/20315))
- Reduce memory allocations in event loops ([#20306](https://github.com/netdata/netdata/issues/20306))
- Cisco yaml pass ([#20291](https://github.com/netdata/netdata/issues/20291))
- Ci: ignore changes in src/go/otel-collector/release-config.yaml.in ([#20222](https://github.com/netdata/netdata/issues/20222))
- Build(deps): update otel dependencies version ([#20319](https://github.com/netdata/netdata/issues/20319))
- SNMP: _generic-if.yaml pass ([#20317](https://github.com/netdata/netdata/issues/20317))
- Update libbpf ([#20316](https://github.com/netdata/netdata/issues/20316))
- Build(deps): bump github.com/lmittmann/tint from 1.0.7 to 1.1.0 in /src/go ([#20320](https://github.com/netdata/netdata/issues/20320))
- _generic-tcp.yaml pass ([#20321](https://github.com/netdata/netdata/issues/20321))
- Dont init dyncfg for vnode ([#20324](https://github.com/netdata/netdata/issues/20324))
- Cancel health initialization if shutdown has been requested ([#20318](https://github.com/netdata/netdata/issues/20318))
- SOC 2 cloud doc update ([#20325](https://github.com/netdata/netdata/issues/20325))
- Generic-udp.yaml pass ([#20326](https://github.com/netdata/netdata/issues/20326))
- Generic-bgp4.yaml ([#20328](https://github.com/netdata/netdata/issues/20328))
- Generic-ospf.yaml pass ([#20327](https://github.com/netdata/netdata/issues/20327))
- Update alerting and notification documentation Agent ([#20329](https://github.com/netdata/netdata/issues/20329))
- Update SCIM documentation ([#20330](https://github.com/netdata/netdata/issues/20330))
- Regenerate integrations docs ([#20332](https://github.com/netdata/netdata/issues/20332))
- Code cleanup and improvements ([#20323](https://github.com/netdata/netdata/issues/20323))
- Alerts cloud ([#20334](https://github.com/netdata/netdata/issues/20334))
- _generic-ip.yaml ([#20331](https://github.com/netdata/netdata/issues/20331))
- Build(deps): bump github.com/vmware/govmomi from 0.50.0 to 0.51.0 in /src/go ([#20341](https://github.com/netdata/netdata/issues/20341))
- SNMP: _generic-lldp.yaml ([#20342](https://github.com/netdata/netdata/issues/20342))
- Switch back to epoll from poll ([#20337](https://github.com/netdata/netdata/issues/20337))
- Fix(go.d/dyncfg): fix duplicate potential "name" in userconfig action ([#20346](https://github.com/netdata/netdata/issues/20346))
- Improvement(go.d/sd): better prometheus exporters detection ([#20348](https://github.com/netdata/netdata/issues/20348))
- SNMP: _generic-rtp.yaml ([#20343](https://github.com/netdata/netdata/issues/20343))
- SNMP: _generic-sip.yaml ([#20344](https://github.com/netdata/netdata/issues/20344))
- SNMP: _generic-ucd.yaml ([#20349](https://github.com/netdata/netdata/issues/20349))
- Build(deps): update otel dependencies version ([#20352](https://github.com/netdata/netdata/issues/20352))
- Add installing flex to install-required-packages.sh ([#20322](https://github.com/netdata/netdata/issues/20322))
- Feat(go.d/dyncfg): add autodetect_retry to dyncfg jobs ([#20357](https://github.com/netdata/netdata/issues/20357))
- Chore(go.d): fix some golangcilint warning ([#20360](https://github.com/netdata/netdata/issues/20360))
- Windows updated ([#20358](https://github.com/netdata/netdata/issues/20358))
- Updated configuration reference ([#20347](https://github.com/netdata/netdata/issues/20347))
- _cisco-voice.yaml ([#20361](https://github.com/netdata/netdata/issues/20361))
- SNMP: _generic-ups.yaml ([#20351](https://github.com/netdata/netdata/issues/20351))
- SNMP: _cisco-wlc.yaml ([#20364](https://github.com/netdata/netdata/issues/20364))
- Chore(otel.plugin): fix building ([#20368](https://github.com/netdata/netdata/issues/20368))
- Split systemd-journal plugin and add Rust-based journal file reader ([#20345](https://github.com/netdata/netdata/issues/20345))
- SNMP: _cisco-ipsec-flow-monitor.yaml ([#20353](https://github.com/netdata/netdata/issues/20353))
- SNMP: _fortinet-fortigate-vpn-tunnel.yaml ([#20367](https://github.com/netdata/netdata/issues/20367))
- SNMP: _fortinet-fortigate-cpu-memory.yaml ([#20366](https://github.com/netdata/netdata/issues/20366))
- Build(deps): bump github.com/lmittmann/tint from 1.1.0 to 1.1.1 in /src/go ([#20370](https://github.com/netdata/netdata/issues/20370))
- SNMP: fortinet-appliance.yaml ([#20369](https://github.com/netdata/netdata/issues/20369))
- Build(deps): bump github.com/redis/go-redis/v9 from 9.8.0 to 9.9.0 in /src/go ([#20372](https://github.com/netdata/netdata/issues/20372))
- Build(deps): bump github.com/docker/docker from 28.1.1+incompatible to 28.2.1+incompatible in /src/go ([#20371](https://github.com/netdata/netdata/issues/20371))
- Fix(go.d/oracledb): correct tablespace usage calculation for all types ([#20373](https://github.com/netdata/netdata/issues/20373))
- Regenerate integrations docs ([#20375](https://github.com/netdata/netdata/issues/20375))
- SNMP: fortinet-fortigate.yaml and remove un-needed profile ([#20374](https://github.com/netdata/netdata/issues/20374))
- Chore(otel.plugin): add more receivers/exporter ([#20376](https://github.com/netdata/netdata/issues/20376))
- Test(go.d/oracledb): fix test ([#20378](https://github.com/netdata/netdata/issues/20378))
- SNMP: fortinet-fortiswitch.yaml ([#20377](https://github.com/netdata/netdata/issues/20377))
- Improve datafile rotation and indexing ([#20354](https://github.com/netdata/netdata/issues/20354))
- SNMP: _aruba-switch-cpu-memory.yaml ([#20381](https://github.com/netdata/netdata/issues/20381))
- Update documentation ([#20380](https://github.com/netdata/netdata/issues/20380))
- SNMP: aruba-switch.yaml ([#20385](https://github.com/netdata/netdata/issues/20385))
- SNMP: aruba-cx-switch.yaml ([#20383](https://github.com/netdata/netdata/issues/20383))
- SNMP: aruba-clearpass.yaml ([#20382](https://github.com/netdata/netdata/issues/20382))
- Apps.plugin documentation and grouping matches improvements ([#20386](https://github.com/netdata/netdata/issues/20386))
- Build(deps): bump github.com/docker/docker from 28.2.1+incompatible to 28.2.2+incompatible in /src/go ([#20387](https://github.com/netdata/netdata/issues/20387))
- Model Context Protocol (MCP) Part 2 ([#20287](https://github.com/netdata/netdata/issues/20287))
- Improvement(go.d/httpcheck): add resp validation debug logging ([#20392](https://github.com/netdata/netdata/issues/20392))
- Improve DynCfg documentation ([#20384](https://github.com/netdata/netdata/issues/20384))
- Feat(go.d): allow to debug a specific job ([#20394](https://github.com/netdata/netdata/issues/20394))
- Maintenance: update restart, backup, uninstall, and restore docs ([#20398](https://github.com/netdata/netdata/issues/20398))
- Improve retention calculation after datafile deletion ([#20350](https://github.com/netdata/netdata/issues/20350))
- Rename nd-mcp on windows ([#20404](https://github.com/netdata/netdata/issues/20404))
- SNMP: _juniper-firewall.yaml ([#20407](https://github.com/netdata/netdata/issues/20407))
- SNMP: _juniper-userfirewall.yaml ([#20409](https://github.com/netdata/netdata/issues/20409))
- SNMP: _juniper-scu.yaml ([#20408](https://github.com/netdata/netdata/issues/20408))
- SNMP: _juniper-dcu.yaml ([#20406](https://github.com/netdata/netdata/issues/20406))
- Improvement(go.d): add ddsnmp profile collector (scalar only) ([#20415](https://github.com/netdata/netdata/issues/20415))
- Fix context updates ([#20416](https://github.com/netdata/netdata/issues/20416))
- SNMP: apc_ups.yaml ([#20419](https://github.com/netdata/netdata/issues/20419))
- Chore(go.d/ddsnmp): correctly handle all mapping types ([#20420](https://github.com/netdata/netdata/issues/20420))
- Improve metrics centralization points documentation ([#20412](https://github.com/netdata/netdata/issues/20412))
- Update_installer: Update remove instruction ([#20418](https://github.com/netdata/netdata/issues/20418))
- Docs: remove sizing-netdata-parents.md ([#20421](https://github.com/netdata/netdata/issues/20421))
- ML: Add documentation for Netdata Insights ([#20425](https://github.com/netdata/netdata/issues/20425))
- Feat(go.d/snmp): enable profile scalar metrics collection ([#20426](https://github.com/netdata/netdata/issues/20426))
- Docs(go.d): add example how to debug a specific job ([#20399](https://github.com/netdata/netdata/issues/20399))
- Chore(go.d/ddsnmp): lazy ddsnmp profile loading ([#20427](https://github.com/netdata/netdata/issues/20427))
- Update MSSQL Metadata ([#20429](https://github.com/netdata/netdata/issues/20429))
- Update ddsnmp mikrotik-router.yaml ([#20428](https://github.com/netdata/netdata/issues/20428))
- Regenerate integrations docs ([#20430](https://github.com/netdata/netdata/issues/20430))
- Enforce correct CPU architecture for Go plugin builds. ([#20405](https://github.com/netdata/netdata/issues/20405))
- Improve statement finalization and cleanup ([#20433](https://github.com/netdata/netdata/issues/20433))
- Adjust stream connector timeout during agent shutdown ([#20434](https://github.com/netdata/netdata/issues/20434))
- Fix heap-use-after-free in query progress updates ([#20431](https://github.com/netdata/netdata/issues/20431))
- Mcp3 ([#20435](https://github.com/netdata/netdata/issues/20435))
- Fix registry save integer overflow and add failure backoff ([#20437](https://github.com/netdata/netdata/issues/20437))
- Improvement(go.d/ddsnmp): use dev type and vendor from meta for family ([#20439](https://github.com/netdata/netdata/issues/20439))
- Chore(go.d/ddsnmp): add basic SNMP table walking functionality ([#20441](https://github.com/netdata/netdata/issues/20441))
- Build(deps): bump golang.org/x/net from 0.40.0 to 0.41.0 in /src/go ([#20444](https://github.com/netdata/netdata/issues/20444))
- Build(deps): bump github.com/gosnmp/gosnmp from 1.40.0 to 1.41.0 in /src/go ([#20449](https://github.com/netdata/netdata/issues/20449))
- Build(deps): bump github.com/lmittmann/tint from 1.1.1 to 1.1.2 in /src/go ([#20446](https://github.com/netdata/netdata/issues/20446))
- Build(deps): bump go.mongodb.org/mongo-driver from 1.17.3 to 1.17.4 in /src/go ([#20447](https://github.com/netdata/netdata/issues/20447))
- Build(deps): bump github.com/redis/go-redis/v9 from 9.9.0 to 9.10.0 in /src/go ([#20445](https://github.com/netdata/netdata/issues/20445))
- Feat: improve SCIM documentation ([#20451](https://github.com/netdata/netdata/issues/20451))
- Regenerate integrations docs ([#20453](https://github.com/netdata/netdata/issues/20453))
- Improvement(go.d/ddsnmp): dedup metrics when merging profiles ([#20456](https://github.com/netdata/netdata/issues/20456))
- Weblog collector: Exclude 429 from 4xx ([#20443](https://github.com/netdata/netdata/issues/20443))
- Build(deps): bump github.com/sijms/go-ora/v2 from 2.8.24 to 2.9.0 in /src/go ([#20457](https://github.com/netdata/netdata/issues/20457))
- Chore(go.d/smartctl): debug log exec output ([#20460](https://github.com/netdata/netdata/issues/20460))
- Build: update otel-collector deps ([#20461](https://github.com/netdata/netdata/issues/20461))
- Improvement(go.d/ddsnmp): add table metrics, tags from the same table ([#20463](https://github.com/netdata/netdata/issues/20463))
- Improve database indexing and rotation handling in event loop ([#20459](https://github.com/netdata/netdata/issues/20459))
- Improvement(go.d/ddsnmp): add table metrics and tags caching optimization ([#20465](https://github.com/netdata/netdata/issues/20465))
- Add MSSQL Wait statistics (windows.plugin) ([#20307](https://github.com/netdata/netdata/issues/20307))
- Regenerate integrations docs ([#20466](https://github.com/netdata/netdata/issues/20466))
- Vendor protobuf in static builds. ([#17774](https://github.com/netdata/netdata/issues/17774))
- Improve datafile rotation and indexing during shutdown ([#20464](https://github.com/netdata/netdata/issues/20464))
- Handle orphan journal files by deleting unmatched entries ([#20462](https://github.com/netdata/netdata/issues/20462))
- Remove static build timeouts from regular builds. ([#20470](https://github.com/netdata/netdata/issues/20470))
- Improvement(go.d/snmp): create table charts ([#20471](https://github.com/netdata/netdata/issues/20471))
- Add MCP documentation ([#20469](https://github.com/netdata/netdata/issues/20469))
- Update mcp.md ([#20475](https://github.com/netdata/netdata/issues/20475))
- Chore(go.d/ddsnmp): add dependency-based expiration to table cache ([#20474](https://github.com/netdata/netdata/issues/20474))
- Improvement(go.d): add bearer_token_file to request cfg ([#20476](https://github.com/netdata/netdata/issues/20476))
- Fix(go.d/redis): don't clear tls for rediss ([#20478](https://github.com/netdata/netdata/issues/20478))
- Chore(go.d/ddsnmp): split table collection into walk and process phases ([#20479](https://github.com/netdata/netdata/issues/20479))
- Chore(go.d/ddsnmp): collect cross-table metrics and tags ([#20481](https://github.com/netdata/netdata/issues/20481))
- Correctly ignore patches that are already applied. ([#20480](https://github.com/netdata/netdata/issues/20480))
- Modify Uninstall Action (windows.installer) ([#20467](https://github.com/netdata/netdata/issues/20467))
- Fix typo. ([#20417](https://github.com/netdata/netdata/issues/20417))
- Chore(go.d/ddsnmp):  support extracting table index components as tags ([#20482](https://github.com/netdata/netdata/issues/20482))
- Build(deps): bump github.com/go-sql-driver/mysql from 1.9.2 to 1.9.3 in /src/go ([#20483](https://github.com/netdata/netdata/issues/20483))
- Anue ([#20488](https://github.com/netdata/netdata/issues/20488))
- Fix(go.d): add missing props to config schemas ([#20489](https://github.com/netdata/netdata/issues/20489))
- Fix fluentd schema permit_plugin ([#20490](https://github.com/netdata/netdata/issues/20490))
- Chore(go.d/ddsnmp): fix table metrics collection ([#20492](https://github.com/netdata/netdata/issues/20492))
- Fix: mark import groups as not supported SCIM feature ([#20495](https://github.com/netdata/netdata/issues/20495))
- Regenerate integrations docs ([#20496](https://github.com/netdata/netdata/issues/20496))
- Chore(go.d/ddsnmp): fix table metrics again ([#20497](https://github.com/netdata/netdata/issues/20497))
- Chore(go.d/ddsnmp): better label values sanitization ([#20500](https://github.com/netdata/netdata/issues/20500))
- Feat(go.d/ddsnmp): make SNMP profile collection configurable ([#20503](https://github.com/netdata/netdata/issues/20503))
- Fix snmp prof mikrotik mem tagging ([#20504](https://github.com/netdata/netdata/issues/20504))
- Additional checks on metasync thread shutdown ([#20455](https://github.com/netdata/netdata/issues/20455))
- Improve(go.d/snmp profiles): simplify _generic-if.yaml and add interface type tags ([#20505](https://github.com/netdata/netdata/issues/20505))
- Monitor Exchange Server (Window.plugin) ([#20454](https://github.com/netdata/netdata/issues/20454))
- Feat(go.d/snmp profile): add sensors to mikrotik-router.yaml ([#20507](https://github.com/netdata/netdata/issues/20507))
- Feat(go.d/snmp profile): add fallback support for duplicate metric tags ([#20508](https://github.com/netdata/netdata/issues/20508))
- Chore(go.d/ddsnmp): fix table collection with caching ([#20509](https://github.com/netdata/netdata/issues/20509))
- Regenerate integrations docs ([#20506](https://github.com/netdata/netdata/issues/20506))
- Test(go.d/ddsnmp): add more tests for table metrics ([#20510](https://github.com/netdata/netdata/issues/20510))
- Improve(go.d/snmp): add SNMP- prefix for vnode hostname ([#20512](https://github.com/netdata/netdata/issues/20512))
- Docs: add Netdata MCP Server preview announcement ([#20513](https://github.com/netdata/netdata/issues/20513))
- Update machine-learning-and-assisted-troubleshooting.md ([#20514](https://github.com/netdata/netdata/issues/20514))
- Use ARAL for labels ([#20502](https://github.com/netdata/netdata/issues/20502))
- Cleanup pending statements during shutdown ([#20511](https://github.com/netdata/netdata/issues/20511))
- Update mcp.md ([#20515](https://github.com/netdata/netdata/issues/20515))
- Improve(go.d/snmp-profiles): Add hrSystemUptime metric for system upt… ([#20516](https://github.com/netdata/netdata/issues/20516))
- Fix(go.d/ddsnmp): remove singular-to-plural conversion in metric family ([#20517](https://github.com/netdata/netdata/issues/20517))
- Drop POWER8+ builds. ([#20518](https://github.com/netdata/netdata/issues/20518))
- Chore(go.d/snmp-profiles): remove unsupported constant_value_one metrics ([#20519](https://github.com/netdata/netdata/issues/20519))
- MCP Part 4 ([#20452](https://github.com/netdata/netdata/issues/20452))
- Improve(go.d/snmp-profiles): metrics deduplication ([#20520](https://github.com/netdata/netdata/issues/20520))
- Upd generic check in snmp prof metrics deduplication ([#20521](https://github.com/netdata/netdata/issues/20521))
- Update units in _generic-if.yaml ([#20523](https://github.com/netdata/netdata/issues/20523))
- Improve(go.d/snmp): log device profiles matched by sysObjectID ([#20524](https://github.com/netdata/netdata/issues/20524))
- Improve(go.d/snmp-profiles): allow users to add custom SNMP profiles ([#20526](https://github.com/netdata/netdata/issues/20526))
- Improve(go.d/snmp): add Go template-based metric transformations for SNMP profiles ([#20528](https://github.com/netdata/netdata/issues/20528))
- Improve(go.d/snmp): dd support for non-identifying tags in table metrics ([#20530](https://github.com/netdata/netdata/issues/20530))
- Build(deps): bump k8s.io/client-go from 0.33.1 to 0.33.2 in /src/go ([#20532](https://github.com/netdata/netdata/issues/20532))
- Lock before checking the statement pool ([#20536](https://github.com/netdata/netdata/issues/20536))
- Refactor(go.d/ddsnmpcollector): restructure into components ([#20543](https://github.com/netdata/netdata/issues/20543))
- SNMP: bluecat profile ([#20538](https://github.com/netdata/netdata/issues/20538))
- Update SQLITE to version 3.50.1 ([#20539](https://github.com/netdata/netdata/issues/20539))
- Build(deps): bump github.com/prometheus/common from 0.64.0 to 0.65.0 in /src/go ([#20545](https://github.com/netdata/netdata/issues/20545))
- Improve(go.d/snmp-profiles): add DHCP tags transform to bluecat profile ([#20547](https://github.com/netdata/netdata/issues/20547))
- Enable Rust-based journal file reader in static builds. ([#20477](https://github.com/netdata/netdata/issues/20477))
- Properly parse disconnect reason ([#20540](https://github.com/netdata/netdata/issues/20540))
- MSI parameter ([#20550](https://github.com/netdata/netdata/issues/20550))
- Hardware (Windows.plugin) ([#20522](https://github.com/netdata/netdata/issues/20522))
- Fix save alert config transition on shutdown ([#20553](https://github.com/netdata/netdata/issues/20553))
- Regenerate integrations docs ([#20552](https://github.com/netdata/netdata/issues/20552))
- Mcp disclaimer update ([#20563](https://github.com/netdata/netdata/issues/20563))
- Additional checks for valid db during db_execute ([#20560](https://github.com/netdata/netdata/issues/20560))
- Check that there is a valid thread when performing ACLK sync shutdown ([#20555](https://github.com/netdata/netdata/issues/20555))
- Simplify MRG loading mechanism logic ([#20562](https://github.com/netdata/netdata/issues/20562))
- Improve(go.d/smartctl): enable direct smartctl execution on non-Linux ([#20567](https://github.com/netdata/netdata/issues/20567))
- Add CLI command to schedule update information ([#20558](https://github.com/netdata/netdata/issues/20558))
- Build(deps): bump github.com/redis/go-redis/v9 from 9.10.0 to 9.11.0 in /src/go ([#20568](https://github.com/netdata/netdata/issues/20568))
- Improve(go.d/smartctl): add configurable concurrent device scanning ([#20569](https://github.com/netdata/netdata/issues/20569))
- Regenerate integrations docs ([#20571](https://github.com/netdata/netdata/issues/20571))
- Switch install types ([#20564](https://github.com/netdata/netdata/issues/20564))
- Improve(go.d/smartctl): add Win default path for smartctl executable ([#20574](https://github.com/netdata/netdata/issues/20574))
- Chore(go.d/snmp-profiles): skip abstract when loading ([#20576](https://github.com/netdata/netdata/issues/20576))
- NUMA Windows  ([#20573](https://github.com/netdata/netdata/issues/20573))
- Regenerate integrations docs ([#20577](https://github.com/netdata/netdata/issues/20577))
- Add Remove Node guide ([#20549](https://github.com/netdata/netdata/issues/20549))
- Improve SQLite library shutdown handling and initialization state ([#20559](https://github.com/netdata/netdata/issues/20559))
- Add Rocky Linux 10 to CI and package builds. ([#20578](https://github.com/netdata/netdata/issues/20578))
- Fix(go.d/ddsnmp): walk cross-table columns when referenced table has no metrics ([#20583](https://github.com/netdata/netdata/issues/20583))
- Fix(go.d/ddsnmp): include table name in config id ([#20584](https://github.com/netdata/netdata/issues/20584))
- Add defines for cleanup statements ([#20570](https://github.com/netdata/netdata/issues/20570))
- Remove devType/Vendor/ from ddsnmp metric families ([#20585](https://github.com/netdata/netdata/issues/20585))
- Fix(go.d/ddsnmp): correct matching same profile multiple times ([#20586](https://github.com/netdata/netdata/issues/20586))
- Ddsnmp add pow transform func and allow mapping duplicate values ([#20587](https://github.com/netdata/netdata/issues/20587))
- Doc: update SCIM doc ([#20588](https://github.com/netdata/netdata/issues/20588))
- Regenerate integrations docs ([#20589](https://github.com/netdata/netdata/issues/20589))
- Build(deps): bump github.com/go-viper/mapstructure/v2 from 2.2.1 to 2.3.0 in /src/go/otel-collector/exporter/netdataexporter ([#20591](https://github.com/netdata/netdata/issues/20591))
- Mcp5 ([#20529](https://github.com/netdata/netdata/issues/20529))
- Build(deps): bump github.com/go-viper/mapstructure/v2 from 2.2.1 to 2.3.0 in /src/go/otel-collector/exporter/journaldexporter ([#20592](https://github.com/netdata/netdata/issues/20592))
- SNMP: new version of families Cisco pass ([#20432](https://github.com/netdata/netdata/issues/20432))
- SNMP: palo-alto.yaml ([#20391](https://github.com/netdata/netdata/issues/20391))
- SNMP: aruba-wireless-controller.yaml ([#20389](https://github.com/netdata/netdata/issues/20389))
- SNMP: _juniper-cos.yaml ([#20402](https://github.com/netdata/netdata/issues/20402))
- Improve(go.d/snmp-profiles): extend transformEntitySensorValue ([#20594](https://github.com/netdata/netdata/issues/20594))
- SNMP: _juniper-virtualchassis.yaml ([#20410](https://github.com/netdata/netdata/issues/20410))
- SNMP: juniper-pulse-secure.yaml ([#20413](https://github.com/netdata/netdata/issues/20413))
- SNMP: 3com profiles ([#20468](https://github.com/netdata/netdata/issues/20468))
- SNMP: a10 yamls ([#20472](https://github.com/netdata/netdata/issues/20472))
- SNMP: APC profiles ([#20491](https://github.com/netdata/netdata/issues/20491))
- SNMP: Alcatel profiles ([#20487](https://github.com/netdata/netdata/issues/20487))
- SNMP: Arista profiles ([#20498](https://github.com/netdata/netdata/issues/20498))
- SNMP: second pass of aruba profiles ([#20499](https://github.com/netdata/netdata/issues/20499))
- SNMP: avaya profiles ([#20525](https://github.com/netdata/netdata/issues/20525))
- SNMP: audiocodes profile ([#20501](https://github.com/netdata/netdata/issues/20501))
- SNMP: avocent profile ([#20527](https://github.com/netdata/netdata/issues/20527))
- SNMP: brother profile ([#20548](https://github.com/netdata/netdata/issues/20548))
- SNMP: cradlepoint profile ([#20561](https://github.com/netdata/netdata/issues/20561))
- Build(deps): bump github.com/docker/docker from 28.2.2+incompatible to 28.3.0+incompatible in /src/go ([#20595](https://github.com/netdata/netdata/issues/20595))
- SNMP: avtech Profiles ([#20535](https://github.com/netdata/netdata/issues/20535))
- SNMP: barracuda Profiles ([#20537](https://github.com/netdata/netdata/issues/20537))
- SNMP: brocade profiles ([#20546](https://github.com/netdata/netdata/issues/20546))
- SNMP: checkpoint profiles ([#20556](https://github.com/netdata/netdata/issues/20556))
- SNMP: chrysalis profiles ([#20557](https://github.com/netdata/netdata/issues/20557))
- SNMP: Chatsworth profile ([#20554](https://github.com/netdata/netdata/issues/20554))
- SNMP: cyberpower-pdu profile ([#20575](https://github.com/netdata/netdata/issues/20575))
- Docs: fix 404 link in README.md ([#20597](https://github.com/netdata/netdata/issues/20597))
- Migrate from stable to nightly and vice versa ([#20551](https://github.com/netdata/netdata/issues/20551))
- Update generic snmp profiles ([#20599](https://github.com/netdata/netdata/issues/20599))
- Small snmp-related changes ([#20603](https://github.com/netdata/netdata/issues/20603))
- Improve mikrotik-router snmp profile ([#20605](https://github.com/netdata/netdata/issues/20605))
- Fix compilation on windows ([#20602](https://github.com/netdata/netdata/issues/20602))
- Ignore duplicate entries when rebuilding the alert version table ([#20579](https://github.com/netdata/netdata/issues/20579))
- Chore(go.d/snmp): add disable_legacy_collection option ([#20606](https://github.com/netdata/netdata/issues/20606))
- Metadata worker should respect shutdown request ([#20598](https://github.com/netdata/netdata/issues/20598))
- Improve netapp snmp profile ([#20608](https://github.com/netdata/netdata/issues/20608))
- Update fortinet snmp profiles ([#20609](https://github.com/netdata/netdata/issues/20609))
- SNMP Mikrotik profile make units in transform ucum ([#20611](https://github.com/netdata/netdata/issues/20611))
- Update sqlite version to 3.50.2 ([#20601](https://github.com/netdata/netdata/issues/20601))
- Improve datafile indexing ([#20607](https://github.com/netdata/netdata/issues/20607))
- Update tripplite snmp profiles ([#20613](https://github.com/netdata/netdata/issues/20613))
- Bump otel-collector components to v0.129.0 ([#20615](https://github.com/netdata/netdata/issues/20615))
- Transfer Learn PR 2473 ([#20600](https://github.com/netdata/netdata/issues/20600))
- Chore(go.d/snmp-profiles): move fam desc and unit under chart_meta ([#20614](https://github.com/netdata/netdata/issues/20614))
- Chore(go.d/snmp-profiles): small cleanup ([#20618](https://github.com/netdata/netdata/issues/20618))
- Chore(go.d/snmp-profiles): charts meta fixes and fam updates p1 ([#20620](https://github.com/netdata/netdata/issues/20620))
- Chore(go.d/snmp-profiles): charts meta fixes and fam updates p2 ([#20621](https://github.com/netdata/netdata/issues/20621))
- Chore(go.d/snmp-profiles): charts meta fixes and fam updates p3 ([#20622](https://github.com/netdata/netdata/issues/20622))
- Fix coverity issues ([#20612](https://github.com/netdata/netdata/issues/20612))
- Improve journal v2 file creation on startup  ([#20619](https://github.com/netdata/netdata/issues/20619))
- Improve packet ID generation ([#20624](https://github.com/netdata/netdata/issues/20624))
- At a glance ([#20627](https://github.com/netdata/netdata/issues/20627))
- Fix syntax error on learn doc ([#20628](https://github.com/netdata/netdata/issues/20628))
- Nidl Framework Documentation ([#20629](https://github.com/netdata/netdata/issues/20629))
- [WIP] Move NIDL-Framework.md to docs/ directory ([#20630](https://github.com/netdata/netdata/issues/20630))
- Move NIDL to docs ([#20632](https://github.com/netdata/netdata/issues/20632))
- Build(deps): bump github.com/docker/docker from 28.3.0+incompatible to 28.3.1+incompatible in /src/go ([#20633](https://github.com/netdata/netdata/issues/20633))
- Chore(go.d/snmp-profiles): charts meta fixes and fam updates p4 ([#20623](https://github.com/netdata/netdata/issues/20623))
- Update NIDL-Framework.md ([#20634](https://github.com/netdata/netdata/issues/20634))
- Refactor(go.d/iprange): migrate from net to net/netip ([#20636](https://github.com/netdata/netdata/issues/20636))
- MCP in Netdata Operations Diagram ([#20637](https://github.com/netdata/netdata/issues/20637))
- Chore(go.d/snmp-profiles): charts meta fixes and fam updates p5 ([#20635](https://github.com/netdata/netdata/issues/20635))
- Improve ACLK connection handling ([#20625](https://github.com/netdata/netdata/issues/20625))
- Rework datafiles ([#20581](https://github.com/netdata/netdata/issues/20581))
- Chore(go.d/snmp-profiles): charts meta fixes and fam updates p6 ([#20640](https://github.com/netdata/netdata/issues/20640))
- Add Screen to Windows installer ([#20593](https://github.com/netdata/netdata/issues/20593))
- Additional checks for ACLK proxy setting ([#20639](https://github.com/netdata/netdata/issues/20639))
- Update Cloud OIDC Authorization Server setup docs ([#20643](https://github.com/netdata/netdata/issues/20643))
- Regenerate integrations docs ([#20644](https://github.com/netdata/netdata/issues/20644))
- SNMP Profiles pass ep1 ([#20641](https://github.com/netdata/netdata/issues/20641))
- Chore(go.d/snmp-profiles): fix quotes ([#20645](https://github.com/netdata/netdata/issues/20645))
- SNMP profiles pass ep2 ([#20647](https://github.com/netdata/netdata/issues/20647))
- Sophos ([#20648](https://github.com/netdata/netdata/issues/20648))
- Build(deps): bump github.com/docker/docker from 28.3.1+incompatible to 28.3.2+incompatible in /src/go ([#20650](https://github.com/netdata/netdata/issues/20650))
- Build(deps): bump golang.org/x/text from 0.26.0 to 0.27.0 in /src/go ([#20651](https://github.com/netdata/netdata/issues/20651))
- Build(deps): bump github.com/miekg/dns from 1.1.66 to 1.1.67 in /src/go ([#20649](https://github.com/netdata/netdata/issues/20649))
- Fix documentation regarding header_match ([#20652](https://github.com/netdata/netdata/issues/20652))
- Regenerate integrations docs ([#20655](https://github.com/netdata/netdata/issues/20655))
- ASP.NET (windows.plugin) ([#20485](https://github.com/netdata/netdata/issues/20485))
- Chore(go.d/snmp-profiles): charts meta fixes and fam updates p7 ([#20646](https://github.com/netdata/netdata/issues/20646))
- Stop submitting analytics ([#20654](https://github.com/netdata/netdata/issues/20654))
- Fix coverity issues ([#20656](https://github.com/netdata/netdata/issues/20656))
- Improve job completion handling with timeout mechanism ([#20657](https://github.com/netdata/netdata/issues/20657))
- Chore(go.d/snmp-profiles): charts meta fixes and fam updates p8 ([#20660](https://github.com/netdata/netdata/issues/20660))
- Cloud Docs: updated ([#20661](https://github.com/netdata/netdata/issues/20661))
- Docs: fix "Unsupported markdown: list" in NC readme diagram ([#20665](https://github.com/netdata/netdata/issues/20665))
- Fix datafile creation race condition ([#20662](https://github.com/netdata/netdata/issues/20662))
- Regenerate integrations docs ([#20659](https://github.com/netdata/netdata/issues/20659))
- Build(deps): bump golang.org/x/net from 0.41.0 to 0.42.0 in /src/go ([#20667](https://github.com/netdata/netdata/issues/20667))
- Build(deps): bump github.com/bmatcuk/doublestar/v4 from 4.8.1 to 4.9.0 in /src/go ([#20666](https://github.com/netdata/netdata/issues/20666))
- Windows Pluging (Freedom to update every) ([#20580](https://github.com/netdata/netdata/issues/20580))
- Update netdata-enterprise-evaluation-corrected.md
- Add comprehensive welcome document ([#20669](https://github.com/netdata/netdata/issues/20669))
- Add ML anomaly detection accuracy analysis documentation ([#20663](https://github.com/netdata/netdata/issues/20663))
- Escape chars on documentation ([#20671](https://github.com/netdata/netdata/issues/20671))
- Regenerate integrations docs ([#20668](https://github.com/netdata/netdata/issues/20668))
- Update welcome-to-netdata.md
- Nd-mcp add claude cli cmd for adding netdata mcp ([#20440](https://github.com/netdata/netdata/issues/20440))
- Feat(go.d/snmp): enable table metrics by default ([#20674](https://github.com/netdata/netdata/issues/20674))
- Regenerate integrations docs ([#20675](https://github.com/netdata/netdata/issues/20675))
- Build(deps): bump azure/trusted-signing-action from 0.5.1 to 0.5.9 ([#20670](https://github.com/netdata/netdata/issues/20670))
- Improve agent shutdown on windows ([#20672](https://github.com/netdata/netdata/issues/20672))
- Code cleanup ([#20673](https://github.com/netdata/netdata/issues/20673))
- Agent docs alignement ([#20676](https://github.com/netdata/netdata/issues/20676))
- Chore(charts.d): suppress broken pipe error from echo during cleanup ([#20680](https://github.com/netdata/netdata/issues/20680))
- Fix deadlock in dictionary cleanup ([#20679](https://github.com/netdata/netdata/issues/20679))
- Remove Ubuntu 24.10 from CI and package builds. ([#20681](https://github.com/netdata/netdata/issues/20681))
- Fix systemd-journal-plugin RPM package. ([#20686](https://github.com/netdata/netdata/issues/20686))
- Fix log message format for buffered reader error ([#20687](https://github.com/netdata/netdata/issues/20687))
- Docs: update continue ext setup ([#20689](https://github.com/netdata/netdata/issues/20689))
- Docs: fix file location in continue setup ([#20690](https://github.com/netdata/netdata/issues/20690))
- Remove Fedora 40 from CI and package builds. ([#20685](https://github.com/netdata/netdata/issues/20685))
- Docs: remove Profiles heading from collapsible section ([#20691](https://github.com/netdata/netdata/issues/20691))

## [2.5.0] - 2025-05-05

### Merged Pull Requests:

- SNMP, Custom descriptions and units ([#20100](https://github.com/netdata/netdata/issues/20100))
- Create Empty Directories (Windows installer) ([#20124](https://github.com/netdata/netdata/issues/20124))
- Fix cleanup and exit and memory leaks ([#20120](https://github.com/netdata/netdata/issues/20120))
- Sqlite upgrade to version 3.49.1 ([#19933](https://github.com/netdata/netdata/issues/19933))
- Work to find leaks easily ([#20106](https://github.com/netdata/netdata/issues/20106))
- Fix compilation when using FSANITIZE_ADDRESS ([#20129](https://github.com/netdata/netdata/issues/20129))
- Handle corrupted journal data when populating the MRG during startup. ([#20128](https://github.com/netdata/netdata/issues/20128))
- Free ACLK message ([#20125](https://github.com/netdata/netdata/issues/20125))
- Make sure pattern array items are added and evaluated in order ([#20130](https://github.com/netdata/netdata/issues/20130))
- Fix Locks (Windows Locks) ([#20131](https://github.com/netdata/netdata/issues/20131))
- Update README.md ([#20133](https://github.com/netdata/netdata/issues/20133))
- Installation-Static Build-Windows ([#20122](https://github.com/netdata/netdata/issues/20122))
- Expression evaluator in re2c/lemon ([#20126](https://github.com/netdata/netdata/issues/20126))
- Install fix admonition docs ([#20136](https://github.com/netdata/netdata/issues/20136))
- Update MSI to use a single unified EULA instead of multiple license pages. ([#20134](https://github.com/netdata/netdata/issues/20134))
- Create netdata-kubernetes.md
- Update netdata-kubernetes.md
- Improve error handling and logging for journal and data files ([#20112](https://github.com/netdata/netdata/issues/20112))
- Fix MSSQL and improvements ([#20032](https://github.com/netdata/netdata/issues/20032))
- Chore(otel/journaldexporter): improve remote tests ([#20143](https://github.com/netdata/netdata/issues/20143))
- Docs: cleanup language and fix minor grammar issues ([#20144](https://github.com/netdata/netdata/issues/20144))
- Build(deps): bump github.com/gosnmp/gosnmp from 1.39.0 to 1.40.0 in /src/go ([#20149](https://github.com/netdata/netdata/issues/20149))
- Build(deps): bump github.com/i                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      