/*
 * Decompiled with CFR 0.152.
 */
package com.openstego.desktop;

import com.openstego.desktop.OpenStego;
import com.openstego.desktop.OpenStegoBulkException;
import com.openstego.desktop.OpenStegoConfig;
import com.openstego.desktop.OpenStegoException;
import com.openstego.desktop.OpenStegoPlugin;
import com.openstego.desktop.util.CommonUtil;
import com.openstego.desktop.util.LabelUtil;
import com.openstego.desktop.util.PluginManager;
import com.openstego.desktop.util.cmd.CmdLineOption;
import com.openstego.desktop.util.cmd.CmdLineOptions;
import com.openstego.desktop.util.cmd.CmdLineParser;
import com.openstego.desktop.util.cmd.PasswordInput;
import java.io.File;
import java.util.List;

public class OpenStegoCmd {
    private static final LabelUtil labelUtil = LabelUtil.getInstance("OpenStego");

    public static void execute(String[] args) {
        String command = null;
        OpenStego stego = null;
        OpenStegoPlugin<?> plugin = null;
        try {
            List<CmdLineOption> optionList;
            CmdLineParser parser = new CmdLineParser(OpenStegoCmd.getStdCmdLineOptions(null), args);
            if (!parser.isValid()) {
                OpenStegoCmd.displayUsage();
                return;
            }
            String pluginName = parser.getParsedOptions().getStringValue("-a");
            if (pluginName != null && !pluginName.equals("")) {
                plugin = PluginManager.getPluginByName(pluginName);
                if (plugin == null) {
                    throw new OpenStegoException(null, "OpenStego", 11, pluginName);
                }
            } else {
                List<OpenStegoPlugin<?>> plugins = PluginManager.getPlugins();
                if (plugins.size() == 1) {
                    plugin = plugins.get(0);
                } else if (plugins.size() > 1 && (optionList = parser.getParsedOptionsAsList()).size() > 0) {
                    command = optionList.get(0).getName();
                    if (command.equals("embed") || command.equals("extract")) {
                        plugins = PluginManager.getDataHidingPlugins();
                        if (plugins.size() == 1) {
                            plugin = plugins.get(0);
                        }
                    } else if ((command.equals("gensig") || command.equals("embedmark") || command.equals("checkmark")) && (plugins = PluginManager.getWatermarkingPlugins()).size() == 1) {
                        plugin = plugins.get(0);
                    }
                }
            }
            if (plugin != null) {
                parser = new CmdLineParser(OpenStegoCmd.getStdCmdLineOptions(plugin), args);
            }
            optionList = parser.getParsedOptionsAsList();
            CmdLineOptions options = parser.getParsedOptions();
            for (int i = 0; i < optionList.size(); ++i) {
                CmdLineOption option = optionList.get(i);
                if (i == 0 && option.getType() != 0 || i > 0 && option.getType() == 0) {
                    OpenStegoCmd.displayUsage();
                    return;
                }
                if (i != 0) continue;
                command = option.getName();
            }
            if (parser.getNonStdOptions().size() > 0) {
                OpenStegoCmd.displayUsage();
                return;
            }
            assert (command != null);
            if (!command.equals("help") && !command.equals("algorithms")) {
                if (plugin == null) {
                    throw new OpenStegoException(null, "OpenStego", 9);
                }
                plugin.resetConfig(parser.getParsedOptions());
                stego = new OpenStego(plugin, (OpenStegoConfig)plugin.getConfig());
            }
            switch (command) {
                case "embed": {
                    OpenStegoCmd.executeEmbed(options, stego);
                    break;
                }
                case "embedmark": {
                    OpenStegoCmd.executeEmbedMark(options, stego);
                    break;
                }
                case "extract": {
                    OpenStegoCmd.executeExtract(options, stego);
                    break;
                }
                case "checkmark": {
                    OpenStegoCmd.executeCheckMark(options, stego);
                    break;
                }
                case "gensig": {
                    OpenStegoCmd.executeGenSig(options, stego);
                    break;
                }
                case "diff": {
                    OpenStegoCmd.executeDiff(options, stego);
                    break;
                }
                case "readformats": {
                    List<String> formats = plugin.getReadableFileExtensions();
                    formats.forEach(System.out::println);
                    break;
                }
                case "writeformats": {
                    List<String> formats = plugin.getWritableFileExtensions();
                    formats.forEach(System.out::println);
                    break;
                }
                case "algorithms": {
                    List<OpenStegoPlugin<?>> plugins = PluginManager.getPlugins();
                    for (OpenStegoPlugin<?> osp : plugins) {
                        System.out.println(osp.getName() + " " + osp.getPurposesLabel() + " - " + osp.getDescription());
                    }
                    break;
                }
                case "help": {
                    if (plugin == null) {
                        OpenStegoCmd.displayUsage();
                        return;
                    }
                    System.err.println(plugin.getUsage());
                    break;
                }
                default: {
                    OpenStegoCmd.displayUsage();
                }
            }
        }
        catch (OpenStegoException osEx) {
            if (osEx.getErrorCode() == 0) {
                osEx.printStackTrace();
            } else {
                System.err.println(osEx.getMessage());
            }
        }
        catch (OpenStegoBulkException bulkEx) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < bulkEx.getExceptions().size(); ++i) {
                sb.append("  ").append(i + 1).append(". ").append(bulkEx.getKeys().get(i)).append(": ").append(bulkEx.getExceptions().get(i).getMessage()).append("\n");
            }
            System.err.println();
            System.err.println(labelUtil.getString("cmd.label.bulkerror.header"));
            System.err.println(sb);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void executeEmbed(CmdLineOptions options, OpenStego stego) throws OpenStegoException, OpenStegoBulkException {
        String msgFileName = options.getStringValue("-mf");
        String coverFileName = options.getStringValue("-cf");
        String stegoFileName = options.getStringValue("-sf");
        if (stego.getConfig().isUseEncryption() && stego.getConfig().getPassword() == null) {
            stego.getConfig().setPassword(PasswordInput.readPassword(labelUtil.getString("cmd.msg.enterPassword") + " "));
        }
        File msgFile = msgFileName == null || msgFileName.equals("-") ? null : new File(msgFileName);
        List<File> coverFileList = CommonUtil.parseFileList(coverFileName, ";");
        if (coverFileList.size() <= 1) {
            if (coverFileList.size() == 0 && coverFileName != null && !coverFileName.equals("-")) {
                System.err.println(labelUtil.getString("cmd.msg.coverFileNotFound", coverFileName));
                return;
            }
            String stegoFile = stegoFileName == null || stegoFileName.equals("-") ? null : stegoFileName;
            CommonUtil.writeFile(stego.embedData(msgFile, coverFileList.size() == 0 ? null : coverFileList.get(0), stegoFile), stegoFile);
        } else {
            if (stegoFileName != null && !stegoFileName.equals("-")) {
                System.err.println(labelUtil.getString("cmd.warn.stegoFileIgnored"));
            }
            OpenStegoBulkException bulkException = new OpenStegoBulkException();
            for (File file : coverFileList) {
                coverFileName = file.getName();
                try {
                    CommonUtil.writeFile(stego.embedData(msgFile, file, coverFileName), coverFileName);
                    System.err.println(labelUtil.getString("cmd.msg.coverProcessed", coverFileName));
                }
                catch (OpenStegoException e) {
                    bulkException.add(coverFileName, e);
                }
            }
            bulkException.throwIfRequired();
        }
    }

    private static void executeEmbedMark(CmdLineOptions options, OpenStego stego) throws OpenStegoException, OpenStegoBulkException {
        String sigFileName = options.getStringValue("-gf");
        String coverFileName = options.getStringValue("-cf");
        String stegoFileName = options.getStringValue("-sf");
        File sigFile = sigFileName == null || sigFileName.equals("-") ? null : new File(sigFileName);
        List<File> coverFileList = CommonUtil.parseFileList(coverFileName, ";");
        if (coverFileList.size() <= 1) {
            if (coverFileList.size() == 0 && coverFileName != null && !coverFileName.equals("-")) {
                System.err.println(labelUtil.getString("cmd.msg.coverFileNotFound", coverFileName));
                return;
            }
            String stegoFile = stegoFileName == null || stegoFileName.equals("-") ? null : stegoFileName;
            CommonUtil.writeFile(stego.embedMark(sigFile, coverFileList.size() == 0 ? null : coverFileList.get(0), stegoFile), stegoFile);
        } else {
            if (stegoFileName != null && !stegoFileName.equals("-")) {
                System.err.println(labelUtil.getString("cmd.warn.stegoFileIgnored"));
            }
            OpenStegoBulkException bulkException = new OpenStegoBulkException();
            for (File file : coverFileList) {
                coverFileName = file.getName();
                try {
                    CommonUtil.writeFile(stego.embedMark(sigFile, file, coverFileName), coverFileName);
                    System.err.println(labelUtil.getString("cmd.msg.coverProcessed", coverFileName));
                }
                catch (OpenStegoException e) {
                    bulkException.add(coverFileName, e);
                }
            }
            bulkException.throwIfRequired();
        }
    }

    private static void executeExtract(CmdLineOptions options, OpenStego stego) throws OpenStegoException {
        List<?> msgData;
        String stegoFileName = options.getStringValue("-sf");
        String extractDir = options.getStringValue("-xd");
        if (stegoFileName == null) {
            OpenStegoCmd.displayUsage();
            return;
        }
        try {
            msgData = stego.extractData(new File(stegoFileName));
        }
        catch (OpenStegoException osEx) {
            if (osEx.getErrorCode() == 1 || osEx.getErrorCode() == 6) {
                if (stego.getConfig().getPassword() == null) {
                    stego.getConfig().setPassword(PasswordInput.readPassword(labelUtil.getString("cmd.msg.enterPassword") + " "));
                    try {
                        msgData = stego.extractData(new File(stegoFileName));
                    }
                    catch (OpenStegoException inEx) {
                        if (inEx.getErrorCode() == 1) {
                            System.err.println(inEx.getMessage());
                            return;
                        }
                        throw inEx;
                    }
                }
                System.err.println(osEx.getMessage());
                return;
            }
            throw osEx;
        }
        String extractFileName = options.getStringValue("-xf");
        if (extractFileName == null && ((extractFileName = (String)msgData.get(0)) == null || extractFileName.equals(""))) {
            extractFileName = "untitled";
        }
        if (extractDir != null) {
            extractFileName = extractDir + File.separator + extractFileName;
        }
        CommonUtil.writeFile((byte[])msgData.get(1), extractFileName);
        System.err.println(labelUtil.getString("cmd.msg.fileExtracted", extractFileName));
    }

    private static void executeCheckMark(CmdLineOptions options, OpenStego stego) throws OpenStegoException {
        String stegoFileName = options.getStringValue("-sf");
        String sigFileName = options.getStringValue("-gf");
        if (stegoFileName == null || sigFileName == null) {
            OpenStegoCmd.displayUsage();
            return;
        }
        List<File> stegoFileList = CommonUtil.parseFileList(stegoFileName, ";");
        if (stegoFileList.size() == 1) {
            System.out.println(stego.checkMark(stegoFileList.get(0), new File(sigFileName)));
        } else {
            for (File file : stegoFileList) {
                stegoFileName = file.getName();
                System.out.println(stegoFileName + "\t" + stego.checkMark(file, new File(sigFileName)));
            }
        }
    }

    private static void executeGenSig(CmdLineOptions options, OpenStego stego) throws OpenStegoException {
        if (stego.getConfig().getPassword() == null) {
            stego.getConfig().setPassword(PasswordInput.readPassword(labelUtil.getString("cmd.msg.enterPassword") + " "));
        }
        String signatureFileName = options.getStringValue("-gf");
        CommonUtil.writeFile(stego.generateSignature(), signatureFileName == null || signatureFileName.equals("-") ? null : signatureFileName);
    }

    private static void executeDiff(CmdLineOptions options, OpenStego stego) throws OpenStegoException {
        String coverFileName = options.getStringValue("-cf");
        String stegoFileName = options.getStringValue("-sf");
        String extractDir = options.getStringValue("-xd");
        String extractFileName = options.getStringValue("-xf");
        if (extractDir != null) {
            extractFileName = extractDir + File.separator + extractFileName;
        }
        CommonUtil.writeFile(stego.getDiff(new File(stegoFileName), new File(coverFileName), extractFileName), extractFileName);
    }

    private static void displayUsage() throws OpenStegoException {
        PluginManager.loadPlugins();
        System.err.print(labelUtil.getString("appName") + " " + labelUtil.getString("appVersion") + ". ");
        System.err.println(labelUtil.getString("copyright") + "\n");
        System.err.println(labelUtil.getString("cmd.usage", File.separator));
    }

    private static CmdLineOptions getStdCmdLineOptions(OpenStegoPlugin<?> plugin) throws OpenStegoException {
        CmdLineOptions options = new CmdLineOptions();
        options.add("embed", "--embed", 0, false);
        options.add("extract", "--extract", 0, false);
        options.add("gensig", "--gensig", 0, false);
        options.add("embedmark", "--embedmark", 0, false);
        options.add("checkmark", "--checkmark", 0, false);
        options.add("diff", "--diff", 0, false);
        options.add("readformats", "--readformats", 0, false);
        options.add("writeformats", "--writeformats", 0, false);
        options.add("algorithms", "--algorithms", 0, false);
        options.add("help", "--help", 0, false);
        options.add("-a", "--algorithm", 1, true);
        options.add("-mf", "--messagefile", 1, true);
        options.add("-cf", "--coverfile", 1, true);
        options.add("-sf", "--stegofile", 1, true);
        options.add("-xf", "--extractfile", 1, true);
        options.add("-xd", "--extractdir", 1, true);
        options.add("-gf", "--sigfile", 1, true);
        options.add("-c", "--compress", 1, false);
        options.add("-C", "--nocompress", 1, false);
        options.add("-e", "--encrypt", 1, false);
        options.add("-E", "--noencrypt", 1, false);
        options.add("-p", "--password", 1, true);
        options.add("-A", "--cryptalgo", 1, true);
        if (plugin != null) {
            plugin.populateStdCmdLineOptions(options);
        }
        return options;
    }
}

