/*
 * Decompiled with CFR 0.152.
 */
package com.openstego.desktop;

import com.openstego.desktop.util.LabelUtil;
import java.util.HashMap;
import java.util.Map;

public class OpenStegoException
extends Exception {
    private static final long serialVersionUID = 668241029491685413L;
    static final int UNHANDLED_EXCEPTION = 0;
    private static final Map<String, String> errMsgKeyMap = new HashMap<String, String>();
    private final int errorCode;
    private final String namespace;

    public OpenStegoException(Throwable cause) {
        this(cause, "OpenStego", 0, (Object[])null);
    }

    public OpenStegoException(Throwable cause, String namespace, int errorCode) {
        this(cause, namespace, errorCode, (Object[])null);
    }

    public OpenStegoException(Throwable cause, String namespace, int errorCode, String param) {
        this(cause, namespace, errorCode, new Object[]{param});
    }

    public OpenStegoException(Throwable cause, String namespace, int errorCode, Object ... params) {
        super("OpenStego".equals(namespace) && errorCode == 0 ? cause.toString() : LabelUtil.getInstance(namespace).getString(errMsgKeyMap.get(namespace + errorCode), params), cause);
        this.namespace = namespace;
        this.errorCode = errorCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public static void addErrorCode(String namespace, int errorCode, String labelKey) {
        errMsgKeyMap.put(namespace + errorCode, labelKey);
    }
}

