# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.1.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [0.8.3] - 2025-06-26

### Fixed

- Corrected reported version. Version 0.8.1 and 0.8.2 incorrectly reported 0.8.0.

## [0.8.2] - 2025-06-25

### Fixed

- Listing the installed packages handles package names with a hyphen correctly now.

## [0.8.1] - 2025-05-28

### Fixed

- Coverage check in CI pipeline now works correctly.

## [0.8.0] - 2025-05-27

### Added

- CHANGELOG.md
- CONTRIBUTING.md
- gitlab ci-pipeline
- VERSION_FLAG (set to `-v` by default)
- Doc comments for all exported functions/methods/types
- function to create a `Package`, including all files, from strings 
- test for functions which were previously tested indirectly by test which now belong to other packages

### Changed

- seperation of the source code into packages
    - slim `main` package contains only the `main` function
    - `utils` package contains utility functions and wrappers around the `os` and `io` packages
    - `sboRepo` contains...
        - the `Package` struct and its methods
        - functions to parse an SBo repository into a map of `Package` structs
        - functions to resolve dependencies and to create a process list
    - `pkg` package contains...
        - the `Run` function which is the entry point of the application
        - all configuration and command line parsing
        - the error handling of the application
- much cleaner tests
- dedicated `doc.mk` makefile to generate the README and manpage
- cleaner way to automatically create the README and manpage

### Fixed

- bug in `TestListInstalled`, packages are now read from a dummy file instead of the real system

## [0.7.0] - 2025-05-17

### Added:

- Moved logic from `main` function to a `Run` function which accepts many of the constants set in config.go as parameters to make it more flexible
- Unit tests for the `Run` function. Overall coverage is 99.8% now (only `main` itself, which just calls `Run` is not and can not be tested)
- Cleaner code by moving some logic into helper functions

### Fixed:

- skip hidden directories like .git when searching the repo for packages

## [0.6.3] - 2025-04-28

### Changed

- Updated documentation:
    - describes what is said above int the README.

### Fixed:

- 6.0 introduced an automatically generated man page. It uses the output of the applications help output and go-md2man for this purpose. The manpage was hence considered out of date if the application was rebuild (since the help output may have changed) triggering a rebuild with go-md2man, making it a build-time dependency. This was fixed. Now, make doc needs to be triggered explicitly to re-generate the documentation.

## [0.6.2] - 2025-04-26

### Fixed:

- Ensure in the makefile that needed target directories are created before trying to write files into them. This fixes the build on systems where the directory for man pages does not exist yet.

## [0.6.1] - 2025-04-26

Empty release due to a mistake.

## [0.6.0] - 2025-04-26

### Added:

- Documentation:
    - Automated generation of the README ensures that the mentioned options are always up to date.
    - Automated generation and installation options of a man page (similar content to the README)
    - Added docstrings to many functions

### Changed:

- Cleaner code:
    - Moved repeated code into functions
    - General clean up of some code

### Fixed:

- Fixes crash which occurred if building a package failed

## [0.5.0] - 2025-03-17

### Added:

- Parallelized the most costly routines:
    - Creation of the repo map
    - Sorting out up-to-data packages
    - Checking which files must be downloaded/are downloaded

### Changed:

- Nicer output:
    - If a package is not found we throw a better formatted error message (and panic) instead of just panicking
    - The "Banner" used to raise attention to the user looks nicer
- Cleaner code:
    - Implemented and uses new wrapper routines around routines which might panic and catch the panic in the wrapper
    - Cleaner and more efficient parser for input files (pkg_list.txt, greylist, blacklist)
    - Added and improved docstrings
    - Nicer formatting in the main function
- When comparing files, we compare the bytes directly instead of the hash which avoids hashing

### Fixed:

- In case an older build of a package (*.t?z) is present in the TMP_DIR directory, we make sure that we install the package we just build (by checking time stamps) instead of the old one

## [0.4.0] - 2025-01-24

### Changed:

- When listing packages names after a search or when the user is prompted to exclude packages, also a short description of the package (taken from the slack-desc file) is displayed.

## [0.3.0] - 2025-01-12

### Changed:

- If there is more than one README file (i.e. a README.Slackware) show all of them where we previously only showed "README"

### Fixed:

- make test now also works if make or make build was not run previously

## [0.2.0] - 2025-01-11

### Added:

- can list all installed SBo packages. Useful to create an initial pkg_list.txt
- every function outside of main has 100% unit test covarage

### Changed:

- code restructured such that testing became easier

### Fixed:

- PromptUser clean: flush input buffer afterwards
- IsEmpty: Under some circumstances it was not detected if all packages were removed

## [0.1.0] - 2024-11-28

Fully functional first release, see README.md for details.
