# Contributing Guidelines

There most likely won't be any other contributors, so this is more of a reminder for myself.

## Compiler Versions
- Must run on all currently supported versions of Slackware.
- CI enforces that the code compiles with gccgo 11.2.0.
- CI enforces that all tests pass with gccgo 11.2.0.

## Code Style
- Use `make fmt` (calls `go fmt`) to format the code.
- CI enforces that `make fmt` does not produce any changes to the code.

## Tests
- run them regularly via `make test` and `make cover`
- all functions (despite `main()`) must be fully covered by tests.
- CI enforces that code coverage is higher than 99%.
- must not rely on any non source-files (outside or inside) the repository
- CI enforces that all tests pass also on a non-Slackware system.

## Documentation
- All public functions must be documented with GoDoc comments starting with the function name.
- README.md and pkg.8 are generated automatically by `make doc`
- `make doc` needs to be run whenever...
    - the version number changes.
    - command line options change.
    - file under `doc/` changes.
- CI enforces that `make doc` does not produce any changes to the code.

## Source Tree and Packages
- The `main()` should be the only function of the main `package` and should only call `pkg.Run`
- All packages must be in the `lib/` directory.
- Utilities which are...
    - specific to the `pkg` command -> `lib/pkg`.
    - usefull to interact with a repository of Slackware packages -> `lib/repoMap`.
    - general purpose helper functions -> `lib/utils`.

## Changelog
- Must be updated with every change.
