package main

import (
	"os"

	"gitlab.com/M0M097/pkg/lib/pkg"
)

// main is wrapper that just passes the command line and constant configs to
// the pkg.Run function.
func main() {
	pkg.Run(
		os.Stdout, os.Stdin, os.Stderr, // Standard streams
		os.Args, // Command line arguments

		// Directory paths
		pkg.REPO_PATH, pkg.DOC_DIR, pkg.TMP_DIR, pkg.CONFIG_DIR,

		// Constant filepaths
		pkg.GREYLIST, pkg.BLACKLIST, pkg.OTHER_BLACKLIST, pkg.DEFAULT_PKG_FILE,

		// Commands
		pkg.PULL_CMD, pkg.SYNC_CMD, pkg.CLEAN_CMD, pkg.DOWNLOAD_CMD, pkg.INSTALL_CMD,
		pkg.FALLBACK_PAGER,
	)
}
