APP_NAME = $(notdir $(CURDIR))
MANPAGE = $(APP_NAME).8
MD2MAN = go-md2man -in
TODAY = "$(shell date -I)"
DOCDIR = doc

README_PARTS = $(addprefix $(DOCDIR)/, $(addsuffix _README.md, 00 10 20 90))
MANPAGE_PARTS = $(README_PARTS:_README.md=_MANPAGE.roff)

doc: README.md $(MANPAGE)

README.md: $(README_PARTS)
	cat $^ > $@

$(MANPAGE): $(MANPAGE_PARTS)
	cat $^ > $@

%_MANPAGE.roff: %_README.md
	$(MD2MAN) $< > $@

# Ensures that version and date in the manpage are updated
$(DOCDIR)/00_MANPAGE.roff: $(APP_NAME)
	awk -v version=\"`./$< -v`\" \
		'NR == 1 && $$5 != version {$$4 = $(TODAY); $$5 = version}; {print}' $@ > $@.tmp
	mv $@.tmp $@

$(DOCDIR)/20_README.md: $(APP_NAME)
	./$< --help 2>&1 | awk '$$1 ~ /-/{$$1="\n`"$$1"`"};NR > 1 {print $$0}' > $@

.PHONY: doc
