# `pkg` Simple and fast package manager for the Slackbuilds.org Slackware packages repository.

[![pipeline status](https://gitlab.com/M0M097/pkg/badges/main/pipeline.svg)](https://gitlab.com/M0M097/pkg/-/commits/main) 
[![coverage report](https://gitlab.com/M0M097/pkg/badges/main/coverage.svg)](https://gitlab.com/M0M097/pkg/-/commits/main)
[![Latest Release](https://gitlab.com/M0M097/pkg/-/badges/release.svg)](https://gitlab.com/M0M097/pkg/-/releases)

[[_TOC_]]

## Installation
A SlackBuild file is provided at [slackbuilds.org](https://slackbuilds.org/repository/15.0/system/pkg/)

`make && sudo make install` will compile the program, give it the same name as the directory name of this directory (`pkg` if you simply cloned it from git) and install it to the default location `/usr/local/bin`.
Edit the makefile or pass arguments to `make` (i.e. `make PREFIX=$HOME/.local`) to change the installation location, name of the binary, etc.

## Configuration
In addition to the command line flags all external commands (to update the repository, install packages, etc), (default) file paths, the command line flags themselves and many other settings can be changed by editing `lib/pkg/config.go` and recompiling. See the comments in the file for more information. No knowledge of `go` is required to change these settings.

This README and the man page are partly automatically generated from the help output of the program. Run `make doc` before `make install` to re-generate it in case you modfied the accepted command line flags.

## Dependencies
All dependencies are present in a default Slackware installation. 
A `go` compiler is required to compile the program. Despite the go standard library no other libraries are used.
In the default configuration, `curl` is used for downloading files, `git` for keeping the repository up to date, `installpkg` for installing/upgrading packages and `bash` for running the Slackbuilds. These can be changed in `src/config.go`.

To rebuild the man page you need `go-md2man`. If you want to use another markdown to roff converter, pass it to the makefile: `make doc MD2MAN=yourconverter` (must accept an input file name and write the result to stdout).

To check the unit test coverage with `make cover` you do need the `google-go-lang` package from Slackbuilds.org. `make test`, which runs the tests, sets `-vet=off` and hence also works with gccgo shipped with Slackware.

## API
The de-facto main function `Run` in the `lib/pkg` package can be wrapped. However, it is a very high-level function that does not allow for much customization.
Generally useful functions to interact programmatically with a repository (parsing the repository, resolve dependencies etc.) of SlackBuilds can be found in the `lib/sboRepo` package.

## Usage
