If invoked with no arguments, it will read white-space seperated packages from `/etc/pkg/pkg_list.txt`, resolves their dependencies and installs/upgrades them in the correct order if they are not already installed or are older than the version in the repository.
The user will be prompted to optionally exclude packages from the list if `-y` is not given.
If the package name is in `/etc/pkg/pkg_list.txt` is followed by `key=value` pairs, these will be passed to the Slackbuild as environment variables. For example, `mypackage FOO=bar` will set the environment variable `FOO` to `bar` when building `mypackage`.
Additionally, if the file `/etc/pkg/mypackage.prebuild` exists and is executable, it will be run before building (and after downloading the sources of) `mypackage`.
The first argument passed to the prebuild script is the path to the directory containing the sources/slackbuild of the package.

An initial `pkg_list.txt` can be generated by running `pkg -l` (list installed SBo packages) and then removing packages which you do not use directly but are, i.e., dependencies of other packages.

`pkg` also updates the `/etc/slackpkg/blacklist` so that orphaned packages are automatically removed when `slackpkg clean-system` is run, and packages in `/etc/pkg/pkg_list.txt` and their dependencies are not removed.
To achive this it first copies `/etc/pkg/blacklist` to `/etc/slackpkg/blacklist` and then appends the packages in `/etc/pkg/pkg_list.txt` and their dependencies to the blacklist. So copy (parts of) your original blacklist to `/etc/pkg/blacklist`, if you want to exclude packages not managed by `pkg` from being removed by `slackpkg clean-system`, otherwise backup your original blacklist and create an empty file at `/etc/pkg/blacklist`. Note: if `/etc/pkg/blacklist` is not present, `pkg` will fail with an error message to ensure that `/etc/slackpkg/blacklist` is not overwritten by mistake.

Packages can also be greylisted in `/etc/pkg/greylist` so that they are not installed by `pkg` but are not removed by `slackpkg clean-system` either (since they are still added to `etc/slackpkg/blacklist`.

If positonal arguments are given, they are treated as package names and installed/upgraded in the correct order. The blacklist is not updated in this case. So `pkg mypackage` will install `mypackage` and its dependencies, but `mypackage` will be removed if `slackpkg clean-system` is run. Add `mypackage` to `/etc/pkg/pkg_list.txt` to prevent this.

`pkg` can also be used to view the README of a packages or list their dependencies/dependees.

By default, it clones the SBo repo to `/var/lib/pkg/sbo` syncs the repository before if the `-u` flag is given.

Any invalid flag like `-h` will print the usage and exit.

## Options
