package pkg

// config.go - Configuration constants for the pkg tool.
const (
	VERSION = "0.8.3"

	BLACKLIST = "/etc/slackpkg/blacklist"

	// Command that will execute the SlackBuild script.
	BUILD_CMD = "/bin/bash --login "

	CONFIG_DIR       = "/etc/pkg"
	DEFAULT_PKG_FILE = CONFIG_DIR + "/pkg_list.txt"
	ENV_CMD          = "/usr/bin/env "
	DOC_DIR          = "/usr/doc"

	// Must be a string which, when appended by URLs, and executed by the
	// shell, will download the files to TMP_DIR. Posiible alternative:
	// DOWNLOAD_CMD    = "/usr/bin/wget  --directory-prefix"
	DOWNLOAD_CMD = "/usr/bin/curl --remote-name-all --location --parallel --output-dir " + TMP_DIR

	// Pager to be used if $PAGER is not set. Used to display README and
	// SlackBuild files.
	FALLBACK_PAGER = "/usr/bin/less"

	// This command must clean the repository of any files that are not
	// in the upstream repository. Adjust if SYNC_CMD is changed.
	CLEAN_CMD = "/usr/bin/git -C " + REPO_PATH + " clean -fdx"

	// File containing a list of packages (one per line, comments "#" allowed),
	// which will be skipped during the upgrade process, can be disabled with
	// command line flag.
	GREYLIST = CONFIG_DIR + "/greylist"

	INSTALL_CMD = "/sbin/upgradepkg --install-new --reinstall "
	MIRROR      = "https://github.com/SlackBuildsOrg/slackbuilds.git"
	TMP_DIR     = "/tmp/pkg"
	// Will be copied to BLACKLIST, before BLACKLIST gets updated.
	OTHER_BLACKLIST = CONFIG_DIR + "/blacklist"

	// Extension for prebuild hooks. If a file with `package_name`.PREBUILD_EXT
	// exists in CONFIG_DIR, it will be executed before the package is built.
	// The first argument will be the path to the package directory.
	PREBUILD_EXT = ".prebuild"

	PULL_CMD  = "/usr/bin/git clone --depth 1 --no-tags --branch master -- " + MIRROR + " " + REPO_PATH
	REPO_PATH = "/var/lib/pkg/sbo"

	// Must be a string which, when executed by the shell, will update the
	// repository.
	SYNC_CMD = "/usr/bin/git -C " + REPO_PATH + " pull"

	// Flags for command line arguments.
	FILTERINSTALLED_FLAG = "i" // Don't filter installed packages
	FILE_FLAG            = "f" // Read package names from file
	LIST_INSTALLED_FLAG  = "l" // List installed packages
	MD5_FLAG             = "m" // Skip MD5Sum checks
	NO_DEPS_FLAG         = "n" // Don't install dependencies
	ROOT_FLAG            = "r" // Display dependees of the given package
	RESPECTGREYLIST_FLAG = "g" // Ignore the greylist
	SEARCH_FLAG          = "s" // Search for a package
	TRACK_FLAG           = "t" // Track the given packages (show all dependencies)
	UPDATE_FLAG          = "u" // Update the repository (before doing anything else)
	VERSION_FLAG         = "v" // Display the version of pkg
	VIEW_FLAG            = "d" // Display information for the given packages
	VIEWBUILD_FLAG       = "b" // Display build scripts for the given packages
	YES_FLAG             = "y" // Skip all prompts
)
