package sboRepo

import (
	"path/filepath"
	"testing"

	"gitlab.com/M0M097/pkg/lib/utils"
)

func TestCreate(t *testing.T) {
	td := t.TempDir()
	categoryPath := filepath.Join(td, "category")
	pkg := PkgCreator{
		Name:              DUMMY_PKG1,
		Path:              categoryPath,
		Version:           DUMMY_VERSION,
		Download:          DUMMY_DOWNLOAD_URL,
		Md5sum:            DUMMY_MD5SUM,
		Download64:        DUMMY_DOWNLOAD_URL64,
		Md5sum64:          DUMMY_MD5SUM64,
		Requires:          utils.Join([]string{DUMMY_PKG2, DUMMY_PKG3}),
		SlackBuildContent: MOCK_PKG_SLACKBUILD_CONTENT,
		ReadmeContent:     MOCK_PKG_README_CONTENT,
		SlackDescContent:  MOCK_PKG_SLACK_DES_CONTENT,
	}.Create()
	mustBeEqual(t, utils.Exists(pkg.SlackBuild()), true)
	mustBeEqual(t, utils.Exists(pkg.Readme()), true)
	mustBeEqual(t, utils.Exists(pkg.InfoFile()), true)
	mustBeEqual(t, utils.Exists(pkg.SlackDesc()), true)

	mustBeEqual(t, pkg.Name(), DUMMY_PKG1)
	mustBeEqual(t, pkg.Path(), filepath.Join(categoryPath, pkg.Name()))

	// Check the contents of the info file
	mustBeEqual(t, pkg.Version(), DUMMY_VERSION)
	mustBeEqualStringSlices(t, pkg.Md5sums(), []string{DUMMY_MD5SUM64})
	mustBeEqualStringSlices(t, pkg.DownloadUrls(), []string{DUMMY_DOWNLOAD_URL64})
	mustBeEqualStringSlices(t, pkg.Dependencies(), []string{DUMMY_PKG2, DUMMY_PKG3})

	// Check the contents of the SlackBuild, README, and slack-desc files
	mustBeEqual(t, string(utils.ReadFile(pkg.SlackBuild())), MOCK_PKG_SLACKBUILD_CONTENT)
	mustBeEqual(t, string(utils.ReadFile(pkg.Readme())), MOCK_PKG_README_CONTENT)
	mustBeEqual(t, string(utils.ReadFile(pkg.SlackDesc())), MOCK_PKG_SLACK_DES_CONTENT)

}
