/*
Package sboRepo provides types and methods to interact with a local repository
of Slackware packages, specifically a clone of the SlackBuilds.org (SBO)
repository.

It provides a `Package` type that represents a Slackware package, allowing for
querying package metadata. It also provides methods which can help to create a
doubly linked list of packages as well as a dependency graph of packages.

The package also provides a `RepoMap` type that parses a directory structure to
create a map of instances of `Package`, allowing for easy access to package
metadata and dependencies. After parsing (i.e. a SlackBuilds.org repository),
it can be used to query packages by name. It provides methods to resolve build
the dependency graph and a process list of packages, which can be used to
determine the order in which packages should be built based on their
dependencies.

It also provides a Head type, on top of which the mentioned doubly linked of
packages can be built and which is returned by the ProcessList method of the
`RepoMap`. It can be used to (concurrently) iterate over the packages in the
list, allowing for efficient processing.

The `PkgCreator` type is provided to conveniently create a new package
including its metadata files, such as .info, README, and slack-desc. It can be
used to create a new package in the repository, ensuring that all necessary
files are created and populated with the correct metadata.
*/
package sboRepo
