/*
Package utils provides generally useful utility functions and wrappers.

It wraps some functions from the `os` and `io` packages. Those wrappers panic
if the operation fails, so they can be used in a more convenient way without
having to check for errors every time. Those wrappers are defined in
`os_wrapper.go`.

It also provides some higher-level utility functions which are not included in
the standard library, and functions useful for cli applications which need
to interact with the user. Those functions are mainly defined in
`io_and_helpers.go`.

`executor.go` defines the `Executor` and `Pager` types, which can be used to
execute shell commands, capture their output, and log their execution.
*/
package utils
