# sbotools

**[sbotools](https://pghvlaans.github.io/sbotools/)** is a set of Perl scripts providing a ports-like automation interface to [SlackBuilds.org](https://www.slackbuilds.org/). Run **sbotool** for a TUI. The tools can also run independently for greater efficiency:

  * **sbocheck**: Fetch the latest version of SlackBuilds.org repository; check for version updates, build number changes and out-of-tree installed SlackBuilds. Perform shared object dependency checks.
  * **sboclean**: Remove cruft by cleaning source archives, build directories and saved build options.
  * **sboconfig**: A command line interface for changing settings.
  * **sbofind**: Search the local copy of the repository.
  * **sbohints**: Query and modify the blacklist and requests for optional dependencies and reverse
dependency rebuilds.
  * **sboinstall**: Install SlackBuilds with their dependencies; handle compat32 packages and build from templates.
  * **sboremove**: Interactively remove installed SlackBuilds along with any unused dependencies.
  * **sboupgrade**: Upgrade previously-installed SlackBuilds.

Features include dependency handling, using a custom git branch for the upstream repository, reverse dependency search and rebuild, batch mode, gpg verification and more. See **sbotools(1)** or **sbotool(1)** for a startup guide.

Script maintainers may be interested in the **[sbotest](https://github.com/pghvlaans/sbotest)** companion package for convenient reverse dependency build testing.

This repository is an **sbotools** revival, and was forked from the [pink-mist repository](https://github.com/pink-mist/sbotools), which covered development from version 0.1 through version 2.7. A debt of gratitude is owed to the original author, Jacob Pipkin, longtime maintainer Andreas Guldstrand and major contributor Luke Williams. This software would not exist without their efforts.

To make **sbotools** packages from the master branch, see [sbotools-git-slackbuild](https://github.com/pghvlaans/sbotools-git-slackbuild). For release **sbotools**, a SlackBuild is [available](https://slackbuilds.org/repository/15.0/system/sbotools/) at SlackBuilds.org.

## Most Recent Changes
#### 4.0 - 2025-10-09
  * sbofind, sboremove: Display the short description, if available
    * Note: If using a git repo, descriptions will not be found until SLACKBUILDS.TXT has been regenerated by sbocheck
  * All scripts except sboconfig: Use --wrap and --nowrap to turn word wrapping on and off
  * Added sbotool, a dialog-based front-end
  * Added a setting DIALOGRC to specify a dialogrc file for sbotool
    * Thanks to SCerovec for the suggestion
  * sboinstall: Added --template-only to create a template without building
  * sbofind: Add --raw (matches only) and --descriptions (also search descriptions)
  * Repo.pm: Always generate SLACKBUILDS.TXT on 14.0 and 14.1.
  * sboinstall: --norequirements is compatible with --batch and --dry-run
  * Added diagnostic message for missing script descriptions
  * Bugfix: sbohints properly acts on scripts with regex special characters in the name
  * Added Help.pm, which contains sbotool help messages
  * Bugfix: Skip GPG verification for --dry-run and --template-only when not root
  * All scripts: --help descriptions fit in an 80x25 terminal window.

#### 3.8.1 - 2025-08-28
  * Replace most grep instances
  * Simplify location finding
  * Info.pm: Only attempt repairs on known-bad info files
  * sbofind: Simplify search
  * Build.pm: Speed up rationalize_queue
  * Util.pm: Clean up hint reading; faster in()
  * Info.pm: Parse each info file only once
  * Do not kludge 32-bit on x86_64 and compat32 dependency handling
  * Pkgs.pm: Generate installed package lists only once (unless running from sbotest)
  * Build.pm: Remove obsolete subroutines
  * sbohints: Fix --query when a script both has optional dependencies and is an optional dependency; cleanup
  * Remove selected file existence checks to reduce lag (on the first run, in particular)

## Previous Changes
See [ChangeLog.md](https://github.com/pghvlaans/sbotools/blob/master/SBO-Lib/ChangeLog.md) for a record of changes from version 1.9 onward.
