# sbpkg (Full-Featured SBo Package Manager) Changelog

## Version 1.1.4 - 2025-07-03
### Fixed
- Corrected exit error codes for `KeyboardInterrupt` and `EOFError`.
- Resolved architecture detection issues for CPU and OS.
- Eliminated an issue causing an audible "beep" sound during sbpkg command execution. The beep resulted from a compatibility check sending a terminal bell signal. The check now operates silently, ensuring a quieter user experience.

## Version 1.1.3 - 2025-03-14
### Fixed
- Applied kernel version patching for installed packages.
- Added logic to skip already installed packages.
- Fixed `EOFError` handling for input methods.

## Version 1.1.2 - 2025-02-19
### Added
- Implemented copying of changes from edited `.sbo` files to the repository (contributed by Joel Carnat).
- Introduced temporary folders for each package to ensure correct installations.
- Added `pyproject.toml` file and removed `setup.py`.
- Included `kernel_version` configuration to exclude kernel version from package versioning.
- Added variable alignment size for the package upgrade view.
- Enabled user selection of packages for upgrades.
- Separated packages and their dependencies for improved management.

### Fixed
- Corrected traceback display for `KeyboardInterrupt`.

## Version 1.1.1 - 2024-10-14
### Added
- Added support for Git mirrors.

## Version 1.1.0 - 2024-05-26
### Fixed
- Resolved `KeyError` for non-existent packages.
- Enabled display of repository `ChangeLog.txt` using the `--repo-clog` command.

### Changed
- Disabled GPG verification by default.

## Version 1.0.9 - 2024-05-07
### Changed
- Enhanced code quality.
- Improved handling of circular dependencies.

### Fixed
- Addressed `pylint` errors.

### Bugfixes
- Fixed the `-x` option argument handling.

## Version 1.0.8 - 2024-04-01
### Changed
- Added support for blacklisting installed packages.

## Version 1.0.7 - 2024-04-01
### Bugfixes
- Fixed package version comparison for the `-current` version during upgrades.
- Enabled package installation post-upgrade with the `--upgrade` option.

## Version 1.0.6 - 2024-03-22
### Changed
- Removed test print statements from the codebase.

## Version 1.0.5 - 2024-03-20
### Added
- Implemented process logging for `install` and `remove` commands.

### Changed
- Updated `lftp` options to delete local folders not present on the remote server.
- Enabled direct repository updates when new entries are found in `ChangeLog.txt`.

### Bugfixes
- Corrected total file size calculation for the `remove` command.
- Fixed process error status exit codes.

## Version 1.0.4 - 2024-03-12
### Changed
- Updated the configuration file structure.
- Improved command version information display.

## Version 1.0.3 - 2024-03-12
### Added
- Included total source count for downloads.
- Added support for `-current` Slackware users.

### Changed
- Enhanced CLI help and manpage documentation.

## Version 1.0.2 - 2024-03-11
### Added
- Introduced `reinstall` command for Slackware packages.
- Added `--exclude-pkgs=<packages>` option.

### Changed
- Improved the command-line help menu.

## Version 1.0.1 - 2024-03-11
### Bugfixes
- Fixed `ChangeLog.txt` verification during fresh installations.

## Version 1.0.0 - 2024-03-09
### Added
- Released version 1.0.0 (Beta 1).