# slpkg ChangeLog

## Version 5.4.5 - 05-Oct-2025
### Added
- **Added Aliases**: Implemented aliases (shortcuts) for all major commands (e.g., i for install, u for update, b for build, d for download, s for search) to significantly improve CLI efficiency and user experience.

## Version 5.4.4 - 09-Sep-2025
### Added
- **Enhancement: slpkg upgrade now suggests new packages**: The slpkg upgrade command has been enhanced to be more comprehensive. In addition to listing packages with available updates, it now identifies and presents new packages that have been added to the repositories since the last database update but are not currently installed on the system. These new packages are clearly marked with an "Add New Package" label in the terminal selector, allowing users to select and install them alongside regular package upgrades in a single, streamlined process.

### Fixed
- **Bug Fix: Corrected incomplete dependency resolution**: This release fixes a critical bug in the dependency resolution logic of the dependencies.py and required.py modules. Previously, the system would fail to correctly identify and include all required transitive dependencies for a package, leading to incomplete dependency lists.

## Version 5.4.3 - 28-Jul-2025
### Fixed
- **Fix: SyntaxError in terminal_selector.py f-string for older Python versions**: Addressed a SyntaxError: f-string: expecting '}' that occurred in slpkg/terminal_selector.py (specifically line 244) when running with older Python versions (e.g., Python 3.9). This error was caused by nested double quotes within an f-string expression. Modified the problematic f-string to use single quotes for the nested expression (' ' * balance_length) instead of double quotes. This ensures broader compatibility of the slpkg application across various Python 3.x environments, including those where the f-string parser is less forgiving of nested quote types. Newer Python versions (e.g., 3.12+) are not affected by this specific parsing issue, but the fix maintains compatibility. (Thanks to KB_SBo)

## Version 5.4.2 - 27-Jul-2025
### Added
- **Added SLACK_TESTING Repository**: This update includes a new repository configuration in repositories.toml, providing direct access to the official Slackware testing tree. This addition was made in response to a user request on the linuxquestions.org forum, highlighting the community's need for easier access to testing packages. This repository points to the slackware64-current/testing/ mirror, which contains packages currently under development and testing for the next stable release of Slackware. By default, this repository is ENABLE = false to ensure system stability for most users. Users must explicitly enable it in their repositories.toml file if they intend to use it. (Thanks to marav)
- **Added COSMIC Repository**: This update introduces a new repository configuration in repositories.toml for the COSMIC Desktop Environment, a work-in-progress desktop environment. This addition caters to users interested in testing and contributing to the development of COSMIC on Slackware.  A new entry [COSMIC] has been added to the repositories.toml file. This repository points to https://slackware.uk/cosmicde/x86_64/, providing access to packages related to the COSMIC desktop environment. COSMIC is a new desktop environment under active development. This repository allows users to install and test the latest builds of COSMIC on Slackware -current. This repository is specifically based on Slackware -current. Users are advised to enable it only if they are running a Slackware -current installation to avoid potential compatibility issues. (Merge Request: !121)

## Version 5.4.1 - 23-Jul-2025
### Added
- **`--dialog` (`-D`) Option Across Package Commands**: This update significantly enhances user interaction by extending the --dialog option's availability to all commands that involve package selection or management. This provides users with a choice between the traditional terminal selector and a dialog-based interface for interactive package selection instead to terminal selector. The --dialog (-D) option can now be used with the following commands: build, install, remove, download, list, info, search, dependees, and tracking.
- **Sorted Package Display in Terminal Selector**: The list of packages presented to the user in the terminal selector (when the dialog option is not active) is now consistently sorted alphabetically (not dependency lists). This is achieved by applying self.match_packages = sorted(self.match_packages) before the TerminalSelector is initialized. Sorting the package list makes it significantly easier for users to navigate and locate specific packages, especially in scenarios involving a large number of matching results. This improves the overall efficiency and user-friendliness of interactive package selection.

## Version 5.4.0 - 21-Jul-2025
### Added
- **Dialog option to upgrade command**: Added `--dialog` option to enable text-based graphical user interfaces (TUI) for interactive prompts when available.
- **Terminal selector: Enhanced Visual Feedback**: The "pick" character (the asterisk * for selected items) now uses a yellow foreground color when terminal colors are enabled, providing clearer and more immediate visual feedback for selected items. A distinct > character is now used as a prefix for the currently highlighted item, improving visual distinction and guiding the user's focus. This prefix is dynamically applied based on the cursor's position.
- **Tab Key for Select/Deselect All**: This update introduces a new keyboard shortcut to enhance usability within the interactive terminal selector. Tab Key Functionality (\t): Users can now press the Tab key to quickly select or deselect all available items in the list.
- **Added --pager Command-Line Option**: A new command-line option, --pager (or its short form, -R), has been introduced. When this option is used, the output of the command will be piped through a terminal pager, enabling interactive scrolling, searching, and navigation of the content. This is particularly useful for viewing large outputs that exceed the terminal's visible lines.
- **Configurable Pager via slpkg.toml**: The specific pager command to be used can now be configured by setting the PAGER variable in your slpkg.toml file (e.g., PAGER = "less -R" or PAGER = "most"). If the PAGER variable is not defined in the configuration, less -R will be used as the default. The -R option for less ensures that ANSI color escape sequences are correctly interpreted, preserving color formatting in the output.
- **Improved changelog.py Output Handling**: The display_changelog method in changelog.py has been updated to conditionally use the configured pager. If the --pager option is enabled, the changelog content is streamed to the pager. Otherwise, the content is printed directly to standard output, maintaining compatibility for users who prefer non-paginated output. This change also addresses pylint and mypy warnings by using subprocess.Popen with a with statement for robust resource management.
- **Configurable Editor via slpkg.toml**: The default text editor used for file editing operations can now be specified by setting the EDITOR variable in your slpkg.toml configuration file (e.g., EDITOR = "vim"). If this variable is not explicitly set in slpkg.toml, the system will fall back to checking the EDITOR environment variable.
- **New --edit Option for install and build commands**: This option opens the target SlackBuild file in the user's configured editor (specified by the editor configuration setting) just before the build process begins, allow the user to make changes.
- **New option `--repo-tag` (`-T`) for build/install commands**: Allows users to set a specific repository tag for SlackBuild scripts. This tag helps distinguish custom builds from other sources. The option expects a tag value (e.g., `_custom`) and is applied before a build operation, exclusively to SlackBuilds from supported repositories.

## Version 5.3.9 - 18-Jul-2025
### Fixed
- **Addressed a ValueError occurring during package removal or upgrade processes**: This error was triggered when the 'ok' string, indicating a user selection, was erroneously interpreted as a numerical value during conversion to an integer. The fix ensures correct handling of user input.

### Added
- **Added --edit option**: A new global option, --edit (or -e), has been introduced. This option allows users to open relevant files (e.g., changelog entries, configuration files) directly with the system's default text editor. This enhances user convenience by providing a quick way to modify content without manually locating and opening files.
- **Added --edit option to config command**: The config command now supports the --edit (or -e) option. This allows users to directly open the slpkg.toml configuration file using the system's default text editor even if the dialog is enabled. This provides a convenient and quick way to manage and modify slpkg settings.
- **Comprehensive Logging Implemented Across All Modules**: This release marks the completion of a significant refactoring effort to integrate robust logging capabilities throughout the application. This comprehensive logging implementation significantly enhances the diagnostic capabilities and
overall stability of the slpkg application.
- **New: Configurable Logging Level**: The application's logging verbosity can now be controlled via the LOGGING setting in the slpkg.toml configuration file. Users can specify the desired logging level (e.g., "DEBUG", "INFO", "WARNING", "ERROR", "CRITICAL") to tailor the amount of detail written to the log file, aiding in troubleshooting and normal operation. The default logging level remains "INFO" if not explicitly set in the configuration.
- **Added --debug / -d Command-Line Option**: A new command-line option, --debug (or its shorthand -d), has been added to all slpkg commands. This option allows users to directly set the logging level to DEBUG from the command line, overriding any logging_level configuration specified in slpkg.toml. This provides a convenient way to enable verbose logging for troubleshooting without modifying the configuration file.

### Updated
- **Refactored slackbuild.py for Single Responsibility Principle (SRP)**: The slackbuild.py module has undergone significant refactoring to adhere more closely to the Single Responsibility Principle (SRP). Previously, the Slackbuilds class handled a multitude of responsibilities, including dependency resolution, source preparation, downloading, building, installing, and cleanup. The main Slackbuilds class now acts as an orchestrator, coordinating the actions of these specialized components, leading to a more robust and modular codebase.
- **install.py Module: Implementation with SRP and Logging**: The install.py module, responsible for downloading and installing binary packages with their dependencies, has been refactored to better adhere to the Single Responsibility Principle (SRP) and now includes comprehensive logging.

## Version 5.3.8 - 15-Jul-2025
### Fixed
- **Terminal Selector Scrolling for Large Lists**: We've completely overhauled the Terminal Selector to properly handle scrolling for large lists. Previously, when listing many items (e.g., 1700+ packages), the display would break, with the highlight getting stuck at the top of the terminal while the actual selection was far off-screen. Now, the selector uses a viewport system that only displays the items currently visible on your screen. Moving with arrow keys or Page Up/Page Down will smoothly scroll through the list, ensuring the highlighted item is always in view. This makes navigating even massive lists much more intuitive and stable.

## Version 5.3.7 - 13-Jul-2025
### Fixed
- **AttributeError**: 'Repositories' object has no attribute 'sbo_branch' (Thanks to marav)
- **Empty Package Selection Crash**: Resolved an issue where the package removal process would crash with a ValueError: max() iterable argument is empty if no packages or dependencies were found or selected for removal. The application now handles this scenario gracefully.
- **Upgrade Package Selection**: Resolved an issue that prevented the TerminalSelector from correctly displaying or allowing selection of packages during the upgrade process.

### Updated
- **Improved: Version Check Mechanism**: The self-update check now uses pyproject.toml instead of CHANGELOG.md to determine the latest available version. This change leverages the more stable and structured nature of pyproject.toml for version information, leading to more reliable and consistent update checks.

## Version 5.3.6 - 06-Jul-2025
### Added
- **New Feature: changelog Command**: A new changelog command has been added, allowing users to view the changelog for a specified repository. Users can now display the full changelog by running slpkg changelog -o repository_name. Additionally, the command supports a --query (or -q) option to filter changelog entries by a specific search term, such as a package name, keyword, version, or date.
- **Enhanced Bash and Zsh Completion**: The full command-line completion implementation for both Bash and Zsh is now complete. This significantly improves your command-line experience by offering auto-completion not just for slpkg commands, but also for repository package names, making package management even faster and more intuitive on your preferred shell.

## Version 5.3.5 - 05-Jul-2025
### Fixed
- **Fix: Permission Denied Error for Log Files**: This release addresses a PermissionError: [Errno 13] Permission denied issue that occurred when slpkg attempted to write or unlink the error.log file in /var/log/slpkg/ while running as a non-root user. Previously, the application would always try to manage log files in the system-wide /var/log/ directory, which requires root privileges. This caused errors for users running slpkg without root privileges.

## Version 5.3.4 - 01-Jul-2025
### Fixed
- **Fix KeyError**: Improved data access reliability by fixing an underlying KeyError during description lookup and search command.

## Version 5.3.3 - 30-Jun-2025
### Updated
- **Improved Progress Indicator**: We've enhanced the user experience during updates! The "Checking for news" progress indicator now transitions smoothly from the spinning animation to a clear "Done" message, ensuring a cleaner and more intuitive visual feedback for completed tasks.

### Fixed
- **Fix KeyError**: Improved data access reliability by fixing an underlying KeyError during description lookup and search command.
- **Fix error logging initialization**: Corrected an issue where log messages were not being written to the error log file (`/var/log/slpkg/error.log`). This was due to `logging.basicConfig()` being called multiple times within the application. The `logging` module's `basicConfig()` method is designed to configure the root logger only once. Subsequent calls are ignored, preventing the file handler from being correctly set up. The fix involved removing redundant `logging.basicConfig()` calls, ensuring the primary configuration in `main.py` is the sole one, thereby allowing error messages to be persistently logged as intended.

## Version 5.3.2 - 27-Jun-2025
### Updated
- **Repository Branch Configuration**: The Git repository branch can now be specified by the user within the configuration file (e.g., [PONCE] BRANCH = 'current'). This removes the need for automatic branch detection, providing users with more control over the source repository.
- **Enhanced Security**: slpkg now enforces root privileges for critical commands like install, build, and update etc. This ensures that system-level changes are only performed by authorized users, preventing accidental or malicious modifications.
- **Improved User Experience**: Commands that don't require system-level access, such as info, search, list etc, can still be executed without root privileges, allowing for easy package exploration and management.

### Added
- **Expanded Search & List Functionality**: A new --desc option has been added to the search and list commands. This allows users to include the package description in the output, providing more comprehensive information at a glance.

### Fixed
- **Corrected an issue**: Where package descriptions were not being properly stored in the database during the installation process.

## Version 5.3.1 - 24-Jun-2025
### Updated
- **Type Annotations**: Corrected various type annotation inconsistencies across the codebase to improve readability, maintainability, and static analysis.
- **Argument Parsing**: Migrated `slpkg_new-configs.py` to use Python's `argparse` module for command-line argument handling, replacing manual `sys.argv` parsing with a robust, standardized approach.

### Fixed
- **Updated CLI Usage Message**: The primary usage message displayed when invoking slpkg without arguments, or with --help, has been refined for clarity and consistency. Previously, it incorrectly indicated <COMMANDS>, suggesting multiple commands could be used simultaneously. It has now been corrected to Usage: slpkg <COMMAND> [PACKAGES] [OPTIONS] to accurately reflect that only a single command is executed at a time. This minor adjustment improves user guidance and aligns with standard command-line interface conventions. 

## Version 5.3.0 - 16-Jun-2025
### Fixed
- Corrected source download counting for SlackBuilds repositories (sbo and ponce).
- Improved type annotations for enhanced static analysis and code clarity.
- Resolved all static type checking errors reported by `mypy` to improve code quality and reliability.
- Implemented a singleton pattern for the `Configs` class to ensure `config.py` is read only once, preventing redundant file reads and performance overhead.

### Added
- **Configuration Validation**: Added validation to ensure settings in `slpkg.toml` are of the correct data type.
- **New Repositories**: Added support for `d2slack` and `slackdce` repositories, as requested by LU9DCE (#191).
- **Version Checking**: Introduced functionality to check for new versions of `slpkg`, notifying users of available updates.
- **Manual Package Selection**: Enabled manual package selection via command-line input when the graphical dialog is disabled.
- **Editor Fallback**: Configuration file editing (`/etc/slpkg/slpkg.toml`) now uses the `EDITOR` environment variable if the interactive dialog interface is unavailable.
- **Color Option**: Added `--color` option to control colored output explicitly, allowing users to enable or disable it regardless of terminal detection.
- **Dialog Option**: Added `--dialog` option to enable text-based graphical user interfaces (TUI) for interactive prompts when available.

### Updated
- Migrated command-line argument handling to Python's `argparse` module, reducing codebase size and complexity by approximately 40%, improving maintainability and performance. **Note**: This may alter command-line argument behavior; review `slpkg help` for updated usage details.
- Disabled CLI color output by default for better compatibility across terminal emulators.
- Disabled ASCII-only character output by default to enhance display consistency.
- Removed borders and additional color schemes to improve terminal compatibility and reduce rendering overhead.
- Renamed `--view` command to `info` for a more descriptive name.
- Made `python-dialog` an optional dependency, with fallback to command-line selectors if not installed.

## Version 5.2.5 - 24-Apr-2025
### Fixed
- Resolved unbound local variable issues.
- Removed unused variables.
- Fixed incompatible type assignments.
- Eliminated unnecessary repository data loading for installed packages and `find` command.
- Added support for ASCII emoji in terminal output.

## Version 5.2.4 - 18-Apr-2025
### Updated
- Added autodetection for CPU and OS architecture.
- Set default options for `aria2` with `-c` flag.

### Fixed
- Ensured verification of `data.json` database file existence.

## Version 5.2.3 - 07-Apr-2025
### Fixed
- Resolved bug with accessing local variable `deps_logs` (#189).

### Added
- Introduced `aria2` as an alternative downloader.

## Version 5.2.2 - 01-Apr-2025
### Fixed
- Fixed `EOFError` in input method.
- Limited `sbosrcarch` repository to `ponce` and `sbo` only.

### Updated
- Added comments to `slpkg.toml`, `repositories.toml`, and `blacklist.toml` configuration files.
- Updated manpage text instructions.

### Added
- Added `sbosrcarch` mirror as an alternative download source for `sbo` and `ponce` repositories.

### Removed
- Removed outdated French manpage.

## Version 5.2.1 - 28-Feb-2025
### Added
- Introduced `cli.py` module.

## Version 5.2.0 - 19-Feb-2025
### Added
- Added color-coded options for upgrading or adding new packages.
- Included a message for moving packages to the `tmp/` directory.
- Added `BOOTLOADER_UPDATE` configuration to execute a command.

### Updated
- Renamed temporary binary package directory.

### Fixed
- Prevented execution without root privileges.

## Version 5.1.9 - 13-Feb-2025
### Updated
- Enhanced code quality with improved type annotations and docstrings.

### Fixed
- Corrected source download counter for the `download` option.
- Fixed `KeyError` during package removal.

## Version 5.1.8 - 24-Jan-2025
### Fixed
- Resolved `AttributeError: 'PosixPath' object has no attribute 'endswith'` (thanks to marav).

## Version 5.1.7 - 18-Jan-2025
### Fixed
- Sorted package lists for upgrades and new installations.
- Removed kernel version from package versions during upgrades (thanks to marav).
- Corrected detection of built packages in the `/tmp` folder.

## Version 5.1.6 - 29-Oct-2024
### Added
- Added warning message for kernel upgrades.

### Fixed
- Fixed newline issue at process completion.

## Version 5.1.5 - 06-Oct-2024
### Updated
- Improved searching for installed packages by repository.

## Version 5.1.4 - 29-Sep-2024
### Fixed
- Fixed auto-update for Git repositories.

## Version 5.1.3 - 26-Sep-2024
### Fixed
- Corrected ASCII character handling for `done` and `failed` statuses.

### Updated
- Modified the upgrade method to prioritize adding new packages.

### Added
- Added support for Git repositories.
- Included completion time for updates.

## Version 5.1.2 - 22-Aug-2024
### Fixed
- Fixed upgrades when the `new_packages` method is enabled.

## Version 5.1.1 - 22-Jul-2024
### Added
- Added `installed` tag for installed packages in the `search` command.
- Introduced `--fetch` option to identify the fastest and slowest mirrors.

### Fixed
- Fixed creation of custom repositories (thanks to mac-a-r0ni).
- Resolved `OSError: [Errno 24] Too many open files` for parallel downloads (thanks to rizitis).

## Version 5.1.0 - 06-Jun-2024
### Added
- Introduced `PACKAGE_METHOD` configuration to select the upgrade method.
- Added `DOWNGRADE_PACKAGES` configuration to allow package downgrades (thanks to marav).
- Added `PACKAGE_TYPE` configuration for custom binary types.
- Replaced `tomli` and `tomllib` with `python3-tomlkit` for `-current`.

### Updated
- Improved invalid package version messages.
- Converted `upgrade.log` to JSON format.
- Separated process bar from the progress bar.

## Version 5.0.9 - 23-May-2024
### Added
- Added informative message for invalid package versions with the `upgrade` command.
- Added configuration to delete sources after building or installing packages.

## Version 5.0.8 - 10-May-2024
### Added
- Enabled viewing packages with missing dependencies by repository (thanks to rizitis).

### Updated
- Moved `NEW_PACKAGES` and `REMOVE_PACKAGES` configurations to `repositories.toml`.

### Removed
- Removed `slackdce` repository (thanks to rizitis).

## Version 5.0.7 - 07-May-2024
### Fixed
- Replaced TOML error messages with custom error messages.
- Resolved optional dependencies for package removal.

### Updated
- Enhanced code quality.
- Improved GPG key import verification.
- Sorted `search` command output (thanks to marav).
- Updated GNOME mirror (thanks to rizitis).
- Prevented circular dependencies.

### Added
- Added total file size display for the `find` command.

## Version 5.0.6 - 19-Apr-2024
### Release Note
- Users may need to force-update local repositories before using this version.

### Updated
- Enabled reading configuration values regardless of case (lowercase or uppercase).

### Added
- Added support for custom repositories.
- Introduced `KERNEL_VERSION` configuration to handle custom SlackBuild versions.

## Version 5.0.5 - 12-Apr-2024
### Added
- Added maximum parallel download limit in the configuration file.
- Introduced `--pkg-version` option for the `search` command.
- Added file size display for the `find` command.

### Removed
- Removed support for local repositories.

### Updated
- Excluded packages from `slack_extra` repository (thanks to marav).
- Updated SalixOS mirrors.
- Updated `repositories.toml` configuration file.

### Fixed
- Fixed `BrokenPipeError: [Errno 32] Broken pipe`.
- Corrected download path for download-only operations.
- Fixed alignment in the `search` command.

## Version 5.0.4 - 04-Apr-2024
### Updated
- Ignored blacklisted installed packages.
- Updated progress bar spinners.

### Removed
- Removed `python3-progress` dependency.

### Fixed
- Fixed comparison of invalid package versions.
- Restored functionality for local repositories.

### Added
- Added extra `lftp` mirror options in the configuration file.

## Version 5.0.3 - 01-Apr-2024
### Updated
- Updated `slpkg_new-configs` and `(D)iff` command (thanks to marav).

### Fixed
- Fixed `JSONDecodeError: Expecting value: line 1 column 1 (char 0)` (thanks to marav).

## Version 5.0.2 - 30-Mar-2024
### Updated
- Improved coding style.
- Updated `tomli` import for `-current` version.
- Updated handling of "ticked on/off" packages when already up-to-date (#181).

### Fixed
- Fixed custom package upgrades (thanks to marav).
- Fixed package installation during `upgrade` command (#180).

## Version 5.0.1 - 29-Mar-2024
### Updated
- Enhanced checking of upgrade packages against all repositories (`slpkg upgrade --repository='*' --check`).

### Fixed
- Fixed package upgrades for `-current` version (thanks to marav).

## Version 5.0.0 - 24-Mar-2024
### Updated
- Implemented blacklist using regex patterns.
- Moved `check-updates` command to `--check` option.
- Renamed `--no-silent` option to `--progress-bar`.
- Set default silent mode to `false`.

### Removed
- Removed `SQLAlchemy` dependency.
- Removed `help` command; use manpage instead.
- Removed `clean-logs` and `clean-data` commands.
- Removed `rules.toml` configuration file.
- Removed `--install-data` option.
- Removed `FILE_PATTERN` from configurations.
- Removed `--jobs` option.
- Removed `spinning_bar` configuration.

### Added
- Added package upgrade checking with the `--check` option.
- Introduced `MAKEFLAGS` configuration to specify the number of jobs.
- Added support for GPG verification.
- Added `NEW_PACKAGES` configuration for `-current` users and `upgrade` command.
- Added `REMOVED_PACKAGES` configuration for `-current` users and `upgrade` command.

### Fixed
- Fixed double view message when updating repositories.
- Corrected package file size calculation for removal.

## Version 4.9.8 - 14-Feb-2024
### Added
- Added `urllib3` settings to the `slpkg.toml` configuration file.

## Version 4.9.7 - 07-Jan-2024
### Fixed
- Fixed `urllib3 KeyError: 'content-length'`.

### Updated
- Improved repository update checking.

## Version 4.9.6 - 16-Dec-2023
### Added
- Added `slackdce` repository (thanks to rizitis).

### Updated
- Switched to GNU General Public License v3 (GPLv3).

## Version 4.9.5 - 10-Dec-2023
### Fixed
- Fixed package removal with the `--yes` option.

## Version 4.9.4 - 04-Dec-2023
### Added
- Added `LFTP_EXCLUDE` option for the `lftp` command to ignore non-essential files.

## Version 4.9.3 - 28-Nov-2023
### Updated
- Enhanced `[Tracking]` to return the complete list of package dependencies.
- Improved process exit status code messages.

### Fixed
- Fixed process stderr exit code.

### Added
- Added `pprkut` repository (thanks to rizitis).

## Version 4.9.2 - 05-Aug-2023
### Updated
- Improved update checking to return repository size.
- Updated Conraid repository mirror URL.

## Version 4.9.1 - 28-Jun-2023
### Updated
- Updated bullet progress bar color.
- Changed logging path to `/var/log/slpkg/`.
- Supported package builds with `pyproject.toml` (requires `python3-build`).

### Added
- Added process log file under `/var/log/slpkg/filename_date_time.log`.
- Added process log file setting in `/etc/slpkg.toml`.

## Version 4.9.0 - 21-Jun-2023
### Updated
- Improved multilib installation instructions.

### Fixed
- Fixed repository update continuation after a failure.

## Version 4.8.9 - 06-Jun-2023
### Fixed
- Fixed `urllib3.exceptions.NewConnectionError` (#173, thanks to rizitis).

## Version 4.8.8 - 29-May-2023
### Updated
- Updated French manpage.

### Fixed
- Fixed dependency selection for upgraded packages.
- Fixed building packages with the same source name (e.g., `nvidia-driver` and `nvidia-kernel`).

## Version 4.8.7 - 23-May-2023
### Fixed
- Fixed package tags for `slack_patches` and `salixos_patches`.
- Fixed parallel downloads for SlackBuilds repositories (`sbo`, `ponce`).

## Version 4.8.6 - 21-May-2023
### Updated
- Optimized database loading (#172).

### Fixed
- Fixed `ValueError` in `search` command.
- Fixed updating packages to the same version (#169).
- Fixed `--skip-installed` option.

### Added
- Added `rules.toml` configuration file.

## Version 4.8.5 - 18-May-2023
### Fixed
- Fixed case sensitivity in `find` and `search` commands.
- Fixed combination of `--repository=` and `--directory=` options.
- Fixed `TypeError` in `repo-info` command (#171).

## Version 4.8.4 - 14-May-2023
### Added
- Added case-insensitive pattern matching with `--no-case` option.
- Enabled border color selection via configuration file.
- Added new processing status views for build, install, upgrade, and remove operations.

### Fixed
- Fixed removal of chosen dependencies.

## Version 4.8.3 - 29-Apr-2023
### Updated
- Improved synchronization with local repositories (thanks to Christopher Schrauben, #166).
- Renamed `--bin-repo` option to `--repository`.

### Added
- Added `--install-data` option to install only database data.
- Added column for package installed version (thanks to tpiszcze).

## Version 4.8.2 - 25-Apr-2023
### Updated
- Improved exit status code handling.
- Enhanced package summary for file size calculations.

### Added
- Added option to enable or disable the spinning bar.

### Fixed
- Fixed Slackware patches repository tag.
- Fixed skipping source downloads for installed packages (thanks to kingbeowulf, LQ63).

## Version 4.8.1 - 21-Apr-2023
### Updated
- Improved error messages.
- Enhanced repository updates (thanks to rizitis).
- Improved `reinstall` command for Slackware.

### Fixed
- Fixed double packages as main and dependency in binary repositories.
- Fixed package viewing for `ponce` repository (thanks to rizitis).

## Version 4.8.0 - 19-Apr-2023
### Fixed
- Fixed dependency counting for tracking and blacklisted packages.
- Fixed dependency resolution for blacklisted or excluded packages.

## Version 4.7.9 - 15-Apr-2023
### Updated
- Improved proxy configuration.
- Enhanced file size conversion.
- Optimized package upgrades.

### Fixed
- Fixed screen clearing when dialog is disabled.

### Added
- Added support for local repositories (thanks to marav).

## Version 4.7.8 - 12-Apr-2023
### Added
- Added support for Unix shell-style wildcards in blacklists (thanks to marav).
- Added proxy support (thanks to tpiszcze, #160).

### Updated
- Improved `--reinstall` option configuration (thanks to rizitis).
- Enhanced performance.

## Version 4.7.7 - 07-Apr-2023
### Updated
- Replaced multiple SQL queries to improve performance.

### Fixed
- Fixed double dependencies in binary repositories.
- Fixed package version removal.
- Fixed alignment for package name and version.

### Added
- Added `__slots__` to improve performance.
- Added removal of local repository data.

## Version 4.7.6 - 04-Apr-2023
### Fixed
- Fixed package upgrades with build numbers >= 10.

### Updated
- Added color indication for upgradable packages.
- Enabled package upgrades by repository.

### Added
- Added package lists for multilib installation.
- Added dependency detection before package removal (thanks to marav).
- Added `-y`, `--yes` flag to the `remove` command.
- Added support for `wget2` downloader.

## Version 4.7.5 - 04-Apr-2023
### Fixed
- Fixed package upgrades from repositories.

## Version 4.7.4 - 04-Apr-2023
### Fixed
- Fixed Python typing hints.
- Fixed package upgrades.

### Updated
- Improved color indication for upgradable packages during installation.

## Version 4.7.3 - 03-Apr-2023
### Fixed
- Fixed `-B` option for `-u` (update) and `-c` (check-updates) commands.
- Fixed building packages with shared sources (e.g., `nvidia-driver` and `nvidia-kernel`).
- Fixed data mirror installation for `msb`, `csb`, `salixos_extra`, and `salixos_patches` repositories.

## Version 4.7.2 - 02-Apr-2023
### Updated
- Improved package version parsing.
- Simplified `-B=` and `-z=` options to `-B` and `-z`.

### Fixed
- Fixed dependency upgrades without `-r` option.
- Fixed SlackBuild repository tag.
- Fixed file pattern `*` to find all installed files.

## Version 4.7.1 - 02-Apr-2023
### Fixed
- Fixed `TypeError: can only concatenate str (not "NoneType") to str`.

## Version 4.7.0 - 02-Apr-2023
### Updated
- Improved checks for recurring options.
- Enhanced performance and code quality.

### Removed
- Removed file pattern from CLI menu.

### Added
- Added support for binary repositories.
- Added support for sixteen binary repositories.
- Added repository information display.

## Version 4.6.1 - 15-Mar-2023
### Updated
- Improved handling of empty arguments.
- Enhanced checks for invalid options.
- Improved error messages.

### Added
- Added `vimdiff` support in the `slpkg_new-configs` command (thanks to tkor).

## Version 4.6.0 - 15-Mar-2023
### Updated
- Improved dialog text help for dependencies.
- Enhanced configuration error messages.
- Removed `-N` timestamping from `wget` options.

### Fixed
- Fixed summary for package upgrades.
- Fixed handling of `KeyboardInterrupt`.

### Added
- Added progress spinner and color selection in the configuration file.

## Version 4.5.9 - 14-Mar-2023
### Fixed
- Fixed default build path to `/tmp/slpkg/build`.
- Fixed building packages with multiple sources.

### Added
- Added `lftp` as a source file downloader.
- Added support for multiprocess downloading.
- Added configuration for parallel downloads.
- Added `--parallel` option for parallel downloads.
- Added build tag display to package views (thanks to marav).

### Updated
- Enabled upgrading packages with the same version but different build tags (thanks to marav).
- Renamed `new-configs` to `slpkg_new-configs`.

## Version 4.5.8 - 09-Mar-2023
### Updated
- Displayed repository names instead of sizes.
- Highlighted installed packages in grey.
- Removed update confirmation prompts.

## Version 4.5.7 - 07-Mar-2023
### Added
- Added support for ignoring comments in `list.pkgs` files (thanks to rizitis).
- Added file pattern configuration.
- Added `new-configs` command for managing `.new` files.
- Added support for `.sqf` files (thanks to rizitis).

### Updated
- Improved blacklist configuration file.

### Fixed
- Fixed `TypeError: '<' not supported between instances of 'str' and 'int'`.

## Version 4.5.6 - 03-Mar-2023
### Updated
- Updated `ponce` repository.
- Updated `slpkg.toml` for `ponce` repository.

### Added
- Added `--generate-only` option for `ponce` repository.
- Added `clean-data` command to delete repository data.
- Added dialog text help for items.
- Added support for reading packages from files.
- Added configuration prompts.

## Version 4.5.5 - 02-Mar-2023
### Fixed
- Fixed generator type to list return.

## Version 4.5.4 - 05-Feb-2023
### Updated
- Improved configuration messages.

### Added
- Added support for concatenating short options (thanks to marav).
- Added `help` command for additional assistance.
- Added `ponce` repository.
- Added `lftp` downloader.

### Fixed
- Fixed TOML decoder error for blacklist file.
- Fixed version comparison for dependencies (thanks to marav).

## Version 4.5.3 - 27-Jan-2023
### Added
- Added short options.
- Added new configuration for ASCII characters.

## Version 4.5.2 - 21-Jan-2023
### Fixed
- Fixed `IndexError: list index out of range`.

### Updated
- Updated manpages for options (thanks to marav).

### Added
- Added `--file-pattern` option.
- Added `curl` downloader as a secondary option.

## Version 4.5.1 - 16-Jan-2023
### Added
- Added `--directory=PATH` option for the `download` command.
- Added `--pkg-version` option to print repository version.

## Version 4.5.0 - 14-Jan-2023
### Updated
- Prioritized downloading all SlackBuilds first.
- Renamed `view_mode` to `silent_mode`.

### Added
- Added `--no-silent` option.

## Version 4.4.9 - 13-Jan-2023
### Updated
- Improved color highlighting for installed packages.

### Fixed
- Fixed package upgrades (thanks to marav).

## Version 4.4.8 - 12-Jan-2023
### Added
- Added ASCII box for checksum errors.

## Version 4.4.7 - 07-Jan-2023
### Added
- Added completion report for download-only operations.
- Added French manpage (thanks to marav).
- Added verification for file downloads.

### Updated
- Replaced `os.isdir` with `pathlib` module.

## Version 4.4.6 - 06-Jan-2023
### Updated
- Improved performance for dependency handling.

### Fixed
- Fixed build summary.

### Removed
- Removed `python-toml` dependency.

## Version 4.4.5 - 03-Jan-2023
### Added
- Added modern view mode style.
- Added progress bar.

### Updated
- Fixed MD5 sum comparison.

## Version 4.4.4 - 31-Dec-2022
### Fixed
- Fixed `AttributeError: 'PosixPath' object has no attribute 'startswith'`.
- Fixed `KeyError: 'sbo_chglog_txt'` (#LQ post6401410).

## Version 4.4.3 - 30-Dec-2022
### Updated
- Switched to `pathlib` library.

## Version 4.4.2 - 29-Dec-2022
### Updated
- Improved path handling.

## Version 4.4.1 - 28-Dec-2022
### Added
- Added `configs` command to read and edit configuration files.

## Version 4.4.0 - 23-Dec-2022
### Added
- Added command to track dependencies.
- Added `pythondialog` as a dependency.
- Added dialog support for upgrade, remove, and dependency operations.
- Added `--full-reverse` flag for dependency handling.
- Added `--search` flag to enable dialog for package selection.

## Version 4.3.9 - 22-Dec-2022
### Added
- Added feature to check `ChangeLog.txt` before updates (#153).
- Added `dependees` command.

### Fixed
- Fixed display of installed versions.
- Fixed permission denied issue (#152).
- Fixed colors and messages for upgrade and reinstall operations.
- Fixed dependency installation order.

## Version 4.3.7 - 09-Dec-2022
### Updated
- Merged `is_installed` method into utilities.

## Version 4.3.6 - 08-Dec-2022
### Fixed
- Fixed package removal.

## Version 4.3.5 - 07-Dec-2022
### Updated
- Improved code style.

### Fixed
- Fixed flag parameter handling.

## Version 4.3.4 - 02-Dec-2022
### Updated
- Removed `dataclasses` and switched to `__init__`.
- Improved version print command.

### Added
- Added version to requirements in the `view` packages command.
- Added short CLI menu.

## Version 4.3.3 - 01-Dec-2022
### Fixed
- Fixed blacklist file permissions to 0644.
- Fixed typo in `slpkg.toml` configuration file.
- Fixed `slpkg.toml` configuration handling.

### Updated
- Improved OS architecture handling in configurations.

## Version 4.3.2 - 28-Nov-2022
### Fixed
- Fixed removal of multiple packages with dependencies.

### Updated
- Switched to Python TOML for loading configuration files.

## Version 4.3.1 - 26-Nov-2022
### Added
- Added category display in the `view` command.
- Added Slackware repository version display.

### Fixed
- Fixed package removal for packages with matching names.
- Fixed installation of packages with correct SBo tags.

## Version 4.3.0 - 23-Nov-2022
### Added
- Added messages for blacklisted packages.
- Added homepage display in the `view` command.

### Updated
- Improved CLI menu.

## Version 4.2.9 - 19-Nov-2022
### Fixed
- Fixed `slpkg upgrade` failure when a package is blacklisted (#149).

### Updated
- Moved `%README%` to the blacklist.

### Added
- Added maintainer information in the `view` command (#150).

## Version 4.2.8 - 06-Nov-2022
### Updated
- Ensured verification of SBo script existence before patching the tag.

## Version 4.2.7 - 05-Nov-2022
### Fixed
- Switched to checking `ChangeLog.txt` files by size.

## Version 4.2.6 - 03-Nov-2022
### Fixed
- Fixed verification of `ChangeLog.txt` file existence.

## Version 4.2.5 - 01-Nov-2022
### Added
- Added command to check for news in `ChangeLog.txt`.

### Updated
- Updated manpage.

## Version 4.2.4 - 30-Oct-2022
### Added
- Added patching of SBo TAG from the configuration file.
- Added downloading of SlackBuild scripts in the `view` command.

### Updated
- Improved CLI help menu.

## Version 4.2.3 - 28-Oct-2022
### Updated
- Ensured creation of all necessary paths from the configuration file.
- Improved log cleaning and dependency viewing.

### Added
- Added verification for database file existence.
- Added check for package existence in the database before upgrades.

## Version 4.2.2 - 20-Oct-2022
### Updated
- Removed version checking for `--skip-installed` option.
- Removed unused configurations.
- Renamed `search` command to `view`.

### Added
- Added new `search` command to search and match packages from repositories.

## Version 4.2.1 - 18-Oct-2022
### Added
- Added printing of README file in the `search` option.

### Updated
- Improved configurations for SBo repository.

## Version 4.2.0 - 14-Oct-2022
### Updated
- Moved `--download-only` option to commands.
- Ensured `upgrade` commands work with all options.

## Version 4.1.9 - 14-Oct-2022
### Added
- Added `--download-only` option.

## Version 4.1.8 - 06-Oct-2022
### Updated
- Updated manpage for `.yaml` files.

### Added
- Added `--skip-installed` option.

## Version 4.1.7 - 28-Sep-2022
### Fixed
- Fixed creation of `/var/lib/slpkg` directory.

## Version 4.1.6 - 26-Sep-2022
### Added
- Added missing configs folder to repository.

## Version 4.1.5 - 09-Sep-2022
### Updated
- Renamed configuration files to `.yml`.

### Fixed
- Fixed version display for `noarch` packages.

## Version 4.1.4 - 17-Jul-2022
### Added
- Added `setup.cfg` file.
- Added option to upgrade SBo packages.

## Version 4.1.3 - 26-Jun-2022
### Fixed
- Fixed `/tmp` permissions after installation.

### Updated
- Improved detection of installation binary files in `/tmp`.

## Version 4.1.2 - 24-Jun-2022
### Fixed
- Fixed installation of `noarch` packages.

## Version 4.1.1 - 23-Jun-2022
### Updated
- Improved CLI menu view with colors.
- Switched to YAML configurations.

### Added
- Added unit tests.
- Added `clean-tmp` command to delete downloaded sources from `/tmp/slpkg`.
- Added `find` command for installed packages.

## Version 4.1.0 - 20-Jun-2022
### Updated
- Rewrote `slpkg` code from scratch, supporting only the SBo repository.

## Version 4.0.2 - 13-Jun-2022
### Fixed
- Fixed database library path.

## Version 4.0.1 - 30-May-2022
### Added
- Added `SQLAlchemy` Object Relational Mapper.

## Version 4.0.0 - 29-May-2022
### Added
- Replaced `sqlite3` database with SBo repository.
- Added `python-progress` as a dependency.

## Version 3.9.9 - 24-May-2022
### Updated
- Improved stderr error output for auto-install packages.

## Version 3.9.8 - 12-May-2022
### Fixed
- Fixed `TypeError` for `--repos=` flag.

### Updated
- Switched SlackBuild script to Bash shell.

## Version 3.9.7 - 09-May-2022
### Fixed
- Fixed stderr error output.

### Updated
- Improved dependency resolution speed.
- Renamed `--repositories` to `--repos` flag.
- Fixed updating custom repositories.
- Fixed manual repository passing.

## Version 3.9.6 - 02-Apr-2022
### Updated
- Improved package version comparison during distribution upgrades.

## Version 3.9.5 - 02-Apr-2022
### Fixed
- Fixed `ONLY_INSTALLED` configuration variable when enabled.

## Version 3.9.4 - 26-Mar-2022
### Fixed
- Fixed virtual environment check before execution.

## Version 3.9.3 - 13-Feb-2022
### Updated
- Fixed installation crash when no `TESTING` file is present.

## Version 3.9.2 - 06-Feb-2022
### Updated
- Updated Slackware mirrors.
- Updated copyright year.
- Removed `urllib3` dependency, as it is now part of Slackware.

## Version 3.9.1 - 01-Jan-2021
### Updated
- Updated copyright year.

### Fixed
- Fixed `--checklist` and `resolve-off` flags (#129).
- Fixed custom repository handling.

## Version 3.9.0 - 21-Jun-2020
### Fixed
- Fixed `--checklist` flag compatibility with `--upgrade` option.

## Version 3.8.9 - 03-Jun-2020
### Fixed
- Fixed Slackware distribution `--upgrade` flag.

## Version 3.8.8 - 20-May-2020
### Fixed
- Fixed variable name for patches upgrade option.

## Version 3.8.7 - 01-Apr-2020
### Fixed
- Fixed `--checklist` flag functionality for versions 3.8.1 to 3.8.6 (#127).

## Version 3.8.6 - 22-Mar-2020
### Fixed
- Fixed `pkg_not_found` message function arguments.

## Version 3.8.5 - 05-Mar-2020
### Added
- Added `set export variable $TAG` (#126).

## Version 3.8.4 - 25-Feb-2020
### Fixed
- Fixed retrieval of MD5SUM from incorrect info file returning `None`.

### Updated
- Updated Slackware mirrors.

## Version 3.8.3 - 21-Feb-2020
### Fixed
- Fixed package counting for binary repositories.

### Added
- Added proxy server support.

## Version 3.8.2 - 15-Feb-2020
### Fixed
- Fixed SBo repository package and version viewing.
- Fixed `msb` repository `PACKAGES.txt` file.
- Fixed distribution upgrades with `-c`, `--check` option.

### Added
- Added multi-package management in blacklist files.

## Version 3.8.1 - 13-Feb-2020
### Fixed
- Fixed double installation from Slackware regular repository and patches directory (#122).

### Updated
- Removed status progress bar.
- Improved setup and installation processes.
- Simplified blacklist management.

## Version 3.8.0 - 05-Feb-2020
### Added
- Rewrote significant portions of the code to support Python 3, with potential for future bug fixes.

### Fixed
- Fixed merging files with Slackware repository for current and Slack versions.

### Updated
- Improved code for Python 3 compatibility.

## Version 3.7.4 - 20-Dec-2019
### Fixed
- Fixed `UnicodeDecodeError: 'utf-8' codec can't decode byte`.

## Version 3.7.3 - 11-Dec-2019
### Fixed
- Fixed Slackware-current handling for Alien Bob’s 20191130 release (#119).
- Improved repository update class method calls.
- Replaced `requests` dependency with `urllib3`.
- Improved code style for Python 3 compatibility.

## Version 3.7.2 - 06-Dec-2019
### Fixed
- Fixed handling of `ConnectionError` in `requests`.

## Version 3.7.1 - 03-Dec-2019
### Updated
- Updated `pythondialog` dependency.
- Updated Slackware mirrors.
- Improved `pip` installation method.
- Enhanced `setup.py` for Python 3.
- Improved `print` function for Python 3 format.

### Added
- Replaced built-in `urllib` with `python-requests` dependency.

## Version 3.7.0 - 01-Dec-2019
### Updated
- Switched to Python 3.

## Version 3.4.3 - 19-May-2019
### Updated
- Updated `gen_repos_files.sh` to version 1.94.

### Fixed
- Fixed downloader recognition of `+` character.
- Fixed building from sources with `+` in names.

## Version 3.4.2 - 23-Jan-2019
### Fixed
- Fixed deletion of build folder in network option.

## Version 3.4.1 - 23-Jan-2019
### Fixed
- Fixed manpage.

## Version 3.4.0 - 21-Jan-2019
### Updated
- Updated manpage.
- Converted examples, repositories, and install text files to Markdown format.
- Merged `sbo/remove.py` into `slpkg/remove.py`.

### Fixed
- Fixed updating `slpkg` from the GitLab repository.

### Added
- Added `clean-tmp` command to remove packages and sources from `/tmp/slpkg/`.
- Added support for `elilo` and `grub` bootloader upgrades after kernel upgrades.
- Added viewing and removal of third-party packages.
- Added file size display for removed packages.

## Version 3.3.9 - 14-Jan-2019
### Updated
- Updated README and added example text file.
- Improved checklist error messages.
- Removed unnecessary `ALL` arguments.

### Added
- Added support for `elilo` and `grub` bootloader upgrades.
- Added viewing and removal of third-party packages.
- Added file size display for removed packages.

## Version 3.3.8 - 09-Jun-2018
### Fixed
- Fixed `aria2c` download path for optional downloader.

### Updated
- Switched to GitLab repository.

## Version 3.3.7 - 22-Apr-2018
### Fixed
- Fixed downloading `v3.3.6.tar.gz` file (#109).

## Version 3.3.6 - 21-Apr-2018
### Fixed
- Fixed `pip` install with logo printing (#106).

## Version 3.3.5 - 01-Apr-2018
### Fixed
- Fixed `pip` install failure (#106).

### Updated
- Updated Slackware mirrors.

## Version 3.3.4 - 10-Jan-2018
### Added
- Added file size display per package for `-f`, `--find` option.

## Version 3.3.3 - 01-Jan-2018
### Updated
- Updated `README.rst` for Python modules.
- Temporarily removed Python 3 support until the next Slackware release.
- Updated Slackware mirrors.

## Version 3.3.2 - 21-Oct-2017
### Fixed
- Fixed dependency issues (#97).
- Updated `msb` repository to version 1.18.

### Updated
- Updated Slackware mirrors.

## Version 3.3.1 - 07-Oct-2017
### Added
- Added Slackware version setting via `/etc/slpkg/slpkg.conf`.
- Added computer architecture setting via `/etc/slpkg/slpkg.conf`.

## Version 3.3.0 - 01-Oct-2017
### Fixed
- Fixed `TypeError: stat() argument 1 must be encoded string without null bytes, not str` (#100).
- Fixed file script check before build (`IOError: [Errno 2] No such file or directory`).

## Version 3.2.9 - 24-Sep-2017
### Fixed
- Fixed dependency issues (#97).

### Added
- Added support for `patches/` directory in Slackware repository (#98).

## Version 3.2.8 - 06-Aug-2017
### Fixed
- Fixed package return after build.

### Updated
- Improved build error messages.

## Version 3.2.7 - 09-Apr-2017
### Updated
- Updated Alien’s repositories (`alien`, `ktown`, `multi`) (#83, thanks to travis-82).
- Updated Rworkman’s repository (`rlw`) (#83).
- Added package security messages for network and SBo repositories.

### Added
- Added `sbosrcarch` as a secondary repository for source files (#82, thanks to travis-82).
- Added rebuilding of SBo packages during upgrades (#85, thanks to bhreach).

## Version 3.2.6 - 22-Feb-2017
### Updated
- Improved configuration file pattern.

### Added
- Added support for special packages requiring attention (e.g., OpenGL 32-Bit Libs after upgrade, #81, thanks to Edward W. Koenig and Inukaze).
- Added `pkg_security` configuration file.

## Version 3.2.5 - 17-Feb-2017
### Updated
- Updated URL for `mles/mled` repository (thanks to Kiki Novak).
- Switched to `i586` architecture for SBo repository.
- Disabled progress bar by default.

### Fixed
- Fixed exit codes (#73, #79).

## Version 3.2.4 - 10-Feb-2017
### Updated
- Switched SlackBuild script to `i586` architecture.
- Renamed `slackr` repository to `conraid`.
- Updated `MATE` repository to support Slackware `-current` x86_64.

### Added
- Added `Cinnamon` repository.
- Added `Connochaetos` (slack-n-free) repository.
- Added `Microlinux` repositories (`desktop`, `server`, `extras`).

### Fixed
- Fixed package list upgrades.
- Fixed `MATE` repository update checks.

## Version 3.2.3 - 07-Feb-2017
### Updated
- Updated copyright year.
- Updated Slackware mirrors.

### Fixed
- Fixed package list updates after fresh installation (`IOError: [Errno 2] No such file or directory`).

## Version 3.2.2 - 26-Oct-2016
### Added
- Added Python 3 support with `2to3` tool.
- Added building and installation with Python 3.

## Version 3.2.1 - 25-Oct-2016
### Fixed
- Fixed exit code return when packages for installation are not found (#73).

## Version 3.2.0 - 19-Oct-2016
### Added
- Added `rlworkman.deps` dependency configuration file.

### Fixed
- Fixed `IndexError: list index out of range` for tracking arguments.

### Updated
- Updated Rworkman’s (`rlw`) repository dependencies for Slackware 14.2.

## Version 3.1.9 - 17-Oct-2016
### Updated
- Switched to version 1.16 for `msb` repository.

### Fixed
- Fixed dependency resolution for binary repositories.
- Fixed dependency removal for binary repositories.

### Removed
- Removed `studioware` binary repository due to switch to SlackBuild type.

## Version 3.1.8 - 11-Oct-2016
### Added
- Added rebuilding of SBo packages and reinstallation of binary packages.
- Added Slackware package management tools (thanks to Thomas Szteliga, #71).

### Fixed
- Fixed repository error message display without usage.
- Fixed package counting in `deps-status` option.

### Updated
- Improved help and usage messages.
- Updated Slackware mirrors.
- Merged `--deps` into `--check-deps` flag for the `remove` argument.

## Version 3.1.7 - 14-Jul-2016
### Fixed
- Fixed updating and upgrading specific repositories (#69).

## Version 3.1.6 - 06-Jul-2016
### Updated
- Updated `slackr` (Conraid’s) repository URL.
- Removed `aaa_elflibs` from blacklist.
- Updated Slackware mirrors.

## Version 3.1.5 - 26-May-2016
### Fixed
- Fixed `-l`, `--list` option compatibility with all arguments.
- Fixed `TypeError` in tracking option for binary repositories.

### Updated
- Improved code style.

## Version 3.1.4 - 11-May-2016
### Updated
- Updated `slackers.it` default repository.

## Version 3.1.3 - 15-Apr-2016
### Fixed
- Fixed handling of local SBo repositories.

## Version 3.1.2 - 24-Feb-2016
### Fixed
- Fixed `AttributeError: LooseVersion instance has no attribute 'version'`.
- Removed redundant code.

## Version 3.1.1 - 23-Feb-2016
### Added
- Added option to prevent package downgrades via configuration file.

## Version 3.1.0 - 17-Feb-2016
### Fixed
- Fixed downloading packages for x86 architecture in `slonly` repository (#59).
- Fixed continuing build and install for SBo packages with dead source links.

### Updated
- Improved status toolbar.

## Version 3.0.9 - 09-Feb-2016
### Fixed
- Fixed listing installed packages from repositories by name only (#58).
- Fixed handling of `+` character in sources.

## Version 3.0.8 - 29-Jan-2016
### Added
- Added `--name` flag in `list` option to show only package names.

### Fixed
- Fixed duplicate packages in `ktown` repository with `list` option.

## Version 3.0.7 - 26-Jan-2016
### Updated
- Improved help menu.
- Adjusted argument positions for `deps-status` with `--tree` and `--graph=` options.
- Updated Slackware mirrors.

## Version 3.0.6 - 22-Jan-2016
### Fixed
- Fixed `IndexError: list index out of range` when removing packages with `--tag` option.

### Updated
- Updated `README.rst` file.
- Improved usage and help options.
- Adjusted argument positions for `--desc`, `--network`, and `--tracking` options.
- Updated Slackware mirrors.

## Version 3.0.5 - 06-Jan-2016
### Updated
- Improved argument positioning for `queue` and `blacklist` in `--add` and `--remove` flags.
- Updated usage arguments.
- Updated file licenses.

## Version 3.0.4 - 30-Dec-2015
### Fixed
- Fixed installation of `chkrootkit` (#53).
- Prevented reinstallation of already installed binary packages.
- Fixed reference message when removing one package.

### Updated
- Updated Slackware mirrors.

## Version 3.0.3 - 01-Dec-2015
### Fixed
- Fixed upgrading/installing `nouveau` in Slackware repository (#55).

### Updated
- Updated Slackware mirrors.

## Version 3.0.2 - 19-Nov-2015
### Fixed
- Fixed string-to-float conversion error when removing packages (#52).

## Version 3.0.1 - 12-Nov-2015
### Added
- Added `--download-only` option to download packages and dependencies without installation.
- Added `--directory-prefix=` option to specify download directories.

### Fixed
- Improved code style.

## Version 3.0.0 - 15-Oct-2015
### Fixed
- Fixed checksum return for SBo repository.

## Version 2.9.7 - 09-Oct-2015
### Fixed
- Fixed finding SBo Slackware binary packages in `/tmp`.

## Version 2.9.6 - 03-Oct-2015
### Fixed
- Fixed installation failure for `nvidia-kernel` (#46).
- Fixed inconsistent version issues during builds (#48).

## Version 2.9.5 - 01-Oct-2015
### Updated
- Improved root privilege checking.
- Removed header from usage.

## Version 2.9.4 - 24-Sep-2015
### Updated
- Improved handling of `KeyboardInterrupt` in `main.py`.

### Fixed
- Fixed upgrading packages from SBo repository.
- Fixed Pylint errors and improved code health.

## Version 2.9.3 - 23-Sep-2015
### Added
- Added default repositories file for editable URLs.
- Added `--case-ins` option for case-insensitive matching in `--tracking`.

### Fixed
- Fixed case-insensitive package matching.

## Version 2.9.2 - 21-Sep-2015
### Added
- Added screen clearing in `--network` option.

### Updated
- Improved viewing of `doinst.sh` in `--network` option if present.
- Enhanced commands in `--network` option.

### Fixed
- Fixed issue with `node-0.12.7` where `uname` and `rm` commands were not found (#43).
- Fixed incorrect prompt for zero packages (#44).
- Fixed case-insensitive package matching.
- Fixed building packages without keeping log files.
- Fixed typos.

## Version 2.9.1 - 18-Sep-2015
### Added
- Added `--deps` option in `removepkg` to remove dependencies instead of via configuration.
- Added support for `.tbz` and `.tlz` Slackware packages in auto-detect option.

## Version 2.9.0 - 18-Sep-2015
### Added
- Added quit option in `new-config` command.

### Updated
- Improved installation Bash script.
- Enhanced messages and reference messages.
- Improved image types for graphs.
- Improved viewing of SlackBuilds repository in `--network` option.

### Fixed
- Fixed typos.
- Fixed package description printing.

## Version 2.8.9 - 15-Sep-2015
### Added
- Added `--case-ins` option for case-insensitive matching.

### Fixed
- Fixed dialog utility crash on Esc key exit.

### Updated
- Improved handling of optional dependencies.
- Enhanced `--network` view commands.

## Version 2.8.8 - 14-Sep-2015
### Added
- Added `--checklist` option in `--network` option.

### Fixed
- Fixed typo in help option.

### Updated
- Improved optional dependency handling.
- Enhanced `--network` view commands.

## Version 2.8.7 - 11-Sep-2015
### Fixed
- Fixed verification of already installed dependencies before removal.

## Version 2.8.6 - 11-Sep-2015
### Added
- Added reading of `doinst.sh` file in `--network` option.
- Added editor selection via configuration file.

### Updated
- Renamed `view.py` script to `network.py`.

## Version 2.8.5 - 08-Sep-2015
### Fixed
- Fixed package removal with `--checklist` and `--check-deps` options.

## Version 2.8.4 - 08-Sep-2015
### Added
- Added `--checklist` option in `--check` for upgrading packages.

### Updated
- Updated Slackware mirrors.

## Version 2.8.3 - 07-Sep-2015
### Added
- Added updating package lists for `slack` repository after distribution upgrades.
- Added reset of `slpkg` configuration file to default values.

### Fixed
- Fixed `pip` install.

## Version 2.8.2 - 04-Sep-2015
### Updated
- Improved finding of SBo-created Slackware packages.

### Fixed
- Fixed `slackpkg` update for `ChangeLog.txt`.
- Fixed Pylint errors.

## Version 2.8.1 - 02-Sep-2015
### Fixed
- Fixed build path handling.
- Fixed verification of SBo package creation.
- Fixed autobuild source order list.

### Updated
- Removed build check.
- Improved repository enable reference.

## Version 2.8.0 - 01-Sep-2015
### Added
- Added new configuration file for repositories in `/etc/slpkg/repositories.conf`.
- Added enabling/disabling repositories via dialog utility.

### Updated
- Updated all configuration files.
- Improved command-line help logo.
- Enhanced flags for package upgrades.
- Added screen clearing after dialog utility exit.

### Fixed
- Fixed removal of `None` type packages.
- Fixed removal of old SBo folder before building.

## Version 2.7.6 - 28-Aug-2015
### Fixed
- Fixed failed checksum message (#40).
- Removed calculated size.

### Updated
- Improved printing of package lists from repositories.

## Version 2.7.5 - 25-Aug-2015
### Added
- Added `python2-pythondialog` as an optional dependency.
- Added `--checklist` option for package removal.
- Added gigabyte unit in package manager.
- Added version and size for removed dependencies.

### Updated
- Moved `Msg()` function to `self.msg`.
- Improved dependency tracking.

## Version 2.7.4 - 21-Aug-2015
### Added
- Added support for `httpie` downloader.
- Added package removal by TAG.
- Added summary for removed package sizes.

### Fixed
- Fixed dependency resolution messages for SBo repository during package searches.
- Fixed reference messages for installing and upgrading.
- Fixed build error messages.

### Updated
- Improved installation of SBo packages with specific build numbers.
- Enhanced architecture selection for SBo repository.
- Improved module import paths.

## Version 2.7.3 - 13-Aug-2015
### Added
- Added tree view for `deps-status` command.

### Fixed
- Fixed `pasture/` directory for Slackware 14.0.

### Updated
- Added comments for Slackware ARM users in `REPOSITORIES` and `slpkg.conf`.
- Improved `slackpkg` synchronization with `ChangeLog.txt`.

## Version 2.7.2 - 10-Aug-2015
### Added
- Added support for Slackware ARM.

### Fixed
- Fixed package builds with multiple sources using `--autobuild`.

### Updated
- Improved installed package management.
- Updated `setup.py` requirements.

## Version 2.7.1 - 08-Aug-2015
### Fixed
- Fixed partial name package removal (#34).
- Fixed "package not found" message during removal (#35).
- Fixed remove and install references.

## Version 2.7.0 - 06-Aug-2015
### Fixed
- Fixed `EOFError` on `Ctrl+D` interrupt.

### Updated
- Replaced `sys.exit(0)` with `raise SystemExit()` and removed unused `sys` module.
- Improved code and docstrings.
- Updated Slackware mirrors.

## Version 2.6.9 - 31-Jul-2015
### Added
- Added `new-config` command to manage `.new` configuration files.

### Fixed
- Fixed ignoring blacklisted packages with version "blacklist" in binary repositories.

### Updated
- Updated `slpkg.SlackBuild` script.
- Improved Slackware version reading function.

## Version 2.6.8 - 30-Jul-2015
### Fixed
- Fixed SBo dependency installation order.

## Version 2.6.7 - 28-Jul-2015
### Fixed
- Fixed typo (#32).

### Added
- Added optional `graph-easy` module for drawing ASCII dependency diagrams.

## Version 2.6.6 - 25-Jul-2015
### Added
- Added `deps-status` command with message for missing logs.
- Added optional `pygraphviz` module for drawing dependency image maps.

### Updated
- Improved dependency log writing with full package details.

## Version 2.6.5 - 23-Jul-2015
### Added
- Added `core/` directory creation for Slackware repository.

### Fixed
- Fixed creation of `core/` directory.

## Version 2.6.4 - 21-Jul-2015
### Updated
- Merged functions into classes.

### Fixed
- Fixed auto-detection of Slackware packages.
- Fixed dependency checks before removal.
- Fixed directory existence checks before finding.
- Fixed matching of binary installed packages with repository packages.

## Version 2.6.3 - 17-Jul-2015
### Added
- Added option to enable/disable progress status bar via configuration.

### Fixed
- Fixed SBo install and upgrade print views.
- Improved code style and complexity.
- Fixed matching of binary installed packages with repository packages.

### Updated
- Updated Slackware mirrors.
- Improved version display for SBo packages during installation or upgrades.

## Version 2.6.2 - 16-Jul-2015
### Added
- Added health check for installed packages.

### Fixed
- Fixed removal of directories from Slackware repository during package list recreation (#29).
- Added support for Slackware version 13.37 (#28).
- Fixed fresh installation issues (#30).

## Version 2.6.1 - 15-Jul-2015
### Fixed
- Fixed retrieval of installed versions.
- Fixed matching of `_SBo` package names with installed names.

### Updated
- Improved initialization method for file reading in downloads.

## Version 2.6.0 - 08-Jul-2015
### Added
- Added auto-detection of Slackware packages for installation.

### Updated
- Improved toolbar progressive status.

### Fixed
- Fixed visibility of options without colors.
- Fixed dependency removal checks (#26).

## Version 2.5.9 - 02-Jul-2015
### Fixed
- Fixed printing of package content lists.
- Fixed Alien `-current` repository.
- Fixed `multi -current` repository.

### Added
- Added support for `slonly -current` (x86_64) repository.

## Version 2.5.8 - 28-Jun-2015
### Fixed
- Fixed checksum for Alien repository.

## Version 2.5.7 - 28-Jun-2015
### Fixed
- Fixed double packages in Alien repository.
- Fixed dependency resolution for binary packages.

### Updated
- Changed mirror for Alien repository.

## Version 2.5.6 - 25-Jun-2015
### Fixed
- Fixed capital letter default for message prompts (thanks to Thomas Szteliga).
- Reduced source code complexity.

### Added
- Added `MAKEFLAGS` option in `/etc/slpkg/slpkg.conf` (thanks to Brenton Earl).

## Version 2.5.5 - 23-Jun-2015
### Added
- Added summary for `--FIND`, `--check`, and `repo-list` options.

### Updated
- Improved package view alignment.
- Enhanced repository view lists.

## Version 2.5.4 - 22-Jun-2015
### Added
- Added support for local repositories via `repo-add` command.
- Added package skipping by repository or local sources.

### Fixed
- Fixed repository existence check during package upgrades.
- Fixed `AttributeError: 'list' object has no attribute 'splitlines'` in `--tracking` (thanks to Brenton Earl).
- Fixed repository existence/enabled checks during upgrades.
- Fixed custom repository updates.

### Updated
- Improved toolbar timing.

## Version 2.5.3 - 20-Jun-2015
### Added
- Added blacklist support by repository priority.
- Added `wget`, `curl`, and `aria2c` downloaders.
- Added support for downloading `jdk` from SBo repository.

### Fixed
- Fixed dependency resolution classes.
- Fixed adding/removing packages from blacklist and queue.

## Version 2.5.2 - 19-Jun-2015
### Added
- Added repository check in blacklist.

### Updated
- Improved blacklist options.

### Fixed
- Fixed Pylint errors.

## Version 2.5.1 - 14-Jun-2015
### Added
- Added checking of repository `ChangeLog.txt` with `slpkg --check [repo]`.

### Fixed
- Fixed argument typo.

## Version 2.5.0 - 12-Jun-2015
### Added
- Added full support for Slackware commands `installpkg`, `upgradepkg`, and `removepkg` with all options; merged `--reinstall` into `--upgradepkg`.
- Added printing of installed versions.
- Added dependency usage check before removal.
- Added `MSB` (MATE) to default repositories.
- Added specific repository updates/upgrades.

### Fixed
- Fixed `slonly` repository `ChangeLog.txt` link.
- Removed `foo.pkg` selection; use variable `pkgs="pip brasero pylint"` instead.
- Fixed binary dependency resolution.
- Fixed `slackers.it` mirror.
- Ignored inactive SBo repository.

## Version 2.4.4 - 10-Jun-2015
### Fixed
- Fixed `AttributeError: 'Update' object has no attribute 'meta'` during repository updates.

## Version 2.4.3 - 10-Jun-2015
### Added
- Added long options.

### Fixed
- Fixed `repo_data()` function `TypeError`.
- Fixed SBo version comparison.
- Improved code style.

## Version 2.4.2 - 04-Jun-2015
### Fixed
- Fixed `TypeError` in `repo_data()` function.
- Fixed SBo version comparison.
- Improved code style.

## Version 2.4.1 - 04-Jun-2015
### Added
- Added option to upgrade only installed distribution packages.
- Added option to enable/disable dependency resolution.

### Fixed
- Fixed package upgrades.
- Fixed checksum on/off handling.
- Fixed dependency resolution for Slackware binary package upgrades.

## Version 2.4.0 - 02-Jun-2015
### Fixed
- Fixed comments in `--help` option.

### Added
- Added option to skip packages during upgrades.

## Version 2.3.6 - 30-May-2015
### Fixed
- Fixed input of the first package during multi-package searches with `-F`.

## Version 2.3.5 - 30-May-2015
### Fixed
- Fixed version display for SBo packages with `-F` option.

## Version 2.3.4 - 28-May-2015
### Fixed
- Fixed argument comments.
- Fixed compression of SlackBuild packages.
- Fixed binary dependency and size handling.
- Fixed Pylint errors.
- Fixed `rlw` repository package dependencies.

### Added
- Added package finding from enabled repositories.
- Added `clean.py` script to remove data.

## Version 2.3.3 - 23-May-2015
### Fixed
- Fixed `ZeroDivisionError` during binary package installation.
- Fixed `OSError` for non-existent paths.

## Version 2.3.2 - 21-May-2015
### Fixed
- Fixed arguments and options.
- Removed package version display during upgrades to avoid conflicts.
- Fixed file license.

## Version 2.3.1 - 14-May-2015
### Added
- Added synchronization with `slackpkg` to update `ChangeLog.txt` during distribution upgrades.

## Version 2.2.9 - 24-Apr-2015
### Fixed
- Fixed references for installed packages after distribution upgrades.
- Fixed double references for installed SBo packages.
- Fixed clearing of master SBo packages.

## Version 2.2.8 - 23-Apr-2015
### Fixed
- Fixed adding new packages during upgrades.
- Fixed manpage.
- Fixed `TypeError: 'NoneType' object has no attribute '__getitem__'` for missing SBo links (thanks to R S Ananda Murthy).
- Fixed `slackbuilds.org` `ChangeLog.txt` URL.
- Fixed `install.sh` script.
- Fixed `binary/install.py`, `sbo/slackbuild.py`, and `slack/patches.py` classes.
- Fixed package counting during distribution upgrades.

## Version 2.2.7 - 18-Mar-2015
### Added
- Added Bash and Fish completion files.

### Fixed
- Fixed synchronization issues during SBo repository upgrades.
- Fixed spacing in view displays.

## Version 2.2.6 - 26-Feb-2015
### Added
- Added download counter.

### Fixed
- Fixed Slackware release message.

## Version 2.2.5 - 24-Feb-2015
### Fixed
- Fixed error handling.
- Renamed `VERSION` to `RELEASE` in configuration file.
- Merged functions and reduced `__metadata__` complexity.
- Fixed `SlackBuild` and install scripts.
- Renamed `re-create` command to `upgrade`.
- Fixed `IOError: [Errno 13] Permission denied` as user.
- Fixed Alien repository checksums.

## Version 2.2.3 - 16-Feb-2015
### Fixed
- Fixed `slpkg.SlackBuild` script support for `.zip` archives.
- Fixed overwriting of new SBo scripts.
- Fixed master package removal with dependencies.

## Version 2.2.2 - 11-Feb-2015
### Added
- Added display of hidden matching SBo packages.

## Version 2.2.1 - 06-Feb-2015
### Added
- Added support for multi-package handling.
- Added variable passing to scripts.
- Added support for `file.pkg` instead of `[package...]` or `[package]`.

### Fixed
- Fixed key error for incorrect repository names.
- Renamed `BUILD` to `BUILD_PATH` in `slpkg.conf`.
- Fixed installation with modified `OUTPUT` variable.
- Fixed view list display in `-l` option.
- Fixed installed package display in `-f` and `-l` options.

## Version 2.2.0 - 08-Jan-2015
### Fixed
- Fixed queue downloads.
- Fixed find argument.
- Renamed `repolist` and `repoinfo` to `repo-list` and `repo-info`.
- Fixed installed package list.

### Added
- Added custom binary repository support.
- Added Slackware `patches` repository in `PACKAGES.txt`.
- Added Alien’s restricted repository.
- Added `wget` option.
- Added default repository display in `repo-list`.

## Version 2.1.5 - 27-Dec-2014
### Added
- Added `slacker.it`, `slackonly.com`, Alien’s `ktown`, Alien’s `multilib`, `Slacke E17` and `E18`, `SalixOS`, and `Slackel` repositories.
- Added `re-create` command.
- Added `repolist` command.
- Added `repoinfo` command.

### Fixed
- Fixed ignoring hidden files in `/var/log/packages/`.
- Fixed arguments.

## Version 2.1.4 - 16-Dec-2014
### Added
- Added `update` command and removed auto-update package lists.
- Added `slpkg` self-update.

### Fixed
- Fixed `UnboundLocalError: local variable 'md5' referenced before assignment` for Alien repository updates (thanks to Jack Kiersey).
- Fixed checksums for Slackware package updates.

## Version 2.1.3 - 06-Dec-2014
### Fixed
- Fixed `IndexError: tuple index out of range` during SBo upgrades.

## Version 2.1.2 - 04-Dec-2014
### Added
- Added checksum support for all repositories.

### Fixed
- Fixed download modules.

## Version 2.1.1 - 01-Dec-2014
### Added
- Added repository selection options in `/etc/slpkg/slpkg.conf`.
- Added options to skip unsupported and untested packages.

### Fixed
- Fixed `TypeError` for unsupported/untested SBo packages.

## Version 2.1.0 - 28-Nov-2014
### Fixed
- Fixed build path handling.
- Fixed directory creation if not existent.

### Added
- Added `studioware` (studio) repository.

## Version 2.0.9 - 26-Nov-2014
### Fixed
- Fixed `setup.py` to install configuration files after checksum.
- Fixed viewing of `slpkg` configuration file.

## Version 2.0.8 - 25-Nov-2014
### Added
- Added additional options in `slpkg.conf`.

## Version 2.0.7 - 22-Nov-2014
### Added
- Added more options in `slpkg.conf`.
- Added `slackware-mirrors` file in `/etc/slpkg`.

### Fixed
- Fixed upgrading of installed Slackware packages.

## Version 2.0.6 - 18-Nov-2014
### Fixed
- Fixed `setup.py` file.

## Version 2.0.5 - 18-Nov-2014
### Added
- Added `/etc/slpkg.conf` file.
- Moved `--current` switch to `/etc/slpkg.conf`.
- Added local `PACKAGES.TXT` for Slackware repository.
- Added options to view package descriptions.
- Added repository support in tracking dependencies with `-t`.
- Added configuration file management.

### Fixed
- Fixed upgrading of binary packages.

## Version 2.0.4 - 07-Nov-2014
### Added
- Added Robby Workman, Alien Bob (Eric Hameleers), and `slacky.eu` repositories.

### Fixed
- Fixed remove list reference.

## Version 2.0.3 - 29-Oct-2014
### Fixed
- Fixed arguments.
- Fixed dependency logs.
- Fixed Pydoc pager.
- Fixed list package paging.

## Version 2.0.2 - 21-Oct-2014
### Fixed
- Fixed source code.

## Version 2.0.1 - 20-Oct-2014
### Fixed
- Fixed MD5 checksum failures.
- Fixed downloading all sources before building in view options.

## Version 2.0.0 - 15-Oct-2014
### Fixed
- Aligned code with PEP8 style.
- Fixed SBo architecture handling.
- Fixed package splitting.

## Version 1.9.9 - 11-Oct-2014
### Added
- Added queue options.

## Version 1.9.8 - 07-Oct-2014
### Fixed
- Fixed source code updates.

## Version 1.9.7 - 06-Oct-2014
### Fixed
- Fixed `UnboundLocalError: local variable 'arch' referenced before assignment`.

## Version 1.9.6 - 04-Oct-2014
### Fixed
- Fixed installation of packages from Slackware repository.

## Version 1.9.5 - 04-Oct-2014
### Fixed
- Added `aaa_elflibs` to blacklist.
- Fixed current version upgrades to only include installed packages.
- Fixed gzip manpage in `setup.py`.
- Fixed blacklist configuration file installation via `setup.py`.
- Added GB unit support in Slackware repository.

## Version 1.9.4 - 01-Oct-2014
### Added
- Added support for installing packages from Slackware current repository.
- Added support for upgrading the entire Slackware current tree.

### Fixed
- Fixed arguments.

## Version 1.9.3 - 29-Sep-2014
### Added
- Added blacklist configuration file.
- Added blacklist options.

## Version 1.9.2 - 27-Sep-2014
### Fixed
- Removed `argparse`.
- Created downloader module with `wget`.

## Version 1.9.1 - 25-Sep-2014
### Fixed
- Fixed updating SlackBuilds packages in version 1.9.0.
- Fixed architecture in SBo upgrades.

## Version 1.9.0 - 24-Sep-2014
### Fixed
- Fixed arguments.
- Replaced `less` command with `pydoc`.

## Version 1.8.9 - 23-Sep-2014
### Added
- Added short package descriptions.
- Added viewing of matching packages from SBo repository.

### Fixed
- Fixed opening/closing of files like `SLACKBUILDS.TXT`.

## Version 1.8.8 - 22-Sep-2014
### Fixed
- Fixed package alignment in views.
- Fixed build time handling.

### Added
- Added dependency searching from local `SLACKBUILDS.TXT` file.

## Version 1.8.7 - 19-Sep-2014
### Fixed
- Fixed build time handling.

## Version 1.8.6 - 14-Sep-2014
### Fixed
- Fixed references for installing or upgrading.
- Updated finding of installed packages.

### Added
- Added total file size display for installed packages.
- Added highlighting for upgraded packages from Slackware repository.

## Version 1.8.5 - 13-Sep-2014
### Fixed
- Fixed KB to MB conversion.
- Fixed building sources with spaces in filenames (e.g., `Sublime Text 2.0.2 x64.tar.bz2`).

## Version 1.8.4 - 10-Sep-2014
### Added
- Added MD5SUM file checking.
- Added build time tracking.

## Version 1.8.3 - 08-Sep-2014
### Fixed
- Fixed messages.

## Version 1.8.2 - 08-Sep-2014
### Fixed
- Fixed dependency resolution for `-c sbo upgrade` option.
- Fixed SBo summary updates.

### Added
- Added build log file.

## Version 1.8.1 - 04-Sep-2014
### Fixed
- Fixed `install.sh` script for `wget` downloading `.tar.gz` archives.
- Fixed installation of packages like `adobe-reader`.

## Version 1.8.0 - 02-Sep-2014
### Fixed
- Fixed architecture view for dependencies in `-s sbo <package>`.
- Fixed version finding for `-s sbo <package>`.
- Removed unnecessary package removal after downloads.
- Fixed `wget -N` command issues for some packages.

## Version 1.7.9 - 30-Aug-2014
### Added
- Added `extra` and `pasture` packages from the official Slackware tree.
- Added `install.sh` script.

### Fixed
- Fixed removal of destination files after copying to SBo script directory.
- Fixed appearance of build tags for packages without tags.
- Fixed `_slack` tag handling.

## Version 1.7.8 - 28-Aug-2014
### Fixed
- Fixed `ImportError: No module named __metadata__`.

## Version 1.7.7 - 26-Aug-2014
### Fixed
- Fixed installation of `noarch` packages from SBo repository.
- Fixed handling of `%README%` as a dependency.
- Fixed arguments.
- Fixed messages.

## Version 1.7.6 - 25-Aug-2014
### Fixed
- Resolved `IndexError` for `-aa` in CLI `argparse` options.
- Corrected issues with architecture-specific configurations.

### Added
- Implemented functionality to upgrade all SlackBuilds (SBo) packages.

## Version 1.7.5 - 22-Aug-2014
### Added
- Introduced package installation reports for commands `slpkg -s sbo <package>`, `slpkg -s slack <package>`, and `slpkg -c slack upgrade`.

### Fixed
- Updated mirrors for Slackware x86 architecture.

## Version 1.7.4 - 17-Aug-2014
### Fixed
- Resolved `NameError: global name 'getpass' is not defined`.

### Added
- Enabled downloading of `.asc` files for package upgrades or installations from the Slackware tree.
- Added file size calculation during package installation.
- Supported package installation or upgrades from Slackware mirrors.

## Version 1.7.3 - 16-Aug-2014
### Fixed
- Sorted package lists in the view, with thanks to Dave for assistance (https://github.com/wvragga).
- Fixed LILO reinstallation after kernel upgrades.
- Replaced system code with Python code.
- Corrected reinstallation logic for existing packages and upgrades with `slpkg -s slack <packages>`.
- Updated paths: `ChangeLog.txt` now saved in `/var/log/slpkg` and `SLACKBUILDS.TXT` in `/var/lib/slpkg/sbo_repo`.
- Improved upgrade initialization method.
- Replaced `mkdir -p` with `os.mkdir` to create directories only if they do not exist.

## Version 1.7.2 - 13-Aug-2014
### Fixed
- Improved error messages.

## Version 1.7.1 - 11-Aug-2014
### Fixed
- Resolved `OSError: [Errno 2] No such file or directory: '/tmp/slpkg/patches/'`.

### Added
- Enhanced package search functionality from slackbuilds.org.
- Improved package search reliability following `ChangeLog.txt` updates.

## Version 1.7.0 - 09-Aug-2014
### Added
- Implemented package removal with all dependencies.

## Version 1.6.9 - 04-Aug-2014
### Fixed
- Removed unnecessary code.
- Ensured creation of `/tmp/slpkg/readme/` path.

### Added
- Introduced build path to store all packages in `Slpkg_Build` directory.
- Enabled building and installing packages only if a newer version is available or the package is not installed (`slpkg -s sbo`).
- Added display of installed packages in dependency tracking.

## Version 1.6.8 - 01-Aug-2014
### Fixed
- Corrected handling of HTTP extra sources with leading spaces.
- Fixed issues with the `EMBASSY` package.
- Handled `KeyboardInterrupt` gracefully.

## Version 1.6.7 - 31-Jul-2014
### Fixed
- Improved package removal process.
- Resolved `OSError: [Errno 2] No such file or directory`.
- Enhanced error messages.

## Version 1.6.6 - 30-Jul-2014
### Fixed
- Corrected 'Wrong file' error during package builds.

## Version 1.6.5 - 28-Jul-2014
### Added
- Included `slack`, `noarch`, and other categories in package lists (`slpkg -l`).
- Added index display in package lists (`slpkg -l`).
- Enabled package installation via official Slackware mirrors.

### Fixed
- Improved error messages.

### Changed
- Updated argument display views.

## Version 1.6.3 - 28-Jul-2014
### Fixed
- Enhanced error messages.
- Resolved `IndexError: tuple index out of range`.

## Version 1.6.3 - 27-Jul-2014
### Fixed
- Corrected argument handling.
- Resolved `NameError: global name 'sp' is not defined`.

## Version 1.6.2 - 26-Jul-2014
### Added
- Enabled distribution upgrades from official Slackware mirrors (`slpkg -c slack upgrade`).

### Fixed
- Improved package change detection, increasing speed by 2x.
- Enhanced error messages.

## Version 1.6.1 - 22-Jul-2014
### Fixed
- Improved error messages.
- Corrected package removal process.
- Fixed package search functionality.
- Resolved issues with printing package contents.

## Version 1.6.0 - 21-Jul-2014
### Fixed
- Improved package removal (`slpkg -r`).
- Enhanced error messages.
- Added creation of `__metadata__`.

## Version 1.5.9 - 18-Jul-2014
### Fixed
- Implemented creation of sub-modules.

## Version 1.5.8 - 18-Jul-2014
### Fixed
- Added reporting of packages before removal (`slpkg -r`).

## Version 1.5.7 - 17-Jul-2014
### Fixed
- Resolved `IndentationError: expected an indented block`.

## Version 1.5.6 - 17-Jul-2014
### Added
- Introduced `setuptools` as a secondary installer.

## Version 1.5.5 - 15-Jul-2014
### Fixed
- Created `slpkg.py` module.

## Version 1.5.4 - 13-Jul-2014
### Fixed
- Ensured removal of files in `/tmp` directory after reading.

## Version 1.5.3 - 24-Jun-2014
### Fixed
- Resolved `IOError: [Errno 13] Permission denied` when accessing `/tmp/slpkg/readme/`.

## Version 1.5.2 - 24-Jun-2014
### Fixed
- Handled `urllib2.URLError: <urlopen error [Errno 111] Connection refused>`.

## Version 1.5.1 - 12-Jun-2014
### Fixed
- Corrected download link retrieval for architectures other than x86_64.

## Version 1.5.0 - 07-Jun-2014
### Fixed
- Ensured downloads occur only if the server file is newer than the local file.
- Improved source code.

## Version 1.4.9 - 06-Jun-2014
### Fixed
- Fixed loop exit after building in the 'network' option.
- Enhanced source code.

## Version 1.4.8 - 06-Jun-2014
### Fixed
- Improved messages for upgrade, install, reinstall, and file removal reporting.

## Version 1.4.7 - 04-Jun-2014
### Added
- Supported download, build, and install options with `-n` (network) and `-c` (check).

## Version 1.4.6 - 05-Jun-2014
### Fixed
- Corrected building of `noarch` packages.

## Version 1.4.5 - 04-Jun-2014
### Added
- Added support for FTP links.
- Implemented reporting of already installed packages.

## Version 1.4.4 - 03-Jun-2014
### Added
- Supported all extra sources.

### Fixed
- Resolved out-of-range errors in SBo version links with filenames.

## Version 1.4.3 - 03-Jun-2014
### Fixed
- Prevented building packages with more than four arguments.

## Version 1.4.2 - 03-Jun-2014
### Fixed
- Avoided building packages if already installed.
- Prevented downloading if the file is already installed.

## Version 1.4.1 - 31-May-2014
### Fixed
- Avoided downloading packages if already installed.

## Version 1.4.0 - 30-May-2014
### Fixed
- Supported installation of SBo packages with different tags.
- Prevented building and installing already installed packages.

## Version 1.3.9 - 30-May-2014
### Fixed
- Removed unnecessary SBo script search.
- Updated argument naming.
- Improved source code.

## Version 1.3.8 - 30-May-2014
### Fixed
- Resolved issues with missing dependencies.

## Version 1.3.7 - 29-May-2014
### Fixed
- Corrected link filename with version.

## Version 1.3.6 - 28-May-2014
### Added
- Enabled downloading packages with all dependencies, building, and installing them.

## Version 1.3.5 - 24-May-2014
### Fixed
- Improved "no dependencies" message in tracking function.
- Added confirmation for package deletion.

## Version 1.3.4 - 23-May-2014
### Fixed
- Resolved `sre_constants.error` for package names with special characters.

## Version 1.3.3 - 22-May-2014
### Added
- Supported downloading and building packages.

## Version 1.3.2 - 22-May-2014
### Added
- Enabled viewing of package info and SlackBuild files.

### Fixed
- Improved build argument messages.
- Resolved `TypeError: unsupported operand type(s)` in `sbo_requires_pkg` function.

## Version 1.3.1 - 21-May-2014
### Added
- Supported viewing of README files.

## Version 1.3.0 - 21-May-2014
### Fixed
- Improved `argparse` view.

## Version 1.2.9 - 21-May-2014
### Added
- Implemented dependency tracking.

## Version 1.2.8 - 20-May-2014
### Added
- Supported downloading packages from www.slackbuilds.org.
- Enabled building packages with extra sources.

## Version 1.2.7 - 20-May-2014
### Fixed
- Refactored code into functions.

## Version 1.2.6 - 20-May-2014
### Fixed
- Improved code quality and performance.

## Version 1.2.5 - 19-May-2014
### Fixed
- Corrected download source for x86_64 architecture.

## Version 1.2.4 - 19-May-2014
### Added
- Supported downloading source code by PC architecture.

## Version 1.2.3 - 19-May-2014
### Added
- Added progress bar to package searching.

### Fixed
- Improved package update checks.

## Version 1.2.2 - 19-May-2014
### Fixed
- Enhanced library repository handling.

## Version 1.2.1 - 19-May-2014
### Fixed
- Improved function implementations.

## Version 1.2.0 - 17-May-2014
### Added
- Checked if packages from www.slackbuilds.org are up-to-date.

## Version 1.1.9 - 17-May-2014
### Fixed
- Added notification message for existing packages in the remove function.

## Version 1.1.8 - 17-May-2014
### Added
- Implemented root user check.

### Fixed
- Improved package search and display.

## Version 1.1.7 - 16-May-2014
### Fixed
- Enhanced function implementations.

## Version 1.1.6 - 15-May-2014
### Fixed
- Removed redundant binary search option.

## Version 1.1.5 - 15-May-2014
### Added
- Supported multiple install, upgrade, remove, and find operations.
- Enabled searching for network SlackBuilds links and sources.

## Version 1.1.4 - 14-May-2014
### Fixed
- Updated `sbo_requires_pkg` function to avoid using `.txt` files.

## Version 1.1.3 - 14-May-2014
### Added
- Supported finding package requirements from www.slackbuilds.org.

## Version 1.1.2 - 13-May-2014
### Added
- Enabled finding existing binary packages in `/tmp` directory.

## Version 1.1.1 - 13-May-2014
### Fixed
- Improved list printout.

## Version 1.1.0 - 12-May-2014
### Added
- Supported searching from SBo and printing download links.

## Version 1.0.9 - 12-May-2014
### Fixed
- Improved warning messages and color printouts.

## Version 1.0.8 - 12-May-2014
### Added
- Supported single install argument.
- Added two options for list argument.

### Fixed
- Corrected argument handling.

## Version 1.0.7 - 11-May-2014
### Fixed
- Handled null arguments.

## Version 1.0.6 - 11-May-2014
### Fixed
- Updated SlackBuild argument handling.

## Version 1.0.5 - 10-May-2014
### Added
- Supported auto-build package selection.

### Fixed
- Updated man page and `README.rst` file.

## Version 1.0.3 - 10-May-2014
### Added
- Implemented `find_package` function.

## Version 1.0.2 - 10-May-2014
### Fixed
- Improved `setup.py` file.
- Compressed man page `slpkg.8` with gzip.

## Version 1.0.1 - 09-May-2014
### Added
- Supported installation of man pages.

## Version 1.0.0 - 09-May-2014
### Added
- Introduced man page.

## Version 0.0.3 - 09-May-2014
### Added
- Supported warning messages for package removal.
- Replaced remove command.

## Version 0.0.2 - 08-May-2014
### Added
- Supported package reinstallation.

### Fixed
- Improved version printout.

## Version 0.0.1 - 07-May-2014
### Notes
- Released version 0.0.1, development status: Alpha.