#!/usr/bin/python3
# -*- coding: utf-8 -*-


import unittest

from slpkg.load_data import LoadData
from slpkg.package_validator import PackageValidator


class TestPkgInstalled(unittest.TestCase):
    """Test for installed."""

    def setUp(self) -> None:
        """Set the test."""
        load = LoadData()
        self.data = load.load('sbo')
        self.pkg_validator = PackageValidator()
        self.packages = ['colored', 'sbo-create', 'sun']

    def test_check_exists(self) -> None:
        """Check if packages exist."""
        self.assertIsNone(self.pkg_validator.is_package_exists(self.packages, self.data))

    def test_check_is_installed(self) -> None:
        """Check if installed."""
        self.assertIsNone(self.pkg_validator.is_package_installed(self.packages))


if __name__ == "__main__":
    unittest.main()
