#!/usr/bin/python3
# -*- coding: utf-8 -*-


import unittest

from slpkg.config import config_load


class TestColors(unittest.TestCase):
    """Test for colors."""

    def setUp(self) -> None:
        """Set the test."""
        self.config = config_load

    def test_colors(self) -> None:
        """Test the colors."""
        self.assertEqual('\x1b[47m', self.config.back_white)
        self.assertEqual('\x1b[1m', self.config.bold)
        self.assertEqual('\x1b[30m', self.config.black)
        self.assertEqual('\x1b[91m', self.config.red)
        self.assertEqual('\x1b[32m', self.config.green)
        self.assertEqual('\x1b[93m', self.config.yellow)
        self.assertEqual('\x1b[96m', self.config.cyan)
        self.assertEqual('\x1b[38;5;247m', self.config.grey)
        self.assertEqual('\x1b[0m', self.config.endc)


if __name__ == '__main__':
    unittest.main()
