#!/usr/bin/python3
# -*- coding: utf-8 -*-


import unittest
from pathlib import Path

from slpkg.config import config_load


class TestConfigs(unittest.TestCase):
    """Testing the configuration."""

    def setUp(self) -> None:
        """Set the test."""
        self.config = config_load

    def test_configs(self) -> None:  # pylint: disable=[R0915]
        """Test the configs."""
        self.assertEqual('slpkg', self.config.prog_name)
        self.assertEqual('x86_64', self.config.cpu_arch)
        self.assertEqual(Path('/tmp'), self.config.tmp_path)
        self.assertEqual(Path('/tmp/slpkg'), self.config.tmp_slpkg)
        self.assertEqual(Path('/tmp/slpkg/build'), self.config.build_path)
        self.assertEqual(Path('/tmp/slpkg/'), self.config.download_only_path)
        self.assertEqual(Path('/etc/slpkg'), self.config.etc_path)
        self.assertEqual(Path('/var/lib/slpkg'), self.config.lib_path)
        self.assertEqual(Path('/var/log/slpkg/'), self.config.log_path)
        self.assertEqual(Path('/var/log/packages'), self.config.log_packages)

        self.assertEqual(Path('/var/log/slpkg/deps.log'), self.config.deps_log_file)
        self.assertEqual(Path('/var/log/slpkg/process.log'), self.config.process_log_file)

        self.assertEqual('INFO', self.config.logging_level)
        self.assertEqual('.pkgs', self.config.file_list_suffix)
        self.assertEqual(['.tgz', '.txz'], self.config.package_type)
        self.assertEqual('upgradepkg --install-new', self.config.installpkg)
        self.assertEqual('upgradepkg --reinstall', self.config.reinstall)
        self.assertEqual('removepkg', self.config.removepkg)
        self.assertEqual(True, self.config.colors)
        self.assertEqual('-j4', self.config.makeflags)
        self.assertEqual(False, self.config.gpg_verification)
        self.assertEqual(True, self.config.checksum_md5)
        self.assertEqual(False, self.config.dialog)
        self.assertEqual(False, self.config.pager)
        self.assertEqual(False, self.config.view_missing_deps)
        self.assertEqual(True, self.config.package_method)
        self.assertEqual(False, self.config.downgrade_packages)
        self.assertEqual(False, self.config.delete_sources)
        self.assertEqual('wget', self.config.downloader)
        self.assertEqual('-c -q --progress=bar:force:noscroll --show-progress', self.config.wget_options)
        self.assertEqual('', self.config.curl_options)
        self.assertEqual('-c', self.config.aria2_options)
        self.assertEqual('-c get -e', self.config.lftp_get_options)
        self.assertEqual('-c mirror --parallel=100 --only-newer --delete', self.config.lftp_mirror_options)
        self.assertEqual(True, self.config.ask_question)
        self.assertEqual(True, self.config.kernel_version)
        self.assertEqual('grub-mkconfig -o /boot/grub/grub.cfg', self.config.bootloader_command)
        self.assertEqual(False, self.config.parallel_downloads)
        self.assertEqual(5, self.config.maximum_parallel)
        self.assertEqual(False, self.config.progress_bar)
        self.assertEqual('spinner', self.config.progress_spinner)
        self.assertEqual('white', self.config.spinner_color)
        self.assertEqual(True, self.config.process_log)

        self.assertEqual(False, self.config.urllib_retries)
        self.assertEqual(False, self.config.urllib_redirect)
        self.assertEqual(3.0, self.config.urllib_timeout)

        self.assertEqual('', self.config.proxy_address)
        self.assertEqual('', self.config.proxy_username)
        self.assertEqual('', self.config.proxy_password)


if __name__ == '__main__':
    unittest.main()
