XZ (LZMA2)
==========

I've only modified the Makefile a bit to create a static library, and I also had to add this little patch to make it work
with concatenated streams generated by some buggy xz compressors (XZ_DEC_CONCATENATED is defunct):
```diff
--- a/src/xz/xz_dec_stream.c
+++ b/src/xz/xz_dec_stream.c
@@ -742,7 +742,12 @@ static enum xz_ret dec_main(struct xz_dec *s, struct xz_buf *b)
                        if (!fill_temp(s, b))
                                return XZ_OK;

-                       return dec_stream_footer(s);
+                       ret = dec_stream_footer(s);
+                       if (ret == XZ_STREAM_END) {
+                               xz_dec_reset(s);
+                               continue;
+                       }
+                       return ret;
                }
        }
```
Otherwise this is the verbatim code from the Linux kernel, see [tukaani.org](https://www.tukaani.org/xz/embedded.html).
I'd like to say thanks to Lasse Collin for this library and for the help he provided.

Compilation
-----------

```
make libxz.a
```
