 vmbinstallpkg

_vmbinstallpkg_ and its companion _vmbremovepkg_ install and remove Slackware packages created from build scripts at [SlackBuilds.org](https://www.slackbuilds.org/) (SBo).
Rather than installing just the target application, they determine all the target's dependencies and display them in a dialog with check boxes to indicate approval to install or remove them.
In the case of removal, dependant packages which are also dependencies of other SBo packages are displayed unchecked.

_vmbinstallpkg_ uses [_HooRex_](https://gitlab.com/chris.willing/hoorex) internally to calculate dependencies.

Unless running as root (not recommended), _vmbinstallpkg_ and _vmbremovepkg_ will both use _sudo_ to authorize the actual installing & removing of packages.


### Installation
The preferred installation method is to build and install the [SlackBuild for _vmbinstallpkg_ at SlackBuilds.org](https://slackbuilds.org/repository/15.0/system/vmbinstallpkg/).
This should include building and installing the [_HooRex_ SlackBuild at SBo](https://slackbuilds.org/repository/15.0/misc/hoorex/).
After installation, edit the configuration file at `/etc/default/vmbinstallpkg` (see [_Setup_](https://gitlab.com/vmbuilder/vmbinstallpkg/-/tree/main#setup) below).

Alternatively, first build and install [_HooRex_ from SBo](https://slackbuilds.org/repository/15.0/misc/hoorex/).
Now, as root, copy the
[_vmbinstallpkg_](https://gitlab.com/vmbuilder/vmbinstallpkg/-/raw/main/vmbinstallpkg) and
[_vmbremovepkg_](https://gitlab.com/vmbuilder/vmbinstallpkg/-/raw/main/vmbremovepkg) scripts
from here into your system's _/usr/bin_ directory (or elsewhere in the user's PATH).
Now copy the [vmbinstallpkg.defaults](https://gitlab.com/vmbuilder/vmbinstallpkg/-/raw/main/vmbinstallpkg.defaults) file to `/etc/default/vmbinstallpkg`,
also editing as required (see [_Setup_](https://gitlab.com/vmbuilder/vmbinstallpkg/-/tree/main#setup) below).

### Setup
_vmbinstallpkg_ needs to know two things:
- location of a _HooRex_ dependency database (_repoData.pkl_)
- a local directory or network location containing built packages it can install from

These locations are set in a configuration defaults file at `/etc/default/vmbinstallpkg` using the variables _HOOREX\_DB_ and _REPODIR_ respectively.

As shipped, the defaults file has _HOOREX\_DB_ set to retrieve the dependency database from the network.
The advantage of this default is that the user doesn't need to know anything about how _HooRex_ works or how to set it up.
A possible disadvantage is the need to trust that the remote site is maintaining an up to date and accurate database.

For users familiar with _HooRex_, _HOOREX\_DB_ can be set to use a locally generated dependency database.
Commented examples are provided in the defaults file showing how either an absolute or relative directory path may be specified.
In the latter case, the location is relative to _vmbinstallpkg_'s local directory  at `$HOME/.local/share/vmbinstallpkg`.
If _HOOREX\_DB_ is empty (typically _HOOREX_DB=\$\{HOOREX\_DB\}_ in the defaults file), _vmbinstallpkg_ will use _HooRex_'s default location  at `$HOME/.local/share/hoorex`.

As shipped, the defaults file also has _REPODIR=\$\{REPODIR\}_, the directory where built SlackBuilds ready for installation can be found, set to empty (unless set in the environment).
In the case of such an empty _REPODIR_ value, _vmbinstallpkg_ will use _/tmp_ as the directory from which to install built packages.
This default is used because it is the default _OUTPUT_ location for SlackBuilds from SBo.
Different users will likely choose to move built packages from _/tmp_ to different locations for storage and the user should change the default file's _REPODIR_ to reflect that location (commented example provided).

An alternative to using a local directory from which to obtain built packages to install is to obtain them from a remote networked location which is accessible using _curl_ or _wget_.
In this case, _REPODIR_ should point to the remote directory containing a PACKAGES.TXT file which describes packages available from the remote repository e.g.
```
	http://192.168.1.16/slackware/SBo/packages/${SL_ARCH}/${SL_RELEASE}
```

### Usage
```
	vmbinstallpkg|vmbremovepkg  <target_package | -f | --force-update | -v | --version>
```
When _vmbinstallpkg_ is run with a target package name, the dependency database is interrogated and a dialog showing the target package and all packages it depends on with all check boxes checked.
The user may uncheck any of these according to their whim.
When _OK_ is selected, all checked packages are installed.

If the target package is not found in the directory which REPODIR was set to, _vmbinstallpkg_ can't continue and will question whether REPODIR is set correctly.
If the target package is found but any of the target package's dependencies are missing from the directory which REPODIR was set to,
they will be listed along with an option to continue anyway or to stop (usually the sensible option).

When instantiated as _vmbremovepkg_, dependencies which are also dependencies of other currently installed packages are still listed but are shown unchecked - not wanting to impair those other packages' usability.

If _vmbinstallpkg_ is invoked with either _-v_ or _--version_ options, its version is printed before exiting.

Running _vmbinstallpkg_ with either _-f_ or _--force-update_ options only has any effect if _HOOREX\_DB_ or _REPODIR_ has been set to some network location.
- in the _HOOREX\_DB_ case it will download and use the dependency database from the location specified and then exit.
While useful, it is generally not necessary to manually update the dependency database like this.
Each time _vmbinstallpkg_ is run, if the previously downloaded dependency database is found to be more than three days old, the remote version is checked to determine if it is any newer than the local version and, if so, the latest version is downloaded and used.
The interval between checks of the dependency database may be changed by setting the REPODATA_AGE_CHECK variable in the defaults file (`/etc/default/vmbinstallpkg`).
- in the _REPODIR_ case, it is the _PACKAGES.TXT_ file which is downloaded and used.
The default interval between checks of the _PACKAGES.TXT_ file is 1 day but can be changed by setting the
REPODIR_AGE_CHECK variable in the defaults file (`/etc/default/vmbinstallpkg`).

When using a networked repository as the source of packages to install,
the repo's _PACKAGES.TXT_ file is used to find the precise location of the package to be installed
(as well as locations of packages it depends on).
The downloaded packages are stored locally while awaiting confirmation via a user dialog screen that they are to be installed,
as in this example showing installation of _FreeCAD_ from the _slackdce_ repo at _https://slackware.uk/slackdce_

<div align="center">
!["Install FreeCAD"](install_FreeCAD.png)
</div>

After the user has OK'd which packages to install (or the user Cancels the transaction), any downloaded packages are removed from local storage.

### Remote repository considerations
Before specifying a remote package repository from which to download and install built packages (using _REPODIR_) it is worth considering how much the remote repository can be trusted.
Packages from unknown sites may contain malicious software detrimental to your system.

Also note that not all package repositories are guaranteed to contain packages for _all_ the SlackBuilds available at SlackBuilds.org
and it's unlikely that a particular repository will have packages for all machine architectures.

### Support
Problems, comments and questions should be directed to the [Issues](https://gitlab.com/vmbuilder/vmbinstallpkg/-/issues) section (create a new issue).
Alternatively, the perspective of other users may be useful e.g. [Linux Questions](https://www.linuxquestions.org/questions/slackware-14/%5Bannounce%5D-dependency-aware-sbo-package-installer-and-remover-4175752397/)


### Contributing
Merge Requests to fix bugs are welcome at [Merge requests](https://gitlab.com/vmbuilder/vmbinstallpkg/-/merge_requests). Major feature additions are probably best discussed first in the [Issues](https://gitlab.com/vmbuilder/vmbinstallpkg/-/issues) section.

### License
_vmbinstallpkg_ is released under a modified 2 clause BSD license similar to that under which SBo build scripts are licensed i.e. it only has a single clause.
