
// fXNgbvp 308x94 (SUPPORT_SOFTKBD == 0 / PC-9801-119)

static const UINT8 np2kbd_bmp[3217] = {
		0xbe,0x39,0x00,0x06,0x05,0x42,0x4d,0xbe,0x39,0x00,0x00,0x04,0x76,
		0x00,0xc2,0x41,0x28,0x00,0xc2,0x34,0x01,0x00,0x00,0x5e,0x01,0xc2,
		0x16,0x01,0x00,0x04,0x05,0xc4,0x48,0x07,0xc6,0x00,0x03,0x10,0xa0,
		0x00,0xc2,0x08,0x00,0xc2,0x30,0x30,0x30,0x00,0x52,0x00,0x52,0x52,
		0x00,0x7b,0x7b,0x7b,0x00,0x94,0x00,0x94,0x94,0x00,0xa5,0xad,0xad,
		0x00,0xb5,0x00,0xb5,0xb5,0x00,0xe7,0xe7,0xe7,0x00,0xff,0x23,0xff,
		0xff,0x07,0xc4,0x11,0x88,0x11,0x0e,0x09,0x00,0x0e,0x78,0x77,0x00,
		0x3f,0x00,0x3f,0x00,0x18,0x26,0xc8,0x76,0x31,0x11,0x93,0x00,0x02,
		0x13,0x56,0x01,0x8d,0x33,0x21,0x01,0xc3,0x02,0x42,0x35,0x35,0x64,
		0x02,0x46,0x00,0x23,0x14,0x0d,0xca,0x63,0x01,0xc4,0xa0,0x01,0x88,
		0x33,0x06,0x47,0x11,0x33,0x33,0x35,0x77,0x5c,0x77,0x15,0x45,0x45,
		0x01,0x8d,0x0a,0xc6,0x26,0xc9,0x73,0x35,0x49,0x66,0x00,0x02,0x63,
		0x43,0x01,0x8d,0x64,0x46,0x01,0xc3,0x02,0x66,0x66,0x53,0x65,0x44,
		0x67,0x3c,0x29,0x74,0x4a,0x53,0x0d,0xc9,0x33,0x56,0x01,0xc3,0x34,
		0x01,0x86,0x36,0x40,0x66,0x06,0x47,0x65,0x36,0x66,0x65,0x57,0x77,
		0xb5,0x15,0x45,0x45,0x01,0x8d,0x0a,0xc6,0x57,0x26,0xc8,0x71,0x0c,
		0x85,0x48,0x31,0x01,0x8c,0x33,0x63,0x01,0xc5,0x66,0x66,0x36,0x55,
		0x17,0x63,0x6b,0x43,0x0d,0xc9,0x16,0x01,0x84,0x63,0x01,0x86,0x32,
		0x36,0x66,0x06,0x48,0x02,0x02,0x47,0x77,0x15,0x45,0x74,0xdf,0x01,
		0x8d,0x0a,0xc6,0x47,0x26,0xff,0x26,0xff,0x26,0xff,0x26,0xff,0x26,
		0xc5,0x16,0x00,0x00,0x06,0x26,0xd3,0x70,0x20,0x02,0x26,0xe1,0x00,
		0x11,0x60,0x06,0x00,0x25,0x02,0x60,0x60,0x00,0x01,0x82,0x4a,0x60,
		0x03,0x42,0x06,0x06,0x26,0xc2,0x06,0x05,0x42,0x06,0x51,0x06,0x26,
		0xf1,0x60,0x0d,0xc6,0x16,0x66,0x06,0x25,0x42,0xb5,0x26,0xc2,0x06,
		0x00,0x42,0x26,0xc7,0x06,0x26,0xc9,0x07,0x00,0x42,0xad,0x25,0x03,
		0x07,0x26,0xcb,0x60,0x26,0xcf,0x13,0x44,0x31,0x12,0x82,0x3d,0x60,
		0x60,0x26,0xc3,0x26,0x82,0x26,0xc4,0x02,0x02,0x00,0x4d,0xf2,0xd7,
		0x10,0x03,0x0d,0xc3,0x16,0x15,0x82,0x06,0x26,0xc4,0x03,0x82,0x26,
		0xc6,0x6f,0x60,0x06,0x02,0x26,0xcf,0x70,0x26,0xc5,0x51,0x43,0x58,
		0xc3,0x26,0xd0,0xeb,0x25,0x03,0x4d,0xc7,0x01,0x42,0x00,0x26,0xc3,
		0x00,0x02,0x04,0x74,0xf2,0xff,0x0d,0x82,0x0d,0xc3,0x4d,0xc9,0x24,
		0x42,0x26,0xc6,0x2b,0x02,0x26,0xd0,0x76,0x86,0xbf,0x26,0xc5,0x60,
		0x58,0xc3,0x74,0xcc,0x11,0x02,0x26,0xc2,0x4d,0xc6,0x3b,0x84,0xff,
		0x74,0xc5,0x12,0x83,0x4d,0xf4,0x74,0xc4,0x4d,0xc7,0x9b,0xcb,0x74,
		0xd2,0x9b,0xce,0xff,0x26,0xce,0x4d,0x83,0x9b,0xca,0x12,0xc2,0x26,
		0xc5,0x02,0x42,0x74,0xf3,0x0d,0xc6,0xff,0x4d,0xc8,0x26,0xd6,0xc2,
		0xd6,0x26,0xce,0xe9,0xff,0xe9,0xde,0x01,0x84,0xe9,0xd1,0xdd,0x25,
		0x0b,0x26,0xd8,0x56,0x25,0x05,0x01,0x8c,0x26,0xca,0x26,0x26,0xf6,
		0x76,0x15,0x22,0x05,0x01,0x86,0x26,0xca,0x54,0x26,0xc3,0x15,0x45,
		0x74,0xe4,0x01,0x8d,0x0a,0xc6,0x26,0xc9,0x74,0x36,0x04,0x03,0x64,
		0x24,0xa1,0x01,0x8d,0x64,0x28,0xc5,0x66,0x64,0x53,0x44,0x26,0xaa,
		0x2a,0x75,0x34,0x0d,0xc9,0x43,0x01,0xc4,0x42,0x01,0x86,0x46,0x53,
		0x66,0x06,0x47,0x66,0x29,0x82,0x77,0x77,0x15,0x45,0x17,0x06,0xd0,
		0x01,0x87,0x0a,0xc6,0x77,0x26,0xc8,0x77,0x41,0x13,0x33,0x08,0x33,
		0x32,0x12,0x67,0x01,0x8d,0x43,0x11,0x33,0x81,0x00,0x03,0x32,0x12,
		0x36,0x74,0x12,0x44,0x00,0x27,0x32,0x43,0x13,0x0d,0xcb,0x02,0x43,
		0x21,0x26,0x01,0x87,0x33,0x6d,0x33,0x06,0x45,0x01,0x83,0x36,0x44,
		0x42,0x15,0x43,0x31,0x17,0x05,0xeb,0x01,0x89,0x0a,0xc5,0x26,0xc3,
		0x63,0x11,0x03,0x11,0x00,0x05,0x24,0x42,0x0b,0x33,0x35,0x64,0x21,
		0x02,0x83,0x45,0x01,0xbf,0x01,0x85,0xf6,0x17,0x42,0x02,0x04,0x00,
		0x02,0x16,0x82,0x63,0x02,0x04,0x01,0x87,0x77,0x7a,0x77,0x0c,0x95,
		0x07,0x46,0x26,0xc2,0x6f,0x83,0x44,0x5a,0x06,0x53,0x8b,0x00,0xc2,
		0x65,0x44,0x67,0x51,0xc3,0x45,0x01,0xbf,0x01,0x85,0x08,0x36,0x66,
		0x64,0x46,0x16,0xc5,0x65,0x36,0x66,0x29,0x65,0x33,0x74,0x44,0x34,
		0x01,0x86,0x57,0x77,0x0c,0x94,0xf3,0x07,0x47,0x26,0xc6,0x97,0x84,
		0x81,0x45,0x66,0x66,0xcf,0x14,0x01,0xb7,0xfe,0xe6,0x4d,0xed,0x4d,
		0xe9,0xda,0xc2,0xc6,0x26,0xff,0x26,0xff,0x26,0xee,0x00,0x2d,0x00,
		0x07,0x0a,0x43,0x07,0x00,0x42,0x01,0x82,0x70,0xcb,0xc2,0xbf,0x0d,
		0xc3,0x07,0x01,0x84,0xcf,0x43,0x06,0xc9,0x01,0x86,0x26,0xfa,0x15,
		0x47,0xc0,0x1a,0x89,0x26,0xcf,0x60,0x00,0x60,0x60,0x60,0x66,0x73,
		0x06,0x26,0xc6,0x0b,0xc2,0x1f,0xd1,0x70,0x70,0x05,0x12,0x26,0xc7,
		0xf2,0x18,0x45,0x25,0x06,0x0f,0x86,0x26,0xc8,0x00,0x06,0x00,0x02,
		0x60,0xbf,0x26,0xc6,0x60,0x26,0xc5,0x01,0x83,0x26,0xca,0x16,0xc2,
		0x13,0x88,0x4d,0xd0,0xfb,0x26,0xcc,0x0a,0x46,0x23,0x48,0x03,0x4d,
		0x25,0x05,0x70,0x26,0xcc,0x06,0xc5,0x7a,0x77,0x54,0xc5,0x0f,0x86,
		0x42,0xc4,0x26,0xc3,0x60,0x26,0xcb,0x06,0xb9,0x4d,0xc6,0x06,0x26,
		0xcc,0x37,0x08,0x26,0xc4,0x00,0x00,0x07,0x43,0xde,0x4d,0xc9,0x27,
		0x02,0x06,0x26,0xc7,0x0c,0x0d,0x51,0x4d,0x74,0xc7,0x07,0xfb,0x26,
		0xcc,0x7d,0x86,0x7f,0x4c,0x4d,0xc9,0x4e,0x02,0x00,0x26,0xc6,0x1a,
		0x02,0xff,0x26,0xc3,0x01,0x84,0x26,0xcb,0x37,0x06,0x01,0x83,0x74,
		0xd0,0x00,0x03,0x4d,0xc8,0xef,0x0a,0x46,0x4d,0xcd,0x71,0x4d,0x00,
		0x03,0x46,0x28,0x85,0x9a,0x0e,0x1a,0x06,0xff,0x26,0xc7,0x4d,0x83,
		0x4d,0xdf,0x86,0xca,0x4d,0xd1,0x26,0xc2,0x32,0xc2,0xe9,0xc7,0xdf,
		0x94,0xd2,0x01,0x94,0x00,0x76,0x85,0xc1,0x0f,0x05,0x09,0x9b,0xc7,
		0x1b,0x82,0xff,0x9b,0xd4,0x0f,0xc2,0x86,0xcf,0xe9,0xf2,0x74,0xce,
		0xe9,0xff,0xc2,0xce,0x15,0x45,0xcb,0x1e,0x04,0x26,0xd6,0x65,0x46,
		0x01,0x02,0x26,0x15,0x45,0x01,0xbf,0xa1,0x26,0xc7,0x62,0x26,0xc7,
		0x54,0x66,0x66,0x15,0x1d,0x85,0x9e,0x01,0x86,0x47,0x77,0x0c,0x94,
		0x07,0x47,0x26,0xc2,0x23,0x83,0x45,0x8b,0x36,0x89,0x66,0x63,0x44,
		0x08,0x84,0x53,0x01,0xbf,0x01,0x85,0x09,0x46,0x66,0x64,0x56,0x64,
		0xc8,0x63,0x43,0x02,0x04,0x4e,0x42,0x01,0x86,0x77,0x77,0x0c,0x94,
		0x07,0x47,0x26,0xc2,0x74,0x06,0x33,0x33,0x33,0x31,0x13,0x01,0x02,
		0x01,0x86,0x36,0x03,0x74,0x12,0x44,0x44,0x44,0x31,0x01,0xbf,0x01,
		0x87,0x19,0x33,0x33,0x11,0x16,0xc4,0x01,0x83,0x36,0x74,0x02,0xc3,
		0x3e,0x21,0x26,0x01,0x86,0x48,0xc2,0x0c,0x94,0x07,0x46,0x26,0xc2,
		0x63,0x52,0x11,0x00,0x03,0x35,0x01,0x86,0x64,0x21,0x01,0x83,0x45,
		0xc8,0x01,0xbf,0x01,0x8c,0x63,0x31,0x16,0xc4,0x11,0x12,0x35,0x71,
		0x63,0x1d,0x02,0x02,0xc5,0x1f,0xc2,0x35,0x77,0x77,0x0b,0x95,0xd4,
		0x22,0x45,0x26,0xc3,0x33,0x5c,0xc4,0x34,0x01,0x86,0x44,0x67,0xb4,
		0x55,0xc3,0x45,0x01,0xbf,0x01,0x8c,0x35,0xb3,0x86,0x64,0x45,0x18,
		0x36,0x66,0x64,0x90,0x83,0xb6,0x43,0x36,0x66,0x65,0x37,0x57,0x77,
		0x0b,0x94,0x22,0x46,0x57,0x26,0xc2,0xce,0xcd,0xdc,0xdb,0xaf,0x01,
		0xb7,0x33,0xc3,0x47,0x36,0xed,0x4d,0xe9,0xc4,0x0b,0x91,0xe9,0xca,
		0xec,0x26,0xff,0x26,0xff,0x26,0xeb,0x07,0x00,0x42,0x09,0x82,0x70,
		0x00,0xef,0x0b,0x44,0x08,0x02,0x01,0x83,0x07,0x0e,0xc5,0x05,0x06,
		0x08,0x8d,0x03,0x46,0x3b,0x00,0x00,0x01,0x84,0x0a,0x83,0x26,0xeb,
		0x70,0x16,0x0b,0x01,0x84,0x80,0x26,0xcb,0x00,0x60,0x60,0x60,0x00,
		0x63,0x16,0x07,0x00,0x06,0x00,0x60,0x06,0x26,0xc9,0x01,0x8f,0x21,
		0x8b,0xf7,0x01,0x8e,0x17,0x85,0x08,0x86,0x1b,0x06,0x77,0x1b,0x06,
		0x2a,0x43,0x26,0xd0,0x7e,0x06,0x26,0xc9,0x34,0x46,0x14,0x4b,0x26,
		0xc2,0x08,0x02,0x26,0xc5,0x06,0x00,0x60,0x60,0x06,0x06,0x63,0x16,
		0x06,0x00,0x3f,0x00,0x66,0x26,0xc3,0x3f,0xc7,0x26,0xe1,0x08,0x87,
		0x4a,0x45,0x26,0xc7,0xfd,0x25,0x05,0x01,0x87,0x26,0xdf,0x36,0x06,
		0x1b,0x4b,0x26,0xce,0x00,0x26,0xc3,0xff,0x27,0x02,0x4d,0xca,0x6c,
		0x0f,0x03,0x45,0x41,0xc2,0x6f,0x8a,0x06,0xc6,0x2d,0xc7,0xcf,0x9b,
		0xd3,0x26,0xd3,0x06,0x06,0x1e,0xc3,0x26,0xda,0x22,0x02,0x26,0xc9,
		0xde,0x73,0x02,0x26,0xc3,0x60,0x9b,0xca,0x4a,0x4f,0x1f,0xcb,0x4d,
		0xfe,0x60,0x5e,0x00,0x4d,0xc9,0x70,0x26,0xc5,0x3e,0xc6,0x9b,0xc7,
		0x4d,0xc8,0x00,0xcf,0x00,0x02,0x26,0xc2,0x00,0x00,0x4f,0x83,0x9b,
		0xeb,0x26,0xc7,0x9b,0xcd,0xff,0x26,0xcc,0x9b,0xc8,0x71,0x83,0x74,
		0xd3,0x26,0xc6,0xda,0xc7,0xe9,0xc6,0x26,0xc8,0xff,0xe9,0xce,0xcc,
		0x8b,0x34,0x08,0x71,0x46,0x7a,0x0d,0xa4,0x94,0x74,0xce,0xe9,0xc6,
		0x7d,0x60,0x26,0xcc,0xe9,0xcb,0x17,0xcc,0x03,0x44,0xe9,0xca,0x15,
		0x02,0x85,0xbf,0x01,0x86,0x26,0x13,0x85,0x01,0xbf,0x01,0x8c,0x26,
		0xc2,0xda,0x03,0x26,0xcd,0x7a,0x54,0x26,0xc3,0x0b,0x94,0x22,0x46,
		0x26,0xc3,0x43,0x02,0x84,0x42,0xac,0x01,0x86,0x44,0x07,0xc4,0x53,
		0x01,0xbf,0x01,0x8c,0x33,0x66,0x41,0x60,0x72,0x05,0x36,0x16,0x66,
		0x64,0x56,0x9e,0xc7,0x0e,0x66,0x63,0x77,0x77,0x0b,0x94,0x22,0x46,
		0x6c,0x83,0x74,0x02,0x11,0x33,0x33,0x33,0x21,0x26,0x01,0x87,0x12,
		0x06,0x44,0x44,0x44,0x31,0x36,0x01,0xbf,0x01,0x8b,0x35,0x88,0x1b,
		0x02,0x06,0x00,0x06,0x27,0xc2,0x36,0x44,0x33,0x77,0x33,0x19,0x83,
		0x00,0x02,0x01,0x82,0x36,0x48,0xc2,0x0d,0x54,0x22,0x45,0x84,0x26,
		0xc3,0x63,0x33,0x21,0x11,0x00,0x04,0x13,0x33,0x2c,0x35,0x64,0x02,
		0x84,0x45,0x01,0xbf,0x01,0x8c,0x63,0x34,0xa1,0x71,0xc2,0x60,0x26,
		0x82,0x06,0x66,0x36,0x33,0x1a,0x04,0x27,0x35,0x63,0x01,0x85,0x77,
		0x77,0x0c,0x15,0x07,0x46,0x26,0xc2,0x10,0x36,0x64,0x46,0x59,0x45,
		0x53,0x66,0x65,0x44,0x5c,0x67,0x55,0x43,0x45,0x01,0xbf,0x01,0x8c,
		0x98,0xc5,0x06,0x66,0x52,0x06,0x26,0xc2,0x23,0x74,0x44,0x34,0x33,
		0x01,0x85,0x57,0x79,0x77,0x0c,0x14,0x07,0x47,0x26,0xc3,0xa7,0x88,
		0x36,0x66,0xd9,0x94,0xff,0x01,0xbe,0xbf,0xc7,0x26,0xc3,0xe0,0x86,
		0xe2,0x47,0xe9,0xc3,0x0c,0x11,0xe9,0xca,0xc8,0x26,0xff,0x26,0xec,
		0x60,0x00,0x50,0x42,0x63,0x16,0x00,0x62,0x60,0x00,0x02,0x26,0xf0,
		0x70,0x00,0x07,0x09,0x03,0x70,0x56,0x70,0x0a,0xc4,0x00,0x03,0x45,
		0x07,0x00,0x42,0x0e,0x43,0x07,0xcf,0x10,0x05,0x01,0x85,0x70,0x00,
		0x03,0x52,0x03,0x02,0x06,0xcb,0x26,0xd1,0x00,0x60,0x66,0x00,0x06,
		0x63,0x16,0x06,0x06,0x1b,0x00,0x00,0x00,0x26,0xc5,0x0f,0x8c,0x70,
		0x03,0x43,0x26,0xcd,0xed,0xa9,0xc2,0xd2,0x02,0x26,0xc4,0x07,0x07,
		0x82,0x18,0xc3,0x07,0x25,0x06,0xff,0x1c,0x45,0x2a,0x45,0x26,0xcd,
		0x2c,0x0d,0x03,0x46,0x0c,0x07,0x0f,0x85,0x1a,0x84,0xa7,0x26,0xcf,
		0x06,0x26,0xc4,0x06,0x00,0x4d,0xc6,0x13,0x0d,0x1a,0x03,0x77,0x16,
		0x08,0x82,0x57,0x02,0x26,0xc8,0x00,0x03,0x83,0x26,0xc4,0x25,0x06,
		0xff,0x26,0xcc,0x09,0x42,0x26,0xe6,0x0a,0x46,0x26,0xc7,0x4d,0xcb,
		0x3f,0x03,0x4d,0xc7,0x3c,0x00,0x60,0x26,0xc8,0x3d,0x85,0x0f,0x86,
		0x4f,0x84,0x16,0x66,0xff,0x7e,0x42,0x4d,0xcd,0x74,0xc5,0x3f,0xc8,
		0x1a,0x8c,0x21,0x8c,0x7b,0xc6,0x4d,0xd6,0xff,0x4c,0x06,0x26,0xd1,
		0x8d,0x03,0xc2,0xd2,0x13,0x05,0x84,0x88,0x0d,0xc2,0x07,0x42,0x7f,
		0x06,0x26,0xcd,0x4d,0xc7,0x18,0xcc,0x68,0x87,0x26,0xef,0x05,0x43,
		0x26,0xd4,0xbf,0x99,0xc3,0x00,0x74,0xc2,0x01,0x84,0xc2,0xc5,0x1b,
		0xcd,0x26,0xc4,0x4d,0xcb,0x3f,0x00,0x06,0x5a,0x83,0x26,0xe7,0x21,
		0x8e,0x05,0x13,0x4f,0x88,0x26,0xcf,0xff,0xe8,0x02,0x9b,0xc3,0x01,
		0x85,0x26,0xd8,0x9b,0xcb,0xe9,0xcc,0x8f,0x8d,0x76,0x8b,0xff,0xed,
		0x4d,0x53,0x0e,0x08,0x87,0xe9,0xd8,0x4d,0xc6,0x26,0xc4,0x01,0x85,
		0x26,0xc3,0xf8,0x14,0xc6,0xe9,0xc7,0x9b,0xc5,0xe9,0xcb,0x00,0x05,
		0x65,0x46,0x66,0x7b,0x26,0x13,0x85,0x01,0xbf,0x01,0x8c,0x26,0xcb,
		0x15,0x72,0x82,0x25,0x02,0x94,0x01,0x86,0x47,0x77,0x0c,0x14,0x15,
		0x26,0xc9,0x46,0x64,0x42,0x56,0x0e,0x45,0x63,0x66,0x63,0x44,0x07,
		0x44,0x53,0xd9,0x01,0xbf,0x01,0x8c,0x46,0x3d,0x03,0x3f,0x05,0x43,
		0x43,0x01,0xc4,0x4e,0x42,0x01,0x86,0x77,0x77,0x0c,0x14,0x07,0x47,
		0x26,0xc2,0x74,0x10,0x33,0x11,0x33,0x00,0x03,0x31,0x13,0x33,0x36,
		0x03,0x74,0x12,0x44,0x44,0x44,0x31,0x01,0xbf,0x01,0x8e,0x08,0x33,
		0x33,0x21,0x23,0x18,0x44,0x11,0x36,0x74,0x9f,0x1a,0x83,0x21,0x26,
		0x01,0x86,0x48,0xc2,0x0c,0x14,0x07,0x46,0x26,0xc2,0x22,0x63,0x11,
		0x00,0x04,0x13,0x56,0x42,0x01,0x83,0x14,0xd6,0x01,0xbf,0x01,0x94,
		0x31,0x18,0xc5,0x35,0x1a,0xc5,0x01,0x87,0x77,0xf4,0x1e,0xc6,0x05,
		0x8e,0x07,0x47,0x26,0xc2,0x33,0x74,0x85,0x63,0x44,0x59,0x46,0x7b,
		0x44,0x54,0x01,0xbf,0x01,0x92,0x53,0x35,0x75,0x05,0x6f,0x34,0x1a,
		0xc5,0x01,0x87,0x57,0x1e,0xc6,0x05,0x8e,0x07,0x47,0x26,0xc2,0x89,
		0xc5,0x85,0x66,0x66,0x31,0x7b,0x44,0x77,0x41,0x01,0xbf,0xdf,0x01,
		0x93,0x18,0x86,0x63,0xe0,0x86,0xe2,0x47,0x1e,0xc6,0x05,0x8e,0xe9,
		0xca,0xcd,0x26,0xff,0x26,0xfc,0x60,0x06,0xec,0x03,0x26,0xe3,0x70,
		0x13,0x84,0x67,0x70,0x05,0x02,0x15,0x43,0x00,0x07,0x17,0x05,0x01,
		0x85,0x03,0x46,0xfe,0x01,0x86,0x0a,0x45,0x05,0x08,0x03,0x4c,0x26,
		0xcd,0x0a,0x44,0x26,0xd9,0x66,0x27,0x06,0x00,0x4d,0xdb,0x60,0x00,
		0x00,0x43,0x26,0xc9,0x23,0x03,0xff,0x28,0x83,0x03,0x83,0x2a,0x48,
		0x03,0x47,0x01,0x85,0x31,0x47,0x03,0x46,0x2f,0x85,0xd8,0x03,0x48,
		0x26,0xd3,0x00,0x48,0x02,0x1d,0x82,0x60,0x60,0x66,0x27,0x00,0x00,
		0x01,0x82,0x06,0x00,0x01,0x82,0x26,0xc5,0x4d,0xc3,0xd3,0x03,0x83,
		0x26,0xca,0x06,0x26,0xc9,0x66,0x66,0x0c,0x82,0x26,0xca,0xff,0x01,
		0x86,0x23,0x47,0x43,0x46,0x26,0xcc,0x23,0x4d,0x4c,0x05,0x26,0xcd,
		0x36,0x8c,0x71,0x66,0x20,0x82,0x1c,0x42,0x26,0xc3,0x60,0x06,0x60,
		0x01,0x83,0x33,0x06,0x60,0x74,0xc6,0x4d,0xc4,0x06,0x06,0x20,0x42,
		0x26,0xc9,0xff,0x23,0x42,0x4d,0xcb,0x26,0xcb,0x23,0x47,0x1c,0x46,
		0x26,0xd9,0x25,0x0d,0x5a,0x0d,0x3f,0x77,0x07,0x7f,0x4a,0x4d,0xc2,
		0x4e,0x42,0x26,0xc4,0x48,0x82,0x01,0x83,0xeb,0x49,0xc3,0xc2,0xc9,
		0x4d,0x82,0x60,0x9d,0x83,0x00,0x09,0x04,0x32,0x42,0xfb,0x4d,0xc9,
		0x00,0x43,0x26,0xcb,0x6d,0xcb,0x18,0xc6,0x70,0x21,0x86,0x94,0xc7,
		0xff,0x23,0x4c,0x2d,0xce,0x5f,0x4b,0x4d,0xc9,0x1b,0xc3,0x74,0xc4,
		0x28,0x85,0x4d,0xc5,0xff,0x7a,0x42,0x2a,0xc3,0x4d,0xc3,0x53,0x82,
		0x9b,0xc8,0x23,0x82,0x9b,0xcf,0xb4,0xc5,0xff,0x46,0xce,0x26,0xc6,
		0x1c,0x46,0xa2,0xc5,0x26,0xd4,0xc2,0xd5,0x0f,0x84,0x9b,0xd3,0xff,
		0x26,0xc5,0x74,0xc2,0x9b,0xc5,0x4d,0xc4,0xc2,0xc8,0x0a,0xc2,0xe9,
		0xd4,0x6a,0x47,0xbf,0x66,0xc6,0x70,0x03,0x5a,0xef,0x0d,0x25,0x0d,
		0x9d,0x8b,0xe9,0xd8,0x4d,0x83,0xd2,0x2a,0xc2,0xe9,0xd7,0x15,0x0e,
		0x06,0x32,0x67,0x13,0x84,0x42,0xce,0x01,0xbf,0x01,0x92,0x41,0x56,
		0x26,0xc6,0x1a,0xc5,0x01,0x87,0x47,0x2e,0x77,0x15,0x26,0x83,0x00,
		0x05,0x8e,0x07,0x47,0x26,0xc2,0x43,0x89,0x0d,0xc5,0x64,0x24,0x47,
		0x11,0x83,0x75,0x34,0x01,0xbf,0xad,0x01,0x93,0x36,0x18,0xc5,0x42,
		0x1a,0xc5,0x01,0x87,0x77,0x1e,0xc6,0xe2,0x05,0x8e,0x07,0x47,0x26,
		0xc2,0x74,0x11,0x33,0x00,0x02,0x32,0x00,0x12,0x67,0x41,0x24,0x44,
		0x44,0x43,0x13,0xd3,0x01,0xbf,0x01,0x95,0x13,0x18,0xc3,0x21,0x26,
		0x1a,0xc4,0x01,0x88,0x7f,0x77,0x1e,0xc5,0x05,0x8f,0x07,0x47,0x8d,
		0xc3,0x00,0x3f,0x00,0x3f,0x00,0x17,0xe4,0x26,0xff,0x00,0x3f,0x26,
		0xde,0x63,0x11,0x00,0x03,0x35,0x77,0x26,0x76,0x31,0x01,0xc3,0x13,
		0x57,0x05,0x42,0x04,0x85,0x11,0x3f,0x13,0x56,0x04,0x84,0x07,0x02,
		0x04,0x18,0x0b,0x42,0x0b,0x3f,0x0b,0x18,0xa1,0x26,0xc2,0x33,0xd1,
		0x04,0x34,0x57,0x73,0x35,0xc7,0x84,0x63,0x45,0x26,0xc2,0x04,0x85,
		0x66,0x63,0x43,0x04,0x84,0x07,0x02,0xfa,0x04,0x18,0x0b,0x42,0x0b,
		0x3f,0x0b,0x18,0x26,0xc2,0x16,0xec,0x86,0x71,0xe2,0x07,0x06,0x26,
		0xc2,0x04,0x85,0x66,0x66,0x31,0x01,0xc6,0x63,0xff,0x04,0x18,0x0b,
		0x42,0x0b,0x3f,0x0b,0x18,0x26,0xff,0x26,0xff,0x26,0xff,0x1b,0xbf,
		0x84,0x26,0xfb,0x00,0x60,0x60,0x00,0x26,0xc3,0x60,0x00,0x13,0x00,
		0x06,0x60,0x26,0xc6,0x60,0x66,0x00,0x83,0x0c,0x02,0x33,0x06,0x66,
		0x07,0x03,0x04,0x04,0x00,0x06,0x04,0x05,0x02,0xc2,0xed,0x04,0x08,
		0x1b,0x84,0x06,0xcb,0x06,0x0b,0x0e,0x0f,0x48,0x06,0x0b,0x06,0xc7,
		0x01,0xc2,0x05,0x82,0x31,0x66,0x60,0x09,0x04,0x06,0xc2,0x04,0x02,
		0xdb,0x09,0x02,0x04,0x05,0x66,0x04,0x09,0x26,0xc5,0x60,0x00,0x02,
		0x26,0xc4,0x3f,0x60,0x60,0x26,0xd4,0x33,0x04,0x0e,0x04,0x1b,0x8e,
		0x02,0xc2,0x26,0xc7,0xfe,0x13,0xc2,0x26,0xcd,0x04,0x08,0x32,0x08,
		0x16,0x84,0x1b,0x02,0x26,0xc6,0x06,0x6f,0x00,0x0b,0x05,0x04,0x04,
		0x60,0x04,0x06,0x2b,0x03,0x04,0x06,0x4d,0xc8,0x39,0x60,0x00,0x26,
		0xc5,0x10,0x05,0x1b,0x82,0x00,0x06,0x29,0x82,0xff,0x33,0x03,0x04,
		0x42,0x22,0x84,0x04,0x0a,0x32,0x43,0x04,0x04,0x13,0x02,0x26,0xc4,
		0xff,0x02,0x85,0x0b,0x05,0x06,0xc8,0x46,0xc4,0x64,0x85,0x04,0x05,
		0x26,0xc7,0x02,0x02,0xf7,0x26,0xc5,0x14,0x42,0x22,0x84,0x04,0x0a,
		0x06,0x04,0x06,0x27,0x82,0x26,0xc5,0x67,0x06,0x4e,0x03,0x4d,0xc6,
		0x06,0x06,0x4d,0xc8,0x1b,0x84,0x3e,0x4b,0xff,0x4d,0xc8,0x04,0x07,
		0x06,0xc2,0x4d,0xc8,0x0b,0x0f,0x4d,0xc7,0x0b,0x08,0x26,0xc6,0xff,
		0x04,0xc4,0x06,0xc4,0x70,0x87,0x0d,0x45,0x04,0x05,0x26,0xc3,0x6a,
		0xc6,0x4d,0xc6,0xff,0x00,0x03,0x9b,0xc5,0x2e,0x82,0xc2,0xc6,0x07,
		0xc4,0x0c,0x04,0x3e,0x45,0x04,0x02,0xff,0x90,0x85,0x04,0x02,0x1b,
		0x84,0x04,0x05,0x1b,0x8f,0x0b,0x11,0x04,0x07,0x9b,0xc7,0xff,0x32,
		0x45,0xbe,0x83,0x09,0x03,0x06,0xc3,0x09,0x04,0x04,0x05,0x26,0xc5,
		0x04,0x04,0xeb,0xe9,0xff,0xe9,0xff,0xe9,0xe0,0x15,0x26,0xc7,0x56,
		0x26,0xc8,0x04,0x85,0xcf,0x0c,0x02,0x04,0x85,0x66,0x63,0x04,0x18,
		0x0b,0x42,0x0b,0x3f,0x0b,0x18,0xa1,0x26,0xc2,0x43,0x02,0x84,0x42,
		0x77,0x74,0x36,0x01,0xc3,0x31,0x64,0x27,0x26,0xc2,0x04,0x85,0x66,
		0x64,0x24,0x04,0x84,0xfc,0x07,0x02,0x04,0x18,0x0b,0x42,0x0b,0x3f,
		0x0b,0x18,0x26,0xc2,0x74,0x11,0x00,0x33,0x33,0x33,0x21,0x26,0x77,
		0x77,0x41,0x03,0x13,0x33,0x33,0x32,0x12,0x67,0x26,0xc2,0x04,0x84,
		0xff,0x02,0xc3,0x04,0x83,0x07,0x03,0x04,0x19,0x0b,0x3f,0x0b,0x1a,
		0x26,0xc2,0x00,0x3f,0xc0,0x00,0x3f,0x00,0x18,0x00,0x00,0x75,0x44,
		0x46,0x00,0x07,0x77,0x54,0x44,0x60,0x07,0x12,0xbf,0x00,0x3f,0x26,
		0xd2,0x00,0x74,0x53,0x24,0x00,0x77,0x45,0x26,0x40,0xe0,0x26,0xff,
		0x00,0x3f,0x26,0xd4,0x75,0x64,0x00,0x77,0x46,0x70,0x37,0x26,0xff,
		0x00,0x3f,0x26,0xd4,0x73,0x44,0x45,0x00,0x0e,0x77,0x34,0x43,0x50,
		0x26,0xff,0x00,0x3f,0x26,0xd3,0x76,0x01,0x44,0x47,0x00,0x77,0x64,
		0x44,0x70,0x26,0xff,0xfe,0x00,0x3f,0x26,0xd3,0x01,0x03,0x00,0xc2,
		0x26,0xff,0x00,0x3f,0x26,0xd4};


typedef struct {
	UINT8	left;
	UINT8	keys;
	UINT8	left1;
	UINT8	left2;
	UINT8	base;
	UINT8	right;
} FULLKEY;

typedef struct {
	FULLKEY	fk[4];
	UINT8	cur0[5];
	UINT8	cur1[5];
	UINT8	ten[20];
} KEYTBL;

static const KEYTBL keytbl = {
		// fullkey 4
		   {{17, 13, 0x00, 0x00, 0x01, 0x0e},
			{24, 12, 0x0f, 0x0f, 0x10, 0x1c},
			{28, 12, 0x74, 0xf1, 0x1d, 0x1c},
			{34, 11, 0x70, 0x70, 0x29, 0x7d}},

		// 220
		   {0x38, 0x36, 0x3a, 0x3b, 0x3d},
		   {0x39, 0x37, 0x3a, 0x3c, 0x3d},

		// 252
		   {0x3e, 0x3f, 0x40, 0x41,
			0x42, 0x43, 0x44, 0x45,
			0x46, 0x47, 0x48, 0x49,
			0x4a, 0x4b, 0x4c, 0x4d,
			0x4e, 0x4f, 0x50, 0x1c}};


static UINT getsoftkbd(int x, int y) {

	UINT		posy;
const FULLKEY	*fk;

	if ((y >= (2 + 4)) && (y < (16 + 4))) {
		x -= 2;
		if (x < 0) {
			return(SOFTKEY_NC);
		}
		if (x < (21 - 4)) {
			return((x < 14)?0x60:SOFTKEY_NC);
		}
		x -= (21 - 4);
		if (x < (42 - 21)) {
			return((x < 14)?0x61:SOFTKEY_NC);
		}
		x -= (42 - 21);
		if (x < (132 - 42)) {
			x /= 17;
			return((x < 5)?(0x62 + x):SOFTKEY_NC);
		}
		x -= (132 - 42);
		if (x < (222 - 132)) {
			x /= 17;
			return((x < 5)?(0x67 + x):SOFTKEY_NC);
		}
		x -= (222 - 132);
		x /= 17;
		return((x < 5)?(0x52 + x):SOFTKEY_NC);
	}
	x -= 2;
	posy = (y - (18 + 4)) / 14;
	if ((posy >= 5) || (x < 0)) {
		return(SOFTKEY_NC);
	}
	if (x < (220 - 4)) {			// fullkey
		if (posy < 4) {
			fk = keytbl.fk + posy;
			x -= fk->left;
			if (x < -14) {
				return(fk->left1);
			}
			else if (x < 0) {
				return(fk->left2);
			}
			x /= 14;
			if (x < (int)fk->keys) {
				return(fk->base + x);
			}
			return(fk->right);
		}
		else {
			x -= (17 - 4);
			if (x < 0) {
				return(SOFTKEY_NC);
			}
			x -= 14;
			if (x < 0) {
				return(0xf2);
			}
			x -= 14;
			if (x < 0) {
				return(0x77);
			}
			x -= 14;
			if (x < 0) {
				return(0x73);
			}
			x -= 21;
			if (x < 0) {
				return(0x51);
			}
			x -= 91;
			if (x < 0) {
				return(0x34);
			}
			x -= 21;
			if (x < 0) {
				return(0x35);
			}
			x -= 14;
			if (x < 0) {
				return(0x78);
			}
			if (x < 14) {
				return(0x79);
			}
		}
		return(SOFTKEY_NC);
	}
	x -= (220 - 4);
	if (x < (252 - 220)) {			// cur
		if (x < 14) {
			return(keytbl.cur0[posy]);
		}
		else if (x < 28) {
			return(keytbl.cur1[posy]);
		}
		return(SOFTKEY_NC);
	}
	x -= (252 - 220);
	if (x < 14*5) {					// ten key
		x = x / 14;
		return(keytbl.ten[x + posy * 4]);
	}
	return(SOFTKEY_NC);
}

static void ledpaint(CMNVRAM *vram) {

	UINT	col;

	col = (softkbd.led & 4)?9:8;
	cmndraw_fill(vram, 6, 0, 2, 6, softkbd.pal[col]);
	col = (softkbd.led & 8)?9:8;
	cmndraw_fill(vram, 15, 0, 2, 6, softkbd.pal[col]);
}

