/**
 * @file	WndProc.h
 * @brief	vV[W NX̐錾уC^[tFCX̒`܂
 */

#pragma once

#include <map>
#include "WndBase.h"

/**
 * @brief vV[W NX
 */
class CWndProc : public CWndBase
{
public:
	static void Initialize(HINSTANCE hInstance);
	static void Deinitialize();
	static HINSTANCE GetInstanceHandle();
	static void SetResourceHandle(HINSTANCE hInstance);
	static HINSTANCE GetResourceHandle();
	static HINSTANCE FindResourceHandle(LPCTSTR lpszName, LPCTSTR lpszType);

	CWndProc();
	virtual ~CWndProc();

	operator HWND() const;
	HWND GetSafeHwnd() const;
	static CWndProc* FromHandlePermanent(HWND hWnd);
	BOOL Attach(HWND hWndNew);
	HWND Detach();

	virtual void PreSubclassWindow();
	BOOL SubclassWindow(HWND hWnd);
	BOOL SubclassDlgItem(UINT nID, CWndProc* pParent);
	HWND UnsubclassWindow();

	BOOL CreateEx(DWORD dwExStyle, LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, int x, int y, int nWidth, int nHeight, HWND hwndParent, HMENU nIDorHMenu, LPVOID lpParam = NULL);
	virtual BOOL DestroyWindow();
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);

protected:
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
	virtual BOOL OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult);
	virtual void OnNcDestroy(WPARAM wParam, LPARAM lParam);
	virtual LRESULT WindowProc(UINT nMsg, WPARAM wParam, LPARAM lParam);
	LRESULT DefWindowProc(UINT nMsg, WPARAM wParam, LPARAM lParam);
	virtual void PostNcDestroy();

protected:
	static HINSTANCE sm_hInstance;		//!< CX^X nh
	static HINSTANCE sm_hResource;		//!< \[X nh
	static LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

	static void HookWindowCreate(CWndProc* pWnd);
	static bool UnhookWindowCreate();

private:
	static DWORD sm_dwThreadId;						//!< ̃Xbh ID
	static HHOOK sm_hHookOldCbtFilter;				//!< tbN tB^[
	static CWndProc* sm_pWndInit;					//!< ̃CX^X
	static std::map<HWND, CWndProc*>* sm_pWndMap;	//!< EBhE }bv
	WNDPROC m_pfnSuper;								//!< ʃvV[W
	static LRESULT CALLBACK CbtFilterHook(int nCode, WPARAM wParam, LPARAM lParam);
};

/**
 * CX^X nh擾
 * @return CX^X nh
 */
inline HINSTANCE CWndProc::GetInstanceHandle()
{
	return sm_hInstance;
}

/**
 * \[X nhݒ
 * @param[in] hInstance \[X nh
 */
inline void CWndProc::SetResourceHandle(HINSTANCE hInstance)
{
	sm_hResource = hInstance;
}

/**
 * \[X nh擾
 * @return \[X nh
 */
inline HINSTANCE CWndProc::GetResourceHandle()
{
	return sm_hResource;
}

/**
 * HWND Iy[^
 * @return HWND
 */
inline CWndProc::operator HWND() const
{
	return m_hWnd;
}

/**
 * EBhẼEBhE nhԂ܂
 * @return EBhE nh
 */
inline HWND CWndProc::GetSafeHwnd() const
{
	return (this != NULL) ? m_hWnd : NULL;
}

